<?PHP
/**** Sevas On family Types ****/
// 0 - Pooja on Sri Swamiji's name
// 1 - Pooja on Sri Datta Vijayananda Teertha Swamiji's name
// 2 - Pooja on all Family Members
// 3 - Pooja on selected Family Members
// 4 - Donation on Sri Swamiji's name
// 5 - Donation on Sri Datta Vijayananda Teertha Swamiji's name
// 6 - Donation on all Family Members
// 7 - Donation on selected Family Members
// 8 - Pooja on Friends / Others
// 9 - Donation on Friends / Others
// 10 - Subscription on selected Family Member
// 11 - Subscription on Sri Swamiji's name
// 12 - Subscription on Sri Datta Vijayananda Teertha Swamiji's name
// 13 - Donation on Appji Member
// 14 - Subscription on Appji Member
/**** Sevas On family Types ****/
class Orders_Model extends CI_Model 
{
	var $tableName="orders";
	var $payment_success_statuses ="";
	var $archivesDb = "";
	var $s_orders_data_table = "";
	var $auth_check = "";
	var $searchAliasNames = [
								"email" => "Email ID",
								"order_number" => "Seva ID",
								"username" => "User ID",
								"phone" => "Phone",
								"firstname" => "First Name",
								"lastname" => "Last Name",
								"order_number" => "Seva ID",
								"transaction_id" => "Tx ID",
								"t.tx" => "Tx ID",
								"t.note" => "Note",
								"t.order_id" => "Seva ID",
								"t.firstname" => "First name",
								"t.lastname" => "Last name",
								"t.email" => "Email ID",
								"t.phone" => "Phone",
								"t.city" => "City",
								"t.state" => "State",
								"o.order_number" => "Seva ID",
								"o.email" => "Email ID",
								"o.username" => "User ID",
								"o.phone" => "Phone",
								"o.firstname" => "First Name",
								"o.lastname" => "Last Name",
								"appji_member_name" => "Appji Member Name",
								"appji_member_email" => "Appji Member Email",
							];




	public function __construct()
	{
		parent::__construct();
		$year_table = date("Y");
		$this->s_orders_data_table="orders_archives_".$year_table;
		$this->archivesDb = $this->load->database("data_archives",true,false);
		$this->auth_check = $this->load->database("sso_auth",true,false);
		$this->payment_success_statuses = array('success','Success','approved','completed','captured','paid','Release Payment');
		if ($this->archivesDb->table_exists($this->s_orders_data_table) )
		{

		}
		else
		{
		  	// table does not exist
		  	$new_table = "CREATE TABLE IF NOT EXISTS `".$this->s_orders_data_table."` (
			  		`id` int(11) NOT NULL AUTO_INCREMENT,
				  	`date` datetime NOT NULL,
				  	`data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
				  	`order_id` int(11) NOT NULL,
				  	PRIMARY KEY (`id`)
					) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
			$this->archivesDb->query($new_table);
		}
	}
	public function orderRowById($id)
	{
		$this->db->select("id,user_id,order_number,partial_payments_allowed,order_type,subscription_mixed_order,date,transaction_id,total_price,paid,total_paid,currency,status,created_by,ashram_id,ashram_name,ashram_alias_name,payment_status
		,payment_mode,payment_alt_mode,is_cancelled,trust_name,trust_address,trust_id,donation_type,tokens,ip_address,no_paid_transactions,partially_refunded
		,dispatched,app,is_manual_payment,dispatch_status,cancel_reason,cancelled_on,isd_code,phone,email,refund_failed_count,partially_refunded,total_refunded_amount,refund_failed_count,total_replaced_amount,fully_refunded,is_appji_order,country,dispatch_status,firstname,lastname,price_in_words,address1,address2,address3,city,state,country_name,donation_initials");
		$this->db->where("id",$id);
		$this->db->from($this->tableName);
		$q=$this->db->get();
		$result=$q->row();
		return $result;
	}
	public function orderItemsByOrderId($id)
	{
		$this->db->select("*,oi.id as id,oi.id as order_item_id,p.id as pet_id");
		$this->db->where("order_id",$id);
		$this->db->from("order_items as oi");
		$this->db->join("pets as p","p.id=oi.pet_id","left");
		$items=$this->db->get();
		$result=$items->result();
		return $result;
	}
	public function orderLogByOrderId($id)
	{
		$this->db->where("order_id",$id);
		$items=$this->db->get("order_log");
		$result=$items->result();
		return $result;
	}
	public function orderFilesByOrderId($id)
	{
		$result = [];
		$this->db->where("order_id",$id);
		$items=$this->db->get("order_items_files");
		if($items->num_rows())
		{
			$result['order_items_files']=$items->result();
			foreach ($result['order_items_files'] as $fileData)
			{
				$this->db->where("file_id",$fileData->id);
				$tempD=$this->db->get("order_items_downloads")->result();
				$result['order_items_downloads'][$fileData->id]=$tempD;
			}
		}
		return $result;
	}
	public function orderItemsByItemId($id)
	{
		$this->db->select("oi.item_id,o.firstname,o.middlename,o.lastname,oi.schedule_dates");
		$this->db->where("item_id",$id);
		$this->db->from("order_items as oi");
		$this->db->join($this->tableName." as o","o.id=oi.order_id","left");
		$items=$this->db->get();
		$result=$items->result();
		return $result;
	}
	public function orderItemsByItemIdAndDate($id,$month,$year)
	{
		$this->db->select("oi.item_id,oi.family_member_details,oi.schedule_dates,oid.id,oid.order_id,oid.order_item_id,oid.date");
		$this->db->where("item_id",$id);
		//$this->db->where("DATE_FORMAT(STR_TO_DATE(schedule_dates,'%d %b %Y'),'%Y-%m')='$year-$month'");
		$this->db->where("MONTH(oid.date)",$month);
		$this->db->where("YEAR(oid.date)",$year);
		$this->db->from("order_items as oi");
		$this->db->join("order_items_dates as oid","oid.order_item_id=oi.id","left");
		$this->db->group_by('oi.schedule_dates');
		$items=$this->db->get();
		$result=$items->result();
		//echo $this->db->last_query();
		return $result;
	}
	public function orderItemsByItemIdAndSignleDate($id,$date)
	{
		$this->db->select("oi.item_id,oi.family_member_details,oi.schedule_dates,oid.id,oid.order_id,oid.order_item_id,oid.date");
		$this->db->where("item_id",$id);
		//$this->db->where("DATE_FORMAT(STR_TO_DATE(schedule_dates,'%d %b %Y'),'%Y-%m')='$year-$month'");
		$this->db->where("date(oid.date)",$date);
		$this->db->where("date(oid.date)",$date);
		$this->db->from("order_items as oi");
		$this->db->join("order_items_dates as oid","oid.order_item_id=oi.id","left");
		// $this->db->group_by('oi.schedule_dates');
		$items=$this->db->get();
		$result=$items->result();
		// echo $this->db->last_query();
		return $result;
	}
	public function orderItemsByItemIdAfterCurrDate($id)
	{
		$date = date('Y-m-d');
		$this->db->select("oi.item_id,oi.schedule_dates");
		$this->db->where("item_id",$id);
		$this->db->where("DATE_FORMAT(STR_TO_DATE(schedule_dates,'%d %b %Y'),'%Y-%m-%d')>'$date'");
		$this->db->from("order_items as oi");
		$items=$this->db->get();
		$result=$items->result();
		return $result;
	}
	public function orderData($id)
	{
		$this->db->select("id,user_id,partial_payments_allowed,order_number,order_type,subscription_mixed_order,date,transaction_id,total_price,paid,total_paid,currency,status,created_by,ashram_id,ashram_name,ashram_alias_name,payment_status
		,payment_mode,payment_alt_mode,is_cancelled,trust_name,trust_address,trust_id,donation_type,tokens,ip_address,no_paid_transactions,partially_refunded,zipcode
		,dispatched,country,dispatch_note,order_pan_number,cancel_reason,cancelled_on,order_aadhaar_number,order_tin_number,order_passport_number,order_voter_epic_number,order_driving_license_number,order_ration_card_number,original_total_price,order_total_price,is_manual_payment,donation_initials,isd_code,tax_80g_501c3,firstname,middlename,lastname,dispatch_status,email,address1,address2,address3,partially_refunded,total_refunded_amount,refund_failed_count,total_replaced_amount,fully_refunded,is_appji_order,phone,address1,address2,address3,city,state,country,username,preferred_name,old_data,country_name,pan_or_aadhaar");
		$this->db->from($this->tableName);
		$this->db->where("id",$id);
		$q=$this->db->get();
		$result['order']=$q->row();
		$result['order_items']=array();
		$result['order_items_files']=array();
		if($q->num_rows())
		{
			$this->db->select("oi.order_id,oi.order_type,oi.item_id,oi.quantity,oi.updated_quantity,oi.item_name,oi.price,oi.pet_id,oi.transaction_ids,oi.refunded_transaction_ids,oi.paid_count,oi.refunded_counts,oi.paid_amount,
			oi.schedule_dates,oi.assign_pet,oi.donor_id,oi.subscription,oi.options,oi.subscription_id,oi.num_of_payments,oi.frequency,oi.pay_till_cancel,oi.status,oi.gift_friend_name,oi.gift_friend_email,oi.personal_note,oi.have_personal_note,oi.family_members,
			oi.appji_member_name,oi.appji_member_email,oi.family_member_details,oi.onetime_charge,oi.shipping,oi.shipping_price,oi.shipping_address1,oi.shipping_address2,oi.shipping_address3,oi.shipping_city,oi.shipping_state,oi.shipping_country_name,oi.shipping_country,oi.payment_mode,
			oi.period,oi.pitru_paksha_pooja,oi.pooja_on_swamiji,oi.pooja_on_teertha_swamiji,oi.pitru_paksha_deceased_person_name,oi.is_poornaphala_seva,oi.poornaphala_tie_by,oi.poornaphala_ids,oi.poornaphala_end_dates,oi.refunded_amount,
			oi.friend_or_other_1,oi.friend_or_other_2,oi.friend_or_other_3,oi.friend_or_other_4,oi.friend_or_other_5,oi.friend_or_other_6,oi.friend_or_other_7,oi.friend_or_other_8,oi.friend_or_other_9,oi.friend_or_other_10,oi.attend_pooja_in_person,oi.id as id,oi.id as order_item_id,p.id as pet_id,is_from_appji,link_token");
			$this->db->where("order_id",$id);
			$this->db->from("order_items as oi");
			$this->db->join("pets as p","p.id=oi.pet_id","left");
			$items=$this->db->get();
			$result['order_items']=$items->result();

			$this->db->where("order_id",$id);
			$items=$this->db->get("order_log");
			$result['order_log']=$items->result();

			$this->db->where("order_id",$id);
			$items=$this->db->get("order_items_files");
			if($items->num_rows())
			{
				$result['order_items_files']=$items->result();
				foreach ($result['order_items_files'] as $fileData)
				{
					$this->db->where("file_id",$fileData->id);
					$tempD=$this->db->get("order_items_downloads")->result();
					$result['order_items_downloads'][$fileData->id]=$tempD;
				}
			}

			$this->db->where("order_id",$id);
			$payflow_card=$this->db->get("subscription_profiles_payflow")->row();
			
			$this->db->where("order_id",$id);
			$stripe_card=$this->db->get("stripe_subscriptions_payment_details")->row();
			$result['payflow_card']=$payflow_card;
			$result['stripe_card']=$stripe_card;
		}
		return $result;
	}

	public function orderDataTemp($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->get("orders_temp");
		$result['order']=$q->row();
		$result['order_items']=array();
		$result['order_items_files']=array();
		if($q->num_rows())
		{
			$this->db->select("*,oi.id as id,oi.id as order_item_id,p.id as pet_id");
			$this->db->where("order_id",$id);
			$this->db->from("order_items_temp as oi");
			$this->db->join("pets as p","p.id=oi.pet_id","left");
			$items=$this->db->get();
			$result['order_items']=$items->result();
			$this->db->where("order_id",$id);
			$payflow_card=$this->db->get("subscription_profiles_payflow")->row();
			$result['payflow_card']=$payflow_card;
		}
		return $result;
	}

	public function orderDataByTx($tx)
	{
		$this->db->where("transaction_id",$tx);
		$q=$this->db->get($this->tableName);
		$result['order']=$q->row();
		if($q->num_rows())
		{
			$this->db->where("order_id",$result['order']->id);
			$items=$this->db->get("order_items");
			$result['order_items']=$items->result();
		}
		return $result;
	}

	public function itemData($orderItemId,$orderId=0)
	{
		$this->db->where("id",$orderItemId);
		if($orderId)
			$this->db->where("order_id",$orderId);
		$q=$this->db->get("order_items");
		return $q->row();
	}

	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->db->where('ashram_id',$this->currentUser->ashram_id);
		}
		return $this->db->get($this->tableName)->num_rows();
	}
	public function getPoojasCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->db->where('ashram_id',$this->currentUser->ashram_id);
		}
		$this->db->where("order_type",1);
		return $this->db->get($this->tableName)->num_rows();
	}
	public function getDonationsCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->db->where('ashram_id',$this->currentUser->ashram_id);
		}
		$this->db->where("order_type",2);
		return $this->db->get($this->tableName)->num_rows();
	}
	public function getStoreItemsCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->db->where('ashram_id',$this->currentUser->ashram_id);
		}
		$this->db->where("order_type",3);
		return $this->db->get($this->tableName)->num_rows();
	}
	public function getDonationSubscriptionItemsCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->db->where('ashram_id',$this->currentUser->ashram_id);
		}
		$this->db->where("order_type",2);
		return $this->db->get($this->tableName)->num_rows();
	}

	public function listAdmin($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}	
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(o.id) as c,sum(o.total_price) as total_sum,currency");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,date,o.user_id,o.username,o.transaction_id,o.total_price,o.original_total_price,o.order_total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_mode,o.payment_status,o.is_cancelled,o.tokens,o.dispatched,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,
			o.email,o.firstname,o.lastname,o.phone,o.country,o.created_by,o.declaration_type,o.app,usr.pan_number as pan_number");
		}
		if($excel==1)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,date,o.username,o.user_id,o.transaction_id,o.total_price,o.paid,o.status,o.currency,o.payment_mode,o.payment_status,o.partial_payments_allowed,
			o.paid_tx_ids,o.address1,o.address2,o.address3,o.city,o.state,o.email,o.firstname,o.lastname,o.phone,o.created_by,o.refunded_tx_ids,o.country,o.zipcode,o.total_paid,o.no_paid_transactions,o.paid_tx_ids,
			o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.tokens,o.dispatch_status,o.app,usr.pan_number as pan_number");
		}
		$query1->where("o.order_number !=",NULL);
		$query1->from($this->tableName." as o");

		if($i==2 || $excel==1)
		{
			$query1->join("users as usr",'usr.id=o.user_id');
		}

		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
			$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nSource: ";
		if(isset($_POST['app']) && is_numeric($_POST['app']) && in_array($_POST['app'],array(0,1)))
		{
			$query1->where("o.app",$_POST['app']);
			if($_POST['app']==1)
				$preData.="App";
			else
				$preData.="Website";
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && is_numeric($_POST['payment_status']) && in_array($_POST['payment_status'],array(0,1,2)))
		{
			$query1->where("o.payment_status",$_POST['payment_status']);
			if($_POST['payment_status']==1)
				$preData.="Paid";
			else if($_POST['payment_status']==0)
				$preData.="Pending";
			else if($_POST['payment_status']==1)
				$preData.="Partially Paid";
		}

		$preData.="\nPayment Mode: ";
		if(isset($_POST['payment_type']) && is_numeric($_POST['payment_type']) && in_array($_POST['payment_type'],array(0,1)))
		{
			if($_POST['payment_type']==1)
			{
				$query1->where_in("o.payment_alt_mode",array("paypal","payu","razorpay","stripe","authorize.net"));
				$preData.="Online";
			}
			else
			{
				$query1->where("o.payment_alt_mode",'cash');
				$preData.="Offline";
			}
		}

		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->where("o.payment_alt_mode",$_POST['payment_mode']);
			if($_POST['payment_mode'] == 'cash')
			{
				$preData.='Offline';
			}
			else
			{
				$preData.=$_POST['payment_mode'];
			}
		}

		$preData.="\nNo Tx Sevas:";
		if(isset($_POST['no_tx_orders']) && $_POST['no_tx_orders'] != "" && in_array($_POST['no_tx_orders'],array("Yes","No")))
		{
			$query1->where("o.no_paid_transactions",$_POST['no_tx_orders']);
			$preData.=" No Tx Sevas";
		}
		else
		{
			$preData.=" All Sevas";
		}

		$preData.="\nCancelled Sevas:";
		if(isset($_POST['cancelled_orders']) && $_POST['cancelled_orders'] != "" && in_array($_POST['cancelled_orders'],array(0,1)))
		{
			$query1->where("o.is_cancelled",$_POST['cancelled_orders']);
			if($_POST['cancelled_orders']==0)
			{
				$preData.= 'Non Cancelled Sevas';
			}
			if($_POST['cancelled_orders']==1)
			{
				$preData.= 'Cancelled Sevas';
			}
		}
		else
		{
			$preData.=" All Sevas";
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(o.date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(o.date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_POST['amount_condition']) && $_POST['amount_condition']!='') && (isset($_POST['search_amount']) && $_POST['search_amount']!='') )
		{
			$query1->where("o.total_price".$_POST['amount_condition'],$_POST['search_amount']);
			$preData.="\nAmount: ".$_POST['amount_condition']." ".$_POST['search_amount'];
		}

		$preData.="\nToken Status:";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			if($_POST['tokens']==0)
			{
				$query1->where("o.tokens",0);
				$preData.="Tokens not issued";
			}
			else
			{
				$query1->where("o.tokens",1);
				$preData.="Tokens issued";
			}
		}
		else
		{
			$preData.=" All Token Status";
		}

		$preData.="\nShipping Status:";
		if(isset($_POST['dispatched']) && is_numeric($_POST['dispatched']) && in_array($_POST['dispatched'],array(0,1,2,3)))
		{
			$query1->where("o.dispatch_status",$_POST['dispatched']);
			if($_POST['dispatched']==0)
			{
				$preData.="N/A";
			}
			else if($_POST['dispatched']==1)
			{
				$preData.="Pending";
			}
			else if($_POST['dispatched']==2)
			{
				$preData.="Completed";
			}
			else if($_POST['dispatched']==3)
			{
				$preData.="Returned";
			}
		}

		$preData.="\nCreated By:";
		if(isset($_POST['created_by']) && is_numeric($_POST['created_by']) && in_array($_POST['created_by'],array(0,1,2)))
		{
			if($_POST['created_by']==0)
			{
				$query1->where("o.created_by",0);
				$preData.=" Guest";
			}
			else if($_POST['created_by']==1)
			{
				$query1->where("o.created_by",1);
				$preData.=" Admin";
			}
			else
			{
				$query1->where("o.created_by",2);
				$preData.=" User";
			}
		}
		else
		{
			$preData.=" All";
		}

		$preData.="\nSeva Type:";
		if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3,4)))
		{
			if($_POST['order_type']==1)
			{
				$query1->where("o.order_type",1);
				$preData.=" Poojas";
			}
			else if($_POST['order_type']==2)
			{
				$query1->where("o.order_type",2);
				$preData.=" Donations";
			}
			else if($_POST['order_type']==4)
			{
				$query1->group_start();
				$query1->where("o.order_type",4);
				$query1->or_where("o.subscription_mixed_order",1);
				$query1->group_end();
				$preData.=" Subscriptions";
			}
			else
			{
				$query1->where("o.order_type",3);
				$preData.=" Store";
			}
		}
		else
		{
			$preData.=" All";
		}


		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			if(isset($_POST['pagenum']) && $_POST['pagenum']==13)
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Sevas - Tally report",$preData,$_POST['pagenum']);
			}
			else
			{
				$requestResp=$this->excel_exports_model->makeRequest('default',"model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Sevas",$preData);
			}
			return $requestResp;
		}


		if($i==1)
		{
			$query1->group_by("currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by('o.'.$col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		/*echo $query1->last_query();
		exit;*/

		$c=0;
		$sno=$start+1;
		$ids=array();
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$ids[]=$row['id'];
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function listAdminCancelledOrders($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}	
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(o.id) as c,sum(o.total_price) as total_sum,currency");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("o.*, usr.pan_number as pan_number");
		}
		$query1->where("o.order_number !=",NULL);
		$query1->where("o.is_cancelled ",1);
		$query1->from($this->tableName." as o");

		if($i==2 || $excel==1)
		{
			$query1->join("users as usr",'usr.id=o.user_id');
		}

		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}
				$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->where("o.payment_alt_mode",$_POST['payment_mode']);
			if($_POST['payment_mode'] == 'cash')
			{
				$preData.='Offline';
			}
			else
			{
				$preData.=$_POST['payment_mode'];
			}
		}

		$preData.="\nNo Tx Sevas:";
		if(isset($_POST['no_tx_orders']) && $_POST['no_tx_orders'] != "" && in_array($_POST['no_tx_orders'],array("Yes","No")))
		{
			$query1->where("o.no_paid_transactions",$_POST['no_tx_orders']);
			$preData.=" No Paid Tx Sevas";
		}
		else
		{
			$preData.=" All Sevas";
		}

		$preData.="\nCancelled Sevas:";
		if(isset($_POST['cancelled_orders']) && $_POST['cancelled_orders'] != "" && in_array($_POST['cancelled_orders'],array(0,1)))
		{
			$query1->where("o.is_cancelled",$_POST['cancelled_orders']);
			$preData.= $_POST['cancelled_orders'];
		}
		else
		{
			$preData.=" All Sevas";
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(o.cancelled_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(o.cancelled_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$preData.="\nSeva Type:";
		if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3,4)))
		{
			if($_POST['order_type']==1)
			{
				$query1->where("o.order_type",1);
				$preData.=" Poojas";
			}
			else if($_POST['order_type']==2)
			{
				$query1->where("o.order_type",2);
				$preData.=" Donations";
			}
			else if($_POST['order_type']==4)
			{
				$query1->group_start();
				$query1->where("o.order_type",4);
				$query1->or_where("o.subscription_mixed_order",1);
				$query1->group_end();
				$preData.=" Subscriptions";
			}
			else
			{
				$query1->where("o.order_type",3);
				$preData.=" Store";
			}
		}
		else
		{
			$preData.=" All";
		}


		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('cancelled_on',$_POST['dir']);
				else
					$query1->order_by('cancelled_on',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Sevas",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$query1->group_by("currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by('o.'.$col_name,$dir);
			else
				$query1->order_by('o.cancelled_on',$dir);
		}
		else
		{
			$query1->order_by('o.cancelled_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		$ids=array();
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['cancelled_on']=date("d M Y",strtotime($rtn['data'][$c]['cancelled_on']));
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$ids[]=$row['id'];
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function listAdminPoojas($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		if($this->session->userdata("ashramId"))
		{
			$poojas=$this->poojas_model->getByAshramId($this->session->userdata("ashramId"));
			$poojasArray=array();
			foreach ($poojas as $poojaData)
			{
				$poojasArray[$poojaData->id]=$poojaData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		if($this->session->userdata("pooja_categoryId"))
		{
			$categoryData = $this->poojas_categories_model->categoryData($this->session->userdata("pooja_categoryId"));
		}
		$preData='';
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,date,o.user_id,o.username,o.transaction_id,o.total_price,o.original_total_price,o.order_total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_status,o.is_cancelled,o.tokens,o.dispatched,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.address1,o.address2,o.address3,
			o.email,o.firstname,o.lastname,o.phone,o.country,o.created_by,o.declaration_type,o.app,o.id as oid,o.paid_tx_ids, o.refunded_tx_ids, o.failed_tx_ids, o.cancelled_tx_ids, o.inprocess_tx_ids,o.city,o.state,o.country,o.country_name,
			 o.bounced_tx_ids, o.payment_mode as payment_mode,oi.id,oi.poornaphala_ids,oi.quantity,oi.item_name,oi.donor_id,oi.schedule_dates,oi.item_name,oi.personal_note,oi.transaction_ids,oi.price,oi.family_member_details,usr.pan_number as pan_number");
		}
		if($excel==1)
		{
			if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
			{
				$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.username,o.user_id,o.transaction_id,o.total_price,o.paid,o.status,o.currency,o.payment_status,o.partial_payments_allowed,
				o.paid_tx_ids,o.address1,o.address2,o.address3,o.city,o.state,o.email,o.firstname,o.lastname,o.phone,o.created_by,o.refunded_tx_ids,o.country,o.zipcode,o.total_paid,o.no_paid_transactions,o.paid_tx_ids,
				o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.tokens,o.dispatch_status,o.app,o.id as oid, o.payment_mode as payment_mode,oi.family_member_details,oi.updated_quantity,oi.price,
				oi.id,oi.quantity,oi.item_name,oi.donor_id,oid.date as schedule_dates,oi.poornaphala_ids,oi.item_name,oi.personal_note,oi.transaction_ids,oi.is_poornaphala_seva,oi.poornaphala_end_dates,oi.poornaphala_tie_by,oi.attend_pooja_in_person,usr.pan_number as pan_number");
			}
			else
			{
				$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,date,o.username,o.user_id,o.transaction_id,o.total_price,o.paid,o.status,o.currency,o.payment_status,o.partial_payments_allowed,
				o.paid_tx_ids,o.address1,o.address2,o.address3,o.city,o.state,o.email,o.firstname,o.lastname,o.phone,o.created_by,o.refunded_tx_ids,o.country,o.zipcode,o.total_paid,o.no_paid_transactions,o.paid_tx_ids,
				o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.tokens,o.dispatch_status,o.app,o.id as oid, o.payment_mode as payment_mode,oi.family_member_details,oi.updated_quantity,oi.price,
				oi.id,oi.quantity,oi.item_name,oi.donor_id,oi.schedule_dates,oi.poornaphala_ids,oi.item_name,oi.personal_note,oi.transaction_ids,oi.is_poornaphala_seva,oi.poornaphala_end_dates,oi.poornaphala_tie_by,oi.attend_pooja_in_person,usr.pan_number as pan_number");
			}
		}
		$query1->where("payment_status!=",0);
		$query1->where("is_cancelled!=",1);
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nCategories: ";
		if($this->session->userdata("pooja_categoryId"))
		{
			$preData.="\nCategory: ";
			$query1->where("oi.category",$this->session->userdata("pooja_categoryId"));
			$preData.=$categoryData->name;
		}else{
			$preData.="All categories";
		}
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) &&  trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->like("o.payment_alt_mode",$_POST['payment_mode']);
			if($_POST['payment_mode'] == 'cash')
				$preData.='Offline';
			else
				$preData.=$_POST['payment_mode'];
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nPooja(s): ";
			if(isset($_POST['pooja_id']) && $_POST['pooja_id']!='')
			{
				if(is_array($_POST['pooja_id']))
				{
					if(empty(array_filter($_POST['pooja_id'])))
					{
						goto pooja_default;
					}
					$query1->where_in("item_id",$_POST['pooja_id']);
					$pii=0;
					foreach ($_POST['pooja_id'] as $pooja_id)
					{
						if($pii) $preData.=", ";
						$preData.=$poojasArray[$pooja_id]->pooja_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("item_id",$_POST['pooja_id']);
					$preData.=$poojasArray[$_POST['pooja_id']]->pooja_name;
				}
			}
			else
			{
				pooja_default:
				$preData.="All Poojas";
			}
		}

		$query1->where("o.order_type",1);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');

		if($i==2 || $excel==1)
		{
			$query1->join("users as usr",'usr.id=o.user_id');
		}

		
		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_POST['amount_condition']) && $_POST['amount_condition']!='') && (isset($_POST['search_amount']) && $_POST['search_amount']!='') )
		{
			$amountWhere = "IF(`oi`.`updated_quantity` > 0, (`oi`.`price`*`oi`.`updated_quantity`), (`oi`.`price`*`oi`.`quantity`)) ".$_POST['amount_condition']." '".$_POST['search_amount']."'";
			$query1->where($amountWhere);
			$preData.="\nAmount: ".$_POST['amount_condition']." ".$_POST['search_amount'];
		}

		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("o.tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && is_numeric($_POST['payment_status']) && in_array($_POST['payment_status'],array(0,1,2)))
		{
			$query1->where("o.payment_status",$_POST['payment_status']);
			if($_POST['payment_status']==1)
				$preData.="Paid";
			else if($_POST['payment_status']==0)
				$preData.="Pending";
			else if($_POST['payment_status']==1)
				$preData.="Partially Paid";
		}


		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
			{
				$datesfilter.=" where date(oid.date)>='".date("Y:m:d",strtotime($_POST['from_date'] ?? ''))."' ";
			}
			else
			{
				$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_POST['from_date'] ?? ''))."' ";
			}
			$fromDateTime=strtotime($_POST['from_date']);
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
			{
				$datesfilter.="date(oid.date)<='".date("Y:m:d",strtotime($_POST['to_date'] ?? ''))."'";
			}
			else
			{
				$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_POST['to_date'] ?? ''))."'";
			}
			$toDateTime=strtotime($_POST['to_date']);
			$preData.=$_POST['to_date'];
		}

		if((!isset($_POST['from_date']) || $_POST['from_date']=='') && (!isset($_POST['to_date']) || $_POST['to_date']==''))
		{
			$fromDateTime="0";
		}

		if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
		{
			$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by date";
		}
		else
		{
			$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";
		}

		$query1->where("oi.id in (".$sub_query.")");
		if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
		{
			$query1->join("order_items_dates as oid",'oid.order_id=o.id AND oid.order_item_id=oi.id');
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.'.$_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by('o.'.$_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.date',$_POST['dir']);
				else
					$query1->order_by('o.date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$pageNum=2;
			if(isset($_POST['pagenum']) && ($_POST['pagenum']==4 || $_POST['pagenum']==7 || $_POST['pagenum']==14))
				$pageNum=$_POST['pagenum'];

			if(isset($_POST['pagenum']) && $_POST['pagenum']==7)
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"Poojas - Seva Karta report",$preData,$pageNum);
			}
			else if(isset($_POST['pagenum']) && $_POST['pagenum']==14)
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Pooja Sevas By Date",$preData,$pageNum);
			}
			else
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Pooja Sevas",$preData,$pageNum);
			}
			return $requestResp;
		}

		if($i==1)
		{
			$query1->group_by("o.currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by('o.'.$col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['transaction_ids'];
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			// $rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".$rtn['data'][$c]['quantity'].")";
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$resultPoojaDates='';
			$poojaDates=array_filter(explode(",",$rtn['data'][$c]['schedule_dates']));
			$rDates=array();
			foreach ($poojaDates as $poojaDate)
			{
				$poojaDateTime=strtotime($poojaDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=", ";
						$resultPoojaDates.=$poojaDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=", ";
						$resultPoojaDates.=$poojaDate;
					}
				}
			}
			$result_dates=array_filter(explode(",",$resultPoojaDates));
			$rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".count($result_dates).")";
			if($row['quantity']>1)
			{
				$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];
				$sub_total_sum+=($row['price']*count($result_dates));

				$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
				$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*count($result_dates));
			}


			$rtn['data'][$c]['pooja_dates']=$resultPoojaDates;

			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
			$rtn['data'][$c]['family_details']=nl2br($row['family_member_details']);

			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;

			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	public function listAdminPoojasByDate($excel=0)
	{
		$excel = (!empty($excel)) ? $excel : 0;
		$countries=$this->locations_model->getCountries(true);

		if($this->session->userdata("ashramId"))
		{
			$poojas=$this->poojas_model->getByAshramId($this->session->userdata("ashramId"));
			$poojasArray=array();
			foreach ($poojas as $poojaData)
			{
				$poojasArray[$poojaData->id]=$poojaData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		if(isset($_POST['category_id']) && $_POST['category_id']!='')
		{
			$categoryData = $this->poojas_categories_model->categoriesData($_POST['category_id']);
		}
		$preData='';
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.user_id,o.username,o.transaction_id,o.total_price,o.original_total_price,o.order_total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_status,o.is_cancelled,o.tokens,o.dispatched,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.address1,o.address2,o.address3,
			o.email,o.firstname,o.lastname,o.phone,o.country,o.created_by,o.declaration_type,o.app,o.id as oid,o.paid_tx_ids, o.refunded_tx_ids, o.failed_tx_ids, o.cancelled_tx_ids, o.inprocess_tx_ids,o.city,o.state,o.country,o.country_name,
			 o.bounced_tx_ids, o.payment_mode as payment_mode, oi.id, oi.poornaphala_ids, oi.quantity, oi.item_name, oi.donor_id, oid.date as pooja_date, oi.item_name, oi.personal_note, oi.transaction_ids, oi.price, oi.family_member_details, order_pan_number");
		}
		if($excel==1)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.username,o.user_id,o.transaction_id,o.total_price,o.paid,o.status,o.currency,o.payment_status,o.partial_payments_allowed,
			o.paid_tx_ids,o.address1,o.address2,o.address3,o.city,o.state,o.email,o.firstname,o.lastname,o.phone,o.created_by,o.refunded_tx_ids,o.country,o.zipcode,o.total_paid,o.no_paid_transactions,o.paid_tx_ids,
			o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.tokens,o.dispatch_status,o.app,o.id as oid, o.payment_mode as payment_mode,oi.family_member_details,oi.updated_quantity,oi.price,
			oi.id,oi.quantity,oi.item_name,oi.donor_id,oid.date as pooja_date,oi.poornaphala_ids,oi.item_name,oi.personal_note,oi.transaction_ids,oi.is_poornaphala_seva,oi.poornaphala_end_dates,oi.poornaphala_tie_by,oi.attend_pooja_in_person,order_pan_number");
		}
		
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nCategories: ";
		if(isset($_POST['category_id']) && $_POST['category_id']!='')
		{
			if(is_array($_POST['category_id']))
			{
				if(empty(array_filter($_POST['category_id'])))
				{
					goto category_default;
				}
				$query1->where_in("oi.category",$_POST['category_id']);
				$pii=0;
				foreach ($categoryData as $category)
				{
					if($pii) $preData.=", ";
					$preData.=$category->name;
					$pii++;
				}
			}
			else
			{					
				$query1->where("oi.category",$_POST['category_id']);
				$preData.=$categoryData->name;
			}
		}
		else
		{
			category_default:
			$preData.="All categories";
		}
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) &&  trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->like("o.payment_alt_mode",$_POST['payment_mode']);
			if($_POST['payment_mode'] == 'cash')
				$preData.='Offline';
			else
				$preData.=$_POST['payment_mode'];
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nPooja(s): ";
			if(isset($_POST['pooja_id']) && $_POST['pooja_id']!='')
			{
				if(is_array($_POST['pooja_id']))
				{
					if(empty(array_filter($_POST['pooja_id'])))
					{
						goto pooja_default;
					}
					$query1->where_in("item_id",$_POST['pooja_id']);
					$pii=0;
					foreach ($_POST['pooja_id'] as $pooja_id)
					{
						if($pii) $preData.=", ";
						$preData.=$poojasArray[$pooja_id]->pooja_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("item_id",$_POST['pooja_id']);
					$preData.=$poojasArray[$_POST['pooja_id']]->pooja_name;
				}
			}
			else
			{
				pooja_default:
				$preData.="All Poojas";
			}
		}
		$query1->where("payment_status!=",0);
		$query1->where("is_cancelled!=",1);
		$query1->where("o.order_type",1);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$query1->join("order_items_dates as oid",'oid.order_item_id=oi.id');
		$query1->group_by("oid.id");

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency'] ?? '');
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_POST['amount_condition']) && $_POST['amount_condition']!='') && (isset($_POST['search_amount']) && $_POST['search_amount']!='') )
		{
			$amountWhere = "IF(`oi`.`updated_quantity` > 0, (`oi`.`price`*`oi`.`updated_quantity`), (`oi`.`price`*`oi`.`quantity`)) ".$_POST['amount_condition']." '".$_POST['search_amount']."'";
			$query1->where($amountWhere);
			$preData.="\nAmount: ".$_POST['amount_condition']." ".$_POST['search_amount'];
		}

		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("o.tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && is_numeric($_POST['payment_status']) && in_array($_POST['payment_status'],array(0,1,2)))
		{
			$query1->where("o.payment_status",$_POST['payment_status']);
			if($_POST['payment_status']==1)
				$preData.="Paid";
			else if($_POST['payment_status']==0)
				$preData.="Pending";
			else if($_POST['payment_status']==1)
				$preData.="Partially Paid";
		}


		$fromDateTime='';
		$toDateTime='';

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(oid.date) >=",date("Y:m:d",strtotime($_POST['from_date'] ?? '')));
			$fromDateTime=strtotime($_POST['from_date'] ?? '');
			$preData.=$_POST['from_date'];
		}
		else
		{
			if(!isset($_POST['to_date']) || $_POST['to_date']=='')
			{
				$fromDateTime=time();
				$query1->where("DATE(oid.date) >=",date("Y:m:d"));
				$preData.=date("d M Y");

			}
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(oid.date) <=",date("Y:m:d",strtotime($_POST['to_date'] ?? '')));
			$toDateTime=strtotime($_POST['to_date'] ?? '');
			$preData.=$_POST['to_date'];
		}
		else
		{
			if(!isset($_POST['from_date']) || $_POST['from_date']=='')
			{
				$query1->where("DATE(oid.date) <=",date("Y:m:d"));
				$toDateTime=time();
				$preData.=date("d M Y");
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.'.$_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by('o.'.$_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('oid.date',$_POST['dir']);
				else
					$query1->order_by('oid.date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Pooja Sevas By Date",$preData,14);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'] ?? '')]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency ?? '')]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by('o.'.$col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['transaction_ids'];
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date'] ?? ''));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'] ?? '')." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'] ?? '')." ".$rtn['data'][$c]['total_price'];
			$rtn['data'][$c]['family_details']='N/A';
			if($row['family_member_details']!='')
				$rtn['data'][$c]['family_details']=nl2br($row['family_member_details'] ?? '');
			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];
			$rtn['data'][$c]['address']=$address;
			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];
			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	private function orderTransactions($orderId,$totalPaid=0,$subscriptions_include=0)
	{
		$transactions=$this->transaction_model->getTransactionsByOrder($orderId,$subscriptions_include);
		$result='';
		$paid=0;
		foreach ($transactions as $tx)
		{
			if(abs($tx->amount)==0)
				continue;
			if(in_array(strtolower($tx->status),$this->payment_success_statuses))
			{
				if($result!='') $result.="<br>";
				$result.=$tx->tx." (".date("d M Y",strtotime($tx->created_on)).")";

				$paid+=abs($tx->amount);
			}
		}
		if($totalPaid==0)
			return $result;
		else
			return $paid;
	}

	public function listAdminDonations($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		if($this->session->userdata("ashramId"))
		{
			$donations=$this->donations_model->getByAshramId($this->session->userdata("ashramId"));
			$donationsArray=array();
			foreach ($donations as $donationData)
			{
				$donationsArray[$donationData->id]=$donationData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		//getting category Data
		if($this->session->userdata("donation_categoryId"))
		{
			$categoryData = $this->donations_categories_model->categoryData($this->session->userdata("donation_categoryId"));
		}
		//getting group Data
		if($this->session->userdata("groupId"))
		{
			$groupData = $this->donations_groups_model->groupData($this->session->userdata("groupId"));
		}
		$preData="";
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.user_id,o.username,o.transaction_id,o.total_price,o.original_total_price,o.order_total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_status,o.is_cancelled,o.tokens,o.dispatched,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.address1,o.address2,o.address3,
			o.email,o.firstname,o.lastname,o.phone,o.country,o.created_by,o.declaration_type,o.app,o.id as oid,o.paid_tx_ids, o.refunded_tx_ids, o.failed_tx_ids, o.cancelled_tx_ids, o.inprocess_tx_ids,o.city,o.state,o.country,o.country_name,
			 o.bounced_tx_ids, o.payment_mode as payment_mode,oi.id,oi.quantity,oi.item_name,oi.donor_id,oi.schedule_dates,oi.item_name,oi.personal_note,oi.transaction_ids,oi.price,oi.family_member_details,
			 oi.appji_member_name,oi.appji_member_email,oi.subscription,oi.item_id,usr.pan_number as pan_number");
		}
		if($excel==1)
		{
			if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
			{
				$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.username,o.user_id,o.transaction_id,o.total_price,o.paid,o.status,o.currency,o.payment_status,o.partial_payments_allowed,
				o.paid_tx_ids,o.address1,o.address2,o.address3,o.city,o.state,o.email,o.firstname,o.lastname,o.phone,o.created_by,o.refunded_tx_ids,o.country,o.zipcode,o.total_paid,o.no_paid_transactions,o.paid_tx_ids,
				o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.tokens,o.dispatch_status,o.app,o.id as oid, o.payment_mode as payment_mode,oi.family_member_details,oi.updated_quantity,oi.price,
				oi.id,oi.quantity,oi.item_name,oi.donor_id,oid.date schedule_dates,oi.item_name,oi.item_id,oi.subscription,oi.personal_note,oi.transaction_ids,oi.is_poornaphala_seva,oi.poornaphala_end_dates,oi.poornaphala_tie_by,usr.pan_number as pan_number");
			}
			else
			{
				$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.username,o.user_id,o.transaction_id,o.total_price,o.paid,o.status,o.currency,o.payment_status,o.partial_payments_allowed,
				o.paid_tx_ids,o.address1,o.address2,o.address3,o.city,o.state,o.email,o.firstname,o.lastname,o.phone,o.created_by,o.refunded_tx_ids,o.country,o.zipcode,o.total_paid,o.no_paid_transactions,o.paid_tx_ids,
				o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.tokens,o.dispatch_status,o.app,o.id as oid, o.payment_mode as payment_mode,oi.family_member_details,oi.updated_quantity,oi.price,
				oi.id,oi.quantity,oi.item_name,oi.donor_id,oi.schedule_dates,oi.item_name,oi.item_id,oi.subscription,oi.personal_note,oi.transaction_ids,oi.is_poornaphala_seva,oi.poornaphala_end_dates,oi.poornaphala_tie_by,usr.pan_number as pan_number");
			}
		}

		$query1->where("oi.subscription",0);
		$query1->where("is_cancelled!=",1);
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nCategories: ";
		if($this->session->userdata("donation_categoryId"))
		{
			$preData.="\nCategory: ";
			$query1->where("oi.category",$this->session->userdata("donation_categoryId"));
			$preData.=$categoryData->name;
		}else{
			$preData.="All categories";
		}
		$preData.="\nGroups: ";
		if($this->session->userdata("groupId"))
		{
			$preData.="\nGroup: ";
			$query1->where("d.group_id",$this->session->userdata("groupId"));
			$preData.=$groupData->name;
		}else{
			$preData.="All Groups";
		}
		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->like("o.payment_alt_mode",$_POST['payment_mode']);
			if($_POST['payment_mode'] == 'cash')
			{
				$preData.="Offline";
			} else {
				$preData.=$_POST['payment_mode'];
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nDonation(s): ";
			if(isset($_POST['donation_id']) && $_POST['donation_id']!='')
			{
				if(is_array($_POST['donation_id']))
				{
					
					if(empty(array_filter($_POST['donation_id'])))
					{
						goto donation_default;
					}
					$query1->where_in("item_id",$_POST['donation_id']);
					$pii=0;
					foreach ($_POST['donation_id'] as $donation_id)
					{
						if($pii) $preData.=", ";
						$preData.=$donationsArray[$donation_id]->donation_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("item_id",$_POST['donation_id']);
					$preData.=$donationsArray[$_POST['donation_id']]->donation_name;
				}
			}
			else
			{
				donation_default:
				$preData.="All Donations";
			}
		}
		
		$query1->where("o.order_type",2);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		if($this->session->userdata("groupId")) {
			$query1->join("donations as d",'oi.item_id = d.id');
			
		}

		if($i==2 || $excel==1)
		{
			$query1->join("users as usr",'usr.id=o.user_id');
		}
		$query1->where("payment_status!=",0);
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) &&  trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			
				if(in_array(trim($_POST['search_col']), ['appji_member_name','appji_member_email', 'personal_note']))
				{
					$query1->like('oi.'.$_POST['search_col'],trim($_POST['search_text']));
				}
				else
				{
					$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				}
				$preData.=" containing ";
			
			/* else if($_POST['wild']=='starts')
			{
				if(in_array(trim($_POST['search_col']), ['appji_member_name','appji_member_email', 'personal_note']))
				{
					$query1->like('oi.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				}
				else
				{
					$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				}
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				if(in_array(trim($_POST['search_col']), ['appji_member_name','appji_member_email', 'personal_note']))
				{
					$query1->like('oi.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				}
				else
				{
					$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				}
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}
		
		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_POST['amount_condition']) && $_POST['amount_condition']!='') && (isset($_POST['search_amount']) && $_POST['search_amount']!='') )
		{
			$amountWhere = "IF(`oi`.`updated_quantity` > 0, (`oi`.`price`*`oi`.`updated_quantity`), (`oi`.`price`*`oi`.`quantity`)) ".$_POST['amount_condition']." '".$_POST['search_amount']."'";
			$query1->where($amountWhere);
			$preData.="\nAmount: ".$_POST['amount_condition']." ".$_POST['search_amount'];
		}

		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("o.tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && is_numeric($_POST['payment_status']) && in_array($_POST['payment_status'],array(0,1,2)))
		{
			$query1->where("o.payment_status",$_POST['payment_status']);
			if($_POST['payment_status']==1)
				$preData.="Paid";
			else if($_POST['payment_status']==0)
				$preData.="Pending";
			else if($_POST['payment_status']==1)
				$preData.="Partially Paid";
		}


		$preData.="\nFrom Date: ";
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
			{
				$datesfilter.=" where date(oid.date)>='".date("Y:m:d",strtotime($_POST['from_date'] ?? ''))."' ";
			}
			else
			{
				$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_POST['from_date'] ?? ''))."' ";
			}
			$fromDateTime=strtotime($_POST['from_date']);
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
			{
				$datesfilter.="date(oid.date)<='".date("Y:m:d",strtotime($_POST['to_date'] ?? ''))."'";
			}
			else
			{
				$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_POST['to_date'] ?? ''))."'";
			}
			$toDateTime=strtotime($_POST['to_date']);
			$preData.=$_POST['to_date'];
		}

		if((!isset($_POST['from_date']) || $_POST['from_date']=='') && (!isset($_POST['to_date']) || $_POST['to_date']==''))
		{
			$fromDateTime="0";
		}
		
		if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
		{
			$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by date";
		}
		else
		{
			$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";
		}

		$query1->where("oi.id in (".$sub_query.")");
		if(isset($_POST['report_by_date']) && $_POST['report_by_date']==1)
		{
			$query1->join("order_items_dates as oid",'oid.order_id=o.id AND oid.order_item_id=oi.id');
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.'.$_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by('o.'.$_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.date',$_POST['dir']);
				else
					$query1->order_by('o.date',"desc");
			}
			$sql=$query1->get_compiled_select();

			if(isset($_POST['pagenum']) && $_POST['pagenum']==8)
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"Donations - Seva Karta report",$preData,8);
			}
			else if(isset($_POST['pagenum']) && $_POST['pagenum']==15)
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Donation Sevas By Date",$preData,15);
			}
			else
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Donation Sevas",$preData,3);
			}
			return $requestResp;
		}

		if($i==1)
		{
			$query1->group_by("o.currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by('o.'.$col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['transaction_ids'];
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			// $rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".$rtn['data'][$c]['quantity'].")";
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$resultDonationDates='';
			$donationDates=array_filter(explode(",",$rtn['data'][$c]['schedule_dates']));
			$rDates=array();
			foreach ($donationDates as $donationDate)
			{
				
				$poojaDateTime=strtotime($donationDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=", ";
						$resultDonationDates.=$donationDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=", ";
						$resultDonationDates.=$donationDate;
					}
				}
			}

			$result_dates=array_filter(explode(",",$resultDonationDates));
			$rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".count($result_dates).")";
			if($row['quantity']>1)
			{
				$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];
				$sub_total_sum+=($row['price']*count($result_dates));

				$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
				$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*count($result_dates));
			}

			$rtn['data'][$c]['donation_dates']=$resultDonationDates;

			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
			$rtn['data'][$c]['family_details']=nl2br($row['family_member_details']);

			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;

			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	public function listAdminDonationsByDate($excel=0)
	{
		$excel = (!empty($excel)) ? $excel : 0;
		$countries=$this->locations_model->getCountries(true);

		if($this->session->userdata("ashramId"))
		{
			$donations=$this->donations_model->getByAshramId($this->session->userdata("ashramId"));
			$donationsArray=array();
			foreach ($donations as $donationData)
			{
				$donationsArray[$donationData->id]=$donationData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		//getting category Data
		if(isset($_POST['category_id']) && $_POST['category_id']!='')
		{
			$categoryData = $this->donations_categories_model->categoriesData($_POST['category_id']);
		}
		//getting group Data
		if($this->session->userdata("groupId"))
		{
			$groupData = $this->donations_groups_model->groupData($this->session->userdata("groupId"));
		}
		$preData="";
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.user_id,o.username,o.transaction_id,o.total_price,o.original_total_price,o.order_total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_status,o.is_cancelled,o.tokens,o.dispatched,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.address1,o.address2,o.address3,
			o.email,o.firstname,o.lastname,o.phone,o.country,o.created_by,o.declaration_type,o.app,o.id as oid,o.paid_tx_ids, o.refunded_tx_ids, o.failed_tx_ids, o.cancelled_tx_ids, o.inprocess_tx_ids,o.city,o.state,o.country,o.country_name,
			 o.bounced_tx_ids, o.payment_mode as payment_mode,oi.id,oi.quantity,oi.item_name,oi.donor_id,oi.schedule_dates,oi.item_name,oi.personal_note,oi.transaction_ids,oi.price,oi.family_member_details,
			 oi.appji_member_name,oi.appji_member_email,oi.subscription,oi.item_id,o.order_pan_number");
		}
		if($excel==1)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.username,o.user_id,o.transaction_id,o.total_price,o.paid,o.status,o.currency,o.payment_status,o.partial_payments_allowed,
			o.paid_tx_ids,o.address1,o.address2,o.address3,o.city,o.state,o.email,o.firstname,o.lastname,o.phone,o.created_by,o.refunded_tx_ids,o.country,o.zipcode,o.total_paid,o.no_paid_transactions,o.paid_tx_ids,
			o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.tokens,o.dispatch_status,o.app,o.id as oid, o.payment_mode as payment_mode,oi.family_member_details,oi.updated_quantity,oi.price,
			oi.id,oi.quantity,oi.item_name,oi.donor_id,oid.date as donation_date,oi.item_name,oi.item_id,oi.subscription,oi.personal_note,oi.transaction_ids,oi.is_poornaphala_seva,oi.poornaphala_end_dates,oi.poornaphala_tie_by,o.order_pan_number");
		}

		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nCategories: ";
		if(isset($_POST['category_id']) && $_POST['category_id']!='')
		{
			if(is_array($_POST['category_id']))
			{
				if(empty(array_filter($_POST['category_id'])))
				{
					goto category_default;
				}
				$query1->where_in("oi.category",$_POST['category_id']);
				$pii=0;
				foreach ($categoryData as $category)
				{
					if($pii) $preData.=", ";
					$preData.=$category->name;
					$pii++;
				}
			}
			else
			{					
				$query1->where("oi.category",$_POST['category_id']);
				$preData.=$categoryData->name;
			}
		}
		else
		{
			category_default:
			$preData.="All categories";
		}
		$preData.="\nGroups: ";
		if($this->session->userdata("groupId"))
		{
			$preData.="\nGroup: ";
			$query1->where("d.group_id",$this->session->userdata("groupId"));
			$preData.=$groupData->name;
		}else{
			$preData.="All Groups";
		}
		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->like("o.payment_alt_mode",$_POST['payment_mode']);
			if($_POST['payment_mode'] == 'cash')
			{
				$preData.="Offline";
			} else {
				$preData.=$_POST['payment_mode'];
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nDonation(s): ";
			if(isset($_POST['donation_id']) && $_POST['donation_id']!='')
			{
				if(is_array($_POST['donation_id']))
				{
					
					if(empty(array_filter($_POST['donation_id'])))
					{
						goto donation_default;
					}
					$query1->where_in("item_id",$_POST['donation_id']);
					$pii=0;
					foreach ($_POST['donation_id'] as $donation_id)
					{
						if($pii) $preData.=", ";
						$preData.=$donationsArray[$donation_id]->donation_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("item_id",$_POST['donation_id']);
					$preData.=$donationsArray[$_POST['donation_id']]->donation_name;
				}
			}
			else
			{
				donation_default:
				$preData.="All Donations";
			}
		}
		
		$query1->where("oi.subscription",0);
		$query1->where("is_cancelled!=",1);
		$query1->where("o.order_type",2);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$query1->join("order_items_dates as oid",'oid.order_item_id=oi.id');
		$query1->group_by("oid.id");
		if($this->session->userdata("groupId")) {
			$query1->join("donations as d",'oi.item_id = d.id');
		}
		$query1->where("payment_status!=",0);
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) &&  trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			
				if(in_array(trim($_POST['search_col']), ['appji_member_name','appji_member_email', 'personal_note']))
				{
					$query1->like('oi.'.$_POST['search_col'],trim($_POST['search_text']));
				}
				else
				{
					$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				}
				$preData.=" containing ";
			$preData.='"'.$_POST['search_text'].'"';
		}
		
		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency'] ?? '');
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_POST['amount_condition']) && $_POST['amount_condition']!='') && (isset($_POST['search_amount']) && $_POST['search_amount']!='') )
		{
			$amountWhere = "IF(`oi`.`updated_quantity` > 0, (`oi`.`price`*`oi`.`updated_quantity`), (`oi`.`price`*`oi`.`quantity`)) ".$_POST['amount_condition']." '".$_POST['search_amount']."'";
			$query1->where($amountWhere);
			$preData.="\nAmount: ".$_POST['amount_condition']." ".$_POST['search_amount'];
		}

		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("o.tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && is_numeric($_POST['payment_status']) && in_array($_POST['payment_status'],array(0,1,2)))
		{
			$query1->where("o.payment_status",$_POST['payment_status']);
			if($_POST['payment_status']==1)
				$preData.="Paid";
			else if($_POST['payment_status']==0)
				$preData.="Pending";
			else if($_POST['payment_status']==1)
				$preData.="Partially Paid";
		}

		$fromDateTime='';
		$toDateTime='';

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(oid.date) >=",date("Y:m:d",strtotime($_POST['from_date'] ?? '')));
			$fromDateTime=strtotime($_POST['from_date'] ?? '');
			$preData.=$_POST['from_date'];
		}
		else
		{
			if(!isset($_POST['to_date']) || $_POST['to_date']=='')
			{
				$fromDateTime=time();
				$query1->where("DATE(oid.date) >=",date("Y:m:d"));
				$preData.=date("d M Y");

			}
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(oid.date) <=",date("Y:m:d",strtotime($_POST['to_date'] ?? '')));
			$toDateTime=strtotime($_POST['to_date'] ?? '');
			$preData.=$_POST['to_date'];
		}
		else
		{
			if(!isset($_POST['from_date']) || $_POST['from_date']=='')
			{
				$query1->where("DATE(oid.date) <=",date("Y:m:d"));
				$toDateTime=time();
				$preData.=date("d M Y");
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.'.$_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by('o.'.$_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('oid.date',$_POST['dir']);
				else
					$query1->order_by('oid.date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Donation Sevas By Date",$preData,15);

			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'] ?? '')]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency ?? '')]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by('o.'.$col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['transaction_ids'];
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date'] ?? ''));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'] ?? '')." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'] ?? '')." ".$rtn['data'][$c]['total_price'];
			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
			$rtn['data'][$c]['family_details']=nl2br($row['family_member_details'] ?? '');

			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;

			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	public function listPublicDonations($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		if(isset($_POST['ashram_id']) && $_POST['ashram_id']>0)
		{
			$donations=$this->donations_model->getByAshramId($_POST['ashram_id']);
			$donationsArray=array();
			foreach ($donations as $donationData)
			{
				$donationsArray[$donationData->id]=$donationData;
			}
			$ashramData=$this->ashrams_model->ashramData($_POST['ashram_id']);
		}

		$preData="";
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("user","participant")))
			{
				$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency, sum(oi.quantity * oi.price) as total_amount");
			}
			else
			{
				$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
			}
		}

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("user","participant")))
			{
				$query1->select("o.*,oi.*, sum(oi.quantity * oi.price) as total_amount, o.id as oid,o.paid_tx_ids, o.refunded_tx_ids, o.failed_tx_ids, o.cancelled_tx_ids, o.inprocess_tx_ids, o.bounced_tx_ids, o.payment_mode as payment_mode, usr.pan_number as pan_number");
			}
			else
			{
				$query1->select("o.*,oi.*,o.id as oid,o.paid_tx_ids, o.refunded_tx_ids, o.failed_tx_ids, o.cancelled_tx_ids, o.inprocess_tx_ids, o.bounced_tx_ids, o.payment_mode as payment_mode, usr.pan_number as pan_number");
			}
		}

		$query1->where("subscription",0);
		$query1->where("is_cancelled!=",1);
		$preData.="Ashram: ";
		if(isset($_POST['ashram_id']) && $_POST['ashram_id']>0)
		{
			$query1->where("o.ashram_id",$_POST['ashram_id']);
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		if(isset($_POST['ashram_id']) && $_POST['ashram_id']>0)
		{
			$preData.="\nDonation(s): ";
			if(isset($_POST['donation_id']) && $_POST['donation_id']!='')
			{
				if(is_array($_POST['donation_id']))
				{
					$query1->where_in("item_id",$_POST['donation_id']);
					$pii=0;
					foreach ($_POST['donation_id'] as $donation_id)
					{
						if($pii) $preData.=", ";
						if(isset($donationsArray[$donation_id]->donation_name) && $donationsArray[$donation_id]->donation_name!="")
							$preData.=$donationsArray[$donation_id]->donation_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("item_id",$_POST['donation_id']);
					$preData.=$donationsArray[$_POST['donation_id']]->donation_name;
				}
			}
			else
			{
				$preData.="All Donations";
			}
		}
		
		$query1->where("o.order_type",2);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');

		if($i==2 || $excel==1)
		{
			$query1->join("users as usr",'usr.id=o.user_id');
		}
		$query1->where("payment_status!=",0);
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && 
			isset($_POST['wild']) && trim($_POST['search_text'])!='')
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			if($_POST['wild']=='contains')
			{
				if(in_array(trim($_POST['search_col']), ['appji_member_name','appji_member_email','family_member_details']))
				{
					$query1->like('oi.'.$_POST['search_col'],trim($_POST['search_text']));
				}
				else
				{
					$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				}
				$preData.=" containing ";
			}
			$preData.='"'.$_POST['search_text'].'"';
		}
		
		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$preData.="Total By:";
		if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("user","participant")))
		{
			$query1->group_by("o.currency");
			if($_POST['group_by']=='user')
			{
				$query1->group_by("o.user_id");
				$preData.=" Devotee";
			}
			if($_POST['group_by']=='participant')
			{
				$query1->group_by("o.user_id");
				$query1->group_by("oi.family_member_details");
				$preData.=" Participant";
			}
		}

		$preData.="\nFrom Date: ";
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_POST['from_date']))."' ";
			$fromDateTime=strtotime($_POST['from_date']);
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_POST['to_date']))."'";
			$toDateTime=strtotime($_POST['to_date']);
			$preData.=$_POST['to_date'];
		}

		if((!isset($_POST['from_date']) || $_POST['from_date']=='') && (!isset($_POST['to_date']) || $_POST['to_date']==''))
		{
			$fromDateTime="0";
		}
		
		$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";

		$query1->where("oi.id in (".$sub_query.")");

		if(isset($_POST['sevas_by_name']) && $_POST['sevas_by_name']=='byappajisname')
		{
			$query1->where("oi.family_member_details", "Sri Ganapathy Sachchidananda Swamiji");
		}
		else if(isset($_POST['sevas_by_name']) && $_POST['sevas_by_name']=='byswajimisname')
		{
			$query1->where("oi.family_member_details", "Sri Datta Vijayananda Teertha Swamiji");
		}

		if($i==1)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("user","participant")))
			{
				$query1->group_by("o.currency");
				$temp_result = $query1->get()->result();
				$t_total=0;
				foreach ($GLOBALS['currencies'] as $currencyData)
				{
					$t_cur_total[strtolower($currencyData['currency'])]=0;
				}
				foreach ($temp_result as $temp_row)
				{
					$t_total+=$temp_row->c;
					$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_amount;
				}
				$rtn['recordsTotal'] = count($temp_result);
				$rtn['recordsFiltered'] = count($temp_result);
				$rtn['total_sum'] = $t_cur_total;
			}
			else
			{
				$query1->group_by("o.currency");
				$temp_result = $query1->get()->result();
				$t_total=0;
				foreach ($GLOBALS['currencies'] as $currencyData)
				{
					$t_cur_total[strtolower($currencyData['currency'])]=0;
				}
				foreach ($temp_result as $temp_row)
				{
					$t_total+=$temp_row->c;
					$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
				}

				$rtn['recordsTotal'] = $t_total;
				$rtn['recordsFiltered'] = $t_total;
				$rtn['total_sum'] = $t_cur_total;
			}
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if(($col_name=='item_price') && (isset($_POST['group_by']) && in_array($_POST['group_by'],array("user","participant"))) )
			{
				$query1->order_by('total_amount',$dir);
			}
			else if($col_name=='item_price')
			{
				$query1->order_by('(oi.quantity * oi.price)',$dir);
			}
			else if($col_num)
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($GLOBALS['currencies'] as $currencyData)
		{
			$groupbyTotalSum[strtolower($currencyData['currency'])]=0;
		}
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['transaction_ids'];
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['group_by']="";
			if(isset($_POST['group_by']))
			{
				$rtn['data'][$c]['group_by']=$_POST['group_by'];
			}
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$resultDonationDates='';
			$donationDates=array_filter(explode(",",$rtn['data'][$c]['schedule_dates']));
			$rDates=array();
			foreach ($donationDates as $donationDate)
			{
				
				$poojaDateTime=strtotime($donationDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=", ";
						$resultDonationDates.=$donationDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=", ";
						$resultDonationDates.=$donationDate;
					}
				}
			}

			$result_dates=array_filter(explode(",",$resultDonationDates));
			$rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".count($result_dates).")";

			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("user","participant")))
			{
				$groupbyTotalSum[strtolower($rtn['data'][$c]['currency'])]+=$rtn['data'][$c]['total_amount'];
				$rtn['total_sum'][strtolower($rtn['data'][$c]['currency'])]=$groupbyTotalSum[strtolower($rtn['data'][$c]['currency'])];
			}
			else if($row['quantity']>1)
			{
				$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];
				$sub_total_sum+=($row['price']*count($result_dates));

				$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
				$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*count($result_dates));
			}

			$rtn['data'][$c]['donation_dates']=$resultDonationDates;

			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
			$rtn['data'][$c]['family_details']=nl2br($row['family_member_details']);

			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;

			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	public function listAdminMismatchOrders($ashramId, $excel=0)
	{
		$preData="";
		$i=0;
		$query1=$this->db;

		if($excel==0)
		{
			$query1->select("count(id) as c,sum(order_amount) as total_sum,currency");
		}

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from("mismatch_ashram_orders");
		$query1->where("order_ashram_id",$ashramId);
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}
		
		$preData.="\nSeva Type: ";
		if(isset($_POST['order_type']) && $_POST['order_type']!='')
		{
			$query1->where("order_type",$_POST['order_type']);
			$preData.=strtoupper($_POST['order_type']);
		}
		else
		{
			$preData.="All Seva Types";
		}

		$preData.="\nFrom Date: ";
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(order_date)>=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(order_date)<=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}
		
		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
				{
					if($_POST['order_by'] == "currency")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("order_amount",$_POST['dir']);
						$query1->order_by("order_date",$_POST['dir']);
					}
					else if($_POST['order_by'] == "order_amount")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("currency",$_POST['dir']);
						$query1->order_by("order_date",$_POST['dir']);
					}
					else if($_POST['order_by'] == "order_date")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("currency",$_POST['dir']);
						$query1->order_by("order_amount",$_POST['dir']);
					}
					else
						$query1->order_by($_POST['order_by'],$_POST['dir']);
				}
				else
				{
					$query1->order_by($_POST['order_by'],'desc');
				}
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('order_date',$_POST['dir']);
				else
					$query1->order_by('order_date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Mismatch Ashram Sevas",$preData,12);

			return $requestResp;
		}

		if($i==1)
		{
			$query1->group_by("currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
			{
				if($col_name == "currency")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("order_amount",$dir);
					$query1->order_by("order_date",$dir);
				}
				else if($col_name == "order_amount")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("currency",$dir);
					$query1->order_by("order_date",$dir);
				}
				else if($col_name == "order_date")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("currency",$dir);
					$query1->order_by("order_amount",$dir);
				}
				else
					$query1->order_by($col_name,$dir);
			}
			else
				$query1->order_by('order_date',$dir);
		}
		else
		{
			$query1->order_by('order_date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$ashramData1=$this->ashrams_model->ashramData($row["order_ashram_id"]);
			$ashramData2=$this->ashrams_model->ashramData($row["original_ashram_id"]);
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['order_date']=date("d M Y H:i A",strtotime($rtn['data'][$c]['order_date']));
			$ashram_name1 = $ashramData1->name . " (".$row["order_ashram_id"].")";
			$ashram_name2 = $ashramData2->name . " (".$row["original_ashram_id"].")";

			$rtn['data'][$c]['order_ashram']=$ashram_name1;
			$rtn['data'][$c]['original_ashram']=$ashram_name2;
			$rtn['data'][$c]['currency']=strtoupper($rtn['data'][$c]['currency']);
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function listAdminStore($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		if($this->session->userdata("ashramId"))
		{
			$items=$this->store_model->getByAshramId($this->session->userdata("ashramId"));
			$itemsArray=array();
			foreach ($items as $itemData)
			{
				$itemsArray[$itemData->id]=$itemData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		//getting category data
		if($this->session->userdata("store_categoryId"))
		{
			$categoryData = $this->subscriptions_categories_model->categoryData($this->session->userdata("store_categoryId"));
		}
		
		$preData="";
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,date,o.user_id,o.username,o.transaction_id,o.total_price,o.original_total_price,o.order_total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_status,o.is_cancelled,o.tokens,o.dispatched,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.address1,o.address2,o.address3,
			o.email,o.firstname,o.lastname,o.phone,o.country,o.created_by,o.declaration_type,o.app,o.id as oid,o.paid_tx_ids, o.refunded_tx_ids, o.failed_tx_ids, o.cancelled_tx_ids, o.inprocess_tx_ids,o.city,o.state,o.country,o.country_name,
			 o.bounced_tx_ids, o.payment_mode as payment_mode,oi.id,oi.quantity,oi.item_name,oi.donor_id,oi.schedule_dates,oi.item_name,oi.personal_note,oi.transaction_ids,oi.price,oi.family_member_details,usr.pan_number as pan_number");
		}
		if($excel==1)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,date,o.username,o.user_id,o.transaction_id,o.total_price,o.paid,o.status,o.currency,o.payment_status,o.partial_payments_allowed,
			o.paid_tx_ids,o.address1,o.address2,o.address3,o.city,o.state,o.email,o.firstname,o.lastname,o.phone,o.created_by,o.refunded_tx_ids,o.country,o.zipcode,o.total_paid,o.no_paid_transactions,o.paid_tx_ids,
			o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.tokens,o.dispatch_status,o.app,o.id as oid, o.payment_mode as payment_mode,oi.family_member_details,oi.updated_quantity,oi.price,
			oi.shipping_address1,oi.shipping_address2,oi.shipping_address3,oi.shipping_city,oi.shipping_state,oi.shipping_country_name,oi.prasadam_not_required,oi.gift_friend_name,oi.gift_friend_email,oi.shipping,
			oi.id,oi.quantity,oi.item_name,oi.donor_id,oi.schedule_dates,oi.item_name,oi.personal_note,oi.transaction_ids,usr.pan_number as pan_number");
		}
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nItem(s): ";
			if(isset($_POST['item_id']) && $_POST['item_id']!='')
			{
				if(is_array($_POST['item_id']))
				{
					if(empty(array_filter($_POST['item_id'])))
					{
						goto store_default;
					}
					$query1->where_in("item_id",$_POST['item_id']);
					$pii=0;
					foreach ($_POST['item_id'] as $item_id)
					{
						if($pii) $preData.=", ";
						$preData.=$itemsArray[$item_id]->item_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("item_id",$_POST['item_id']);
					$preData.=$itemsArray[$_POST['item_id']]->item_name;
				}
			}
			else
			{
				store_default:
				$preData.="All items";
			}
		}
		//filtering with order category
		if($this->session->userdata("store_categoryId"))
		{
			$preData.="\nCategory: ";
			$query1->where("oi.category",$this->session->userdata("store_categoryId"));
			$preData.=$categoryData->name;
		}else{
			$preData.="All categories";
		}
		
		$query1->where("o.order_type",3);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$query1->where("payment_status!=",0);
		$query1->where("is_cancelled!=",1);
		if($i==2 || $excel==1)
		{
			$query1->join("users as usr",'usr.id=o.user_id');
		}

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) &&  trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
			$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->like("o.payment_alt_mode",$_POST['payment_mode']);
			if($_POST['payment_mode']=='cash')
			{
				$preData.="Offline";
			} else{
				$preData.=$_POST['payment_mode'];
			}
		}
		
		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_POST['amount_condition']) && $_POST['amount_condition']!='') && (isset($_POST['search_amount']) && $_POST['search_amount']!='') )
		{
			$amountWhere = "IF(`oi`.`updated_quantity` > 0, (`oi`.`price`*`oi`.`updated_quantity`), (`oi`.`price`*`oi`.`quantity`)) ".$_POST['amount_condition']." '".$_POST['search_amount']."'";
			$query1->where($amountWhere);
			$preData.="\nAmount: ".$_POST['amount_condition']." ".$_POST['search_amount'];
		}

		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("o.tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && is_numeric($_POST['payment_status']) && in_array($_POST['payment_status'],array(0,1,2)))
		{
			$query1->where("o.payment_status",$_POST['payment_status']);
			if($_POST['payment_status']==1)
				$preData.="Paid";
			else if($_POST['payment_status']==0)
				$preData.="Pending";
			else if($_POST['payment_status']==1)
				$preData.="Partially Paid";
		}

		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(date) >=",date("Y:m:d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(date) <=",date("Y:m:d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nShipping Status:";
		if(isset($_POST['dispatched']) && is_numeric($_POST['dispatched']) && in_array($_POST['dispatched'],array(0,1,2,3)))
		{
			$query1->where("o.dispatch_status",$_POST['dispatched']);
			if($_POST['dispatched']==0)
			{
				$preData.="N/A";
			}
			else if($_POST['dispatched']==1)
			{
				$preData.="Pending";
			}
			else if($_POST['dispatched']==2)
			{
				$preData.="Completed";
			}
			else if($_POST['dispatched']==3)
			{
				$preData.="Returned";
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.'.$_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by('o.'.$_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.date',$_POST['dir']);
				else
					$query1->order_by('o.date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Store Orders",$preData,5);
			return $requestResp;
		}

		if($i==1)
		{
			$query1->group_by("o.currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by('o.'.$col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['transaction_ids'];
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			$rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".$rtn['data'][$c]['quantity'].")";
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];

			if($row['quantity']>1)
			{
				$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];

				$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
				$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']);
			}

			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
			$rtn['data'][$c]['family_details']=nl2br($row['family_member_details']);

			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;

			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	public function listAdminPoojasPrasadam($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$poojas=$this->poojas_model->getByAshramId($this->session->userdata("ashramId"));
			$poojasArray=array();
			foreach ($poojas as $poojaData)
			{
				$poojasArray[$poojaData->id]=$poojaData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$poojas=$this->poojas_model->getByAshramId($this->session->userdata("ashramId"));
			$poojasArray=array();
			foreach ($poojas as $poojaData)
			{
				$poojasArray[$poojaData->id]=$poojaData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$preData='';
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("*,o.id as oid,user_id,username,GROUP_CONCAT(item_name) as items,GROUP_CONCAT(oi.id) as itemids,GROUP_CONCAT(oi.item_id) as seva_itemids,GROUP_CONCAT(DATE(oid.date)) as itemdates");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,o.id as oid,user_id,username,GROUP_CONCAT(item_name separator '???') as items,GROUP_CONCAT(oi.id) as itemids,GROUP_CONCAT(DATE(oid.date)) as itemdates");
		}

		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		$preData.="\nPrasadam Not Required: ";
		if(isset($_POST['p_required']) && $_POST['p_required']!='')
		{
			$query1->where("prasadam_not_required",$_POST['p_required']);
			if($_POST['p_required'] == 1)
				$preData.="Yes";
			if($_POST['p_required'] == 0)
				$preData.="No";
		}

		/*if($this->session->userdata("ashramId"))
		{
			$preData.="\nPooja: ";
			if(isset($_POST['pooja_id']) && $_POST['pooja_id']!='')
			{
				$query1->where("item_id",$_POST['pooja_id']);
				$preData.=$poojasArray[$_POST['pooja_id']]->pooja_name;
			}
			else
			{
				$preData.="All Poojas";
			}
		}*/

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nPooja(s): ";
			if(isset($_POST['pooja_id']) && $_POST['pooja_id']!='')
			{
				if(is_array($_POST['pooja_id']))
				{
					if(empty(array_filter($_POST['pooja_id'])))
					{
						goto pooja_default;
					}
					$query1->where_in("item_id",$_POST['pooja_id']);
					$pii=0;
					foreach ($_POST['pooja_id'] as $pooja_id)
					{
						if(!is_numeric($pooja_id) || !$pooja_id )
						{
							continue;
						}
						if($pii) $preData.=", ";
						$preData.=$poojasArray[$pooja_id]->pooja_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("item_id",$_POST['pooja_id']);
					$preData.=$poojasArray[$_POST['pooja_id']]->pooja_name;
				}
			}
			else
			{
				pooja_default:
				$preData.="All Poojas";
			}
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='' && $_POST['currency']!='all')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$query1->where("o.order_type",1);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$query1->join("order_items_dates as oid",'oid.order_item_id=oi.id');
		$query1->where("o.payment_status!=",0);
		$query1->where("is_cancelled!=",1);
		//$query1->group_by("user_id");
		$query1->group_by("oid");

		$preData.="\nSearch Keywords: ";
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='')
		{
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			$preData.=" containing ";
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nCountry: ";
		if(isset($_POST['country']) && trim($_POST['country'])!='')
		{
			$query1->like('o.country',trim($_POST['country']));
			$preData.='"'.$_POST['country'].'"';
		}
		

		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}
		
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$datesfilter.=" where date(oid.date)>='".date("Y:m:d",strtotime($_POST['from_date']))."' ";
			$fromDateTime=strtotime($_POST['from_date']);
			$query1->where("DATE(oid.date) >=",date("Y:m:d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		else
		{
			if(!isset($_POST['to_date']) || $_POST['to_date']=='')
			{
				$datesfilter.=" where date(oid.date)>='".date("Y:m:d")."' ";
				$fromDateTime=time();
				$query1->where("DATE(oid.date) >=",date("Y:m:d"));
				$preData.=date("d M Y");

			}
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="date(oid.date)<='".date("Y:m:d",strtotime($_POST['to_date']))."'";
			$query1->where("DATE(oid.date) <=",date("Y:m:d",strtotime($_POST['to_date'])));
			$toDateTime=strtotime($_POST['to_date']);
			$preData.=$_POST['to_date'];
		}
		else
		{
			if(!isset($_POST['from_date']) || $_POST['from_date']=='')
			{
				if($datesfilter!='') $datesfilter.=" and ";
				else $datesfilter.=" where ";
				$datesfilter.="date(oid.date)<='".date("Y:m:d")."'";
				$query1->where("DATE(oid.date) <=",date("Y:m:d"));
				$toDateTime=time();
				$preData.=date("d M Y");
			}
		}

		//$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";

		//$query1->where("oi.id in (".$sub_query.")");

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.date',$_POST['dir']);
				else
					$query1->order_by('o.date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"Pooja Sevas - Prasadam Report",$preData,4);
			return $requestResp;
		}



		if($i==1)
		{
			$temp_result = $query1->get();
			$rtn['prasadam_counts'] = array();
			$rtn['total_prasadam_counts'] = 0;
			$rtn['recordsTotal'] = $temp_result->num_rows();
			$rtn['recordsFiltered'] = $temp_result->num_rows();
			$temp_resultarr=$temp_result->result_array();
			foreach ($temp_resultarr as $temp_row)
			{
				// echo '<pre>'; print_r($temp_row); die();
				$tempItemids=array_filter(explode(",",$temp_row['seva_itemids']));
				$tempItems=array_filter(explode(",",$temp_row['items']));
				$tempItemdates=array_filter(explode(",",$temp_row['itemdates']));

				$tempItemsArray=array();
				foreach ($tempItemids as $key => $tempItem_id)
				{
					$tempItemsArray[$tempItem_id]['names'][]=$tempItems[$key];
					$tempItemsArray[$tempItem_id]['dates'][]=date("d M Y",strtotime($tempItemdates[$key]));
				}
				foreach ($tempItemsArray as $key => $tempItemRow)
				{
					if(isset($rtn['prasadam_counts'][$key]['name']) && isset($rtn['prasadam_counts'][$key]['totalPrasadams']))
					{
						$rtn['prasadam_counts'][$key]['totalPrasadams'] += count($tempItemRow['dates']);
						$rtn['total_prasadam_counts'] += count($tempItemRow['dates']);
					}
					else if(!isset($rtn['prasadam_counts'][$key]))
					{
						$rtn['prasadam_counts'][$key] = array(
																		'name'=>$tempItemRow['names'][0],
																		'totalPrasadams'=>count($tempItemRow['dates'])
																	);
						$rtn['total_prasadam_counts'] += count($tempItemRow['dates']);
					}
				}
			}
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			unset($row['data']);
			unset($row['options']);
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$itemids=array_filter(explode(",",$row['itemids']));
			$items=array_filter(explode("???",$row['items']));
			$itemdates=array_filter(explode(",",$row['itemdates']));

			$itemsArray=array();
			foreach ($itemids as $key => $item_id)
			{
				$itemsArray[$item_id]['names'][]=$items[$key];
				$itemsArray[$item_id]['dates'][]=date("d M Y",strtotime($itemdates[$key]));
			}
			$itemsString='';
			$k=0;
			foreach ($itemsArray as $key => $itemRow)
			{
				$ino = $k+1;
				if($k>0)
					$itemsString.="<br><br><span style='color:red;'>".$ino . ".</span> " .$itemRow['names'][0]."<br>&nbsp;&nbsp;&nbsp;&nbsp;(<b>Total: ".count($itemRow['dates'])."</b>)&nbsp;&nbsp; <span style='color:blue;'>".implode(", ",$itemRow['dates'])."</span>";
				else
					$itemsString.= "<span style='color:red;'>".$ino . ".</span> " .$itemRow['names'][0]."<br> &nbsp;&nbsp;&nbsp;&nbsp;(<b>Total: ".count($itemRow['dates'])."</b>)&nbsp;&nbsp; <span style='color:blue;'>".implode(", ",$itemRow['dates'])."</span>";

				$k++;
			}

			$rtn['data'][$c]['iteminfo']=$itemsString;
			$rtn['data'][$c]['itemsinfo']=$itemsArray;
			
			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'] . " - ".$row['zipcode'];

			$rtn['data'][$c]['address']=$address;

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	#Author: Baji
	#Branch: bajidotwork_DPDEV-failedsubscriptionpayments
	public function listAdminFailedSubscriptions($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		if($this->session->userdata("ashramId"))
		{
			$donations=$this->donations_model->getByAshramId($this->session->userdata("ashramId"));
			$donationsArray=array();
			foreach ($donations as $donationData)
			{
				$donationsArray[$donationData->id]=$donationData;
			}

			$subscriptions=$this->subscriptions_model->getByAshramId($this->session->userdata("ashramId"));
			$subscriptionsArray=array();
			foreach ($subscriptions as $subscriptionData)
			{
				$subscriptionsArray[$subscriptionData->id]=$subscriptionData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$preData="";
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("o.id as oid,oi.id as oiid,ts.payment_mode as payment_mode,ts.tx as transaction_id,ts.amount as fail_amount,ts.status as tranx_status,ts.created_on as payment_created_on,o.date as order_date,ts.is_manual_payment,ts.is_foreign_payment,ts.payment_mode as ts_payment_mode,ts.note as tranx_note,o.currency,o.address1,o.address2,o.address3,o.city,o.state,o.country,o.zipcode,o.phone,oi.item_name,o.order_number,o.email,o.firstname,o.lastname,o.username,o.date,ts.payment_number,o.user_id,oi.status as subscription_status,oi.period,oi.num_of_payments");
		}
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("ts.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nSubscription(s): ";
			if(isset($_POST['subscription_id']) && $_POST['subscription_id']!='')
			{
				if(is_array($_POST['subscription_id']))
				{
					$query1->where_in("ts.order_item_id",$_POST['subscription_id']);
					$pii=0;
					foreach ($_POST['subscription_id'] as $subscription_id)
					{
						if($pii) $preData.=", ";
						$preData.=$subscriptionsArray[$subscription_id]->subscription_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("ts.order_item_id",$_POST['subscription_id']);
					$preData.=$donationsArray[$_POST['subscription_id']]->subscription_name;
				}
			}
			else
			{
				$preData.="All Subscriptions";
			}
		}

		$query1->group_start();
			$query1->where("o.order_type",2);
			$query1->or_where("o.order_type",4);
  		$query1->group_end();
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$query1->join("transaction as ts",'ts.order_item_id=oi.id',"left");
		$query1->where_in("ts.status",array('failed','failure','bounced','User Cancelled','cash_pending'));
		$query1->where("oi.subscription",1);
		

		$preData.="\nRecords Type: ";
		if(isset($_POST['records_type']) && $_POST['records_type']=='latestUnique')
		{
			$preData.="Latest Records";
		}
		else
		{
			$preData.="All Records";
		}

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}


		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("ts.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$preData.="\nPayment Mode: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->like("ts.payment_mode",$_POST['payment_mode']);
			$preData.=$_POST['payment_mode'];
		}

		$preData.="\Subscription Status: ";
		if(isset($_POST['subscription_status']) && $_POST['subscription_status']!='')
		{
			$query1->where("oi.status",$_POST['subscription_status']);
			if($_POST['subscription_status'] == '0')
			{
				$preData.="Pending";
			}
			if($_POST['subscription_status'] == '1')
			{
				$preData.="In-Progress";
			}
			if($_POST['subscription_status'] == '2')
			{
				$preData.="Fully Paid";
			}
			if($_POST['subscription_status'] == '3')
			{
				$preData.="Cancelled";
			}
		}
		else
		{
			$preData.="All Subscriptions";
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && $_POST['payment_status']!='')
		{
			// $query1->where("sp.status",$_POST['payment_status']);
			// if($_POST['payment_status'] == '8')
			// {
			// 	$preData.="Paid";
			// }
			// if($_POST['payment_status'] == '0')
			// {
			// 	$preData.="Pending";
			// }
			// if($_POST['payment_status'] == '1')
			// {
			// 	$preData.="Failed";
			// }
			// if($_POST['payment_status'] == '101')
			// {
			// 	$preData.="InProcess";
			// }
			// if($_POST['payment_status'] == '102')
			// {
			// 	$preData.="Bounced";
			// }
			// if($_POST['payment_status'] == '103')
			// {
			// 	$preData.="Refunded";
			// }
		}

        $preData.="\nFrom Date: ";
        if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$created_from = date('Y-m-d H:i:s',strtotime($_POST['from_date']));
			$query1->where("ts.created_on >=",$created_from);
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$created_to = date('Y-m-d',strtotime($_POST['to_date']));
            $created_to = date('Y-m-d H:i:s',strtotime('+23 hour +59 minutes +59 seconds',strtotime($created_to)));
			$query1->where("ts.created_on <=",$created_to);
			$preData.=$_POST['to_date'];
		}

		$preData.="\nSubscription Mode: ";
		if(isset($_POST['subscription_type']) && in_array($_POST['subscription_type'],array("days","months","weeks","years")))
		{
			$query1->where("oi.period",$_POST['subscription_type']);
			if($_POST['subscription_type']=="weeks")
			{
				$preData.="Weekly";
			}
			if($_POST['subscription_type']=="days")
			{
				$preData.="Daily";
			}
			if($_POST['subscription_type']=="months")
			{
				$preData.="Monthly";
			}
			if($_POST['subscription_type']=="years")
			{
				$preData.="Yearly";
			}
		}

		
		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			if(isset($_POST['records_type']) && $_POST['records_type']=='latestUnique')
			{
				// $query1->group_by("sp.payment_number, sp.order_item_id,sp.order_id");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Failed Subscription Payments",$preData,9);
			return $requestResp;
		}

		if($i==1)
		{

			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		if(isset($_POST['records_type']) && $_POST['records_type']=='latestUnique')
		{
			// $query1->group_by("sp.payment_number, sp.order_item_id,sp.order_id");
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		//echo $this->db->last_query();exit();
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($row['period'] == "weeks")
			{
				$rtn['data'][$c]['period']="Weekly";
			}
			else if($row['period'] == "days")
			{
				$rtn['data'][$c]['period']="Daily";
			}
			else if($row['period'] == "months")
			{
				$rtn['data'][$c]['period']="Monthly";
			}
			else if($row['period'] == "years")
			{
				$rtn['data'][$c]['period']="Yearly";
			}
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['payment_status']=$rtn['data'][$c]['tranx_status'];
			$rtn['data'][$c]['payment_mode']=ucfirst($row['payment_mode']);
			$rtn['data'][$c]['fail_amount']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['fail_amount'];
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['transaction_id'];
			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;
			$code = isset($countries[$row['country']]->isd_code)?$countries[$row['country']]->isd_code:"N/A";
			if($code == "N/A")
				$number = $rtn['data'][$c]['phone'];
			else
				$number = "+".$code." ".$rtn['data'][$c]['phone'];
			if($row['tranx_note']!='')
				$rtn['data'][$c]['tranx_note'] = nl2br($rtn['data'][$c]['tranx_note']);
			else
				$rtn['data'][$c]['tranx_note'] = "N/A";
			$rtn['data'][$c]['phone']= $number;
			$rtn['data'][$c]['payment_date_c']=date("d M Y",strtotime($rtn['data'][$c]['payment_created_on']));
			$rtn['data'][$c]['order_date']=date("d M Y",strtotime($rtn['data'][$c]['order_date']));

			if($rtn['data'][$c]['subscription_status'] == '0')
			{
				$rtn['data'][$c]['subscription_status_str']="<span class='label label-warning' style = 'margin-top:5px;'>Pending</span>";
			}
			else if($rtn['data'][$c]['subscription_status'] == '1')
			{
				$rtn['data'][$c]['subscription_status_str']="<span class='label label-info' style = 'margin-top:5px;'>In-Progress</span>";
			}
			else if($rtn['data'][$c]['subscription_status'] == '2')
			{
				$rtn['data'][$c]['subscription_status_str']="<span class='label label-success' style = 'margin-top:5px;'>Fully Paid</span>";
			}
			else if($rtn['data'][$c]['subscription_status'] == '3')
			{
				$rtn['data'][$c]['subscription_status_str']="<span class='label label-danger' style = 'margin-top:5px;'>Cancelled</span>";
			}
			else
			{
				$rtn['data'][$c]['subscription_status_str'] = 'NA';
			}
			
			$sno++;
			$c++;
			
		}
		return $rtn;
	}

	public function listUserFailedSubscriptions($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		if($this->session->userdata("ashramId"))
		{
			$donations=$this->donations_model->getByAshramId($this->session->userdata("ashramId"));
			$donationsArray=array();
			foreach ($donations as $donationData)
			{
				$donationsArray[$donationData->id]=$donationData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$preData="";
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("o.id as oid,oi.id as oiid,sp.tx as transaction_id,sp.amount as fail_amount,sp.status as tranx_status,sp.date as payment_created_on,o.date as order_date,ts.is_manual_payment,ts.is_foreign_payment,ts.payment_mode as ts_payment_mode,ts.note as tranx_note,o.currency,o.address1,o.address2,o.address3,o.city,o.state,o.country,o.zipcode,o.phone,oi.item_name,o.order_number,o.email,o.firstname,o.lastname,o.username,o.date,sp.payment_number,sp.status as sub_status");
		}
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("ts.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
  		$query1->from("subscription_payments as sp");
		$query1->join($this->tableName." as o","o.id = sp.order_id");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$query1->join("transaction as ts",'ts.tx=sp.tx');
		$query1->where("sp.status",1);
		$query1->where("o.user_id",$this->currentUser->id);
		$query1->where("o.is_cancelled!=",1);
		$query1->where_in("oi.status",array(1,0));

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && 
			isset($_POST['wild']) && trim($_POST['search_text'])!='')
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}


		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$preData.="\nPayment mode: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->like("o.payment_mode",$_POST['payment_mode']);
			$preData.=$_POST['payment_mode'];
		}

        $preData.="\nFrom Date: ";
        if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$created_from = date('Y-m-d H:i:s',strtotime($_POST['from_date']));
			$query1->where("sp.date >=",$created_from);
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$created_to = date('Y-m-d',strtotime($_POST['to_date']));
            $created_to = date('Y-m-d H:i:s',strtotime('+23 hour +59 minutes +59 seconds',strtotime($created_to)));
			$query1->where("sp.date <=",$created_to);
			$preData.=$_POST['to_date'];
		}
		
		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Failed Subscription Payments",$preData,7);
			return $requestResp;
		}

		if($i==1)
		{

			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		//echo $this->db->last_query();exit();
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['payment_status']=$rtn['data'][$c]['tranx_status'];
			$rtn['data'][$c]['payment_mode']=ucfirst($row['ts_payment_mode']);
			$rtn['data'][$c]['fail_amount']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['fail_amount'];
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['transaction_id'];
			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;
			$code = isset($countries[$row['country']]->isd_code)?$countries[$row['country']]->isd_code:"N/A";
			if($code == "N/A")
				$number = $rtn['data'][$c]['phone'];
			else
				$number = "+".$code." ".$rtn['data'][$c]['phone'];
			if($row['tranx_note']!='')
				$rtn['data'][$c]['tranx_note'] = nl2br($rtn['data'][$c]['tranx_note']);
			else
				$rtn['data'][$c]['tranx_note'] = "N/A";
			$rtn['data'][$c]['phone']= $number;
			$rtn['data'][$c]['payment_date_c']=date("d M Y",strtotime($rtn['data'][$c]['payment_created_on']));
			$rtn['data'][$c]['order_date']=date("d M Y",strtotime($rtn['data'][$c]['order_date']));
			
			$sno++;
			$c++;
			
		}
		return $rtn;
	}

	/**
	 * List All One Time Failed Payments
	 * @gitBranch: bajidotwork_DPDEV-425
	 * @version   1.1
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function listAdminonetimeFailedpayments($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		if($this->session->userdata("ashramId"))
		{
			$donations=$this->donations_model->getByAshramId($this->session->userdata("ashramId"));
			$donationsArray=array();
			foreach ($donations as $donationData)
			{
				$donationsArray[$donationData->id]=$donationData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$preData="";
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c");
		}

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("o.id as oid,oi.id as oiid,ts.payment_mode as payment_mode,ts.tx as transaction_id,ts.amount as fail_amount,ts.status as tranx_status,ts.created_on as payment_created_on,o.date as order_date,ts.is_manual_payment,ts.is_foreign_payment,ts.payment_mode as ts_payment_mode,ts.note as ts_note,o.currency,o.address1,o.address2,o.address3,o.city,o.state,o.country,o.zipcode,o.phone,oi.item_name,o.order_number,o.email,o.firstname,o.lastname,o.username,o.date,payment_number");
		}
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("ts.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		$query1->from("transaction as ts");
		$query1->join($this->tableName." as o",'ts.order_id=o.id');
		$query1->join("order_items as oi",'oi.order_id=o.id');
		//$query1->join("donors as d",'d.id=oi.donor_id',"left");
		$query1->where_in("ts.status",array('failed','failure','bounced','User Cancelled','cash_pending'));
		$query1->where("ts.amount!=",0);
		$query1->where("ts.subscription",0);
		

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']) )
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}


		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("ts.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$preData.="\nPayment mode: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->like("ts.payment_mode",$_POST['payment_mode']);
			$preData.=$_POST['payment_mode'];
		}

        $preData.="\nFrom Date: ";
        if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$created_from = date('Y-m-d H:i:s',strtotime($_POST['from_date']));
			$query1->where("ts.created_on >=",$created_from);
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$created_to = date('Y-m-d',strtotime($_POST['to_date']));
            $created_to = date('Y-m-d H:i:s',strtotime('+23 hour +59 minutes +59 seconds',strtotime($created_to)));
			$query1->where("ts.created_on <=",$created_to);
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Failed Onetime Payments",$preData,10);
			return $requestResp;
		}

		if($i==1)
		{

			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['payment_status']=$rtn['data'][$c]['tranx_status'];
			$rtn['data'][$c]['payment_mode']=ucfirst($row['payment_mode']);
			$rtn['data'][$c]['fail_amount']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['fail_amount'];
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['transaction_id'];
			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;
			$code = isset($countries[$row['country']]->isd_code)?$countries[$row['country']]->isd_code:"N/A";
			if($code == "N/A")
				$number = $rtn['data'][$c]['phone'];
			else
				$number = "+".$code." ".$rtn['data'][$c]['phone'];
			if($row['ts_note']!='')
				$rtn['data'][$c]['ts_note'] = nl2br($rtn['data'][$c]['ts_note']);
			else
				$rtn['data'][$c]['ts_note'] = "N/A";
			$rtn['data'][$c]['phone']= $number;
			$rtn['data'][$c]['payment_date_c']=date("d M Y",strtotime($rtn['data'][$c]['payment_created_on']));
			$rtn['data'][$c]['order_date']=date("d M Y",strtotime($rtn['data'][$c]['order_date']));
			
			$sno++;
			$c++;
			
		}
		return $rtn;
	}

	public function listAdminSubscriptions($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);
		$pets=$this->pets_model->getAll();

		if($this->session->userdata("ashramId"))
		{
			$subscriptions=$this->subscriptions_model->getByAshramId($this->session->userdata("ashramId"));
			$subscriptionsArray=array();
			foreach ($subscriptions as $donationData)
			{
				$subscriptionsArray[$donationData->id]=$donationData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		//getting category data
		if($this->session->userdata("subscription_categoryId"))
		{
			$categoryData = $this->subscriptions_categories_model->categoryData($this->session->userdata("subscription_categoryId"));
		}
		
		$preData="";
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.user_id,o.username,o.transaction_id,o.total_price,o.original_total_price,o.order_total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_status,o.is_cancelled,o.tokens,o.dispatched,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.address1,o.address2,o.address3,
			o.email,o.firstname,o.lastname,o.phone,o.country,o.created_by,o.declaration_type,o.app,o.id as oid,o.paid_tx_ids, o.refunded_tx_ids, o.failed_tx_ids, o.cancelled_tx_ids, o.inprocess_tx_ids,o.city,o.state,o.country,o.country_name,
			 o.bounced_tx_ids, o.payment_mode as payment_mode,oi.id,oi.quantity,oi.item_name,oi.donor_id,oi.schedule_dates,oi.item_name,oi.personal_note,oi.price,oi.family_member_details,
			 oi.paid_amount,oi.subscription_refunded_amount,oi.assign_pet,oi.appji_member_name,oi.appji_member_email,pet.pet_name,pet.pet_serial_number,oi.transaction_ids as item_transaction_ids,oi.subscription,oi.item_id,usr.pan_number as pan_number");
		}
		if($excel==1)
		{
			$query1->select("o.id,o.order_number,o.subscription_mixed_order,o.order_type,o.date,o.username,o.user_id,o.transaction_id,o.total_price,o.paid,o.status,o.currency,o.payment_status,o.partial_payments_allowed,
			o.paid_tx_ids,o.address1,o.address2,o.address3,o.city,o.state,o.email,o.firstname,o.lastname,o.phone,o.created_by,o.refunded_tx_ids,o.country,o.zipcode,o.total_paid,o.no_paid_transactions,o.paid_tx_ids,
			o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.tokens,o.dispatch_status,o.app,o.id as oid, oi.id as oiid,o.payment_mode as payment_mode,oi.family_member_details,oi.updated_quantity,oi.price,oi.appji_member_name,oi.appji_member_email,
			oi.subscription_refunded_amount,oi.paid_amount,oi.id,oi.order_id,oi.quantity,oi.item_name,oi.paid_count,oi.refunded_counts,oi.transaction_ids as item_transaction_ids,pet.pet_name,pet.pet_serial_number,oi.schedule_dates,oi.item_name,oi.item_id,oi.subscription,oi.personal_note,oi.transaction_ids,oi.num_of_payments,usr.pan_number as pan_number");
		}
		
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nSubscription(s): ";
			if(isset($_POST['subscription_id']) && $_POST['subscription_id']!='')
			{
				if(is_array($_POST['subscription_id']))
				{
					if(empty(array_filter($_POST['pooja_id'])))
					{
						goto subscription_default;
					}
					$query1->where_in("item_id",$_POST['subscription_id']);
					$pii=0;
					foreach ($_POST['subscription_id'] as $donation_id)
					{
						if($pii) $preData.=", ";
						$preData.=$subscriptionsArray[$donation_id]->subscription_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("item_id",$_POST['subscription_id']);
					$preData.=$donationsArray[$_POST['subscription_id']]->subscription_name;
				}
			}
			else
			{
				subscription_default:
				$preData.="All Subscriptions";
			}
		}
		//filtering with order category
		if($this->session->userdata("subscription_categoryId"))
		{
			$preData.="\nCategory: ";
			$query1->where("oi.category",$this->session->userdata("subscription_categoryId"));
			$preData.=$categoryData->name;
		}else{
			$preData.="All categories";
		}
		
		$query1->group_start();
			$query1->where("o.order_type",2);
			$query1->or_where("o.order_type",4);
  		$query1->group_end();
		
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		//$query1->join("donors as d",'d.id=oi.donor_id',"left");
		$query1->join("pets as pet",'pet.id=oi.pet_id',"left");
		$query1->where("oi.subscription",1);
		$query1->where("oi.status!=",0);
		$query1->where("oi.status!=",2);
		$query1->where("is_cancelled!=",1);

		if($i==2 || $excel==1)
		{
			$query1->join("users as usr",'usr.id=o.user_id');
		}
		

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col'])  && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			if(in_array(trim($_POST['search_col']), ['appji_member_name','appji_member_email']))
			{
				$query1->like('oi.'.$_POST['search_col'],trim($_POST['search_text']));
			}
			else
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
			}
			$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				if(in_array(trim($_POST['search_col']), ['appji_member_name','appji_member_email']))
				{
					$query1->like('oi.'.$_POST['search_col'],trim($_POST['search_text']));
				}
				else
				{
					$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				}
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				if(in_array(trim($_POST['search_col']), ['appji_member_name','appji_member_email']))
				{
					$query1->like('oi.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				}
				else
				{
					$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				}
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				if(in_array(trim($_POST['search_col']), ['appji_member_name','appji_member_email']))
				{
					$query1->like('oi.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				}
				else
				{
					$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				}
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}


		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_POST['amount_condition']) && $_POST['amount_condition']!='') && (isset($_POST['search_amount']) && $_POST['search_amount']!='') )
		{
			$amountWhere = "IF(`oi`.`updated_quantity` > 0, (`oi`.`price`*`oi`.`updated_quantity`), (`oi`.`price`*`oi`.`quantity`)) ".$_POST['amount_condition']." '".$_POST['search_amount']."'";
			$query1->where($amountWhere);
			$preData.="\nAmount: ".$_POST['amount_condition']." ".$_POST['search_amount'];
		}

		$preData.="\nPet status: ";
		if(isset($_POST['pet_status']) && $_POST['pet_status']!='' && in_array($_POST['pet_status'],array(0,1,2)))
		{
			if($_POST['pet_status']==0)
			{
				$preData.="Pet not assigned";
				$query1->where("assign_pet",1);
				$query1->where("pet_id",0);
			}
			else if($_POST['pet_status']==1)
			{
				$preData.="Pet assigned";
				$query1->where("assign_pet",1);
				$query1->where("pet_id !=",0);
			}
			else if($_POST['pet_status']==2)
			{
				$preData.="N/A";
				$query1->where("assign_pet",0);
			}
		}

		$preData.="\nPets: ";
		if(isset($_POST['pet_id']) && $_POST['pet_id']!='')
		{
			$query1->where("pet_id",$_POST['pet_id']);
			$preData.=$pets[$_POST['pet_id']]->pet_name;
		}
		else
		{
			$preData.="All Pets";
		}

		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->like("o.payment_alt_mode",$_POST['payment_mode']);
			if($_POST['payment_mode'] == 'cash')
			{
				$preData.='Offline';
			} else {
				$preData.=$_POST['payment_mode'];
			}
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && $_POST['payment_status']!='' && in_array($_POST['payment_status'],array(0,1,2)))
		{
			if($_POST['payment_status']==0)
			{
				$preData.="Pending";
				$query1->where("oi.status",0);
			}
			else if($_POST['payment_status']==1)
			{
				$preData.="Fully Paid";
				$query1->where("oi.status",3);
			}
			else if($_POST['payment_status']==2)
			{
				$preData.="Partially Paid";
				$query1->where("oi.status",1);
			}
		}

		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("o.tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}
		$preData.="\nFrom Date: ";
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_POST['from_date']))."' ";
			$fromDateTime=strtotime($_POST['from_date']);
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_POST['to_date']))."'";
			$toDateTime=strtotime($_POST['to_date']);
			$preData.=$_POST['to_date'];
		}

		if((!isset($_POST['from_date']) || $_POST['from_date']=='') && (!isset($_POST['to_date']) || $_POST['to_date']==''))
		{
			$fromDateTime="0";
		}
		
		$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";

		$query1->where("oi.id in (".$sub_query.")");

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.'.$_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by('o.'.$_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('o.date',$_POST['dir']);
				else
					$query1->order_by('o.date',"desc");
			}
			$sql=$query1->get_compiled_select();


			if(isset($_POST['pagenum']) && $_POST['pagenum']==11)
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"Subscriptions - Seva Karta report",$preData,11);
			}
			else
			{
			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"All Subscriptions",$preData,6);
			}
			return $requestResp;
		}

		if($i==1)
		{
			$query1->group_by("o.currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by('o.'.$col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;

			// $totalpaid = $rtn['data'][$c]['paid_amount'] - $rtn['data'][$c]['subscription_refunded_amount'];
			$rtn['data'][$c]['total_paid']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['paid_amount'];
			$rtn['data'][$c]['subscription_refunded_amount']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['subscription_refunded_amount'];
			$rtn['data'][$c]['txids']=$rtn['data'][$c]['item_transaction_ids'];


			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			// $rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".$rtn['data'][$c]['quantity'].")";
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$resultDonationDates='';
			$donationDates=array_filter(explode(",",$rtn['data'][$c]['schedule_dates']));
			$rDates=array();
			foreach ($donationDates as $donationDate)
			{
				
				$poojaDateTime=strtotime($donationDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=", ";
						$resultDonationDates.=$donationDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=", ";
						$resultDonationDates.=$donationDate;
					}
				}
			}

			$result_dates=array_filter(explode(",",$resultDonationDates));
			$rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".count($result_dates).")";
			if($row['quantity']>1)
			{
				$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];
				$sub_total_sum+=($row['price']*count($result_dates));

				$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
				$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*count($result_dates));
			}

			$rtn['data'][$c]['subscription_dates']=$resultDonationDates;

			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
			$rtn['data'][$c]['family_details']=nl2br($row['family_member_details']);

			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;

			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	public function listUser($excel=0)
	{

		if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='')
		{
			$ashramData=$this->ashrams_model->ashramData($_POST['ashram_id']);
		}
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(id) as c,sum(total_price) as total_sum,currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("id,order_number,subscription_mixed_order,order_type,date,user_id,username,transaction_id,total_price,original_total_price,order_total_price,paid,total_paid,status,ashram_id,
			currency,payment_mode,payment_status,is_cancelled,tokens,dispatched,dispatch_status,no_paid_transactions,payment_alt_mode,partial_payments_allowed,is_manual_payment");
		}
		if($excel==1)
		{
			$query1->select("id,order_number,subscription_mixed_order,order_type,date,user_id,transaction_id,total_price,paid,status,currency,payment_mode,payment_status,partial_payments_allowed");
		}
		$query1->where("user_id",$this->currentUser->id);
		$query1->from($this->tableName);
		$preData="Ashram: ";
		if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='')
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='')
		{
			$query1->where("ashram_id",$_POST['ashram_id']);
		}

		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode'] == "offline")
			{
				$query1->where_in("payment_alt_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
			}
			else
			{
				$query1->where("payment_alt_mode",$_POST['payment_mode']);
			}
			$preData.=ucfirst($_POST['payment_mode']);
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && $_POST['payment_status']!='')
		{
			$query1->where("payment_status",$_POST['payment_status']);

			if($_POST['payment_status']==0)
			{
				$preData.="Pending";
			}
			else if($_POST['payment_status']==1)
			{
				$preData.="Paid";
			}
			else if($_POST['payment_status']==2)
			{
				$preData.="Partially Paid";
			}
		}

		$preData.="\nToken Status:";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			if($_POST['tokens']==0)
			{
				$query1->where("tokens",0);
				$preData.="Tokens not issued";
			}
			else
			{
				$query1->where("tokens",1);
				$preData.="Tokens issued";
			}
		}
		else
		{
			$preData.=" All Token Status";
		}

		$preData.="\nNo Tx Sevas:";
		if(isset($_POST['no_tx_orders']) && $_POST['no_tx_orders'] != "" && in_array($_POST['no_tx_orders'],array("Yes","No")))
		{
			$query1->where("no_paid_transactions",$_POST['no_tx_orders']);
			$preData.=" No Paid Tx Sevas";
		}
		else
		{
			$preData.=" All Sevas";
		}

		$preData.="\nShipping Status:";
		if(isset($_POST['dispatched']) && is_numeric($_POST['dispatched']) && in_array($_POST['dispatched'],array(0,1)))
		{
			if($_POST['dispatched']==0)
			{
				$query1->where("dispatched",0);
				$preData.="Not dispatched";
			}
			else
			{
				$query1->where("dispatched",1);
				$preData.="Dispatched";
			}
		}

		$preData.="\nSeva Type:";
		if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3,4)))
		{
			if($_POST['order_type']==1)
			{
				$query1->where("order_type",1);
				$preData.=" Poojas";
			}
			else if($_POST['order_type']==2)
			{
				$query1->where("order_type",2);
				$preData.=" Donations";
			}
			else if($_POST['order_type']==4)
			{
				$query1->group_start();
				$query1->where("order_type",4);
				$query1->or_where("subscription_mixed_order",1);
				$query1->group_end();
				$preData.=" Subscriptions";
			}
			else
			{
				$query1->where("order_type",3);
				$preData.=" Store";
			}
		}
		else
		{
			$preData.=" All Seva Types";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"My Sevas",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$query1->group_by("currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
				$t_cur_total['total_'.strtolower($currencyData['currency']).'_records']=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
				$t_cur_total['total_'.strtolower($temp_row->currency).'_records']+=$temp_row->c;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('date',$dir);
		}
		else
		{
			$query1->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$c=0;
		$sno=$start+1;
		$ids=array();
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$ids[]=$row['id'];

			$sno++;
			$c++;
		}

		if(!empty($ids))
		{
			$this->db->select("sum(subscription) as has_subscription,id,order_id");
			$this->db->where_in("order_id",$ids);
			$this->db->from("order_items");
			$this->db->group_by("order_id");
			$oitems=array();
			foreach ($this->db->get()->result() as $key => $oitem)
			{
				$oitems[$oitem->order_id]=$oitem;
			}

			foreach ($rtn['data'] as $key => $row)
			//foreach ($oitems as $key => $oitem)
			{

				if(isset($oitems[$row['id']]) && $oitems[$row['id']]->has_subscription)
					$rtn['data'][$key]['subscription']=1;
				else 
					$rtn['data'][$key]['subscription']=0;
			}
		}

		return $rtn;
	}

	public function listUsernoTXSevas($excel=0)
	{

		if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='')
		{
			$ashramData=$this->ashrams_model->ashramData($_POST['ashram_id']);
		}
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(id) as c,sum(total_price) as total_sum,currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("id,order_number,order_type,subscription_mixed_order,date,user_id,username,transaction_id,total_price,paid,no_paid_transactions,total_paid,
			currency,status,ashram_id,payment_status,payment_mode,payment_alt_mode,tokens,dispatch_status,dispatched");
		}
		if($excel==1)
		{
			$query1->select("id,order_number,order_type,subscription_mixed_order,date,user_id,username,transaction_id,total_price,paid,no_paid_transactions,total_paid,
			currency,status,ashram_id,payment_status,payment_mode,payment_alt_mode,tokens,dispatch_status,dispatched");
		}
		$query1->where("user_id",$this->currentUser->id);
		$query1->where("no_paid_transactions","Yes");
		$query1->where("is_cancelled!=",1);
		$query1->from($this->tableName);
		$preData="Ashram: ";
		if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='')
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='')
		{
			$query1->where("ashram_id",$_POST['ashram_id']);
		}

		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode'] == "offline")
			{
				$query1->where_in("payment_alt_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
			}
			else
			{
				$query1->where("payment_alt_mode",$_POST['payment_mode']);
			}
			$preData.=ucfirst($_POST['payment_mode']);
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && $_POST['payment_status']!='')
		{
			$query1->where("payment_status",$_POST['payment_status']);

			if($_POST['payment_status']==0)
			{
				$preData.="Pending";
			}
			else if($_POST['payment_status']==1)
			{
				$preData.="Paid";
			}
			else if($_POST['payment_status']==2)
			{
				$preData.="Partially Paid";
			}
		}

		$preData.="\nToken Status:";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			if($_POST['tokens']==0)
			{
				$query1->where("tokens",0);
				$preData.="Tokens not issued";
			}
			else
			{
				$query1->where("tokens",1);
				$preData.="Tokens issued";
			}
		}
		else
		{
			$preData.=" All Token Status";
		}

		$preData.="\nShipping Status:";
		if(isset($_POST['dispatched']) && is_numeric($_POST['dispatched']) && in_array($_POST['dispatched'],array(0,1)))
		{
			if($_POST['dispatched']==0)
			{
				$query1->where("dispatched",0);
				$preData.="Not dispatched";
			}
			else
			{
				$query1->where("dispatched",1);
				$preData.="Dispatched";
			}
		}

		$preData.="\nSeva Type:";
		if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3,4)))
		{
			if($_POST['order_type']==1)
			{
				$query1->where("order_type",1);
				$preData.=" Poojas";
			}
			else if($_POST['order_type']==2)
			{
				$query1->where("order_type",2);
				$preData.=" Donations";
			}
			else if($_POST['order_type']==4)
			{
				$query1->group_start();
				$query1->where("order_type",4);
				$query1->or_where("subscription_mixed_order",1);
				$query1->group_end();
				$preData.=" Subscriptions";
			}
			else
			{
				$query1->where("order_type",3);
				$preData.=" Store";
			}
		}
		else
		{
			$preData.=" All Seva Types";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"My Failed Seva Payments",$preData,8);
			return $requestResp;
		}


		if($i==1)
		{
			$query1->group_by("currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('date',$dir);
		}
		else
		{
			$query1->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		$ids=array();
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$ids[]=$row['id'];
			$sno++;
			$c++;
		}

		if(!empty($ids))
		{
			$this->db->select("sum(subscription) as has_subscription,id,order_id");
			$this->db->where_in("order_id",$ids);
			$this->db->from("order_items");
			$this->db->group_by("order_id");
			$oitems=array();
			foreach ($this->db->get()->result() as $key => $oitem)
			{
				$oitems[$oitem->order_id]=$oitem;
			}

			foreach ($rtn['data'] as $key => $row)
			//foreach ($oitems as $key => $oitem)
			{

				if(isset($oitems[$row['id']]) && $oitems[$row['id']]->has_subscription)
					$rtn['data'][$key]['subscription']=1;
				else 
					$rtn['data'][$key]['subscription']=0;
			}
		}

		return $rtn;
	}

	public function listUserSubscriptions($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		if($this->session->userdata("subscription_categoryId"))
		{
			$categoryData = $this->poojas_categories_model->categoryData($this->session->userdata("subscription_categoryId"));
		}
		$countries=$this->locations_model->getCountries(true);
		$pets=$this->pets_model->getAll();

		$preData="";
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.order_number,o.subscription_mixed_order,o.user_id,o.transaction_id,o.order_type,o.date,o.total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_mode,o.payment_status,o.is_cancelled,o.address1,o.address2,o.address3,o.city,o.state,o.country,o.firstname,o.lastname,o.email,o.phone,o.tokens,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.id as oid,oi.price,
			oi.quantity,oi.schedule_dates,oi.order_id,oi.item_name,oi.family_member_details,oi.subscription,oi.id as oiid,oi.status as or_item_status,oi.pet_id,oi.assign_pet,pet_name");
		}
		if($excel==1)
		{
			$query1->select("o.order_number,o.subscription_mixed_order,o.transaction_id,o.order_type,o.date,o.user_id,username,o.total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_mode,o.payment_status,o.is_cancelled,o.paid_tx_ids,o.refunded_tx_ids,o.failed_tx_ids,o.cancelled_tx_ids,o.inprocess_tx_ids,o.bounced_tx_ids,o.payment_alt_mode,o.id as oid,oi.price,oi.quantity,oi.schedule_dates,oi.order_id,oi.item_name,oi.family_member_details,oi.id as oiid,oi.status as or_item_status,oi.num_of_payments,
			oi.paid_count,oi.pet_id,oi.assign_pet,pet.pet_name,oi.paid_amount");
		}
		$query1->where("o.user_id",$this->currentUser->id);
		
		$query1->group_start();
			$query1->where("o.order_type",2);
			$query1->or_where("o.order_type",4);
  		$query1->group_end();

		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		//$query1->join("donors as d",'d.id=oi.donor_id',"left");
		$query1->join("pets as pet",'pet.id=oi.pet_id',"left");
		$query1->where("oi.subscription",1);
		$query1->where("is_cancelled!=",1);

		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		if($this->session->userdata("subscription_categoryId"))
		{
			$preData.="\nCategory: ";
			$query1->where("oi.category",$this->session->userdata("subscription_categoryId"));
			$preData.=$categoryData->name;
		}else{
			$preData.="All categories";
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}
		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode'] == "offline")
			{
				$query1->like("payment_alt_mode","cash");
			}
			else
			{
				$query1->like("payment_alt_mode",$_POST['payment_mode']);
			}
			$preData.=ucfirst($_POST['payment_mode']);
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && $_POST['payment_status']!='' && in_array($_POST['payment_status'],array(0,1,2)))
		{
			if($_POST['payment_status']==0)
			{
				$preData.="Pending";
				$query1->where("oi.status",0);
			}
			else if($_POST['payment_status']==1)
			{
				$preData.="Fully Paid";
				$query1->where("oi.status",3);
			}
			else if($_POST['payment_status']==2)
			{
				$preData.="Partially Paid";
				$query1->where("oi.status",1);
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
		}

		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}
		$preData.="\nFrom Date: ";
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_POST['from_date']))."' ";
			$fromDateTime=strtotime($_POST['from_date']);
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_POST['to_date']))."'";
			$toDateTime=strtotime($_POST['to_date']);
			$preData.=$_POST['to_date'];
		}

		if((!isset($_POST['from_date']) || $_POST['from_date']=='') && (!isset($_POST['to_date']) || $_POST['to_date']==''))
		{
			$fromDateTime="0";
		}
		
		$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";

		$query1->where("oi.id in (".$sub_query.")");

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"My Subscriptions",$preData,6);
			return $requestResp;
		}

		if($i==1)
		{
			$query1->group_by("currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
				$t_cur_total['total_'.strtolower($currencyData['currency']).'_records']=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
				$t_cur_total['total_'.strtolower($temp_row->currency).'_records']+=$temp_row->c;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$payments=$this->transaction_model->getTransactionsByOrderItem($row['oiid'],1);
			//$payments=$this->subscription_payments_model->getAllByOrderItem($row['oiid']);
			$total_count=count($payments);

			$total_paid=0;
			$txids='';
			
			foreach ($payments as $key => $sub_payment)
			{
				if(in_array(strtolower($sub_payment->status),$this->payment_success_statuses) || $sub_payment->status=='inprocess')
				{
					$total_paid+=$sub_payment->amount;
					if($txids!='') $txids.=", ";
					$txids.=$sub_payment->tx;
				}
				else
				{
					unset($payments[$key]);
				}
			}
			//$rtn['data'][$c]['txids']=str_replace(",","<br>",$txids);

			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;

			$rtn['data'][$c]['total_paid']=strtoupper($rtn['data'][$c]['currency'])." ".$total_paid;
			$rtn['data'][$c]['trs']=$payments;
			$rtn['data'][$c]['txids']=$txids;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			// $rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".$rtn['data'][$c]['quantity'].")";
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$resultSubscriptionDates='';
			$donationDates=array_filter(explode(",",$rtn['data'][$c]['schedule_dates']));
			$rDates=array();
			foreach ($donationDates as $subscriptionDate)
			{
				
				$poojaDateTime=strtotime($subscriptionDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($subscriptionDate,$rDates))
					{
						$rDates[]=$subscriptionDate;
						if($resultSubscriptionDates!='') $resultSubscriptionDates.=", ";
						$resultSubscriptionDates.=$subscriptionDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($subscriptionDate,$rDates))
					{
						$rDates[]=$subscriptionDate;
						if($resultSubscriptionDates!='') $resultSubscriptionDates.=", ";
						$resultSubscriptionDates.=$subscriptionDate;
					}
				}
			}

			$result_dates=array_filter(explode(",",$resultSubscriptionDates));
			$rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".count($result_dates).")";
			if($row['quantity']>1)
			{
				$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];
				$sub_total_sum+=($row['price']*count($result_dates));

				$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
				$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*count($result_dates));
			}

			$rtn['data'][$c]['subscription_dates']=$resultSubscriptionDates;

			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
			$rtn['data'][$c]['family_details']=nl2br($row['family_member_details']);

			$address=$row['address1'];
			if($row['address2']!='')
				$address.="<br>".$row['address2'];
			if($row['address3']!='')
				$address.="<br>".$row['address3'];
			$address.="<br>".$row['city'];
			$address.="<br>".$row['state'];
			$address.="<br>".$row['country'];

			$rtn['data'][$c]['address']=$address;

			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	public function listUserPoojas($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		if($this->session->userdata("pooja_categoryId"))
		{
			$categoryData = $this->poojas_categories_model->categoryData($this->session->userdata("pooja_categoryId"));
		}
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.order_number,o.user_id,o.subscription_mixed_order,o.transaction_id,o.order_type,o.date,o.total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_mode,o.payment_status,o.is_cancelled,o.tokens,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.id as oid,oi.price,
			oi.quantity,oi.schedule_dates,oi.order_id,oi.item_name,oi.family_member_details");
		}
		if($excel==1)
		{
			$query1->select("o.order_number,o.subscription_mixed_order,o.transaction_id,o.order_type,o.date,o.user_id,username,o.total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_mode,o.payment_status,o.is_cancelled,o.payment_alt_mode,o.id as oid,oi.price,oi.quantity,oi.schedule_dates,oi.order_id,oi.item_name,oi.family_member_details");
		}
		$query1->where("o.order_type",1);
		$query1->where("user_id",$this->currentUser->id);
		$query1->where("payment_status!=",0);
		$query1->where("is_cancelled!=",1);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$preData="";
		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		if($this->session->userdata("pooja_categoryId"))
		{
			$preData.="\nCategory: ";
			$query1->where("oi.category",$this->session->userdata("pooja_categoryId"));
			$preData.=$categoryData->name;
		}else{
			$preData.="All categories";
		}
		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if($this->session->userdata("ashramId"))
		{
			$query1->where("ashram_id",$this->session->userdata("ashramId"));
		}
		
		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode'] == "offline")
				$query1->where_in("payment_alt_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
			else
				$query1->where("payment_alt_mode",$_POST['payment_mode']);

			$preData.=ucfirst($_POST['payment_mode']);
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && $_POST['payment_status']!='')
		{
			$query1->where("payment_status",$_POST['payment_status']);

			if($_POST['payment_status'] == 0)
				$preData.="Pending";

			if($_POST['payment_status'] == 1)
				$preData.="Paid";

			if($_POST['payment_status'] == 2)
				$preData.="Partially Paid";
		}
		
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';

		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_POST['from_date']))."' ";
			$fromDateTime=strtotime($_POST['from_date']);
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_POST['to_date']))."'";
			$toDateTime=strtotime($_POST['to_date']);
		}
		
		if((!isset($_POST['from_date']) || $_POST['from_date']=='') && (!isset($_POST['to_date']) || $_POST['to_date']==''))
		{
			$fromDateTime="0";
		}

		if($fromDateTime)
			$preData.="\nFrom Date ".date("d M Y",$fromDateTime);
		else
			$preData.="\nFrom Date ".date("d M Y");

		if($toDateTime)
			$preData.="\nTo Date ".date("d M Y",$toDateTime);
		else
			$preData.="\nTo Date ".date("d M Y");

		$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";

		$query1->where("oi.id in (".$sub_query.")");

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"My Poojas",$preData,2);
			return $requestResp;
		}



		if($i==1)
		{
			$query1->group_by("currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
				$t_cur_total['total_'.strtolower($currencyData['currency']).'_records']=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
				$t_cur_total['total_'.strtolower($temp_row->currency).'_records']+=$temp_row->c;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			// $rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".$rtn['data'][$c]['quantity'].")";
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$resultPoojaDates='';
			if(in_array($rtn['data'][$c]['payment_alt_mode'], array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc')))
			{
				$rtn['data'][$c]['payment_alt_mode'] = "Offline";
			}
			else
			{
				$rtn['data'][$c]['payment_alt_mode'] = $rtn['data'][$c]['payment_alt_mode'];
			}
			$rtn['data'][$c]['payment_alt_mode']=ucfirst($rtn['data'][$c]['payment_alt_mode']);
			$poojaDates=array_filter(explode(",",$rtn['data'][$c]['schedule_dates']));
			$rDates=array();
			foreach ($poojaDates as $poojaDate)
			{
				
				$poojaDateTime=strtotime($poojaDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=", ";
						$resultPoojaDates.=$poojaDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=", ";
						$resultPoojaDates.=$poojaDate;
					}
				}
			}
			$result_dates=array_filter(explode(",",$resultPoojaDates));
			$rtn['data'][$c]['pooja_dates']=$resultPoojaDates;
			$rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".count($result_dates).")";
			if($row['quantity']>1)
			{
				$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];
				$sub_total_sum+=($row['price']*count($result_dates));

				$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
				$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*count($result_dates));
			}

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	public function listUserDonations($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		if($this->session->userdata("donation_categoryId"))
		{
			$categoryData = $this->poojas_categories_model->categoryData($this->session->userdata("donation_categoryId"));
		}
		//getting group Data
		if($this->session->userdata("groupId"))
		{
			$groupData = $this->donations_groups_model->groupData($this->session->userdata("groupId"));
		}
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.order_number,o.user_id,o.subscription_mixed_order,o.transaction_id,o.order_type,o.date,o.total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_mode,o.payment_status,o.is_cancelled,o.tokens,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.id as oid,oi.price,
			oi.quantity,oi.schedule_dates,oi.order_id,oi.item_name,oi.family_member_details,oi.subscription");
		}
		if($excel==1)
		{
			$query1->select("o.order_number,o.subscription_mixed_order,o.transaction_id,o.order_type,o.date,o.user_id,username,o.total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_mode,o.payment_status,o.is_cancelled,o.payment_alt_mode,o.id as oid,oi.price,oi.quantity,oi.schedule_dates,oi.order_id,oi.item_name,oi.family_member_details");
		}
		$query1->where("o.order_type",2);
		$query1->where("payment_status!=",0);
		$query1->where("is_cancelled!=",1);
		$query1->where("user_id",$this->currentUser->id);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		if($this->session->userdata("groupId")) {
			$query1->join("donations as d",'oi.item_id = d.id');
		}
		$preData="";
		$query1->where("oi.subscription",0);
		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		if($this->session->userdata("donation_categoryId"))
		{
			$preData.="\nCategory: ";
			$query1->where("oi.category",$this->session->userdata("donation_categoryId"));
			$preData.=$categoryData->name;
		}else{
			$preData.="All categories";
		}
		if($this->session->userdata("groupId"))
		{
			$preData.="\nGroup: ";
			$query1->where("d.group_id",$this->session->userdata("groupId"));
			$preData.=$groupData->name;
		}else{
			$preData.="All Groups";
		}

		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}
		
		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
		}

		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode'] == "offline")
				$query1->where_in("payment_alt_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
			else
				$query1->where("payment_alt_mode",$_POST['payment_mode']);

			$preData.=ucfirst($_POST['payment_mode']);
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && $_POST['payment_status']!='')
		{
			$query1->where("payment_status",$_POST['payment_status']);

			if($_POST['payment_status'] == 0)
				$preData.="Pending";

			if($_POST['payment_status'] == 1)
				$preData.="Paid";

			if($_POST['payment_status'] == 2)
				$preData.="Partially Paid";
		}

		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_POST['from_date']))."' ";
			$fromDateTime=strtotime($_POST['from_date']);
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_POST['to_date']))."'";
			$toDateTime=strtotime($_POST['to_date']);
		}

		if((!isset($_POST['from_date']) || $_POST['from_date']=='') && (!isset($_POST['to_date']) || $_POST['to_date']==''))
		{
			$fromDateTime="0";
		}

		if($fromDateTime)
			$preData.="\nFrom Date ".date("d M Y",$fromDateTime);
		else
			$preData.="\nFrom Date ".date("d M Y");

		if($toDateTime)
			$preData.="\nTo Date ".date("d M Y",$toDateTime);
		else
			$preData.="\nTo Date ".date("d M Y");

		$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";

		$query1->where("oi.id in (".$sub_query.")");

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"My Donations",$preData,3);
			return $requestResp;
		}

		if($i==1)
		{
			$query1->group_by("currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
				$t_cur_total['total_'.strtolower($currencyData['currency']).'_records']=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
				$t_cur_total['total_'.strtolower($temp_row->currency).'_records']+=$temp_row->c;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;

			/*$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;*/
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			// $rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".$rtn['data'][$c]['quantity'].")";
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			if(in_array($rtn['data'][$c]['payment_alt_mode'], array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc')))
			{
				$rtn['data'][$c]['payment_alt_mode'] = "Offline";
			}
			else
			{
				$rtn['data'][$c]['payment_alt_mode'] = $rtn['data'][$c]['payment_alt_mode'];
			}
			$rtn['data'][$c]['payment_alt_mode']=ucfirst($rtn['data'][$c]['payment_alt_mode']);
			$resultDonationDates='';
			$donationDates=array_filter(explode(",",$rtn['data'][$c]['schedule_dates']));
			$rDates=array();
			foreach ($donationDates as $donationDate)
			{
				
				$poojaDateTime=strtotime($donationDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=", ";
						$resultDonationDates.=$donationDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=", ";
						$resultDonationDates.=$donationDate;
					}
				}
			}

			$result_dates=array_filter(explode(",",$resultDonationDates));
			$rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".count($result_dates).")";
			if($row['quantity']>1)
			{
				$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];
				$sub_total_sum+=($row['price']*count($result_dates));

				$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
				$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*count($result_dates));
			}
			$rtn['data'][$c]['donation_dates']=$resultDonationDates;
			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}

	public function listUserStore($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		if($this->session->userdata("store_categoryId"))
		{
			$categoryData = $this->store_categories_model->categoryData($this->session->userdata("store_categoryId"));
		}
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(o.id) as c,sum(price) as total_sum,o.currency as currency");
		}

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("o.order_number,o.user_id,o.subscription_mixed_order,o.transaction_id,o.order_type,o.date,o.total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_mode,o.payment_status,o.is_cancelled,o.tokens,o.dispatch_status,o.no_paid_transactions,o.payment_alt_mode,o.partial_payments_allowed,o.is_manual_payment,o.id as oid,oi.price,
			oi.quantity,oi.schedule_dates,oi.order_id,oi.item_name,oi.family_member_details,oi.shipping_price");
		}
		if($excel==1)
		{
			$query1->select("o.order_number,o.subscription_mixed_order,o.transaction_id,o.order_type,o.date,o.user_id,username,o.total_price,o.paid,o.total_paid,o.status,o.ashram_id,
			o.currency,o.payment_mode,o.payment_status,o.is_cancelled,o.payment_alt_mode,o.id as oid,oi.price,oi.quantity,oi.schedule_dates,oi.order_id,oi.item_name,oi.shipping_price
			,oi.shipping,oi.shipping_address1,oi.shipping_address2,oi.shipping_address3,oi.shipping_city,oi.shipping_state,oi.shipping_country_name,oi.gift_friend_name,oi.gift_friend_email");
		}
		$query1->where("o.order_type",3);
		$query1->where("payment_status!=",0);
		$query1->where("is_cancelled!=",1);
		$query1->where("user_id",$this->currentUser->id);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$preData="";
		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		if($this->session->userdata("store_categoryId"))
		{
			$preData.="\nCategory: ";
			$query1->where("oi.category",$this->session->userdata("store_categoryId"));
			$preData.=$categoryData->name;
		}else{
			$preData.="All categories";
		}
		$preData.="\nToken Status: ";
		if(isset($_POST['tokens']) && is_numeric($_POST['tokens']) && in_array($_POST['tokens'],array(0,1)))
		{
			$query1->where("tokens",$_POST['tokens']);
			if($_POST['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}
		
		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if($this->session->userdata("ashramId"))
		{
			$query1->where("ashram_id",$this->session->userdata("ashramId"));
		}


		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode'] == "offline")
				$query1->where_in("payment_alt_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
			else
				$query1->where("payment_alt_mode",$_POST['payment_mode']);

			$preData.=ucfirst($_POST['payment_mode']);
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && $_POST['payment_status']!='')
		{
			$query1->where("payment_status",$_POST['payment_status']);

			if($_POST['payment_status'] == 0)
				$preData.="Pending";

			if($_POST['payment_status'] == 1)
				$preData.="Paid";

			if($_POST['payment_status'] == 2)
				$preData.="Partially Paid";
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(date) >=",date("Y:m:d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(date) <=",date("Y:m:d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"My Store Items",$preData,4);
			return $requestResp;
		}

		if($i==1)
		{
			$query1->group_by("currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$t_cur_total[strtolower($currencyData['currency'])]=0;
				$t_cur_total['total_'.strtolower($currencyData['currency']).'_records']=0;
			}
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total[strtolower($temp_row->currency)]+=$temp_row->total_sum;
				$t_cur_total['total_'.strtolower($temp_row->currency).'_records']+=$temp_row->c;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			$rtn['total_sum'] = $t_cur_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('o.date',$dir);
		}
		else
		{
			$query1->order_by('o.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".($rtn['data'][$c]['price']*$rtn['data'][$c]['quantity']);
			$rtn['data'][$c]['item_price_quantity']= "(".strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['price']." x ".$rtn['data'][$c]['quantity'].")";
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['total_price'];
			$rtn['data'][$c]['payment_alt_mode']=ucfirst($rtn['data'][$c]['payment_alt_mode']);

			if($row['quantity']>1)
			{
				$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];
				$sub_total_sum+=($row['price']*$row['quantity']);

				$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
				$rtn['data'][$c]['item_price']=strtoupper($rtn['data'][$c]['currency'])." ".(($rtn['data'][$c]['price']*$row['quantity'])+$rtn['data'][$c]['shipping_price']);
			}
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function getAshramsByCurrencyAndYear($currency_segment, $year_segment, $trust_basic_id="")
	{
		$ashrams = [];
		$reports_db=$this->load->database("reports",true,false);
		$query1=$reports_db;
		$i=0;
		$tableName = "";
		if(isset($currency_segment) && $currency_segment!='' && isset($year_segment) && $year_segment!='')
		{
			if($currency_segment=='inr')
			{
				$tableName = "tx_report_".$currency_segment."_".strtolower(str_replace("-","_",$year_segment));
			}
			else
			{
				$tableName = "tx_report_".$currency_segment."_".$year_segment;
			}
		}
		if($reports_db->table_exists($tableName))
		{
			$trustids = [];
			if($trust_basic_id>0)
			{
				$this->db->select("GROUP_CONCAT(DISTINCT id SEPARATOR ',') as trust_ids");
				$this->db->from('ashrams_trust_accounts');
				$this->db->where("trust_basic_id",$trust_basic_id);
				$trustidstr=$this->db->get()->row_array();
				if(isset($trustidstr['trust_ids']) && $trustidstr['trust_ids']!='')
				{
					$trustids = explode(',', $trustidstr['trust_ids']);
				}
			}

			$query1->select("GROUP_CONCAT(DISTINCT ashram_id SEPARATOR ',') as ashram_ids");
			$query1->from($tableName);
			$query1->where("user_id",$this->currentUser->id);
			$query1->where("order_type !=",3);
			if($trust_basic_id>0 && count($trustids)>0)
			{
				$query1->where_in('trust_id',$trustids);
			}
			$ashramsids=$query1->get()->row_array();

			if(isset($ashramsids['ashram_ids']) && $ashramsids['ashram_ids']!='')
			{
				$ashramsids = explode(',', $ashramsids['ashram_ids']);
				$this->db->select("*");
				$this->db->order_by("sort_order",'asc');
				$this->db->where_in('id',$ashramsids);
				$q=$this->db->get('ashrams');
				$ashrams=$q->result();
			}
		}
		return $ashrams;
	}

	public function getTrustsByCurrencyAndYear($currency_segment, $year_segment)
	{
		$trusts = [];
		$reports_db=$this->load->database("reports",true,false);
		$query1=$reports_db;
		$i=0;
		$tableName = "";
		if(isset($currency_segment) && $currency_segment!='' && isset($year_segment) && $year_segment!='')
		{
			if($currency_segment=='inr')
			{
				$tableName = "tx_report_".$currency_segment."_".strtolower(str_replace("-","_",$year_segment));
			}
			else
			{
				$tableName = "tx_report_".$currency_segment."_".$year_segment;
			}
		}
		if($reports_db->table_exists($tableName))
		{
			$query1->select("GROUP_CONCAT(DISTINCT trust_id SEPARATOR ',') as trust_ids");
			$query1->from($tableName);
			$query1->where("user_id",$this->currentUser->id);
			$query1->where("order_type !=",3);
			$query1->where("trust_id !=",0);
			$trustids=$query1->get()->row_array();

			if(isset($trustids['trust_ids']) && $trustids['trust_ids']!='')
			{
				$trustids = explode(',', $trustids['trust_ids']);
				$this->db->select("tbd.trust_basic_id,tbd.trust_name");
				$this->db->where_in('ata.id',$trustids);
				$this->db->from("trust_basic_details as tbd");
				$this->db->join("ashrams_trust_accounts as ata","ata.trust_basic_id=tbd.trust_basic_id","INNER");
				$this->db->group_by('tbd.trust_basic_id');
				$items=$this->db->get();
				$trusts=$items->result();
			}
		}
		return $trusts;
	}

	public function listUserSummary($excel=0)
	{
		$reports_db=$this->load->database("reports",true,false);
		$i=0;
		$tableName = "";
		if(isset($_POST['currency']) && $_POST['currency']!='' && isset($_POST['year']) && $_POST['year']!='')
		{
			if($_POST['currency']=='inr')
			{
				$tableName = "tx_report_".$_POST['currency']."_".strtolower(str_replace("-","_",$_POST['year']));
			}
			else
			{
				$tableName = "tx_report_".$_POST['currency']."_".$_POST['year'];
			}
		}

		$trust_ids = [];
		if(isset($_POST['trust_basic_id']) && $_POST['trust_basic_id']>0)
		{
			$this->db->select("GROUP_CONCAT(DISTINCT id SEPARATOR ',') as trust_ids");
			$this->db->from("ashrams_trust_accounts");
			$this->db->where("trust_basic_id",$_POST['trust_basic_id']);
			$trustids=$this->db->get()->row_array();

			if(isset($trustids['trust_ids']) && $trustids['trust_ids']!='')
			{
				$trust_ids = explode(',', $trustids['trust_ids']);
			}
		}

		
		if ($reports_db->table_exists($tableName) )
		{
		  // table exists some code run query
		}
		else
		{
		  	$rtn['data'] = [];
			$rtn['recordsTotal'] = 0;
			$rtn['recordsFiltered'] = 0;
			goto stepNoResults;
		}
		if(isset($_POST['ashram']) && is_numeric($_POST['ashram']))
		{
			$ashramData=$this->ashrams_model->ashramData($_POST['ashram']);
		}

		$query1=$reports_db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->where("user_id",$this->currentUser->id);
		$query1->where("order_type !=",3);

		if(isset($_POST['trust_basic_id']) && $_POST['trust_basic_id']>0 && count($trust_ids)>0)
		{
			$query1->where_in('trust_id',$trust_ids);
		}

		// $query1->from("transaction_report");
		$query1->from($tableName);
		
		$preData="Ashram: ";
		if(isset($_POST['ashram']) && is_numeric($_POST['ashram']))
		{
			$query1->where("ashram_id",$_POST['ashram']);
			$preData="Ashram Name: ".$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		$yearDisplayText = "";
		$yearDisplayTextWithTo = "";
		$preData.="\nYear: ";
		if($_POST['currency']=='inr')
		{
			$yearsplits = explode('_to_', $_POST['year']);
			if(isset($yearsplits[0]) && $yearsplits[0]!='')
			{
				$preData.= date("jS M Y",strtotime($yearsplits[0]));
				$yearDisplayText.= date("jS M Y",strtotime($yearsplits[0]));
				$yearDisplayTextWithTo.= date("jS M Y",strtotime($yearsplits[0]));
			}
			if(isset($yearsplits[1]) && $yearsplits[1]!='')
			{
				$preData.= " to ".date("jS M Y",strtotime($yearsplits[1]));
				$yearDisplayText.= " - ".date("jS M Y",strtotime($yearsplits[1]));
				$yearDisplayTextWithTo.= " to ".date("jS M Y",strtotime($yearsplits[1]));
			}		
		}
		else
		{
			if(isset($_POST['year']) && is_numeric($_POST['year']) && $_POST['year']<=date("Y") && $_POST['year']>=2015)
			{
				$query1->where("YEAR(transaction_date)",$_POST['year']);
				$preData.=$_POST['year'];
			}
			else
			{
				$query1->where("YEAR(transaction_date)",0);
			}
			$yearDisplayText = $_POST['year'];
			$yearDisplayTextWithTo = $_POST['year'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('order_date',$_POST['dir']);
				else
					$query1->order_by('order_date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"reports",$_POST,"year_end_donations_statement_".$_POST['currency'],$preData,5);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order_date',$dir);
		}
		else
		{
			$query1->order_by('order_date',$dir);
		}

		//$query1->order_by('order_date','desc');
		
		$rtn['data']=$query1->get()->result_array();

		stepNoResults:
		$c=0;
		$sno=1;
		$price=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['transaction_date']));
			$rtn['data'][$c]['order_date']=date("d M Y",strtotime($rtn['data'][$c]['order_date']));
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['amount'];
			$rtn['data'][$c]['item']=str_replace(" ,","<br>",$row['item']);
			$rtn['data'][$c]['source_of_payment']="Offline";
			$srcc_payment_mode = strtolower($rtn['data'][$c]['payment_mode']);
			if($srcc_payment_mode == "paypal" || $srcc_payment_mode == "payu" || $srcc_payment_mode == "razorpay" || $srcc_payment_mode == "authorize.net" || $srcc_payment_mode == "stripe")
			{
				$rtn['data'][$c]['source_of_payment']="Online";
			}
			$rtn['data'][$c]['ashram_name'] = "";
			$ashramDataa = $this->ashrams_model->ashramData($rtn['data'][$c]['ashram_id']);
			if(isset($ashramDataa->name))
			{
				$rtn['data'][$c]['ashram_name'] = $ashramDataa->name;
			}
			$rtn['data'][$c]['payment_mode']=ucfirst($row['payment_mode']);
			$price+=$row['amount'];
			$sno++;
			$c++;
		}
		$rtn['total_price']=strtoupper($_POST['currency'])." ".$price;
		$rtn['total_price_in_words']= '('.strtoupper($_POST['currency'])." ".$this->general_model->amountToWords($price).')';
		$rtn['ashram_address']= '';
		$rtn['ashram_year_end_statement_text'] = '';
		if(strtolower($_POST['currency'])=='inr')
		{
			$rtn['ashram_year_end_statement_logo'] = '<img src="'.aws_s3_base_url.'images/site_assets/global_site_images/others/dattapeetham_logo.jpg" style="width: 70px;">';
		}
		else
		{
            if(global_site_flag==4)
            {
                $rtn['ashram_year_end_statement_logo'] = '<img src="'.aws_s3_base_url.'images/site_assets/global_site_images/others/yogasangeeta-logo.png" style="width: 85px;">';
            } else {
                $rtn['ashram_year_end_statement_logo'] = '<img src="'.aws_s3_base_url.'images/site_assets/global_site_images/others/dycusa-logo.png" style="width: 85px;">';
            }
		}
		$rtn['ashram80g']= '';
		$rtn['year_display_text'] = $yearDisplayText;
		$rtn['year_display_text_with_to'] = $yearDisplayTextWithTo;
		if(isset($_POST['ashram']) && is_numeric($_POST['ashram']))
		{
			if(isset($ashramData->year_end_statement_text_usd) && strtolower($_POST['currency'])=='usd')
			{
				$rtn['ashram_year_end_statement_text'] = $ashramData->year_end_statement_text_usd;
			}
			if(isset($ashramData->year_end_statement_text_inr) && strtolower($_POST['currency'])=='inr')
			{
				$rtn['ashram_year_end_statement_text'] = $ashramData->year_end_statement_text_inr;
			}

			if(isset($ashramData->year_end_statement_image_usd) && strtolower($_POST['currency'])=='usd')
			{
				$rtn['ashram_year_end_statement_logo'] = $ashramData->year_end_statement_image_usd;
			}
			if(isset($ashramData->year_end_statement_image_inr) && $ashramData->year_end_statement_image_inr!="" && strtolower($_POST['currency'])=='inr')
			{
				$rtn['ashram_year_end_statement_logo'] = '<img src="'.aws_s3_base_url.'images/ashrams/ashram_images/'.$ashramData->year_end_statement_image_inr.'" style="width: 70px;">';;
			}

			if(isset($ashramData->year_end_statement_image_usd) && $ashramData->year_end_statement_image_usd!="" && strtolower($_POST['currency'])=='usd')
			{
				$rtn['ashram_year_end_statement_logo'] = '<img src="'.aws_s3_base_url.'images/ashrams/ashram_images/'.$ashramData->year_end_statement_image_usd.'" style="width: 70px;">';;
			}


			if(isset($ashramData->trust_name_inr) && strtolower($_POST['currency'])=='inr')
			{
				$rtn['ashram_address'] = $ashramData->trust_name_inr;
			}
			if(isset($ashramData->trust_name_usd) && strtolower($_POST['currency'])=='usd')
			{
				$rtn['ashram_address'] = $ashramData->trust_name_usd;
			}
			if(isset($ashramData->trust_address_inr) && strtolower($_POST['currency'])=='inr')
			{
				$rtn['ashram_address'] = $rtn['ashram_address'].'<br>'.nl2br(htmlentities($ashramData->trust_address_inr));
			}
			if(isset($ashramData->trust_address_usd) && strtolower($_POST['currency'])=='usd')
			{
				$rtn['ashram_address'] = $rtn['ashram_address'].'<br>'.nl2br(htmlentities($ashramData->trust_address_usd));
			}
			// if(isset($ashramData->address))
			// {
			// 	$rtn['ashram_address'] = nl2br(htmlentities($ashramData->address));
			// }
			$ashram80gs = $this->ashrams_model->getAshram80gByAshramIdAndYear($_POST['ashram'], $_POST['year']);
			if(isset($ashram80gs->ashram_80g_note) && $ashram80gs->ashram_80g_note!="")
			{
				$rtn['ashram80g'] = $ashram80gs->ashram_80g_note;
			}
			else
			{
				$rtn['ashram80g'] = '80G tax deduction benefits are NOT available for '.$ashramData->name;
			}
		}
		$rtn['trustBasicData'] = "";
		$rtn['trustBasic80gData'] = "";
		$rtn['trust_address_with_name'] = "";
		$rtn['trust_logo_url'] = aws_s3_base_url."images/site_assets/global_site_images/others/dattapeetham_logo.jpg";
		$rtn['trust_logo_url'] = '<img src="'.aws_s3_base_url.'images/site_assets/global_site_images/others/dattapeetham_logo.jpg" style="width: 70px;">';
		if(isset($_POST['trust_basic_id']) && $_POST['trust_basic_id']>0)
		{
			$rtn['trustBasicData']=$this->ashrams_trust_accounts_model->trustBasicDataById($_POST['trust_basic_id']);
			$rtn['trustBasic80gData']=$this->ashrams_trust_accounts_model->getTrust80gByTrustIdAndYear($_POST['trust_basic_id'], $_POST['year']);
			
			if(isset($rtn['trustBasicData']->trust_name) && $rtn['trustBasicData']->trust_name!="")
            {
                $rtn['trust_address_with_name'] .= nl2br(htmlentities($rtn['trustBasicData']->trust_name ?? "") ?? "")."<br>";
            }
            if(isset($rtn['trustBasicData']->address) && $rtn['trustBasicData']->address!="")
            {
                $rtn['trust_address_with_name'] .= nl2br(htmlentities($rtn['trustBasicData']->address ?? "") ?? "");
            }
            if(isset($rtn['trustBasicData']->logo) && $rtn['trustBasicData']->logo!="")
            {
            	$rtn['trust_logo_url'] = '<img src="'.aws_s3_base_url.'images/trusts/trust_images/'.$rtn['trustBasicData']->logo.'" style="width: 70px;">';
            }
		}
		return $rtn;
	}


	public function createNewTransactionReportTable($tableName='')
	{
		if($tableName!='')
		{
			$reports_db=$this->load->database("reports",true,false);
			if ($reports_db->table_exists($tableName) )
			{
			  // table exists some code run query
			}
			else
			{
				// echo 'Request for New Table '.$tableName.'<br>';
				$new_table = "CREATE TABLE IF NOT EXISTS `".$tableName."` (
					  			`id` int(11) NOT NULL AUTO_INCREMENT,
						  		`order_id` int(11) NOT NULL,
						  		`ashram_id` int(11) NOT NULL,
						  		`trust_id` int(11) NOT NULL,
							  	`order_item_id` int(11) DEFAULT NULL,
								`order_number` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
								`order_date` datetime NOT NULL,
								`tx` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
								`item` text COLLATE utf8mb4_unicode_ci NOT NULL,
								`transaction_date` datetime NOT NULL,
								`amount` int(11) NOT NULL,
								`currency` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
								`order_type` int(11) NOT NULL,
								`payment_mode` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`user_id` int(11) NOT NULL,
								`username` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`email` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`address_line_1` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`address_line_2` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`address_line_3` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`city` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`state` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`country` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`country_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`zip` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								`created_by` int(11) NOT NULL,
								`created_on` datetime NOT NULL,
								`modified_on` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
						  		PRIMARY KEY (`id`)
								) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
				$reports_db->query($new_table);
				// echo 'New Table Created '.$tableName.'<br>';
			}
		}
	}

	public function populateTransactionReport()
	{ 
		ini_set('max_execution_time', 0);
		$years = ['2015','2016','2017','2018','2019','2020','2021'];
		foreach($years as $thisYear)
		{
			echo "Started Year end statement CRON for the year ".$thisYear."\n";

			$this->logaction->log("system","Year end statement CRON initiated for the year ".$thisYear);
			$this->db->select("t.order_id,t.ashram_id,t.trust_id, o.order_number, o.date as order_date, t.tx as transaction_id, t.created_on as transaction_created_on, t.amount, t.currency, o.order_type, t.payment_mode, o.user_id, o.username, CONCAT(IFNULL(o.firstname,''),' ',IFNULL(o.middlename,''),' ',IFNULL(o.lastname,'')) as name, o.email, o.address1 as address_line_1, o.address2 as address_line_2, o.address3 as address_line_3, o.city, o.state, o.country_name as country, o.country as country_code,o.zipcode as zip, o.created_by, GROUP_CONCAT(oi.id) as item_ids, GROUP_CONCAT(oi.item_name) as item_names,t.subscription");
	        $this->db->from("transaction as t");
	        $this->db->join("orders as o",'o.id=t.order_id',"inner");
	        $this->db->join("order_items as oi",'oi.order_id=o.id',"left");
	        $this->db->where_in("t.status",array("completed",'success','release payment','approved','captured','paid','Release Payment','Success'));
	        $this->db->where("t.amount>",0);
	        $this->db->where("t.currency!=","");
	        $this->db->where("t.tx!=","");
	        $this->db->where("t.tx!=",NULL);
	        $this->db->where("YEAR(t.created_on)",$thisYear);
	        $this->db->group_by('t.id');
	        $this->db->order_by('t.id');
			$transactionResults = $this->db->get()->result();
			// echo '<pre>'; print_r($transactionResults); die();
			$reports_db=$this->load->database("reports",true,false);

			$countries=$this->locations_model->getCountries(true);

			foreach ($transactionResults as $tx_record)
	        {
	        	if($tx_record->order_id)
	            {
	            	if(strtolower($tx_record->currency)=='inr')
	            	{
	            		$tableName = "tx_report_inr_";
	            		$monthOfCreated = date("m",strtotime($tx_record->transaction_created_on));
	            		$yearOfCreated = date("Y",strtotime($tx_record->transaction_created_on));
	            		if($monthOfCreated>=4)
	            		{
	            			$tableName .= $yearOfCreated."-".financial_year_start_month_date;
	                        $tableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
	            		}
	            		else
	            		{
	            			$tableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
	                        $tableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
	            		}
	            		
	            	}
	            	else
	            	{
	            		$tableName = "tx_report_usd_".date("Y",strtotime($tx_record->transaction_created_on));
	            	}

	            	$tableName = str_replace("-","_",$tableName);
	            	if($reports_db->table_exists($tableName) )
					{
					  // table exists some code run query
					}
					else
					{
	            		$this->createNewTransactionReportTable($tableName);
	            	}

	            	$countryName = "";
	            	if(isset($countries[$tx_record->country]->country_name))
	            	{
	            		$countryName = $countries[$tx_record->country]->country_name;
	            	}

	            	$reports_db->where("tx",$tx_record->transaction_id);
	                $record_exist=$reports_db->get($tableName)->num_rows();
	                
	                if($record_exist)
	                {
	                    continue;
	                }

	        	 	$insertData=array(
	                                    "order_id" => $tx_record->order_id,
										"ashram_id" => $tx_record->ashram_id,
										"trust_id" => $tx_record->trust_id,
										"order_item_id" => $tx_record->item_ids,
										"order_number" => $tx_record->order_number,
										"order_date" => $tx_record->order_date,
										"tx" => $tx_record->transaction_id,
										"item" => $tx_record->item_names,
										"transaction_date" => $tx_record->transaction_created_on,
										"amount" => $tx_record->amount,
										"currency" => $tx_record->currency,
										"order_type" => $tx_record->order_type,
										"payment_mode" => $tx_record->payment_mode,
										"user_id" => $tx_record->user_id,
										"username" => $tx_record->username,
										"name" => $tx_record->name,
										"email" => $tx_record->email,
										"address_line_1" => $tx_record->address_line_1,
										"address_line_2" => $tx_record->address_line_2,
										"address_line_3" => $tx_record->address_line_3,
										"city" => $tx_record->city,
										"state" => $tx_record->state,
										"country" => $countryName,
										"country_code" => $tx_record->country_code,
										"zip" => $tx_record->zip,
										"created_by" => $tx_record->created_by,
	                                    "created_on"=>date("Y:m:d H:i:s")
	                                );
	                $reports_db->insert($tableName,$insertData);
	            }
	        }
	        $this->logaction->log("system","Year end statement CRON completed for the year ".$thisYear);
	        echo "Year end statement CRON completed for the year ".$thisYear."\n\n\n";
	    }
	}

	public function populateYesterdayTransactionReport()
	{ 
		ini_set('max_execution_time', 0);
		$yesterdayDate = date('Y-m-d',strtotime("-1 days"));
		// echo '<pre>'; print_r($yesterdayDate); die();
		$this->logaction->log("system","Year end statement CRON initiated for the day ".$yesterdayDate);
		$this->db->select("t.order_id,t.ashram_id,t.trust_id, o.order_number, o.date as order_date, t.tx as transaction_id, t.created_on as transaction_created_on, t.amount, t.currency, o.order_type, t.payment_mode, o.user_id, o.username, CONCAT(IFNULL(o.firstname,''),' ',IFNULL(o.middlename,''),' ',IFNULL(o.lastname,'')) as name, o.email, o.address1 as address_line_1, o.address2 as address_line_2, o.address3 as address_line_3, o.city, o.state, o.country_name as country, o.country as country_code,o.zipcode as zip, o.created_by, GROUP_CONCAT(oi.id) as item_ids, GROUP_CONCAT(oi.item_name) as item_names,t.subscription");
        $this->db->from("transaction as t");
        $this->db->join("orders as o",'o.id=t.order_id',"inner");
        $this->db->join("order_items as oi",'oi.order_id=o.id',"left");
        $this->db->where_in("t.status",array("completed",'success','release payment','approved','captured','paid','Release Payment','Success'));
        $this->db->where("t.amount>",0);
        $this->db->where("t.currency!=","");
        $this->db->where("t.tx!=","");
        $this->db->where("t.tx!=",NULL);
        $this->db->where("DATE(t.created_on)",$yesterdayDate);
        $this->db->group_by('t.id');
        $this->db->order_by('t.id');
		$transactionResults = $this->db->get()->result();
		// echo '<pre>'; print_r($transactionResults); die();
		$reports_db=$this->load->database("reports",true,false);

		$countries=$this->locations_model->getCountries(true);

		foreach ($transactionResults as $tx_record)
        {
        	if($tx_record->order_id)
            {
            	if(strtolower($tx_record->currency)=='inr')
            	{
            		$tableName = "tx_report_inr_";
            		$monthOfCreated = date("m",strtotime($tx_record->transaction_created_on));
            		$yearOfCreated = date("Y",strtotime($tx_record->transaction_created_on));
            		if($monthOfCreated>=4)
            		{
            			$tableName .= $yearOfCreated."-".financial_year_start_month_date;
                        $tableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
            		}
            		else
            		{
            			$tableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
                        $tableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
            		}
            		
            	}
            	else
            	{
            		$tableName = "tx_report_usd_".date("Y",strtotime($tx_record->transaction_created_on));
            	}

            	$tableName = str_replace("-","_",$tableName);
            	if($reports_db->table_exists($tableName) )
				{
				  // table exists some code run query
				}
				else
				{
            		$this->createNewTransactionReportTable($tableName);
            	}

            	$countryName = "";
            	if(isset($countries[$tx_record->country]->country_name))
            	{
            		$countryName = $countries[$tx_record->country]->country_name;
            	}

            	$reports_db->where("tx",$tx_record->transaction_id);
                $record_exist=$reports_db->get($tableName)->num_rows();
                
                if($record_exist)
                {
                    continue;
                }

        	 	$insertData=array(
                                    "order_id" => $tx_record->order_id,
									"ashram_id" => $tx_record->ashram_id,
									"trust_id" => $tx_record->trust_id,
									"order_item_id" => $tx_record->item_ids,
									"order_number" => $tx_record->order_number,
									"order_date" => $tx_record->order_date,
									"tx" => $tx_record->transaction_id,
									"item" => $tx_record->item_names,
									"transaction_date" => $tx_record->transaction_created_on,
									"amount" => $tx_record->amount,
									"currency" => $tx_record->currency,
									"order_type" => $tx_record->order_type,
									"payment_mode" => $tx_record->payment_mode,
									"user_id" => $tx_record->user_id,
									"username" => $tx_record->username,
									"name" => $tx_record->name,
									"email" => $tx_record->email,
									"address_line_1" => $tx_record->address_line_1,
									"address_line_2" => $tx_record->address_line_2,
									"address_line_3" => $tx_record->address_line_3,
									"city" => $tx_record->city,
									"state" => $tx_record->state,
									"country" => $countryName,
									"country_code" => $tx_record->country_code,
									"zip" => $tx_record->zip,
									"created_by" => $tx_record->created_by,
                                    "created_on"=>date("Y:m:d H:i:s")
                                );
                $reports_db->insert($tableName,$insertData);
            }
        }
        $this->logaction->log("system","Year end statement CRON completed for the day ".$yesterdayDate);
	}

	public function populateTransactionReport_old()
	{
		ini_set('max_execution_time', 0);
		$itemNameUpdateTables = [];
		$reports_db=$this->load->database("reports",true,false);
		$this->db->select("*");
        $this->db->from("transaction");
        $this->db->where_in("status",array("completed",'success','release payment','approved','captured','paid','Release Payment','Success'));
        $this->db->where("currency!=","");
		$q=$this->db->get();
		$transactionResults = $q->result();
        foreach ($transactionResults as $tx_record)
        {
            if($tx_record->order_id)
            {
            	if(strtolower($tx_record->currency)=='inr')
            	{
            		$tableName = "tx_report_inr_";
            		$monthOfCreated = date("m",strtotime($tx_record->created_on));
            		$yearOfCreated = date("Y",strtotime($tx_record->created_on));
            		if($monthOfCreated>=4)
            		{
            			$tableName .= $yearOfCreated."-".financial_year_start_month_date;
                        $tableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
            		}
            		else
            		{
            			$tableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
                        $tableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
            		}
            		
            	}
            	else
            	{
            		$tableName = "tx_report_usd_".date("Y",strtotime($tx_record->created_on));
            	}

            	$tableName = str_replace("-","_",$tableName);
            	$this->createNewTransactionReportTable($tableName);

            	if($tableName!='')
            	{
            		$itemNameUpdateTables[]=$tableName;
            	}

                $reports_db->where("tx",$tx_record->tx);
                $record_exist=$reports_db->get($tableName)->num_rows();
                
                if($tx_record->tx=='' || abs($tx_record->amount)==0 || $record_exist)
                {
                    continue;
                }
                if($tx_record->created_on=='')
                {
                    $tx_record->created_on=$tx_record->started_on;
                }
                $orderData=$this->orders_model->orderData($tx_record->order_id);
                if(empty($orderData['order']))
                {
                    echo $tx_record->order_id."\n";
                    continue;
                }
                $items=array();
                $itemNames='';
                foreach ($orderData['order_items'] as $itemData)
                {
                    if($itemData->subscription==1)
                        continue;
                    $items[$itemData->id]=$itemData;
                    if($itemNames!='') $itemNames.=" ,";
                    $itemNames.=$itemData->item_name;
                }

                if($tx_record->subscription==1)
                {
					
					foreach ($orderData['order_items'] as $itemData)
	                {
	                	if($itemData->id == $tx_record->order_item_id)
	                	{
	                		if($itemNames!='') $itemNames.=" ,";
	                    	$itemNames.=$itemData->item_name;
	                    	break;
	                	}
	                }
                    $insertData=array(
                                    "order_id"=> $orderData['order']->id,
                                    "order_item_id"=>$tx_record->order_item_id,
                                    "ashram_id"=>$tx_record->ashram_id,
                                    "order_number"=>$orderData['order']->order_number,
                                    "order_date"=> $orderData['order']->date,
                                    "tx"=> $tx_record->tx,
                                    "item"=>$itemNames,
                                    "transaction_date"=>$tx_record->created_on,
                                    "amount"=> abs($tx_record->amount),
                                    "currency"=>$tx_record->currency,
                                    "order_type"=>$orderData['order']->order_type,
                                    "payment_mode"=>$tx_record->payment_mode,
                                    "user_id"=>$orderData['order']->user_id,
                                    "created_on"=>date("Y:m:d H:i:s")
                                );
                    $reports_db->insert($tableName,$insertData);
                }
                else
                {
                    $insertData=array(
                                    "order_id"=> $orderData['order']->id,
                                    "order_item_id"=>$tx_record->order_item_id,
                                    "ashram_id"=>$tx_record->ashram_id,
                                    "order_number"=>$orderData['order']->order_number,
                                    "order_date"=> $orderData['order']->date,
                                    "tx"=> $tx_record->tx,
                                    "item"=>$itemNames,
                                    "transaction_date"=>$tx_record->created_on,
                                    "amount"=> abs($tx_record->amount),
                                    "currency"=>$tx_record->currency,
                                    "order_type"=>$orderData['order']->order_type,
                                    "payment_mode"=>$tx_record->payment_mode,
                                    "user_id"=>$orderData['order']->user_id,
                                    "created_on"=>date("Y:m:d H:i:s")
                                );
                    $reports_db->insert($tableName,$insertData);
                }
            }
        }

        $itemNameUpdateTables = array_unique($itemNameUpdateTables);
        foreach($itemNameUpdateTables as $thisTableName)
        {
	        $report = $reports_db->select("id,item,tx,order_id,order_item_id")->from($thisTableName)->where("item","")->get();
	        if($report->num_rows() > 0)
	        {
	        	$report_records = $report->result();
	        	foreach ($report_records as $key => $value) 
	        	{

	        		$report_orderData=$this->orders_model->orderData($value->order_id);
	                if(empty($report_orderData['order']))
	                {
	                    echo $value->order_id."\n";
	                    continue;
	                }
	                foreach ($report_orderData['order_items'] as $itemData1)
	                {
	                    if($itemData1->subscription==1 && $value->item == "")
	                    {
	                        $itemName = "Setup fee for subscription: ".$itemData1->item_name;

		                    $updateData = array("item"=>$itemName);

		                    $reports_db->where("id",$value->id);
							$reports_db->update($tableName,$updateData);
	                    }
	                }
	        	}
	        }
	    }
	}

	public function createOrderTemp($reference,$transaction,$tempInfo,$ipn)
	{
		// Get temp cart data
		$customData=unserialize($tempInfo->data);
		// Get temp user data
		$userData=unserialize($tempInfo->user_data);
		$username='';
		if(!empty($userData))
		{
			$username=$userData->username;
		}
		// Set payment mode
		$paymentMode='';
		if($customData['paymentMode']=='payu')
		{
			$paymentMode="PayU (".$ipn->paymentMode.')';
		}
		else if($customData['paymentMode']=='razorpay')
		{
			$paymentMode='Razorpay';
		}
		else if($customData['paymentMode']=='paypal')
		{
			$paymentMode='PayPal';
		}
		else if($customData['paymentMode']=='stripe')
		{
			$paymentMode='Stripe';
		}
		else if($customData['paymentMode']=='authorize.net')
		{
			$paymentMode='Authorize.net';
		}
		else
		{
			$paymentMode=$customData['paymentMode'];
		}

		$paymentStatus=1;
		if($customData['paymentMode']=='cash')
		{
			$paymentStatus=0;
			$paymentMode="Offline";
		}
		// Get form data
		$info=$customData['formData'];
		$app=0;
		if(isset($info['app']) && $info['app']==1)
			$app=1;

		$partial_payments_allowed=1;

		foreach ($customData['cartData'] as $itemData)
		{
			if($itemData['options']['partial_payments_allowed']==0)
			{
				$partial_payments_allowed=0;
			}
		}

		$pan_or_aadhaar = '';
		$order_pan_number = '';
		$order_aadhaar_number = '';
		$order_tin_number = '';
		$order_passport_number = '';
		$order_voter_epic_number = '';
		$order_driving_license_number = '';
		$order_ration_card_number = '';
		$order_declaration_type = 'Donation';
		$order_selected_template = '';
		// Set PAN number
		if(isset($info['pan_or_aadhaar']) && $info['pan_or_aadhaar']!='')
		{
			$pan_or_aadhaar = trim($info['pan_or_aadhaar']);
		}
		if(isset($info['pan_number']) && $info['pan_number']!='' && $pan_or_aadhaar=='PAN')
		{
			$order_pan_number = trim($info['pan_number']);
		}
		// Set Aadhar number
		if(isset($info['aadhaar_number']) && $info['aadhaar_number']!='' && $pan_or_aadhaar=='Aadhaar')
		{
			$order_aadhaar_number = trim($info['aadhaar_number']);
		}
		// Set TIN number
		if(isset($info['tin_number']) && $info['tin_number']!='')
		{
			$order_tin_number = trim($info['tin_number']);
		}
		// Set passport number
		if(isset($info['passport_number']) && $info['passport_number']!='')
		{
			$order_passport_number = trim($info['passport_number']);
		}
		// Set voter epic number
		if(isset($info['voter_epic_number']) && $info['voter_epic_number']!='')
		{
			$order_voter_epic_number = trim($info['voter_epic_number']);
		}
		// Set driving license number
		if(isset($info['driving_license_number']) && $info['driving_license_number']!='')
		{
			$order_driving_license_number = trim($info['driving_license_number']);
		}
		// Set ration card number
		if(isset($info['ration_card_number']) && $info['ration_card_number']!='')
		{
			$order_ration_card_number = trim($info['ration_card_number']);
		}
		// Set declaration type
		if(isset($info['declaration_type']) && $info['declaration_type']=='Gift')
		{
			$order_declaration_type = trim($info['declaration_type']);
		}
		// set gift template if declaration type is Gift
		if(isset($info['selected_template']) && $info['selected_template']!='' && $order_declaration_type=='Gift')
		{
			$order_selected_template = trim($info['selected_template']);
		}
		// Get country details by country
		$countryData=$this->locations_model->getCountryByCode($info['country']);
		$is_appji_order = '0';
		// Set order is appji ashram or not
		if($customData['cart_type']==2 && $this->session->userdata("donationCartAshramIdSelection")==appji_ashram_id)
        {
        	$is_appji_order = '1';
        }
        if($customData['cart_type']==4 && $this->session->userdata("subscriptionCartAshramIdSelection")==appji_ashram_id)
        {
        	$is_appji_order = '1';
        }
        // Build array to store data to oreder_temp table
		$orderArray=array(
                        	'date' => date("Y:m:d H:i:s"),
							'user_id' => $tempInfo->user_id,
							'username'=>$username,
							'order_type'=>$customData['cart_type'],
							'ashram_id' => $customData['ashramData']->id,
							'transaction_id' => $transaction->tx,
							'currency'=>$tempInfo->currency,
							'total_price'=>$tempInfo->amount,
							'original_total_price'=>$tempInfo->amount,
							'order_total_price'=>$tempInfo->amount,
							'price_in_words'=>$customData['amount_in_words'],
							'created_by'=>$customData['created_by'],
							'firstname'=>trim($info['firstname']),
							//'middle_name'=>trim($info['middle_name']),
							'lastname'=>trim($info['lastname']),
							'preferred_name'=>trim($info['preferred_name']),
							'email'=>trim($info['email']),
							'phone'=>trim($info['phone']),
							'address1'=>trim($info['address1']),
							'address2'=>trim($info['address2']),
							'address3'=>trim($info['address3']),
							'city'=>trim($info['city']),
							'state'=>trim($info['state']),
							'country'=>$info['country'],
							'country_name'=>$countryData->country_name,
							"isd_code"=>$countryData->isd_code,
							'data'=>"",
							'zipcode'=>$info['zipcode'],
							'donation_initials'=>$info['donation_initials'],
							'ip_address' =>$customData['ip_address'],
							'created_by_user_id'=>$customData['created_by_user_id'],
							"trust_id"=>$customData['trustData']->id,
							"trust_name"=>$customData['trustData']->trust_name,
                            "trust_address"=>$customData['trustData']->address,
                            "trust_ashram_footer"=>$customData['trustData']->ashram_footer,
                            "tax_80g_501c3"=>$customData['trustData']->tax_80g_501c3,
                            "ashram_name"=>$customData['ashramData']->name,
							'status'=>1,
							'payment_status'=>$paymentStatus,
							'payment_mode'=>$paymentMode,
							'payment_alt_mode'=>$customData['paymentMode'],
							'is_manual_payment'=>$info['is_manual_payment'],
							'partial_payments_allowed'=>$partial_payments_allowed,
							'pan_or_aadhaar'=>$pan_or_aadhaar,
							'order_pan_number'=>$order_pan_number,
							'order_aadhaar_number'=>$order_aadhaar_number,
							'order_tin_number'=>$order_tin_number,
							'order_passport_number'=>$order_passport_number,
							'order_voter_epic_number'=>$order_voter_epic_number,
							'order_driving_license_number'=>$order_driving_license_number,
							'order_ration_card_number'=>$order_ration_card_number,
							'declaration_type'=>$order_declaration_type,
							'declaration_template'=>$order_selected_template,
							'is_appji_order'=>$is_appji_order,
							'app'=>$app
						);
		if((isset($customData['ashramData']->show_alias_name_as_ashram_name) && $customData['ashramData']->show_alias_name_as_ashram_name==1) && (isset($customData['ashramData']->alias_name) && $customData['ashramData']->alias_name!=""))
		{
			$orderArray['ashram_alias_name'] = $customData['ashramData']->alias_name;
		}
		else
		{
			$orderArray['ashram_alias_name'] = $customData['ashramData']->name;
		}

		$q=$this->db->insert("orders_temp",$orderArray);
		//Get temp order id
		$order_id=$this->db->insert_id();
		$this->logaction->log($this->service,get_class($this),"Order",$this->db->last_query());

		// Generate order number based on order_id
		$orderNumber="TO-".date("Y")."-".date("m")."-10000".$order_id;
		// Update order_temp with card hash details and order number
		$hash_card_data = md5($tempInfo->data);
		$this->db->where("id",$order_id);
		$this->db->update("orders_temp",
							array("order_number"=>$orderNumber,"cart_hash_data"=>$hash_card_data)
						);

		/*$i_s_data = array('data'=>serialize($tempInfo),'date'=>date("Y-m-d H:i:s"),'order_id'=>$order_id);
		$this->archivesDb->insert($this->s_orders_data_table,$i_s_data);*/
		// Get user sso_user_id
		$this->load->model("user/users_model");
		$sso_user_id = $this->users_model->getSSOUserID($tempInfo->user_id);
		// Build array to store order item data to order_items_temp table
		$seq=0;
		foreach ($customData['cartData'] as $itemData)
		{
			// Set default values for order items
			$friend_or_otherarr = [];
			$friend_or_otherarr[1] = '';
			$friend_or_otherarr[2] = '';
			$friend_or_otherarr[3] = '';
			$friend_or_otherarr[4] = '';
			$friend_or_otherarr[5] = '';
			$friend_or_otherarr[6] = '';
			$friend_or_otherarr[7] = '';
			$friend_or_otherarr[8] = '';
			$friend_or_otherarr[9] = '';
			$friend_or_otherarr[10] = '';
			$pooja_on_swamiji = 0;
			$pooja_on_teertha_swamiji = 0;
			$is_from_appji = 'No';
			$appji_member_name = '';
			$appji_member_email = '';
			$link_token = '';
			$seq++;
			$priceCol="price_".strtolower($tempInfo->currency);
			$onetimeChargeCol="onetime_charge_".strtolower($tempInfo->currency);

			$nameoffamilytype = "";
			$selectedfamilymembers = "";
			$itemData['options']['family_member_details'] = '';
			// Set family member details for every order item
			if(isset($itemData['options']['pooja_on_family_type']) && in_array($itemData['options']['pooja_on_family_type'],[0,1,2,3,8]))
			{
				if($itemData['options']['pooja_on_family_type'] == 0)
				{
					$pooja_on_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Ganapathy Sachchidananda Swamiji";
					$nameoffamilytype = 0;
				}
				if($itemData['options']['pooja_on_family_type'] == 1)
				{
					$pooja_on_teertha_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Datta Vijayananda Teertha Swamiji";
					$nameoffamilytype = 1;
				}
				if($itemData['options']['pooja_on_family_type'] == 2)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							$thisnote .= $thisdonr['donor_name']."\r\n";
							if($selectedfamilymembers == '')
							{
								$selectedfamilymembers .= $thisdonr['donor_id'];
							} else {
								$selectedfamilymembers .= ','.$thisdonr['donor_id'];
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 2;
				}
				if($itemData['options']['pooja_on_family_type'] == 3)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							if(isset($itemData['options']['pooja_on_family_members']) && !empty($itemData['options']['pooja_on_family_members']) && in_array($thisdonr['donor_id'], $itemData['options']['pooja_on_family_members']))
							{
								$thisnote .= $thisdonr['donor_name']."\r\n";
								if($selectedfamilymembers == '')
								{
									$selectedfamilymembers .= $thisdonr['donor_id'];
								} else {
									$selectedfamilymembers .= ','.$thisdonr['donor_id'];
								}
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 3;
				}
				if($itemData['options']['pooja_on_family_type'] == 8)
				{
					$itemData['options']['family_member_details'] = '';
					for($othercount=1;$othercount<=10;$othercount++)
					{
						if(isset($itemData['options']['other_name'.$othercount]) && $itemData['options']['other_name'.$othercount]!='')
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							$itemData['options']['family_member_details'] .= trim($itemData['options']['other_name'.$othercount]);
							$friend_or_otherarr[$othercount] = trim($itemData['options']['other_name'.$othercount]);
						}
					}
					if(isset($itemData['options']['other_names']) && !empty($itemData['options']['other_names']))
					{
						$optionsOtherName = array();
						$optionsOtherNameKey = 1;
						foreach($itemData['options']['other_names'] as $thisName)
						{
							$optionsOtherName[$optionsOtherNameKey] = $thisName;
							$optionsOtherNameKey++;
						}
						for($othercount=1;$othercount<=10;$othercount++)
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							if(isset($optionsOtherName[$othercount]))
							{
								$itemData['options']['family_member_details'] .= trim($optionsOtherName[$othercount]);
								$friend_or_otherarr[$othercount] = trim($optionsOtherName[$othercount]);
							}
						}
					}
					$nameoffamilytype = 8;
				}
			}


			if(isset($itemData['options']['donation_on_family_type']) && in_array($itemData['options']['donation_on_family_type'],[4,5,6,7,9,13]))
			{
				if($itemData['options']['donation_on_family_type'] == 4)
				{
					$pooja_on_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Ganapathy Sachchidananda Swamiji";
					$nameoffamilytype = 4;
				}
				if($itemData['options']['donation_on_family_type'] == 5)
				{
					$pooja_on_teertha_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Datta Vijayananda Teertha Swamiji";
					$nameoffamilytype = 5;
				}
				if($itemData['options']['donation_on_family_type'] == 6)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->where('is_hidden',0);
					$donorquery->order_by('donor_name','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							$thisnote .= $thisdonr['donor_name']."\r\n";
							if($selectedfamilymembers == '')
							{
								$selectedfamilymembers .= $thisdonr['donor_id'];
							} else {
								$selectedfamilymembers .= ','.$thisdonr['donor_id'];
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 6;
				}
				if($itemData['options']['donation_on_family_type'] == 7)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							if(in_array($thisdonr['donor_id'], $itemData['options']['donation_on_family_members']))
							{
								$thisnote .= $thisdonr['donor_name']."\r\n";
								if($selectedfamilymembers == '')
								{
									$selectedfamilymembers .= $thisdonr['donor_id'];
								} else {
									$selectedfamilymembers .= ','.$thisdonr['donor_id'];
								}
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 7;
				}
				
				if($itemData['options']['donation_on_family_type'] == 9)
				{
					$itemData['options']['family_member_details'] = '';
					for($othercount=1;$othercount<=10;$othercount++)
					{
						if(isset($itemData['options']['other_name'.$othercount]) && $itemData['options']['other_name'.$othercount]!='')
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							$itemData['options']['family_member_details'] .= trim($itemData['options']['other_name'.$othercount]);
							$friend_or_otherarr[$othercount] = trim($itemData['options']['other_name'.$othercount]);
						}
					}
					if(isset($itemData['options']['other_names']) && !empty($itemData['options']['other_names']))
					{
						$optionsOtherName = array();
						$optionsOtherNameKey = 1;
						foreach($itemData['options']['other_names'] as $thisName)
						{
							$optionsOtherName[$optionsOtherNameKey] = $thisName;
							$optionsOtherNameKey++;
						}
						for($othercount=1;$othercount<=10;$othercount++)
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							if(isset($optionsOtherName[$othercount]))
							{
								$itemData['options']['family_member_details'] .= trim($optionsOtherName[$othercount]);
								$friend_or_otherarr[$othercount] = trim($optionsOtherName[$othercount]);
							}
						}
					}
					$nameoffamilytype = 9;
				}
				if($itemData['options']['donation_on_family_type'] == 13)
				{
					$itemData['options']['family_member_details'] = '';
					if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
					{
						$itemData['options']['family_member_details'] = $itemData['options']['appji_member_name'];
					}
					if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
					{
						$itemData['options']['family_member_details'] .=  "\r\n".$itemData['options']['appji_member_email'];
					}
					$nameoffamilytype = 13;
				}
			}


			if(isset($itemData['options']['subscription_on_family_type']) && in_array($itemData['options']['subscription_on_family_type'],[10,11,12,14]))
			{
				if($itemData['options']['subscription_on_family_type'] == 10)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							if($thisdonr['donor_id']==$itemData['options']['subscription_on_family_member'])
							{
								$thisnote .= $thisdonr['donor_name']."\r\n";
								if($selectedfamilymembers == '')
								{
									$selectedfamilymembers .= $thisdonr['donor_id'];
								} else {
									$selectedfamilymembers .= ','.$thisdonr['donor_id'];
								}
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 10;
				}
				if($itemData['options']['subscription_on_family_type'] == 11)
				{
					$pooja_on_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Ganapathy Sachchidananda Swamiji";
					$nameoffamilytype = 11;
				}
				if($itemData['options']['subscription_on_family_type'] == 12)
				{
					$pooja_on_teertha_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Datta Vijayananda Teertha Swamiji";
					$nameoffamilytype = 12;
				}
				if($itemData['options']['subscription_on_family_type'] == 14)
				{
					$itemData['options']['family_member_details'] = '';
					if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
					{
						$itemData['options']['family_member_details'] = $itemData['options']['appji_member_name'];
					}
					if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
					{
						$itemData['options']['family_member_details'] .=  "\r\n".$itemData['options']['appji_member_email'];
					}
					$nameoffamilytype = 14;
				}
			}
			
			if($customData['cart_type']==1)
			{
				$shipDomestic="shipping_domestic_".strtolower($tempInfo->currency);
				$shipInternational="shipping_international_".strtolower($tempInfo->currency);
				$shippingPrice=0;
				$prasadam_status = 0;
				if($this->input->post('prasadam_not_required') && $this->input->post('prasadam_not_required') == 1)
				{
					$prasadam_status = 1;
				}
				if(isset($itemData['options']['shipping']) && $itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						if($itemData['options']['shipping_address']['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
					}
					else
                	{
                		if($info['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
                	}
				}
				if(isset($itemData['options']['pitru_paksha_pooja']) && $itemData['options']['pitru_paksha_pooja']==1)
				{
					if(isset($itemData['options']['pitru_paksha_deceased_person_name']) && $itemData['options']['pitru_paksha_deceased_person_name']!='')
						$itemData['options']['family_member_details'] = $itemData['options']['pitru_paksha_deceased_person_name'];
					else
						$itemData['options']['family_member_details'] = 'NA';

					$selectedfamilymembers = '';
				}
				if(isset($itemData['options']['is_poornaphala_seva']) && $itemData['options']['is_poornaphala_seva']==1)
				{
					if(isset($itemData['options']['poornaphala_tie_by']))
						$itemData['options']['poornaphala_tie_by'] = $itemData['options']['poornaphala_tie_by'];
					else
						$itemData['options']['poornaphala_tie_by'] = 'Priest will tie Poornaphala';
				}
				if(isset($itemData['options']['is_attend_in_person']) && $itemData['options']['is_attend_in_person']==1)
				{
					if(isset($itemData['options']['attend_pooja_in_person']))
						$itemData['options']['attend_pooja_in_person'] = $itemData['options']['attend_pooja_in_person'];
					else
						$itemData['options']['attend_pooja_in_person'] = 'I will not attend Pooja in-person';
				}
				$max_family_members = 'All family members';
				if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members']>0)
				{
					$max_family_members = $itemData['options']['max_family_members'];
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'start_date'=>$itemData['options']['start_date'],
								'end_date'=>$itemData['options']['end_date'],
								'time_from'=>$itemData['options']['time_from'],
								'time_to'=>$itemData['options']['time_to'],
								'schedule_dates' =>$itemData['options']['result_date'],
								'options' =>serialize($itemData['options']),
								'prasadam_not_required'=>$prasadam_status,
								//'shipping'=>$itemData['options']['shipping'],
								//'shipping_price'=>$shippingPrice,
								'pooja_on_swamiji'=>$pooja_on_swamiji,
								'category'=>$itemData['options']['category'],
								'sequence'=>$seq,
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'personal_note'=>$itemData['options']['personal_note'],
								'family_member_details'=>$itemData['options']['family_member_details'],
								'name_of_family_type'=>$nameoffamilytype,
								'pooja_on_teertha_swamiji'=>$pooja_on_teertha_swamiji,
								'family_members'=>$selectedfamilymembers,
								'max_family_members'=>$max_family_members,
								'friend_or_other_1'=>$friend_or_otherarr[1],
								'friend_or_other_2'=>$friend_or_otherarr[2],
								'friend_or_other_3'=>$friend_or_otherarr[3],
								'friend_or_other_4'=>$friend_or_otherarr[4],
								'friend_or_other_5'=>$friend_or_otherarr[5],
								'friend_or_other_6'=>$friend_or_otherarr[6],
								'friend_or_other_7'=>$friend_or_otherarr[7],
								'friend_or_other_8'=>$friend_or_otherarr[8],
								'friend_or_other_9'=>$friend_or_otherarr[9],
								'friend_or_other_10'=>$friend_or_otherarr[10],
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);

				if(isset($itemData['options']['shipping']) && $itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						$orderItem['shipping_address1']=$itemData['options']['shipping_address']['address1'];
						$orderItem['shipping_address2']=$itemData['options']['shipping_address']['address2'];
						$orderItem['shipping_address3']=$itemData['options']['shipping_address']['address3'];
						$orderItem['shipping_city']=$itemData['options']['shipping_address']['city'];
						$orderItem['shipping_state']=$itemData['options']['shipping_address']['state'];
						$orderItem['shipping_country_name']=$itemData['options']['shipping_address']['country_name'];
						$orderItem['shipping_country']=$itemData['options']['shipping_address']['country'];
					}
					else
					{
						$countryData=$this->locations_model->getCountryByCode($info['country']);
						$orderItem['shipping_address1']=trim($info['address1']);
						$orderItem['shipping_address2']=trim($info['address2']);
						$orderItem['shipping_address3']=trim($info['address3']);
						$orderItem['shipping_city']=trim($info['city']);
						$orderItem['shipping_state']=trim($info['state']);
						$orderItem['shipping_country_name']=$countryData->country_name;
						$orderItem['shipping_country']=trim($info['country']);
					}
				}
			}
			else if($customData['cart_type']==2)
			{
				$max_family_members = 'All family members';
				if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members']>0)
				{
					$max_family_members = $itemData['options']['max_family_members'];
				}
				if(isset($itemData['options']['is_appji_donation']) && $itemData['options']['is_appji_donation']>0)
				{
					$is_from_appji = $itemData['options']['is_appji_donation'];
				}
				if(isset($itemData['options']['appji_link_token']) && $itemData['options']['appji_link_token']!='')
				{
					$link_token = $itemData['options']['appji_link_token'];
				}
				if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
				{
					$appji_member_name = $itemData['options']['appji_member_name'];
				}
				if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
				{
					$appji_member_email = $itemData['options']['appji_member_email'];
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'schedule_dates' =>$itemData['options']['result_date'],
								'options' =>serialize($itemData['options']),
								'sequence'=>$seq,
								'category'=>$itemData['options']['category'],
								'family_member_details'=>$itemData['options']['family_member_details'],
								'personal_note'=>$itemData['options']['personal_note'],
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'donor_id'=>$itemData['options']['donor_id'],
								'assign_pet'=>$itemData['options']['assign_pet'],
								'name_of_family_type'=>$nameoffamilytype,
								'pooja_on_teertha_swamiji'=>$pooja_on_teertha_swamiji,
								'family_members'=>$selectedfamilymembers,
								'pooja_on_swamiji'=>$pooja_on_swamiji,
								'max_family_members'=>$max_family_members,
								'friend_or_other_1'=>$friend_or_otherarr[1],
								'friend_or_other_2'=>$friend_or_otherarr[2],
								'friend_or_other_3'=>$friend_or_otherarr[3],
								'friend_or_other_4'=>$friend_or_otherarr[4],
								'friend_or_other_5'=>$friend_or_otherarr[5],
								'friend_or_other_6'=>$friend_or_otherarr[6],
								'friend_or_other_7'=>$friend_or_otherarr[7],
								'friend_or_other_8'=>$friend_or_otherarr[8],
								'friend_or_other_9'=>$friend_or_otherarr[9],
								'friend_or_other_10'=>$friend_or_otherarr[10],
								'is_from_appji'=>$is_from_appji,
								'link_token'=>$link_token,
								'appji_member_name'=>$appji_member_name,
								'appji_member_email'=>$appji_member_email,
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);
			}
			else if($customData['cart_type']==3) //Store Item
			{
				$shipDomestic="shipping_domestic_".strtolower($tempInfo->currency);
				$shipInternational="shipping_international_".strtolower($tempInfo->currency);
				$shippingPrice=0;
				if($itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						if($itemData['options']['shipping_address']['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
					}
					else
                	{
                		if($info['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
                	}
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'family_member_details'=>isset($itemData['options']['family_member_details']) ? $itemData['options']['family_member_details'] : '',
								'personal_note'=>$itemData['options']['personal_note'],
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'shipping'=>$itemData['options']['shipping'],
								'shipping_price'=>$shippingPrice,
								'options' =>serialize($itemData['options']),
								'category'=>$itemData['options']['category'],
								'sequence'=>$seq,
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);
				if($itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						$orderItem['shipping_address1']=$itemData['options']['shipping_address']['address1'];
						$orderItem['shipping_address2']=$itemData['options']['shipping_address']['address2'];
						$orderItem['shipping_address3']=$itemData['options']['shipping_address']['address3'];
						$orderItem['shipping_city']=$itemData['options']['shipping_address']['city'];
						$orderItem['shipping_state']=$itemData['options']['shipping_address']['state'];
						$orderItem['shipping_country_name']=$itemData['options']['shipping_address']['country_name'];
						$orderItem['shipping_country']=$itemData['options']['shipping_address']['country'];
					}
					else
					{
						$countryData=$this->locations_model->getCountryByCode($info['country']);
						$orderItem['shipping_address1']=trim($info['address1']);
						$orderItem['shipping_address2']=trim($info['address2']);
						$orderItem['shipping_address3']=trim($info['address3']);
						$orderItem['shipping_city']=trim($info['city']);
						$orderItem['shipping_state']=trim($info['state']);
						$orderItem['shipping_country_name']=$countryData->country_name;
						$orderItem['shipping_country']=trim($info['country']);
					}
				}
				if(isset($itemData['options']['gift_friend_email']))
				{
					$orderItem['gift_friend_email']=$itemData['options']['gift_friend_email'];
				}
				if(isset($itemData['options']['gift_friend_name']))
				{
					$orderItem['gift_friend_name']=$itemData['options']['gift_friend_name'];
				}
			}
			else if($customData['cart_type']==4)
			{
				$pay_till_cancel = 0;
				if(!empty($itemData['options']['pay_till_cancel']) && $itemData['options']['pay_till_cancel'] > 0)
				{
					$pay_till_cancel = 1;
					$itemData['options']['num_of_payments'] = 1;
				}
				if(isset($itemData['options']['is_appji_subscription']) && $itemData['options']['is_appji_subscription']>0)
				{
					$is_from_appji = $itemData['options']['is_appji_subscription'];
				}
				if(isset($itemData['options']['appji_link_token']) && $itemData['options']['appji_link_token']!='')
				{
					$link_token = $itemData['options']['appji_link_token'];
				}
				if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
				{
					$appji_member_name = $itemData['options']['appji_member_name'];
				}
				if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
				{
					$appji_member_email = $itemData['options']['appji_member_email'];
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'schedule_dates' =>$itemData['options']['result_date'],
								'options' =>serialize($itemData['options']),
								'sequence'=>$seq,
								'category'=>$itemData['options']['category'],
								'family_member_details'=>isset($itemData['options']['family_member_details']) ? $itemData['options']['family_member_details'] : '',
								'personal_note'=>$itemData['options']['personal_note'],
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'subscription'=>$itemData['options']['subscription'],
								'onetime_charge'=>$itemData['options'][$onetimeChargeCol],
								'period'=>$itemData['options']['period'],
								"pay_till_cancel"=>$pay_till_cancel,
								'frequency'=>$itemData['options']['frequency'],
								'expiry_date'=>$itemData['options']['subscription_expiry_date'],
								'expiration_method'=>$itemData['options']['expiration_method'],
								'num_of_payments'=>$itemData['options']['num_of_payments'],
								'given_expiry_date'=>$itemData['options']['expiry_date'],
								'donor_id'=>$itemData['options']['donor_id'],
								'assign_pet'=>$itemData['options']['assign_pet'],
								'name_of_family_type'=>$nameoffamilytype,
								'pooja_on_teertha_swamiji'=>$pooja_on_teertha_swamiji,
								'family_members'=>$selectedfamilymembers,
								'pooja_on_swamiji'=>$pooja_on_swamiji,
								'is_from_appji'=>$is_from_appji,
								'link_token'=>$link_token,
								'appji_member_name'=>$appji_member_name,
								'appji_member_email'=>$appji_member_email,
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);
				if($itemData['options']['subscription']==1)
				{
					$orderItem['status']=0;
				}
			}
			$q=$this->db->insert('order_items_temp',$orderItem);

			$itemId=$this->db->insert_id();

			if(isset($itemData['options']['subscription']) && $itemData['options']['subscription']==1)
			{
				$orderItem['id']=$itemId;
				//$this->subscription_payments_model->createRecords($orderItem);
			}
		}
		
		return array("order_id"=>$order_id);
	}

	public function createOrder($reference,$transaction,$tempInfo,$ipn)
	{
		$customData=unserialize($tempInfo->data);
		$userData=unserialize($tempInfo->user_data);
		$username='';
		if(!empty($userData))
		{
			$username=$userData->username;
		}
		$paymentMode='';
		if($customData['paymentMode']=='payu')
		{
			$paymentMode="PayU (".$ipn->paymentMode.')';
		}
		else if($customData['paymentMode']=='razorpay')
		{
			$paymentMode='Razorpay';
		}
		else if($customData['paymentMode']=='paypal')
		{
			$paymentMode='PayPal';
		}
		else if($customData['paymentMode']=='stripe')
		{
			$paymentMode='Stripe';
		}
		else if($customData['paymentMode']=='authorize.net')
		{
			$paymentMode='Authorize.net';
		}
		else
		{
			$paymentMode=$customData['paymentMode'];
		}

		$paymentStatus=1;
		if($customData['paymentMode']=='cash')
		{
			$paymentStatus=0;
			$paymentMode="Offline";
		}
		
		$info=$customData['formData'];
		$app=0;
		if(isset($info['app']) && $info['app']==1)
			$app=1;

		$partial_payments_allowed=1;

		foreach ($customData['cartData'] as $itemData)
		{
			if($itemData['options']['partial_payments_allowed']==0)
			{
				$partial_payments_allowed=0;
			}
		}

		$pan_or_aadhaar = '';
		$order_pan_number = '';
		$order_aadhaar_number = '';
		$order_tin_number = '';
		$order_passport_number = '';
		$order_voter_epic_number = '';
		$order_driving_license_number = '';
		$order_ration_card_number = '';
		$order_declaration_type = 'Donation';
		$order_selected_template = '';
		if(isset($info['pan_or_aadhaar']) && $info['pan_or_aadhaar']!='')
		{
			$pan_or_aadhaar = trim($info['pan_or_aadhaar']);
		}
		if(isset($info['pan_number']) && $info['pan_number']!='' && $pan_or_aadhaar == 'PAN')
		{
			$order_pan_number = trim($info['pan_number']);
			$this->load->model("user_model");
			$userDetails=$this->user_model->userData($tempInfo->user_id);
			if(isset($userDetails->sso_user_id) && $userDetails->sso_user_id>0)
			{
				$this->auth_check=$this->load->database("sso_auth",true);
				$updateuserdata = [];
				if(isset($info['pan_number']) && $info['pan_number']!='' && strlen($info['pan_number'])==10)
				{
					$updateuserdata['pan_number'] = $info['pan_number'];

					//Update Current Site User PAN Number
					$this->db->where("id",$tempInfo->user_id);
					$this->db->update('users',$updateuserdata);

					//Update Global User PAN Number
					$this->auth_check->where("id",$userDetails->sso_user_id);
					$this->auth_check->update('users',$updateuserdata);

					//Update Current User Session with given address 
	        		$userDetails=$this->user_model->userData($tempInfo->user_id);
	        		if($this->session->userdata("id"))
	                {
	                    if($this->session->userdata('temp_checkout_user'))
	                    {
	                        $this->session->set_userdata('temp_checkout_user',$userDetails);
	                    }
	                }
	                else if($this->session->userdata("user_id"))
	                {
	                	$this->session->set_userdata("user_data",$userDetails);
	                }
				}
			}
		}
		if(isset($info['aadhaar_number']) && $info['aadhaar_number']!='' && $pan_or_aadhaar == 'Aadhaar')
		{
			$order_aadhaar_number = trim($info['aadhaar_number']);
			$this->load->model("user_model");
			$userDetails=$this->user_model->userData($tempInfo->user_id);
			if(isset($userDetails->sso_user_id) && $userDetails->sso_user_id>0)
			{
				$this->auth_check=$this->load->database("sso_auth",true);
				$updateuserdata = [];
				if(isset($info['aadhaar_number']) && $info['aadhaar_number']!='' && strlen($info['aadhaar_number'])==12)
				{
					$updateuserdata['aadhaar_number'] = $info['aadhaar_number'];

					//Update Current Site User Aadhaar Number
					$this->db->where("id",$tempInfo->user_id);
					$this->db->update('users',$updateuserdata);

					//Update Global User Aadhaar Number
					$this->auth_check->where("id",$userDetails->sso_user_id);
					$this->auth_check->update('users',$updateuserdata);

					//Update Current User Session with given address 
	        		$userDetails=$this->user_model->userData($tempInfo->user_id);
	        		if($this->session->userdata("id"))
	                {
	                    if($this->session->userdata('temp_checkout_user'))
	                    {
	                        $this->session->set_userdata('temp_checkout_user',$userDetails);
	                    }
	                }
	                else if($this->session->userdata("user_id"))
	                {
	                	$this->session->set_userdata("user_data",$userDetails);
	                }
				}
			}
		}

		if(isset($info['tin_number']) && $info['tin_number']!='' && $pan_or_aadhaar == 'TIN')
		{
			$order_tin_number = trim($info['tin_number']);
			$this->load->model("user_model");
			$userDetails=$this->user_model->userData($tempInfo->user_id);
			if(isset($userDetails->sso_user_id) && $userDetails->sso_user_id>0)
			{
				$this->auth_check=$this->load->database("sso_auth",true);
				$updateuserdata = [];
				if(isset($info['tin_number']) && $info['tin_number']!='' && strlen($info['tin_number'])==11)
				{
					$updateuserdata['tin_number'] = $info['tin_number'];

					//Update Current Site User TIN Number
					$this->db->where("id",$tempInfo->user_id);
					$this->db->update('users',$updateuserdata);

					//Update Global User TIN Number
					$this->auth_check->where("id",$userDetails->sso_user_id);
					$this->auth_check->update('users',$updateuserdata);

					//Update Current User Session with given address 
	        		$userDetails=$this->user_model->userData($tempInfo->user_id);
	        		if($this->session->userdata("id"))
	                {
	                    if($this->session->userdata('temp_checkout_user'))
	                    {
	                        $this->session->set_userdata('temp_checkout_user',$userDetails);
	                    }
	                }
	                else if($this->session->userdata("user_id"))
	                {
	                	$this->session->set_userdata("user_data",$userDetails);
	                }
				}
			}
		}

		if(isset($info['passport_number']) && $info['passport_number']!='' && $pan_or_aadhaar == 'Passport')
		{
			$order_passport_number = trim($info['passport_number']);
			$this->load->model("user_model");
			$userDetails=$this->user_model->userData($tempInfo->user_id);
			if(isset($userDetails->sso_user_id) && $userDetails->sso_user_id>0)
			{
				$this->auth_check=$this->load->database("sso_auth",true);
				$updateuserdata = [];
				if(isset($info['passport_number']) && $info['passport_number']!='' && strlen($info['passport_number'])==12)
				{
					$updateuserdata['passport_number'] = $info['passport_number'];

					//Update Current Site User Passport Number
					$this->db->where("id",$tempInfo->user_id);
					$this->db->update('users',$updateuserdata);

					//Update Global User Passport Number
					$this->auth_check->where("id",$userDetails->sso_user_id);
					$this->auth_check->update('users',$updateuserdata);

					//Update Current User Session with given address 
	        		$userDetails=$this->user_model->userData($tempInfo->user_id);
	        		if($this->session->userdata("id"))
	                {
	                    if($this->session->userdata('temp_checkout_user'))
	                    {
	                        $this->session->set_userdata('temp_checkout_user',$userDetails);
	                    }
	                }
	                else if($this->session->userdata("user_id"))
	                {
	                	$this->session->set_userdata("user_data",$userDetails);
	                }
				}
			}
		}

		if(isset($info['voter_epic_number']) && $info['voter_epic_number']!='' && $pan_or_aadhaar == 'EPIC')
		{
			$order_voter_epic_number = trim($info['voter_epic_number']);
			$this->load->model("user_model");
			$userDetails=$this->user_model->userData($tempInfo->user_id);
			if(isset($userDetails->sso_user_id) && $userDetails->sso_user_id>0)
			{
				$this->auth_check=$this->load->database("sso_auth",true);
				$updateuserdata = [];
				if(isset($info['voter_epic_number']) && $info['voter_epic_number']!='' && strlen($info['voter_epic_number'])>=10)
				{
					$updateuserdata['voter_epic_number'] = $info['voter_epic_number'];

					//Update Current Site User EPIC Number
					$this->db->where("id",$tempInfo->user_id);
					$this->db->update('users',$updateuserdata);

					//Update Global User EPIC Number
					$this->auth_check->where("id",$userDetails->sso_user_id);
					$this->auth_check->update('users',$updateuserdata);

					//Update Current User Session with given address 
	        		$userDetails=$this->user_model->userData($tempInfo->user_id);
	        		if($this->session->userdata("id"))
	                {
	                    if($this->session->userdata('temp_checkout_user'))
	                    {
	                        $this->session->set_userdata('temp_checkout_user',$userDetails);
	                    }
	                }
	                else if($this->session->userdata("user_id"))
	                {
	                	$this->session->set_userdata("user_data",$userDetails);
	                }
				}
			}
		}

		if(isset($info['driving_license_number']) && $info['driving_license_number']!='' && $pan_or_aadhaar == 'DL')
		{
			$order_driving_license_number = trim($info['driving_license_number']);
			$this->load->model("user_model");
			$userDetails=$this->user_model->userData($tempInfo->user_id);
			if(isset($userDetails->sso_user_id) && $userDetails->sso_user_id>0)
			{
				$this->auth_check=$this->load->database("sso_auth",true);
				$updateuserdata = [];
				if(isset($info['driving_license_number']) && $info['driving_license_number']!='' && strlen($info['driving_license_number'])==18)
				{
					$updateuserdata['driving_license_number'] = $info['driving_license_number'];

					//Update Current Site User DL Number
					$this->db->where("id",$tempInfo->user_id);
					$this->db->update('users',$updateuserdata);

					//Update Global User DL Number
					$this->auth_check->where("id",$userDetails->sso_user_id);
					$this->auth_check->update('users',$updateuserdata);

					//Update Current User Session with given address 
	        		$userDetails=$this->user_model->userData($tempInfo->user_id);
	        		if($this->session->userdata("id"))
	                {
	                    if($this->session->userdata('temp_checkout_user'))
	                    {
	                        $this->session->set_userdata('temp_checkout_user',$userDetails);
	                    }
	                }
	                else if($this->session->userdata("user_id"))
	                {
	                	$this->session->set_userdata("user_data",$userDetails);
	                }
				}
			}
		}

		if(isset($info['ration_card_number']) && $info['ration_card_number']!='' && $pan_or_aadhaar == 'RationCard')
		{
			$order_ration_card_number = trim($info['ration_card_number']);
			$this->load->model("user_model");
			$userDetails=$this->user_model->userData($tempInfo->user_id);
			if(isset($userDetails->sso_user_id) && $userDetails->sso_user_id>0)
			{
				$this->auth_check=$this->load->database("sso_auth",true);
				$updateuserdata = [];
				if(isset($info['ration_card_number']) && $info['ration_card_number']!='' && strlen($info['ration_card_number'])==12)
				{
					$updateuserdata['ration_card_number'] = $info['ration_card_number'];

					//Update Current Site User Ractin Card Number
					$this->db->where("id",$tempInfo->user_id);
					$this->db->update('users',$updateuserdata);

					//Update Global User Ractin Card Number
					$this->auth_check->where("id",$userDetails->sso_user_id);
					$this->auth_check->update('users',$updateuserdata);

					//Update Current User Session with given address 
	        		$userDetails=$this->user_model->userData($tempInfo->user_id);
	        		if($this->session->userdata("id"))
	                {
	                    if($this->session->userdata('temp_checkout_user'))
	                    {
	                        $this->session->set_userdata('temp_checkout_user',$userDetails);
	                    }
	                }
	                else if($this->session->userdata("user_id"))
	                {
	                	$this->session->set_userdata("user_data",$userDetails);
	                }
				}
			}
		}

		if(isset($info['declaration_type']) && $info['declaration_type']=='Gift')
		{
			$order_declaration_type = trim($info['declaration_type']);
		}
		if(isset($info['selected_template']) && $info['selected_template']!='' && $order_declaration_type=='Gift')
		{
			$order_selected_template = trim($info['selected_template']);
		}
		$countryData=$this->locations_model->getCountryByCode($info['country']);
		$is_appji_order = '0';
		if(($customData['cart_type']==2 || $customData['cart_type']==4) && ($this->session->userdata("donationCartAshramIdSelection")==appji_ashram_id || $customData['ashramData']->id==appji_ashram_id))
        {
        	$is_appji_order = '1';
        }
        $tax80gText = "";
		if(strtolower($tempInfo->currency)=='inr')
		{
			$tax80gText = $customData['trustData']->tax_80g_501c3;
		}
		$orderArray=array(
                        	'date' => date("Y:m:d H:i:s"),
							'user_id' => $tempInfo->user_id,
							'username'=>$username,
							'order_type'=>$customData['cart_type'],
							'ashram_id' => $customData['ashramData']->id,
							'transaction_id' => $transaction->tx,
							'currency'=>$tempInfo->currency,
							'total_price'=>$tempInfo->amount,
							'original_total_price'=>$tempInfo->amount,
							'order_total_price'=>$tempInfo->amount,
							'price_in_words'=>$customData['amount_in_words'],
							'created_by'=>$customData['created_by'],
							'firstname'=>trim($info['firstname']),
							//'middle_name'=>trim($info['middle_name']),
							'lastname'=>trim($info['lastname']),
							'preferred_name'=>trim($info['preferred_name']),
							'email'=>trim($info['email']),
							'phone'=>trim($info['phone']),
							'address1'=>trim($info['address1']),
							'address2'=>trim($info['address2']),
							'address3'=>trim($info['address3']),
							'city'=>trim($info['city']),
							'state'=>trim($info['state']),
							'country'=>$info['country'],
							'country_name'=>$countryData->country_name,
							"isd_code"=>$countryData->isd_code,
							//'data'=>"",
							'zipcode'=>$info['zipcode'],
							'donation_initials'=>$info['donation_initials'],
							'ip_address' =>$customData['ip_address'],
							'created_by_user_id'=>$customData['created_by_user_id'],
							"trust_id"=>$customData['trustData']->id,
							"trust_name"=>$customData['trustData']->trust_name,
                            "trust_address"=>$customData['trustData']->address,
                            "trust_ashram_footer"=>$customData['trustData']->ashram_footer,
                            "tax_80g_501c3"=>$tax80gText,
                            "ashram_name"=>$customData['ashramData']->name,
							'status'=>1,
							'payment_status'=>$paymentStatus,
							'payment_mode'=>$paymentMode,
							'payment_alt_mode'=>$customData['paymentMode'],
							'is_manual_payment'=>$info['is_manual_payment'],
							'partial_payments_allowed'=>$partial_payments_allowed,
							'pan_or_aadhaar'=>$pan_or_aadhaar,
							'order_pan_number'=>$order_pan_number,
							'order_aadhaar_number'=>$order_aadhaar_number,
							'order_tin_number'=>$order_tin_number,
							'order_passport_number'=>$order_passport_number,
							'order_voter_epic_number'=>$order_voter_epic_number,
							'order_driving_license_number'=>$order_driving_license_number,
							'order_ration_card_number'=>$order_ration_card_number,
							'declaration_type'=>$order_declaration_type,
							'declaration_template'=>$order_selected_template,
							'is_appji_order'=>$is_appji_order,
							'app'=>$app
						);
		if((isset($customData['ashramData']->show_alias_name_as_ashram_name) && $customData['ashramData']->show_alias_name_as_ashram_name==1) && (isset($customData['ashramData']->alias_name) && $customData['ashramData']->alias_name!=""))
		{
			$orderArray['ashram_alias_name'] = $customData['ashramData']->alias_name;
		}
		else
		{
			$orderArray['ashram_alias_name'] = $customData['ashramData']->name;
		}

		$q=$this->db->insert($this->tableName,$orderArray);

		$order_id=$this->db->insert_id();
		$this->logaction->log($this->service,get_class($this),"Order",$this->db->last_query());

		$orderNumber="O-".date("Y")."-".date("m")."-100".$order_id;

		$hash_card_data = md5($tempInfo->data);
		$this->db->where("id",$order_id);
		$this->db->update($this->tableName,
							array("order_number"=>$orderNumber,"cart_hash_data"=>$hash_card_data)
						);

		$i_s_data = array('data'=>serialize($tempInfo),'date'=>date("Y-m-d H:i:s"),'order_id'=>$order_id);
		$this->archivesDb->insert($this->s_orders_data_table,$i_s_data);
		$this->load->model("user/users_model");
		$sso_user_id = $this->users_model->getSSOUserID($tempInfo->user_id);
		$seq=0;
		foreach ($customData['cartData'] as $itemData)
		{
			$friend_or_otherarr = [];
			$friend_or_otherarr[1] = '';
			$friend_or_otherarr[2] = '';
			$friend_or_otherarr[3] = '';
			$friend_or_otherarr[4] = '';
			$friend_or_otherarr[5] = '';
			$friend_or_otherarr[6] = '';
			$friend_or_otherarr[7] = '';
			$friend_or_otherarr[8] = '';
			$friend_or_otherarr[9] = '';
			$friend_or_otherarr[10] = '';
			$pooja_on_swamiji = 0;
			$pooja_on_teertha_swamiji = 0;
			$is_from_appji = 'No';
			$link_token = '';
			$appji_member_name = '';
			$appji_member_email = '';
			$seq++;
			$priceCol="price_".strtolower($tempInfo->currency);
			$onetimeChargeCol="onetime_charge_".strtolower($tempInfo->currency);

			$nameoffamilytype = "";
			$selectedfamilymembers = "";
			$itemData['options']['family_member_details'] = '';
			// Set family member details for every order item
			if($customData['cart_type']==1 && !isset($itemData['options']['pooja_on_family_type']))
			{
				if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members'] != 'All family members')
				{
					$itemData['options']['pooja_on_family_type'] = 3;
				}
				else
				{
					$itemData['options']['pooja_on_family_type'] = 2;
				}
			}

			if($customData['cart_type']==2 && !isset($itemData['options']['donation_on_family_type']))
			{
				if($this->session->userdata("donationCartAshramIdSelection")==appji_ashram_id)
            	{
            		$cartItem['options']['donation_on_family_type'] = 13;
            	}
				else if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members'] != 'All family members')
				{
					$itemData['options']['donation_on_family_type'] = 7;
				}
				else
				{
					$itemData['options']['donation_on_family_type'] = 6;
				}
			}

			if($customData['cart_type']==4 && !isset($itemData['options']['subscription_on_family_type']))
			{
				if($this->session->userdata("subscriptionCartAshramIdSelection")==appji_ashram_id)
            	{
            		$itemData['options']['subscription_on_family_type'] = 14;
            	}
				else
				{
					$itemData['options']['subscription_on_family_type'] = 10;
				}
			}


			if(isset($itemData['options']['pooja_on_family_type']) && in_array($itemData['options']['pooja_on_family_type'],[0,1,2,3,8]))
			{
				if($itemData['options']['pooja_on_family_type'] == 0)
				{
					$pooja_on_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Ganapathy Sachchidananda Swamiji";
					$nameoffamilytype = 0;
				}
				if($itemData['options']['pooja_on_family_type'] == 1)
				{
					$pooja_on_teertha_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Datta Vijayananda Teertha Swamiji";
					$nameoffamilytype = 1;
				}
				if($itemData['options']['pooja_on_family_type'] == 2)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							$thisnote .= $thisdonr['donor_name']."\r\n";
							if($selectedfamilymembers == '')
							{
								$selectedfamilymembers .= $thisdonr['donor_id'];
							} else {
								$selectedfamilymembers .= ','.$thisdonr['donor_id'];
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 2;
				}
				if($itemData['options']['pooja_on_family_type'] == 3)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							if(isset($itemData['options']['pooja_on_family_members']) && !empty($itemData['options']['pooja_on_family_members']) && in_array($thisdonr['donor_id'], $itemData['options']['pooja_on_family_members']))
							{
								$thisnote .= $thisdonr['donor_name']."\r\n";
								if($selectedfamilymembers == '')
								{
									$selectedfamilymembers .= $thisdonr['donor_id'];
								} else {
									$selectedfamilymembers .= ','.$thisdonr['donor_id'];
								}
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 3;
				}
				if($itemData['options']['pooja_on_family_type'] == 8)
				{
					$itemData['options']['family_member_details'] = '';
					for($othercount=1;$othercount<=10;$othercount++)
					{
						if(isset($itemData['options']['other_name'.$othercount]) && $itemData['options']['other_name'.$othercount]!='')
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							$itemData['options']['family_member_details'] .= trim($itemData['options']['other_name'.$othercount]);
							$friend_or_otherarr[$othercount] = trim($itemData['options']['other_name'.$othercount]);
						}
					}
					if(isset($itemData['options']['other_names']) && !empty($itemData['options']['other_names']))
					{
						$optionsOtherName = array();
						$optionsOtherNameKey = 1;
						foreach($itemData['options']['other_names'] as $thisName)
						{
							$optionsOtherName[$optionsOtherNameKey] = $thisName;
							$optionsOtherNameKey++;
						}
						for($othercount=1;$othercount<=10;$othercount++)
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							if(isset($optionsOtherName[$othercount]))
							{
								$itemData['options']['family_member_details'] .= trim($optionsOtherName[$othercount]);
								$friend_or_otherarr[$othercount] = trim($optionsOtherName[$othercount]);
							}
						}
					}
					$nameoffamilytype = 8;
				}
			}


			if(isset($itemData['options']['donation_on_family_type']) && in_array($itemData['options']['donation_on_family_type'],[4,5,6,7,9,13]))
			{
				if($itemData['options']['donation_on_family_type'] == 4)
				{
					$pooja_on_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Ganapathy Sachchidananda Swamiji";
					$nameoffamilytype = 4;
				}
				if($itemData['options']['donation_on_family_type'] == 5)
				{
					$pooja_on_teertha_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Datta Vijayananda Teertha Swamiji";
					$nameoffamilytype = 5;
				}
				if($itemData['options']['donation_on_family_type'] == 6)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->where('is_hidden',0);
					$donorquery->order_by('donor_name','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							$thisnote .= $thisdonr['donor_name']."\r\n";
							if($selectedfamilymembers == '')
							{
								$selectedfamilymembers .= $thisdonr['donor_id'];
							} else {
								$selectedfamilymembers .= ','.$thisdonr['donor_id'];
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 6;
				}
				if($itemData['options']['donation_on_family_type'] == 7)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							if(in_array($thisdonr['donor_id'], $itemData['options']['donation_on_family_members']))
							{
								$thisnote .= $thisdonr['donor_name']."\r\n";
								if($selectedfamilymembers == '')
								{
									$selectedfamilymembers .= $thisdonr['donor_id'];
								} else {
									$selectedfamilymembers .= ','.$thisdonr['donor_id'];
								}
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 7;
				}
				if($itemData['options']['donation_on_family_type'] == 9)
				{
					$itemData['options']['family_member_details'] = '';
					for($othercount=1;$othercount<=10;$othercount++)
					{
						if(isset($itemData['options']['other_name'.$othercount]) && $itemData['options']['other_name'.$othercount]!='')
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							$itemData['options']['family_member_details'] .= trim($itemData['options']['other_name'.$othercount]);
							$friend_or_otherarr[$othercount] = trim($itemData['options']['other_name'.$othercount]);
						}
					}
					if(isset($itemData['options']['other_names']) && !empty($itemData['options']['other_names']))
					{
						$optionsOtherName = array();
						$optionsOtherNameKey = 1;
						foreach($itemData['options']['other_names'] as $thisName)
						{
							$optionsOtherName[$optionsOtherNameKey] = $thisName;
							$optionsOtherNameKey++;
						}
						for($othercount=1;$othercount<=10;$othercount++)
						{
							if($othercount>1)
							{
								$itemData['options']['family_member_details'] .=  "\r\n";
							}
							if(isset($optionsOtherName[$othercount]))
							{
								$itemData['options']['family_member_details'] .= trim($optionsOtherName[$othercount]);
								$friend_or_otherarr[$othercount] = trim($optionsOtherName[$othercount]);
							}
						}
					}
					$nameoffamilytype = 9;
				}
				if($itemData['options']['donation_on_family_type'] == 13)
				{
					$itemData['options']['family_member_details'] = '';
					if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
					{
						$itemData['options']['family_member_details'] = $itemData['options']['appji_member_name'];
					}
					if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
					{
						$itemData['options']['family_member_details'] .=  "\r\n".$itemData['options']['appji_member_email'];
					}
					$nameoffamilytype = 13;
				}
			}

			if(isset($itemData['options']['subscription_on_family_type']) && in_array($itemData['options']['subscription_on_family_type'],[10,11,12,14]))
			{
				if($itemData['options']['subscription_on_family_type'] == 10)
				{
					$donorquery=$this->auth_check;
					$donorquery->select("donor_name, donor_relation, id as donor_id");
					$donorquery->from('donors');
					$donorquery->where('is_hidden',0);
					$donorquery->where('user_id',$sso_user_id);
					$donorquery->order_by('id','ASC');
					$user_family_donors = $donorquery->get()->result_array();
					$thisnote = "";
					if(count($user_family_donors)>0){
						foreach($user_family_donors as $thisdonr)
						{
							if($thisdonr['donor_id']==$itemData['options']['subscription_on_family_member'])
							{
								$thisnote .= $thisdonr['donor_name']."\r\n";
								if($selectedfamilymembers == '')
								{
									$selectedfamilymembers .= $thisdonr['donor_id'];
									$itemData['options']['donor_id'] = $thisdonr['donor_id'];
								} else {
									$selectedfamilymembers .= ','.$thisdonr['donor_id'];
									$itemData['options']['donor_id'] = $thisdonr['donor_id'];
								}
							}
						}
					}
					$itemData['options']['family_member_details'] = $thisnote;
					$nameoffamilytype = 10;
				}
				if($itemData['options']['subscription_on_family_type'] == 11)
				{
					$pooja_on_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Ganapathy Sachchidananda Swamiji";
					$nameoffamilytype = 11;
				}
				if($itemData['options']['subscription_on_family_type'] == 12)
				{
					$pooja_on_teertha_swamiji = 1;
					$itemData['options']['family_member_details'] = "Sri Datta Vijayananda Teertha Swamiji";
					$nameoffamilytype = 12;
				}
				if($itemData['options']['subscription_on_family_type'] == 14)
				{
					$itemData['options']['family_member_details'] = '';
					if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
					{
						$itemData['options']['family_member_details'] = $itemData['options']['appji_member_name'];
					}
					if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
					{
						$itemData['options']['family_member_details'] .=  "\r\n".$itemData['options']['appji_member_email'];
					}
					$nameoffamilytype = 14;
				}
			}

			
			if($customData['cart_type']==1)
			{
				$shipDomestic="shipping_domestic_".strtolower($tempInfo->currency);
				$shipInternational="shipping_international_".strtolower($tempInfo->currency);
				$shippingPrice=0;
				$prasadam_status = 0;
				if($this->input->post('prasadam_not_required') && $this->input->post('prasadam_not_required') == 1)
				{
					$prasadam_status = 1;
				}
				if(isset($itemData['options']['shipping']) && $itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						if($itemData['options']['shipping_address']['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
					}
					else
                	{
                		if($info['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
                	}
				}
				$pitru_paksha_pooja = 0;
				$pitru_paksha_deceased_person_name = '';
				if(isset($itemData['options']['pitru_paksha_pooja']) && $itemData['options']['pitru_paksha_pooja']==1)
				{
					$pitru_paksha_pooja = 1;
					if(isset($itemData['options']['pitru_paksha_deceased_person_name']) && $itemData['options']['pitru_paksha_deceased_person_name']!='')
					{
						$itemData['options']['family_member_details'] = $itemData['options']['pitru_paksha_deceased_person_name'];
						$pitru_paksha_deceased_person_name = $itemData['options']['pitru_paksha_deceased_person_name'];
					}
					else
					{
						$itemData['options']['family_member_details'] = 'NA';
					}

					$selectedfamilymembers = '';
				}
				$is_poornaphala_seva = 0;
				$poornaphala_tie_by = '';
				if(isset($itemData['options']['is_poornaphala_seva']) && $itemData['options']['is_poornaphala_seva']==1)
				{
					$is_poornaphala_seva = 1;
					if(isset($itemData['options']['poornaphala_tie_by']))
					{
						$itemData['options']['poornaphala_tie_by'] = $itemData['options']['poornaphala_tie_by'];
						$poornaphala_tie_by = $itemData['options']['poornaphala_tie_by'];
					}
					else
					{
						$itemData['options']['poornaphala_tie_by'] = 'Priest will tie Poornaphala';
						$poornaphala_tie_by = "Priest will tie Poornaphala";
					}
				}

				$attend_pooja_in_person = '';
				if(isset($itemData['options']['is_attend_in_person']) && $itemData['options']['is_attend_in_person']==1)
				{
					if(isset($itemData['options']['attend_pooja_in_person']))
					{
						$itemData['options']['attend_pooja_in_person'] = $itemData['options']['attend_pooja_in_person'];
						$attend_pooja_in_person = $itemData['options']['attend_pooja_in_person'];
					}
					else
					{
						$itemData['options']['attend_pooja_in_person'] = 'I will not attend Pooja in-person';
						$attend_pooja_in_person = "I will not attend Pooja in-person";
					}
				}
				$max_family_members = 'All family members';
				if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members']>0)
				{
					$max_family_members = $itemData['options']['max_family_members'];
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'start_date'=>$itemData['options']['start_date'],
								'end_date'=>$itemData['options']['end_date'],
								'time_from'=>$itemData['options']['time_from'],
								'time_to'=>$itemData['options']['time_to'],
								'schedule_dates' =>$itemData['options']['result_date'],
								'options' =>serialize($itemData['options']),
								'prasadam_not_required'=>$prasadam_status,
								//'shipping'=>$itemData['options']['shipping'],
								//'shipping_price'=>$shippingPrice,
								'pooja_on_swamiji'=>$pooja_on_swamiji,
								'category'=>$itemData['options']['category'],
								'sequence'=>$seq,
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'personal_note'=>$itemData['options']['personal_note'],
								'family_member_details'=>$itemData['options']['family_member_details'],
								'pitru_paksha_pooja'=>$pitru_paksha_pooja,
								'pitru_paksha_deceased_person_name'=>$pitru_paksha_deceased_person_name,
								'is_poornaphala_seva'=>$is_poornaphala_seva,
								'poornaphala_tie_by'=>$poornaphala_tie_by,
								'attend_pooja_in_person'=>$attend_pooja_in_person,
								'name_of_family_type'=>$nameoffamilytype,
								'pooja_on_teertha_swamiji'=>$pooja_on_teertha_swamiji,
								'family_members'=>$selectedfamilymembers,
								'max_family_members'=>$max_family_members,
								'friend_or_other_1'=>$friend_or_otherarr[1],
								'friend_or_other_2'=>$friend_or_otherarr[2],
								'friend_or_other_3'=>$friend_or_otherarr[3],
								'friend_or_other_4'=>$friend_or_otherarr[4],
								'friend_or_other_5'=>$friend_or_otherarr[5],
								'friend_or_other_6'=>$friend_or_otherarr[6],
								'friend_or_other_7'=>$friend_or_otherarr[7],
								'friend_or_other_8'=>$friend_or_otherarr[8],
								'friend_or_other_9'=>$friend_or_otherarr[9],
								'friend_or_other_10'=>$friend_or_otherarr[10],
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);

				if(isset($itemData['options']['shipping']) && $itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						$orderItem['shipping_address1']=$itemData['options']['shipping_address']['address1'];
						$orderItem['shipping_address2']=$itemData['options']['shipping_address']['address2'];
						$orderItem['shipping_address3']=$itemData['options']['shipping_address']['address3'];
						$orderItem['shipping_city']=$itemData['options']['shipping_address']['city'];
						$orderItem['shipping_state']=$itemData['options']['shipping_address']['state'];
						$orderItem['shipping_country_name']=$itemData['options']['shipping_address']['country_name'];
						$orderItem['shipping_country']=$itemData['options']['shipping_address']['country'];
					}
					else
					{
						$countryData=$this->locations_model->getCountryByCode($info['country']);
						$orderItem['shipping_address1']=trim($info['address1']);
						$orderItem['shipping_address2']=trim($info['address2']);
						$orderItem['shipping_address3']=trim($info['address3']);
						$orderItem['shipping_city']=trim($info['city']);
						$orderItem['shipping_state']=trim($info['state']);
						$orderItem['shipping_country_name']=$countryData->country_name;
						$orderItem['shipping_country']=trim($info['country']);
					}
				}
			}
			else if($customData['cart_type']==2)
			{
				$max_family_members = 'All family members';
				if(isset($itemData['options']['max_family_members']) && $itemData['options']['max_family_members']>0)
				{
					$max_family_members = $itemData['options']['max_family_members'];
				}
				if(isset($itemData['options']['is_appji_donation']) && $itemData['options']['is_appji_donation']>0)
				{
					$is_from_appji = $itemData['options']['is_appji_donation'];
				}
				if(isset($itemData['options']['appji_link_token']) && $itemData['options']['appji_link_token']!='')
				{
					$link_token = $itemData['options']['appji_link_token'];
				}
				if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
				{
					$appji_member_name = $itemData['options']['appji_member_name'];
				}
				if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
				{
					$appji_member_email = $itemData['options']['appji_member_email'];
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'schedule_dates' =>$itemData['options']['result_date'],
								'options' =>serialize($itemData['options']),
								'sequence'=>$seq,
								'category'=>$itemData['options']['category'],
								'family_member_details'=>$itemData['options']['family_member_details'],
								'personal_note'=>$itemData['options']['personal_note'],
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'donor_id'=>$itemData['options']['donor_id'],
								'assign_pet'=>$itemData['options']['assign_pet'],
								'name_of_family_type'=>$nameoffamilytype,
								'pooja_on_teertha_swamiji'=>$pooja_on_teertha_swamiji,
								'family_members'=>$selectedfamilymembers,
								'pooja_on_swamiji'=>$pooja_on_swamiji,
								'max_family_members'=>$max_family_members,
								'friend_or_other_1'=>$friend_or_otherarr[1],
								'friend_or_other_2'=>$friend_or_otherarr[2],
								'friend_or_other_3'=>$friend_or_otherarr[3],
								'friend_or_other_4'=>$friend_or_otherarr[4],
								'friend_or_other_5'=>$friend_or_otherarr[5],
								'friend_or_other_6'=>$friend_or_otherarr[6],
								'friend_or_other_7'=>$friend_or_otherarr[7],
								'friend_or_other_8'=>$friend_or_otherarr[8],
								'friend_or_other_9'=>$friend_or_otherarr[9],
								'friend_or_other_10'=>$friend_or_otherarr[10],
								'is_from_appji'=>$is_from_appji,
								'link_token'=>$link_token,
								'appji_member_name'=>$appji_member_name,
								'appji_member_email'=>$appji_member_email,
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);
				if($itemData['options']['subscription']==1)
				{
					$orderItem['status']=0;
				}
			}
			else if($customData['cart_type']==3) //Store Item
			{
				$shipDomestic="shipping_domestic_".strtolower($tempInfo->currency);
				$shipInternational="shipping_international_".strtolower($tempInfo->currency);
				$shippingPrice=0;
				if($itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						if($itemData['options']['shipping_address']['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
					}
					else
                	{
                		if($info['country']=='IN')
						{
							$shippingPrice=$itemData['options'][$shipDomestic]*$itemData['qty'];
						}
						else
						{
							$shippingPrice=$itemData['options'][$shipInternational]*$itemData['qty'];
						}
                	}
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'family_member_details'=>isset($itemData['options']['family_member_details']) ? $itemData['options']['family_member_details'] : '',
								'personal_note'=>$itemData['options']['personal_note'],
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'shipping'=>$itemData['options']['shipping'],
								'shipping_price'=>$shippingPrice,
								'options' =>serialize($itemData['options']),
								'category'=>$itemData['options']['category'],
								'sequence'=>$seq,
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);
				if($itemData['options']['shipping']==1)
				{
					if(!empty($itemData['options']['shipping_address']))
					{
						$orderItem['shipping_address1']=$itemData['options']['shipping_address']['address1'];
						$orderItem['shipping_address2']=$itemData['options']['shipping_address']['address2'];
						$orderItem['shipping_address3']=$itemData['options']['shipping_address']['address3'];
						$orderItem['shipping_city']=$itemData['options']['shipping_address']['city'];
						$orderItem['shipping_state']=$itemData['options']['shipping_address']['state'];
						$orderItem['shipping_country_name']=$itemData['options']['shipping_address']['country_name'];
						$orderItem['shipping_country']=$itemData['options']['shipping_address']['country'];
					}
					else
					{
						$countryData=$this->locations_model->getCountryByCode($info['country']);
						$orderItem['shipping_address1']=trim($info['address1']);
						$orderItem['shipping_address2']=trim($info['address2']);
						$orderItem['shipping_address3']=trim($info['address3']);
						$orderItem['shipping_city']=trim($info['city']);
						$orderItem['shipping_state']=trim($info['state']);
						$orderItem['shipping_country_name']=$countryData->country_name;
						$orderItem['shipping_country']=trim($info['country']);
					}
				}
				if(isset($itemData['options']['gift_friend_email']))
				{
					$orderItem['gift_friend_email']=$itemData['options']['gift_friend_email'];
				}
				if(isset($itemData['options']['gift_friend_name']))
				{
					$orderItem['gift_friend_name']=$itemData['options']['gift_friend_name'];
				}
			}
			else if($customData['cart_type']==4)
			{
				$pay_till_cancel = 0;
				if(!empty($itemData['options']['pay_till_cancel']) && $itemData['options']['pay_till_cancel'] > 0)
				{
					$pay_till_cancel = 1;
					$itemData['options']['num_of_payments'] = 1;
				}
				if(isset($itemData['options']['is_appji_subscription']) && $itemData['options']['is_appji_subscription']>0)
				{
					$is_from_appji = $itemData['options']['is_appji_subscription'];
				}
				if(isset($itemData['options']['appji_link_token']) && $itemData['options']['appji_link_token']!='')
				{
					$link_token = $itemData['options']['appji_link_token'];
				}
				if(isset($itemData['options']['appji_member_name']) && $itemData['options']['appji_member_name']!='')
				{
					$appji_member_name = $itemData['options']['appji_member_name'];
				}
				if(isset($itemData['options']['appji_member_email']) && $itemData['options']['appji_member_email']!='')
				{
					$appji_member_email = $itemData['options']['appji_member_email'];
				}
				$orderItem=array(
								'order_id' => $order_id,
								'item_id'=>$itemData['id'],
								'item_name'=>$itemData['name'],
								'quantity' => $itemData['qty'],
								'price'=>$itemData['options'][$priceCol],
								'schedule_dates' =>$itemData['options']['result_date'],
								'options' =>serialize($itemData['options']),
								'sequence'=>$seq,
								'category'=>$itemData['options']['category'],
								'family_member_details'=>$itemData['options']['family_member_details'],
								'personal_note'=>$itemData['options']['personal_note'],
								'have_personal_note'=>$itemData['options']['have_personal_note'],
								'subscription'=>$itemData['options']['subscription'],
								'onetime_charge'=>$itemData['options'][$onetimeChargeCol],
								'period'=>$itemData['options']['period'],
								'frequency'=>$itemData['options']['frequency'],
								'pay_till_cancel'=>$pay_till_cancel,
								'expiry_date'=>$itemData['options']['subscription_expiry_date'],
								'expiration_method'=>$itemData['options']['expiration_method'],
								'num_of_payments'=>$itemData['options']['num_of_payments'],
								'given_expiry_date'=>$itemData['options']['expiry_date'],
								'donor_id'=>$itemData['options']['donor_id'],
								'assign_pet'=>$itemData['options']['assign_pet'],
								'name_of_family_type'=>$nameoffamilytype,
								'pooja_on_teertha_swamiji'=>$pooja_on_teertha_swamiji,
								'family_members'=>$selectedfamilymembers,
								'pooja_on_swamiji'=>$pooja_on_swamiji,
								'is_from_appji'=>$is_from_appji,
								'link_token'=>$link_token,
								'appji_member_name'=>$appji_member_name,
								'appji_member_email'=>$appji_member_email,
								'custom_email_text'=>isset($itemData['options']['custom_email_text']) ? $itemData['options']['custom_email_text'] : '',
								'custom_sms_text'=>isset($itemData['options']['custom_sms_text']) ? $itemData['options']['custom_sms_text'] : '',
							);
				if($itemData['options']['subscription']==1)
				{
					$orderItem['status']=0;
				}

				$this->db->where("id",$order_id);
				$this->db->update($this->tableName,
									array("subscription_mixed_order"=>1)
								);
			}
			$q=$this->db->insert('order_items',$orderItem);

			$itemId=$this->db->insert_id();

			if(isset($itemData['options']['subscription']) && $itemData['options']['subscription']==1)
			{
				$orderItem['id']=$itemId;
				/*echo $itemId;
				print_r($orderItem);*/
				$this->subscription_payments_model->createRecords($orderItem);
			}

			if($customData['cart_type']==1 || $customData['cart_type']==2 || $customData['cart_type']==4)
			{
				$itemDates=array_filter(explode(",",$itemData['options']['result_date']));
				foreach($itemDates as $itemDate)
				{
					$this->db->insert("order_items_dates",
									  	array(
											  'order_id'=>$order_id,
											  'order_item_id'=>$itemId,
											  'date'=>date("Y:m:d H:i:s",strtotime($itemDate))
											  )
									);
				}
				if(isset($is_poornaphala_seva) && $is_poornaphala_seva==1)
				{
					$this->generatePoornaphalaUniqueIdByOrderItemId($itemId);
				}
			}
			else
			{
				$orgItem=unserialize($itemData['options']['item_data']);
				$dFiles=$orgItem['files'];
				if(!empty($dFiles))
				{
					foreach ($dFiles as $fileData)
					{
						$this->db->insert("order_items_files",
											array(
													'order_item_id'=>$itemId,
													'order_id'=>$order_id,
													'filename'=>$fileData->filename,
													'title'=>$fileData->title,
													'description'=>$fileData->description,
													'size'=>$fileData->size,
													'file_id'=>$fileData->id
												)
										);
					}
				}
			}
		}

		$this->db->where("order_id",$order_id);
		$this->db->update("order_items",
							array("order_type"=>$customData['cart_type'])
						);

		//Delete cart
		$this->db->where("reference_id",$reference);
		$this->db->delete("cart_data");

		//Vishwashanti pada yatra donations save saperate table
		if(global_site_flag==1 && $customData['cart_type']==2)
        {
        	$itemResults = $this->updateVishwashantiPadaYatraDonationOrderItems($order_id);
        	if(!empty($itemResults))
			{
				foreach ($itemResults as $key => $thisResult)
				{
					$this->db->insert('vishwashanti_pada_yatra_orders',$thisResult);
				}
			}

			$itemResults = $this->updateShodashaDattaKshetraPadaYatraDonationOrderItems($order_id);
        	if(!empty($itemResults))
			{
				foreach ($itemResults as $key => $thisResult)
				{
					$this->db->insert('shodasha_datta_kshetra_pada_yatra_orders',$thisResult);
				}
			}
        }

		if($paymentStatus==1 || 1)
		{
			/*if($customData['paymentMode']!='paypal')
			{
				$this->sendOrderReceiptEmail($order_id);
			}*/
			if($info['is_manual_payment']==0)
			{
				$this->sendOrderDetailsEmail($order_id);
				// $this->sendOrderGiftEmail($order_id);
			}
			$this->sendOrderDetailsEmailBcc($order_id);
			$this->sendOrderDetailsCustomSms($order_id);
		}
		if($is_appji_order == 1)
		{
			$this->updateAppjiLinkTokens($order_id);
		}
		if($customData['paymentMode'] != 'cash' && $is_appji_order == 1)
		{
			$this->sendOrderPaymentStatusToAppjiServer($order_id);
		}

		//Auto subscrive to ashram newsletters
		$this->load->model("ashrams/ashram_members_model");
		if(!$this->ashram_members_model->checkSubscribe($customData['ashramData']->id,$tempInfo->user_id))
		{
			$this->ashram_members_model->subscribe($customData['ashramData']->id,$tempInfo->user_id);	
		}
		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
				$user_id=$this->session->userdata('admin_data')->id;
			else
				$user_id=$this->session->userdata('user_data')->id;
		}
		else
		{
			$user_id = $tempInfo->user_id;
		}
		if($username=='')
		{
			if($this->session->userdata('loggedIn'))
			{
				if($this->session->userdata('id'))
					$username=$this->session->userdata('admin_data')->username;
				else
					$username=$this->session->userdata('user_data')->username;
			}
		}
		else
		{
			$username=$username;
		}
		if(isset($customData['cart_type']) && $customData['cart_type']==3)
		{
			$this->order_log_model->log($order_id,"Order created",$user_id,$username);
		}
		else
		{
			if(isset($order_declaration_type) && $order_declaration_type=='Gift')
			{
				$this->order_log_model->log($order_id,"Gift created",$user_id,$username);
			}
			else
			{
				$this->order_log_model->log($order_id,"Seva created",$user_id,$username);
			}
		}
		
		return array("order_id"=>$order_id);
	}
	public function sendOrderGiftEmail($orderId,$orderItemID=0)
	{
		$orderData=$this->orderData($orderId);
		if(empty($orderData['order']))
			return 0;

		if($orderData['order']->order_type!=3)
			return 0;

		$fileDownloads=array();
		if(!empty($orderData['order_items_files']))
		{
			foreach ($orderData['order_items_files'] as $fileData)
			{
				$fileDownloads[$fileData->order_item_id][]=$fileData;
			}
		}
		
		if(!empty($fileDownloads))
		foreach ($orderData['order_items'] as $orderItem)
		{
			if($orderItemID && $orderItemID!=$orderItem->id)
			{
				continue;
			}

			if($orderItem->shipping==0 && isset($fileDownloads[$orderItem->id]))
			{
				$giftEmailData['fileDownloads']=$fileDownloads[$orderItem->id];
				$giftEmailData['orderData']=$orderData;
				$body=$this->load->view("orders/public/_email_gift_item",$giftEmailData,true);
				$subject=$orderData['order']->ashram_name.' - You have a gift from '.$orderData['order']->firstname." ".$orderData['order']->lastname;
				$this->email_extension->sendMailGuest(
														'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
														$orderItem->gift_friend_email,
														$orderItem->gift_friend_email,
														$subject,
														$body,
														'',
														1);
			}
		}
	}
	public function sendOrderReceiptEmail($orderId)
	{
		$orderData=$this->orderData($orderId);
		if($orderData['order']->is_manual_payment==0)
		{
			$this->sendTransactionReceiptEmail($orderId,$orderData['order']->transaction_id);
			//$this->sendTransactionReceiptEmailBcc($orderId,$orderData['order']->transaction_id);
			/*$data['orderData']=$orderData;
			$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
			$body=$this->load->view("orders/public/_email_order_receipt",$data,true);
			$subject=$orderData['order']->ashram_name.' - Receipt for Transaction: '.$orderData['order']->tx;
			$this->email_extension->sendMailGuest(
													'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
													$orderData['order']->firstname." ".$orderData['order']->lastname,
													$orderData['order']->email,
													$subject,
													$body,
													'',
													1);*/

			return 1;
		}
		else
		{
			return 0;
		}
	}
	public function sendCollectPaymentEmail($orderId)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		if($orderData['order']->is_manual_payment==1)
			return 0;

		$data['orderData']=$orderData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_collect_payments",$data,true);
		$subject=$orderData['order']->ashram_name.' - Request for payment - '.$orderData['order']->order_number;
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);
		return 1;
	}
	public function sendOrderDetailsEmail($orderId)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
			return 1;
		}
		if($orderData['order']->is_manual_payment==1)
			return 0;

		$data['orderData']=$orderData;
		$data ['donors'] = [];
      	if($orderData['order']->user_id!='')
      	{
      		$this->load->model("user/users_model");
			$sso_user_id = $this->users_model->getSSOUserID($orderData['order']->user_id);
			$this->load->model("subscriptions/donors_model");
			$data ['donors'] = $this->donors_model->getUserDonorsWithFullData($sso_user_id);
      	}
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_order_details",$data,true);
		if($orderData['order']->order_type==3)
			$subject=$orderData['order']->ashram_name.' - Order Details for Order ID: '.$orderData['order']->order_number;
		else
			$subject=$orderData['order']->ashram_name.' - '.$sevsOrGift.' Details - '.$sevsOrGift.' ID: '.$orderData['order']->order_number;
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);
		return 1;
	}
	public function sendOrderDetailsEmailBcc($orderId)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$data['orderData']=$orderData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_order_details_bcc",$data,true);
		if($orderData['order']->order_type==3)
			$subject=$orderData['order']->ashram_name.' - Order Details for Order ID: '.$orderData['order']->order_number;
		else
			$subject=$orderData['order']->ashram_name.' - '.$sevsOrGift.' Details - '.$sevsOrGift.' ID: '.$orderData['order']->order_number;
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												"Admin",
												orders_email_cc,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);
		return 1;
	}

	public function sendTransactionReceiptEmailBcc($orderId,$tx)
	{
		$orderData=$this->orderData($orderId);
		$transaction=$this->transaction_model->getTransactionByTx($tx);
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);

		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		
		if(in_array($transaction->status,$this->payment_success_statuses))
		{
			$data['orderData']=$orderData;
			$data['transaction']=$transaction;
			
			$body=$this->load->view("orders/public/_email_transaction_receipt_bcc",$data,true);
			if($sevsOrGift == "Gift")
			{
				$subject=$orderData['order']->ashram_name.' - '.$sevsOrGift.' ID: '.$orderData['order']->order_number;
			}
			else
			{
				$subject=$orderData['order']->ashram_name.' - Receipt for Transaction: '.$tx." - ".$sevsOrGift." ID: ".$orderData['order']->order_number;
			}
			$this->email_extension->sendMailGuest(
													'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
													"Admin",
													orders_email_cc_2,
													$subject,
													$body,
													'',
													1,
													'',
													$sevsOrGift
												);
		}

		return 1;
	}
	
	public function sendTransactionReceiptEmail($orderId,$tx,$sendSms=1)
	{
		$orderData=$this->orderData($orderId);
		$transaction=$this->transaction_model->getTransactionByTx($tx);
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);

		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		
		if(in_array($transaction->status,$this->payment_success_statuses))
		{
			$data['orderData']=$orderData;
			$data['transaction']=$transaction;
			
			$body=$this->load->view("orders/public/_email_transaction_receipt",$data,true);
			if($sevsOrGift == "Gift")
			{
				$subject=$orderData['order']->ashram_name.' - '.$sevsOrGift.' ID: '.$orderData['order']->order_number;
			}
			else
			{
				$subject=$orderData['order']->ashram_name.' - Receipt for Transaction: '.$tx." - ".$sevsOrGift." ID: ".$orderData['order']->order_number;
			}
			$this->email_extension->sendOrdersMail(
													'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
													$orderData['order']->user_id,
													$orderData['order']->firstname." ".$orderData['order']->lastname,
													$orderData['order']->email,
													$subject,
													$body,
													'',
													1,
													'',
													$sevsOrGift
												);
		}

		if($transaction->payment_mode=='paypal')
			$transaction->started_on=$transaction->created_on;

		$this->load->library("sms");
		if($transaction->payment_mode == "cashiers_check"){
			$transaction->payment_mode = "cashiers check";
		}
		if($transaction->payment_mode == "paypal" && $transaction->status="approved"){
			$transaction->status = "Paid";
		}
		if($transaction->payment_mode == "payu" && strtolower($transaction->status)=='release payment'){
			$transaction->status = "Paid";
		}
		if($transaction->payment_mode == "razorpay" && $transaction->status="captured"){
			$transaction->status = "Paid";
		}
		if(in_array(strtolower($transaction->status),$this->payment_success_statuses))
			$transaction->status="Paid";
		
		if($sendSms==1)
		{
			$message=
					display_site_name."\n".
					"Payment update:\n".
					$sevsOrGift." ID: ".$orderData['order']->order_number."\n".
					"Tx Date: ".date("d M Y",strtotime($transaction->started_on))."\n".
					"Amount: ".strtoupper($orderData['order']->currency)." ".$transaction->amount."\n".
					"Payment mode: ".$transaction->payment_mode."\n".
					"Tx status: ".ucwords($transaction->status)
					;
			$this->sms->sendSMS(
									'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
									$data['countryData']->isd_code.$orderData['order']->phone,
									$message,
									1,
									$orderData['order']->user_id,
									$orderData['order']->username,
									$data['countryData']->isd_code
								);
		}

		return 1;
	}

	public function sendSubscriptionPaymentEmail($orderId,$order_item_id,$payment_id,$sendSms=1)
	{
		$orderData=$this->orderData($orderId);

		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}

		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$paymentData=$this->subscription_payments_model->getById($payment_id);
		if(empty($paymentData) || $paymentData->order_id!=$orderId || $paymentData->order_item_id!=$order_item_id)
		{
			return 0;
		}
		
		$data['orderData']=$orderData;
		$data['itemData']=$orderItem;
		$data['paymentData']=$paymentData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_subscription_payment",$data,true);
		$subject=$orderData['order']->ashram_name.' - Payment Notification - Subscription payment for '.$orderItem->item_name;
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);

		if($sendSms==1)
		{
			$this->load->library("sms");
			$paymentStatus="Paid";
			if($paymentData->status==0)
			{
				$paymentStatus="Pending";
			}
			else if($paymentData->status==1)
			{
				$paymentStatus="Failed";
			}
			else if($paymentData->status==8)
			{
				$paymentStatus="Paid";
			}
			else if($paymentData->status==101)
			{
				$paymentStatus="In process";
			}
			else if($paymentData->status==102)
			{
				$paymentStatus="Bounced";
			}
			else if($paymentData->status==103)
			{
				$paymentStatus="Refunded";
			}
			else
			{
				$paymentStatus="Failed";
			}


			$message=display_site_name."\n".
					"Payment update:\n".
					$sevsOrGift." ID: ".$orderData['order']->order_number."\n".
					"Subscription: ".$orderItem->item_name."\n".
					"Tx Date: ".date("d M Y",strtotime($paymentData->date))."\n".
					"Amount: ".strtoupper($orderData['order']->currency)." ".$paymentData->amount."\n".
					"Payment mode: ".$paymentData->payment_mode."\n".
					"Payment status: ".$paymentStatus."\n".
					""
					;
			$this->sms->sendSMS(
									'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
									$data['countryData']->isd_code.$orderData['order']->phone,
									$message,
									1,
									$orderData['order']->user_id,
									$data['countryData']->isd_code
								);
		}
		return 1;
	}

	public function updateOrderCancelFlag($orderData,$cancel_status,$cancel_reason="",$cancel_date="")
	{
		if($cancel_status == 0)
		{
			$updateData = array(
                        "is_cancelled"=>0,
                        "cancel_reason"=>NULL,
                        "cancelled_on"=>NULL,
                        );
			$this->db->where(array('id'=>$orderData["order"]->id));
	        $this->db->update('orders',$updateData);
		}
		else if($cancel_status == 1)
		{
			$updateData = array(
                        "is_cancelled"=>1,
                        "cancel_reason"=>$cancel_reason,
                        "cancelled_on"=>date("Y-m-d H:i:s",strtotime($cancel_date)),
                        );
			$this->db->where(array('id'=>$orderData["order"]->id));
	        $this->db->update('orders',$updateData);
	        $this->sendorderCancelEmail($orderData["order"]->id,$orderData);
		}
	}

	public function sendorderCancelEmail($orderId,$orderData)
	{
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}

		$data['orderData']=$orderData;
		$body=$this->load->view("orders/public/_email_order_cancel",$data,true);
		$subject=$orderData['order']->ashram_name.' - '.$sevsOrGift.' Cancel Notification for '.$orderData["order"]->order_number;
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);
		return 1;
	}

	//Payment fails status email for paypal transactions to admin as cc
	public function sendSubscriptionPaymentEmailBCC($orderId,$order_item_id,$payment_id,$sendSms=1)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$paymentData=$this->subscription_payments_model->getById($payment_id);
		if(empty($paymentData) || $paymentData->order_id!=$orderId || $paymentData->order_item_id!=$order_item_id)
		{
			return 0;
		}
		
		$data['orderData']=$orderData;
		$data['itemData']=$orderItem;
		$data['paymentData']=$paymentData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_subscription_payment_bcc",$data,true);
		$subject=$orderData['order']->ashram_name.' - Payment Notification - Subscription payment for '.$orderItem->item_name;
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												"Admin",
												orders_email_cc_2,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);

		return 1;
	}

	public function sendSubscriptionTransactionStatusEmailBCC($orderId,$order_item_id,$payment_id,$sendSms=1)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$paymentData=$this->subscription_payments_model->getById($payment_id);
		if(empty($paymentData) || $paymentData->order_id!=$orderId || $paymentData->order_item_id!=$order_item_id)
		{
			return 0;
		}
		$txData=$this->transaction_model->getTransactionByTx($paymentData->tx);
		$data['orderData']=$orderData;
		$data['itemData']=$orderItem;
		$data['paymentData']=$paymentData;
		$data['txData']=$txData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_subscription_payment_status",$data,true);
		$subject=$orderData['order']->ashram_name.' - Payment Status - Subscription payment for '.$orderItem->item_name;
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												"Admin",
												orders_email_cc_2,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);

		
		return 1;
	}

	public function sendSubscriptionTransactionStatusEmail($orderId,$order_item_id,$payment_id,$sendSms=1)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$paymentData=$this->subscription_payments_model->getById($payment_id);
		if(empty($paymentData) || $paymentData->order_id!=$orderId || $paymentData->order_item_id!=$order_item_id)
		{
			return 0;
		}
		$txData=$this->transaction_model->getTransactionByTx($paymentData->tx);
		$data['orderData']=$orderData;
		$data['itemData']=$orderItem;
		$data['paymentData']=$paymentData;
		$data['txData']=$txData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_subscription_payment_status",$data,true);
		$subject=$orderData['order']->ashram_name.' - Payment Status - Subscription payment for '.$orderItem->item_name;
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);

		$paymentStatus='';
		if($data['paymentData']->status==0)
		{
			$paymentStatus='Pending';
		}
		if($data['paymentData']->status==8)
		{
			$paymentStatus='Paid';
		}
		if($data['paymentData']->status==101)
		{
			$paymentStatus='In Process';
		}
		if($data['paymentData']->status==102)
		{
			$paymentStatus='Bounced';
		}
		if($data['paymentData']->status==103)
		{
			$paymentStatus='Refunded';
		}

		if($paymentData->payment_mode == "cashiers_check"){
			$paymentData->payment_mode = "cashiers check";
		}

		if($sendSms==1)
		{
			$this->load->library("sms");
			$message=display_site_name."\n".
					"Payment update:\n".
					$sevsOrGift." ID: ".$orderData['order']->order_number."\n".
					"Subscription: ".$orderItem->item_name."\n".
					"Tx Date: ".date("d M Y",strtotime($paymentData->date))."\n".
					"Amount: ".strtoupper($orderData['order']->currency)." ".$paymentData->amount."\n".
					"Payment mode: ".$paymentData->payment_mode."\n".
					"Payment status: ".$paymentStatus."\n".
					""
					;
			$this->sms->sendSMS(
									'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
									$data['countryData']->isd_code.$orderData['order']->phone,
									$message,
									1,
									$orderData['order']->user_id,
									$data['countryData']->isd_code
								);
		}
		return 1;
	}

	public function sendSubscriptionCancelEmail($orderId,$order_item_id)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		
		$data['orderData']=$orderData;
		$data['itemData']=$orderItem;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_subscription_cancelled",$data,true);
		$subject=$orderData['order']->ashram_name.' - Subscription for '.$orderItem->item_name." has been cancelled";
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);

		$this->load->library("sms");
		$message=
				display_site_name."\n".
				"Subscription update:\n".
				$sevsOrGift." ID: ".$orderData['order']->order_number."\n".
				"Subscription: ".$orderItem->item_name."\n".
				"Status: Cancelled"."\n".
				""
				;
		$this->sms->sendSMS(
								'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
								$data['countryData']->isd_code.$orderData['order']->phone,
								$message,
								1,
								$orderData['order']->user_id,
								$orderData['order']->username,
								$data['countryData']->isd_code
							);
		return 1;
	}

	//Subscription cancel Email BCC
	public function sendSubscriptionCancelEmailBCC($orderId,$order_item_id)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		
		$data['orderData']=$orderData;
		$data['itemData']=$orderItem;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_subscription_cancelled_bcc",$data,true);
		$subject=$orderData['order']->ashram_name.' - Subscription for '.$orderItem->item_name." has been cancelled";
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												"Admin",
												orders_email_cc_2,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);
		return 1;
	}

	public function sendTransactionStatusEmailBCC($orderId,$order_item_id,$tx)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$txData=$this->transaction_model->getTransactionByTx($tx);
		if(empty($txData) || $txData->order_id!=$orderId)
		{
			return 0;
		}
		
		$data['orderData']=$orderData;
		$data['itemData']=$orderItem;
		$data['txData']=$txData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_payment_status_bcc",$data,true);
		$subject=$orderData['order']->ashram_name.' - Payment Status - Payment for '.$orderItem->item_name;
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												"Admin",
												orders_email_cc_2,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);
	}

	public function sendTransactionStatusEmail($orderId,$order_item_id,$tx,$sendSms=1)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$txData=$this->transaction_model->getTransactionByTx($tx);
		if(empty($txData) || $txData->order_id!=$orderId)
		{
			return 0;
		}
		
		$data['orderData']=$orderData;
		$data['itemData']=$orderItem;
		$data['txData']=$txData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_payment_status",$data,true);
		$subject=$orderData['order']->ashram_name.' - Payment Status - Payment for '.$orderItem->item_name;
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);

		$paymentStatus='';

		if(in_array(strtolower($txData->status),$this->payment_success_statuses))
		{
			$paymentStatus='Pending';
		}
		else if(in_array($txData->status,array("pending","cash_pending")))
		{
			$paymentStatus='Pending';
		}
		else
		{
			if($txData->status=='inprocess')
			{
				$paymentStatus='In Process';
			}
			else if($txData->status=='bounced')
			{
				$paymentStatus='Bounced';
			}
			else if($txData->status=='refund')
			{
				$paymentStatus='Refunded';
			}
			else
			{
				if(in_array(strtolower($txData->status),$this->payment_success_statuses))
					$paymentStatus="Paid";
				else
					$paymentStatus=ucwords($txData->status);
			}
		}
		if($txData->payment_mode == "cashiers_check"){
			$txData->payment_mode = "cashiers check";
		}

		if($sendSms==1)
		{
			$this->load->library("sms");
			$message=display_site_name."\n".
					"Payment update:\n".
					$sevsOrGift." ID: ".$orderData['order']->order_number."\n".
					"Subscription: ".$orderItem->item_name."\n".
					"Tx Date: ".date("d M Y",strtotime($txData->started_on))."\n".
					"Amount: ".strtoupper($orderData['order']->currency)." ".$txData->amount."\n".
					"Payment mode: ".$txData->payment_mode."\n".
					"Payment status: ".$paymentStatus."\n".
					""
					;
			$this->sms->sendSMS(
									'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
									$data['countryData']->isd_code.$orderData['order']->phone,
									$message,
									1,
									$orderData['order']->user_id,
									$orderData['order']->username,
									$data['countryData']->isd_code
								);
		}
		return 1;
	}

	public function sendTransactionStatusEmailOffline($orderId,$tx,$sendSms=1)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$txData=$this->transaction_model->getTransactionByTx($tx);
		if(empty($txData) || $txData->order_id!=$orderId)
		{
			return 0;
		}
		
		$data['orderData']=$orderData;
		$data['txData']=$txData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_payment_status_offline",$data,true);
		$subject=$orderData['order']->ashram_name.' - Payment Status - Payment for '.$orderData['order']->order_number;
		$this->email_extension->sendOrdersMail(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);

		$paymentStatus='';

		if(in_array(strtolower($txData->status),$this->payment_success_statuses))
		{
			$paymentStatus='Paid';
		}
		else if(in_array($txData->status,array("pending","cash_pending")))
		{
			$paymentStatus='Pending';
		}
		else
		{
			if($txData->status=='inprocess')
			{
				$paymentStatus='In Process';
			}
			else if($txData->status=='bounced')
			{
				$paymentStatus='Bounced';
			}
			else if($txData->status=='refund')
			{
				$paymentStatus='Refunded';
			}
			else
			{
				if(in_array(strtolower($txData->status),$this->payment_success_statuses))
					$paymentStatus="Paid";
				else
					$paymentStatus=ucwords($txData->status);
			}
		}

		if($txData->payment_mode == "cashiers_check"){
			$txData->payment_mode = "cashiers check";
		}

		if($sendSms==1)
		{
			$this->load->library("sms");
			$message=display_site_name."\n".
					"Payment update:\n".
					$sevsOrGift." ID: ".$orderData['order']->order_number."\n".
					"Tx Date: ".date("d M Y",strtotime($txData->started_on))."\n".
					"Amount: ".strtoupper($orderData['order']->currency)." ".$txData->amount."\n".
					"Payment mode: ".$txData->payment_mode."\n".
					"Payment status: ".$paymentStatus."\n".
					""
					;
			$this->sms->sendSMS(
									'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
									$data['countryData']->isd_code.$orderData['order']->phone,
									$message,
									1,
									$orderData['order']->user_id,
									$orderData['order']->username,
									$data['countryData']->isd_code
								);
		}
		return 1;
	}

	public function sendTransactionStatusEmailOfflineBCC($orderId,$tx,$sendSms=0)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$txData=$this->transaction_model->getTransactionByTx($tx);
		if(empty($txData) || $txData->order_id!=$orderId)
		{
			return 0;
		}
		
		$data['orderData']=$orderData;
		$data['txData']=$txData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_payment_status_offline_bcc",$data,true);
		$subject=$orderData['order']->ashram_name.' - Payment Status - Payment for '.$orderData['order']->order_number;
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												"Admin",
												orders_email_cc_2,
												$subject,
												$body,
												'',
												1,
												'',
												$sevsOrGift
											);
		return 1;
	}

	public function tokenIssued($orderId)
	{

		$orderData=$this->orderData($orderId);

		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		/*if(empty($orderData['order']))
			return 0;

		if($this->session->userdata("ashramId"))
		{
			if($orderData->ashram_id!=$this->session->userdata("ashramId"))
				return 0;
		}*/

		if($orderData['order']->tokens==1)
			return 2;

		$this->db->where("id",$orderId);
		$this->db->update($this->tableName,
							array(
									"tokens"=>1,
									"tokens_issued_on"=>date("Y:m:d H:i:s"),
									"tokens_issued_by"=>$this->currentUser->id
								)
						);

		$odata['orderData']=$orderData;
		if($orderData['order']->is_manual_payment==0)
		{
			$body=$this->load->view("orders/user/_order_token",$odata,true);

			$subject=$orderData['order']->ashram_name.' - Prasadam Tokens issued for '.$sevsOrGift.' ID: '.$orderData['order']->order_number;
			$this->email_extension->sendOrdersMail(
													'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
													$orderData['order']->user_id,
													$orderData['order']->firstname." ".$orderData['order']->lastname,
													$orderData['order']->email,
													$subject,
													$body,
													'',
													1,
													'',
													$sevsOrGift);
		}
		return 1;

	}

	public function updateDownloadCount($fileId,$count)
	{
		$this->db->where("id",$fileId);
		$this->db->update("order_items_files",array("downloads"=>$count));

		$this->db->insert("order_items_downloads",
							array
							(
								"file_id"=>$fileId,
								"date"=>date("Y:m:d H:i:s"),
								"ip_address"=>$_SERVER['REMOTE_ADDR'],
								'browser'=>$this->agent->browser()." ".$this->agent->version()
							)
						);
	}

	public function fileUsage($fileId)
	{
		$this->db->where("file_id",$fileId);
		$q=$this->db->get("order_items_files");
		return $q->num_rows();
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->poojasExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==3)
		{
			$objPHPExcel=$this->donationsExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==4)
		{
			$objPHPExcel=$this->poojasPrasadamExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==5)
		{
			$objPHPExcel=$this->storeExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==6)
		{
			$objPHPExcel=$this->subscriptionsExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==7)
		{
			$objPHPExcel=$this->sevaKartaPoojasExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==8)
		{
			$objPHPExcel=$this->sevaKartaDonationsExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		#Author: Baji
		#Branch: bajidotwork_DPDEV-failedsubscriptionpayments
		if($excelData->page_number==9)
		{
			$objPHPExcel=$this->FailedsubscriptionsExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==10)
		{
			$objPHPExcel=$this->listAdminFailedOnetimeReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==11)
		{
			$objPHPExcel=$this->sevaKartaSubscriptionsExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		if($excelData->page_number==12)
		{
			$objPHPExcel=$this->mismatch_ashram_orders_excel_report($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		if($excelData->page_number==13)
		{
			$objPHPExcel=$this->poornaPhalaOrdersExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		if($excelData->page_number==14)
		{
			$objPHPExcel=$this->poojasByDateExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		if($excelData->page_number==15)
		{
			$objPHPExcel=$this->donationsByDateExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Paid");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created By");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Paid Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refunded Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Failed Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cancelled Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Inprocess Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounced Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens Issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Shipping Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"App?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);


		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$txids=$reportrow->paid_tx_ids;
			#$txids=str_replace("<br>",", ",$this->orderTransactions($reportrow->id,0,1));
			#$totalPaid=$this->orderTransactions($reportrow->id,1,1);
			$totalPaid=$reportrow->total_paid;
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$totalPaid);

			$otype="Poojas";
			if($reportrow->order_type==2)
				$otype="Donations";
			if($reportrow->order_type==3)
				$otype="Store";
			if($reportrow->order_type==4 || $reportrow->subscription_mixed_order==1)
				$otype="Subscription";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;
			if($reportrow->zipcode!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}

			

			$created_by="Admin";
			if($reportrow->created_by==2)
				$created_by="User";
			if($reportrow->created_by==0)
				$created_by="Guest";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$created_by);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cancelled_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->inprocess_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			

			$ship_status="N/A";
			if($reportrow->dispatch_status==1)
				$ship_status="Pending";
			else if($reportrow->dispatch_status==2)
				$ship_status="Completed";
			else if($reportrow->dispatch_status==3)
				$ship_status="Returned";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$ship_status);

			if($reportrow->app==1)
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"Yes");
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"No");

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function mismatch_ashram_orders_excel_report($excelData,$objPHPExcel)
	{	
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
						'fill' => array(
				            'type' => PHPExcel_Style_Fill::FILL_SOLID,
				            'color' => array('rgb' => 'FFFF00')
				        ),
							'font' => array(
							'bold' => true
							)
						);

		$styleArray1 = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray1);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;
		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Currency");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Ashram ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Original Ashram ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		foreach ($q->result() as $reportrow)
		{

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$ashramData1=$this->ashrams_model->ashramData($reportrow->order_ashram_id);
			$ashramData2=$this->ashrams_model->ashramData($reportrow->original_ashram_id);

			$ashram_name1 = $ashramData1->name . " (".$reportrow->order_ashram_id.")";
			$ashram_name2 = $ashramData1->name . " (".$reportrow->original_ashram_id.")";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$ashram_name1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$ashram_name2);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->order_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->order_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->order_date)));

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function poojasExcelReportAdmin($excelData,$objPHPExcel)
	{	
		$countries=$this->locations_model->getCountries(true);
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;
		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pooja Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pooja Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pooja Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Paid Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refunded Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Failed Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cancelled Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Inprocess Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounced Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Attend Pooja in-person");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created by");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if(in_array(global_site_flag, [2]))
	    {
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poorna Phala Serial(s)");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poorna Phala Tying Date(s)");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poorna Phala End Date(s)");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poorna Phala Tied by");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
	    }

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$txids = $reportrow->paid_tx_ids;

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			if($reportrow->username=='')
				$reportrow->username='Guest';
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->family_member_details);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;

			if(isset($reportrow->zipcode)!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$resultPoojaDates='';
			$poojaDates=array_filter(explode(",",$reportrow->schedule_dates));
			$rDates=array();
			foreach ($poojaDates as $poojaDate)
			{
				$poojaDateTime=strtotime($poojaDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=', ';
						$resultPoojaDates.=$poojaDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=', ';
						$resultPoojaDates.=$poojaDate;
					}
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultPoojaDates);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->personal_note);
			if($reportrow->updated_quantity>0)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->updated_quantity*$reportrow->price);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->quantity*$reportrow->price);
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cancelled_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->inprocess_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			
			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->attend_pooja_in_person);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			$created_by='';
			if($reportrow->created_by==0)
                $created_by = 'Guest';
            if($reportrow->created_by==1)
                $created_by = 'Admin';
            if($reportrow->created_by==2)
                $created_by = 'User';
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$created_by);

            if(in_array(global_site_flag, [2]))
	    	{
	    		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->poornaphala_ids);
	    		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultPoojaDates);
	    		$resultPPendDates='';
	    		if($reportrow->is_poornaphala_seva ==1)
	    		{
					$PPEndDates=array_filter(explode(",",$reportrow->poornaphala_end_dates));
					$resDates=array();
					foreach ($PPEndDates as $PPendDate)
					{
						$PPendDateTime=strtotime($PPendDate);
						if($fromDateTime!='')
						{
							if($fromDateTime<=$PPendDateTime && !in_array($PPendDate,$resDates))
							{
								$resDates[]=$PPendDate;
								if($resultPPendDates!='') $resultPPendDates.=', ';
								$resultPPendDates.=$PPendDate;
							}
						}
						if($toDateTime!='')
						{
							if($PPendDateTime<=$toDateTime && !in_array($PPendDate,$resDates))
							{
								$resDates[]=$PPendDate;
								if($resultPPendDates!='') $resultPPendDates.=', ';
								$resultPPendDates.=$PPendDate;
							}
						}
					}
				}
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultPPendDates);
	    		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->poornaphala_tie_by);
	    	}


			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
	private function sevaKartaPoojasExcelReportAdmin($excelData,$objPHPExcel)
	{	
		$countries=$this->locations_model->getCountries(true);
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;
		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pooja Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->family_member_details);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);
			
			$resultPoojaDates='';
			$poojaDates=array_filter(explode(",",$reportrow->schedule_dates));
			$rDates=array();
			
			foreach ($poojaDates as $poojaDate)
			{
				$poojaDateTime=strtotime($poojaDate);
				
				if($fromDateTime!='' && $toDateTime=='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=', ';
						$resultPoojaDates.=$poojaDate;
					}
				}
				else if($toDateTime!='' && $fromDateTime=='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=', ';
						$resultPoojaDates.=$poojaDate;
					}
				}
				else if($toDateTime!='' && $fromDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && $fromDateTime<=$poojaDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=', ';
						$resultPoojaDates.=$poojaDate;
					}
				}
				else
				{
					$rDates[]=$poojaDate;
					if($resultPoojaDates!='') $resultPoojaDates.=', ';
					$resultPoojaDates.=$poojaDate;
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultPoojaDates);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function donationsExcelReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

 		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donation Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donation Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donation Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Paid Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refunded Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Failed Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cancelled Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Inprocess Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounced Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created By");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if($this->session->userdata("ashramId")==appji_ashram_id)
        {
        	$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Email");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
        }

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$txids = $reportrow->paid_tx_ids;

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			if($reportrow->username=='')
				$reportrow->username='Guest';
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->family_member_details);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;

			if(isset($reportrow->zipcode)!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}
			

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$resultDonationDates='';
			$donationDates=array_filter(explode(",",$reportrow->schedule_dates));
			$rDates=array();
			foreach ($donationDates as $donationDate)
			{
				if($resultDonationDates!='') $resultDonationDates.=PHP_EOL;
				$poojaDateTime=strtotime($donationDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultDonationDates);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->personal_note);
			if($reportrow->updated_quantity>0)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->updated_quantity*$reportrow->price);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->quantity*$reportrow->price);
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cancelled_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->inprocess_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			
			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			$created_by='';
			if($reportrow->created_by==0)
                $created_by = 'Guest';
            if($reportrow->created_by==1)
                $created_by = 'Admin';
            if($reportrow->created_by==2)
                $created_by = 'User';
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$created_by);

            if($this->session->userdata("ashramId")==appji_ashram_id)
        	{
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_name);
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_email);
        	}

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}


	private function sevaKartaDonationsExcelReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donation Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donation Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if($this->session->userdata("ashramId")==appji_ashram_id)
        {
        	$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Email");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
        }

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$txids=str_replace("<br>",", ",$this->orderTransactions($reportrow->order_id));

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->family_member_details);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$resultDonationDates='';
			$donationDates=array_filter(explode(",",$reportrow->schedule_dates));
			$rDates=array();
			foreach ($donationDates as $donationDate)
			{
				if($resultDonationDates!='') $resultDonationDates.=PHP_EOL;
				$poojaDateTime=strtotime($donationDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultDonationDates);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			if($this->session->userdata("ashramId")==appji_ashram_id)
        	{
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_name);
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_email);
        	}

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function sevaKartaSubscriptionsExcelReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if($this->session->userdata("ashramId")==appji_ashram_id)
        {
        	$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Email");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
        }

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$txids=str_replace("<br>",", ",$this->orderTransactions($reportrow->order_id));

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->family_member_details);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$resultSubscriptionDates='';
			$subscriptionDates=array_filter(explode(",",$reportrow->schedule_dates));
			$rDates=array();
			foreach ($subscriptionDates as $subscriptionDate)
			{
				if($resultSubscriptionDates!='') $resultSubscriptionDates.=PHP_EOL;
				$subscriptionDateTime=strtotime($subscriptionDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$subscriptionDateTime && !in_array($subscriptionDate,$rDates))
					{
						$rDates[]=$subscriptionDate;
						if($resultSubscriptionDates!='') $resultSubscriptionDates.=', ';
						$resultSubscriptionDates.=$subscriptionDate;
					}
				}
				if($toDateTime!='')
				{
					if($subscriptionDateTime<=$toDateTime && !in_array($subscriptionDate,$rDates))
					{
						$rDates[]=$subscriptionDate;
						if($resultSubscriptionDates!='') $resultSubscriptionDates.=', ';
						$resultSubscriptionDates.=$subscriptionDate;
					}
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultSubscriptionDates);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			if($this->session->userdata("ashramId")==appji_ashram_id)
        	{
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_name);
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_email);
        	}

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function poojasPrasadamExcelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;
		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poojas & Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			
			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);

			$itemids=array_filter(explode(",",$reportrow->itemids));
			$items=array_filter(explode("???",$reportrow->items));
			$itemdates=array_filter(explode(",",$reportrow->itemdates));

			$itemsArray=array();
			foreach ($itemids as $key => $item_id)
			{
				$itemsArray[$item_id]['names'][]=$items[$key];
				$itemsArray[$item_id]['dates'][]=date("d M Y",strtotime($itemdates[$key]));
			}
			$itemsString='';
			foreach ($itemsArray as $key => $itemRow)
			{
				if($itemsString!='') $itemsString.=PHP_EOL;
				$itemsString.=$itemRow['names'][0]." (".implode(",",$itemRow['dates']).")";
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$itemsString);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function poojasPrasadamExcelReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());
		$totalPrasadams = 0;
		foreach ($q->result() as $reportrow)
		{
			$itemdatescount=count(array_filter(explode(",",$reportrow->itemdates)));
			$totalPrasadams += (int)$itemdatescount;
		}
		$j=$j+1;
		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Prasadams: ".$totalPrasadams);

		$j=$j+2;
		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);



		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poojas & Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens Issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Prasadam Required?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			if($reportrow->prasadam_not_required==1)
			{
				$styleArray = array(
			    'font'  => array(
			        'color' => array('rgb' => 'FF0000')
			    ));
				$objPHPExcel->getActiveSheet()->getStyle($i)->applyFromArray($styleArray)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFCECE');
				
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			
			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$countries[$reportrow->country]->country_name ."-". $reportrow->zipcode;
			$address.="\nPh: +".$countries[$reportrow->country]->isd_code." ".$reportrow->phone;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);

			$itemids=array_filter(explode(",",$reportrow->itemids));
			$items=array_filter(explode("???",$reportrow->items));
			$itemdates=array_filter(explode(",",$reportrow->itemdates));

			$itemsArray=array();
			foreach ($itemids as $key => $item_id)
			{
				$itemsArray[$item_id]['names'][]=$items[$key];
				$itemsArray[$item_id]['dates'][]=date("d M Y",strtotime($itemdates[$key]));
			}
			$objRichText = new PHPExcel_RichText();
			$itemCounts = 0;
			foreach ($itemsArray as $key => $itemRow)
			{
				$itemCounts++;
				$itemsString="";
				if($itemCounts>1)
				{
					$itemsString=PHP_EOL;
					$itemsString.=PHP_EOL;
				}
				$itemsString.=$itemRow['names'][0];
				$itemsString.=PHP_EOL;
				// $itemsString.="(<b>Total: ".count($itemRow['dates'])."</b>) (".implode(", ",$itemRow['dates']).")";

				// $objRichText = new PHPExcel_RichText();
				$objRichText->createText($itemsString);
				$objBold = $objRichText->createTextRun("(Total: ".count($itemRow['dates']).") ");
				$objBold->getFont()->setSize("13")->setBold(true);
				$objRichText->createText("(".implode(", ",$itemRow['dates']).")");
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$objRichText);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$p_required="No";
			if($reportrow->prasadam_not_required==0)
				$p_required="Yes";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$p_required);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function storeExcelReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order Date / Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Shipping Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Shipping address / Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Paid Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refunded Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Failed Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cancelled Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Inprocess Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounced Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Shipping Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created by");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Prasadam Required?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}
		foreach ($q->result() as $reportrow)
		{
			$txids = $reportrow->paid_tx_ids;
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			if($reportrow->username=='')
				$reportrow->username='Guest';
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->family_member_details);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;

			if(isset($reportrow->zipcode)!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}
			

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->personal_note);

			if($reportrow->gift_friend_name)
			{
				$giftfriendname = $reportrow->gift_friend_name;
			} else {
				$giftfriendname = $reportrow->firstname." ".$reportrow->lastname;
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$giftfriendname);

			if($reportrow->shipping==1)
			{
				$shipping_address=$reportrow->shipping_address1;
				if($reportrow->shipping_address2!='')
					$shipping_address.="\n".$reportrow->shipping_address2;
				if($reportrow->shipping_address3!='')
					$shipping_address.="\n".$reportrow->shipping_address3;
				$shipping_address.="\n".$reportrow->shipping_city;
				$shipping_address.="\n".$reportrow->shipping_state;
				$shipping_address.="\n".$reportrow->shipping_country_name;

				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$shipping_address);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gift_friend_email);
			}
			
			if($reportrow->updated_quantity>0)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->updated_quantity*$reportrow->price);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->quantity*$reportrow->price);
			}
			// $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->quantity*$reportrow->price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cancelled_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->inprocess_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$p_required="No";
			if($reportrow->prasadam_not_required==0)
				$p_required="Yes";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);
			

			$shippingStatus='N/A';
			if($reportrow->dispatch_status==1)
				$shippingStatus='Pending';
			if($reportrow->dispatch_status==2)
				$shippingStatus='Completed';
			if($reportrow->dispatch_status==3)
				$shippingStatus='Returned';

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$shippingStatus);

			$created_by='';
			if($reportrow->created_by==0)
                $created_by = 'Guest';
            if($reportrow->created_by==1)
                $created_by = 'Admin';
            if($reportrow->created_by==2)
                $created_by = 'User';
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$created_by);
            

            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$p_required);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function subscriptionsExcelReportUser($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Subscriptions Payments");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription Payments Paid");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pet #");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);


		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Start Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Paid");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Paid Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refunded Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Failed Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cancelled Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Inprocess Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounced Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$payments=$this->transaction_model->getTransactionsByOrderItem($reportrow->oiid,1);
			$total_count=count($payments);

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->num_of_payments);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_count);

			if($reportrow->pet_name!='')
			{
				$pet=$reportrow->pet_name;
			}
			else
			{
				$pet='N/A';
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pet);

			

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$resultDonationDates='';
			$donationDates=array_filter(explode(",",$reportrow->schedule_dates));
			$rDates=array();
			foreach ($donationDates as $donationDate)
			{
				if($resultDonationDates!='') $resultDonationDates.=PHP_EOL;
				$poojaDateTime=strtotime($donationDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultDonationDates);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->quantity*$reportrow->price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->paid_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cancelled_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->inprocess_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			
			$paymentStatus='N/A';
			if($reportrow->payment_status==1)
				$paymentStatus='Paid';
			if($reportrow->payment_status==0)
				$paymentStatus='Pending';
			if($reportrow->payment_status==2)
				$paymentStatus='Partially Paid';

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$paymentStatus);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function subscriptionsExcelReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Start Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Subscriptions Count");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Paid Subscriptions Count");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refunded Subscriptions Count");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Paid");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Refunded");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pet #");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pet Serial No");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens Issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if($this->session->userdata("ashramId")==appji_ashram_id)
        {
        	$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Email");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
        }

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$payments=$this->transaction_model->getTransactionsByOrderItem($reportrow->oiid,1);
			$total_count=count($payments);

			$total_paid=0;
			$paid_count=0;
			
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			if($reportrow->username=='')
				$reportrow->username='Guest';
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->personal_note);
			$resultDonationDates='';
			$donationDates=array_filter(explode(",",$reportrow->schedule_dates));
			$rDates=array();
			foreach ($donationDates as $donationDate)
			{
				if($resultDonationDates!='') $resultDonationDates.=PHP_EOL;
				$poojaDateTime=strtotime($donationDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultDonationDates);
			if($reportrow->updated_quantity>0)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->updated_quantity*$reportrow->price);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->quantity*$reportrow->price);
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->num_of_payments);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_count);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_counts);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->paid_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->subscription_refunded_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_transaction_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			
			$paymentStatus='N/A';
			if($reportrow->payment_status==1)
				$paymentStatus='Paid';
			if($reportrow->payment_status==0)
				$paymentStatus='Pending';
			if($reportrow->payment_status==2)
				$paymentStatus='Partially Paid';

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$paymentStatus);
			if($reportrow->pet_name!='')
			{
				$pet=$reportrow->pet_name;
			}
			else
			{
				$pet='N/A';
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pet);

			
			if($reportrow->pet_serial_number!='')
			{
				$petsno=$reportrow->pet_serial_number;
			}
			else
			{
				$petsno='N/A';
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$petsno);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;

			if(isset($reportrow->zipcode)!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);
			
			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			if($this->session->userdata("ashramId")==appji_ashram_id)
        	{
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_name);
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_email);
        	}

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function listAdminFailedOnetimeReport($excelData,$objPHPExcel)
	{	
		$countries=$this->locations_model->getCountries(true);
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;
		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			if($reportrow->username=='')
				$reportrow->username='Guest';
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->family_member_details);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;

			$txnote = "";
			if($reportrow->ts_note != "")
			{
				$txnote = nl2br($reportrow->ts_note);
				$txnote = strip_tags($txnote);
			}

			if(isset($reportrow->zipcode)!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$txnote);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->fail_amount);
			$tx_date = "";
			if($reportrow->payment_created_on)
				$tx_date = date("d M Y",strtotime($reportrow->payment_created_on));
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->transaction_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tx_date);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->tranx_status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	#Author: Baji
	#Branch: bajidotwork_DPDEV-failedsubscriptionpayments
	private function FailedsubscriptionsExcelReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment #");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);
		$c=0;
		foreach ($q->result() as $reportrow)
		{

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			if($reportrow->username=='')
				$reportrow->username='Guest';
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);

			$txnote = "";
			if($reportrow->tranx_note != "")
			{
				$txnote = nl2br($reportrow->tranx_note);
				$txnote = strip_tags($txnote);
			}
			
			$tx_date = "";
			if($reportrow->payment_created_on)
				$tx_date = date("d M Y",strtotime($reportrow->payment_created_on));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tx_date);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->fail_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->transaction_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->tranx_status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$txnote);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;
			if($reportrow->zipcode!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}


	public function excelReportUser($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->poojasExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==3)
		{
			$objPHPExcel=$this->donationsExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==6)
		{

			$objPHPExcel=$this->subscriptionsExcelReportUser($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==4)
		{
			$objPHPExcel=$this->storeExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==5)
		{
			$objPHPExcel=$this->summaryExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==7)
		{
			$objPHPExcel=$this->FailedsubscriptionsExcelReportUser($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==8)
		{
			$objPHPExcel=$this->noTxsevasExcelReportUser($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);


			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);

			$otype="Poojas";
			if($reportrow->order_type==2)
				$otype="Donations";
			if($reportrow->order_type==3)
				$otype="Store";
			if($reportrow->order_type==4 || $reportrow->subscription_mixed_order==1)
				$otype="Subscription";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function noTxsevasExcelReportUser($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);


			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);

			$otype="Poojas";
			if($reportrow->order_type==2)
				$otype="Donations";
			if($reportrow->order_type==3)
				$otype="Store";
			if($reportrow->order_type==4 || $reportrow->subscription_mixed_order==1)
				$otype="Subscription";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function FailedsubscriptionsExcelReportUser($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment#");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Currency");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);
		$c=0;
		foreach ($q->result() as $reportrow)
		{

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_number);

			$tx_date = "";
			if($reportrow->payment_created_on)
				$tx_date = date("d M Y",strtotime($reportrow->payment_created_on));

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tx_date);

			$txnote = "";
			if($reportrow->tranx_note != "")
			{
				$txnote = nl2br($reportrow->tranx_note);
				$txnote = strip_tags($txnote);
			}
			$sub_status = "Pending";
			if($reportrow->sub_status == 8)
			{
				$sub_status = "Paid";
			}
			if($reportrow->sub_status == 1)
			{
				$sub_status = "Failed";
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$txnote);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->fail_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->transaction_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ts_payment_mode);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sub_status);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function poojasExcelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Pooja Name");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Pooja Dates");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Pooja Amount");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle('H'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle('I'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('J'.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle('J'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->item_name);
			$resultPoojaDates='';
			$poojaDates=array_filter(explode(",",$reportrow->schedule_dates));
			$rDates=array();
			foreach ($poojaDates as $poojaDate)
			{
				
				$poojaDateTime=strtotime($poojaDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=', ';
						$resultPoojaDates.=$poojaDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($poojaDate,$rDates))
					{
						$rDates[]=$poojaDate;
						if($resultPoojaDates!='') $resultPoojaDates.=', ';
						$resultPoojaDates.=$poojaDate;
					}
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$resultPoojaDates);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,strtoupper($reportrow->currency)." ".$reportrow->quantity*$reportrow->price);
			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,$reportrow->transaction_id);
			$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i,$reportrow->payment_alt_mode);
			$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i,$reportrow->family_member_details);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function donationsExcelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Donation Name");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Donation Dates");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Donation Amount");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle('H'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle('I'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('J'.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle('J'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->item_name);
			$resultDonationDates='';
			$donationDates=array_filter(explode(",",$reportrow->schedule_dates));
			$rDates=array();
			foreach ($donationDates as $donationDate)
			{
				
				$poojaDateTime=strtotime($donationDate);
				if($fromDateTime!='')
				{
					if($fromDateTime<=$poojaDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
				if($toDateTime!='')
				{
					if($poojaDateTime<=$toDateTime && !in_array($donationDate,$rDates))
					{
						$rDates[]=$donationDate;
						if($resultDonationDates!='') $resultDonationDates.=', ';
						$resultDonationDates.=$donationDate;
					}
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$resultDonationDates);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,strtoupper($reportrow->currency)." ".$reportrow->quantity*$reportrow->price);
			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,$reportrow->transaction_id);
			$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i,$reportrow->payment_alt_mode);
			$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i,$reportrow->family_member_details);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
	private function storeExcelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Item Name");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Item Amount");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle('H'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$j,"Shipping address / Gift Email ID");
		$objPHPExcel->getActiveSheet()->getStyle('I'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,strtoupper($reportrow->currency)." ".$reportrow->quantity*$reportrow->price);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,$reportrow->transaction_id);
			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,$reportrow->payment_alt_mode);
			if($reportrow->shipping==1)
			{
				if($reportrow->shipping_address1!='')
				{
					$address=$reportrow->shipping_address1;
					if($reportrow->shipping_address2!='')
						$address.="\n".$reportrow->shipping_address2;
					if($reportrow->shipping_address3!='')
						$address.="\n".$reportrow->shipping_address3;
					$address.="\n".$reportrow->shipping_city;
					$address.="\n".$reportrow->shipping_state;
					$address.="\n".$reportrow->shipping_country_name;
				}
				else
				{
					$address=$reportrow->address1;
					if($reportrow->address2!='')
						$address.="\n".$reportrow->address2;
					if($reportrow->address3!='')
						$address.="\n".$reportrow->address3;
					$address.="\n".$reportrow->city;
					$address.="\n".$reportrow->state;
					$address.="\n".$reportrow->country_name;
				}
				$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i,$address);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i,$reportrow->gift_friend_email);
			}
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function summaryExcelReport($excelData,$objPHPExcel)
	{
		$reports_db=$this->load->database("reports",true,false);
		// $q=$this->db->query($excelData->query);
		$q=$reports_db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		// $objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',"Donation Summary");

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Item");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Donation Amount");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$j,"Type");
		$objPHPExcel->getActiveSheet()->getStyle('H'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle('I'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('J'.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle('J'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,date("d M Y",strtotime($reportrow->order_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->item);
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->tx);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,date("d M Y",strtotime($reportrow->transaction_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,strtoupper($reportrow->currency)." ".$reportrow->amount);
			$type='Poojas';
			if($reportrow->order_type==2)
				$type='Donation';
			if($reportrow->order_type==3)
				$type='Store';
			if($reportrow->order_type==4)
				$type='Subscriptions';
			
			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,$type);

			$source_of_payment="Offline";
			$srcc_payment_mode = strtolower($reportrow->payment_mode);
			if($srcc_payment_mode == "paypal" || $srcc_payment_mode == "payu" || $srcc_payment_mode == "razorpay" || $srcc_payment_mode == "authorize.net" || $srcc_payment_mode == "stripe")
			{
				$source_of_payment="Online";
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i,$source_of_payment);

			$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i,$reportrow->payment_mode);


			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}


	public function sendOrderSummary()
	{
		$this->db->select("user_id,email,firstname,lastname");
		$this->db->where("user_id !=",0);
		$this->db->where("year(date)",date("Y"));
		$this->db->group_by("user_id");
		$q=$this->db->get($this->tableName);

		foreach ($q->result() as $row)
		{
			$this->db->where("user_id",$row->user_id);
			$this->db->where("year(date)",date("Y"));
			$q2=$this->db->get($this->tableName);

			$eData['orders']=$q2->result();
			$body=$this->load->view("orders/public/_email_year_order_summary",$eData,true);
			$subject='Seva Summary for '.date("Y").' - '.htmlentities($row->firstname)." ".htmlentities($row->lastname);
			$this->email_extension->sendMailGuest(
													'payments',
													htmlentities($row->firstname)." ".htmlentities($row->lastname),
													$row->email,
													$subject,
													$body,
													'',
													1);
		}


		$this->db->select("user_id,email,firstname,lastname");
		$this->db->where("user_id",0);
		$this->db->where("year(date)",date("Y"));
		$this->db->group_by("email");
		$q=$this->db->get($this->tableName);

		foreach ($q->result() as $row)
		{
			$this->db->where("email",$row->email);
			$this->db->where("year(date)",date("Y"));
			$q2=$this->db->get($this->tableName);

			$eData['orders']=$q2->result();
			$body=$this->load->view("orders/public/_email_year_order_summary",$eData,true);
			$subject='Seva Summary for '.date("Y").' - '.htmlentities($row->firstname)." ".htmlentities($row->lastname);
			$this->email_extension->sendMailGuest(
													'payments',
													htmlentities($row->firstname)." ".htmlentities($row->lastname),
													$row->email,
													$subject,
													$body,
													'',
													1);
		}
	}

	public function sendPoojaReminder($category)
	{
		$this->db->select("user_id,email,firstname,lastname");
		$this->db->where("user_id !=",0);
		$this->db->where("year(date)",(date("Y")-1));
		$this->db->group_by("user_id");
		$q=$this->db->get($this->tableName);

		foreach ($q->result() as $row)
		{
			$this->db->select("item_name,item_id,image");
			$this->db->from($this->tableName." as o");
			$this->db->join("order_items as oi","o.id=oi.order_id");
			$this->db->join("poojas as p","oi.item_id=p.id");
			$this->db->where("user_id",$row->user_id);
			$this->db->where("oi.category",$category);
			$this->db->where("o.order_type",1);
			$this->db->group_by("item_id");
			$this->db->where("year(date)",(date("Y")-1));
			$q2=$this->db->get();

			if($q2->num_rows())
			{
				$eData['poojas']=$q2->result();
				$body=$this->load->view("orders/public/_email_poojas_reminder",$eData,true);
				$subject='Seva Summary for '.date("Y").' - '.htmlentities($row->firstname)." ".htmlentities($row->lastname);
				$this->email_extension->sendMailGuest(
														'payments',
														htmlentities($row->firstname)." ".htmlentities($row->lastname),
														$row->email,
														$subject,
														$body,
														'',
														1);
			}
		}

		$this->db->select("user_id,email,firstname,lastname");
		$this->db->where("user_id",0);
		$this->db->where("year(date)",(date("Y")-1));
		$this->db->group_by("email");
		$q=$this->db->get($this->tableName);

		foreach ($q->result() as $row)
		{
			$this->db->select("item_name,item_id,image");
			$this->db->from($this->tableName." as o");
			$this->db->join("order_items as oi","o.id=oi.order_id");
			$this->db->join("poojas as p","oi.item_id=p.id");
			$this->db->where("email",$row->email);
			$this->db->where("oi.category",$category);
			$this->db->where("o.order_type",1);
			$this->db->group_by("item_id");
			$this->db->where("year(date)",(date("Y")-1));
			$q2=$this->db->get();

			if($q2->num_rows())
			{
				$eData['poojas']=$q2->result();
				$body=$this->load->view("orders/public/_email_poojas_reminder",$eData,true);
				$subject='Seva Summary for '.date("Y").' - '.htmlentities($row->firstname)." ".htmlentities($row->lastname);
				$this->email_extension->sendMailGuest(
														'payments',
														htmlentities($row->firstname)." ".htmlentities($row->lastname),
														$row->email,
														$subject,
														$body,
														'',
														1);
			}
		}
	}

	public function sendDonationReminder()
	{
		$this->db->select("user_id,email,firstname,lastname");
		$this->db->where("user_id !=",0);
		$query1->group_start();
			$query1->where("order_type",2);
			$query1->or_where("order_type",4);
  		$query1->group_end();
		$this->db->where("year(date)",date("Y"));
		$this->db->group_by("user_id");
		$q=$this->db->get($this->tableName);

		foreach ($q->result() as $row)
		{
			$this->db->select("item_name,item_id,image");
			$this->db->from($this->tableName." as o");
			$this->db->join("order_items as oi","o.id=oi.order_id");
			$this->db->join("donations as d","oi.item_id=d.id");
			$this->db->where("user_id",$row->user_id);
			$query1->group_start();
				$query1->where("o.order_type",2);
				$query1->or_where("o.order_type",4);
	  		$query1->group_end();
			$this->db->group_by("item_id");
			$this->db->where("year(date)",date("Y"));
			$q2=$this->db->get();

			if($q2->num_rows())
			{
				$eData['donations']=$q2->result();
				$body=$this->load->view("orders/public/_email_donations_reminder",$eData,true);

				$subject='Seva Summary for '.date("Y").' - '.htmlentities($row->firstname)." ".htmlentities($row->lastname);
				$this->email_extension->sendMailGuest(
														'payments',
														htmlentities($row->firstname)." ".htmlentities($row->lastname),
														$row->email,
														$subject,
														$body,
														'',
														1);
			}
		}

		$this->db->select("user_id,email,firstname,lastname");
		$this->db->where("user_id",0);
		$query1->group_start();
			$query1->where("order_type",2);
			$query1->or_where("order_type",4);
  		$query1->group_end();
		$this->db->where("year(date)",date("Y"));
		$this->db->group_by("email");
		$q=$this->db->get($this->tableName);

		foreach ($q->result() as $row)
		{
			$this->db->select("item_name,item_id,image");
			$this->db->from($this->tableName." as o");
			$this->db->join("order_items as oi","o.id=oi.order_id");
			$this->db->join("donations as d","oi.item_id=d.id");
			$this->db->where("email",$row->email);
			$query1->group_start();
				$query1->where("o.order_type",2);
				$query1->or_where("o.order_type",4);
	  		$query1->group_end();
			$this->db->group_by("item_id");
			$this->db->where("year(date)",date("Y"));
			$q2=$this->db->get();

			if($q2->num_rows())
			{
				$eData['donations']=$q2->result();
				$body=$this->load->view("orders/public/_email_donations_reminder",$eData,true);
				$subject='Seva Summary for '.date("Y").' - '.htmlentities($row->firstname)." ".htmlentities($row->lastname);
				$this->email_extension->sendMailGuest(
														'payments',
														htmlentities($row->firstname)." ".htmlentities($row->lastname),
														$row->email,
														$subject,
														$body,
														'',
														1);
			}
		}
	}

	public function updateNote($orderData,$orderItem,$family_member_details)
	{
		$opts=unserialize($orderItem->options);
		$opts['family_member_details']=$family_member_details;
		$updateData = array("family_member_details"=>$family_member_details, "options"=>serialize($opts));
		if(isset($_POST['family_donor_type']) && $_POST['family_donor_type'] == '8')
		{
			$updateData['name_of_family_type']=8;
		}
		if(isset($_POST['family_donor_type']) && $_POST['family_donor_type'] == '9')
		{
			$updateData['name_of_family_type']=9;
		}

		$this->db->where("id",$orderItem->order_item_id);
		$this->db->update("order_items",$updateData);
		$this->logaction->log($this->service,"Changed family details for Seva item:".$orderItem->order_item_id." - Seva ID:".$orderData['order']->id);
	}

	public function updateFriendOtherFamilyDetails($orderData, $orderItem, $othernamefor, $friend_other_name)
	{
		$opts=unserialize($orderItem->options);
		// echo '<pre>'; print_r($orderItem); die();
		$updateData['friend_or_other_'.$othernamefor] = $friend_other_name;
		$opts['family_member_details'] = '';
		$updateData['family_member_details'] = '';
		if($othernamefor == 1)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_1 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_1."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_1."\r\n";
		}
		if($othernamefor == 2)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_2 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_2."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_2."\r\n";
		}
		if($othernamefor == 3)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_3 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_3."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_3."\r\n";
		}
		if($othernamefor == 4)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_4 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_4."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_4."\r\n";
		}
		if($othernamefor == 5)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_5 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_5."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_5."\r\n";
		}
		if($othernamefor == 6)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_6 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_6."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_6."\r\n";
		}
		if($othernamefor == 7)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_7 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_7."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_7."\r\n";
		}
		if($othernamefor == 8)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_8 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_8."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_8."\r\n";
		}
		if($othernamefor == 9)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_9 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_9."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_9."\r\n";
		}
		if($othernamefor == 10)
		{
			$opts['family_member_details'].= $friend_other_name."\r\n";
			$updateData['family_member_details'].= $friend_other_name."\r\n";
		}
		else if($orderItem->friend_or_other_10 !='')
		{
			$opts['family_member_details'].= $orderItem->friend_or_other_10."\r\n";
			$updateData['family_member_details'].= $orderItem->friend_or_other_10."\r\n";
		}

		$updateData['options'] = serialize($opts);
		if(isset($_POST['family_donor_type']) && $_POST['family_donor_type'] == '8')
		{
			$updateData['name_of_family_type']=8;
		}
		if(isset($_POST['family_donor_type']) && $_POST['family_donor_type'] == '9')
		{
			$updateData['name_of_family_type']=9;
		}
		$updateData['family_members'] = '';

		$this->db->where("id",$orderItem->order_item_id);
		$this->db->update("order_items",$updateData);
		$this->logaction->log($this->service,"Changed family details for Seva item:".$orderItem->order_item_id." - Seva ID:".$orderData['order']->id);
	}

	public function removeFriendOtherFamilyDetails($orderData, $orderItem, $otherNameId)
	{
		$opts=unserialize($orderItem->options);
		$orderItem = (array)$orderItem;
		if($otherNameId>0 && $otherNameId<=10)
        {
        	$opts['family_member_details'] = '';
			$updateData['family_member_details'] = '';
        	for($deletingId = 1; $deletingId<=10; $deletingId++)
            {
            	if($deletingId == 10)
            	{
            		$updateData['friend_or_other_'.$deletingId] = '';
	                $opts['other_name'.$deletingId] = '';
	                $opts['family_member_details'].= '';
					$updateData['family_member_details'].= '';
            	}
            	else if($deletingId >= $otherNameId)
            	{
	            	$updateData['friend_or_other_'.$deletingId] = $orderItem['friend_or_other_'.($deletingId+1)];
	                $opts['other_name'.$deletingId] = $orderItem['friend_or_other_'.($deletingId+1)];
	                $opts['family_member_details'].= $orderItem['friend_or_other_'.($deletingId+1)]."\r\n";
					$updateData['family_member_details'].= $orderItem['friend_or_other_'.($deletingId+1)]."\r\n";
				}
				else
				{
					$updateData['friend_or_other_'.$deletingId] = $orderItem['friend_or_other_'.$deletingId];
	                $opts['other_name'.$deletingId] = $orderItem['friend_or_other_'.$deletingId];
	                $opts['family_member_details'].= $orderItem['friend_or_other_'.$deletingId]."\r\n";
					$updateData['family_member_details'].= $orderItem['friend_or_other_'.$deletingId]."\r\n";
				}
            }
            $updateData['options'] = serialize($opts);

            $this->db->where("id",$orderItem['order_item_id']);
			$this->db->update("order_items",$updateData);
			$this->logaction->log($this->service,"Changed family details for Seva item:".$orderItem['order_item_id']." - Seva ID:".$orderData['order']->id);
        }
	}

	public function PitruPakshaDeceasedPersonName($orderData,$orderItem,$family_member_details)
	{
		$opts=unserialize($orderItem->options);
		$opts['family_member_details']=$family_member_details;
		$opts['pitru_paksha_deceased_person_name']=$family_member_details;

		$this->db->where("id",$orderItem->order_item_id);
		$this->db->update("order_items",
								array(
										"family_member_details"=>$family_member_details,
										"pitru_paksha_deceased_person_name"=>$family_member_details,
										"options"=>serialize($opts)
								)
						);
		$this->logaction->log($this->service,"Changed name of deceased person for Seva item:".$orderItem->order_item_id." - Seva ID:".$orderData['order']->id);
	}

	public function updatePrasadamStatus($orderId,$flag=0)
	{
		$this->db->where("order_id",$orderId);
		$this->db->update("order_items", array( "prasadam_not_required"=>$flag ) );
	}
	public function updatePersonalNote($orderData,$orderItem,$note)
	{
		$opts=unserialize($orderItem->options);
		$opts['note']=$note;

		$this->db->where("id",$orderItem->order_item_id);
		$this->db->update("order_items",
								array(
										"personal_note"=>$note,
										"options"=>serialize($opts)
								)
						);
		$this->logaction->log($this->service,"Changed Personal Note for Seva item:".$orderItem->order_item_id." - Seva ID:".$orderData['order']->id);
	}
	public function updateGiftEmail($orderData,$orderItem,$email)
	{
		$opts=unserialize($orderItem->options);
		$opts['gift_friend_email']=$email;

		$this->db->where("id",$orderItem->order_item_id);
		$this->db->update("order_items",
								array(
										"gift_friend_email"=>$email,
										"options"=>serialize($opts)
								)
						);
		$this->logaction->log($this->service,"Changed gift email for Seva item:".$orderItem->order_item_id." - Seva ID:".$orderData['order']->id);
	}
	public function updateGiftName($orderData,$orderItem,$name)
	{
		$opts=unserialize($orderItem->options);
		$opts['gift_name_email']=$name;

		$this->db->where("id",$orderItem->order_item_id);
		$this->db->update("order_items",
								array(
										"gift_friend_name"=>$name,
										"options"=>serialize($opts)
								)
						);
		$this->logaction->log($this->service,"Changed gift name for Seva item:".$orderItem->order_item_id." - Seva ID:".$orderData['order']->id);
	}
	public function updateShippingAddress($orderData,$orderItem,$address)
	{
		$opts=unserialize($orderItem->options);
		
		$opts['shipping_address']['address1']=$address['address1'];
		$opts['shipping_address']['address2']=$address['address2'];
		$opts['shipping_address']['address3']=$address['address3'];
		$opts['shipping_address']['city']=$address['city'];
		$opts['shipping_address']['state']=$address['state'];
		$opts['shipping_address']['country']=$address['country'];
		$countryData=$this->locations_model->getCountryByCode($address['country']);
		$opts['shipping_address']['country_name']=$countryData->country_name;

		$this->db->where("id",$orderItem->order_item_id);
		$this->db->update("order_items",
								array(
										"shipping_address1"=>$address['address1'],
										"shipping_address2"=>$address['address2'],
										"shipping_address3"=>$address['address3'],
										"shipping_city"=>$address['city'],
										"shipping_state"=>$address['state'],
										"shipping_country"=>$address['country'],
										"shipping_country_name"=>$countryData->country_name,
										"options"=>serialize($opts)
								)
						);
		$this->logaction->log($this->service,"Changed shipping address for Seva item:".$orderItem->order_item_id." - Seva ID:".$orderData['order']->id);
	}

	public function update_dispatch($orderData,$status,$dispatch_note)
	{
		$dis_note="<span style='color:red;'>".date("d M Y h:i A")."</span>\n";
		if($status==0)
		{
			$dis_note.='<span class="label" style="background-color:#000;">N/A</span> ';
		}
		if($status==1)
		{
			$dis_note.='<span class="label label-dark-purple" style="background-color:#8E44AD;">Pending</span> ';
		}
		if($status==2)
		{
			$dis_note.='<span class="label label-dark-green">Completed</span> ';
		}
		if($status==3)
		{
			$dis_note.='<span class="label label-dark-red">Returned</span> ';
		}
		if($orderData['order']->dispatch_note!='')
			$dispatch_note=$orderData['order']->dispatch_note."\n\n".$dis_note.$dispatch_note;
		else
			$dispatch_note=$dis_note.$dispatch_note;

		$this->db->where("id",$orderData['order']->id);
		$this->db->update($this->tableName,
								array(
										"dispatch_status"=>$status,
										"dispatch_note"=>$dispatch_note
								)
						);

		/*$body=$this->load->view("orders/public/_email_dispatch_note",array("orderData"=>$orderData,"dispatch_note"=>$dispatch_note),true);
		$subject=$orderData['order']->ashram_name.' - Your order #'.$orderData['order']->order_number." dispatched";
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1);*/
	}

	public function update_payment_status($orderData,$payment_status,$payment_mode,$payment_note)
	{
		$updateData['payment_status']=$payment_status;
		if($payment_status==1)
		{
			$tx=$this->payment_model->createCashTransaction($orderData);
			$updateData['transaction_id']=$tx;
			if($payment_mode!='cash')
			$updateData['payment_mode']="Cash (".ucwords($payment_mode).")";
		}
		if($payment_status==0)
		{
			$this->payment_model->deleteCashTransaction($orderData['order']->id);
			$updateData['payment_mode']="Cash";
			$updateData['transaction_id']='';
		}


		$this->db->where("id",$orderData['order']->id);
		$this->db->update($this->tableName,$updateData);

		if($payment_status==1)
		{
			$this->order_log_model->log($orderData['order']->id,"Pending -> Paid\n ".$payment_note);
		}
		if($payment_status==0)
		{
			$this->order_log_model->log($orderData['order']->id,"Paid -> Pending\n ".$payment_note);
		}
		//$this->order_log_model->log($orderData['order']->id,"Payment note: ".$payment_note);
	}

	public function charge_amount($orderData,$amount,$payment_mode,$payment_note)
	{
		// if($payment_mode=='cheque')
		// 	$note="<b>".date("d M Y h:i A")."</b> (inprocess)\n".$payment_note;
		// else
		// 	$note="<b>".date("d M Y h:i A")."</b> (paid)\n".$payment_note;
		$note = $payment_note;
		$tx=$this->transaction_model->createCashTransaction($orderData,$amount,$payment_mode,$note);
		if($payment_mode=='cheque')
			$status="inprocess";
		else
			$status="paid";

		$is_manual_payment=0;
		if(!empty($this->input->post("is_manual_payment")))
			$is_manual_payment=1;

		//$this->transaction_model->updateDetails($tx,array("status"=>$status));
		$this->transaction_model->updateDetails($tx,
								array(
										'status'=>$status,
										"is_manual_payment"=>empty($this->input->post("is_manual_payment"))?0:$this->input->post("is_manual_payment"),
										"is_foreign_payment"=>empty($this->input->post("is_foreign_payment"))?0:$this->input->post("is_foreign_payment"),
										"manual_receipt_number"=>empty($this->input->post("manual_receipt_number"))?0:$this->input->post("manual_receipt_number"),
										"manual_receipt_date"=>empty($this->input->post("manual_receipt_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("manual_receipt_date"))),
										"offline_number"=>empty($this->input->post("offline_number"))?null:$this->input->post("offline_number"),
										"offline_bank"=>empty($this->input->post("offline_bank"))?null:$this->input->post("offline_bank"),
										"offline_date"=>empty($this->input->post("offline_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("offline_date"))),
										"foreign_currency"=>empty($this->input->post("foreign_currency"))?0:$this->input->post("foreign_currency"),
										"foreign_amount"=>empty($this->input->post("foreign_amount"))?0:$this->input->post("foreign_amount"),
										"realized_amount"=>empty($this->input->post("realized_amount"))?0:$this->input->post("realized_amount")
									));
		/*$transactions=$this->transaction_model->getTransactionsByOrder($orderData['order']->id);
		$paidAmount=0;
		foreach ($transactions as $transaction)
		{
			if(in_array(strtolower($transaction->status),array("completed",'success','release payment','approved','captured','paid')))
			{
				$paidAmount+=$transaction->amount;
			}
		}
		if($paidAmount==0)
			$updateData['payment_status']=0;
		if($paidAmount<$orderData['order']->total_price)
			$updateData['payment_status']=2;
		if($paidAmount==$orderData['order']->total_price)
			$updateData['payment_status']=1;

		$updateData['paid']=$paidAmount;

		$this->db->where("id",$orderData['order']->id);
		$this->db->update($this->tableName,$updateData);*/
		$this->calculateDue($orderData['order']->id);

		$this->order_log_model->log($orderData['order']->id,"Charged amount: ".strtoupper($orderData['order']->currency)." ".$amount."\n".
			$payment_mode."\nTx ID:".$tx."\nNote: ".$payment_note);


		if($orderData['order']->is_manual_payment==0 && $is_manual_payment==0)
		{
			if(in_array(strtolower($status),array("completed",'success','release payment','Release Payment','approved','captured','paid')))
			{
				$this->orders_model->sendTransactionReceiptEmail($orderData['order']->id,$tx);
				$this->payment_model->populateTransactionReport($tx);
				$this->payment_model->updateOrderTotalPaid($orderData['order']->id,$amount,$tx);
				//$this->orders_model->sendTransactionReceiptEmailBcc($orderData['order']->id,$tx);
			}
			else
			{
				$this->orders_model->sendTransactionStatusEmailOffline($orderData['order']->id,$tx);
				$this->orders_model->sendTransactionStatusEmailOfflineBCC($orderData['order']->id,$tx);
			}
		}

		/*$this->load->library("sms");
		$message=
				display_site_name."\n".
				"Payment update:\n".
				"Seva ID: ".$orderData['order']->order_number."\n".
				"Date: ".date("d M Y")."\n".
				"Amount: ".strtoupper($orderData['order']->currency)." ".$amount."\n".
				"Tx ID: ".$tx."\n".
				"Status: ".$status.
				"";
		$countryData=$this->locations_model->getCountryByCode($orderData['order']->country);
		$this->sms->sendSMS(
								'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
								$countryData->isd_code.$orderData['order']->phone,
								$message,
								$countryData->isd_code
							);*/

	}

	public function calculateDue($orderId)
	{
		$orderData=$this->orderData($orderId);

		$transactions=$this->transaction_model->getTransactionsByOrder($orderId,1);
		$paidAmount=0;
		$subscriptions=0;
		$pendingNum=0;
		foreach ($transactions as $transaction)
		{
			if(in_array(strtolower($transaction->status),$this->payment_success_statuses))
			{
				if($transaction->subscription==1 && $transaction->flag==0)
				{
					if($subscriptions==0)
					{
						$paidAmount+=$transaction->amount;
						$subscriptions++;		
					}
				}
				else
					$paidAmount+=$transaction->amount;
			}
			else
			{
				if($transaction->payment_mode=='cheque' && $transaction->status!='bounced')
				{
					$paidAmount+=$transaction->amount;
					$pendingNum++;
				}
			}
		}
		if($paidAmount==0)
			$updateData['payment_status']=0;
		else
		{
			if($paidAmount<$orderData['order']->total_price)
				$updateData['payment_status']=2;
			if($paidAmount==$orderData['order']->total_price)
			{
				if($pendingNum)
					$updateData['payment_status']=2;
				else
					$updateData['payment_status']=1;
			}
		}

		$updateData['paid']=$paidAmount;
		if(isset($updateData['payment_status']))
		if($updateData['paid']!=$orderData['order']->paid || $updateData['payment_status']!=$orderData['order']->payment_status)
		{
			$this->db->where("id",$orderId);
			$this->db->update($this->tableName,$updateData);

			if($orderData['order']->payment_mode == 'Offline' && $orderData['order']->is_appji_order == 1  && in_array($updateData['payment_status'], [1,2]))
			{
				// $this->updateAppjiLinkTokens($orderId);
				$this->sendOrderPaymentStatusToAppjiServer($orderId);
			}
		}
	}

	public function calculateOrderItemDue($orderId,$orderItemId)
	{
		$orderData=$this->orderData($orderId);
		$currentItem=array();
		foreach ($orderData['order_items'] as $orderItem)
		{
			if($orderItem->id==$orderItemId)
				$currentItem=$orderItem;
		}
		$transactions=$this->transaction_model->getTransactionsByOrderAlt($orderId,1);
		if(!empty($currentItem) && $currentItem->subscription==1)
			$subscription_payments=$this->subscription_payments_model->getByOrderItem($orderItemId);
		else
			return 0;

		$totalPayment=0;
		$totalNumber=0;
		$subscriptionsPaid=0;
		foreach ($subscription_payments as $subscription_payment)
		{
			$totalPayment+=$subscription_payment->amount;
			$totalNumber++;
			if($subscription_payment->status==8)
				$subscriptionsPaid++;
		}

		$paidAmount=0;
		$subscriptions=0;
		
		foreach ($transactions as $transaction)
		{
			if(in_array(strtolower($transaction->status),array("completed",'success','release payment','Release Payment','approved','captured','paid')))
			{
				/*if($transaction->subscription==1 && $transaction->flag==0)
				{
					$paidAmount+=$transaction->amount;
				}*/
				if($transaction->order_item_id==$orderItemId && $transaction->flag==0)
				{
					$amt = intval($transaction->amount);
					$paidAmount+=$amt;
				}
			}
		}

		if($paidAmount==0 && $subscriptionsPaid==0)
			$updateData['status']=0;
		else
		{
			if(($paidAmount==$totalPayment) || ($paidAmount > $totalPayment))
			{
				$updateData['status']=3; //Completed
			}
			else
			{
				$updateData['status']=1;
			}
		}
		if($currentItem->status!=$updateData['status'])
		{
			$this->db->where("order_id",$orderId);
			$this->db->where("id",$orderItemId);
			$this->db->update("order_items",$updateData);
		}
	}

	public function changeCard($id)
	{
		$orderData=$this->orders_model->orderData($id);

		//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($orderData['order']->ashram_id,$orderData['order']->order_type);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[strtolower($orderData['order']->currency)];
		//Get trust data

    	$formData['firstname']=$orderData['order']->firstname;
        $formData['lastname']=$orderData['order']->lastname;
        $formData['email']=$orderData['order']->email;
        $formData['phone']=$orderData['order']->phone;
        $formData['address1']=$orderData['order']->address1;
        $formData['address2']=$orderData['order']->address2;
        $formData['zipcode']=$orderData['order']->zipcode;
        $formData['city']=$orderData['order']->city;
        $formData['state']=$orderData['order']->state;
        $formData['country']=$orderData['order']->country;
        $formData['ashram_id']=$orderData['order']->ashram_id;

		$authorize_result=$this->paypal_model->authorizeCard(
											$trustData,
											$this->input->post("card_number"),
											str_replace("/","",$this->input->post("card_expiry")),
											$this->input->post("card_cvv"),
											$formData
										);
		if($authorize_result['RESULT']!=0)
		{
			return 0;
		}

		$has_subscription=0;
		foreach ($orderData['order_items'] as $itemData)
		{
			if(($orderData['order']->order_type==2 || $orderData['order']->order_type==4) && $itemData->subscription==1 && $itemData->status==1)
			{
				$paypal_result=$this->paypal_model->changeCard(
												$trustData,
												$authorize_result,
												$itemData->subscription_id
											);
				$has_subscription=1;
			}
		}

		if($has_subscription)
		{
			//==========Load encryption library=============//

	    	$this->load->library('encryption');

			$this->encryption->initialize(
			        array(
			                'cipher' => 'aes-256',
			                'mode' => 'cbc',
			                'key' => file_get_contents("../app_configs/aes_key")
			        )
			);

	    	//==========Load encryption library=============//
	    	$payment_string=$authorize_result['ACCT']."\n".
						$authorize_result['EXPDATE']."\n".
						$authorize_result['CARDTYPE']."\n".
						$this->input->post("card_name")."\n".
						$authorize_result['PNREF']."\n".
						$authorize_result['TRANSTIME'];
			$encrypted_payment_string=$this->encryption->encrypt($payment_string);

			//================Store card & Payment references=============//
			$this->db->where("order_id",$id);
			$this->db->delete("subscription_profiles_payflow");
			$expiry_dates = explode("/", $this->input->post("card_expiry"));
			$card_expiry_month = "";
			$card_expiry_year = "";

			if(!empty($expiry_dates[0]))
				$card_expiry_month = $expiry_dates[0];

			if(!empty($expiry_dates[1]))
			{
				if($expiry_dates[1] == "00")
					$card_expiry_year = "30".$expiry_dates[1];
				else
					$card_expiry_year = "20".$expiry_dates[1];
			}
			
			$profileData=array(
								"payment_info"=>$encrypted_payment_string,
								"created_on"=>date("Y:m:d H:i:s"),
								"updated_on"=>date("Y:m:d H:i:s"),
								"order_id"=>$id,
								"card_expiry_month"=>$card_expiry_month,
								"card_expiry_year"=>$card_expiry_year,
								"user_id"=>$orderData['order']->user_id
							);
			$this->db->insert("subscription_profiles_payflow",$profileData);

			//================Store card & Payment references=============//

			$this->order_log_model->log($id,"Credit card updated");

			if($orderData['order']->is_manual_payment==0)
			{
				$data['orderData']=$orderData;
				$data['card_number']=$authorize_result['ACCT'];
				$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
				$body=$this->load->view("orders/public/_email_subscription_card_changed",$data,true);
				$subject='Credit Card updated for '.$orderData['order']->order_number;
				$this->email_extension->sendMailGuest(
														'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
														$orderData['order']->firstname." ".$orderData['order']->lastname,
														$orderData['order']->email,
														$subject,
														$body,
														'',
														1);

				$this->load->library("sms");
				$message=
						display_site_name."\n".
						"Card updated successfully for Seva ID:".$orderData['order']->order_number."\n".
						""
						;
				$this->sms->sendSMS(
										'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
										$data['countryData']->isd_code.$orderData['order']->phone,
										$message,
										1,
										$orderData['order']->user_id,
										$orderData['order']->username,
										$data['countryData']->isd_code
									);
			}

			return 1;
		}
		return 0;
	}

	public function updateSubscription($id,$txData,$itemData)
	{
		if($itemData->subscription_id=='')
		{
			$updateData['subscription_id']=$txData['PROFILEID'];
			$updateData['status']=1;
			$this->subscription_payments_model->updateProfileId($id,$txData['PROFILEID']);
		}
		$this->db->where("id",$id);
		$this->db->update("order_items",$updateData);
	}

	public function readSubscriptionsPaypalStatus()
	{
		$this->db->select("*,oi.id as id");
		$this->db->from("order_items as oi");
		$this->db->join("orders as o","o.id=oi.order_id");
		$this->db->where("subscription",1);
		$this->db->where("oi.status",1);
		$this->db->where("oi.expiration_method",1);
		$this->db->group_start();
			$this->db->where("last_read <",date("Y:m:d"));
			$this->db->or_where("last_read",null);
		$this->db->group_end();
		$this->db->limit("20");
		$items=$this->db->get()->result();
		foreach ($items as $orderItem)
		{
			//Read info from paypal
			$subscriptionInfo=$this->paypal_model->subscriptionInquiry(
																		$orderItem->subscription_id,
																		$orderItem->ashram_id,
																		$orderItem->order_type,
																		strtolower($orderItem->currency)
																	);

			if(isset($subscriptionInfo['STATUS']) && $subscriptionInfo['STATUS']!='ACTIVE')
			{
				$this->db->where("id",$orderItem->id);
				$this->db->update("order_items",array("status"=>3,"last_read"=>date("Y:m:d")));

				$this->order_log_model->log($orderItem->order_id,"Subscription \"".$orderItem->item_name."\" expired.");
			}
		}
	}

	public function readSubscriptionsPaypal($orderId=0,$itemId=0)
	{
		$this->db->select("*,oi.id as id");
		$this->db->from("order_items as oi");
		$this->db->join("orders as o","o.id=oi.order_id");
		$this->db->where("subscription",1);
		$this->db->where("o.payment_alt_mode","paypal");

		if($orderId)
		{
			$this->db->where("oi.order_id",$orderId);
			if($itemId)
			{
				$this->db->where("oi.id",$itemId);
			}
		}
		else
		{
			$this->db->where("oi.status",1);
			$this->db->group_start();
				$this->db->where("last_read <",date("Y:m:d"));
				$this->db->or_where("last_read",null);
			$this->db->group_end();
		}

		$this->db->limit("30");

		$items=$this->db->get()->result();


		foreach ($items as $orderItem)
		{
			//Read the existing transactions
			$this->db->where("order_item_id",$orderItem->id);
			$existingTransactions=$this->db->get("subscription_payments")->result();

			//Get only the existing Tx IDs
			$txIds=array();
			foreach ($existingTransactions as $existingTransaction)
			{
				if(!in_array($existingTransaction->tx,$txIds))
					$txIds[]=$existingTransaction->tx;
			}

			//Read from paypal
			$subscriptionPayments=$this->paypal_model->subscriptionPayments(
																				$orderItem->subscription_id,
																				$orderItem->ashram_id,
																				$orderItem->order_type,
																				strtolower($orderItem->currency)
																			);
			$payments=array();
			$seq=0;
			$paymentsLoop=$subscriptionPayments;
			unset($paymentsLoop['RESULT']);
			unset($paymentsLoop['RPREF']);
			unset($paymentsLoop['PROFILEID']);
			//Consolidate the transactions from paypal
			foreach ($paymentsLoop as $key => $record)
			{
				if(preg_match("/P_PNREF/i",$key))
				{
					$seq=abs(str_replace("P_PNREF","",$key));
				}
				if(isset($subscriptionPayments["P_PNREF".$seq]))
				{
					$payments[$seq]['tx']=$subscriptionPayments["P_PNREF".$seq];
					$payments[$seq]['date']=$subscriptionPayments["P_TRANSTIME".$seq];
					$payments[$seq]['amount']=$subscriptionPayments["P_AMT".$seq];
					$payments[$seq]['status']=$subscriptionPayments["P_TRANSTATE".$seq];
				}
			}

			$lastpayment=0;

			//Loop through paypal transactions
			foreach ($payments as $seqq => $txr)
			{
				//Check if the transaction already exist in DB
				if(in_array($txr['tx'],$txIds))
				{
					continue;
				}

				if($txr['status']==6)
				{
					$pstatus='spending'; //Settlement pending
				}
				else if($txr['status']==7)
				{
					$pstatus='sprogress'; //Settlement in progress
				}
				else if($txr['status']==8)
				{
					$pstatus='approved'; //Settlement success
				}
				else
				{
					$pstatus='failure';
				}

				/*$retry_status=1;

				if(in_array($txr['status'],array(6,7,8)))
				{
					$retry_status=0;
				}*/
				$retry_status=0;

				if($lastpayment<strtotime($txr['date']))
					$lastpayment=strtotime($txr['date']);


				$this->db->where("tx",$txr['tx']);
				$subscription_payment=$this->db->get("subscription_payments")->row();
				if(empty($subscription_payment)) //By transaction ID
				{
					$this->db->where("payment_number",$seqq);
					$this->db->where("status",0);
					$this->db->where("order_id",$orderItem->order_id);
					$this->db->where("order_item_id",$orderItem->id);
					//$this->db->where("profile_id",$orderItem->subscription_id);
					$existingRecord=$this->db->get("subscription_payments")->row();

					if(empty($existingRecord))
					{
						//Find the transaction with same payment/sequence number to get the original payment date
						$this->db->where("payment_number",$seqq);
						$this->db->where("order_id",$orderItem->order_id);
						$this->db->where("profile_id",$orderItem->subscription_id);
						$this->db->order_by("id","asc");
						$this->db->limit(1);
						$existingRecord=$this->db->get("subscription_payments")->row();

						$db_debug = $this->db->db_debug;
						$this->db->db_debug = false;
						$insertData=array(
									"order_id"=>$orderItem->order_id,
									"order_item_id"=>$orderItem->id,
									"profile_id"=>$orderItem->subscription_id,
									"payment_date"=>$existingRecord->payment_date,
									"date"=>date("Y:m:d H:i:s",strtotime($txr['date'])),
									"tx"=>$txr['tx'],
									"amount"=>abs($txr['amount']),
									"status"=>$txr['status'],
									"payment_number"=>$seqq,
									"retry_status"=>$retry_status,
									"payment_mode"=>"paypal",
									"created_on"=>date("Y:m:d H:i:s")
								);
						$this->db->insert("subscription_payments",$insertData);
						$paymentId=$this->db->insert_id();
						$this->db->db_debug = true;
					}
					else
					{
						$updateData=array(
									//"order_id"=>$orderItem->order_id,
									//"order_item_id"=>$orderItem->id,
									"profile_id"=>$orderItem->subscription_id,
									"date"=>date("Y:m:d H:i:s",strtotime($txr['date'])),
									"tx"=>$txr['tx'],
									"amount"=>abs($txr['amount']),
									"status"=>$txr['status'],
									"payment_mode"=>"paypal",
									"retry_status"=>$retry_status
								);
						$this->db->where("payment_number",$seqq);
						$this->db->where("status",0);
						$this->db->where("order_id",$orderItem->order_id);
						$this->db->where("order_item_id",$orderItem->id);
						//$this->db->where("profile_id",$orderItem->subscription_id);
						$this->db->update("subscription_payments",$updateData);

						$paymentId=$existingRecord->id;
					}

					$this->payment_model->createTransaction($txr['tx'],$orderItem->user_id,'',$pstatus,null,$orderItem->order_id);
					$updateTxArray=
							array(
								"t_status"=>1,
								'data'=>serialize($txr),
								"order_item_id"=>$orderItem->id,
								'modified_on'=>date("Y:m:d H:i:s"),
								'amount'=>abs($txr['amount']),
								'currency'=>$orderItem->currency,
								'payment_mode'=>'paypal',
								'created_on'=>date("Y:m:d H:i:s",strtotime($txr['date'])),
								'note'=>"Payment for ".$orderItem->item_name,
								'ashram_id'=>$orderItem->ashram_id,
								"payment_number"=>$seqq,
								'subscription'=>1,
								"firstname"=>$orderItem->firstname,
                                "lastname"=>$orderItem->lastname,
                                "city"=>$orderItem->city,
                                "state"=>$orderItem->state,
                                "country"=>$orderItem->country,
                                "zipcode"=>$orderItem->zipcode,
                                "email"=>$orderItem->email,
                                "phone"=>$orderItem->phone,
                                "ip_address"=>$orderItem->ip_address
							);
		    		$this->payment_model->updateTx($txr['tx'],$updateTxArray);

		    		$this->db->insert("subscription_payments_transaction_map",
							array(
									"tx"=>$txr['tx'],
									"subscription_payment_id"=>$paymentId
							));

		    		if(in_array(strtolower($pstatus),$this->payment_success_statuses))
		    		{
		    			$this->sendTransactionReceiptEmail($orderItem->order_id,$txr['tx']);
		    			$this->sendSubscriptionPaymentEmail($orderItem->order_id,$orderItem->id,$paymentId,0);
		    			$this->sendSubscriptionPaymentEmailBCC($orderItem->order_id,$orderItem->id,$paymentId);
		    			$this->payment_model->updateOrderTotalPaid($orderItem->order_id,$txr['amount'],$txr['tx']);
		    			$this->payment_model->populateTransactionReport($txr['tx']);
		    		}
		    		else
		    		{
		    			$this->sendSubscriptionPaymentEmail($orderItem->order_id,$orderItem->id,$paymentId);
		    			$this->sendSubscriptionPaymentEmailBCC($orderItem->order_id,$orderItem->id,$paymentId);
		    		}
				}
				else
				{
					$updateData=array(
								//"order_id"=>$orderItem->order_id,
								//"order_item_id"=>$orderItem->id,
								"profile_id"=>$orderItem->subscription_id,
								"date"=>date("Y:m:d H:i:s",strtotime($txr['date'])),
								"amount"=>abs($txr['amount']),
								"status"=>$txr['status'],
								"payment_number"=>$seqq,
								"payment_mode"=>"paypal",
								//"retry_status"=>$retry_status
							);

					$this->db->where("tx",$txr['tx']);
					$this->db->update("subscription_payments",$updateData);

					$updateTxArray=
							array(
								'data'=>serialize($txr),
								'modified_on'=>date("Y:m:d H:i:s"),
								"order_item_id"=>$orderItem->id,
								'amount'=>abs($txr['amount']),
								'currency'=>$orderItem->currency,
								'payment_mode'=>'paypal',
								'note'=>"Payment for ".$orderItem->item_name,
								'status'=>$pstatus,
								"payment_number"=>$seqq,
								'subscription'=>1
							);
		    		$this->payment_model->updateTx($txr['tx'],$updateTxArray);
				}
			}

			//Update last payment Date
			$this->db->where("id",$orderItem->id);
			$this->db->update("order_items",array("last_payment_date"=>date("Y:m:d",$lastpayment), "last_read"=>date("Y:m:d")));
		}
	}

	public function subscriptionCancel($orderData,$itemData)
	{
		$cancelled=0;
		if($orderData['order']->payment_alt_mode=="paypal")
		{
			$response=$this->paypal_model->cancelSubscription(
																$itemData->subscription_id,
																$orderData['order']->ashram_id,
																$orderData['order']->order_type,
																strtolower($orderData['order']->currency)
															);
			if(isset($response['RESULT']) && $response['RESULT']==0)
			{
				$this->db->where("id",$itemData->id);
				$this->db->update("order_items",array("status"=>2));
				$cancelled=1;
			}
		}
		else if($orderData['order']->payment_alt_mode=="cash")
		{
			$this->db->where("id",$itemData->id);
			$this->db->update("order_items",array("status"=>2));
			$cancelled=1;
		}

		else if($orderData['order']->payment_alt_mode=="razorpay")
		{
			
			$this->load->model('razorpay_subscriptions_model','razorpaysubscriptions');
			$response=$this->razorpaysubscriptions->subscription_cancel( $orderData['order']->id, $itemData->subscription_id, $orderData['order']->ashram_id, $orderData['order']->order_type, strtolower($orderData['order']->currency),$itemData->id );

			if($response == 0)
			{
				$this->db->where("id",$itemData->id);
				$this->db->update("order_items",array("status"=>2));
				$cancelled=1;
			}
		}

		else if($orderData['order']->payment_alt_mode=="stripe")
		{
			$this->load->model('stripe_subscriptions_model','stripesubscriptions');
			$response=$this->stripesubscriptions->stripesubscriptionCancel( $orderData, $itemData);
			if($response)
			{
				$cancelled=1;
			}
		}

		if($cancelled==1)
		{
			if($orderData['order']->is_manual_payment==0)
			{
				$this->sendSubscriptionCancelEmail($orderData['order']->id,$itemData->id);
				$this->sendSubscriptionCancelEmailBCC($orderData['order']->id,$itemData->id);
			}
			$this->order_log_model->log($orderData['order']->id,"Subscription \"".$itemData->item_name."\" cancelled.");
			if(isset($orderData['order']->is_appji_order) && $orderData['order']->is_appji_order==1)
			{
				$this->db->where("order_item_id",$itemData->id);
				$this->db->update("appji_subscriptions_links",array("paymentStatus"=>'Cancelled', "cancelledOn"=> date("Y-m-d H:i:s")));
				$this->sendSubscriptionCancelToAppjiServerByItemId($itemData->id);
			}
		}

		return $cancelled;

	}

	public function retrySubscriptionPayment($orderId,$orderItemId,$paymentId)
	{
		$orderData=$this->orderData($orderId);
		$itemData=$this->itemData($orderItemId,$orderId);

		$paymentData=$this->subscription_payments_model->getById($paymentId);
		if($paymentData->status==1 && $paymentData->retry_status==0)
		{

		}
		else
		{
			return 0;
		}

		$success=0;
		if($orderData['order']->payment_alt_mode=="paypal")
		{
			$response=$this->paypal_model->retrySubscriptionPayment(
																$itemData->subscription_id,
																$orderData['order']->ashram_id,
																$orderData['order']->order_type,
																strtolower($orderData['order']->currency),
																$paymentData->payment_number
															);
			$success=1;
			if($response['RESULT']==0)
			{
				$this->db->where("id",$paymentId);
				$this->db->update("subscription_payments",array("retry_status"=>1));
			}
		}
		/*else if($orderData['order']->payment_alt_mode=="cash")
		{
			$this->db->where("id",$itemData->id);
			$this->db->update("order_items",array("status"=>2));
			$cancelled=1;
		}*/

		if($success==1)
		{
			//$this->sendSubscriptionCancelEmail($orderData['order']->id,$itemData->id);
			//$this->order_log_model->log($orderData['order']->id,"Subscription \"".$itemData->item_name."\" cancelled.");
		}

		return $success;

	}


	/*public function subscriptionActivate($orderData,$itemData)
	{
		$current_day=date("Y:m:d",strtotime("+1 day"));

		$this->db->where("payment_date >=",$current_day);
		$this->db->where("order_id",$itemData->order_id);
		$this->db->where("profile_id",$itemData->subscription_id);
		$this->db->order_by("payment_date","asc");
		$this->db->limit(1);
		$existingRecord=$this->db->get("subscription_payments")->row();

		$response=$this->paypal_model->activateSubscription(
																$itemData->subscription_id,
																$orderData['order']->ashram_id,
																$orderData['order']->order_type,
																strtolower($orderData['order']->currency),
																$existingRecord->payment_date
														);

		if($response['RESULT']==0)
		{
			$this->db->where("id",$itemData->id);
			$this->db->update("order_items",array("status"=>1));

			$this->order_log_model->log($orderData['order']->id,"Subscription \"".$itemData->item_name."\" activated.");
			return 1;
		}
		return 0;

	}*/

	public function expireSubscriptionsPaypal()
	{
		$this->db->select("*,oi.id as id");
		$this->db->from("order_items as oi");
		$this->db->join("orders as o","o.id=oi.order_id");
		$this->db->where("subscription",1);
		$this->db->where("expiration_method",2);
		$this->db->where("expiry_date",date("Y:m:d"));
		$this->db->where("oi.status !=",3);
		//$this->db->limit("20");
		$items=$this->db->get()->result();
		foreach ($items as $orderItem)
		{
			//Expire/cancel subscription
			$expired=$this->paypal_model->cancelSubscription(
																$orderItem->subscription_id,
																$orderItem->ashram_id,
																$orderItem->order_type,
																strtolower($orderItem->currency)
															);
			if($expired['RESULT']==0)
			{
				$this->db->where("id",$itemData->id);
				$this->db->update("order_items",array("status"=>3));

				$this->order_log_model->log($orderItem->order_id,"Subscription \"".$orderItem->item_name."\" expired.");
				$this->sendSubscriptionCompletedMail($orderItem->order_id,$orderItem->id);
				return 1;
			}
		}
	}

	public function orderItemsCountByDonorId($donorId)
	{
		$this->db->select("count(id) as c");
		$wq = "1=1 AND ( donor_id=".$donorId." OR FIND_IN_SET('$donorId', family_members) != 0)";
	   	$this->db->where($wq);
		$q=$this->db->get("order_items")->row();
		return $q->c;
	}

	public function orderItemsCountByPetId($petId)
	{
		$this->db->select("count(id) as c");
		$this->db->where("pet_id",$petId);
		$q=$this->db->get("order_items")->row();
		return $q->c;
	}

	public function assignPet($orderItemId,$petId,$orderData,$itemData)
	{
		$this->db->where("id",$orderItemId);
		$this->db->update("order_items",array("pet_id"=>$petId));

		$petData=$this->pets_model->petData($petId);
		$data['petData']=$petData;
		$data['orderData']=$orderData;
		$body=$this->load->view("orders/public/_email_pet_assigned",$data,true);
		$subject=$orderData['order']->ashram_name.' - Pet assigned - '.$itemData->item_name;
		$this->email_extension->sendMailGuest(
												'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1);
	}

	public function sendSubscriptionPaymentFailEmail($orderId,$order_item_id,$payment_id,$tx)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$transaction=$this->transaction_model->getTransactionByTx($tx);
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$paymentData=$this->subscription_payments_model->getById($payment_id);
		if(empty($paymentData) || $paymentData->order_id!=$orderId || $paymentData->order_item_id!=$order_item_id)
		{
			return 0;
		}
		
		if($orderData['order']->is_manual_payment==0)
		{
			$data['orderData']=$orderData;
			$data['itemData']=$orderItem;
			$data['paymentData']=$paymentData;
			$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
			$body=$this->load->view("orders/public/_email_subscription_fail_payment",$data,true);
			$subject=$orderData['order']->ashram_name.' - Payment Notification - Subscription payment for '.$orderItem->item_name;
			$this->email_extension->sendMailGuest(
													'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
													$orderData['order']->firstname." ".$orderData['order']->lastname,
													$orderData['order']->email,
													$subject,
													$body,
													'',
													1,
													'',
													$sevsOrGift
												);

			$this->load->library("sms");

			if($transaction->payment_mode == "cashiers_check"){
				$transaction->payment_mode = "cashiers check";
			}
			
			$message=
					display_site_name."\n".
					"Payment update:\n".
					$sevsOrGift." ID: ".$orderData['order']->order_number."\n".
					"Tx Date: ".date("d M Y",strtotime($transaction->started_on))."\n".
					"Amount: ".strtoupper($orderData['order']->currency)." ".$transaction->amount."\n".
					"Payment mode: ".$transaction->payment_mode."\n".
					"Tx status: Failed"
					;
			$this->sms->sendSMS(
									'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
									$data['countryData']->isd_code.$orderData['order']->phone,
									$message,
									1,
									$orderData['order']->user_id,
									$orderData['order']->username,
									$data['countryData']->isd_code
								);
		}

		return 1;
	}

	//Send Mail When subscription payment got mail from razorpay
	public function sendSubscriptionPaymentFailEmailBCC($orderId,$order_item_id,$payment_id,$tx)
	{
		$orderData=$this->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$transaction=$this->transaction_model->getTransactionByTx($tx);
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$paymentData=$this->subscription_payments_model->getById($payment_id);
		if(empty($paymentData) || $paymentData->order_id!=$orderId || $paymentData->order_item_id!=$order_item_id)
		{
			return 0;
		}
		
		if($orderData['order']->is_manual_payment==0)
		{
			$data['orderData']=$orderData;
			$data['itemData']=$orderItem;
			$data['paymentData']=$paymentData;
			$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
			$body=$this->load->view("orders/public/_email_subscription_fail_payment_bcc",$data,true);
			$subject=$orderData['order']->ashram_name.' - Payment Notification - Subscription payment for '.$orderItem->item_name;
			$this->email_extension->sendMailGuest(
													'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
													"Admin",
													orders_email_cc_2,
													$subject,
													$body,
													'',
													1,
													'',
													$sevsOrGift
												);
		}
		return 1;
	}

	// Send mail when subscription got completed
	public function sendSubscriptionCompletedMail($orderId,$order_item_id)
	{
		$orderData=$this->orders_model->orderData($orderId);
		$sevsOrGift = "Seva";
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$sevsOrGift = "Gift";
		}
		$orderItem=array();
		foreach ($orderData['order_items'] as $item)
		{
			if($item->order_item_id==$order_item_id)
			{
				$orderItem=$item;
				break;
			}
		}
		if(empty($orderItem))
		{
			return 0;
		}
		$data['orderData']=$orderData;
		$data['itemData']=$orderItem;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		$body=$this->load->view("orders/public/_email_subscription_completed",$data,true);
		$subject=$orderData['order']->ashram_name.' - Subscription Notification - Subscription Status for '.$orderItem->item_name;
		$d = $this->email_extension->sendMailGuest('payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),$orderData['order']->firstname." ".$orderData['order']->lastname, $orderData['order']->email, $subject, $body, '',1,'',$sevsOrGift);
		$this->load->library("sms");

		$message=
				display_site_name."\n".
				"Subscription update:\n".
				$sevsOrGift." ID: ".$orderData['order']->order_number."\n".
				"Subscription: ".$orderItem->item_name."\n".
				"Subscription ID: ".$orderItem->subscription_id."\n".
				"Start Date: ".date("d M Y",strtotime($orderItem->schedule_dates))."\n".
				"No of Payments: ".$orderItem->num_of_payments."\n".
				"Currency: ".strtoupper($orderData['order']->currency)."\n".
				"Subscription status: Completed"
				;
		$this->sms->sendSMS('payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency), $data['countryData']->isd_code.$orderData['order']->phone, $message, 1, $orderData['order']->user_id, $orderData['order']->username,$data['countryData']->isd_code );

		return 1;
	
	}


	public function listAdminPoojasSevaKarta()
	{
		if($this->session->userdata("ashramId"))
		{
			$poojas=$this->poojas_model->getByAshramId($this->session->userdata("ashramId"));
			$poojasArray=array();
			foreach ($poojas as $poojaData)
			{
				$poojasArray[$poojaData->id]=$poojaData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		if(isset($_GET['category_id']) && $_GET['category_id']!='')
		{
			$categoryData = $this->poojas_categories_model->categoryData($_GET['category_id']);
			// $categoryData = $this->poojas_categories_model->categoriesData($_GET['category_id']);
		}
		$preData='';
		$i=0;
		$query1=$this->db;
		$query1->select("country_name,price_inr,price_usd,inr_display,usd_display,oi.item_id as pooja_id,o.currency,pooja_name,firstname,lastname,family_member_details,city,state,item_name,price,pooja_on_swamiji,pooja_on_teertha_swamiji,donor_id");
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		$preData.="\nCategories: ";
		if(isset($_GET['category_id']) && $_GET['category_id']!='' && $_GET['category_id']!='-')
		{
			if(is_array($_GET['category_id']))
			{
				if(empty(array_filter($_GET['category_id'])))
				{
					goto category_default;
				}
				$query1->where_in("oi.category",$_GET['category_id']);
				$pii=0;
				foreach ($categoryData as $category)
				{
					if($pii) $preData.=", ";
					$preData.=$category->name;
					$pii++;
				}
			}
			else
			{					
				$query1->where("oi.category",$_GET['category_id']);
				$preData.=$categoryData->name;
			}
		}
		else
		{
			category_default:
			$preData.="All categories";
		}

		$preData.="\nSearch Keywords: ";
		
		if(isset($_GET['search_text']) && isset($_GET['search_col']) && 
			isset($_GET['wild']) && trim($_GET['search_text'])!='' &&
			in_array($_GET['search_col'],$GLOBALS['current_acl']['search_columns']) && 
			in_array($_GET['wild'],$GLOBALS['current_acl']['wild']))
		{
			if($_GET['wild']=='contains')
			{
				$query1->like($_GET['search_col'],trim($_GET['search_text']));
				$preData.=" containing ";
			}
			else if($_GET['wild']=='starts')
			{
				$query1->like($_GET['search_col'],trim($_GET['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_GET['wild']=='ends')
			{
				$query1->like($_GET['search_col'],trim($_GET['search_text']),'before');
				$preData.=" ending with ";
			}
			$preData.='"'.$_GET['search_text'].'"';
		}

		$preData.="\nPayment mode: ";
		if(isset($_GET['payment_mode']) && $_GET['payment_mode']!='')
		{
			$query1->like("payment_alt_mode",$_GET['payment_mode']);
			$preData.=$_GET['payment_mode'];
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nPooja(s): ";
			if(isset($_GET['pooja_id']) && $_GET['pooja_id']!='')
			{
				$poojaids = explode(',', $_GET['pooja_id']);
				if(is_array($poojaids))
				{
					$query1->where_in("item_id",$poojaids);
					$pii=0;
					foreach ($poojaids as $pooja_id)
					{
						if(isset($poojasArray[$pooja_id]->pooja_name))
						{
							if($pii) $preData.=", ";
							$preData.=$poojasArray[$pooja_id]->pooja_name;
							$pii++;
						}
					}
				}
				else
				{					
					$query1->where("item_id",$poojaids);
					$preData.=$poojasArray[$poojaids]->pooja_name;
				}
			}
			else
			{
				$preData.="All Poojas";
			}
		}

		$query1->where("o.order_type",1);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$query1->join("poojas as p",'p.id=oi.item_id');
		$query1->where("o.payment_status!=",0);
		$query1->where("is_cancelled!=",1);
		
		$preData.="\nCurrency: ";
		if(isset($_GET['currency']) && $_GET['currency']!='')
		{
			$query1->where("currency",$_GET['currency']);
			$preData.=strtoupper($_GET['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_GET['amount_condition']) && $_GET['amount_condition']!='') && (isset($_GET['search_amount']) && $_GET['search_amount']!='') )
		{
			$amountWhere = "IF(`oi`.`updated_quantity` > 0, (`oi`.`price`*`oi`.`updated_quantity`), (`oi`.`price`*`oi`.`quantity`)) ".$_GET['amount_condition']." '".$_GET['search_amount']."'";
			$query1->where($amountWhere);
			$preData.="\nAmount: ".$_GET['amount_condition']." ".$_GET['search_amount'];
		}

		$preData.="\nToken Status: ";
		if(isset($_GET['tokens']) && is_numeric($_GET['tokens']) && in_array($_GET['tokens'],array(0,1)))
		{
			$query1->where("tokens",$_GET['tokens']);
			if($_GET['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}

		$preData.="\nPayment Status: ";
		if(isset($_GET['payment_status']) && is_numeric($_GET['payment_status']) && in_array($_GET['payment_status'],array(0,1,2)))
		{
			$query1->where("payment_status",$_GET['payment_status']);
			if($_GET['payment_status']==1)
				$preData.="Paid";
			else if($_GET['payment_status']==0)
				$preData.="Pending";
			else if($_GET['payment_status']==1)
				$preData.="Partially Paid";
		}


		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';

		$preData.="\nFrom Date: ";
		if(isset($_GET['from_date']) && $_GET['from_date']!='')
		{
			$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_GET['from_date']))."' ";
			$fromDateTime=strtotime($_GET['from_date']);
			$preData.=$_GET['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_GET['to_date']) && $_GET['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_GET['to_date']))."'";
			$toDateTime=strtotime($_GET['to_date']);
			$preData.=$_GET['to_date'];
		}

		if((!isset($_GET['from_date']) || $_GET['from_date']=='') && (!isset($_GET['to_date']) || $_GET['to_date']==''))
		{
			$fromDateTime="0";
		}

		$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";

		$query1->where("oi.id in (".$sub_query.")");
		/*$query1->order_by('o.currency','asc');
		$query1->order_by('p.price_inr','desc');*/
		$query1->order_by('p.price_inr','desc');
		$query1->order_by("oi.family_member_details <> 'Sri Ganapathy Sachchidananda Swamiji'");
		$query1->order_by("oi.family_member_details <> 'Sri Datta Vijayananda Teertha Swamiji'");
		$query1->order_by('o.country_name','asc');
		$query1->order_by('o.city','asc');
		$query1->order_by('o.firstname','asc');
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['display_name']=$row['firstname'].' '.$row['lastname'];
			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
				$rtn['data'][$c]['family_details']=nl2br($row['family_member_details']);
			$rtn['data'][$c]['city']=$row['city'];
			$rtn['data'][$c]['country_name']=$row['country_name'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		$rtn['total_rows']=$c;
		$rtn['preData'] = $preData;
		return $rtn;
	}


	public function listAdminDonationsSevaKarta()
	{
		if($this->session->userdata("ashramId"))
		{
			$donations=$this->donations_model->getByAshramId($this->session->userdata("ashramId"));
			$donationsArray=array();
			foreach ($donations as $donationData)
			{
				$donationsArray[$donationData->id]=$donationData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		if(isset($_GET['category_id']) && $_GET['category_id']!='')
		{
			$categoryData = $this->donations_categories_model->categoriesData($_GET['category_id']);
		}
		$preData="";
		$i=0;
		$query1=$this->db;
		$query1->select("country_name,price_inr,price_usd,inr_display,usd_display,oi.item_id as donation_id,o.currency,donation_name,firstname,lastname,family_member_details,city,state,item_name,price,pooja_on_swamiji,pooja_on_teertha_swamiji,donor_id");

		$query1->where("oi.subscription",0);
		$query1->where("is_cancelled!=",1);
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		$preData.="\nCategories: ";
		if(isset($_GET['category_id']) && $_GET['category_id']!='' && $_GET['category_id']!='-')
		{
			if(is_array($_GET['category_id']))
			{
				if(empty(array_filter($_GET['category_id'])))
				{
					goto category_default;
				}
				$query1->where_in("oi.category",$_GET['category_id']);
				$pii=0;
				foreach ($categoryData as $category)
				{
					if($pii) $preData.=", ";
					$preData.=$category->name;
					$pii++;
				}
			}
			else
			{					
				$query1->where("oi.category",$_GET['category_id']);
				$preData.=$categoryData->name;
			}
		}
		else
		{
			category_default:
			$preData.="All categories";
		}

		$preData.="\nPayment mode: ";
		if(isset($_GET['payment_mode']) && $_GET['payment_mode']!='')
		{
			$query1->like("payment_alt_mode",$_GET['payment_mode']);
			$preData.=$_GET['payment_mode'];
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nDonation(s): ";
			if(isset($_GET['donation_id']) && $_GET['donation_id']!='')
			{

				$donationids = explode(',', $_GET['donation_id']);
				if(is_array($donationids))
				{
					$query1->where_in("item_id",$donationids);
					$pii=0;
					foreach ($donationids as $donation_id)
					{
						if(isset($donationsArray[$donation_id]->donation_name))
						{
							if($pii) $preData.=", ";
							$preData.=$donationsArray[$donation_id]->donation_name;
							$pii++;
						}
					}
				}
				else
				{					
					$query1->where("item_id",$donationids);
					$preData.=$donationsArray[$donationids]->donation_name;
				}
			}
			else
			{
				$preData.="All Donations";
			}
		}
		
		$query1->where("o.order_type",2);
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$query1->join("donations as d",'d.id=oi.item_id');
		$query1->where("o.payment_status!=",0);
		$preData.="\nSearch Keywords: ";
		
		if(isset($_GET['search_text']) && isset($_GET['search_col']) && trim($_GET['search_text'])!='' &&
			in_array($_GET['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(in_array(trim($_GET['search_col']), ['appji_member_name','appji_member_email', 'personal_note']))
			{
				$query1->like('oi.'.$_GET['search_col'],trim($_GET['search_text']));
			}
			else
			{
				$query1->like('o.'.$_GET['search_col'],trim($_GET['search_text']));
			}
			$preData.=" containing ";
			$preData.='"'.$_GET['search_text'].'"';
		}
		
		$preData.="\nCurrency: ";
		if(isset($_GET['currency']) && $_GET['currency']!='')
		{
			$query1->where("currency",$_GET['currency']);
			$preData.=strtoupper($_GET['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_GET['amount_condition']) && $_GET['amount_condition']!='') && (isset($_GET['search_amount']) && $_GET['search_amount']!='') )
		{
			$amountWhere = "IF(`oi`.`updated_quantity` > 0, (`oi`.`price`*`oi`.`updated_quantity`), (`oi`.`price`*`oi`.`quantity`)) ".$_GET['amount_condition']." '".$_GET['search_amount']."'";
			$query1->where($amountWhere);
			$preData.="\nAmount: ".$_GET['amount_condition']." ".$_GET['search_amount'];
		}

		$preData.="\nToken Status: ";
		if(isset($_GET['tokens']) && is_numeric($_GET['tokens']) && in_array($_GET['tokens'],array(0,1)))
		{
			$query1->where("tokens",$_GET['tokens']);
			if($_GET['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}

		$preData.="\nPayment Status: ";
		if(isset($_GET['payment_status']) && is_numeric($_GET['payment_status']) && in_array($_GET['payment_status'],array(0,1,2)))
		{
			$query1->where("payment_status",$_GET['payment_status']);
			if($_GET['payment_status']==1)
				$preData.="Paid";
			else if($_GET['payment_status']==0)
				$preData.="Pending";
			else if($_GET['payment_status']==1)
				$preData.="Partially Paid";
		}


		$preData.="\nFrom Date: ";
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';
		if(isset($_GET['from_date']) && $_GET['from_date']!='')
		{
			$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_GET['from_date']))."' ";
			$fromDateTime=strtotime($_GET['from_date']);
			$preData.=$_GET['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_GET['to_date']) && $_GET['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_GET['to_date']))."'";
			$toDateTime=strtotime($_GET['to_date']);
			$preData.=$_GET['to_date'];
		}

		if((!isset($_GET['from_date']) || $_GET['from_date']=='') && (!isset($_GET['to_date']) || $_GET['to_date']==''))
		{
			$fromDateTime="0";
		}
		
		$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";

		$query1->where("oi.id in (".$sub_query.")");
		/*$query1->order_by('o.currency','asc');
		$query1->order_by('d.price_inr','desc');*/
		$query1->order_by('d.price_inr','desc');
		$query1->order_by("oi.family_member_details <> 'Sri Ganapathy Sachchidananda Swamiji'");
        $query1->order_by("oi.family_member_details <> 'Sri Datta Vijayananda Teertha Swamiji'");
		$query1->order_by('o.country_name','asc');
		$query1->order_by('o.city','asc');
		$query1->order_by('o.firstname','asc');
		$rtn['data']=$query1->get()->result_array();
		$c=0;
		$sno=1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['display_name']=$row['firstname'].' '.$row['lastname'];
			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
			$rtn['data'][$c]['family_details']=nl2br($row['family_member_details']);

			$rtn['data'][$c]['city']=$row['city'];
			$rtn['data'][$c]['country_name']=$row['country_name'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		$rtn['total_rows']=$c;
		$rtn['preData'] = $preData;
		return $rtn;
	}

	public function listAdminSubscriptionsSevaKarta()
	{
		if($this->session->userdata("ashramId"))
		{
			$subscriptions=$this->subscriptions_model->getByAshramId($this->session->userdata("ashramId"));
			$subscriptionsArray=array();
			foreach ($subscriptions as $subscriptionData)
			{
				$subscriptionsArray[$subscriptionData->id]=$subscriptionData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$preData="";
		$i=0;
		$query1=$this->db;
		$query1->select("country_name,price_inr,price_usd,o.currency,subscription_name,firstname,lastname,family_member_details,city,state,item_name,price,pooja_on_swamiji,pooja_on_teertha_swamiji,donor_id");

		$query1->where("oi.subscription",1);
		$query1->where("is_cancelled!=",1);
		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nPayment mode: ";
		if(isset($_GET['payment_mode']) && $_GET['payment_mode']!='')
		{
			$query1->like("payment_alt_mode",$_GET['payment_mode']);
			$preData.=$_GET['payment_mode'];
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nsubscription(s): ";
			if(isset($_GET['subscription_id']) && $_GET['subscription_id']!='')
			{

				$subscriptionids = explode(',', $_GET['subscription_id']);
				if(is_array($subscriptionids))
				{
					$query1->where_in("item_id",$subscriptionids);
					$pii=0;
					foreach ($subscriptionids as $subscription_id)
					{
						if(isset($subscriptionsArray[$subscription_id]->subscription_name))
						{
							if($pii) $preData.=", ";
							$preData.=$subscriptionsArray[$subscription_id]->subscription_name;
							$pii++;
						}
					}
				}
				else
				{					
					$query1->where("item_id",$subscriptionids);
					$preData.=$subscriptionsArray[$subscriptionids]->subscription_name;
				}
			}
			else
			{
				$preData.="All subscriptions";
			}
		}
		
		$query1->group_start();
			$query1->where("o.order_type",2);
			$query1->or_where("o.order_type",4);
  		$query1->group_end();
  		
		$query1->from($this->tableName." as o");
		$query1->join("order_items as oi",'oi.order_id=o.id');
		$query1->join("subscriptions as d",'d.id=oi.item_id');
		$query1->where("oi.status!=",0);
		$query1->where("oi.status!=",2);
		$preData.="\nSearch Keywords: ";
		
		if(isset($_GET['search_text']) && isset($_GET['search_col']) && 
			isset($_GET['wild']) && trim($_GET['search_text'])!='')
		{
			if($_GET['wild']=='contains')
			{
				$query1->like($_GET['search_col'],trim($_GET['search_text']));
				$preData.=" containing ";
			}
			else if($_GET['wild']=='starts')
			{
				$query1->like($_GET['search_col'],trim($_GET['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_GET['wild']=='ends')
			{
				$query1->like($_GET['search_col'],trim($_GET['search_text']),'before');
				$preData.=" ending with ";
			}
			$preData.='"'.$_GET['search_text'].'"';
		}
		
		$preData.="\nCurrency: ";
		if(isset($_GET['currency']) && $_GET['currency']!='')
		{
			$query1->where("currency",$_GET['currency']);
			$preData.=strtoupper($_GET['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		if( (isset($_GET['amount_condition']) && $_GET['amount_condition']!='') && (isset($_GET['search_amount']) && $_GET['search_amount']!='') )
		{
			$amountWhere = "IF(`oi`.`updated_quantity` > 0, (`oi`.`price`*`oi`.`updated_quantity`), (`oi`.`price`*`oi`.`quantity`)) ".$_GET['amount_condition']." '".$_GET['search_amount']."'";
			$query1->where($amountWhere);
			$preData.="\nAmount: ".$_GET['amount_condition']." ".$_GET['search_amount'];
		}

		$preData.="\nToken Status: ";
		if(isset($_GET['tokens']) && is_numeric($_GET['tokens']) && in_array($_GET['tokens'],array(0,1)))
		{
			$query1->where("tokens",$_GET['tokens']);
			if($_GET['tokens']==1)
			{
				$preData.="Tokens issued";
			}
			else
			{
				$preData.="Tokens not issued";
			}
		}
		else
		{
			$preData.="All Token Status";
		}

		$preData.="\nPayment Status: ";
		if(isset($_GET['payment_status']) && is_numeric($_GET['payment_status']) && in_array($_GET['payment_status'],array(0,1,2)))
		{
			$query1->where("payment_status",$_GET['payment_status']);
			if($_GET['payment_status']==1)
				$preData.="Paid";
			else if($_GET['payment_status']==0)
				$preData.="Pending";
			else if($_GET['payment_status']==1)
				$preData.="Partially Paid";
		}


		$preData.="\nFrom Date: ";
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';
		if(isset($_GET['from_date']) && $_GET['from_date']!='')
		{
			$datesfilter.=" where date(date)>='".date("Y:m:d",strtotime($_GET['from_date']))."' ";
			$fromDateTime=strtotime($_GET['from_date']);
			$preData.=$_GET['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_GET['to_date']) && $_GET['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="date(date)<='".date("Y:m:d",strtotime($_GET['to_date']))."'";
			$toDateTime=strtotime($_GET['to_date']);
			$preData.=$_GET['to_date'];
		}

		if((!isset($_GET['from_date']) || $_GET['from_date']=='') && (!isset($_GET['to_date']) || $_GET['to_date']==''))
		{
			$fromDateTime="0";
		}
		
		$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";

		$query1->where("oi.id in (".$sub_query.")");
		/*$query1->order_by('d.subscription_name','asc');
		$query1->order_by('o.currency','asc');
		$query1->order_by('d.price_inr','desc');*/
		$query1->order_by("oi.family_member_details <> 'Sri Ganapathy Sachchidananda Swamiji'");
		$query1->order_by("oi.family_member_details <> 'Sri Datta Vijayananda Teertha Swamiji'");
		$query1->order_by('o.country_name','asc');
		$query1->order_by('o.city','asc');
		$query1->order_by('o.firstname','asc');
		$rtn['data']=$query1->get()->result_array();

		$donorquery=$this->auth_check;
		$donorquery->select("id,donor_name");
		$donorquery->from('donors');
		$temp_family_donors = $donorquery->get()->result_array();
		$all_family_donors = [];
		foreach ($temp_family_donors as $temp_family_donor) {
			$all_family_donors[$temp_family_donor['id']] = $temp_family_donor;
		}
		$c=0;
		$sno=1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['display_name']=$row['firstname'].' '.$row['lastname'];
			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_member_details']!='')
			$rtn['data'][$c]['family_details']=nl2br($row['family_member_details']);

			if($row['pooja_on_swamiji']==1)
			{
				$rtn['data'][$c]['family_details'] = $row['family_member_details'];
			} else if($row['pooja_on_teertha_swamiji']==1)
			{
				$rtn['data'][$c]['family_details'] = $row['family_member_details'];
			} else if((isset($row['donor_id']) && $row['donor_id']>0) && (isset($all_family_donors[$row['donor_id']]['donor_name']) && $all_family_donors[$row['donor_id']]['donor_name']!=''))
			{
				$rtn['data'][$c]['family_details']=$all_family_donors[$row['donor_id']]['donor_name'];
    		}
    		else
    		{
    			$rtn['data'][$c]['family_details']='N/A';
    		}

			$rtn['data'][$c]['city']=$row['city'];
			$rtn['data'][$c]['country_name']=$row['country_name'];

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		$rtn['total_rows']=$c;
		$rtn['preData'] = $preData;
		return $rtn;
	}

	public function getAllAshramUsdAmount($for_the_year, $trust_basic_id="")
	{

		$trust_ids = [];
		if($trust_basic_id>0)
		{
			$this->db->select("GROUP_CONCAT(DISTINCT id SEPARATOR ',') as trust_ids");
			$this->db->from("ashrams_trust_accounts");
			$this->db->where("trust_basic_id",$trust_basic_id);
			$trustids=$this->db->get()->row_array();

			if(isset($trustids['trust_ids']) && $trustids['trust_ids']!='')
			{
				$trust_ids = explode(',', $trustids['trust_ids']);
			}
		}

		$reports_db=$this->load->database("reports",true,false);
		$query1=$reports_db;
		$query1->select("SUM(amount) as total_amount");
		$query1->where("user_id",$this->currentUser->id);
		$query1->where("order_type !=",3);
		$query1->from("tx_report_usd_".$for_the_year);
		$query1->where("currency",'usd');
		if($trust_basic_id>0 && count($trust_ids)>0)
		{
			$query1->where_in('trust_id',$trust_ids);
		}
		if(isset($for_the_year) && is_numeric($for_the_year) && $for_the_year<=date("Y") && $for_the_year>=2015)
		{
			$query1->where("YEAR(transaction_date)",$for_the_year);
		}
		else
		{
			$query1->where("YEAR(transaction_date)",0);
		}
		$temp_result = $query1->get()->row();
		if(isset($temp_result->total_amount) && $temp_result->total_amount>0)
		{
			return $temp_result->total_amount;
		}
		else
		{
			return 0;
		}
	}

	public function getTrustInrAmount($for_the_year, $trust_basic_id="")
	{

		$trust_ids = [];
		if($trust_basic_id>0)
		{
			$this->db->select("GROUP_CONCAT(DISTINCT id SEPARATOR ',') as trust_ids");
			$this->db->from("ashrams_trust_accounts");
			$this->db->where("trust_basic_id",$trust_basic_id);
			$trustids=$this->db->get()->row_array();

			if(isset($trustids['trust_ids']) && $trustids['trust_ids']!='')
			{
				$trust_ids = explode(',', $trustids['trust_ids']);
			}
		}
		$tableName = "tx_report_inr_".strtolower(str_replace("-","_",$for_the_year));
		$reports_db=$this->load->database("reports",true,false);
		$query1=$reports_db;
		$query1->select("SUM(amount) as total_amount");
		$query1->where("user_id",$this->currentUser->id);
		$query1->where("order_type !=",3);
		$query1->from($tableName);
		$query1->where("currency",'inr');
		if($trust_basic_id>0 && count($trust_ids)>0)
		{
			$query1->where_in('trust_id',$trust_ids);
		}
		$temp_result = $query1->get()->row();
		if(isset($temp_result->total_amount) && $temp_result->total_amount>0)
		{
			return $temp_result->total_amount;
		}
		else
		{
			return 0;
		}
	}

	public function emptyCartData($beforedate='',$ashram_id=0,$cart_type=0,$user_id=0)
	{
		$rtn['flag'] = 0;
		
		if($beforedate == '')
		{
			return $rtn;
			exit;
		}

		$this->db->select("*");
		$wherecodition = " (date(updated_on) <= '".date("Y-m-d",strtotime($beforedate))."' OR date(started_on) <= '".date("Y-m-d",strtotime($beforedate))."')";
		if($ashram_id>0)
		{
			$wherecodition .= " AND ashram_id = {$ashram_id}";
		}
		if($cart_type>0)
		{
			$wherecodition .= " AND cart_type = {$cart_type}";
		}
		if($user_id>0)
		{
			$wherecodition .= " AND user_id = {$user_id}";
		}
		$this->db->where($wherecodition);
		$this->db->from("cart_data");
		$items=$this->db->get();
		
		if($items->num_rows() > 0)
		{
			$tableName = "cart_data_before_archives_".date("Ymd",strtotime($beforedate));
			if ($this->archivesDb->table_exists($tableName) )
			{
				if (!$this->archivesDb->field_exists('cart_from_seva_details', $tableName))
		        {
		            $sqlUpdatecol ="ALTER TABLE `".$tableName."` ADD `cart_from_seva_details` SMALLINT(2) NOT NULL DEFAULT '0' AFTER `started_on`;";
		            $this->archivesDb->query($sqlUpdatecol);
		        }
			}
			else
			{
			  	// table does not exist
			  	$new_table = "CREATE TABLE IF NOT EXISTS `".$tableName."` (
				  			  `id` int(11) NOT NULL AUTO_INCREMENT,
					  		  `cart_type` int(11) NOT NULL DEFAULT 1,
					  		  `subscription` int(11) NOT NULL DEFAULT 1,
							  `reference_id` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `cart_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `session_id` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `ashram_id` int(11) NOT NULL DEFAULT 0,
							  `user_id` int(11) NOT NULL DEFAULT 0,
							  `updated_on` datetime NOT NULL,
							  `started_on` datetime DEFAULT NULL,
							  `cart_from_seva_details` SMALLINT(2) NOT NULL DEFAULT '0',
					  		PRIMARY KEY (`id`)
							) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
				$this->archivesDb->query($new_table);
			}
			$resultData = $items->result_array();
			$removedPoojaRows = 0;
			$removedDonationsRows = 0;
			$removedSubscriptionsRows = 0;
			$removedStoreRows = 0;
			foreach ($resultData as$resulval) {
				if($resulval['cart_type'] ==1)
				{
					$removedPoojaRows = $removedPoojaRows+1;
				}
				if($resulval['cart_type'] ==2)
				{
					$removedDonationsRows = $removedDonationsRows+1;
				}
				if($resulval['cart_type'] ==3)
				{
					$removedStoreRows = $removedStoreRows+1;
				}
				if($resulval['cart_type'] ==4)
				{
					$removedSubscriptionsRows = $removedSubscriptionsRows+1;
				}
			}
			$rtn['removed_rows_message'] = '';
			if($removedPoojaRows > 0)
			{
				$rtn['removed_rows_message'] .= $removedPoojaRows.' Poojas Cart(s) cleared <br/>';
			}
			if($removedDonationsRows > 0)
			{
				$rtn['removed_rows_message'] .= $removedDonationsRows.' Donations Cart(s) cleared <br/>';
			}
			if($removedSubscriptionsRows > 0)
			{
				$rtn['removed_rows_message'] .= $removedSubscriptionsRows.' Subscriptions Cart(s) cleared <br/>';
			}
			if($removedStoreRows > 0)
			{
				$rtn['removed_rows_message'] .= $removedStoreRows.' Store Cart(s) cleared <br/>';
			}
			$this->archivesDb->insert_batch($tableName,$resultData);
			$this->db->where($wherecodition)->delete("cart_data");
			$rtn['total_removed_rows'] = $this->db->affected_rows();
			$rtn['flag'] = 1;
		}
		return $rtn;
	}

	public function getOrderDataItemDataByOrderItemId($orderItemId)
	{
		$this->db->select("*");
		$this->db->where("id",$orderItemId);
		$q=$this->db->get("order_items");
		$itemData = $q->row_array();
		if(isset($itemData['order_id']) && $itemData['order_id']!='')
		{
			$this->db->select("*");
			$this->db->where("id",$itemData['order_id']);
			$q=$this->db->get("orders");
			$orderData = $q->row_array();
			$itemData['orderData'] = $orderData;
		}

		if(isset($orderData['order_type']) && $orderData['order_type']==1 && isset($itemData['item_id']) && $itemData['item_id']!='')
		{
			$this->db->select("*");
			$this->db->where("id",$itemData['item_id']);
			$q=$this->db->get("poojas");
			$poojasData = $q->row_array();
			$itemData['poojasData'] = $poojasData;
		}

		if(isset($orderData['order_type']) && $orderData['order_type']==2 && isset($itemData['item_id']) && $itemData['item_id']!='')
		{
			$this->db->select("*");
			$this->db->where("id",$itemData['item_id']);
			$q=$this->db->get("donations");
			$donationsData = $q->row_array();
			$itemData['donationsData'] = $donationsData;
		}

		if(isset($orderData['order_type']) && $orderData['order_type']==3 && isset($itemData['item_id']) && $itemData['item_id']!='')
		{
			$this->db->select("*");
			$this->db->where("id",$itemData['item_id']);
			$q=$this->db->get("store");
			$storesData = $q->row_array();
			$itemData['storesData'] = $storesData;
		}

		if(isset($orderData['order_type']) && $orderData['order_type']==4 && isset($itemData['item_id']) && $itemData['item_id']!='')
		{
			$this->db->select("*");
			$this->db->where("id",$itemData['item_id']);
			$q=$this->db->get("subscriptions");
			$subscriptionsData = $q->row_array();
			$itemData['subscriptionsData'] = $subscriptionsData;
		}
		return $itemData;

	}

	public function updateOrderItemDates($orderItemId, $presentDate, $changedDate)
	{
		if(isset($orderItemId) && $orderItemId>0)
		{
			$this->db->select("*");
			$this->db->where("id",$orderItemId);
			$q=$this->db->get("order_items");
			$itemData = $q->row_array();
			// echo '<pre>'; print_r($itemDataDates); die();
			if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='' && $presentDate!='' && $changedDate!='')
			{
				// $changedstring = str_replace($presentDate,$changedDate,$itemData['schedule_dates']);
				$changedstring = implode($changedDate, explode($presentDate, $itemData['schedule_dates'], 2));
				$selected=explode(",",$changedstring);
				foreach($selected as $pdate)
				{
					$final[]=$pdate;
				}
				
				foreach($final as $key=>$tms)
				{
					$final[$key]=strtotime($tms);
				}
				asort($final);
				$resdatearr = [];
				foreach($final as $key=>$tms)
				{
					$final[$key]=date('d M Y',$tms);
					$resdatearr[]=date('d M Y (l)',$tms);
				}
				$changedstring = implode(',', $final);
				$changedstringdate = implode('\r\n', $resdatearr);

				$opts=unserialize($itemData['options']);
				$opts['result_date']=$changedstring;
				$opts['schedule_options']['selected_dates']=$changedstring;
				$opts['schedule_options']['result_date']=$changedstringdate;
				$updateData = array("schedule_dates"=>$changedstring, "options"=>serialize($opts));
				$this->db->where("id",$orderItemId);
				$this->db->update("order_items",$updateData);

				$this->db->select("*");
				$this->db->where("order_id",$itemData['order_id']);
				$this->db->where("order_item_id",$orderItemId);
				$this->db->where("date(date)=",date('Y-m-d',strtotime($presentDate)));
				$q=$this->db->get("order_items_dates");
				$itemDataDates = $q->row_array();
				if(isset($itemDataDates['id']) && $itemDataDates['id']>0)
				{
					$updateDateData = array("date"=>date('Y-m-d H:i:s',strtotime($changedDate)));

					if(isset($itemData['is_poornaphala_seva']) && $itemData['is_poornaphala_seva']==1)
					{
						$updateDateData['poornaphala_end_date'] = date('Y-m-d', strtotime($changedDate .' +15 days'));
					}

					$this->db->where("id",$itemDataDates['id']);
					$this->db->update("order_items_dates",$updateDateData);
				}

				$insertData=array(
                        "order_id"=> $itemData['order_id'],
                        "order_item_id"=>$orderItemId,
                        "from_date"=>date("Y-m-d H:i:s", strtotime($presentDate)),
                        "to_date"=>date("Y-m-d H:i:s", strtotime($changedDate)),
                        "changed_by"=>$this->currentUser->id,
                        "changed_on"=>date("Y:m:d H:i:s")
                    );
        		$this->db->insert('order_items_changed_dates',$insertData);

				$this->db->select("*");
				$this->db->where("id",$itemData['order_id']);
				$orderDataq=$this->db->get("orders");
				$eData['orderData']=$orderDataq->row_array();
				$eData['presentDate'] = $presentDate;
				$eData['changedDate'] = $changedDate;
				$eData['orderType'] = '';
				$eData['orderName'] = '';
				$eData['orderNumber'] = '';
				$eData['orderId'] = $itemData['order_id'];
				if(isset($itemData['item_name']) && $itemData['item_name']!='')
				{
					$eData['orderName'] = $itemData['item_name'];
				}
				if(isset($eData['orderData']['order_number']) && $eData['orderData']['order_number']!='')
				{
					$eData['orderNumber'] = $eData['orderData']['order_number'];
				}
				if(isset($eData['orderData']['id']) && $eData['orderData']['id']>0)
				{
					if(isset($eData['orderData']['order_type']) && $eData['orderData']['order_type'] == 1)
					{
						$eData['orderType'] = 'pooja';
					}
					if(isset($eData['orderData']['order_type']) && $eData['orderData']['order_type'] == 2)
					{
						$eData['orderType'] = 'donation';
					}
					if(isset($eData['orderData']['order_type']) && $eData['orderData']['order_type'] == 3)
					{
						$eData['orderType'] = 'store';
					}
					if(isset($eData['orderData']['order_type']) && $eData['orderData']['order_type'] == 4)
					{
						$eData['orderType'] = 'subscription';
					}

					$eData['sevsOrGift'] = "Seva";
					if(isset($eData['orderData']['declaration_type']) && $eData['orderData']['declaration_type']=='Gift')
					{
						$eData['sevsOrGift'] = "Gift";
					}

					$body=$this->load->view("orders/public/_email_oreder_item_date_change",$eData,true);
					$subject='Your '.$eData['orderType'].' date(s) have been changed per your request';
					$this->email_extension->sendMailGuest(
															'payments_'.$eData['orderData']['ashram_id']."_".strtolower($eData['orderData']['currency']),
															htmlentities($eData['orderData']['firstname'])." ".htmlentities($eData['orderData']['lastname']),
															$eData['orderData']['email'],
															$subject,
															$body,
															'',
															1,
															'',
															$eData['sevsOrGift']
														);
				}
				
			}
		}
	}

	public function updateOrderFamilyMemberDonorDetails($post)
	{
		// echo '<pre>'; print_r($post); die();
		$userId = @$post['userId'];
		$orderItemId = @$post['orderItemId'];
		$familyType = @$post['familyType'];
		$familyMembers = @$post['familyMembers'];

		$pooja_on_swamiji = 0;
		$pooja_on_teertha_swamiji = 0;
		$nameoffamilytype = "";
		$selectedfamilymembers = "";

		$this->load->model("user/users_model");
		$sso_user_id = $this->users_model->getSSOUserID($userId);

		if($familyType == '2' || $familyType == '6')
		{
			$donorquery=$this->auth_check;
			$donorquery->select("donor_name, donor_relation, id as donor_id");
			$donorquery->from('donors');
			$donorquery->where('user_id',$sso_user_id);
			$donorquery->order_by('id','ASC');
			$user_family_donors = $donorquery->get()->result_array();
			$thisnote = "";
			if(count($user_family_donors)>0){
				foreach($user_family_donors as $thisdonr)
				{
					$thisnote .= $thisdonr['donor_name']."\r\n";
					if($selectedfamilymembers == '')
					{
						$selectedfamilymembers .= $thisdonr['donor_id'];
					} else {
						$selectedfamilymembers .= ','.$thisdonr['donor_id'];
					}
				}
			}
			$nameoffamilytype = 2;
			if($familyType == '6')
			{
				$nameoffamilytype = 6;
			}
		} else if($familyType == '3' || $familyType == '7')
		{
			if($familyMembers)
			{
				$thisnote = "";
				if(count($familyMembers)>0){
					foreach($familyMembers as $thisdonr)
					{
						$donaridname = explode(' ___ ', $thisdonr);
						if(@$donaridname[0]!='')
						{
							$thisnote .= $donaridname[0]."\r\n";
						}
						if(@$donaridname[1]!='')
						{
							if($selectedfamilymembers == '')
							{
								$selectedfamilymembers .= $donaridname[1];
							} else {
								$selectedfamilymembers .= ','.$donaridname[1];
							}
						}
					}
				}
			}
			$nameoffamilytype = 3;
			if($familyType == '7')
			{
				$nameoffamilytype = 7;
			}
		} else if($familyType == "0" || $familyType == "4")
		{
			$pooja_on_swamiji = 1;
			$thisnote = "Sri Ganapathy Sachchidananda Swamiji";
			$nameoffamilytype = 0;
			if($familyType == "4")
			{
				$nameoffamilytype = 4;
			}
		} else if($familyType == "1" || $familyType == "5")
		{
			$pooja_on_teertha_swamiji = 1;
			$thisnote = "Sri Datta Vijayananda Teertha Swamiji";
			$nameoffamilytype = 1;
			if($familyType == "5")
			{
				$nameoffamilytype = 5;
			}
		}

		$updateData = [
						'family_member_details'=>$thisnote,
						'pooja_on_swamiji' => $pooja_on_swamiji,
						'name_of_family_type'=>$nameoffamilytype,
						'pooja_on_teertha_swamiji'=>$pooja_on_teertha_swamiji,
						'family_members'=>$selectedfamilymembers,
						];

		$this->db->where("id",$orderItemId);
		$this->db->update("order_items", $updateData);
		return 1;
	}

	public function update_no_transactions($order_id=0)
	{
		if($order_id)
		{
			$orderData=$this->orders_model->orderData($order_id);
	        if(!empty($orderData['order']))
	        {
	            $updateData = array(
	                                "is_cancelled"=>0,
	                                "cancel_reason"=>"",
	                                "cancelled_on"=>NULL,
	                                // "payment_status"=>1,
	                                "no_paid_transactions"=>"No"
	                                );
	            $this->db->where(array('id'=>$order_id));
	            $this->db->update('orders',$updateData);

	            $this->db->where(array('order_id'=>$order_id));
	            $this->db->update('order_items',array("status"=>1));
			}
		}
	}

	public function checkmismatchtrustorders()
    {
        $yesterdayDate = date('Y-m-d',strtotime("-1 days"));
        $poojas_ashram_id = "p.ashram_id";

        $poojas_q = "SELECT o.order_number,o.order_type,oi.order_id as order_id,o.ashram_id as order_ashram_id, p.ashram_id as original_ashram_id,o.date as order_date,o.total_price as order_amount,o.currency,o.payment_mode FROM order_items as oi JOIN orders as o ON o.id = oi.order_id JOIN poojas as p ON p.id = oi.item_id where o.order_type=1 AND date(o.date)="."'".$yesterdayDate."'"." AND o.ashram_id!=p.ashram_id group by o.id";

        $donations_ashram_id = "d.ashram_id";
        $donations_q = "SELECT o.order_number,o.order_type,oi.order_id as order_id,o.ashram_id as order_ashram_id, d.ashram_id as original_ashram_id,o.date as order_date,o.total_price as order_amount,o.currency,o.payment_mode FROM order_items as oi JOIN orders as o ON o.id = oi.order_id JOIN donations as d ON d.id = oi.item_id where o.order_type=2 AND date(o.date)="."'".$yesterdayDate."'"." AND o.ashram_id!=d.ashram_id group by o.id";

        $store_ashram_id = "s.ashram_id";
        $store_q = "SELECT o.order_number,o.order_type,oi.order_id as order_id,o.ashram_id as order_ashram_id, s.ashram_id as original_ashram_id,o.date as order_date,o.total_price as order_amount,o.currency,o.payment_mode FROM order_items as oi JOIN orders as o ON o.id = oi.order_id JOIN store as s ON s.id = oi.item_id where o.order_type=3 AND date(o.date)="."'".$yesterdayDate."'"." AND o.ashram_id!=s.ashram_id group by o.id";

        $subscriptions_ashram_id = "sub.ashram_id";
        $subscriptions_q = "SELECT o.order_number,o.order_type,oi.order_id as order_id,o.ashram_id as order_ashram_id, sub.ashram_id as original_ashram_id,o.date as order_date,o.total_price as order_amount,o.currency,o.payment_mode FROM order_items as oi JOIN orders as o ON o.id = oi.order_id JOIN subscriptions as sub ON sub.id = oi.item_id where o.order_type=4 AND date(o.date)="."'".$yesterdayDate."'"." AND o.ashram_id!=sub.ashram_id group by o.id";
        $final_array = array();

        $poojas_r = $this->db->query($poojas_q);
        $poojas_res = array();
        if($poojas_r->num_rows() > 0)
        {
        	$poojas_res = $poojas_r->result_array();
        }

        $donations_r = $this->db->query($donations_q);
        $donations_res = array();
        if($donations_r->num_rows() > 0)
        {
        	$donations_res = $donations_r->result_array();
        }

        $store_r = $this->db->query($store_q);
        $store_res = array();
        if($store_r->num_rows() > 0)
        {
        	$store_res = $store_r->result_array();
        }

        $subscriptions_r = $this->db->query($subscriptions_q);
        $subscriptions_res = array();
        if($subscriptions_r->num_rows() > 0)
        {
        	$subscriptions_res = $subscriptions_r->result_array();
        }

        if(count($poojas_res)>0 || count($donations_res)>0 || count($store_res)>0 || count($subscriptions_res)>0)
        {
        	$final_array = array_merge($poojas_res,$donations_res,$store_res,$subscriptions_res);
        	if(count($final_array) > 0)
        	{
        		foreach ($final_array as $key => $value) 
        		{
        			$checkExi = $this->db->where("order_id",$value["order_id"])->get("mismatch_ashram_orders");
        			if($checkExi->num_rows() > 0)
        				continue;

        			$this->db->insert("mismatch_ashram_orders",array(
        					"currency"=>$value["currency"],
						  	"order_amount"=>$value["order_amount"],
						  	"order_id"=>$value["order_id"],
						  	"order_number"=>$value["order_number"],
						  	"order_ashram_id"=>$value["order_ashram_id"],
						  	"original_ashram_id"=>$value["original_ashram_id"],
						  	"order_date"=>$value["order_date"],
						  	"payment_mode"=>$value["payment_mode"],
						  	"order_type"=>$value["order_type"]
        			));
        		}

        		$sendingReport = $this->db->select("*")->from("mismatch_ashram_orders")->where("DATE_FORMAT(order_date,'%Y-%m-%d')",$yesterdayDate)->order_by("currency,order_amount","desc")->get();
        		if($sendingReport->num_rows() > 0)
        		{
        			$this->load->model("email_extension_model");
					$settings=$this->email_extension_model->getSettingsByService('mismatch_ashram_orders');
					$tempdata['data']=$sendingReport->result_array();
					$tempdata['mismatch_date'] = $yesterdayDate;
			        $content=$this->load->view("orders/public/_email_mismatch_orders",$tempdata,true);

			        $viewData['name']="Admin";
					$viewData['body']=$content;
					$viewData['signature']=nl2br($settings->signature);
			        $content=$this->load->view("common/templates/email_template",$viewData,true);

			        $subject = "Sevas with mismatch ashrams, Date: ".date("d M Y, l",strtotime($yesterdayDate));
			        $cc = "";
			        $priority = 1;
			        $userData = array();
			        $ashram_mismatch_order_emails = ashram_mismatch_order_emails;
			        if(count($ashram_mismatch_order_emails) > 0)
			        {
			        	foreach ($ashram_mismatch_order_emails as $key => $value) 
				        {
				        	$queueID=$this->email_extension_model->mailTrack("mismatch_ashram_orders",$userData,$value,$subject,$content,0,0,0,0,$priority,1,$cc);
							$this->logaction->log("orders","Email sent to queue ".$value." | ID: ".$queueID);
				        }
			        }
        		}
		    }
        }
    }

    public function getOrderDataItemDataByOrderId($orderId)
	{
		$this->db->select("*");
		$this->db->where("id",$orderId);
		$q=$this->db->get("orders");
		$orderData = $q->row_array();
		

		$this->db->select("*");
		$this->db->where("order_id",$orderId);
		$q=$this->db->get("order_items");
		$itemsData = $q->result_array();
		if(count($itemsData)>0)
		{
			foreach($itemsData as $key => $itemData)
			{
				$itemsData[$key]['orderData'] = $orderData;

				if(isset($orderData['order_type']) && $orderData['order_type']==1 && isset($itemData['item_id']) && $itemData['item_id']!='')
				{
					$this->db->select("*");
					$this->db->where("id",$itemData['item_id']);
					$q=$this->db->get("poojas");
					$poojasData = $q->row_array();
					$itemsData[$key]['poojasData'] = $poojasData;
				}

				if(isset($orderData['order_type']) && $orderData['order_type']==2 && isset($itemData['item_id']) && $itemData['item_id']!='')
				{
					$this->db->select("*");
					$this->db->where("id",$itemData['item_id']);
					$q=$this->db->get("donations");
					$donationsData = $q->row_array();
					$itemsData[$key]['donationsData'] = $donationsData;
				}

				if(isset($orderData['order_type']) && $orderData['order_type']==3 && isset($itemData['item_id']) && $itemData['item_id']!='')
				{
					$this->db->select("*");
					$this->db->where("id",$itemData['item_id']);
					$q=$this->db->get("store");
					$storesData = $q->row_array();
					$itemsData[$key]['storesData'] = $storesData;
				}

				if(isset($orderData['order_type']) && $orderData['order_type']==4 && isset($itemData['item_id']) && $itemData['item_id']!='')
				{
					$this->db->select("*");
					$this->db->where("id",$itemData['item_id']);
					$q=$this->db->get("subscriptions");
					$subscriptionsData = $q->row_array();
					$itemsData[$key]['subscriptionsData'] = $subscriptionsData;
				}
			}
		}
		return $itemsData;

	}

	public function changeBulkItemsDates($order_id, $changingDatesWithItemKeys)
	{
		$changedDates = [];
		$changedItemsData = [];
		if(is_array($changingDatesWithItemKeys))
		{
			foreach ($changingDatesWithItemKeys as $itemKey => $changingDatesWithItemKey)
			{
				foreach($changingDatesWithItemKey as $innerChangingKey => $changingDatesWithItemKeyvalue)
				{
					$changedstring = '';
					$changedstringdate = '';
					$final = [];
					if($innerChangingKey!='' && $changingDatesWithItemKeyvalue!='')
					{
						$this->db->select("*");
						$this->db->where("id",$itemKey);
						$q=$this->db->get("order_items");
						$itemData = $q->row_array();
						$changedItemsData[$itemKey] = $itemData;
						if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='' && $innerChangingKey!='' && $changingDatesWithItemKeyvalue!='')
						{
							$changedDates[$itemKey][$innerChangingKey] = $changingDatesWithItemKeyvalue;
							$changedstring = implode($changingDatesWithItemKeyvalue, explode($innerChangingKey, $itemData['schedule_dates'], 2));
							$selected=explode(",",$changedstring);
							foreach($selected as $pdate)
							{
								$final[]=$pdate;
							}
							
							foreach($final as $key=>$tms)
							{
								$final[$key]=strtotime($tms);
							}
							asort($final);
							$resdatearr = [];
							foreach($final as $key=>$tms)
							{
								$final[$key]=date('d M Y',$tms);
								$resdatearr[]=date('d M Y (l)',$tms);
							}
							$changedstring = implode(',', $final);
							$changedstringdate = implode('\r\n', $resdatearr);

							$opts=unserialize($itemData['options']);
							$opts['result_date']=$changedstring;
							$opts['schedule_options']['selected_dates']=$changedstring;
							$opts['schedule_options']['result_date']=$changedstringdate;
							$updateData = array("schedule_dates"=>$changedstring, "options"=>serialize($opts));
							$this->db->where("id",$itemKey);
							$this->db->update("order_items",$updateData);

							$this->db->select("*");
							$this->db->where("order_id",$itemData['order_id']);
							$this->db->where("order_item_id",$itemKey);
							$this->db->where("date(date)=",date('Y-m-d',strtotime($innerChangingKey)));
							$q=$this->db->get("order_items_dates");
							$itemDataDates = $q->row_array();
							if(isset($itemDataDates['id']) && $itemDataDates['id']>0)
							{
								$updateDateData = array("date"=>date('Y-m-d H:i:s',strtotime($changingDatesWithItemKeyvalue)));

								if(isset($itemData['is_poornaphala_seva']) && $itemData['is_poornaphala_seva']==1)
								{
									$updateDateData['poornaphala_end_date'] = date('Y-m-d', strtotime($changingDatesWithItemKeyvalue .' +15 days'));
								}

								$this->db->where("id",$itemDataDates['id']);
								$this->db->update("order_items_dates",$updateDateData);
							}
						}
					}
				}
			}
		}
		if(count($changedDates)>0)
		{
			if(isset($changedDates) && count($changedDates)>0)
   			{
   				foreach ($changedDates as $itemkey => $changedDatesItem)
   				{
   					if(is_array($changedDatesItem))
   					{
   						foreach ($changedDatesItem as $previousdate => $changedDatesItemvalue)
   						{
   							$insertData=array(
                                    "order_id"=> $order_id,
                                    "order_item_id"=>$itemkey,
                                    "from_date"=>date("Y-m-d H:i:s", strtotime($previousdate)),
                                    "to_date"=>date("Y-m-d H:i:s", strtotime($changedDatesItemvalue)),
                                    "changed_by"=>$this->currentUser->id,
                                    "changed_on"=>date("Y:m:d H:i:s")
                                );
                    		$this->db->insert('order_items_changed_dates',$insertData);
   						}
   					}
   				}
   			}

			$this->db->select("*");
			$this->db->where("id",$order_id);
			$orderDataq=$this->db->get("orders");
			$eData['orderData']=$orderDataq->row_array();
			$eData['orderType'] = '';
			$eData['orderName'] = '';
			$eData['orderNumber'] = '';
			$eData['orderId'] = $order_id;
			$eData['changedDates'] = $changedDates;
			$eData['changedItemsData'] = $changedItemsData;
			if(isset($eData['orderData']['order_number']) && $eData['orderData']['order_number']!='')
			{
				$eData['orderNumber'] = $eData['orderData']['order_number'];
			}
			if(isset($eData['orderData']['id']) && $eData['orderData']['id']>0)
			{
				if(isset($eData['orderData']['order_type']) && $eData['orderData']['order_type'] == 1)
				{
					$eData['orderType'] = 'pooja';
				}
				if(isset($eData['orderData']['order_type']) && $eData['orderData']['order_type'] == 2)
				{
					$eData['orderType'] = 'donation';
				}
				if(isset($eData['orderData']['order_type']) && $eData['orderData']['order_type'] == 3)
				{
					$eData['orderType'] = 'store';
				}
				if(isset($eData['orderData']['order_type']) && $eData['orderData']['order_type'] == 4)
				{
					$eData['orderType'] = 'subscription';
				}

				$eData['sevsOrGift'] = "Seva";
				if(isset($eData['orderData']['declaration_type']) && $eData['orderData']['declaration_type']=='Gift')
				{
					$eData['sevsOrGift'] = "Gift";
				}

				$body=$this->load->view("orders/admin/_email_oreder_bulk_items_dates_change",$eData,true);
				$subject='Your '.$eData['orderType'].' date(s) have been changed per your request';
				$this->email_extension->sendMailGuest(
														'payments_'.$eData['orderData']['ashram_id']."_".strtolower($eData['orderData']['currency']),
														htmlentities($eData['orderData']['firstname'])." ".htmlentities($eData['orderData']['lastname']),
														$eData['orderData']['email'],
														$subject,
														$body,
														'',
														1,
														'',
														$eData['sevsOrGift']
													);
				}
		}
		return $changedDates;
	}


	public function triggerEmailDonationSevaKartaReport()
	{
		$this->db->select("id,name,donations_report_emails");
		$this->db->from('ashrams');
		$this->db->where("is_donations_report_email",1);
		$donationAshrams=$this->db->get()->result_array();
		$yesterdayDate = date('Y-m-d',strtotime("-1 days"));
		// $yesterdayDate = "2021-04-23";
		if(count($donationAshrams)>0)
		{
			foreach($donationAshrams as $thisAshram)
			{
				$ashramId = $thisAshram['id'];
				$toEmails = $thisAshram['donations_report_emails'];

				$reportingEmails = explode(",", $toEmails);
				if(count($reportingEmails)>0)
				{
					$query1=$this->db;
					$query1->select("country_name,price_inr,price_usd,o.currency,donation_name,firstname,lastname,family_member_details,city,state,item_name,price,pooja_on_swamiji,pooja_on_teertha_swamiji,donor_id");
					$query1->where("o.order_type",2);
					$query1->from("orders as o");
					$query1->join("order_items as oi",'oi.order_id=o.id');
					$query1->join("donations as d",'d.id=oi.item_id');
					$query1->where("o.payment_status!=",0);
					$query1->where("oi.subscription",0);
					$query1->where("is_cancelled!=",1);
					$query1->where("o.ashram_id",$ashramId);
					$datesfilter = " where date(date) = '".date("Y:m:d",strtotime($yesterdayDate))."'";
					$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";
					$query1->where("oi.id in (".$sub_query.")");
					$query1->order_by('o.country_name','asc');
					$query1->order_by('o.city','asc');
					$query1->order_by('o.firstname','asc');
					$donationSevas = $query1->get()->result_array();

					if(count($donationSevas)>0)
					{
						$c=0;
						$sno=1;
						foreach ($donationSevas as $row)
						{
							$donationSevas[$c]=$row;
							$donationSevas[$c]['sno']=$sno;
							$donationSevas[$c]['display_name']=$row['firstname'].' '.$row['lastname'];
							$donationSevas[$c]['family_details']='N/A';

							if($row['family_member_details']!='')
							$donationSevas[$c]['family_details']=nl2br($row['family_member_details']);

							$donationSevas[$c]['city']=$row['city'];
							$donationSevas[$c]['country_name']=$row['country_name'];

							$sno++;
							$c++;
						}



						$alldonations = [];
						if(count($donationSevas) > 0)
						{
						    $alldonations = array_unique(array_column($donationSevas, 'item_name'));
						}
						$data['donationSevas'] = $donationSevas;
						$data['allDonations'] = $alldonations;
						$data['forTheDate'] = $yesterdayDate;
						$data['ashramName'] = $thisAshram['name'];

	            		$subject  = "Donations sevakarta report for ashram: ".$thisAshram['name'].", Date: ".date("d M Y, l",strtotime($yesterdayDate));
	            		$body=$this->load->view("orders/public/_email_donations_sevakarta_report",$data,true);
	            		foreach ($reportingEmails as $thismail) 
						{
							echo "email sent to ".$thismail."<br>";
		            		$this->email_extension->sendMailGuest(
																'sevakarta_reports_'.$ashramId,
																"Admin",
																$thismail,
																$subject,
																$body,
																'',
																1);
		            	}
		            }
				}
			}
		}
	}


	public function triggerEmailSubscriptionSevaKartaReport()
	{
		$this->db->select("id,name,subscriptions_report_emails");
		$this->db->from('ashrams');
		$this->db->where("is_subscriptions_report_email",1);
		$subscriptionAshrams=$this->db->get()->result_array();
		$yesterdayDate = date('Y-m-d',strtotime("-1 days"));
		// $yesterdayDate = "2021-03-25";
		if(count($subscriptionAshrams)>0)
		{
			foreach($subscriptionAshrams as $thisAshram)
			{
				$ashramId = $thisAshram['id'];
				$toEmails = $thisAshram['subscriptions_report_emails'];

				$reportingEmails = explode(",", $toEmails);
				if(count($reportingEmails)>0)
				{
					$query1=$this->db;
					$query1->select("country_name,price_inr,price_usd,o.currency,subscription_name,firstname,lastname,family_member_details,city,state,item_name,price,pooja_on_swamiji,pooja_on_teertha_swamiji,donor_id");
					$query1->where("oi.subscription",1);
					$query1->where("is_cancelled!=",1);
					$query1->where("o.ashram_id",$ashramId);

					$query1->group_start();
						$query1->where("o.order_type",2);
						$query1->or_where("o.order_type",4);
			  		$query1->group_end();

			  		$query1->from("orders as o");
					$query1->join("order_items as oi",'oi.order_id=o.id');
					$query1->join("subscriptions as d",'d.id=oi.item_id');
					$query1->where("oi.status!=",0);
					$query1->where("oi.status!=",2);
					// $query1->where("o.payment_status!=",0);
					$datesfilter = " where date(date) = '".date("Y:m:d",strtotime($yesterdayDate))."'";
					$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";
					$query1->where("oi.id in (".$sub_query.")");
					$query1->order_by('o.country_name','asc');
					$query1->order_by('o.city','asc');
					$query1->order_by('o.firstname','asc');
					$subscriptionSevas = $query1->get()->result_array();

					if(count($subscriptionSevas)>0)
					{
						$c=0;
						$sno=1;
						foreach ($subscriptionSevas as $row)
						{
							$subscriptionSevas[$c]=$row;
							$subscriptionSevas[$c]['sno']=$sno;
							$subscriptionSevas[$c]['display_name']=$row['firstname'].' '.$row['lastname'];
							$subscriptionSevas[$c]['family_details']='N/A';

							if($row['family_member_details']!='')
							$subscriptionSevas[$c]['family_details']=nl2br($row['family_member_details']);

							$subscriptionSevas[$c]['city']=$row['city'];
							$subscriptionSevas[$c]['country_name']=$row['country_name'];

							$sno++;
							$c++;
						}



						$allsubscriptions = [];
						if(count($subscriptionSevas) > 0)
						{
						    $allsubscriptions = array_unique(array_column($subscriptionSevas, 'item_name'));
						}
						$data['subscriptionSevas'] = $subscriptionSevas;
						$data['allSubscriptions'] = $allsubscriptions;
						$data['forTheDate'] = $yesterdayDate;
						$data['ashramName'] = $thisAshram['name'];

	            		$subject  = "Subscriptions sevakarta report for ashram: ".$thisAshram['name'].", Date: ".date("d M Y, l",strtotime($yesterdayDate));
	            		$body=$this->load->view("orders/public/_email_subscriptions_sevakarta_report",$data,true);
	            		foreach ($reportingEmails as $thismail) 
						{
							echo "email sent to ".$thismail."<br>";
		            		$this->email_extension->sendMailGuest(
																'sevakarta_reports_'.$ashramId,
																"Admin",
																$thismail,
																$subject,
																$body,
																'',
																1);
		            	}
		            }
				}
			}
		}
	}


	public function triggerEmailStoreItemsSevaKartaReport()
	{
		$this->db->select("id,name,store_report_emails");
		$this->db->from('ashrams');
		$this->db->where("is_store_report_email",1);
		$storeItemsAshrams=$this->db->get()->result_array();
		$yesterdayDate = date('Y-m-d',strtotime("-1 days"));
		// $yesterdayDate = "2021-04-24";
		if(count($storeItemsAshrams)>0)
		{
			$countries=$this->locations_model->getCountries(true);
			foreach($storeItemsAshrams as $thisAshram)
			{
				$ashramId = $thisAshram['id'];
				$toEmails = $thisAshram['store_report_emails'];

				$reportingEmails = explode(",", $toEmails);
				if(count($reportingEmails)>0)
				{
					$query1=$this->db;
					$query1->select("o.*,oi.*,o.id as oid,o.payment_mode as payment_mode, usr.pan_number as pan_number,s.item_name");
					$query1->from("orders as o");
					$query1->join("order_items as oi",'oi.order_id=o.id');
					$query1->join("store as s",'s.id=oi.item_id');
					$query1->join("users as usr",'usr.id=o.user_id');
					$query1->where("o.order_type",3);
					$query1->where("payment_status!=",0);
					$query1->where("is_cancelled!=",1);
					$query1->where("o.ashram_id",$ashramId);
					$query1->where("date(date)=",date("Y:m:d",strtotime($yesterdayDate)));
					$query1->order_by('o.date','DESC');
					$storeItems = $query1->get()->result_array();
					if(count($storeItems)>0)
					{
						$c=0;
						$sno=1;
						foreach ($storeItems as $row)
						{
							$storeItems[$c]=$row;
							$storeItems[$c]['txids']=$storeItems[$c]['transaction_ids'];
							$storeItems[$c]['sno']=$sno;
							$storeItems[$c]['date']=date("d M Y",strtotime($storeItems[$c]['date']));
							$storeItems[$c]['item_price']=strtoupper($storeItems[$c]['currency'])." ".($storeItems[$c]['price']*$storeItems[$c]['quantity']);
							$storeItems[$c]['item_price_quantity']= "(".strtoupper($storeItems[$c]['currency'])." ".$storeItems[$c]['price']." x ".$storeItems[$c]['quantity'].")";
							$storeItems[$c]['total_price']=strtoupper($storeItems[$c]['currency'])." ".$storeItems[$c]['total_price'];

							if($row['quantity']>1)
							{
								$sub_total_sum=$rtn['total_sum'][strtolower($row['currency'])]-$row['price'];

								$rtn['total_sum'][strtolower($row['currency'])]=$sub_total_sum;
								$storeItems[$c]['item_price']=strtoupper($storeItems[$c]['currency'])." ".($storeItems[$c]['price']);
							}

							$storeItems[$c]['family_details']='N/A';

							if($row['family_member_details']!='')
							$storeItems[$c]['family_details']=nl2br($row['family_member_details']);

							$address=$row['address1'];
							if($row['address2']!='')
								$address.="<br>".$row['address2'];
							if($row['address3']!='')
								$address.="<br>".$row['address3'];
							$address.="<br>".$row['city'];
							$address.="<br>".$row['state'];
							$address.="<br>".$row['country'];

							$storeItems[$c]['address']=$address;

							$storeItems[$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];

							$sno++;
							$c++;
						}



						$allstoreitems = [];
						if(count($storeItems) > 0)
						{
						    $allstoreitems = array_unique(array_column($storeItems, 'item_name'));
						}
						$data['storeItems'] = $storeItems;
						$data['allStoreItems'] = $allstoreitems;
						$data['forTheDate'] = $yesterdayDate;
						$data['ashramName'] = $thisAshram['name'];

	            		$subject  = "Store items report for ashram: ".$thisAshram['name'].", Date: ".date("d M Y, l",strtotime($yesterdayDate));
	            		$body=$this->load->view("orders/public/_email_store_items_report",$data,true);
	            		foreach ($reportingEmails as $thismail) 
						{
							echo "email sent to ".$thismail."<br>";
		            		$this->email_extension->sendMailGuest(
																'sevakarta_reports_'.$ashramId,
																"Admin",
																$thismail,
																$subject,
																$body,
																'',
																1);
		            	}
		            }
				}
			}
		}
	}


	public function triggeGetAndSavePoojaSevakartaReportCronsForTheDay()
	{
		$this->db->select("id,name,poojas_report_emails");
		$this->db->from('ashrams');
		$this->db->where("is_poojas_report_email",1);
		$poojaAshrams=$this->db->get()->result_array();
		$currentDate = date('Y-m-d');
		$tomorrowDate = date("Y-m-d", strtotime("+1 day"));
		$datearray = [$currentDate, $tomorrowDate];
		// $currentDate = "2021-04-24";
		// echo '<pre>'; print_r($poojaAshrams); die();
		$poojasForTodayCron = [];
		if(count($poojaAshrams)>0)
		{
			foreach($datearray as $forTheDate)
			{
				foreach($poojaAshrams as $thisAshram)
				{
					$ashramId = $thisAshram['id'];
					$toEmails = $thisAshram['poojas_report_emails'];

					$query1=$this->db;
					$query1->select("p.id as id, pooja_name, ashram_id, start_date, end_date, time_from, time_to, cutoff_type, cutoff_hour, cutoff_minutes, days, include_exclude_dates, exclude_dates, include_dates");
					$query1->from("poojas as p");
					$query1->where("ashram_id",$ashramId);
					$query1->where("status",1);
					$query1->where("is_external_link",0);
					$query1->where("date(start_date)<=",$forTheDate);
					$query1->where("date(end_date)>=",$forTheDate);
					$query1->order_by('p.order','asc');
					$allPoojas=$query1->get()->result_array();
					// echo '<pre>'; print_r($allPoojas);


					if(count($allPoojas)>0)
					{
						foreach ($allPoojas as $key => $poojaData)
						{
							$include_exclude_dates = $poojaData['include_exclude_dates'];
							$weekdays=explode(",",$poojaData['days']);
							$exclude_dates=explode(",",$poojaData['exclude_dates']);
							$include_dates=explode(",",$poojaData['include_dates']);
							$startDateTime=strtotime($poojaData['start_date']);
							$endDateTime=strtotime($poojaData['end_date']);


							$cutoffType=$poojaData['cutoff_type'];
							$cutoffHour=$poojaData['cutoff_hour'];
							$cutoffMinutes=$poojaData['cutoff_minutes'];
							if($cutoffHour>0)
							{
								$tempMinutes = $cutoffHour*60;
								$cutoffMinutes = $cutoffMinutes+$tempMinutes;
							}
							$temp=strtotime("00:00:00");
							if($cutoffType=='CloseAfterStartTime')
							{
								$dateTime=strtotime(date($forTheDate,$temp)." ".$poojaData['time_from']." +".$cutoffMinutes." Minutes");
							} else if($cutoffType=='CloseAfterEndTime')
							{
								$dateTime=strtotime(date($forTheDate,$temp)." ".$poojaData['time_to']." +".$cutoffMinutes." Minutes");
							} else if($cutoffType=='CloseBeforeStartTime')
							{
								$dateTime=strtotime(date($forTheDate,$temp)." ".$poojaData['time_from']." -".$cutoffMinutes." Minutes");
							} else if($cutoffType=='CloseBeforeEndTime')
							{
								$dateTime=strtotime(date($forTheDate,$temp)." ".$poojaData['time_to']." -".$cutoffMinutes." Minutes");
							} else {
								$dateTime=strtotime(date($forTheDate,$temp)." ".$poojaData['time_to']." -".$cutoffMinutes." Minutes");
							}

							$poojaData['cron_run_time'] = date('Y-m-d H:i:s',$dateTime);
							$poojaData['report_emails'] = $toEmails;
							$poojaData['seva_date'] = $forTheDate;

							if($include_exclude_dates == 'IncludeDates')
							{
								if(in_array(date('d M Y', strtotime($forTheDate)), $include_dates))
								{
									$poojasForTodayCron[] = $poojaData;
								}
							}
							else if($include_exclude_dates == 'ExcludeDates')
							{
								if(!in_array(date('d M Y', strtotime($forTheDate)), $exclude_dates))
								{
									$poojasForTodayCron[] = $poojaData;
								}
							}
							else
							{
								$poojasForTodayCron[] = $poojaData;
							}
						}

					}

				}
			}
		}
		// echo '<pre>'; print_r($poojasForTodayCron); exit;
		if(count($poojasForTodayCron)>0)
		{
			foreach($poojasForTodayCron as $thisPooja)
			{
				$this->db->where("item_id",$thisPooja['id']);
				$this->db->where("date(seva_date)=",date('Y-m-d', strtotime($thisPooja['seva_date'])));
                $record_exist=$this->db->get('pooja_sevakarta_reports_crons')->num_rows();
                if($record_exist)
                {

                }
                else
                {
                	$insData = [
                					'ashram_id' => $thisPooja['ashram_id'],
									'item_id' => $thisPooja['id'],
									'item_name' => $thisPooja['pooja_name'],
									'seva_date' => $thisPooja['seva_date'],
									'cron_to_be_run_on' => $thisPooja['cron_run_time'],
									'report_emails' => $thisPooja['report_emails'],
								];
					$this->db->insert('pooja_sevakarta_reports_crons',$insData);
                }
			}
		}
	}

	public function triggerEmailPoojaSevaKartaReport()
	{
		$currentDateTime = date('Y-m-d H:i:s');
		$this->db->select("*");
		$this->db->from('pooja_sevakarta_reports_crons');
		$this->db->where("cron_to_be_run_on<=",$currentDateTime);
		$this->db->where("cron_run_status",'0');
		$this->db->order_by('cron_to_be_run_on','asc');
		$poojaItems=$this->db->get()->result_array();
		// echo '<pre>'; print_r($poojaItems); die();
		if(count($poojaItems)>0)
		{
			foreach($poojaItems as $thisPooja)
			{
				$toEmails = $thisPooja['report_emails'];
				$reportingEmails = explode(",", $toEmails);
				if(count($reportingEmails)>0)
				{
					$query1=$this->db;
					$query1->select("country_name,price_inr,price_usd,o.currency,pooja_name,firstname,lastname,family_member_details,city,state,item_name,price,pooja_on_swamiji,pooja_on_teertha_swamiji,donor_id");
					$query1->from("orders as o");
					$query1->join("order_items as oi",'oi.order_id=o.id');
					$query1->join("poojas as p",'p.id=oi.item_id');
					$query1->where("item_id",$thisPooja['item_id']);
					$query1->where("o.order_type",1);
					$query1->where("o.payment_status!=",0);
					$query1->where("is_cancelled!=",1);
					$datesfilter = " where date(date) = '".date("Y:m:d",strtotime($thisPooja['seva_date']))."' ";
					$sub_query="select order_item_id FROM `order_items_dates` ".$datesfilter." group by order_item_id";
					$query1->where("oi.id in (".$sub_query.")");
					$query1->order_by('o.country_name','asc');
					$query1->order_by('o.city','asc');
					$query1->order_by('o.firstname','asc');
					$poojasSevas = $query1->get()->result_array();
					// echo '<pre>'; print_r($query1->last_query()); die();
					// echo '<pre>'; print_r($poojasSevas);
					if(count($poojasSevas)>0)
					{
						$c=0;
						$sno=1;
						foreach ($poojasSevas as $row)
						{
							$poojasSevas[$c]=$row;
							$poojasSevas[$c]['sno']=$sno;
							$poojasSevas[$c]['display_name']=$row['firstname'].' '.$row['lastname'];
							$poojasSevas[$c]['family_details']='N/A';

							if($row['family_member_details']!='')
								$poojasSevas[$c]['family_details']=nl2br($row['family_member_details']);
							$poojasSevas[$c]['city']=$row['city'];
							$poojasSevas[$c]['country_name']=$row['country_name'];

							$sno++;
							$c++;
						}

						$allpoojas = [];
						if(count($poojasSevas) > 0)
						{
						    $allpoojas = array_unique(array_column($poojasSevas, 'item_name'));
						}
						$data['poojasSevas'] = $poojasSevas;
						$data['allPoojas'] = $allpoojas;
						$data['forTheDate'] = $thisPooja['seva_date'];
						$data['poojaName'] = $thisPooja['item_name'];

	            		$subject  = "Poojas sevakarta report for the pooja: ".$thisPooja['item_name'].", Date: ".date("d M Y, l",strtotime($thisPooja['seva_date']));
	            		$body=$this->load->view("orders/public/_email_poojas_sevakarta_report",$data,true);
	            		foreach ($reportingEmails as $thismail) 
						{
							echo "email sent to ".$thismail."<br>";
		            		$this->email_extension->sendMailGuest(
																'sevakarta_reports_'.$thisPooja['ashram_id'],
																"Admin",
																$thismail,
																$subject,
																$body,
																'',
																1);
		            	}
					}

					$this->db->where("id",$thisPooja['id']);
					$this->db->update('pooja_sevakarta_reports_crons',['cron_run_status'=>'1']);
				}
			}
		}
	}

	public function updateAppjiLinkTokens($orderId)
	{
		$orderData=$this->orderData($orderId);
		$updatearr = [];
		if(isset($orderData['order']->id) && $orderData['order']->id!='')
		{
			$updatearr['order_id'] = $orderData['order']->id;
		}
		if(isset($orderData['order']->order_number) && $orderData['order']->order_number!='')
		{
			$updatearr['order_number'] = $orderData['order']->order_number;
		}
		if(isset($orderData['order']->transaction_id) && $orderData['order']->transaction_id!='')
		{
			$updatearr['transaction_id'] = $orderData['order']->transaction_id;
		}
		if(isset($orderData['order']->payment_status) && $orderData['order']->payment_status==1)
		{
			$updatearr['paymentStatus'] = "Paid";
		}
		if(isset($orderData['order']->payment_status) && $orderData['order']->payment_status==2)
		{
			$updatearr['paymentStatus'] = "Partially Paid";
		}
		if(isset($orderData['order']->payment_status) && in_array($orderData['order']->payment_status, [1,2]))
		{
			$updatearr['isLinkExpired'] = '1';
		}
		if(isset($orderData['order']->user_id) && $orderData['order']->user_id!='')
		{
			$updatearr['paidUserId'] = $orderData['order']->user_id;
		}
		if(isset($orderData['order']->username) && $orderData['order']->username!='')
		{
			$updatearr['paidUserName'] = $orderData['order']->username;
		}
		$updatearr['paidUserFullName'] = "";
		if(isset($orderData['order']->firstname) && $orderData['order']->firstname!='')
		{
			$updatearr['paidUserFullName'] = $orderData['order']->firstname;
		}
		if(isset($orderData['order']->middlename) && $orderData['order']->middlename!='')
		{
			$updatearr['paidUserFullName'] .= " ".$orderData['order']->middlename;
		}
		if(isset($orderData['order']->lastname) && $orderData['order']->lastname!='')
		{
			$updatearr['paidUserFullName'] .= " ".$orderData['order']->lastname;
		}
		if(isset($orderData['order']->email) && $orderData['order']->email!='')
		{
			$updatearr['paidUserEmail'] = $orderData['order']->email;
		}
		if(isset($orderData['order']->phone) && $orderData['order']->phone!='')
		{
			$updatearr['paidUserPhone'] = "+".$orderData['order']->isd_code.''.$orderData['order']->phone;
		}
		$updatearr['paidUserAddress'] = "";
		if(isset($orderData['order']->address1) && $orderData['order']->address1!='')
		{
			$updatearr['paidUserAddress'] = $orderData['order']->address1;
		}
		if(isset($orderData['order']->address2) && $orderData['order']->address2!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->address2;
		}
		if(isset($orderData['order']->address3) && $orderData['order']->address3!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->address3;
		}
		if(isset($orderData['order']->city) && $orderData['order']->city!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->city;
		}
		if(isset($orderData['order']->state) && $orderData['order']->state!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->state;
		}
		if(isset($orderData['order']->country_name) && $orderData['order']->country_name!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->country_name;
		}
		if(isset($orderData['order']->zipcode) && $orderData['order']->zipcode!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->zipcode;
		}
		if(isset($orderData['order']->payment_status) && in_array($orderData['order']->payment_status, [1,2]))
		{
			$updatearr['paidOn'] = date('Y-m-d H:i:s');
		}
		if(isset($orderData['order_items']) && count($orderData['order_items'])>0)
		{
			foreach($orderData['order_items'] as $thisOrderItem)
			{
				if(isset($thisOrderItem->order_item_id) && $thisOrderItem->order_item_id>0)
				{
					$updatearr['order_item_id'] = $thisOrderItem->order_item_id;
				}
				if(isset($thisOrderItem->schedule_dates) && $thisOrderItem->schedule_dates!='')
				{
					$selectedDates=array_filter(explode(",",$thisOrderItem->schedule_dates));
        			foreach ($selectedDates as $selectedDate)
        			{
        				if(trim($selectedDate)!='')
        				{
        					if(isset($orderData['order']->order_type) && $orderData['order']->order_type=='2')
							{
        						$updatearr['donationDate'] = date("Y-m-d",strtotime($selectedDate));
        					}
        					else if(isset($orderData['order']->order_type) && $orderData['order']->order_type=='4')
    						{
    							$updatearr['subscriptionDate'] = date("Y-m-d",strtotime($selectedDate));
    						}
        				}
        			}
				}
				if(isset($thisOrderItem->is_from_appji) && $thisOrderItem->is_from_appji=='Yes')
				{
					if(isset($thisOrderItem->link_token) && $thisOrderItem->link_token!='')
					{
						$this->db->where("linkToken",$thisOrderItem->link_token);
						if(isset($orderData['order']->order_type) && $orderData['order']->order_type=='2')
						{
							$this->db->update("appji_donations_links",$updatearr);
						}
						if(isset($orderData['order']->order_type) && $orderData['order']->order_type=='4')
						{
							$this->db->update("appji_subscriptions_links",$updatearr);
						}
						// $this->sendDonationPaymentSuccessToAppjiServer($thisOrderItem->link_token,$updatearr);
					}
				}
			}
		}
	}


	function sendOrderPaymentStatusToAppjiServer($orderId)
	{
		$orderData=$this->orderData($orderId);
		$updatearr = [];
		if(isset($orderData['order']->id) && $orderData['order']->id!='')
		{
			$updatearr['order_id'] = $orderData['order']->id;
		}
		if(isset($orderData['order']->order_number) && $orderData['order']->order_number!='')
		{
			$updatearr['order_number'] = $orderData['order']->order_number;
		}
		if(isset($orderData['order']->transaction_id) && $orderData['order']->transaction_id!='')
		{
			$updatearr['transaction_id'] = $orderData['order']->transaction_id;
		}
		if(isset($orderData['order']->payment_status) && $orderData['order']->payment_status==1)
		{
			$updatearr['paymentStatus'] = "Paid";
		}
		if(isset($orderData['order']->payment_status) && $orderData['order']->payment_status==2)
		{
			$updatearr['paymentStatus'] = "Partially Paid";
		}
		if(isset($orderData['order']->payment_status) && in_array($orderData['order']->payment_status, [1,2]))
		{
			$updatearr['isLinkExpired'] = '1';
		}
		if(isset($orderData['order']->user_id) && $orderData['order']->user_id!='')
		{
			$updatearr['paidUserId'] = $orderData['order']->user_id;
		}
		if(isset($orderData['order']->username) && $orderData['order']->username!='')
		{
			$updatearr['paidUserName'] = $orderData['order']->username;
		}
		$updatearr['paidUserFullName'] = "";
		if(isset($orderData['order']->firstname) && $orderData['order']->firstname!='')
		{
			$updatearr['paidUserFullName'] = $orderData['order']->firstname;
		}
		if(isset($orderData['order']->middlename) && $orderData['order']->middlename!='')
		{
			$updatearr['paidUserFullName'] .= " ".$orderData['order']->middlename;
		}
		if(isset($orderData['order']->lastname) && $orderData['order']->lastname!='')
		{
			$updatearr['paidUserFullName'] .= " ".$orderData['order']->lastname;
		}
		if(isset($orderData['order']->email) && $orderData['order']->email!='')
		{
			$updatearr['paidUserEmail'] = $orderData['order']->email;
		}
		if(isset($orderData['order']->phone) && $orderData['order']->phone!='')
		{
			$updatearr['paidUserPhone'] = "+".$orderData['order']->isd_code.''.$orderData['order']->phone;
		}
		$updatearr['paidUserAddress'] = "";
		if(isset($orderData['order']->address1) && $orderData['order']->address1!='')
		{
			$updatearr['paidUserAddress'] = $orderData['order']->address1;
		}
		if(isset($orderData['order']->address2) && $orderData['order']->address2!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->address2;
		}
		if(isset($orderData['order']->address3) && $orderData['order']->address3!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->address3;
		}
		if(isset($orderData['order']->city) && $orderData['order']->city!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->city;
		}
		if(isset($orderData['order']->state) && $orderData['order']->state!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->state;
		}
		if(isset($orderData['order']->country_name) && $orderData['order']->country_name!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->country_name;
		}
		if(isset($orderData['order']->zipcode) && $orderData['order']->zipcode!='')
		{
			$updatearr['paidUserAddress'] .= ", ".$orderData['order']->zipcode;
		}
		if(isset($orderData['order']->payment_status) && in_array($orderData['order']->payment_status, [1,2]))
		{
			$updatearr['paidOn'] = date('Y-m-d H:i:s');
		}
		if(isset($orderData['order_items']) && count($orderData['order_items'])>0)
		{
			foreach($orderData['order_items'] as $thisOrderItem)
			{
				if(isset($thisOrderItem->order_item_id) && $thisOrderItem->order_item_id>0)
				{
					$updatearr['order_item_id'] = $thisOrderItem->order_item_id;
				}
				if(isset($thisOrderItem->is_from_appji) && $thisOrderItem->is_from_appji=='Yes')
				{
					if(isset($thisOrderItem->link_token) && $thisOrderItem->link_token!='')
					{
						if(isset($orderData['order']->order_type) && $orderData['order']->order_type=='2')
						{
							$this->sendDonationPaymentSuccessToAppjiServer($thisOrderItem->link_token,$updatearr);
						}
						if(isset($orderData['order']->order_type) && $orderData['order']->order_type=='4')
						{
							$this->sendSubscriptionPaymentSuccessToAppjiServer($thisOrderItem->link_token,$updatearr);
						}
					}
				}
			}
		}
	}


	function sendDonationPaymentSuccessToAppjiServer($linkToken, $data)
	{
		$this->db->where("client_name","Appji");
		$appjiClientDetails = $this->db->get('app_clients')->row_array();
		if(isset($appjiClientDetails['client_id']) && isset($appjiClientDetails['client_base_url']) && $appjiClientDetails['client_base_url']!='')
		{
			$this->db->where("linkToken",$linkToken);
			$q=$this->db->get('appji_donations_links');
			$linkTokenDetails=$q->row_array();
			if(count($linkTokenDetails)>0)
			{
				$serviceUrl = $appjiClientDetails['client_base_url']."/donation";
		        log_message('error', "**********Start of API Call to Appji Server for donation link token ".$linkTokenDetails['linkToken']." Payment Success************");
		        log_message('error', $serviceUrl." Time: ".date("Y-m-d H:i:s"));
		        $headers = [
		            'X-API-Key:' . $appjiClientDetails['client_request_api_key'],
		            'Content-Type: application/json'
		        ];

		        $postdata = [
					"orderId" => $linkTokenDetails['order_id'],
					"transactionId" => $linkTokenDetails['transaction_id'],
					"donationDate" => $linkTokenDetails['donationDate'],
					"donationCurrency" => strtoupper($linkTokenDetails['donationCurrency']),
					"donationAmount" => intval($linkTokenDetails['donationAmount']),
					"appjiEmail" => $linkTokenDetails['appjiEmail'],
					"loginEmail" => $linkTokenDetails['paidUserEmail'],
					"paidUserName" => $linkTokenDetails['paidUserName'],
					"paidUserFullName" => $linkTokenDetails['paidUserFullName'],
					"linkToken" => $linkTokenDetails['linkToken'],
					"paymentStatus" => $linkTokenDetails['paymentStatus'],
					"timestamp" => strtotime($linkTokenDetails['paidOn'])
		        ];

		        $curl = curl_init();
		        curl_setopt_array($curl, array(
		            CURLOPT_URL => $serviceUrl,
		            CURLOPT_RETURNTRANSFER => true,
		            CURLOPT_ENCODING => '',
		            CURLOPT_TIMEOUT => 120,
		            CURLOPT_REFERER, $appjiClientDetails['client_base_url'],
		            CURLOPT_CUSTOMREQUEST => "POST",
		            CURLOPT_POSTFIELDS => json_encode($postdata),
		            CURLOPT_HTTPHEADER => $headers,
		            CURLOPT_FAILONERROR => true
		        ));
		        if (curl_errno($curl)) 
		        {
		            $error_msg = curl_error($curl);
		            log_message('error', print_r($error_msg, TRUE));
		        }
		        $response = curl_exec($curl);
		        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		        curl_close($curl);
		        log_message('error', print_r($response, TRUE));
		        log_message('error', print_r("HTTP Code: ".$httpcode, TRUE));
		        if($httpcode == 200)
		        {
		        	$this->db->where("linkToken",$linkToken);
					$this->db->update("appji_donations_links",array('is_updated_in_appji' => 1));
		        }
		     //    $result = json_decode($response);
		     //    if(isset($result->status) && $result->status == 'success')
			    // {
			    // }
		        log_message('error', "**********End of API Call");
			}
		}
	}

	public function updateAppjiMemberName($orderData,$orderItem,$family_member_details)
	{
		$opts=unserialize($orderItem->options);
		$opts['family_member_details']=$family_member_details;
		$opts['appji_member_name']=$family_member_details;
		$updateData['family_member_details']= $family_member_details;
		$updateData['appji_member_name']= $family_member_details;

		if($orderItem->appji_member_email !='')
		{
			$opts['family_member_details'].= "\r\n".$orderItem->appji_member_email;
			$updateData['family_member_details'].= "\r\n".$orderItem->appji_member_email;
		}

		$updateData['options'] = serialize($opts);

		$this->db->where("id",$orderItem->order_item_id);
		$this->db->update("order_items",$updateData);
		$this->logaction->log($this->service,"Changed appji member name for Seva item:".$orderItem->order_item_id." - Seva ID:".$orderData['order']->id);
	}

	public function updateAppjiMemberEmail($orderData,$orderItem,$member_email)
	{
		$opts=unserialize($orderItem->options);
		$opts['family_member_details']='';
		$opts['appji_member_email']='';
		$updateData['family_member_details']= '';
		$updateData['appji_member_email']= '';

		if($orderItem->appji_member_name !='')
		{
			$opts['family_member_details'].= $orderItem->appji_member_name."\r\n";
			$updateData['family_member_details'].= $orderItem->appji_member_name."\r\n";
		}

		$opts['family_member_details'] .=$member_email;
		$opts['appji_member_email'] .=$member_email;
		$updateData['family_member_details'].= $member_email;
		$updateData['appji_member_email'].= $member_email;

		

		$updateData['options'] = serialize($opts);

		$this->db->where("id",$orderItem->order_item_id);
		$this->db->update("order_items",$updateData);
		$this->logaction->log($this->service,"Changed appji member email for Seva item:".$orderItem->order_item_id." - Seva ID:".$orderData['order']->id);
	}

	public function getTransactionReconciliationDataByPaymentGateWay()
	{
		$ashram_id  = $this->session->userdata("ashramId");
		$currency  = isset($_GET['currency']) ? $_GET['currency'] : "";
		$payment_mode  = isset($_GET['payment_mode']) ? $_GET['payment_mode'] : "";
		$tx_date  = isset($_GET['tx_date']) ? $_GET['tx_date'] : "";
		$order_type  = isset($_GET['order_type']) ? $_GET['order_type'] : "";
		$payment_status  = isset($_GET['payment_status']) ? $_GET['payment_status'] : "";
		$search_text  = isset($_GET['search_text']) ? $_GET['search_text'] : "";
		$search_col  = isset($_GET['search_col']) ? $_GET['search_col']: "";
		if($tx_date!="")
			$tx_date  = date("Y-m-d", strtotime($tx_date));
		// echo $currency;exit;
		$toBeReturnData = [];
		if(!$this->session->userdata("ashramId") || empty($_GET['currency']) || empty($_GET['payment_mode']) || empty($_GET['tx_date']))
		{
			goto end;
		}

		$query1=$this->db;
		$query1->select("tx as transaction_number,ashram_id,amount,currency,payment_mode,tx_order_date as seva_date,tx_order_number as seva_id,tx_order_total_price as seva_total_price, created_on as transaction_date");
		$query1->from("transaction");
		$query1->where("payment_mode",$payment_mode);
		$query1->where("date(created_on)",$tx_date);
		$query1->order_by("tx");
		$websiteTransactions = $query1->get()->result_array();
		

		$gatewayTransactions = [];
		$gatewayTable = "";
		if($payment_mode == 'razorpay')
		{
			$gatewayTable = $payment_mode."_webhook_".date("Y", strtotime($tx_date));
		}

		$this->archivesDb = $this->load->database("data_archives",true,false);
		if($gatewayTable !="" && $this->archivesDb->table_exists($gatewayTable) )
		{
			$this->archivesDb->select("transaction_id, amount, currency, created_on, status");
			$this->archivesDb->from($gatewayTable);
			$this->archivesDb->where("date(created_on)",$tx_date);
			$this->archivesDb->where("transaction_id!=","");
			$gatewayTransactions = $this->archivesDb->get()->result_array();
		}
		// echo '<pre>'; print_r($websiteTransactions); die();

		end:
		return $toBeReturnData;
	}

	function sendSubscriptionPaymentSuccessToAppjiServer($linkToken, $data)
	{
		$this->db->where("client_name","Appji");
		$appjiClientDetails = $this->db->get('app_clients')->row_array();
		if(isset($appjiClientDetails['client_id']) && isset($appjiClientDetails['client_base_url']) && $appjiClientDetails['client_base_url']!='')
		{
			$this->db->where("linkToken",$linkToken);
			$q=$this->db->get('appji_subscriptions_links');
			$linkTokenDetails=$q->row_array();
			if(count($linkTokenDetails)>0)
			{
				$serviceUrl = $appjiClientDetails['client_base_url']."/donation";
		        log_message('error', "**********Start of API Call to Appji Server for Subscription link token ".$linkTokenDetails['linkToken']." Payment Success************");
		        log_message('error', $serviceUrl." Time: ".date("Y-m-d H:i:s"));
		        $headers = [
		            'X-API-Key:' . $appjiClientDetails['client_request_api_key'],
		            'Content-Type: application/json'
		        ];

		        $postdata = [
					"orderId" => $linkTokenDetails['order_id'],
					"transactionId" => $linkTokenDetails['transaction_id'],
					"donationDate" => $linkTokenDetails['subscriptionDate'],
                    "donationCurrency" => strtoupper($linkTokenDetails['subscriptionCurrency']),
                    "donationAmount" => intval($linkTokenDetails['subscriptionAmount']),
					"appjiEmail" => $linkTokenDetails['appjiEmail'],
					"loginEmail" => $linkTokenDetails['paidUserEmail'],
					"paidUserName" => $linkTokenDetails['paidUserName'],
					"paidUserFullName" => $linkTokenDetails['paidUserFullName'],
					"linkToken" => $linkTokenDetails['linkToken'],
					"paymentStatus" => $linkTokenDetails['paymentStatus'],
					"timestamp" => strtotime($linkTokenDetails['paidOn'])
		        ];

		        $curl = curl_init();
		        curl_setopt_array($curl, array(
		            CURLOPT_URL => $serviceUrl,
		            CURLOPT_RETURNTRANSFER => true,
		            CURLOPT_ENCODING => '',
		            CURLOPT_TIMEOUT => 120,
		            CURLOPT_REFERER, $appjiClientDetails['client_base_url'],
		            CURLOPT_CUSTOMREQUEST => "POST",
		            CURLOPT_POSTFIELDS => json_encode($postdata),
		            CURLOPT_HTTPHEADER => $headers,
		            CURLOPT_FAILONERROR => true
		        ));
		        if (curl_errno($curl)) 
		        {
		            $error_msg = curl_error($curl);
		            log_message('error', print_r($error_msg, TRUE));
		        }
		        $response = curl_exec($curl);
		        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		        curl_close($curl);
		        log_message('error', print_r($response, TRUE));
		        log_message('error', print_r("HTTP Code: ".$httpcode, TRUE));
		        if($httpcode == 200)
		        {
		        	$this->db->where("linkToken",$linkToken);
					$this->db->update("appji_subscriptions_links",array('is_updated_in_appji' => 1));
		        }
		        log_message('error', "**********End of API Call");
			}
		}
	}


	function sendSubscriptionCancelToAppjiServerByItemId($itemId)
	{
		$this->db->where("client_name","Appji");
		$appjiClientDetails = $this->db->get('app_clients')->row_array();
		if(isset($appjiClientDetails['client_id']) && isset($appjiClientDetails['client_base_url']) && $appjiClientDetails['client_base_url']!='' && $itemId>0)
		{
			$this->db->where("order_item_id",$itemId);
			$q=$this->db->get('appji_subscriptions_links');
			$linkTokenDetails=$q->row_array();
			if(count($linkTokenDetails)>0)
			{
				$serviceUrl = $appjiClientDetails['client_base_url']."/subscription-cancelled";
		        log_message('error', "**********Start of API Call to Appji Server for Subscription Payment Cancelled************");
		        log_message('error', $serviceUrl." Time: ".date("Y-m-d H:i:s"));
		        $headers = [
		            'X-API-Key:' . $appjiClientDetails['client_request_api_key'],
		            'Content-Type: application/json'
		        ];

		        $postdata = [
					"orderId" => $linkTokenDetails['order_id'],
					"linkToken" => $linkTokenDetails['linkToken'],
					"paymentStatus" => $linkTokenDetails['paymentStatus'],
					"timestamp" => strtotime($linkTokenDetails['cancelledOn'])
		        ];

		        $curl = curl_init();
		        curl_setopt_array($curl, array(
		            CURLOPT_URL => $serviceUrl,
		            CURLOPT_RETURNTRANSFER => true,
		            CURLOPT_ENCODING => '',
		            CURLOPT_TIMEOUT => 120,
		            CURLOPT_REFERER, $appjiClientDetails['client_base_url'],
		            CURLOPT_CUSTOMREQUEST => "POST",
		            CURLOPT_POSTFIELDS => json_encode($postdata),
		            CURLOPT_HTTPHEADER => $headers,
		            CURLOPT_FAILONERROR => true
		        ));
		        if (curl_errno($curl)) 
		        {
		            $error_msg = curl_error($curl);
		            log_message('error', print_r($error_msg, TRUE));
		        }
		        $response = curl_exec($curl);
		        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		        curl_close($curl);
		        log_message('error', print_r($response, TRUE));
		        log_message('error', print_r("HTTP Code: ".$httpcode, TRUE));
		        if($httpcode == 200)
		        {
		        	$this->db->where("linkToken",$linkTokenDetails['linkToken']);
					$this->db->update("appji_subscriptions_links",array('is_cancelled_updated_in_appji' => 1));
		        }
		        log_message('error', "**********End of API Call");
			}
		}
	}



	public function triggerNotUpdatedPaidSubscriptionsUpdateToAppjiServer()
    {
        $q = $this->db->select("*")->from("appji_subscriptions_links")->where("is_updated_in_appji",'0')->where("paymentStatus","Paid")->get();
        if($q->num_rows() > 0)
        {
            $paid_subscriptions = $q->result_array();
            foreach ($paid_subscriptions as $paid_subscription) 
            {
            	$this->sendSubscriptionPaymentSuccessToAppjiServer($paid_subscription['linkToken'],array());
            }
        }
    }

    public function triggerNotUpdatedCancelledSubscriptionsUpdateToAppjiServer()
    {
        $q = $this->db->select("*")->from("appji_subscriptions_links")->where("is_cancelled_updated_in_appji",'0')->where("paymentStatus","Cancelled")->get();
        if($q->num_rows() > 0)
        {
            $cancelled_subscriptions = $q->result_array();
            foreach ($cancelled_subscriptions as $cancelled_subscription) 
            {
            	$this->sendSubscriptionCancelToAppjiServerByItemId($cancelled_subscription['order_item_id']);
            }
        }
    }

    public function triggerNotUpdatedPaidDonationsUpdateToAppjiServer()
    {
        $q = $this->db->select("*")->from("appji_donations_links")->where("is_updated_in_appji",'0')->where("paymentStatus","Paid")->get();
        if($q->num_rows() > 0)
        {
            $paid_donations = $q->result_array();
            foreach ($paid_donations as $paid_donation) 
            {
            	$this->sendDonationPaymentSuccessToAppjiServer($paid_donation['linkToken'],array());
            }
        }
    }


    public function generatePoornaphalaUniqueIdByOrderItemId($order_item_id=0)
    {
    	if($order_item_id>0)
    	{
    		$this->db->select("id,poornaphala_ids,poornaphala_end_dates");
	        $this->db->from("order_items");
	        $this->db->where("is_poornaphala_seva",1);
	        $this->db->where("id",$order_item_id);
	        $orderItem = $this->db->get()->row_array();
	        if(!empty($orderItem))
	        {
	        	$this->db->select("*");
		        $this->db->from("order_items_dates");
		        $this->db->where("order_item_id",$orderItem['id']);
		        $orderItemDates = $this->db->get()->result_array();
		        if(!empty($orderItemDates))
	        	{
	        		foreach($orderItemDates as $orderItemDate)
	        		{
		        		$tiedDate = date('Y-m-d', strtotime($orderItemDate['date']));
		        		$removePoornaphalaDate = date('Y-m-d', strtotime($tiedDate .' +15 days'));
		        		$monthOfTiedDate = date("m",strtotime($tiedDate));
			            $yearOfTiedDate = date("y",strtotime($tiedDate));
			            $financialYearOfTiedDate = '';
			            if($monthOfTiedDate>=4)
			            {
			                $financialYearOfTiedDate .= $yearOfTiedDate.($yearOfTiedDate+1);
			            }
			            else
			            {
			                $financialYearOfTiedDate .= ($yearOfTiedDate-1).$yearOfTiedDate;
			            }

			            $poornaphalaId = 100001;
			            $this->db->select_max('poornaphala_id');
			            $this->db->where('poornaphala_financial_year',$financialYearOfTiedDate);
						$max_poornaphala_result = $this->db->get('order_items_dates')->row();  
						if($max_poornaphala_result->poornaphala_id>0)
						{
							$poornaphalaId = ($max_poornaphala_result->poornaphala_id+1);
						}
						$poornaphalaNumber = $financialYearOfTiedDate."-".$poornaphalaId;
						if(isset($orderItemDate['poornaphala_id']) && $orderItemDate['poornaphala_id']<=0)
						{
							$updateData = array(
													"poornaphala_id" => $poornaphalaId,
													"poornaphala_end_date" => $removePoornaphalaDate,
													"poornaphala_financial_year" => $financialYearOfTiedDate,
													"poornaphala_number" => $poornaphalaNumber
												);
							$this->db->where("id",$orderItemDate['id']);
							$this->db->update("order_items_dates",$updateData);
						}
	        		}
		        }
		        $this->updatePoornaphalaIdsEndDatesToOrderItemsByOrderItemId($order_item_id);
	        }
    	}
    }


    public function updatePoornaphalaIdsEndDatesToOrderItemsByOrderItemId($order_item_id=0)
    {
    	if($order_item_id>0)
    	{
    		$this->db->select("*");
	        $this->db->from("order_items_dates");
	        $this->db->where("order_item_id",$order_item_id);
	        $orderItemDates = $this->db->get()->result_array();

	        $itemPoornaphalaEndDates = [];
    		$itemPoornaphalaIds = [];
    		if(!empty($orderItemDates))
        	{
        		foreach($orderItemDates as $orderItemDate)
        		{
        			$itemPoornaphalaIds[] = $orderItemDate['poornaphala_number'];
        			$itemPoornaphalaEndDates[] = $orderItemDate['poornaphala_end_date'];
        		}
        	}
        	$itemPoornaphalaEndDatesString = implode(",", $itemPoornaphalaEndDates);
    		$itemPoornaphalaIdsString = implode(",", $itemPoornaphalaIds);
    		$updateData = array(
								"poornaphala_end_dates" => $itemPoornaphalaEndDatesString,
								"poornaphala_ids" => $itemPoornaphalaIdsString
							);
    		$this->db->where("id",$order_item_id);
			$this->db->update("order_items",$updateData);
    	}

    }


    public function getOrderItemsDatesByOrderItemId($order_item_id=0)
    {
    	$toBeReturnData = [];
    	if($order_item_id>0)
    	{
    		$this->db->select("*");
	        $this->db->from("order_items_dates");
	        $this->db->where("order_item_id",$order_item_id);
	        $toBeReturnData = $this->db->get()->result_array();
    	}
    	return $toBeReturnData;
    }

    public function listAdminPoornaPhalaPoojaOrders($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$poojas=$this->poojas_model->getByAshramId($this->session->userdata("ashramId"));
			$poojasArray=array();
			foreach ($poojas as $poojaData)
			{
				$poojasArray[$poojaData->id]=$poojaData;
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$preData='';
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("oid.date as poornaphala_tied_date, oid.poornaphala_end_date, oid.poornaphala_number, o.id as order_id, o.order_number, oi.poornaphala_tie_by, o.user_id, o.username, o.firstname, o.middlename, o.lastname, o.email, o.phone, o.isd_code");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("oid.date as poornaphala_tied_date, oid.poornaphala_end_date, oid.poornaphala_number, o.id as order_id, o.order_number, oi.poornaphala_tie_by, o.user_id, o.username, o.firstname, o.middlename, o.lastname, o.email, o.phone, o.isd_code");
		}

		$preData.="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nPooja: ";
			if(isset($_POST['pooja_id']) && $_POST['pooja_id']!='')
			{
				$query1->where("oi.item_id",$_POST['pooja_id']);
				$preData.=$poojasArray[$_POST['pooja_id']]->pooja_name;
			}
			else
			{
				$preData.="All Poorna Phala Poojas";
			}
		}
		// $query1->from("order_items_dates as oid");
		// $query1->join("order_items as oi",'oi.id=oid.order_item_id', "left");
		// $query1->join("orders as o",'o.id=oid.order_id', "left");

		$query1->from("orders as o");
		$query1->join("order_items as oi",'oi.order_id=o.id', "left");
		$query1->join("order_items_dates as oid",'oid.order_item_id=oi.id', "left");
		$query1->where("o.order_type",1);
		$query1->where("o.payment_status!=",0);
		$query1->where("o.is_cancelled!=",1);
		$query1->where("oi.is_poornaphala_seva",1);
		$query1->group_by("oid.id");
		
		
		$fromDateTime='';
		$toDateTime='';
		$datesfilter='';

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$datesfilter.=" where DATE(oid.date)>='".date("Y-m-d",strtotime($_POST['from_date']))."' ";
			$fromDateTime=strtotime($_POST['from_date']);
			$query1->where("DATE(`oid`.`date`) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		else
		{
			if(!isset($_POST['to_date']) || $_POST['to_date']=='')
			{
				$datesfilter.=" where DATE(`oid`.`date`)>='".date("Y-m-d")."' ";
				$fromDateTime=time();
				$query1->where("DATE(`oid`.`date`) >=",date("Y-m-d"));
				$preData.=date("d M Y");

			}
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			if($datesfilter!='') $datesfilter.=" and ";
			else $datesfilter.=" where ";
			$datesfilter.="DATE(`oid`.`date`)<='".date("Y-m-d",strtotime($_POST['to_date']))."'";
			$query1->where("DATE(`oid`.`date`) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$toDateTime=strtotime($_POST['to_date']);
			$preData.=$_POST['to_date'];
		}
		else
		{
			if(!isset($_POST['from_date']) || $_POST['from_date']=='')
			{
				if($datesfilter!='') $datesfilter.=" and ";
				else $datesfilter.=" where ";
				$datesfilter.="DATE(`oid`.`date`)<='".date("Y-m-d")."'";
				$query1->where("DATE(`oid`.`date`) <=",date("Y-m-d"));
				$toDateTime=time();
				$preData.=date("d M Y");
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('oid.date',$_POST['dir']);
				else
					$query1->order_by('oid.date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/orders_model",$sql,$this->currentUser,"default",$_POST,"Pooja Sevas - Poorna Phala Report",$preData,13);
			return $requestResp;
		}



		if($i==1)
		{
			$temp_result = $query1->get();
			$rtn['recordsTotal'] = $temp_result->num_rows();
			$rtn['recordsFiltered'] = $temp_result->num_rows();
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('oid.date',$dir);
		}
		else
		{
			$query1->order_by('oid.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();


		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['poornaphala_tied_date']=date("d M Y",strtotime($rtn['data'][$c]['poornaphala_tied_date']));
			$rtn['data'][$c]['poornaphala_end_date']=date("d M Y",strtotime($rtn['data'][$c]['poornaphala_end_date']));

			$sno++;
			$c++;
		}
		$rtn['from_date']=$fromDateTime;
		$rtn['to_date']=$toDateTime;
		return $rtn;
	}


	private function poornaPhalaOrdersExcelReportAdmin($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;
		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PP Serial");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tied Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PP End Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PP Tied by");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Username");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date']);
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date']);
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->poornaphala_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->poornaphala_tied_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->poornaphala_end_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->poornaphala_tie_by);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->middlename." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$reportrow->isd_code." ".$reportrow->phone);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function orderDataByOrderNumber($order_number)
	{
		$this->db->where("order_number",$order_number);
		$q=$this->db->get($this->tableName);
		$result['order']=$q->row();
		$result['order_items']=array();
		$result['order_items_files']=array();
		if(isset($result['order']->order_number) && $result['order']->order_number!="")
		{
			$this->db->select("*,oi.id as id,oi.id as order_item_id,p.id as pet_id");
			$this->db->where("order_id",$result['order']->id);
			$this->db->from("order_items as oi");
			$this->db->join("pets as p","p.id=oi.pet_id","left");
			$items=$this->db->get();
			$result['order_items']=$items->result();

			$this->db->where("order_id",$result['order']->id);
			$items=$this->db->get("order_log");
			$result['order_log']=$items->result();

			$this->db->where("order_id",$result['order']->id);
			$items=$this->db->get("order_items_files");
			if($items->num_rows())
			{
				$result['order_items_files']=$items->result();
				foreach ($result['order_items_files'] as $fileData)
				{
					$this->db->where("file_id",$fileData->id);
					$tempD=$this->db->get("order_items_downloads")->result();
					$result['order_items_downloads'][$fileData->id]=$tempD;
				}
			}

			$this->db->where("order_id",$result['order']->id);
			$payflow_card=$this->db->get("subscription_profiles_payflow")->row();
			
			$this->db->where("order_id",$result['order']->id);
			$stripe_card=$this->db->get("stripe_subscriptions_payment_details")->row();
			$result['payflow_card']=$payflow_card;
			$result['stripe_card']=$stripe_card;
		}
		return $result;
	}

	public function sendOrderDetailsCustomSms($orderId)
	{
		$orderData=$this->orderData($orderId);
		$data['orderData']=$orderData;
		$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
		if(isset($orderData['order_items']) && !empty($orderData['order_items']))
		{
			$alreadyShowenItemIds = [];
			foreach ($orderData['order_items'] as $itemData)
	        {
	        	if(isset($itemData->custom_sms_text) && trim($itemData->custom_sms_text)!=""&& isset($itemData->item_id) && (!in_array($itemData->item_id, $alreadyShowenItemIds)))
	        	{
	        		array_push($alreadyShowenItemIds,$itemData->item_id);
	        		$message=
							$orderData['order']->ashram_name."\n\n".
							$itemData->item_name." : \n\n".
							$itemData->custom_sms_text
							;
					$this->sms->sendSMS(
											'payments_'.$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
											$data['countryData']->isd_code.$orderData['order']->phone,
											$message,
											1,
											$orderData['order']->user_id,
											$orderData['order']->username,
											$data['countryData']->isd_code
										);
        		}
        	}
		}
	}

	public function updateVishwashantiPadaYatraDonationOrderItems($order_id)
	{
		$toBeReturnArray = [];
		$this->db->select("GROUP_CONCAT(oi.item_id) as item_ids, oi.order_id,o.user_id, CONCAT(o.firstname,' ', o.lastname) as name");
		$this->db->where("oi.order_id",$order_id);
		$this->db->where_in('oi.item_id',vishwashantipadayatra2022_full_donation_ids);
		$this->db->from("order_items as oi");
		$this->db->join("orders as o","o.id=oi.order_id");
		$this->db->group_by("oi.order_id");
		$order_items=$this->db->get()->result_array();
		if(!empty($order_items))
		{
			$finalItemValuesArr = [];
			foreach($order_items as $orderItems)
			{
				$allItems = $orderItems['item_ids'];
				if($orderItems['item_ids']!='')
				{
					$orderItemsArr = explode(",", $orderItems['item_ids']);
					$donation_ids = vishwashantipadayatra2022_full_donation_ids;
					sort($orderItemsArr);
					$uniqueCount = count(array_unique(array_column($orderItemsArr, 'column_name')));
					$independentValues = array_count_values($orderItemsArr);
					$uniquePatterns = [];
					if(array_keys($independentValues) == $donation_ids)
					{
						$minValue = min($independentValues);
						for ($i=0; $i < $minValue; $i++)
						{
							$uniquePatterns[$i]=array();
							foreach ($independentValues as $key => $value)
							{	
								array_push($uniquePatterns[$i], $key);
								if (($key5 = array_search($key, $orderItemsArr)) !== false)
								{
								    unset($orderItemsArr[$key5]);
								}
							}
						}
					}
					if(!empty($uniquePatterns))
					{
						foreach($uniquePatterns as $key => $uniquePattern)
						{
							$itemIds = implode(",", $uniquePattern);
							$this->db->select("oi.family_member_details as family_details, oi.price as amount");
							$this->db->where("oi.order_id",$order_id);
							$this->db->where_in('oi.item_id',$uniquePattern);
							$this->db->from("order_items as oi");
							$this->db->group_by("oi.item_id");
							$itemResults=$this->db->get()->result_array();
							$totalAmount = 0;
							$itemFamilyMembers = "";
							if(!empty($itemResults))
							{
								foreach($itemResults as $thisItem)
								{
									if($thisItem['amount']>0)
									{
										$totalAmount = $totalAmount+$thisItem['amount'];
									}
									if($itemFamilyMembers!="")
										$itemFamilyMembers.="\r\n".$thisItem['family_details'];
									else
										$itemFamilyMembers.=$thisItem['family_details'];
								}
							}
							$itemFamilyMembers = str_replace("\r\n\r\n","\r\n",$itemFamilyMembers);
							$toBeReturnArray[] = [
													'order_id' => $orderItems['order_id'],
													'all_item_ids' => $allItems,
													'is_full_items_paid' => '1',
													'paid_full_item_ids' => $itemIds,
													'name' => $orderItems['name'],
													'user_id' => $orderItems['user_id'],
													'family_details' => $itemFamilyMembers,
													'amount' => $totalAmount,
												];
						}
					}
					if(!empty($orderItemsArr))
					{
						foreach($orderItemsArr as $key => $individualItem)
						{
							$this->db->select("oi.family_member_details as family_details, oi.price as amount");
							$this->db->where("oi.order_id",$order_id);
							$this->db->where_in('oi.item_id',$individualItem);
							$this->db->from("order_items as oi");
							$this->db->group_by("oi.order_id");
							$itemResults=$this->db->get()->row_array();
							$toBeReturnArray[] = [
													'order_id' => $orderItems['order_id'],
													'all_item_ids' => $allItems,
													'is_full_items_paid' => '0',
													'individual_item_id' => $individualItem,
													'name' => $orderItems['name'],
													'user_id' => $orderItems['user_id'],
													'family_details' => isset($itemResults['family_details']) ? $itemResults['family_details'] : '',
													'amount' => isset($itemResults['amount']) ? $itemResults['amount'] : 0,
												];
						}
					}
				}
			}
		}
		return $toBeReturnArray;
	}

	public function listDonationsSevaKartaForVishwashantiPadaYatraAllItemsReport()
	{
		$query1=$this->db;
		$query1->select("vpyo.*,o.currency,o.country_name,o.city");
		$query1->where("vpyo.is_full_items_paid",'1');
		$query1->where("o.is_cancelled!=",1);
		$query1->where("o.order_type",2);
		$query1->from("vishwashanti_pada_yatra_orders as vpyo");
		$query1->join("orders as o",'vpyo.order_id=o.id');
		$query1->where("o.payment_status!=",0);
		$query1->order_by("vpyo.family_details <> 'Sri Ganapathy Sachchidananda Swamiji'");
        $query1->order_by("vpyo.family_details <> 'Sri Datta Vijayananda Teertha Swamiji'");
		$query1->order_by('o.country_name','asc');
		$query1->order_by('o.city','asc');
		$query1->order_by('o.firstname','asc');
		$rtn['data']=$query1->get()->result_array();

		$rtn['inr_total_amount'] = 0;
		$rtn['usd_total_amount'] = 0;
		$c=0;
		$sno=1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_details']!='')
				$rtn['data'][$c]['family_details']=nl2br($row['family_details']);
			if(strtolower($row['currency'])=='inr' && $row['amount']>0)
				$rtn['inr_total_amount'] = $rtn['inr_total_amount'] + $row['amount'];
			if(strtolower($row['currency'])=='usd' && $row['amount']>0)
				$rtn['usd_total_amount'] = $rtn['usd_total_amount'] + $row['amount'];

			$sno++;
			$c++;
		}
		$rtn['total_rows']=$c;
		return $rtn;
	}

	public function listDonationsSevaKartaForVishwashantiPadaYatraSelectedItemReport($item_id)
	{
		$query1=$this->db;
		$query1->select("vpyo.*,o.currency,o.country_name,o.city");
		$query1->where("vpyo.is_full_items_paid",'0');
		$query1->where("o.is_cancelled!=",1);
		$query1->where("o.order_type",2);
		$query1->where("vpyo.individual_item_id",$item_id);
		$query1->from("vishwashanti_pada_yatra_orders as vpyo");
		$query1->join("orders as o",'vpyo.order_id=o.id');
		$query1->where("o.payment_status!=",0);
		$query1->order_by("vpyo.family_details <> 'Sri Ganapathy Sachchidananda Swamiji'");
        $query1->order_by("vpyo.family_details <> 'Sri Datta Vijayananda Teertha Swamiji'");
		$query1->order_by('o.country_name','asc');
		$query1->order_by('o.city','asc');
		$query1->order_by('o.firstname','asc');
		$rtn['data']=$query1->get()->result_array();

		$rtn['inr_total_amount'] = 0;
		$rtn['usd_total_amount'] = 0;
		$c=0;
		$sno=1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_details']!='')
				$rtn['data'][$c]['family_details']=nl2br($row['family_details']);
			if(strtolower($row['currency'])=='inr' && $row['amount']>0)
				$rtn['inr_total_amount'] = $rtn['inr_total_amount'] + $row['amount'];
			if(strtolower($row['currency'])=='usd' && $row['amount']>0)
				$rtn['usd_total_amount'] = $rtn['usd_total_amount'] + $row['amount'];

			$sno++;
			$c++;
		}
		$rtn['total_rows']=$c;
		return $rtn;
	}


	public function updateShodashaDattaKshetraPadaYatraDonationOrderItems($order_id)
	{
		$toBeReturnArray = [];
		$this->db->select("GROUP_CONCAT(oi.item_id) as item_ids, oi.order_id,o.user_id, CONCAT(o.firstname,' ', o.lastname) as name");
		$this->db->where("oi.order_id",$order_id);
		$this->db->where_in('oi.item_id',shodasha_datta_kshetra_pada_yatra_donation_ids);
		$this->db->from("order_items as oi");
		$this->db->join("orders as o","o.id=oi.order_id");
		$this->db->group_by("oi.order_id");
		$order_items=$this->db->get()->result_array();
		if(!empty($order_items))
		{
			$finalItemValuesArr = [];
			foreach($order_items as $orderItems)
			{
				$allItems = $orderItems['item_ids'];
				if($orderItems['item_ids']!='')
				{
					$orderItemsArr = explode(",", $orderItems['item_ids']);
					$donation_ids = shodasha_datta_kshetra_pada_yatra_donation_ids;
					sort($orderItemsArr);
					$uniqueCount = count(array_unique(array_column($orderItemsArr, 'column_name')));
					$independentValues = array_count_values($orderItemsArr);
					$uniquePatterns = [];
					if(array_keys($independentValues) == $donation_ids)
					{
						$minValue = min($independentValues);
						for ($i=0; $i < $minValue; $i++)
						{
							$uniquePatterns[$i]=array();
							foreach ($independentValues as $key => $value)
							{	
								array_push($uniquePatterns[$i], $key);
								if (($key5 = array_search($key, $orderItemsArr)) !== false)
								{
								    unset($orderItemsArr[$key5]);
								}
							}
						}
					}
					if(!empty($uniquePatterns))
					{
						foreach($uniquePatterns as $key => $uniquePattern)
						{
							$itemIds = implode(",", $uniquePattern);
							$this->db->select("oi.family_member_details as family_details, oi.price as amount");
							$this->db->where("oi.order_id",$order_id);
							$this->db->where_in('oi.item_id',$uniquePattern);
							$this->db->from("order_items as oi");
							$this->db->group_by("oi.item_id");
							$itemResults=$this->db->get()->result_array();
							$totalAmount = 0;
							$itemFamilyMembers = "";
							if(!empty($itemResults))
							{
								foreach($itemResults as $thisItem)
								{
									if($thisItem['amount']>0)
									{
										$totalAmount = $totalAmount+$thisItem['amount'];
									}
									if($itemFamilyMembers!="")
										$itemFamilyMembers.="\r\n".$thisItem['family_details'];
									else
										$itemFamilyMembers.=$thisItem['family_details'];
								}
							}
							$itemFamilyMembers = str_replace("\r\n\r\n","\r\n",$itemFamilyMembers);
							$toBeReturnArray[] = [
													'order_id' => $orderItems['order_id'],
													'all_item_ids' => $allItems,
													'is_full_items_paid' => '1',
													'paid_full_item_ids' => $itemIds,
													'name' => $orderItems['name'],
													'user_id' => $orderItems['user_id'],
													'family_details' => $itemFamilyMembers,
													'amount' => $totalAmount,
												];
						}
					}
					if(!empty($orderItemsArr))
					{
						foreach($orderItemsArr as $key => $individualItem)
						{
							$this->db->select("oi.family_member_details as family_details, oi.price as amount");
							$this->db->where("oi.order_id",$order_id);
							$this->db->where_in('oi.item_id',$individualItem);
							$this->db->from("order_items as oi");
							$this->db->group_by("oi.order_id");
							$itemResults=$this->db->get()->row_array();
							$toBeReturnArray[] = [
													'order_id' => $orderItems['order_id'],
													'all_item_ids' => $allItems,
													'is_full_items_paid' => '0',
													'individual_item_id' => $individualItem,
													'name' => $orderItems['name'],
													'user_id' => $orderItems['user_id'],
													'family_details' => isset($itemResults['family_details']) ? $itemResults['family_details'] : '',
													'amount' => isset($itemResults['amount']) ? $itemResults['amount'] : 0,
												];
						}
					}
				}
			}
		}
		return $toBeReturnArray;
	}

	public function listDonationsSevaKartaForVShodashaDattaKshetraPadaYatraAllItemsReport()
	{
		$query1=$this->db;
		$query1->select("sdkpyo.*,o.currency,o.country_name,o.city");
		$query1->where("sdkpyo.is_full_items_paid",'1');
		$query1->where("o.is_cancelled!=",1);
		$query1->where("o.order_type",2);
		$query1->from("shodasha_datta_kshetra_pada_yatra_orders as sdkpyo");
		$query1->join("orders as o",'sdkpyo.order_id=o.id');
		$query1->where("o.payment_status!=",0);
		$query1->order_by("sdkpyo.family_details <> 'Sri Ganapathy Sachchidananda Swamiji'");
        $query1->order_by("sdkpyo.family_details <> 'Sri Datta Vijayananda Teertha Swamiji'");
		$query1->order_by('o.country_name','asc');
		$query1->order_by('o.city','asc');
		$query1->order_by('o.firstname','asc');
		$rtn['data']=$query1->get()->result_array();

		$rtn['inr_total_amount'] = 0;
		$rtn['usd_total_amount'] = 0;
		$c=0;
		$sno=1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_details']!='')
				$rtn['data'][$c]['family_details']=nl2br($row['family_details']);
			if(strtolower($row['currency'])=='inr' && $row['amount']>0)
				$rtn['inr_total_amount'] = $rtn['inr_total_amount'] + $row['amount'];
			if(strtolower($row['currency'])=='usd' && $row['amount']>0)
				$rtn['usd_total_amount'] = $rtn['usd_total_amount'] + $row['amount'];

			$sno++;
			$c++;
		}
		$rtn['total_rows']=$c;
		return $rtn;
	}

	public function listDonationsSevaKartaForShodashaDattaKshetraPadaYatraSelectedItemReport($item_id)
	{
		$query1=$this->db;
		$query1->select("sdkpyo.*,o.currency,o.country_name,o.city");
		$query1->where("sdkpyo.is_full_items_paid",'0');
		$query1->where("o.is_cancelled!=",1);
		$query1->where("o.order_type",2);
		$query1->where("sdkpyo.individual_item_id",$item_id);
		$query1->from("shodasha_datta_kshetra_pada_yatra_orders as sdkpyo");
		$query1->join("orders as o",'sdkpyo.order_id=o.id');
		$query1->where("o.payment_status!=",0);
		$query1->order_by("sdkpyo.family_details <> 'Sri Ganapathy Sachchidananda Swamiji'");
        $query1->order_by("sdkpyo.family_details <> 'Sri Datta Vijayananda Teertha Swamiji'");
		$query1->order_by('o.country_name','asc');
		$query1->order_by('o.city','asc');
		$query1->order_by('o.firstname','asc');
		$rtn['data']=$query1->get()->result_array();

		$rtn['inr_total_amount'] = 0;
		$rtn['usd_total_amount'] = 0;
		$c=0;
		$sno=1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_details']!='')
				$rtn['data'][$c]['family_details']=nl2br($row['family_details']);
			if(strtolower($row['currency'])=='inr' && $row['amount']>0)
				$rtn['inr_total_amount'] = $rtn['inr_total_amount'] + $row['amount'];
			if(strtolower($row['currency'])=='usd' && $row['amount']>0)
				$rtn['usd_total_amount'] = $rtn['usd_total_amount'] + $row['amount'];

			$sno++;
			$c++;
		}
		$rtn['total_rows']=$c;
		return $rtn;
	}

	public function listDonationsSevaKartaForSelectedItemReport($item_id)
	{
		$query1=$this->db;
		$query1->select("oi.item_id,oi.order_id,o.user_id, CONCAT(o.firstname,' ', o.lastname) as name,o.currency,o.country_name,o.city,oi.price as amount, oi.family_member_details as family_details");
		$query1->where("o.is_cancelled!=",1);
		$query1->where("o.order_type",2);
		$query1->where("oi.item_id",$item_id);
		$query1->from("order_items as oi");
		$query1->join("orders as o",'oi.order_id=o.id');
		$query1->where("o.payment_status!=",0);
		$query1->order_by("oi.family_member_details <> 'Sri Ganapathy Sachchidananda Swamiji'");
        $query1->order_by("oi.family_member_details <> 'Sri Datta Vijayananda Teertha Swamiji'");
		$query1->order_by('o.country_name','asc');
		$query1->order_by('o.city','asc');
		$query1->order_by('o.firstname','asc');
		$rtn['data']=$query1->get()->result_array();

		$rtn['inr_total_amount'] = 0;
		$rtn['usd_total_amount'] = 0;
		$c=0;
		$sno=1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['family_details']='N/A';

			if($row['family_details']!='')
				$rtn['data'][$c]['family_details']=nl2br($row['family_details']);
				if(strtolower($row['currency'])=='inr' && $row['amount']>0)
				$rtn['inr_total_amount'] = $rtn['inr_total_amount'] + $row['amount'];
			if(strtolower($row['currency'])=='usd' && $row['amount']>0)
				$rtn['usd_total_amount'] = $rtn['usd_total_amount'] + $row['amount'];

			$sno++;
			$c++;
		}
		$rtn['total_rows']=$c;
		return $rtn;
	}

	private function poojasByDateExcelReportAdmin($excelData,$objPHPExcel)
	{	
		$countries=$this->locations_model->getCountries(true);
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data ?? "");
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;
		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pooja Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pooja Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pooja Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Paid Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refunded Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Failed Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cancelled Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Inprocess Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounced Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Attend Pooja in-person");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created by");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if(in_array(global_site_flag, [2]))
	    {
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poorna Phala Serial(s)");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poorna Phala Tying Date(s)");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poorna Phala End Date(s)");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Poorna Phala Tied by");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
	    }

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date'] ?? '');
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date'] ?? '');
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$txids = $reportrow->paid_tx_ids;

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date ?? '')));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date ?? '')));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date ?? '')));
			if($reportrow->username=='')
				$reportrow->username='Guest';
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_pan_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->family_member_details);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;

			if(isset($reportrow->zipcode)!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->pooja_date ?? '')));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->personal_note);
			if($reportrow->updated_quantity>0)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency ?? '')." ".$reportrow->updated_quantity*$reportrow->price);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency ?? '')." ".$reportrow->quantity*$reportrow->price);
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency ?? '')." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cancelled_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->inprocess_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			
			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->attend_pooja_in_person);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			$created_by='';
			if($reportrow->created_by==0)
                $created_by = 'Guest';
            if($reportrow->created_by==1)
                $created_by = 'Admin';
            if($reportrow->created_by==2)
                $created_by = 'User';
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$created_by);

            if(in_array(global_site_flag, [2]))
	    	{
	    		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->poornaphala_ids);
	    		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultPoojaDates);
	    		$resultPPendDates='';
	    		if($reportrow->is_poornaphala_seva ==1)
	    		{
					$PPEndDates=array_filter(explode(",",$reportrow->poornaphala_end_dates ?? ""));
					$resDates=array();
					foreach ($PPEndDates as $PPendDate)
					{
						$PPendDateTime=strtotime($PPendDate ?? '');
						if($fromDateTime!='')
						{
							if($fromDateTime<=$PPendDateTime && !in_array($PPendDate,$resDates))
							{
								$resDates[]=$PPendDate;
								if($resultPPendDates!='') $resultPPendDates.=', ';
								$resultPPendDates.=$PPendDate;
							}
						}
						if($toDateTime!='')
						{
							if($PPendDateTime<=$toDateTime && !in_array($PPendDate,$resDates))
							{
								$resDates[]=$PPendDate;
								if($resultPPendDates!='') $resultPPendDates.=', ';
								$resultPPendDates.=$PPendDate;
							}
						}
					}
				}
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resultPPendDates);
	    		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->poornaphala_tie_by);
	    	}


			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function donationsByDateExcelReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data ?? "");
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

 		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Family Details");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donation Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donation Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donation Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Paid Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refunded Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Failed Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cancelled Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Inprocess Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounced Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created By");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if($this->session->userdata("ashramId")==appji_ashram_id)
        {
        	$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Appji Member Email");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
        }

		$i=$j+1;
		$sno=1;
		$request_data=unserialize($excelData->request_data);

		$fromDateTime='';
		$toDateTime='';
		if(isset($request_data['from_date']) && $request_data['from_date']!='')
		{
			$fromDateTime=strtotime($request_data['from_date'] ?? '');
		}
		else
		{
			if(!isset($request_data['to_date']) || $request_data['to_date']=='')
			{
				$fromDateTime=time();
			}
		}
		
		if(isset($request_data['to_date']) && $request_data['to_date']!='')
		{
			$toDateTime=strtotime($request_data['to_date'] ?? '');
		}
		else
		{
			if(!isset($request_data['from_date']) || $request_data['from_date']=='')
			{
				$toDateTime=time();
			}
		}

		foreach ($q->result() as $reportrow)
		{
			$txids = $reportrow->paid_tx_ids;

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date ?? '')));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date ?? '')));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date ?? '')));
			if($reportrow->username=='')
				$reportrow->username='Guest';
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_pan_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->family_member_details);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;

			if(isset($reportrow->zipcode)!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}
			

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->donation_date ?? '')));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->personal_note);
			if($reportrow->updated_quantity>0)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency ?? '')." ".$reportrow->updated_quantity*$reportrow->price);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency ?? '')." ".$reportrow->quantity*$reportrow->price);
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency ?? '')." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cancelled_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->inprocess_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			
			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			$created_by='';
			if($reportrow->created_by==0)
                $created_by = 'Guest';
            if($reportrow->created_by==1)
                $created_by = 'Admin';
            if($reportrow->created_by==2)
                $created_by = 'User';
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$created_by);

            if($this->session->userdata("ashramId")==appji_ashram_id)
        	{
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_name);
        		$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->appji_member_email);
        	}

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

}
?>