<?PHP
class Japams_Model extends CI_Model 
{
	var $tableName="japams";
	var $siteServicesDB = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServicesDB = $this->load->database("site_services",true,false);
	}

	public function getCount()
	{
		$this->siteServicesDB->select('count(id) as c');
		$this->siteServicesDB->where_in('status',array(1));
		$q=$this->siteServicesDB->get($this->tableName)->row();
		return $q->c;
	}

	public function getJapaCount()
	{
		$this->siteServicesDB->select('sum(count) as c');
		$q=$this->siteServicesDB->get("japam_user")->row();
		return $q->c;
	}
	
	public function getJapams($user=0) 
	{
        if($user==1)
        {
	        $this->siteServicesDB->group_start();
	            $this->siteServicesDB->where("is_user",0);
	            $this->siteServicesDB->or_where("user_id",$this->currentUser->id);
	        $this->siteServicesDB->group_end();
	    }
	    else
	    {
	    	$this->siteServicesDB->where("is_user",0);
	    }

		$this->siteServicesDB->order_by("name","asc");
		$query = $this->siteServicesDB->get($this->tableName);
		return $query->result();
	}
	public function updateOrder($id,$value)
	{
		$this->siteServicesDB->where("id",$id);
		$this->siteServicesDB->update($this->tableName,array('order'=>$value));
	}
	public function getJapamsByToday()
	{
		$this->siteServicesDB->where("status",1);
		$this->siteServicesDB->where("start_date <=",date("Y:m:d"));
		$this->siteServicesDB->where("end_date >=",date("Y:m:d"));
		$this->siteServicesDB->order_by("order","asc");
		$query = $this->siteServicesDB->get($this->tableName);
		return $query->result();
	}
	public function getJapamsAdmin($user_id=0) 
	{
		if($user_id)
		{
			$this->siteServicesDB->where("is_user",0);
			$this->siteServicesDB->or_where("user_id",$user_id);
		}
		else
			$this->siteServicesDB->where("is_user",0);

		$this->siteServicesDB->order_by("name","asc");
		$query = $this->siteServicesDB->get($this->tableName);
		return $query->result();
	}
	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->siteServicesDB;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$query1->where("is_user",0);
				
		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->siteServicesDB->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDB->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDB->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServicesDB->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('name',$_POST['dir']);
				else
					$query1->order_by('name',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","japams/japams_model",$sql,$this->currentUser,"site_services",$_POST,"All Mantras",$preData);
			return $requestResp;

		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order',$dir);
		}
		else
		{
			$query1->order_by('order',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function listUser($excel=0)
	{
		$i=0;
		$query1=$this->siteServicesDB;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$query1->where("is_user",1);
		$query1->where("user_id",$this->currentUser->id);
				
		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->siteServicesDB->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDB->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDB->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServicesDB->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order',$dir);
		}
		else
		{
			$query1->order_by('order',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if(abs($rtn['data'][$c]['start_date']))
				$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			else
				$rtn['data'][$c]['start_date']='-';
			if(abs($rtn['data'][$c]['end_date']))
				$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			else
				$rtn['data'][$c]['end_date']='-';
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function mantraData($id)
	{
		$this->siteServicesDB->where("id",$id);
		$query = $this->siteServicesDB->get($this->tableName);
		return $query->row();
	}
	public function save($id,$mantraData,$user=0,$app=0)
	{
		$startDate='';
		$endDate='';
		if($this->input->post("start_date")!='')
			$startDate=date("Y:m:d",strtotime($this->input->post("start_date")));
		if($this->input->post("end_date")!='')
			$endDate=date("Y:m:d",strtotime($this->input->post("end_date")));

		if($id==0)
		{
			$query=$this->siteServicesDB->insert($this->tableName,
                                array(
                                	'name' =>$this->general_model->filtertext(trim($_POST['name'])),
									'mantra' =>$this->general_model->filtertext(trim($this->input->post("mantra"))),
									'description' =>$this->general_model->filtertext(trim($this->input->post("description"))),
									'start_date' =>$startDate,
									'end_date' =>$endDate
								)
								);
			$idd=$this->siteServicesDB->insert_id();
		}
		else
		{
			$this->siteServicesDB->where('id', $id);
			$query=$this->siteServicesDB->update($this->tableName,
                                array(
                                	'name' =>$this->general_model->filtertext(trim($_POST['name'])),
									'mantra' =>$this->general_model->filtertext(trim($this->input->post("mantra"))),
									'description' =>$this->general_model->filtertext(trim($this->input->post("description"))),
									'start_date' =>$startDate,
									'end_date' =>$endDate
								)
								);
				
			$idd=$id;
		}
		if($user==1)
		{
			$this->siteServicesDB->where("id",$idd);
			$this->siteServicesDB->update($this->tableName,array(
														'is_user'=>1,
														'user_id'=>$this->currentUser->id
													));	
		}

		if($id && $mantraData->image!='' && !isset($_POST['imgupl']))
		{
			$this->siteServicesDB->where("id",$id);
			$this->siteServicesDB->update($this->tableName,array('image'=>''));
			$path=aws_s3_base_url."images/mantra_images/".$mantraData->image;
			if(file_exists($path))
				unlink($path);
		}
		
		if($app==0)
		{
			if(isset($_FILES['mantra_image']))
			if($_FILES['mantra_image']['name']!='')
			{
				$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
                                            "secretKey"=>aws_s3_secret_key,
                                            "useSSL"=>false,
                                            "endpoint"=>"s3.amazonaws.com"));
				$this->load->helper('image');
				$name=$_FILES['mantra_image']['name'];
				$ext=pathinfo ($_FILES['mantra_image']['name'],PATHINFO_EXTENSION);		
				
				$dirPath=$_SERVER['DOCUMENT_ROOT']."/images/mantra_images/";
				if(!is_dir($dirPath))
				{
					mkdir($dirPath,0777);
				}
				$newName="mantra_".$idd."_".substr(md5(mt_rand()), 0, 16).".".$ext;
				$path=$dirPath.$newName;
				move_uploaded_file($_FILES['mantra_image']['tmp_name'],$path);
				$amazonUri="images/mantra_images/";
				$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newName,S3::ACL_PUBLIC_READ, array(), array());
				unlink($path);
				
				$this->siteServicesDB->where("id",$idd);
				$this->siteServicesDB->update($this->tableName,array('image'=>$newName));
				
			}
		}
		else
		{
			if($this->input->post("mantra_image")!='')
			{
				$dirPath=aws_s3_base_url."/images/mantra_images/";
				if(!is_dir($dirPath))
				{
					mkdir($dirPath,0777);
				}
				
				$temp_path=$this->general_model->base64ToImage($this->input->post("mantra_image"));
				$ext=pathinfo ($temp_path,PATHINFO_EXTENSION);

				$newName=$idd."_".time().".".$ext;
				$path=$dirPath.$newName;
				copy($temp_path,$path);
				$this->general_model->create_thumb_150($path,$path);
				$this->siteServicesDB->where("id",$idd);
				$this->siteServicesDB->update($this->tableName,array('image'=>$newName));
			}
		}

		if($query)
		{
			return $idd;
		}
		else return 0;
	}

	public function updateDonor($id,$donor_id,$donorData)
	{
		if(!empty($id) && !empty($donor_id) && !empty($donorData))
		{
			$this->siteServicesDB->where("id",$id);
			$this->siteServicesDB->update("japam_user",array("donor_id"=>$donor_id,"donor_name"=>$donorData->donor_name,"donor_relation"=>$donorData->donor_relation));
			return 1;
		}
	}

	public function updateJapaCount($id,$count)
	{
		if(!empty($id) && !empty($count))
		{
			$this->siteServicesDB->where("id",$id);
			$this->siteServicesDB->update("japam_user",array("count"=>$count));
			return 1;
		}
	}

	public function japaCountData($japa_count_id)
	{
		$this->siteServicesDB->select('id');
		$this->siteServicesDB->where('id',$japa_count_id);
		$q=$this->siteServicesDB->get("japam_user")->row();
		return $q;
	}

	public function deleteJapaCount($id)
	{
		$this->siteServicesDB->where("id",$id);
		$query = $this->siteServicesDB->delete("japam_user");
	}

	public function delete($id,$mantraData)
	{
		$this->siteServicesDB->where("japam_id",$id);
		$q1=$this->siteServicesDB->get("japam_user");
		if($q1->num_rows())
		{
			return 2;
		}
		$this->siteServicesDB->where("id",$id);
		$query = $this->siteServicesDB->delete($this->tableName);

		if($mantraData->image!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
                                            "secretKey"=>aws_s3_secret_key,
                                            "useSSL"=>false,
                                            "endpoint"=>"s3.amazonaws.com"));

			$path="images/mantra_images/".$mantraData->image;
			$this->s3->deleteObject(aws_s3_bucket_name,$path);
		}

		if($query) return 1;
		else return 0;
	}

	function changeStatus($id,$status)
	{
		$this->siteServicesDB->where("id",$id);
		$this->siteServicesDB->update($this->tableName,array("status"=>$status));
		return 1;
	}

	public function userCountSave() 
	{
		$uid=$this->currentUser->id;
		$userData=$this->users_model->userData($uid);
		$userJapamData = array();
		$japamids = null;
		foreach($_POST['count'] as $key => $value) 
		{
			$donorData = $this->donors_model->donorData($_POST["donor_id"][$key]);

			$city = "";
			if(!empty($donorData->city))
				$city = $donorData->city;
			if(!empty($userData->city))
				$city = $userData->city;

			$japamids = $japamids.",".$key;
			$mantraData=$this->mantraData($key);
			$dates = $_POST['dates'][0];

			$allow=0;
			if(strtotime($dates)>time())
			{
				continue;
			}

			if(abs($mantraData->start_date)!=0 && abs($mantraData->end_date)!=0)
			{
				if(strtotime($dates)>=strtotime($mantraData->start_date) && strtotime($dates)<=strtotime($mantraData->end_date))
				{
					$allow=1;
				}
			}
			else if(abs($mantraData->start_date)!=0 && abs($mantraData->end_date)==0)
			{
				if(strtotime($mantraData->start_date)<=strtotime($dates))
				{
					$allow=1;
				}
			}
			else if(abs($mantraData->start_date)==0 && abs($mantraData->end_date)!=0)
			{
				if(strtotime($mantraData->end_date)>=strtotime($dates))
				{
					$allow=1;
				}
			}
			else
			{
				$allow=1;
			}
			if(is_null($uid))
			{
			    $allow=0;
			}
			if($allow)
			{
				if(!empty($value[0]) && $value[0]!=0) 
				{
					$data = array(
						'count' => $value[0],
						'date' => $dates,
						'updated_on' =>date("Y:m:d H:i:s"),
						'japam_id' => $key,
						'donor_id'=>$_POST["donor_id"][$key],
						"donor_name"=>$donorData->donor_name,
						"donor_relation"=>$donorData->donor_relation,
						'user_id' => $uid,
						"username"=>$userData->username,
						"firstname"=>$userData->firstname,
						"lastname"=>$userData->lastname,
						"deleted"=>$userData->deleted,
						"user_status"=>$userData->status,
						"gender"=>$userData->gender,
						"country"=>$userData->country,
						"city"=>$city,
						"country_id"=>$userData->country_id,
						'year' => date("Y",strtotime($dates)),
						'month' => date("m",strtotime($dates))
					);
					array_push($userJapamData, $data);
				}
			}
		}
		if(!empty($userJapamData)) 
		{
			$this->siteServicesDB->insert_batch('japam_user', $userJapamData);
		}
	}

	public function getAdminJapams()
	{
		$this->siteServicesDB->from("japams");
        $this->siteServicesDB->group_start();
            $this->siteServicesDB->group_start();
                $this->siteServicesDB->where("start_date <=",date("Y:m:d"));
                $this->siteServicesDB->where("end_date >=",date("Y:m:d"));
            $this->siteServicesDB->group_end();
            $this->siteServicesDB->or_group_start();
                $this->siteServicesDB->where("start_date",'0000:00:00');
                $this->siteServicesDB->where("end_date",'0000:00:00');
            $this->siteServicesDB->group_end();

            $this->siteServicesDB->or_group_start();
                $this->siteServicesDB->where("start_date <=",date("Y:m:d"));
                $this->siteServicesDB->where("end_date",'0000:00:00');
            $this->siteServicesDB->group_end();

            $this->siteServicesDB->or_group_start();
                $this->siteServicesDB->where("start_date",'0000:00:00');
                $this->siteServicesDB->where("end_date >=",date("Y:m:d"));
            $this->siteServicesDB->group_end();
        $this->siteServicesDB->group_end();

        $this->siteServicesDB->group_start();
            $this->siteServicesDB->where("is_user",0);
        $this->siteServicesDB->group_end();

        $this->siteServicesDB->order_by("is_user","desc");
        $this->siteServicesDB->order_by("order","asc");
        $this->siteServicesDB->where("status",1);
        $q=$this->siteServicesDB->get();
        return $q;
	}

	public function getUserJapams()
	{
		$this->siteServicesDB->from("japams");
        $this->siteServicesDB->group_start();
            $this->siteServicesDB->group_start();
                $this->siteServicesDB->where("start_date <=",date("Y:m:d"));
                $this->siteServicesDB->where("end_date >=",date("Y:m:d"));
            $this->siteServicesDB->group_end();
            $this->siteServicesDB->or_group_start();
                $this->siteServicesDB->where("start_date",'0000:00:00');
                $this->siteServicesDB->where("end_date",'0000:00:00');
            $this->siteServicesDB->group_end();

            $this->siteServicesDB->or_group_start();
                $this->siteServicesDB->where("start_date <=",date("Y:m:d"));
                $this->siteServicesDB->where("end_date",'0000:00:00');
            $this->siteServicesDB->group_end();

            $this->siteServicesDB->or_group_start();
                $this->siteServicesDB->where("start_date",'0000:00:00');
                $this->siteServicesDB->where("end_date >=",date("Y:m:d"));
            $this->siteServicesDB->group_end();
        $this->siteServicesDB->group_end();

        $this->siteServicesDB->group_start();
            //$this->siteServicesDB->where("is_user",0);
            $this->siteServicesDB->where("user_id",$this->currentUser->id);
        $this->siteServicesDB->group_end();

        $this->siteServicesDB->order_by("is_user","desc");
        $this->siteServicesDB->order_by("order","asc");
        $this->siteServicesDB->where("status",1);
        $q=$this->siteServicesDB->get();
        return $q;
	}

	public function getUserJapamsbyDate($japa_id,$date,$user_id)
	{
		$this->siteServicesDB->from("japam_user");
        $this->siteServicesDB->where("japam_id",$japa_id);
        $this->siteServicesDB->where("date",$date);
        $this->siteServicesDB->where("user_id",$user_id);
        $res=$this->siteServicesDB->get();
        return $res;
	}

	public function userJapamsbyId($mantra_id,$userId)
	{
		$this->siteServicesDB->select("sum(count) as c");
        $this->siteServicesDB->from("japam_user");
        $this->siteServicesDB->where("japam_id",$mantra_id);
        $this->siteServicesDB->where("user_id",$userId);
        $utemp=$this->siteServicesDB->get();
        return $utemp;
	}
	public function usersingleCountSave($jid,$dates,$donor_id) 
	{
		$uid=$this->currentUser->id;
		$userData=$this->users_model->userData($uid);
		$mantraData=$this->mantraData($jid);

		$allow=0;
		if(strtotime($dates)>time())
		{
			return true;
		}
		$donorData = $this->donors_model->donorData($donor_id);

		$city = "";
		if(!empty($donorData->city))
			$city = $donorData->city;
		if(!empty($userData->city))
			$city = $userData->city;

		if(abs($mantraData->start_date)!=0 && abs($mantraData->end_date)!=0)
		{
			if(strtotime($dates)>=strtotime($mantraData->start_date) && strtotime($dates)<=strtotime($mantraData->end_date)
				&& isset($_POST['mantra_count']) && isset($_POST['mantra_count']))
			{
				$allow=1;
			}
		}
		else if(abs($mantraData->start_date)!=0 && abs($mantraData->end_date)==0)
		{
			if(strtotime($mantraData->start_date)<=strtotime($dates) && isset($_POST['mantra_count']) && isset($_POST['mantra_count']))
			{
				$allow=1;
			}
		}
		else if(abs($mantraData->start_date)==0 && abs($mantraData->end_date)!=0)
		{
			if(strtotime($mantraData->end_date)>=strtotime($dates) && isset($_POST['mantra_count']) && isset($_POST['mantra_count']))
			{
				$allow=1;
			}
		}
		else
		{
			$allow=1;
		}
		if($allow)
		{
			$count=0;
			
			if($_POST['mantra_count'])
				$count=abs(substr($_POST['mantra_count'],0,7));

			$this->siteServicesDB->insert('japam_user',
					array('count' => $count,
						'date' => $dates,
						'updated_on' =>date("Y:m:d H:i:s"),
						'japam_id' => $jid,
						'donor_id'=>$donor_id,
						"donor_name"=>$donorData->donor_name,
						"donor_relation"=>$donorData->donor_relation,
						'user_id' => $uid,
						"username"=>$userData->username,
						"firstname"=>$userData->firstname,
						"lastname"=>$userData->lastname,
						"deleted"=>$userData->deleted,
						"user_status"=>$userData->status,
						"gender"=>$userData->gender,
						"country"=>$userData->country,
						"city"=>$city,
						"country_id"=>$userData->country_id,
						'year' => date("Y",strtotime($dates)),
						'month' => date("m",strtotime($dates))
					)
					);
		}
	}

	public function getCountries()
	{
		$this->siteServicesDB->select("country_id,country");
		$this->siteServicesDB->where("count >",0);
		$this->siteServicesDB->where("country_id !=",'');
		$this->siteServicesDB->from("japam_user as j");
		$this->siteServicesDB->group_by("country_id");
		$q=$this->siteServicesDB->get();
		return $q->result();
	}
	public function userReport($excel=0)
	{
		$donorPreData = "";
		if(isset($_POST['donor_id']) && is_numeric($_POST['donor_id']))
		{
			$donorData = $this->donors_model->donorData($_POST['donor_id']);
			$donorPreData = $donorData->donor_name . " (" . $donorData->donor_relation . " )";
		}
		$japams=$this->getJapams(1);
		$japamsArray=array();
		foreach ($japams as $japamData)
		{
			$japamsArray[$japamData->id]=$japamData;
		}

		$i=0;
		$query1=$this->siteServicesDB;
		if($excel==0)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("japam_id")))
				$query1->select("ju.japam_id");
			else
				$query1->select("count(ju.japam_id) as c");
		}
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("japam_id")))
				$query1->select("*,sum(count) as count,ju.date as jdate");
			else
				$query1->select("*,ju.date as jdate");
		}
		$query1->where("ju.user_id",$this->currentUser->id);
		$query1->where("count >",0);
		$query1->from("japam_user as ju");
		$query1->join("japams as j","j.id=ju.japam_id",'inner');

		$preData="";
		$preData.="\nMantras:";
		if(isset($_POST['japam_id']) && is_numeric($_POST['japam_id']) && isset($japamsArray[$_POST['japam_id']]))
		{
			$query1->where("japam_id",$_POST['japam_id']);
			$preData.=" ".$japamsArray[$_POST['japam_id']]->name;
		}
		else
		{
			$preData.=" All Mantras";
		}

		$preData.="\nTotal By:";
		if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("japam_id")))
		{
			$query1->group_by($_POST['group_by']);
			if($_POST['group_by']=='japam_id')
			{
				$preData.="Mantra";
			}
		}

		$preData.="\nPerformed by:";
		if(isset($_POST['donor_id']) && is_numeric($_POST['donor_id']))
		{
			$query1->where("ju.donor_id",$_POST['donor_id']);
			$preData.= $donorPreData;
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("ju.date >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("ju.date <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}


		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('ju.date',$_POST['dir']);
				else
					$query1->order_by('ju.date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","japams/japams_model",$sql,$this->currentUser,"site_services",$_POST,"Japam Report",$preData);
			return $requestResp;
		}
		
		if($i==1)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("japam_id")))
				$temp_result = $query1->get()->num_rows();
			else
				$temp_result = $query1->get()->row()->c;
			$rtn['recordsTotal'] = $temp_result;
			$rtn['recordsFiltered'] = $temp_result;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('ju.date',$dir);
		}
		else
		{
			$query1->order_by('ju.date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();

		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("japam_id")))
			{
				$rtn['data'][$c]['jdate']='N/A';
				$rtn['data'][$c]['day']='N/A';
			}
			else
			{
				$rtn['data'][$c]['jdate']=date("d M Y",strtotime($rtn['data'][$c]['jdate']));
				$rtn['data'][$c]['day']=date("l",strtotime($rtn['data'][$c]['jdate']));
			}
			
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function adminReport($excel=0)
	{
		if($this->input->get("user_id")!='')
		{
			$japams=$this->getJapamsAdmin($this->input->get("user_id"));
		}
		else
			$japams=$this->getJapamsAdmin();

		$japamsArray=array();
		foreach ($japams as $japamData)
		{
			$japamsArray[$japamData->id]=$japamData;
		}

		$preData='';

		$i=0;
		$query1=$this->siteServicesDB;
		if($excel==0)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("j.user_id","japam_id","j.city","j.country_id")))
				$query1->select("j.japam_id");
			else			
				$query1->select("count(j.japam_id) as c");
		}
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("j.user_id","japam_id","j.city","j.country_id")))
				$query1->select("username,firstname,lastname,user_status as ustatus,deleted,sum(count) as count,j.date,japam_id,j.user_id,gender,country,name,donor_name,donor_id,donor_relation,city,count(j.id) as submissions");
			else
				$query1->select("username,firstname,lastname,user_status as ustatus,deleted,count,j.date,japam_id,j.user_id,gender,country,name,donor_name,donor_id,donor_relation,city");
		}

		$query1->where("count >",0);
		$query1->from("japam_user as j");
		$query1->join("japams as jj","jj.id=j.japam_id");

		if($this->input->get("user_id")!='')
		{
			$query1->where("j.user_id",$this->input->get("user_id"));
		}
		else
		{
			$query1->where("is_user",0);
		}

		$preData.="Total By:";
		if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("j.user_id","japam_id","j.city","j.country_id")))
		{
			$query1->group_by($_POST['group_by']);
			if($_POST['group_by']=='j.user_id')
			{
				$query1->group_by('japam_id');
			}
			if($_POST['group_by']=='j.user_id')
			{
				$preData.="User";
			}
			if($_POST['group_by']=='japam_id')
			{
				$preData.="Mantra";
			}
			if($_POST['group_by']=='j.city')
			{
				$query1->group_by('japam_id');
				$preData.="City";
			}
			if($_POST['group_by']=='j.country_id')
			{
				$query1->group_by('japam_id');
				$preData.="Country";
			}
		}

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nMantras:";
		if(isset($_POST['japam_id']) && is_numeric($_POST['japam_id']) && isset($japamsArray[$_POST['japam_id']]))
		{
			$query1->where("japam_id",$_POST['japam_id']);
			$preData.=" ".$japamsArray[$_POST['japam_id']]->name;
		}
		else
		{
			$preData.=" All Mantras";
		}

		$preData.="\nGender:";
		if(isset($_POST['gender']) && in_array($_POST['gender'],array("Male","Female","Others")))
		{
			$query1->where("gender",$_POST['gender']);
			$preData.=" ".$_POST['gender'];
		}
		else
		{
			$preData.=" All Gender";
		}

		$preData.="\nCountry:";
		if(isset($_POST['country_id']) && $_POST['country_id']!='')
		{
			$query1->where("country_id",$_POST['country_id']);
			$countryData=$this->locations_model->getCountryByCode($_POST['country_id']);
			$preData.=" ".$countryData->country_name;
		}
		else
		{
			$preData.=" All Countries";
		}

		$preData.="\nCity:";
		if(isset($_POST['search_city']) && $_POST['search_city']!='')
		{
			$query1->like("city",$_POST['search_city']);
			$preData.=" Contains ".$_POST['search_city'];
		}
		else
		{
			$preData.=" All Cities";
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("j.date >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("j.date <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
				{
					if($_POST['order_by'] == "donor_name")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("country",$_POST['dir']);
						$query1->order_by("city",$_POST['dir']);
					}
					else if($_POST['order_by'] == "country")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("city",$_POST['dir']);
						$query1->order_by("donor_name",$_POST['dir']);
					}
					else if($_POST['order_by'] == "city")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("country",$_POST['dir']);
						$query1->order_by("donor_name",$_POST['dir']);
					}
					else if($_POST['order_by'] == "count")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("country",$_POST['dir']);
						$query1->order_by("city",$_POST['dir']);
						$query1->order_by("donor_name",$_POST['dir']);
					}
					else
						$query1->order_by($_POST['order_by'],$_POST['dir']);
				}
				else
				{
					$query1->order_by($_POST['order_by'],'desc');
				}
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}

			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","japams/japams_model",$sql,$this->currentUser,"site_services",$_POST,"Mantra Japam Report",$preData,2);
			return $requestResp;
		}
		
		if($i==1)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("j.user_id","japam_id","j.city","j.country_id")))
			{
				$temp_result = $query1->get();
				$rtn['recordsTotal'] = $temp_result->num_rows();
				$rtn['recordsFiltered'] = $temp_result->num_rows();
			}
			else
			{
				$temp_result = $query1->get()->row();
				$rtn['recordsTotal'] = $temp_result->c;
				$rtn['recordsFiltered'] = $temp_result->c;
			}
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
			{
				if($col_name == "donor_name")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("city",$dir);
				}
				else if($col_name == "country")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("city",$dir);
					$query1->order_by("donor_name",$dir);
				}
				else if($col_name == "city")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("donor_name",$dir);
				}
				else if($col_name == "count")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("city",$dir);
					$query1->order_by("donor_name",$dir);
				}
				else
					$query1->order_by($col_name,$dir);
			}
			else
				$query1->order_by('date',$dir);
		}
		else
		{
			$query1->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();

		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("j.user_id","japam_id","j.city","j.country_id")))
			{
				$rtn['data'][$c]['date']='N/A';
			}
			else
			{
				$rtn['data'][$c]['submissions']=1;
				$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			}

			$rtn['data'][$c]['day']=date("l",strtotime($rtn['data'][$c]['date']));
			if(isset($_POST['group_by']) && $_POST['group_by']=="japam_id")
			{
				if($_POST["country_id"] == "" && $_POST["search_city"] == "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
					$rtn['data'][$c]['country']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] == "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['country']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] == "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] != "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['country']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] != "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['country']="N/A";
					$rtn['data'][$c]['gender']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] != "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] == "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
			}
			/*if(isset($_POST['group_by']) && $_POST['group_by']=="j.user_id")
			{
				if($_POST["country_id"] == "" && $_POST["search_city"] == "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['gender']="N/A";
					$rtn['data'][$c]['country']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] == "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['country']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] == "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['city']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] != "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['country']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] != "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['country']="N/A";
					$rtn['data'][$c]['gender']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] != "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['gender']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] == "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['city']="N/A";
				}
			}*/
			if(isset($_POST['group_by']) && $_POST['group_by']=="j.city")
			{
				if($_POST["country_id"] == "" && $_POST["search_city"] == "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] == "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] == "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] != "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] != "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] != "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] == "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
				}
			}
			if(isset($_POST['group_by']) && $_POST['group_by']=="j.country_id")
			{
				if($_POST["country_id"] == "" && $_POST["search_city"] == "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] == "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] == "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] != "" && $_POST["gender"] != "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
				}
				else if($_POST["country_id"] == "" && $_POST["search_city"] != "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] != "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
				}
				else if($_POST["country_id"] != "" && $_POST["search_city"] == "" && $_POST["gender"] == "")
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['gender']="N/A";
					$rtn['data'][$c]['city']="N/A";
				}
			}

			if(isset($_POST['search_col']) && $_POST["search_col"] != "")
			{
				$rtn['data'][$c]['username']=$rtn['data'][$c]['username'];
				$rtn['data'][$c]['firstname']=$rtn['data'][$c]['firstname'];
				$rtn['data'][$c]['lastname']=$rtn['data'][$c]['lastname'];
				$rtn['data'][$c]['gender']=$rtn['data'][$c]['gender'];
			}
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function checkName($name,$id)
	{
		$error=0;

		$this->siteServicesDB->where("name",$name);
		$this->siteServicesDB->where("id !=",$id);
		$q=$this->siteServicesDB->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}
		return $error;
	}

	public function excelReportUser($excelData,$objPHPExcel)
	{
		$japams=$this->getJapams();
		$japamsArray=array();
		foreach ($japams as $japamData)
		{
			$japamsArray[$japamData->id]=$japamData;
		}


		$q=$this->siteServicesDB->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$request_data=unserialize($excelData->request_data);

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S. No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Mantra Name");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Japam Count");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Performed by");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Day");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Date");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->count);

			$donor_name = "N/A";
			if(!empty($reportrow->donor_name) && !empty($reportrow->donor_relation) && !empty($reportrow->donor_id))
			{
				$donor_name = $reportrow->donor_name . " (" . $reportrow->donor_relation . " )";
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$donor_name);

			if(isset($request_data['group_by']) && $request_data['group_by']!='')
				$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,"N/A");
			else	
				$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,date("l",strtotime($reportrow->jdate)));

			if(isset($request_data['group_by']) && $request_data['group_by']!='')
				$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,"N/A");
			else	
				$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,date("d M Y",strtotime($reportrow->jdate)));
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->japamReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		$q=$this->siteServicesDB->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);

		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Mantra");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Start Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"End Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->mantra);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->description);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->start_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->end_date)));
			$status="Inactive";
			if($reportrow->status==1)
				$status="Active";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
				
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function japamReport($excelData,$objPHPExcel)
	{
		$japams=$this->getJapamsAdmin();
		$japamsArray=array();
		foreach ($japams as $japamData)
		{
			$japamsArray[$japamData->id]=$japamData;
		}


		$q=$this->siteServicesDB->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Mantra Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if(empty($requestData["group_by"]) ||  $requestData["group_by"] == "j.user_id")
		{
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Status");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		}

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Gender");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Japam Count");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Submissions Count");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Performed by");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);

			if(isset($requestData['group_by']) && $requestData['group_by']=='japam_id')
			{
				if($requestData["country_id"] == "" && $requestData["search_city"] == "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				}
				else if($requestData["country_id"] == "" && $requestData["search_city"] == "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] == "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] == "" && $requestData["search_city"] != "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				}
				else if($requestData["country_id"] == "" && $requestData["search_city"] != "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"NA");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] != "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] == "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				} else if($requestData["country_id"] != "" && $requestData["search_city"] != "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
			}
			else if(isset($requestData['group_by']) && $requestData['group_by']=="j.city")
			{
				if($requestData["country_id"] == "" && $requestData["search_city"] == "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] == "" && $requestData["search_city"] == "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] == "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] == "" && $requestData["search_city"] != "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] == "" && $requestData["search_city"] != "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] != "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] == "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] != "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
			}
			else if(isset($requestData['group_by']) && $requestData['group_by']=="j.country_id")
			{
				if($requestData["country_id"] == "" && $requestData["search_city"] == "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] == "" && $requestData["search_city"] == "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] == "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] == "" && $requestData["search_city"] != "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] == "" && $requestData["search_city"] != "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] != "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] == "" && $requestData["gender"] == "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
				else if($requestData["country_id"] != "" && $requestData["search_city"] != "" && $requestData["gender"] != "")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
				}
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
				if(empty($requestData["group_by"]) ||  $requestData["group_by"] == "j.user_id")
				{
					if($reportrow->deleted==0)
					{
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"Active");
					}
					else
					{
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"Deleted");
					}
				}
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gender);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
			}
			
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->count);

			if(isset($requestData['group_by']) && $requestData['group_by']!='')
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->submissions);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"1");
			}

			$donor_name = "N/A";
			if(!empty($reportrow->donor_name) && !empty($reportrow->donor_relation) && !empty($reportrow->donor_id))
			{
				$donor_name = $reportrow->donor_name;
			}

			if(isset($requestData['group_by']) && ($requestData['group_by']=='japam_id' || $requestData['group_by']=='j.user_id' || $requestData['group_by']=='j.city' || $requestData['group_by']=='j.country_id'))
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$donor_name);
			}
			
			if(isset($requestData['group_by']) && ($requestData['group_by']=='japam_id' || $requestData['group_by']=='j.user_id' || $requestData['group_by']=='j.city' || $requestData['group_by']=='j.country_id'))
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
				
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>