<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class General_newsletters_images_model extends CI_Model
{
	var $tableName="general_newsletter_images";
	public function __construct()
	{
		parent::__construct();
		$this->siteServicesDb = $this->load->database("site_services",true,false);
	}
	public function insert($data)
	{
		$this->siteServicesDb->insert($this->tableName,$data);
	}
	
	public function getImagesByNewsletterId($newsletterId,$multiple=false,$columns=array())
	{
		if(empty($columns))
			$this->siteServicesDb->select("*");
		else
			$this->siteServicesDb->select(implode(",", $columns));
		$this->siteServicesDb->from($this->tableName);
		if($multiple==true)
			$this->siteServicesDb->where_in("newsletter_id",$newsletterId);
		else
		$this->siteServicesDb->where("newsletter_id",$newsletterId);
		$q=$this->siteServicesDb->get();
		return $q->result();
	}
	public function deleteImage($newsletterId,$imageId)
	{
		$this->siteServicesDb->where(array("id"=>$imageId,"newsletter_id"=>$newsletterId));
		$query = $this->siteServicesDb->get($this->tableName);
		if($query->num_rows())
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$r=$query->row();
			$file=$r->filename;
			$amazonUri="content/general_newsletter/";
			$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri.$r->filename);

			$this->siteServicesDb->where(array("id"=>$imageId,"newsletter_id"=>$newsletterId));
			$this->siteServicesDb->delete($this->tableName);
			return 1;
		}
		else
			return 0;
	}
}
?>