<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Speeches_images_model extends CI_Model
{
	var $tableName="speeches_images";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function insert($data)
	{
		$this->siteServivcesDb->insert($this->tableName,$data);
	}

	public function deleteImages($id)
	{
		$this->siteServivcesDb->select("*");
		$this->siteServivcesDb->from($this->tableName);
		$this->siteServivcesDb->where("speech_id",$id);
		$q=$this->siteServivcesDb->get();
		foreach ($q->result() as $row)
		{
			$this->deleteImage($id,$row->id);
		}
	}
	
	public function getImagesBySpeechId($speechId,$multiple=false,$columns=array())
	{
		if(empty($columns))
			$this->siteServivcesDb->select("*");
		else
			$this->siteServivcesDb->select(implode(",", $columns));
		$this->siteServivcesDb->from($this->tableName);
		if($multiple==true)
			$this->siteServivcesDb->where_in("speech_id",$speechId);
		else
		$this->siteServivcesDb->where("speech_id",$speechId);
		$q=$this->siteServivcesDb->get();
		return $q->result();
	}

	public function deleteImage($speechId,$imageId)
	{
		$this->siteServivcesDb->where(array("id"=>$imageId,"speech_id"=>$speechId));
		$query = $this->siteServivcesDb->get($this->tableName);
		if($query->num_rows())
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$r=$query->row();
			$file=$r->filename;
			$amazonUri="content/speeches/".$speechId."/";
			$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri.$r->filename);

			$this->siteServivcesDb->where(array("id"=>$imageId,"speech_id"=>$speechId));
			$this->siteServivcesDb->delete($this->tableName);
			return 1;
		}
		else
			return 0;
	}
}
?>