<?PHP
class Releases_Model extends CI_Model 
{
	var $tableName="releases";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function releaseData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		$result=$q->row();
		return $result;
	}
	public function getYears()
	{
		$this->siteServivcesDb->select("year");
		$this->siteServivcesDb->group_by("year");
		$this->siteServivcesDb->order_by("year","desc");
		$q=$this->siteServivcesDb->get($this->tableName);
		$result['years']=array();
		foreach ($q->result() as $row)
		{
			if(!in_array($row->year,$result['years']))
			{
				$result['years'][]=$row->year;
			}
		}
		return $result;
	}

	public function listPublic()
	{
		$years=$this->getYears();
		//print_r($years);
		$i=0;

		$query1=$this->siteServivcesDb;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		
		$query1->from($this->tableName);

		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->group_start();
			$query1->like("name",$_POST['search_text']);
			$query1->or_like("description",$_POST['search_text']);
			$query1->group_end();
		}
		
		if(isset($_POST['type']) && in_array($_POST['type'],$this->types))
		{
			$query1->where("type",$_POST['type']);
		}

		if(isset($_POST['year']) && is_numeric($_POST['year']))
		{
			$query1->where("year",$_POST['year']);
		}
		else
		{
			if(count($years['years']))
				$query1->where("year",$years['years'][0]);
			else
				$query1->where("year",0);
		}
		
		$per_page=10;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("date","desc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();
		$colors=array("red","blue","orange","green","purple");
		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			if($ii==5)
				$ii=0;
			$rtn['res'][$key]->color=$colors[$ii];
			if($row->display_year==0)
				$rtn['res'][$key]->date=date("d M Y",strtotime($row->date));
			else
				$rtn['res'][$key]->date=date("Y",strtotime($row->date));
			$ii++;
		}

		return $rtn;
	}

	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nRelease Type: ";
		if(isset($_POST['type']) && in_array($_POST['type'],$this->types))
		{
			$query1->where("type",$_POST['type']);
			$preData.=$_POST['type'];
		}
		else
		{
			$preData.="All Types";
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}
		
		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/releases_model",$sql,$this->currentUser,"default",$_POST,"All Releases",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('date',$dir);
		}
		else
		{
			$query1->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id,$releaseData)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->delete($this->tableName);
		return 1;
	}
	public function save($id,$releaseData)
	{
		$markNew=0;
		if(isset($_POST['mark_new']))
			$markNew=1;
		$display_year=0;
		if(isset($_POST['display_year']))
			$display_year=1;

		if(!$id)
		{
			$q=$this->siteServivcesDb->insert($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'type'=>trim($_POST['type']),
									'date'=>date("Y:m:d",strtotime($_POST['date'])),
									'mark_new' => $markNew,
									'display_year' => $display_year,
									'year'=>date("Y",strtotime($_POST['date'])),
									'created_on'=>date("Y:m:d H:i:s"),
									'created_by'=>$this->currentUser->id
								)
								);
			$idd=$this->siteServivcesDb->insert_id();
		}
		else
		{
			
			$this->siteServivcesDb->where('id', $id);
			$q=$this->siteServivcesDb->update($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'type'=>trim($_POST['type']),
									'date'=>date("Y:m:d",strtotime($_POST['date'])),
									'mark_new' => $markNew,
									'display_year' => $display_year,
									'year'=>date("Y",strtotime($_POST['date'])),
									'modified_on'=>date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id
								)
								);
			$idd=$id;
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Release ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Release Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Release Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->type);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>