<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Page_images_model extends CI_Model
{
	var $tableName = "page_images";
	public function __construct()
	{
		parent::__construct();
		$this->siteServicesDb = $this->load->database("site_services",true,false);
	}
	public function insert($data)
	{
		$this->siteServicesDb->insert($this->tableName,$data);
	}
	
	public function getImagesByPageId($pageId,$multiple=false,$columns=array())
	{
		if(empty($columns))
			$this->siteServicesDb->select("*");
		else
			$this->siteServicesDb->select(implode(",", $columns));
		$this->siteServicesDb->from($this->tableName);
		if($multiple==true)
			$this->siteServicesDb->where_in("page_id",$pageId);
		else
		$this->siteServicesDb->where("page_id",$pageId);
		$q=$this->siteServicesDb->get();
		return $q->result();
	}
	public function deleteImage($pageId,$imageId)
	{
		$this->siteServicesDb->where(array("id"=>$imageId,"page_id"=>$pageId));
		$query = $this->siteServicesDb->get($this->tableName);
		if($query->num_rows())
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$r=$query->row();
			$file=$r->filename;
			$amazonUri="content/page_images/".$pageId."/";
			$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri.$r->filename);

			$this->siteServicesDb->where(array("id"=>$imageId,"page_id"=>$pageId));
			$this->siteServicesDb->delete($this->tableName);
			return 1;
		}
		else
			return 0;
	}
}
?>