<?PHP
class Mobile_apps_model extends CI_Model 
{
	var $tableName="mobile_apps";
	var $siteServivcesDb = "";
	var $pagesList=array();
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function refresh()
	{
		$appIds=array_filter(explode(",",apple_accounts));
		
		foreach ($appIds as $appId)
		{
			$apiurl="https://itunes.apple.com/lookup?id=".$appId."&entity=software";
			$json=file_get_contents($apiurl);
			$apps=json_decode($json);
			//$artistData=$apps->results[0];

			//unset($apps->results[0]);

			$subAppIds=array();
			foreach ($apps->results as $app)
			{
				if(!isset($app->trackName))
				{
					continue;
				}
				$subAppIds[]=$app->trackId;

				$this->siteServivcesDb->where("app_id",$app->trackId);
				$check=$this->siteServivcesDb->get($this->tableName);
				if($check->num_rows())
				{
					continue;
				}

				

				$data['thumb']=$app->artworkUrl100;
				$data['name']=$app->trackName;
				if(empty($app->features))
				{
					$data['platform']='1';
				}
				else
				{
					$data['platform']='1,2';
				}
				$data['account_name']=$app->artistName;
				$data['account_id']=$appId;
				$data['app_id']=$app->trackId;
				$data['url']=$app->trackViewUrl;
				$this->siteServivcesDb->insert($this->tableName,$data);
			}
			if(!empty($subAppIds))
			{
				$this->siteServivcesDb->where_not_in("app_id",$subAppIds);
				$this->siteServivcesDb->where("account_id",$appId);
				$this->siteServivcesDb->delete($this->tableName);
			}

		}
	}

	public function getApps($limit=0)
	{
		if($limit)
			$this->siteServivcesDb->limit($limit);
		$this->siteServivcesDb->order_by("order",'desc');
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}

	public function getAppsByAccId($accId)
	{
		$this->siteServivcesDb->where("account_id",$accId);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
}
?>