<?PHP
class Events_images_Model extends CI_Model 
{
	var $tableName="events_images";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function getImageByIds($eventIds)
	{
		$this->siteServivcesDb->select("id,event_id,filename,description,order,width,height");
		$this->siteServivcesDb->where_in("event_id",$eventIds);
		$this->siteServivcesDb->group_by('event_id');
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
	public function getImages($eventId)
	{
		$this->siteServivcesDb->select("id,event_id,filename,description,order,width,height");
		$this->siteServivcesDb->where("event_id",$eventId);
		$this->siteServivcesDb->order_by("order","asc");
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}

	public function imageData($id,$eventId)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->where("event_id",$eventId);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}

	public function uploadFile($eventData)
	{
		$fname=$_FILES['files']['name'][0];
		$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
		$newname='dattapeetham_event_'.$eventData['event']->id."_".substr(md5(mt_rand()), 0, 16).".".$ext;
		$tempPath=$_FILES['files']['tmp_name'][0];
		$tempName=basename($_FILES['files']['tmp_name'][0]);
		$thumbName="thumb_".$fname;
		$thumbPath=str_replace($tempName, $thumbName, $tempPath);
		$this->general_model->create_thumb_150($tempPath,$thumbPath);

		$this->load->helper("image");
		$image = new SimpleImage();
		$image->load($tempPath);
		$img_width=$image->getWidth();
    	$img_height=$image->getHeight();
    	$ratio=$img_width/$img_height;
      
		if($ratio>=1)
		{
			if($img_width>1000)
				$image->resizeToWidth(1000);
		}
		else
		{
			if($img_height>1000)
				$image->resizeToHeight(1000);
		}
		$image->save($tempPath);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$amazonUri="content/event_images/".$eventData['event']->id."/";
		$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
		$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUri."thumb_".$newname,S3::ACL_PUBLIC_READ, array(), array());

		list($iWidth,$iHeight) = getimagesize($tempPath);

		$this->siteServivcesDb->insert($this->tableName,
						array(
								"filename"=>$newname,
								'created_on'=>date("Y:m:d H:i:s"),
								'event_id'=>$eventData['event']->id,
								'width'=>$iWidth,
								'height'=>$iHeight
							));
		$data['fileid']=$this->siteServivcesDb->insert_id();
		$data['filename']=$newname;
		$data['title']=$fname;
		unlink($tempPath);
		unlink($thumbPath);
		return $data;
	}

	public function delete($eventData,$imageData)
	{
		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="content/event_images/".$eventData['event']->id."/".$imageData->filename;
		$amazonThumbUri="content/event_images/".$eventData['event']->id."/thumb_".$imageData->filename;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonThumbUri);
		$this->siteServivcesDb->where("id",$imageData->id);
		$this->siteServivcesDb->delete($this->tableName);
		return 1;
	}

	public function updateInfo($id,$colName,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array($colName=>$value));
	}
}
?>