<?PHP
class Event_attachments_model extends CI_Model 
{
	var $tableName="event_attachments";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function getAttachments($eventId)
	{
		$this->siteServivcesDb->select("id,event_id,filename,description,order,size,groupstring");
		$this->siteServivcesDb->where("event_id",$eventId);
		$this->siteServivcesDb->order_by("order","asc");
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}

	public function attachmentData($id,$eventId)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->where("event_id",$eventId);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}

	public function uploadFile($eventData)
	{
		$fname=$_FILES['files']['name'][0];
		$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
		$newname='dattapeetham_event_'.$eventData['event']->id."_".substr(md5(mt_rand()), 0, 16).".".$ext;
		$tempPath=$_FILES['files']['tmp_name'][0];
		$tempName=basename($_FILES['files']['tmp_name'][0]);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$amazonUri="content/event_attachments/".$eventData['event']->id."/";
		$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
		$fileSize=filesize($tempPath);
		$this->siteServivcesDb->insert($this->tableName,
						array(
								"filename"=>$newname,
								'created_on'=>date("Y:m:d H:i:s"),
								'event_id'=>$eventData['event']->id,
								'description'=>$fname,
								'size'=>$fileSize
							));
		$data['fileid']=$this->siteServivcesDb->insert_id();
		$data['filename']=$newname;
		$data['description']=$fname;
		return $data;
	}

	public function delete($eventData,$attachmentData)
	{
		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="content/event_attachments/".$eventData['event']->id."/".$attachmentData->filename;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
		$this->siteServivcesDb->where("id",$attachmentData->id);
		$this->siteServivcesDb->delete($this->tableName);
		return 1;
	}
	public function updateInfo($id,$colName,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array($colName=>$value));
	}
}
?>