<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Downloads_Model extends CI_Model 
{
	var $tableName="downloads";
	var $siteServivcesDb = "";
    function __construct() 
	{
   		parent::__construct();
   		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->siteServivcesDb->where('ashram_id',$this->currentUser->ashram_id);
		}
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}
	public function updateOrder($id,$value,$name)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array($name=>$value));
	}
	public function listPublic()
	{
		$i=0;

		$query1=$this->siteServivcesDb;
		
		$query1->select("count(d.id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("d.*,dc.name as category_name");
		}
		
		$query1->from($this->tableName . " AS d");
		$query1->join("downloads_categories as dc","dc.id = d.category","left");
		if(is_numeric($this->input->post('ashram_id')) && $this->input->post('ashram_id') != 0)
		{
			$query1->where("d.ashram_id",$this->input->post('ashram_id'));
		}
		if(is_numeric($this->input->post('satsang_id')) && $this->input->post('ashram_id') != 0)
		{
			$query1->where("d.satsang_id",$this->input->post('satsang_id'));
		}

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->like("d.description",$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
		}

		if(isset($_POST['category']) && is_numeric($this->input->post('category')))
		{
			$query1->where("d.category",$_POST['category']);
		}
		
		$per_page=50;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("d.description","asc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();
		$colors=array("red","blue","orange","green","purple");
		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			if($ii==5)
				$ii=0;
			$rtn['res'][$key]->color=$colors[$ii];
			$rtn['res'][$key]->size=$this->general_model->fileSizeConvert($row->size);
			
			if($rtn['res'][$key]->category_name)
				$rtn['res'][$key]->category_name = $rtn['res'][$key]->category_name;
			else
				$rtn['res'][$key]->category_name = "";

			$ii++;
		}
		$rtn['aws_s3_base_url']=aws_s3_base_url;

		return $rtn;
	}
	public function listAdmin($ashramId,$excel=0)
	{
		$ashramData=$this->ashrams_model->ashramData($ashramId);
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(d.id) as c");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			$query1->select("d.*,dc.name as category_name");
		}
		$query1->where("d.ashram_id",$ashramId);
		$query1->from($this->tableName . " AS d");
		$query1->join("downloads_categories as dc","dc.id = d.category","left");
		/*if($this->currentUser->roles!=1)
		{
			$query1->where("created_by",$this->currentUser->id);
		}*/

		if($ashramId)
			$preData="Ashram: ".$ashramData->name;
		else
			$preData="Ashram: N/A";

		$preData.="\nSearch Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		/*$preData.="\nCategory Name: ";*/
		if(isset($_POST['category_id']) && is_numeric($this->input->post('category_id')))
		{
			$query1->where("d.category",$_POST['category_id']);
			/*$catData = $this->downloads_categories_model->categoryData($_POST['category_id']);
			if($catData)
				$preData.='"'.$catData->name.'"';
			else
				$preData.='"N/A"';*/
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('filename',$_POST['dir']);
				else
					$query1->order_by('filename',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/downloads_model",$sql,$this->currentUser,"site_services",$_POST,"All Downloads",$preData);
			return $requestResp;
		}
		
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('filename',$dir);
		}
		else
		{
			$query1->order_by('filename',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['ashram_name'] = "N/A";
			if($rtn['data'][$c]['ashram_id'] > 0)
			{
				$rtn['data'][$c]['ashram_name'] = $ashramData->name;
			}
			if($rtn['data'][$c]['category_name'])
				$rtn['data'][$c]['category_name']=$rtn['data'][$c]['category_name'];
			else
				$rtn['data'][$c]['category_name']="";

			if($rtn['data'][$c]['order'])
				$rtn['data'][$c]['order']=$rtn['data'][$c]['order'];
			else
				$rtn['data'][$c]['order']="";

			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['size']=$this->general_model->fileSizeConvert($row['size']);
			$rtn['data'][$c]['aws_s3_base_url']=aws_s3_base_url;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	
	public function downloadData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}
	public function uploadFile()
	{
		$fname=$_FILES['files']['name'][0];
		$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
		$newname='dattapeetham_'.substr(md5(mt_rand()), 0, 16).".".$ext;
		$tempPath=$_FILES['files']['tmp_name'][0];
		$tempName=basename($_FILES['files']['tmp_name'][0]);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$amazonUri="content/downloads/";
		$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());

		$fileSize=filesize($tempPath);

		$ashram_id=$this->session->userdata('ashramId');
		if($this->currentUser->roles!=1)
		{
			if($this->currentUser->ashram_id)
				$ashram_id=$this->currentUser->ashram_id;
			else if($this->currentUser->satsang_id)
				$ashram_id=$this->currentUser->satsang_id;

		}

		$ashram_id = isset($ashram_id)?$ashram_id:0;

		$this->siteServivcesDb->insert($this->tableName,
						array(
								"filename"=>$newname,
								'description'=>$fname,
								'size'=>$fileSize,
								'created_by'=>$this->currentUser->id,
								'ashram_id'=>$ashram_id
							));
		$data['fileid']=$this->siteServivcesDb->insert_id();
		$data['filename']=$newname;
		$data['description']=$fname;
		return $data;
	}
	public function delete($downloadData)
	{
		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="content/downloads/".$downloadData->filename;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
		$this->siteServivcesDb->where("id",$downloadData->id);
		$this->siteServivcesDb->delete($this->tableName);

		return 1;
	}
	public function updateDescription($id,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array('description'=>$value));
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->pagesExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Category");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"File Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Download Link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"File Size");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);


		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$reportrow->ashram_name = "N/A";
			if($reportrow->ashram_id > 0)
			{
				$ashramData=$this->ashrams_model->ashramData($reportrow->ashram_id);
				$reportrow->ashram_name = $ashramData->name;
			}

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ashram_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->description);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->category_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->filename);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,aws_s3_base_url."content/downloads/".$reportrow->filename);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$this->general_model->fileSizeConvert($reportrow->size));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>