<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Checklist_Model extends CI_Model 
{
	var $tableName='checklists';
	var $siteServivcesDb = "";
	function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
    }
	
	public function listAjaxAdmin($excel=0)
	{
		$roles=$this->users_model->getRoles();
		$rolesArray=array();
		foreach ($roles as $rl)
		{
			$rolesArray[$rl->id]=$rl->role;
		}

		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nRole: ";
		if(isset($_POST['role']) && is_numeric($_POST['role']))
		{
			$query1->where("role",$_POST['role']);
			$preData.=$rolesArray[$_POST['role']];
		}
		else
		{
			$preData.="All Roles";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('topic',$_POST['dir']);
				else
					$query1->order_by('topic',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/checklist_model",$sql,$this->currentUser,"site_services",$_POST,"All Checklists",$preData);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('topic',$dir);
		}
		else
		{
			$query1->order_by('topic',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		$roles=$this->users_model->getRoles();
		$rolesArray=array();
		foreach ($roles as $rl)
		{
			$rolesArray[$rl->id]=$rl->role;
		}
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['role']=$rolesArray[$rtn['data'][$c]['role']];
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	public function listByRoles($rolesString='',$excel=0)
	{
		$roles=explode(",",$rolesString);
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$query1->where_in('role',$roles);
				
		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('topic',$_POST['dir']);
				else
					$query1->order_by('topic',"desc");
			}

			$requestResp=$this->excelexport_model->makeRequest($this->service,"model","checklist_model",$query1,$this->currentUser,"default",$_POST,"My Checklists",$preData);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('topic',$dir);
		}
		else
		{
			$query1->order_by('topic',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function checklistData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->row();
	}
	public function save($id)
	{
		if(!$id)
		{
			
			 $q=$this->siteServivcesDb->insert('checklists',
                                array('content' =>$this->general_model->filtertext(trim($_POST["content"])),
									'topic' =>$this->general_model->filtertext(trim($_POST["topic"])),
									'role' => $_POST["role"],
									'created_on' => date("Y:m:d H:i:s")
								)
								);
			$idd=$this->siteServivcesDb->insert_id();
			
			
		}
		else
		{
			$this->siteServivcesDb->where('id', $id);
			$q=$this->siteServivcesDb->update('checklists',
                                array('topic' =>$this->general_model->filtertext(trim($_POST["topic"])),
									'role' => $_POST["role"],
									'content' =>$this->general_model->filtertext(trim($_POST["content"]))
								)
								);
			$idd=$id;
		}
		if($q) return $idd;
		else return 0;
	}
	
	public function delete($id,$checklistData)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->delete($this->tableName);
		if($q)
			return 1;
		else
			 return 0;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$roles=$this->users_model->getRoles();
		$rolesArray=array();
		foreach ($roles as $rl)
		{
			$rolesArray[$rl->id]=$rl->role;
		}

		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Topic");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Role");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Content");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->topic);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$rolesArray[$reportrow->role]);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,utf8_decode(strip_tags($reportrow->content)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function excelReportUser($excelData,$objPHPExcel)
	{
		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Topic");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Content");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->topic);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,strip_tags($reportrow->content));
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>