<?PHP
class Articles_Model extends CI_Model 
{
	var $tableName="articles";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->siteServivcesDb->where('ashram_id',$this->currentUser->ashram_id);
		}
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}
	public function articleData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		$result=$q->row();
		return $result;
	}
	public function articleDataBySlug($slug)
	{
		$this->siteServivcesDb->where("slug",$slug);
		$query = $this->siteServivcesDb->get($this->tableName);
		return $query->row();
	}
	public function getChildren($id)
	{
		$this->siteServivcesDb->select("year,name,month,day,slug,published_on");
		$this->siteServivcesDb->where("parent_link",$id);
		$qc = $this->siteServivcesDb->get($this->tableName);
		return $qc->result();
	}
	public function getYearMonths()
	{
		$this->siteServivcesDb->select("year,month");
		$this->siteServivcesDb->group_by("year, month");
		$this->siteServivcesDb->order_by("year","desc");
		$this->siteServivcesDb->order_by("month","asc");
		$q=$this->siteServivcesDb->get($this->tableName);
		$result['years']=array();
		$result['months']=array();
		foreach ($q->result() as $row)
		{
			if(!in_array($row->year,$result['years']))
			{
				$result['years'][]=$row->year;
			}
			$result['months'][$row->year][]=$row->month;
		}
		return $result;
	}

	public function updateReadCount($articleId,$count)
	{
		$this->siteServivcesDb->where("id",$articleId);
		$this->siteServivcesDb->update($this->tableName,array("reads"=>$count));
	}

	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(published_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(published_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCategory: ";
		if(isset($_POST['category']) && is_numeric($_POST['category']))
		{
			$query1->where("FIND_IN_SET(".$_POST['category'].",categories) >",0);
			$preData.=$this->categories_model->categoriesList['categories'][$_POST['category']]->category;
		}
		else
		{
			$preData.="All Categories";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('published_on',$_POST['dir']);
				else
					$query1->order_by('published_on',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","content/articles_model",$sql,$this->currentUser,"site_services",$_POST,"All Articles",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('published_on',$dir);
		}
		else
		{
			$query1->order_by('published_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['published_on']=date("d M Y",strtotime($rtn['data'][$c]['published_on']));
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function delete($id,$articleData)
	{
		$this->articles_images_model->deleteImages($id);

		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->delete($this->tableName);

		//Delete Categories
		$this->articles_category_model->remove($id);
		return 1;
	}

	public function save($id,$articleData)
	{
		$oldCats=array();
		$newCats=array();

		if(isset($_POST['categories']))
			$newCats=$_POST['categories'];

		$categories=implode(",",$newCats);

		$parentId=0;

		if(isset($_POST['parent_id']) && is_numeric($_POST['parent_id']))
			$parentId=$_POST['parent_id'];

		$articleSlug=strtolower(url_title($this->general_model->filtertext(trim($_POST["name"]))));

		$publishDate=date("Y:m:d",strtotime($_POST['published_on']));
		$cnt=0;
		while(1)
		{
			$this->siteServivcesDb->where("slug",$articleSlug);
			$this->siteServivcesDb->where("id !=",$id);
			$this->siteServivcesDb->where("date(published_on)",$publishDate);
			$chk=$this->siteServivcesDb->get($this->tableName);
			if($chk->num_rows())
			{
				$cnt++;
				$articleSlug=$articleSlug."-".$cnt;
				continue;
			}
			else
			break;
		}


		if(!$id)
		{
			$q=$this->siteServivcesDb->insert($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                                	'slug'=>$articleSlug,
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'published_on' => date("Y:m:d 00:00:00",strtotime($_POST["published_on"])),
									'seo_keywords' => $this->general_model->filtertext(trim($_POST["seo_keywords"])),
									'seo_description' => $this->general_model->filtertext(trim($_POST["seo_description"])),
									'year'=>date("Y",strtotime($_POST["published_on"])),
									'month'=>abs(date("m",strtotime($_POST["published_on"]))),
									'day'=>abs(date("d",strtotime($_POST["published_on"]))),
									'categories'=>$categories,
									'parent_link'=>$parentId,
									'created_on'=>date("Y:m:d H:i:s"),
									'created_by'=>$this->currentUser->id
								)
								);
			$idd=$this->siteServivcesDb->insert_id();
		}
		else
		{
			
			$this->siteServivcesDb->where('id', $id);
			$q=$this->siteServivcesDb->update($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                                	'slug'=>$articleSlug,
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'published_on' => date("Y:m:d 00:00:00",strtotime($_POST["published_on"])),
									'seo_keywords' => $this->general_model->filtertext(trim($_POST["seo_keywords"])),
									'seo_description' => $this->general_model->filtertext(trim($_POST["seo_description"])),
									'year'=>date("Y",strtotime($_POST["published_on"])),
									'month'=>abs(date("m",strtotime($_POST["published_on"]))),
									'day'=>abs(date("d",strtotime($_POST["published_on"]))),
									'categories'=>$categories,
									'parent_link'=>$parentId,
									'modified_on'=>date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id
								)
								);
			$idd=$id;
		}

		if($id)
		{
			$oldCats=array_filter(explode(",",$articleData->categories));
			$catsToBeDeleted=array_diff($oldCats,$newCats);
			if(!empty($catsToBeDeleted))
				$this->articles_category_model->remove($idd,$catsToBeDeleted);
		}
		$catsToBeInserted=array_diff($newCats,$oldCats);
		if(!empty($catsToBeInserted))
			$this->articles_category_model->insert($idd,$catsToBeInserted);


		//Content Images
		$articleId=$idd;
		$this->load->helper("simple_html_dom");
		$dom=new simple_html_dom();
		$tempContent=trim($_POST['description']);
		$contentDom=$dom->load($tempContent);
		$images=$contentDom->find('img');
		if(count($images))
		{
			if($articleId)
			{
				$existingImages=$this->articles_images_model->getImagesByArticleId($articleId);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$eArray[$eimage->filename]=$eimage->id;
				}
				$editorImages=[];
				foreach ($images as $img_dom) 
				{
					$pathText=$img_dom->attr['src'];
					if(preg_match('/amazon/i',$pathText))
					{
						$editorImages[basename($pathText)]=basename($pathText);
					}
				}
				$diff=array_diff_key($eArray,$editorImages);

				if(count($diff))
				{
					foreach($diff as $ikey)
					$this->articles_images_model->deleteImage($articleId,$ikey);
				}

			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="content/articles/".$articleId."/";
			foreach ($images as $img_dom) 
			{
				$pathText=$img_dom->attr['src'];
				if(preg_match('/amazon/i',$pathText))
					continue;

				$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
				if(file_exists($path))
				{
					$fname=basename($path);
					$newFileName=$articleId."_".$fname;
					$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
					$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
					unlink($path);

					$imageData=array('filename' => $newFileName,
									'article_id' =>$articleId
									);
					$this->articles_images_model->insert($imageData);
				}
			}
			$this->siteServivcesDb->where("id",$articleId);
			$this->siteServivcesDb->update($this->tableName,array("description"=>$tempContent));
		}
		else
		{
			$existingImages=$this->articles_images_model->getImagesByArticleId($articleId);
			$eArray=[];
			foreach ($existingImages as $eimage)
			{
				$this->articles_images_model->deleteImage($articleId,$eimage->id);
			}
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function checkArticleName($name,$id)
	{
		$error=0;

		$slug=url_title($name);

		$this->siteServivcesDb->where("name",$name);
		$this->siteServivcesDb->where("id !=",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}
	public function listPublicByCategory($categoryId)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("categories,name,published_on,slug,year,month,day");
		}
		$query1->from($this->tableName);

		if($categoryId)
			$query1->where("FIND_IN_SET(".$categoryId.",categories) >",0);

		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->group_start();
			$query1->like("name",$_POST['search_text']);
			$query1->or_like("description",$_POST['search_text']);
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('published_on',"desc");

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function listPublic()
	{
		$i=0;

		$query1=$this->siteServivcesDb;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		
		$query1->from($this->tableName);

		if(isset($_POST['month']) && is_numeric($_POST['month']) && in_array($_POST['month'],array(1,2,3,4,5,6,7,8,9,10,11,12)))
		{
			$query1->where("month",trim($_POST['month']));
		}

		if(isset($_POST['year']) && is_numeric($_POST['year']))
		{
			$query1->where("year",trim($_POST['year']));
		}
		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->group_start();
			$query1->like("name",$_POST['search_text']);
			$query1->or_like("description",$_POST['search_text']);
			$query1->group_end();
		}
		
		$per_page=10;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("published_on","desc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();
		$colors=array("red","blue","orange","green","purple");
		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			if($ii==5)
				$ii=0;
			$rtn['res'][$key]->published_on=date("d M Y",strtotime($rtn['res'][$key]->published_on));
			$rtn['res'][$key]->color=$colors[$ii];
			$rtn['res'][$key]->description=strip_tags($rtn['res'][$key]->description);
			$ii++;
		}


		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Article ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Article Title");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Article Link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Categories");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Publish Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SEO Keywords");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"SEO Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Views");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url."articles/".$reportrow->year."/".$reportrow->month."/".$reportrow->day."/".$reportrow->slug);

			$cats=array_filter(explode(",",$reportrow->categories));
			$catString='';
			foreach ($cats as $catId)
			{
				if($catString!='') $catString.=", ";

				$catString.=$this->categories_model->categoriesList['categories'][$catId]->category;
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$catString);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->published_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->seo_keywords);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->seo_description);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->reads);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>