<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Articles_images_model extends CI_Model
{
	var $tableName="articles_images";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function insert($data)
	{
		$this->siteServivcesDb->insert($this->tableName,$data);
	}

	public function deleteImages($id)
	{
		$this->siteServivcesDb->select("*");
		$this->siteServivcesDb->from($this->tableName);
		$this->siteServivcesDb->where("article_id",$id);
		$q=$this->siteServivcesDb->get();
		foreach ($q->result() as $row)
		{
			$this->deleteImage($id,$row->id);
		}
	}
	
	public function getImagesByArticleId($articleId,$multiple=false,$columns=array())
	{
		if(empty($columns))
			$this->siteServivcesDb->select("*");
		else
			$this->siteServivcesDb->select(implode(",", $columns));
		$this->siteServivcesDb->from($this->tableName);
		if($multiple==true)
			$this->siteServivcesDb->where_in("article_id",$articleId);
		else
		$this->siteServivcesDb->where("article_id",$articleId);
		$q=$this->siteServivcesDb->get();
		return $q->result();
	}

	public function deleteImage($articleId,$imageId)
	{
		$this->siteServivcesDb->where(array("id"=>$imageId,"article_id"=>$articleId));
		$query = $this->siteServivcesDb->get($this->tableName);
		if($query->num_rows())
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$r=$query->row();
			$file=$r->filename;
			$amazonUri="content/articles/".$articleId."/";
			$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri.$r->filename);

			$this->siteServivcesDb->where(array("id"=>$imageId,"article_id"=>$articleId));
			$this->siteServivcesDb->delete($this->tableName);
			return 1;
		}
		else
			return 0;
	}
}
?>