<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Categories_model extends CI_Model
{
	var $tableName="categories";
	var $temp=array();
	var $categoriesList=array();
	var $objPHPExcel='';
	public $sorted=array();
	public function __construct()
	{
		parent::__construct();
	}
	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->db->where('ashram_id',$this->currentUser->ashram_id);
		}
		return $this->db->get($this->tableName)->num_rows();
	}
	public function fetchCategories($flag=0,$ashram_id=0)
	{
		$this->db->select("id, category, parent , order, ashram_id, slug, description");
		$this->db->order_by("parent, order, category");
		/*if($public==0 && $this->currentUser->roles!=1)
		{
			$this->db->where("created_by",$this->currentUser->id);
		}*/
		if($ashram_id)
		{
			$this->db->where("ashram_id",$ashram_id);
		}
		else
		{
			$this->db->where("ashram_id",default_ashram_id);
			$this->db->where("satsang_id",0);
		}
		if($flag>0)
		{
			$this->db->where("type",$flag);
		}
		$q=$this->db->get($this->tableName);

        $this->categoriesList = array(
            'categories' => array(),
            'parent_cats' => array()
        );
 
        //build the array lists with data from the category table
        foreach ($q->result() as $row) 
        {
        	if($flag==1)
        	{
        		$row->parent=0;
        	}
            //creates entry into categories array with current category id ie. $categories['categories'][1]
            $this->categoriesList['categories'][$row->id] = $row;
            $this->categoriesList['categories'][$row->slug] = $row;
            //creates entry into parent_cats array. parent_cats array contains a list of all categories with children
            $this->categoriesList['parent_cats'][$row->parent][] = $row->id;
        }
	}
	public function export()
	{
		$preData='';
		$this->db->select("*");
		$this->db->from($this->tableName);
		$sql=$this->db->get_compiled_select();

		$requestResp=$this->excel_exports_model->makeRequest('default',"model","category/categories_model",$sql,$this->currentUser,"default",$_POST,"All Categories",$preData);
		return $requestResp;
		/*$requestResp=$this->excelexport_model->makeRequest($serviceSlug,"categories",$this->linkData[$serviceSlug]['main_model'],$this->db,$this->currentUser,$serviceSlug,array(),$this->linkData[$serviceSlug]['titlepart']." - All Categories",'');*/
		return $requestResp;
	}
	public function excelReport($excelData,$objPHPExcel)
	{
		$ashram_id=$this->session->userdata("ashramId");
		if($this->currentUser->roles!=1)
		{
			if($this->currentUser->ashram_id)
				$ashram_id=$this->currentUser->ashram_id;
		}
		$this->fetchCategories(0,$ashram_id);
		$objPHPExcel=$objPHPExcel;

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$objPHPExcel->getActiveSheet()->SetCellValue('A3',"Total Records: ".(count($this->categoriesList['categories'])/2));

		$j=5;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Category ID");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Ashram");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Category Name");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Category Slug");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Category Description");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$j++;
		$this->excelData=array();
		$this->buildCategoryExcel(0,1);

		foreach ($this->excelData as $key => $eData)
		{
			$eData['ashram_name'] = "N/A";
			if($ashram_id > 0)
			{
				$ashramData=$this->ashrams_model->ashramData($ashram_id);
				$eData['ashram_name'] = $ashramData->name;
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,($key+1));
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,$eData['id']);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,$eData['ashram_name']);
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,$eData['category']);
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,$eData['slug']);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,$eData['description']);
			$j++;
		}
		return $objPHPExcel;
	}
	function buildCategoryExcel($parent,$level)
	{
        if (isset($this->categoriesList['parent_cats'][$parent]))
        {
            foreach ($this->categoriesList['parent_cats'][$parent] as $cat_id)
            {
            	$display=1;
            	$selected='';
            	
            	if($display==1)
            	{
            		$value=$this->categoriesList['categories'][$cat_id]->id;
            		$catData['id']=$value;
	            	$catData['category']=str_repeat("- ",$level-1)." ".$this->categoriesList['categories'][$cat_id]->category;
	            	$catData['description']=$this->categoriesList['categories'][$cat_id]->description;
	            	$catData['slug']=$this->categoriesList['categories'][$cat_id]->slug;
	            	$this->excelData[]=$catData;
            	}
                if (isset($this->categoriesList['parent_cats'][$cat_id])) 
                {
	                $nl=$level+1;
	                $this->buildCategoryExcel($cat_id,$nl);
            	}
            }
        }
    }

    function sorted($parent,$level)
    {
    	if (isset($this->categoriesList['parent_cats'][$parent]))
        {
            foreach ($this->categoriesList['parent_cats'][$parent] as $cat_id)
            {
            	$display=1;
            	$selected='';
            	
            	if($display==1)
            	{
            		$value=$this->categoriesList['categories'][$cat_id]->id;
            		$catData['id']=$value;
	            	$catData['category']=str_repeat("- ",$level-1)." ".$this->categoriesList['categories'][$cat_id]->category;
	            	$catData['description']=$this->categoriesList['categories'][$cat_id]->description;
	            	$catData['slug']=$this->categoriesList['categories'][$cat_id]->slug;
	            	$this->sorted[]=$catData;
            	}
                if (isset($this->categoriesList['parent_cats'][$cat_id])) 
                {
	                $nl=$level+1;
	                $this->sorted($cat_id,$nl);
            	}
            }
        }
    }

	function buildCategoryDropdown($parent,$level,$currentID=0,$selectCurrentCategory=false,$categoryCount=array(),$valueType='id',$showCount=true)
	{
        if (isset($this->categoriesList['parent_cats'][$parent]))
        {
            foreach ($this->categoriesList['parent_cats'][$parent] as $cat_id)
            {
            	$display=1;
            	$selected='';
            	if($currentID && $selectCurrentCategory==false && $currentID==$cat_id)
            	{
            		$display=0;
            	}
            	if($currentID && $selectCurrentCategory==true && $currentID==$cat_id)
            	{
            		$selected="selected";
            		$display=1;
            	}
            	if($display==1)
            	{
            		if($valueType=='slug')
            			$value=$this->categoriesList['categories'][$cat_id]->slug;
            		else
            			$value=$this->categoriesList['categories'][$cat_id]->id;
	            	echo '<option value="'.$value.'" data-title="'.stripslashes($this->categoriesList['categories'][$cat_id]->category).
	            	'" data-slug="'.$this->categoriesList['categories'][$cat_id]->slug.
	            	'" '.$selected;
	            	if(isset($this->categoriesList['categories'][$cat_id]->count))
	            		echo " data-count='".$this->categoriesList['categories'][$cat_id]->count."'";
	            	echo ' >';
	            	echo str_repeat("&#8210; ",$level-1);
	            	echo $this->categoriesList['categories'][$cat_id]->category;
	            	if(isset($this->categoriesList['categories'][$cat_id]->count) && $showCount)
	            	echo "(".$this->categoriesList['categories'][$cat_id]->count.")";
	            	/*if(!empty($categoryCount))
	            	{
	            		if(isset($categoryCount[$cat_id]))
	            			echo "(".$categoryCount[$cat_id].")";
	            		else
	            			echo "(0)";
	            	}*/
	            	echo "</option>";
            	}
                if (isset($this->categoriesList['parent_cats'][$cat_id])) 
                {
	                $nl=$level+1;
	                $this->buildCategoryDropdown($cat_id,$nl,$currentID,$selectCurrentCategory,$categoryCount,$valueType);
            	}
            }
        }
    }

    function buildCategoryAdminList($parent,$level,$categoryCount=array())
	{
        if (isset($this->categoriesList['parent_cats'][$parent]))
        {
            foreach ($this->categoriesList['parent_cats'][$parent] as $cat_id) 
            {
            	$count=0;
            	if(!empty($categoryCount))
            	{
            		if(isset($categoryCount[$cat_id]))
            			$count=$categoryCount[$cat_id];
            	}
            	$data['count']=$count;
        		$data['categoryData']=$this->categoriesList['categories'][$cat_id];
        		$data['level']=$level;
            	$this->load->view("categories/admin/_list_template",$data);
            	
                if (isset($this->categoriesList['parent_cats'][$cat_id])) 
                {
	                $nl=$level+1;
	                $this->buildCategoryAdminList($cat_id,$nl,$categoryCount);
            	}
            }
        }
    }

    public function convertTo($categoriesString='')
    {
    	$categoriesArray=array();
    	if($categoriesString!='')
    	{
    		$categoriesArray=explode(",", $categoriesString);
    	}
    	$result=array();
    	foreach ($this->categoriesList['categories'] as $key => $c) 
    	{
    		if(is_numeric($key))
    		{
    			if(!empty($categoriesArray) && in_array($c->id,$categoriesArray))
    			{
    				$temp['state']['selected']="true".$c->id;
    			}
	    		$temp['text']=$c->category;
	    		$temp['id']=$c->id;
	    		if($c->parent==0)
	    			$temp['parent']="#";
	    		else
	    			$temp['parent']=$c->parent;
	    		$result[]=$temp;
	    		unset($temp['state']);
	    	}
    	}
    	return $result;
    }


    function categoriesCheckboxes($parent,$level,$currentIdsArray=0,$selectCurrentCategories=false,$categoryCount=array(),$valueType='id')
	{
        if (isset($this->categoriesList['parent_cats'][$parent]))
        {
            foreach ($this->categoriesList['parent_cats'][$parent] as $cat_id) 
            {
            	$display=1;
            	$selected='';
            	/*if($currentID && $selectCurrentCategories==false && $currentID==$cat_id)
            	{
            		$display=0;
            	}*/
            	if($selectCurrentCategories==true && in_array($cat_id,$currentIdsArray))
            	{
            		$selected="checked";
            		$display=1;
            	}
            	if($display==1)
            	{
            		if($valueType=='slug')
            			$value=$this->categoriesList['categories'][$cat_id]->slug;
            		else
            			$value=$this->categoriesList['categories'][$cat_id]->id;
            		
            		?>
            		<li class="category-label">
            		<label>
            		<?PHP
            		echo str_repeat("&nbsp;&nbsp;&nbsp; ",$level-1);
            		?>
            		<input type="checkbox" name="categories[]"
	            	value="<?PHP echo $value; ?>" data-title="<?PHP echo stripslashes($this->categoriesList['categories'][$cat_id]->category); ?>" <?PHP echo $selected; ?>>
	            	<span class="name">
	            	<?PHP
	            	echo $this->categoriesList['categories'][$cat_id]->category;
	            	?>
	            	</span>
	            	</label>
	            	</li>

	            	<?PHP
            	}
                if (isset($this->categoriesList['parent_cats'][$cat_id])) 
                {
	                $nl=$level+1;
	                $this->categoriesCheckboxes($cat_id,$nl,$currentIdsArray,$selectCurrentCategories,$categoryCount,$valueType);
            	}
            }
        }
    }


	//------------------------------------------------
	public function getCategoriesInfoByID($categoryArray)
	{
		$this->db->where_in("id",$categoryArray);
		$sub = $this->db->get($this->tableName);
		$result=$sub->result_array();
		return $result;
	}
	//------------------------------------------------
	public function getCategoryInfoByID($categoryID)
	{
		$this->db->where("id",$categoryID);
		$sub = $this->db->get($this->tableName);
		$result=$sub->row();
		return $result;
	}
	//------------------------------------------------
	public function getList()
	{
		$this->db->order_by('parent','asc');
		$this->db->order_by('order','asc');
		$query = $this->db->get($this->tableName);
		return $query->result();
	}

	//------------------------------------------------
	public function get()
	{
		$this->db->order_by("id", "asc"); 
		$query = $this->db->get_where($this->tableName, array('parent'=>0));
		$final=array();
		foreach($query->result() as $row)
		{
			$this->db->order_by("id", "asc"); 
			$sub = $this->db->get_where($this->tableName, array('parent'=>$row->id));
			$final[$row->id]['main']=$row;
			$final[$row->id]['sub']=$sub->result();
			foreach ($sub->result() as $subcat) 
			{
				$final[$subcat->id]['main']=$subcat;
			}
		}
		return $final;
	}
	//------------------------------------------------
	public function getParents($parentID)
	{
		$sub = $this->db->get_where($this->tableName, array('id' => $parentID));
		if($sub->num_rows())
		{
			$category=$sub->row();
			$this->temp[]=$category;
			if($category->parent)
			{
				$this->getParents($category->parent);
			}
		}
		
		return array_reverse($this->temp,true);
	}
	//------------------------------------------------
	public function getCategoryInfo($category)
	{
		$sub = $this->db->get_where($this->tableName, array('slug' => $category));
		$result=$sub->row();
		return $result;
	}

	//------------------------------------------------
	function listCategories()
	{
		$this->db->order_by("category",'asc');
		$query = $this->db->get($this->tableName);
		return $query->result();
	}
		
	//------------------------------------------------
	public function getCategoryByID($categoryID)
	{
		$this->db->where('id',$categoryID);
		$query = $this->db->get($this->tableName);
		return $query->row();
	}
	
	function cat_data($id)
	{
		$this->db->where('id',$id);
		$query = $this->db->get($this->tableName);
		return $query->result();
	}
	
	
	
	//------------------------------------------------
	public function categoryCheck($category,$categoryID)
	{
		$slug=url_title($category);
		if(strlen($slug)<3)
			return 2;

		$this->db->where("id !=",$categoryID);
		$this->db->where("category",$category);

		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4)
			$this->db->where('ashram_id',$this->currentUser->ashram_id);

		if($this->currentUser->roles == 1 || $currentUser->roles == 8)
			$this->db->where('ashram_id',0);
		
		$ee=$this->db->get($this->tableName);
		if($ee->num_rows())
		return 0;//exists
		else return 1;//does not exist
	}
	//------------------------------------------------
	public function parentCategoryCheck($parent,$categoryID)
	{
		if($parent)
		{
			if(isset($this->categories_model->categoriesList['categories'][$parent]) && $parent!=$categoryID)
			return 1;//Valid
			else return 0;//Not valid
		}
		else
			return 1;
	}
	
	//------------------------------------------------
	function saveCategory($id)
	{
		$slug=strtolower(url_title($_POST['category']));
		if($id==0)
		{
			$ashram_id=$this->session->userdata("ashramId");
			$satsang_id=0;
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($this->currentUser->ashram_id)
					$ashram_id=$this->currentUser->ashram_id;
				else if($this->currentUser->satsang_id)
					$satsang_id=$this->currentUser->satsang_id;
			}
			$ashram_id = isset($ashram_id)?$ashram_id:0;
			$query=$this->db->insert($this->tableName,
                            array('category' =>trim($_POST["category"]),
								  'parent'=>trim($_POST['parent']),
								  'slug'=>$slug,
								  'description'=>trim($_POST['description']),
								  'created_by'=>$this->currentUser->id,
								  'created_on'=>date("Y:m:d H:i:s"),
								  'ashram_id'=>$ashram_id,
								  'satsang_id'=>$satsang_id
							)
							);
			$idd=$this->db->insert_id();
			
			
		}
		else
		{
			$this->db->where("id",$id);
			$query = $this->db->update($this->tableName,
								array(
								'category'=>trim($_POST['category']),
								'parent'=>$_POST['parent'],
								'slug'=>$slug,
								'description'=>trim($_POST['description']),
								'modified_on'=>date("Y:m:d H:i:s")
								));
			$idd=$id;
		}
		if($query)
			return $idd;
		else return 0;
	}
	
	//------------------------------------------------
	function delete($categoryID)
	{
		$this->db->where("id",$categoryID);
		$query = $this->db->delete($this->tableName);
		$this->db->where("parent",$categoryID);
		$this->db->update($this->tableName,array('parent'=>0));

		$this->events_model->deleteCategory($categoryID);
		$this->events_category_model->delete($categoryID);

		$this->pages_model->deleteCategory($categoryID);
		$this->pages_category_model->delete($categoryID);

		if($query) return 1;
		else return 0;
	}
	//------------------------------------------------
	function bulk_delete($ids)
	{
		$i=0;
		foreach($ids as $cid)
		{
			$categoryData=$this->getCategoryByID($cid);
			if(!empty($categoryData))
			{
				$c=$this->delete($cid);
				if($c) $i++;
			}
		}
		return $i;
	}

	function catr_dropdown_pages($id,$level)
	{
		$cat_data=$this->cat_data($id);
		?>
        <option  value="<?PHP echo $cat_data[0]->id; ?>"
        <?PHP if(isset($_GET['category']) && $_GET['category']==$cat_data[0]->id) echo " selected"; ?>>
		<?PHP echo str_repeat("&#8210; ",$level-1).$cat_data[0]->category; ?></option>
			
        <?PHP
        $this->db->where('parent',$id);
        $this->db->where('service_id',4);
		$llist = $this->db->get($this->tableName);
		 if($llist->num_rows())
		 foreach($llist->result() as $cat)
		 {
			 $newl=$level+1;
			 $this->catr_dropdown_pages($cat->id,$newl);
		 }
	}
	
	function catr_event($id,$level,$arr)
	{
		$cat_data=$this->cat_data($id);

		$this->db->where('category_id',$cat_data[0]->id);
		$num_p = $this->db->get('pages_category');
		$total_num=$num_p->num_rows();
		?>
         <li id="category-<?PHP echo $cat_data[0]->id?>" class="popular-category">
                  <label class="selectit">
                  <?PHP echo str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;",$level-1); ?>
                  <input value="<?PHP echo $cat_data[0]->id; ?>" type="checkbox" name="post_category[]"
                  <?PHP if(in_array($cat_data[0]->id,$arr)) echo "checked" ?> style="vertical-align:top;"
                  > 
				  <?PHP echo $cat_data[0]->category; ?></label>
        </li>
        <?PHP
        $this->db->where('parent',$id);
        $this->db->where('service_id',4);
		$llist = $this->db->get($this->tableName);
		if($llist->num_rows())
		foreach($llist->result() as $cat)
		{
			$newl=$level+1;
			$this->catr_event($cat->id,$newl,$arr);
		}
	}
}
?>