<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Subscriptions_bundle_model extends CI_Model
{
	var $tableName='subscriptions_bundle';
	function __construct() 
	{
		parent::__construct();
    }
    public function getBySubscription($subscriptionId)
    {
    	$this->db->where("subscription_id",$subscriptionId);
    	$this->db->from($this->tableName." as db");
    	$this->db->join("subscriptions as d","d.id=db.bundle_id");
    	return $this->db->get()->result();
    }
    public function remove($subscriptionId)
    {
    	$this->db->where("subscription_id",$subscriptionId);
    	return $this->db->delete($this->tableName);
    }
    public function update($subscriptionId,$bundleIds)
    {
    	$bundleIds=array_filter(explode(",",$bundleIds));

    	$this->db->where("subscription_id",$subscriptionId);
    	$existing=$this->db->get($this->tableName)->result();
    	$existingIds=array();
    	if(!empty($existing))
    	{
    		foreach ($existing as $bundleItem)
    		{
    			if(!in_array($bundleItem->bundle_id,$existingIds))
    				$existingIds[]=$bundleItem->bundle_id;
    		}
    	}

    	foreach ($existingIds as $existingId)
    	{
    		if(!in_array($existingId,$bundleIds))
    		{
    			//Delete
    			$this->db->where("subscription_id",$subscriptionId);
    			$this->db->where("bundle_id",$existingId);
    			$this->db->delete($this->tableName);
    		}
    	}

    	foreach ($bundleIds as $bundleId)
    	{
    		if(!in_array($bundleId,$existingIds))
    		{
    			//Insert
    			$this->db->insert($this->tableName,
    									array(
    											"subscription_id"=>$subscriptionId,
    											"bundle_id"=>$bundleId
    									)
    								);
    		}
    	}
    }
}
?>