<?PHP
class Store_cover_photos_Model extends CI_Model 
{
	var $tableName="store_cover_photos";
	public function __construct()
	{
		parent::__construct();
	}
	public function getImages($itemId)
	{
		$this->db->where("item_id",$itemId);
		$this->db->order_by("order","asc");
		$q=$this->db->get($this->tableName);
		return $q->result();
	}

	public function imageData($id,$itemId)
	{
		$this->db->where("id",$id);
		$this->db->where("item_id",$itemId);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function uploadFile($itemData)
	{
		$fname=$_FILES['files']['name'][0];
		$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);

		$newname="store_".$itemData['item']->id."_".substr(md5(mt_rand()), 0, 16).".".$ext;
		$tempPath=$_FILES['files']['tmp_name'][0];
		$tempName=basename($_FILES['files']['tmp_name'][0]);
		$thumbName="thumb_".$fname;
		$thumbPath=str_replace($tempName, $thumbName, $tempPath);
		$this->general_model->create_thumb_150($tempPath,$thumbPath);

		$this->load->helper("image");
		$image = new SimpleImage();
		$image->load($tempPath);
		$img_width=$image->getWidth();
    	$img_height=$image->getHeight();
    	$ratio=$img_width/$img_height;
      
		if($ratio>=1)
		{
			if($img_width>800)
				$image->resizeToWidth(800);
		}
		else
		{
			if($img_height>800)
				$image->resizeToHeight(800);
		}
		$image->save($tempPath);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$amazonUri="images/store_images/".$itemData['item']->id."/";
		$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
		$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUri."thumb_".$newname,S3::ACL_PUBLIC_READ, array(), array());

		$this->db->insert($this->tableName,
						array(
								"filename"=>$newname,
								'created_on'=>date("Y:m:d H:i:s"),
								'item_id'=>$itemData['item']->id,
								'description'=>$fname
							));
		$data['fileid']=$this->db->insert_id();
		$data['filename']=$newname;
		$data['title']=$fname;
		return $data;
	}

	public function delete($imageData)
	{
		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="content/store/".$imageData->item_id."/".$imageData->filename;
		$amazonThumbUri="content/store/".$imageData->item_id."/thumb_".$imageData->filename;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonThumbUri);
		$this->db->where("id",$imageData->id);
		$this->db->delete($this->tableName);
		return 1;
	}

	public function updateInfo($id,$colName,$value)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array($colName=>$value));
	}
}
?>