<?PHP
class Poojas_Model extends CI_Model 
{
	var $tableName="poojas";
	var $auth_check = "";
	public function __construct()
	{
		parent::__construct();
		$this->auth_check = $this->load->database("sso_auth",true,false);
	}
	public function poojaData($id)
	{
		$this->db->select("a.*, b.name as ashram_name");
		$this->db->from($this->tableName." as a");
		$this->db->join("ashrams as b","b.id=a.ashram_id","left");
		$this->db->where("a.id",$id);
		$q=$this->db->get();
		$result=$q->row();
		if($result)
		{
			$result->include_dates_txt = '';
			if(isset($result->include_dates) && $result->include_dates !='' && $result->include_dates != NULL)
			{
				$includeDts = explode(',', $result->include_dates);
				usort($includeDts, array($this,'sortDatesByAscendingorder'));
				foreach($includeDts as $thisIncludeDt)
				{
					if($result->include_dates_txt == '')
					{
						$result->include_dates_txt .= date('j M Y (l)', strtotime($thisIncludeDt));
					} else {
						$result->include_dates_txt .= '<br>'.date('j M Y (l)', strtotime($thisIncludeDt));
					}
				}
			}
			$result->exclude_dates_txt = '';
			if(isset($result->exclude_dates) && $result->exclude_dates !='' && $result->exclude_dates != NULL)
			{
				$excludeDts = explode(',', $result->exclude_dates);
				usort($excludeDts, array($this,'sortDatesByAscendingorder'));
				foreach($excludeDts as $thisexcludeDt)
				{
					if($result->exclude_dates_txt == '')
					{
						$result->exclude_dates_txt .= date('j M Y (l)', strtotime($thisexcludeDt));
					} else {
						$result->exclude_dates_txt .= '<br>'.date('j M Y (l)', strtotime($thisexcludeDt));
					}
				}
			}
			$cutoffTimeArr = $this->cutoffTimeCalculation($result->cutoff_type, $result->cutoff_hour, $result->cutoff_minutes, $result->time_from, $result->time_to);
			if(isset($cutoffTimeArr['cutoff_time']))
			{
				$result->cutoff_time = $cutoffTimeArr['cutoff_time'];
			}
			else
			{
				$result->cutoff_time = '';
			}
			if(isset($cutoffTimeArr['cutoff_time_str']))
			{
				$result->cutoff_time_str = $cutoffTimeArr['cutoff_time_str'];
			}
			else
			{
				$result->cutoff_time_str = '';
			}
		}
		return $result;
	}

	public function getAshramIDforMultiPoojas($pooja_ids)
	{
		$q = $this->db->select("ashram_id")->from("poojas")->where_in("id",$pooja_ids)->group_by("ashram_id")->get();
		if($q->num_rows() > 0)
		{
			$r = $q->result();
			return $r;
		}
		return false;
	}

	public function getCount()
	{
		if($this->currentUser->roles == 3 || $this->currentUser->roles == 4){
			$this->db->where('ashram_id',$this->currentUser->ashram_id);
		}
		$this->db->where("status",1);
		return $this->db->get($this->tableName)->num_rows();
	}

	public function getByAshramId($ashramId)
	{
		$this->db->where("ashram_id",$ashramId);
		$this->db->order_by("status","desc");
		$this->db->order_by("pooja_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function getmultiPoojas($pooja_ids)
	{
		$this->db->where_in("id",$pooja_ids);
		$this->db->order_by("status","desc");
		$this->db->order_by("pooja_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function updateOrder($id,$value)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array('order'=>$value));
	}

	public function listAdmin($ashramId,$excel=0)
	{
		if(isset($_POST['category']) && is_numeric($_POST['category']))
		{
			$categoryData=$this->poojas_categories_model->categoryData($this->input->post("category"));
		}
		$poojasCategories=$this->poojas_categories_model->getList();

		$categories=array();
		foreach ($poojasCategories as $poojasCategory)
		{
			$categories[$poojasCategory->id]=$poojasCategory;
		}

		$ashramData=$this->ashrams_model->ashramData($ashramId);

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->where("ashram_id",$ashramId);
		$query1->from($this->tableName);

		$preData="Ashram Name: ".$ashramData->name;

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nPooja Status:";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1)))
		{
			if($_POST['status']==0)
			{
				$query1->where("status",0);
				$preData.="Inactive";
			}
			else
			{
				$query1->where("status",1);
				$preData.="Active";
			}
		}
		else
		{
			$preData.="All Status";
		}

		$preData.="\nPrasadam:";
		if(isset($_POST['prasadam']) && is_numeric($_POST['prasadam']) && in_array($_POST['prasadam'],array(0,1)))
		{
			if($_POST['prasadam']==0)
			{
				$query1->where("shipping",0);
				$preData.="No";
			}
			else
			{
				$query1->where("shipping",1);
				$preData.="Yes";
			}
		}
		else
		{
			$preData.="Yes & No";
		}

		$preData.="\nExternal Link:";
		if(isset($_POST['external_link']) && is_numeric($_POST['external_link']) && in_array($_POST['external_link'],array(0,1)))
		{
			if($_POST['external_link']==0)
			{
				$query1->where("is_external_link",0);
				$preData.="No";
			}
			else
			{
				$query1->where("is_external_link",1);
				$preData.="Yes";
			}
		}
		else
		{
			$preData.="Yes & No";
		}

		$preData.="\nPartial Pay:";
		if(isset($_POST['partial_pay']) && is_numeric($_POST['partial_pay']) && in_array($_POST['partial_pay'],array(0,1)))
		{
			if($_POST['partial_pay']==0)
			{
				$query1->where("partial_payments_allowed",0);
				$preData.="No";
			}
			else
			{
				$query1->where("partial_payments_allowed",1);
				$preData.="Yes";
			}
		}
		else
		{
			$preData.="Yes & No";
		}

		$preData.="\nCategory:";
		if(isset($_POST['category']) && is_numeric($_POST['category']))
		{
			if(!empty($categoryData))
			{
				$query1->where("category",$_POST['category']);
				$preData.=$categoryData->name;
			}
		}
		else
		{
			$preData.="All Categories";
		}


		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('pooja_name',$_POST['dir']);
				else
					$query1->order_by('pooja_name',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ashrams/poojas_model",$sql,$this->currentUser,"default",$_POST,"All Poojas",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('order',$dir);
		}
		else
		{
			$query1->order_by('order',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['timings'] = "N/A";
			if($rtn['data'][$c]['time_from'] && $rtn['data'][$c]['time_to']){
				$rtn['data'][$c]['timings']=date("h:i A",strtotime($rtn['data'][$c]['time_from']))." - ".date("h:i A",strtotime($rtn['data'][$c]['time_to']));
			}
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$closebfre = '';
			if($rtn['data'][$c]['cutoff_type'] == 'CloseAfterStartTime')
			{
				$closebfre = 'Close After Start Time - '.$rtn['data'][$c]['cutoff_hour'].' Hrs and '.$rtn['data'][$c]['cutoff_minutes']. 'Mins';
			} else if($rtn['data'][$c]['cutoff_type'] == 'CloseAfterEndTime')
			{
				$closebfre = 'Close After End Time - '.$rtn['data'][$c]['cutoff_hour'].' Hrs and '.$rtn['data'][$c]['cutoff_minutes']. 'Mins';
			} else if($rtn['data'][$c]['cutoff_type'] == 'CloseBeforeStartTime')
			{
				$closebfre = 'Close Before Start Time - '.$rtn['data'][$c]['cutoff_hour'].' Hrs and '.$rtn['data'][$c]['cutoff_minutes']. 'Mins';
			} else if($rtn['data'][$c]['cutoff_type'] == 'CloseBeforeEndTime')
			{
				$closebfre = 'Close Before End Time - '.$rtn['data'][$c]['cutoff_hour'].' Hrs and '.$rtn['data'][$c]['cutoff_minutes']. 'Mins';
			}
			// $rtn['data'][$c]['close_before'] = $rtn['data'][$c]['close_before']." Mins";
			$rtn['data'][$c]['close_before'] = $closebfre;
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			$rtn['data'][$c]['category_name']="-";
			if($row['category'])
			{
				$rtn['data'][$c]['category_name']=$categories[$row['category']]->name;
			}

			//getting notification data
			$notificationData = $this->mobileNotifications_model->getNotificationIDBasedOnService($row['id'],'poojas');
			$rtn['data'][$c]['notification_id'] = -1;
			if(!empty($notificationData)){
				$rtn['data'][$c]['notification_id'] = 0;
				if($notificationData->is_sent == 0){
					$rtn['data'][$c]['notification_id'] = $notificationData->id;
				}
			}
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id,$poojaData)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);

		if($poojaData->image!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
                                            "secretKey"=>aws_s3_secret_key,
                                            "useSSL"=>false,
                                            "endpoint"=>"s3.amazonaws.com"));
			$path="images/pooja_images/".$poojaData->image;
			$tpath="images/pooja_images/thumb_".$poojaData->image;
			$this->s3->deleteObject(aws_s3_bucket_name,$path);
			$this->s3->deleteObject(aws_s3_bucket_name,$tpath);
		}

		return 1;
	}
	public function save($id,$poojaData)
	{
		$current_date_time=strtotime(date("d M Y")." 00:00:00");
		if($current_date_time>=strtotime($_POST['visible_from']) && $current_date_time<=strtotime($_POST['visible_to']))
		{
			$status=1;
		}
		else
		{
			$status=0;
		}
		$week_days=array('0'=>'Sunday','1'=>'Monday','2'=>'Tuesday','3'=>'Wednesday','4'=>'Thursday','5'=>'Friday','6'=>'Saturday');
		if(isset($_POST['days']))
		{
			$days=implode(",",$_POST['days']);
		}
		else
		{
			$days=implode(",",$week_days);
		}

		$external_link='';
		if($this->input->post("is_external_link")==1)
		{
			$external_link=$this->input->post('external_link');
		}

		$includedates = '';
		$excludedates = '';
		if(trim($_POST['include_exclude_dates']) == 'IncludeDates')
		{
			$includedates = trim($_POST['include_dates']);
		}
		if(trim($_POST['include_exclude_dates']) == 'ExcludeDates')
		{
			$excludedates = trim($_POST['exclude_dates']);
		}
		$pitru_paksha_pooja = 0;
		if(isset($_POST['pitru_paksha_pooja']) && trim($_POST['pitru_paksha_pooja']) == 1)
		{
			$pitru_paksha_pooja = trim($_POST['pitru_paksha_pooja']);
		}
		$max_family_members = 'All family members';
		if(isset($_POST['max_family_members']) && trim($_POST['max_family_members']) >= 1)
		{
			$max_family_members = trim($_POST['max_family_members']);
		}
		$is_poornaphala_seva = 0;
		if(isset($_POST['is_poornaphala_seva']) && trim($_POST['is_poornaphala_seva']) == 1)
		{
			$is_poornaphala_seva = trim($_POST['is_poornaphala_seva']);
		}
		$navagraha_pooja = 0;
	    if(isset($_POST['navagraha_pooja']) && trim($_POST['navagraha_pooja']) == 1)
	    {
	        $navagraha_pooja = trim($_POST['navagraha_pooja']);
	    }
	    $is_secret = 0;
	    if(isset($_POST['is_secret']) && trim($_POST['is_secret']) == 1)
	    {
	        $is_secret = trim($_POST['is_secret']);
	    }
	    $secret_key = NULL;
	    if(isset($_POST['s_key']) && trim($_POST['s_key']) != '' && $is_secret==1)
	    {
	        $secret_key = trim($_POST['s_key']);
	    }
	    $item_key = NULL;
	    if(isset($_POST['item_key']) && trim($_POST['item_key']) != '')
	    {
	        $item_key = trim($_POST['item_key']);
	    }

	    $is_public_display = 1;
	    if(isset($_POST['is_public_display']) && trim($_POST['is_public_display']) == 0)
	    {
	        $is_public_display = trim($_POST['is_public_display']);
	    }

	    $only_for_admin = 0;
	    if(isset($_POST['only_for_admin']) && trim($_POST['only_for_admin']) == 1)
	    {
	        $only_for_admin = trim($_POST['only_for_admin']);
	        $is_public_display = 0;
	    }

	    $only_for_admin = 0;
	    if(isset($_POST['only_for_admin']) && trim($_POST['only_for_admin']) == 1)
	    {
	        $only_for_admin = trim($_POST['only_for_admin']);
	        $is_public_display = 0;
	    }

	    $display_only_popup = 0;
	    if(isset($_POST['display_only_popup']) && trim($_POST['display_only_popup']) == 1)
	    {
	        $display_only_popup = trim($_POST['display_only_popup']);
	    }

	    $popup_content = '';
	    if(isset($_POST['popup_content']) && trim($_POST['popup_content']) != '')
	    {
	        $popup_content = $this->general_model->filtertext(trim($_POST['popup_content']));
	    }

	    $having_custom_email = 0;
	    if(isset($_POST['having_custom_email']) && trim($_POST['having_custom_email']) == 1)
	    {
	        $having_custom_email = trim($_POST['having_custom_email']);
	    }

	    $custom_email_text = '';
	    if(isset($_POST['custom_email_text']) && trim($_POST['custom_email_text']) != '')
	    {
	        $custom_email_text = $this->general_model->filtertext(trim($_POST['custom_email_text']));
	    }

	    $having_custom_sms = 0;
	    if(isset($_POST['having_custom_sms']) && trim($_POST['having_custom_sms']) == 1)
	    {
	        $having_custom_sms = trim($_POST['having_custom_sms']);
	    }

	    $custom_sms_text = '';
	    if(isset($_POST['custom_sms_text']) && trim($_POST['custom_sms_text']) != '')
	    {
	        $custom_sms_text = $this->general_model->filtertext(trim($_POST['custom_sms_text']));
	    }
		
	    $in_person_note = '';
	    if(isset($_POST['in_person_note']) && trim($_POST['in_person_note']) != '')
	    {
	        $in_person_note = $this->general_model->filtertext(trim($_POST['in_person_note']));
	    }

		if(!$id)
		{
			$q=$this->db->insert($this->tableName,
                                array(
                                	'pooja_name' => $this->general_model->filtertext(trim($_POST["pooja_name"])),
                                	'category'=>$this->input->post('category'),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'ashram_id' => $this->session->userdata("ashramId"),
									'shipping'=>$this->input->post("shipping"),
									'visible_from' => date("Y:m:d",strtotime($_POST["visible_from"])),
									'visible_to' => date("Y:m:d",strtotime($_POST["visible_to"])),
									'start_date' => date("Y:m:d",strtotime($_POST["start_date"])),
									'end_date' => date("Y:m:d",strtotime($_POST["end_date"])),
									'time_from' => date("H:i:s",strtotime($_POST["time_from"])),
									'time_to' => date("H:i:s",strtotime($_POST["time_to"])),
									'days'=>$days,
									'status'=>$status,
									'include_exclude_dates'=>trim($_POST['include_exclude_dates']),
									'exclude_dates'=>$excludedates,
									'include_dates'=>$includedates,
									// 'close_before' => $_POST['close_before'],
									'cutoff_type' => $_POST['cutoff_type'],
									'cutoff_hour' => $_POST['cutoff_hour'],
									'cutoff_minutes' => $_POST['cutoff_minutes'],
									'is_external_link'=>$this->input->post('is_external_link'),
									'is_public_display'=>$is_public_display,
									'have_personal_note'=>$this->input->post('have_personal_note'),
									'pitru_paksha_pooja'=>$pitru_paksha_pooja,
									'is_poornaphala_seva'=>$is_poornaphala_seva,
									'attend_pooja_in_person'=>$this->input->post('attend_pooja_in_person'),
									'in_person_note'=>$in_person_note,
									'max_family_members'=>$max_family_members,
									'navagraha_pooja'=>$navagraha_pooja,
									'partial_payments_allowed'=>$this->input->post('partial_payments_allowed'),
									'external_link'=>$external_link,
									'is_secret'=>$is_secret,
									's_key'=>$secret_key,
									'item_key'=>$item_key,
									'only_for_admin'=>$only_for_admin,
									'display_only_popup'=>$display_only_popup,
									'popup_content'=>$popup_content,
									'having_custom_email'=>$having_custom_email,
									'custom_email_text'=>$custom_email_text,
									'having_custom_sms'=>$having_custom_sms,
									'custom_sms_text'=>$custom_sms_text,
								)
								);
			$idd=$this->db->insert_id();
			//saving live updates content for notifications
			$this->mobileNotifications_model->addNotification('Poojas',$this->general_model->filtertext(trim($_POST['pooja_name'])),$idd,'poojas');
		}
		else
		{
			
			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName,
                                array(
                                	'pooja_name' => $this->general_model->filtertext(trim($_POST["pooja_name"])),
                                	'category'=>$this->input->post('category'),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'shipping'=>$this->input->post("shipping"),
									'visible_from' => date("Y:m:d",strtotime($_POST["visible_from"])),
									'visible_to' => date("Y:m:d",strtotime($_POST["visible_to"])),
									'start_date' => date("Y:m:d",strtotime($_POST["start_date"])),
									'end_date' => date("Y:m:d",strtotime($_POST["end_date"])),
									'time_from' => date("H:i:s",strtotime($_POST["time_from"])),
									'time_to' => date("H:i:s",strtotime($_POST["time_to"])),
									'days'=>$days,
									'include_exclude_dates'=>trim($_POST['include_exclude_dates']),
									'exclude_dates'=>$excludedates,
									'include_dates'=>$includedates,
									// 'close_before' => $_POST['close_before'],
									'cutoff_type' => $_POST['cutoff_type'],
									'cutoff_hour' => $_POST['cutoff_hour'],
									'cutoff_minutes' => $_POST['cutoff_minutes'],
									'status'=>$status,
									'is_external_link'=>$this->input->post('is_external_link'),
									'is_public_display'=>$is_public_display,
									'have_personal_note'=>$this->input->post('have_personal_note'),
									'pitru_paksha_pooja'=>$pitru_paksha_pooja,
									'is_poornaphala_seva'=>$is_poornaphala_seva,
									'attend_pooja_in_person'=>$this->input->post('attend_pooja_in_person'),
									'in_person_note'=>$in_person_note,
									'max_family_members'=>$max_family_members,
									'navagraha_pooja'=>$navagraha_pooja,
									'partial_payments_allowed'=>$this->input->post('partial_payments_allowed'),
									'external_link'=>$external_link,
									'is_secret'=>$is_secret,
									's_key'=>$secret_key,
									'item_key'=>$item_key,
									'only_for_admin'=>$only_for_admin,
									'display_only_popup'=>$display_only_popup,
									'popup_content'=>$popup_content,
									'having_custom_email'=>$having_custom_email,
									'custom_email_text'=>$custom_email_text,
									'having_custom_sms'=>$having_custom_sms,
									'custom_sms_text'=>$custom_sms_text,
								)
								);
			$idd=$id;
		}

		$updateData=array();
		foreach ($GLOBALS['currencies'] as $currencyData)
		{
			$priceCol='price_'.strtolower($currencyData['currency']);
			$displayCol=strtolower($currencyData['currency'])."_display";
			$updateData[$priceCol]=$_POST[$priceCol];
			$shipDomestic='shipping_domestic_'.strtolower($currencyData['currency']);
			$shipInternational='shipping_international_'.strtolower($currencyData['currency']);

			if($this->input->post($displayCol)!='')
			{
				$updateData[$displayCol]=1;
			}
			else
			{
				$updateData[$displayCol]=0;	
			}

			if($this->input->post("shipping")==1)
			{	
				$updateData[$shipDomestic]=$_POST[$shipDomestic];
				$updateData[$shipInternational]=$_POST[$shipInternational];
			}
			else
			{
				$updateData[$shipDomestic]=0;
				$updateData[$shipInternational]=0;
			}
		}

		$this->db->where("id",$idd);
		$this->db->update($this->tableName,$updateData);

		if($id && $poojaData->image!='' && !isset($_POST['imgupl']))
		{
			$this->db->where("id",$id);
			$this->db->update($this->tableName,array('image'=>''));
			$path=aws_s3_base_url."/images/pooja_images/".$poojaData->image;
			if(file_exists($path))
				unlink($path);
		}
		
		if(isset($_FILES['pooja_image']))
		if($_FILES['pooja_image']['name']!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$this->load->helper('image');
			$name=$_FILES['pooja_image']['name'];
			$ext=pathinfo ($_FILES['pooja_image']['name'],PATHINFO_EXTENSION);			
			
			$newName="pooja_".$idd."_".substr(md5(mt_rand()), 0, 16).".".$ext;
			$tempPath=$_FILES['pooja_image']['tmp_name'];
			$tempName=basename($_FILES['pooja_image']['tmp_name']);
			$thumbName="thumb_".$newName;
			$thumbPath=str_replace($tempName, $thumbName, $tempPath);
			$this->general_model->create_thumb_150($tempPath,$thumbPath);
			
			$image = new SimpleImage();
			$image->load($tempPath);
			$img_width=$image->getWidth();
	    	$img_height=$image->getHeight();
	    	$ratio=$img_width/$img_height;
	      
			if($ratio>=1)
			{
				if($img_width>800)
					$image->resizeToWidth(800);
			}
			else
			{
				if($img_height>800)
					$image->resizeToHeight(800);
			}
			$image->save($tempPath);
			
			$amazonUri="images/pooja_images/";
			$amazonUriThumb="images/pooja_images/thumb_".$newName;
			$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newName,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());
			
			$this->db->where("id",$idd);
			$this->db->update($this->tableName,array('image'=>$newName));
			
		}

		if($idd>0)
		{
			$this->checkAndUpdatePoojaSevakartaReportCron($idd);
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function checkAndUpdatePoojaSevakartaReportCron($pooja_id)
	{
		if($pooja_id>0)
		{
			$poojasForTodayCron = [];
			$currentDate = date('Y-m-d');

			$this->db->select("p.*,a.poojas_report_emails");
			$this->db->from('poojas as p');
			$this->db->join("ashrams as a",'a.id=p.ashram_id');
			$this->db->where("a.is_poojas_report_email",1);
			$this->db->where("p.id",$pooja_id);
			$poojaData = $this->db->get()->row_array();
			if(isset($poojaData['id']) && $poojaData['id']>0)
			{
				$include_exclude_dates = $poojaData['include_exclude_dates'];
				$weekdays=explode(",",$poojaData['days']);
				$exclude_dates=explode(",",$poojaData['exclude_dates']);
				$include_dates=explode(",",$poojaData['include_dates']);
				$startDateTime=strtotime($poojaData['start_date']);
				$endDateTime=strtotime($poojaData['end_date']);

				$cutoffType=$poojaData['cutoff_type'];
				$cutoffHour=$poojaData['cutoff_hour'];
				$cutoffMinutes=$poojaData['cutoff_minutes'];
				if($cutoffHour>0)
				{
					$tempMinutes = $cutoffHour*60;
					$cutoffMinutes = $cutoffMinutes+$tempMinutes;
				}
				$temp=strtotime("00:00:00");
				if($cutoffType=='CloseAfterStartTime')
				{
					$dateTime=strtotime(date("Y-m-d",$temp)." ".$poojaData['time_from']." +".$cutoffMinutes." Minutes");
				} else if($cutoffType=='CloseAfterEndTime')
				{
					$dateTime=strtotime(date("Y-m-d",$temp)." ".$poojaData['time_to']." +".$cutoffMinutes." Minutes");
				} else if($cutoffType=='CloseBeforeStartTime')
				{
					$dateTime=strtotime(date("Y-m-d",$temp)." ".$poojaData['time_from']." -".$cutoffMinutes." Minutes");
				} else if($cutoffType=='CloseBeforeEndTime')
				{
					$dateTime=strtotime(date("Y-m-d",$temp)." ".$poojaData['time_to']." -".$cutoffMinutes." Minutes");
				} else {
					$dateTime=strtotime(date("Y-m-d",$temp)." ".$poojaData['time_to']." -".$cutoffMinutes." Minutes");
				}

				$poojaData['cron_run_time'] = date('Y-m-d H:i:s',$dateTime);
				$poojaData['report_emails'] = $poojaData['poojas_report_emails'];

				if($include_exclude_dates == 'IncludeDates')
				{
					if(in_array(date('d M Y', strtotime($currentDate)), $include_dates))
					{
						$poojasForTodayCron[] = $poojaData;
					}
				}
				else if($include_exclude_dates == 'ExcludeDates')
				{
					if(!in_array(date('d M Y', strtotime($currentDate)), $exclude_dates))
					{
						$poojasForTodayCron[] = $poojaData;
					}
				}
				else
				{
					$poojasForTodayCron[] = $poojaData;
				}
			}

			if(count($poojasForTodayCron)>0)
			{
				foreach($poojasForTodayCron as $thisPooja)
				{
					$this->db->where("item_id",$thisPooja['id']);
					$this->db->where("date(cron_to_be_run_on)=",date('Y-m-d', strtotime($thisPooja['cron_run_time'])));
	                $record_exist=$this->db->get('pooja_sevakarta_reports_crons')->num_rows();
	                if($record_exist)
	                {
	                	$updateData = [
										'cron_to_be_run_on' => $thisPooja['cron_run_time'],
										'report_emails' => $thisPooja['report_emails'],
										'cron_run_status' => '0',
									];
	                	$this->db->where("item_id",$thisPooja['id']);
	                	$this->db->where("date(cron_to_be_run_on)=",date('Y-m-d', strtotime($thisPooja['cron_run_time'])));
						$this->db->update("pooja_sevakarta_reports_crons", $updateData);
	                }
	                else
	                {
	                	$insData = [
										'ashram_id' => $thisPooja['ashram_id'],
										'item_id' => $thisPooja['id'],
										'item_name' => $thisPooja['pooja_name'],
										'seva_date' => $currentDate,
										'cron_to_be_run_on' => $thisPooja['cron_run_time'],
										'report_emails' => $thisPooja['report_emails'],
									];
						$this->db->insert('pooja_sevakarta_reports_crons',$insData);
	                }
				}
			}
		}
		
	}

	public function checkPoojaName($name,$id)
	{
		$error=0;

		$this->db->where("pooja_name",$name);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	/**
	 * updateSwamijipooja Make Pooja On sri swamiji name by updating family note in order Items
	 * @param  [int] $status [Check Status]
	 * @param  [int] $itemId [Order Item Id]
	 * @param  [int] $userId [UserId]
	 * @return [int]         [1,0]
	 * @author Baji Shaik <[bajidotwork@gmail.com]>
	 */
	public function updateSwamijipooja($status,$itemId,$userId)
	{
		$details = $this->db->select('family_details')->from('users')->where('id',$userId)->get()->result();
		if($status == 1)
		{
			$this->db->where("id",$itemId);
			$this->db->update("order_items",
							array("pooja_on_swamiji"=>1,'family_member_details'=>"Sri Ganapathy Sachchidananda Swamiji")
						);
			return 1;
		}
		else
		{
			$this->db->where("id",$itemId);
			$this->db->update("order_items",
							array("pooja_on_swamiji"=>0,'family_member_details'=>$details[0]->family_details)
						);
			return 1;
		}
		return 0;
	}

	public function sortDatesByAscendingorder($a, $b)
	{
	 	$a = date('Y-m-d', strtotime($a));
	    $b = date('Y-m-d', strtotime($b));

	    if ($a == $b) {
	        return 0;
	    }
	    return ($a < $b) ? -1 : 1;
	}

	//============================================================================================================================

	public function cutoffTimeCalculation($cutoff_type, $cutoff_hour, $cutoff_minutes, $time_from, $time_to)
	{
		$toBeReturnCutoffTime = '';
		$cutoffTimeStr = '';
		$cutoffmis = 0;
	    $cutofftimes = "";
		if($cutoff_hour > 0 || $cutoff_minutes > 0)
	    {
		    if($cutoff_hour>0)
		    {
		        $cutoffmis = $cutoff_hour*60;
		    }
		    if($cutoff_minutes>0)
		    {
		        $cutoffmis = +$cutoffmis+$cutoff_minutes;
		    }
		    if($cutoffmis > 0)
		    {
		        if($cutoff_type == 'CloseBeforeStartTime')
		        {
		            $cutofftimes = date('h:i A',strtotime(date('Y-m-d '.$time_from).' - '.$cutoffmis.' minute'));
		            $cutoffTimeStr = date('Y-m-d H:i:s',strtotime(date('Y-m-d '.$time_from).' - '.$cutoffmis.' minute'));
		        } else if($cutoff_type == 'CloseBeforeEndTime')
		        {
		        	$cutofftimes = date('h:i A',strtotime(date('Y-m-d '.$time_to).' - '.$cutoffmis.' minute'));
		        	$cutoffTimeStr = date('Y-m-d H:i:s',strtotime(date('Y-m-d '.$time_to).' - '.$cutoffmis.' minute'));
		        } else if($cutoff_type == 'CloseAfterStartTime')
		        {
		        	$cutofftimes = date('h:i A',strtotime(date('Y-m-d '.$time_from).' + '.$cutoffmis.' minute'));
		        	$cutoffTimeStr = date('Y-m-d H:i:s',strtotime(date('Y-m-d '.$time_from).' + '.$cutoffmis.' minute'));
		        } else if($cutoff_type == 'CloseAfterEndTime')
		        {
		        	$cutofftimes = date('h:i A',strtotime(date('Y-m-d '.$time_to).' + '.$cutoffmis.' minute'));
		        	$cutoffTimeStr = date('Y-m-d H:i:s',strtotime(date('Y-m-d '.$time_to).' + '.$cutoffmis.' minute'));
		        }
		    }
		    // $toBeReturnCutoffTime = $cutofftimes;
	    }
	    else
	    {
	    	if( $cutoffmis == 0 && ($cutoff_type == 'CloseBeforeEndTime' || $cutoff_type == 'CloseAfterEndTime') )
		    {
		    	$cutofftimes = date('h:i A',strtotime(date('Y-m-d '.$time_to).' - '.$cutoffmis.' minute'));
		    	$cutoffTimeStr = date('Y-m-d H:i:s',strtotime(date('Y-m-d '.$time_to).' - '.$cutoffmis.' minute'));
		    }
		    else
		    {
		    	$cutofftimes = date('h:i A',strtotime(date('Y-m-d '.$time_from).' - '.$cutoffmis.' minute'));
		    	$cutoffTimeStr = date('Y-m-d H:i:s',strtotime(date('Y-m-d '.$time_from).' - '.$cutoffmis.' minute'));
		    }
	    }

	    if($cutoffTimeStr!='')
	    {
	    	if(date('Y-m-d') == date('Y-m-d', strtotime($cutoffTimeStr)))
	    	{
	    		$cutoffTimeStr = $cutofftimes;
	    	}
	    	if(date('Y-m-d') > date('Y-m-d', strtotime($cutoffTimeStr)))
	    	{
	    		$cutoffTimeStr = $cutofftimes." previous day";
	    	}
	    	if(date('Y-m-d') < date('Y-m-d', strtotime($cutoffTimeStr)))
	    	{
	    		$cutoffTimeStr = $cutofftimes." next day";
	    	}
	    }

	    $tobeReturnArr = ['cutoff_time' => $cutofftimes, 'cutoff_time_str' => $cutoffTimeStr]; 
	    return $tobeReturnArr;
	    // return $toBeReturnCutoffTime;
	}

	public function listPublic($ashramId,$admindata,$userdata)
	{
		if($this->session->userdata("defaultCurrency")=='')
		{
			$emptyRtn['total']=0;
			$emptyRtn['categories']=array();
			$emptyRtn['categories_poojas']=array();
			return $emptyRtn;
			exit;
		}
		$priceString='';
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($priceString!='') $priceString.=",";
			$priceString.='price_'.strtolower($cData['currency']);
		}
		$query1=$this->db;
		$query1->select("p.id as id,pooja_name,p.description,start_date,end_date,time_from,time_to,cutoff_type,cutoff_hour,cutoff_minutes,image,days, include_exclude_dates,exclude_dates,include_dates,name as category_name,c.description as category_description,c.allow_public_display as category_description_display,external_link,is_external_link,is_public_display,c.id as cid,".$priceString.", navagraha_pooja, is_poornaphala_seva, p.display_only_popup, p.popup_content");

		$query1->where("ashram_id",$ashramId);
		$query1->where("status",1);
		if(!empty($this->session->userdata("cart_items_from_seva_details")) && $this->session->userdata("cart_items_from_seva_details")["order_type"] == 1 && $this->session->userdata("cart_items_from_seva_details")["user_id"] && ($this->session->userdata("defaultCurrency") == $this->session->userdata("cart_items_from_seva_details")["currency"]) && ($this->session->userdata("poojasCartAshramIdSelection") == $this->session->userdata("cart_items_from_seva_details")["ashram_id"]))
        {
        	$query1->where("partial_payments_allowed",0);
        }
		if(isset($_GET['special_pooja']) && $_GET['special_pooja']=='navagraha-poojas')
		{
			$query1->where("navagraha_pooja",1);
		}
		else
		{
			$query1->where("navagraha_pooja",0);
		}
		
		if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("only_for_admin",0);
		}

		if(isset($userdata) || (isset($admindata) && $admindata->roles !=1 && $admindata->roles !=3 && $admindata->roles !=4) || (empty($admindata) && empty($userdata)))
			$query1->where("is_public_display",1);

		if(isset($_GET['s_key']) && $_GET['s_key']!='')
		{
			$query1->where("s_key",$_GET['s_key']);
		}
		else if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("s_key",null);
		}

		if(isset($_GET['item_key']) && $_GET['item_key']!='')
		{
			$query1->where("item_key",$_GET['item_key']);
		}

		$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
		$query1->where($displayCol,1);


		$query1->from($this->tableName." as p");
		$query1->join("poojas_categories as c","c.id=p.category","left");
		
		$dir='asc';

		$query1->order_by('c.order','asc');
		//$query1->order_by('start_date','asc');
		$query1->order_by('p.order','asc');

		$rtn['data']=$query1->get()->result_array();

		$c=0;

		$categories_poojas=[];
		$categories=[];
		$temp_cats=[];

		foreach ($rtn['data'] as $row)
		{
			$days=array_filter(explode(",",$row['days']));

			$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['start_date']=date("d M y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M y",strtotime($rtn['data'][$c]['end_date']));
			$rtn['data'][$c]['time_from']=date("h:i A",strtotime($rtn['data'][$c]['time_from']));
			$rtn['data'][$c]['time_to']=date("h:i A",strtotime($rtn['data'][$c]['time_to']));
			$rtn['data'][$c]['price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$rtn['data'][$c][$priceCol];
			if($rtn['data'][$c]['image']=='')
				$rtn['data'][$c]['image']=aws_s3_base_url."images/pooja_images/sample-pooja.jpg";
			else
				$rtn['data'][$c]['image']=aws_s3_base_url."images/pooja_images/thumb_".$rtn['data'][$c]['image'];

			if(count($days)==0 || count($days)==7)
			{
				$rtn['data'][$c]['days']='';
			}
			else
			{
				$rtn['data'][$c]['days']='(<b style="color:red;">Only on</b> ';
				$di=0;
				foreach ($days as $weekday)
				{
					if($di) $rtn['data'][$c]['days'].=", ";
					$rtn['data'][$c]['days'].=substr($weekday,0,3);
					$di++;
				}
				$rtn['data'][$c]['days'].=")";
			}

			$rtn['data'][$c]['item_status']=1;
			if(strtotime($row['end_date']." ".$row['time_to'])<=time())
				$rtn['data'][$c]['item_status']=0;


			$rtn['data'][$c]['include_dates_txt'] = '';
			if(isset($row['include_dates']) && $row['include_dates'] !='' && $row['include_dates'] != NULL)
			{
				$includeDts = explode(',', $row['include_dates']);
				usort($includeDts, array($this,'sortDatesByAscendingorder'));
				foreach($includeDts as $thisIncludeDt)
				{
					if($rtn['data'][$c]['include_dates_txt'] == '')
					{
						$rtn['data'][$c]['include_dates_txt'] .= date('j M Y (D)', strtotime($thisIncludeDt));
					} else {
						$rtn['data'][$c]['include_dates_txt'] .= '<br>'.date('j M Y (D)', strtotime($thisIncludeDt));
					}
				}
			}
			$rtn['data'][$c]['exclude_dates_txt'] = '';
			if(isset($row['exclude_dates']) && $row['exclude_dates'] !='' && $row['exclude_dates'] != NULL)
			{
				$excludeDts = explode(',', $row['exclude_dates']);
				usort($excludeDts, array($this,'sortDatesByAscendingorder'));
				foreach($excludeDts as $thisexcludeDt)
				{
					if($rtn['data'][$c]['exclude_dates_txt'] == '')
					{
						$rtn['data'][$c]['exclude_dates_txt'] .= date('j M Y (D)', strtotime($thisexcludeDt));
					} else {
						$rtn['data'][$c]['exclude_dates_txt'] .= '<br>'.date('j M Y (D)', strtotime($thisexcludeDt));
					}
				}
			}
			$cutoffTimeArr = $this->cutoffTimeCalculation($row['cutoff_type'], $row['cutoff_hour'], $row['cutoff_minutes'], $row['time_from'], $row['time_to']);

			if(isset($cutoffTimeArr['cutoff_time']))
			{
				$rtn['data'][$c]['cutoff_time'] = $cutoffTimeArr['cutoff_time'];
			}
			else
			{
				$rtn['data'][$c]['cutoff_time'] = '';
			}

			if(isset($cutoffTimeArr['cutoff_time_str']))
			{
				$rtn['data'][$c]['cutoff_time_str'] = $cutoffTimeArr['cutoff_time_str'];
			}
			else
			{
				$rtn['data'][$c]['cutoff_time_str'] = '';
			}

			if($rtn['data'][$c]['cutoff_time_str']!='')
			{
				if(isset($row['include_exclude_dates']) && $row['include_exclude_dates']=='IncludeDates' && isset($includeDts) && count($includeDts)>0)
				{
					$lastIncludeDate = end($includeDts);
					$lastIncludeDate = date('Y-m-d', strtotime($lastIncludeDate));
					if(strtotime($lastIncludeDate." ".$rtn['data'][$c]['cutoff_time'])<=time())
					{
						$rtn['data'][$c]['item_status']=0;
					}
				}
				if(isset($row['include_exclude_dates']) && $row['include_exclude_dates']=='ExcludeDates' && isset($excludeDts) && count($excludeDts)>0)
				{
					$lastExcludeDate = end($excludeDts);
					$lastExcludeDate = date('Y-m-d', strtotime($lastExcludeDate));
					if($lastExcludeDate==date('Y-m-d') && date('Y-m-d', strtotime($row['end_date']))==date('Y-m-d'))
					{
						$rtn['data'][$c]['item_status']=0;
					}
					else if(strtotime($row['end_date']." ".$rtn['data'][$c]['cutoff_time'])<=time())
					{
						$rtn['data'][$c]['item_status']=0;
					}
				}
				else if(strtotime($row['end_date']." ".$rtn['data'][$c]['cutoff_time'])<=time())
				{
					$rtn['data'][$c]['item_status']=0;
				}
			}



			$categories_poojas[$row['cid']][]=$rtn['data'][$c];
			if(empty(trim($row['category_description'])))
			{
				$d_category = "";
			}
			else
			{
				$d_category = $row['category_description'];
			}
			if(!in_array($row['cid'],$temp_cats))
			{
				$categories[]=array("id"=>$row['cid'],"category"=>$row['category_name'],"category_description"=>$d_category,"category_description_display"=>$row['category_description_display']);
				$temp_cats[]=$row['cid'];
			}
			$c++;
		}
		unset($rtn['data']);
		$rtn['total']=$c;
		$rtn['categories']=$categories;
		$rtn['categories_poojas']=$categories_poojas;
		return $rtn;
	}


	public function listPublicByPoojas($ashramId,$admindata,$userdata)
	{
		$priceString='';
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($priceString!='') $priceString.=",";
			$priceString.='price_'.strtolower($cData['currency']);
		}
		$query1=$this->db;
		$query1->select("p.id as id, pooja_name, p.description, start_date, end_date, time_from, time_to, cutoff_type, cutoff_hour, cutoff_minutes, image, days, include_exclude_dates, exclude_dates, include_dates, external_link, is_external_link, is_public_display,".$priceString.", navagraha_pooja, is_poornaphala_seva, p.display_only_popup, p.popup_content,p.attend_pooja_in_person,p.in_person_note");

		$query1->where("ashram_id",$ashramId);
		if(!empty($this->session->userdata("cart_items_from_seva_details")) && $this->session->userdata("cart_items_from_seva_details")["order_type"] == 1)
        {
        	$query1->where("partial_payments_allowed",0);
        }
		$query1->where("status",1);
		$query1->where("end_date>=",date('Y-m-d'));
		if(isset($_GET['special_pooja']) && $_GET['special_pooja']=='navagraha-poojas')
		{
			$query1->where("navagraha_pooja",1);
		}
		else
		{
			$query1->where("navagraha_pooja",0);
		}

		if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("only_for_admin",0);
		}

		if(isset($userdata) || (isset($admindata) && $admindata->roles !=1 && $admindata->roles !=3 && $admindata->roles !=4) || (empty($admindata) && empty($userdata)))
			$query1->where("is_public_display",1);

		if(isset($_GET['s_key']) && $_GET['s_key']!='')
		{
			$query1->where("s_key",$_GET['s_key']);
		}
		else if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("s_key",null);
		}

		if(isset($_GET['item_key']) && $_GET['item_key']!='')
		{
			$query1->where("item_key",$_GET['item_key']);
		}

		$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
		$query1->where($displayCol,1);


		$query1->from($this->tableName." as p");
		
		$dir='asc';
		$query1->order_by('p.start_date','asc');
		$query1->order_by('p.order','asc');
		$rtn['poojas']=$query1->get()->result_array();

		$c=0;
		foreach ($rtn['poojas'] as $row)
		{
			$rtn['poojas'][$c]['pooja_on_selected_date'] = '';
			$rtn['poojas'][$c]['time_from']=date("h:i A",strtotime($row['time_from']));
			$rtn['poojas'][$c]['time_to']=date("h:i A",strtotime($row['time_to']));
			$rtn['poojas'][$c]['pooja_dates'] = [];
			$rtn['poojas'][$c]['pooja_dates_arr'] = [];
			$rtn['poojas'][$c]['pooja_dates_item_status'] = [];
			$date_from = $row['start_date'];   
			$date_from = strtotime($date_from); 
			$date_to = $row['end_date'];  
			$date_to = strtotime($date_to);

			$datediff = $date_to - $date_from;
			$datediff = round($datediff / (60 * 60 * 24));

			$today_date = strtotime(date('y-m-d'));

			$todaydatediff = $date_to - $today_date;
			$todaydatediff = round($todaydatediff / (60 * 60 * 24));

			if($datediff > 30 && $todaydatediff>30)
			{
				$rtn['poojas'][$c]['pooja_dates'][] = date("d M y", $date_from).' - '.date("d M y", $date_to);
				$rtn['poojas'][$c]['pooja_dates_arr'][date("d M y", $date_from).' - '.date("d M y", $date_to)] = date("d M y", $date_from).' - '.date("d M y", $date_to);

				$rtn['poojas'][$c]['pooja_dates_item_status'][date("d M y", $date_from).' - '.date("d M y", $date_to)]=1;
				if(strtotime($row['end_date']." ".$row['time_to'])<=time())
					$rtn['poojas'][$c]['pooja_dates_item_status'][date("d M y", $date_from).' - '.date("d M y", $date_to)]=0;
			} else {
				// Loop from the start date to end date and output all dates inbetween  
				for($datestring=$date_from; $datestring<=$date_to; $datestring+=86400)
				{  
					$poojaIncludeDates = explode(',', $row['include_dates']);
					$poojaExcludeDates = explode(',', $row['exclude_dates']);
					if($row['include_exclude_dates'] == 'IncludeDates' && !in_array(date('d M Y', $datestring), $poojaIncludeDates) )
					{
						continue;
					}
					if($row['include_exclude_dates'] == 'ExcludeDates' && in_array(date('d M Y', $datestring), $poojaExcludeDates) )
					{
						continue;
					}
					if(strtotime(date('Y-m-d')) <= $datestring)
					{
						if($row['days']!='')
						{
							$weekdays=explode(",",$row['days']);
							if(in_array(date("l",$datestring),$weekdays))
							{
								$rtn['poojas'][$c]['pooja_dates'][] = date("Y-m-d", $datestring);
						    	$rtn['poojas'][$c]['pooja_on_selected_date'] = 'Yes';
						    	$rtn['poojas'][$c]['pooja_dates_arr'][date("Y-m-d", $datestring)] = date("d M y", $datestring);

						    	$rtn['poojas'][$c]['pooja_dates_item_status'][date("Y-m-d", $datestring)]=1;
								if(strtotime($row['end_date']." ".$row['time_to'])<=time())
								{
									$rtn['poojas'][$c]['pooja_dates_item_status'][date("Y-m-d", $datestring)]=0;
								}

								if( (date('Y-m-d', $datestring) == date('Y-m-d')) && (date('H:i:s')>=$row['time_to']) )
								{
									$rtn['poojas'][$c]['pooja_dates_item_status'][date("Y-m-d", $datestring)]=0;
								}
							}
						} else {
						    $rtn['poojas'][$c]['pooja_dates'][] = date("Y-m-d", $datestring);
						    $rtn['poojas'][$c]['pooja_on_selected_date'] = 'Yes';
						    $rtn['poojas'][$c]['pooja_dates_arr'][date("Y-m-d", $datestring)] = date("d M y", $datestring);

						    $rtn['poojas'][$c]['pooja_dates_item_status'][date("Y-m-d", $datestring)]=1;
								if(strtotime($row['end_date']." ".$row['time_to'])<=time())
								{
									$rtn['poojas'][$c]['pooja_dates_item_status'][date("Y-m-d", $datestring)]=0;
								}

								if( (date('Y-m-d', $datestring) == date('Y-m-d')) && (date('H:i:s')>=$row['time_to']) )
								{
									$rtn['poojas'][$c]['pooja_dates_item_status'][date("Y-m-d", $datestring)]=0;
								}
						}
					}
				}
			}
			

			$rtn['poojas'][$c]['start_date']=date("d M y",strtotime($row['start_date']));
			$rtn['poojas'][$c]['end_date']=date("d M y",strtotime($row['end_date']));
			$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));
			$rtn['poojas'][$c]['price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$row[$priceCol];
			if($row['image']=='')
				$rtn['poojas'][$c]['image']=aws_s3_base_url."images/pooja_images/sample-pooja.jpg";
			else
				$rtn['poojas'][$c]['image']=aws_s3_base_url."images/pooja_images/thumb_".$row['image'];

			$rtn['poojas'][$c]['item_status']=1;
			if(strtotime($row['end_date']." ".$row['time_to'])<=time())
				$rtn['poojas'][$c]['item_status']=0;

			$rtn['poojas'][$c]['include_dates_txt'] = '';
			if(isset($row['include_dates']) && $row['include_dates'] !='' && $row['include_dates'] != NULL)
			{
				$includeDts = explode(',', $row['include_dates']);
				usort($includeDts, array($this,'sortDatesByAscendingorder'));
				foreach($includeDts as $thisIncludeDt)
				{
					if($rtn['poojas'][$c]['include_dates_txt'] == '')
					{
						$rtn['poojas'][$c]['include_dates_txt'] .= date('j M Y (D)', strtotime($thisIncludeDt));
					} else {
						$rtn['poojas'][$c]['include_dates_txt'] .= '<br>'.date('j M Y (D)', strtotime($thisIncludeDt));
					}
				}
			}
			$rtn['poojas'][$c]['exclude_dates_txt'] = '';
			if(isset($row['exclude_dates']) && $row['exclude_dates'] !='' && $row['exclude_dates'] != NULL)
			{
				$excludeDts = explode(',', $row['exclude_dates']);
				usort($excludeDts, array($this,'sortDatesByAscendingorder'));
				foreach($excludeDts as $thisexcludeDt)
				{
					if($rtn['poojas'][$c]['exclude_dates_txt'] == '')
					{
						$rtn['poojas'][$c]['exclude_dates_txt'] .= date('j M Y (D)', strtotime($thisexcludeDt));
					} else {
						$rtn['poojas'][$c]['exclude_dates_txt'] .= '<br>'.date('j M Y (D)', strtotime($thisexcludeDt));
					}
				}
			}

			$cutoffTimeArr = $this->cutoffTimeCalculation($row['cutoff_type'], $row['cutoff_hour'], $row['cutoff_minutes'], $row['time_from'], $row['time_to']);

			if(isset($cutoffTimeArr['cutoff_time']))
			{
				$rtn['poojas'][$c]['cutoff_time'] = $cutoffTimeArr['cutoff_time'];
			}
			else
			{
				$rtn['poojas'][$c]['cutoff_time'] = '';
			}
			
			if(isset($cutoffTimeArr['cutoff_time_str']))
			{
				$rtn['poojas'][$c]['cutoff_time_str'] = $cutoffTimeArr['cutoff_time_str'];
			}
			else
			{
				$rtn['poojas'][$c]['cutoff_time_str'] = '';
			}

			if($rtn['poojas'][$c]['cutoff_time']!='')
			{
				if(isset($row['include_exclude_dates']) && $row['include_exclude_dates']=='IncludeDates' && isset($includeDts) && count($includeDts)>0)
				{
					$lastIncludeDate = end($includeDts);
					$lastIncludeDate = date('Y-m-d', strtotime($lastIncludeDate));
					if(strtotime($lastIncludeDate." ".$rtn['poojas'][$c]['cutoff_time'])<=time())
					{
						$rtn['poojas'][$c]['item_status']=0;
					}
				}
				else if(strtotime($row['end_date']." ".$rtn['poojas'][$c]['cutoff_time'])<=time())
					$rtn['poojas'][$c]['item_status']=0;
			}
			
			$c++;
		}
		$rtn['total']=$c;
		return $rtn;
	}


	public function listPublicByDate($ashramId,$admindata,$userdata)
	{
		$priceString='';
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($priceString!='') $priceString.=",";
			$priceString.='price_'.strtolower($cData['currency']);
		}
		$query1=$this->db;
		$query1->select("p.id as id, pooja_name, p.description, start_date, end_date, time_from, time_to, cutoff_type, cutoff_hour, cutoff_minutes, image, days, include_exclude_dates, exclude_dates, include_dates, external_link, is_external_link, is_public_display, ".$priceString.", navagraha_pooja, is_poornaphala_seva, p.display_only_popup, p.popup_content");

		$query1->where("ashram_id",$ashramId);
		$query1->where("status",1);
		if(!empty($this->session->userdata("cart_items_from_seva_details")) && $this->session->userdata("cart_items_from_seva_details")["order_type"] == 1)
        {
        	$query1->where("partial_payments_allowed",0);
        }
		if(isset($_GET['special_pooja']) && $_GET['special_pooja']=='navagraha-poojas')
		{
			$query1->where("navagraha_pooja",1);
		}
		else
		{
			$query1->where("navagraha_pooja",0);
		}
		
		if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("only_for_admin",0);
		}

		if(isset($userdata) || (isset($admindata) && $admindata->roles !=1 && $admindata->roles !=3 && $admindata->roles !=4) || (empty($admindata) && empty($userdata)))
			$query1->where("is_public_display",1);

		if(isset($_GET['s_key']) && $_GET['s_key']!='')
		{
			$query1->where("s_key",$_GET['s_key']);
		}
		else if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("s_key",null);
		}

		if(isset($_GET['item_key']) && $_GET['item_key']!='')
		{
			$query1->where("item_key",$_GET['item_key']);
		}

		$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
		$query1->where($displayCol,1);


		$query1->from($this->tableName." as p");
		
		$dir='asc';
		$query1->order_by('p.start_date','asc');
		$query1->order_by('p.order','asc');
		$poojas_res=$query1->get()->result_array();

		$pooja_dates = [];
		$c=0;
		foreach ($poojas_res as $row)
		{
			$date_from = $row['start_date'];   
			$date_from = strtotime($date_from); 
			$date_to = $row['end_date'];  
			$date_to = strtotime($date_to);  



			$datediff = $date_to - $date_from;
			$datediff = round($datediff / (60 * 60 * 24));

			$today_date = strtotime(date('y-m-d'));

			$todaydatediff = $date_to - $today_date;
			$todaydatediff = round($todaydatediff / (60 * 60 * 24));

			// if($todaydatediff>25)
			// {
			// 	// $pooja_dates[] = date("d M y", $date_from).' - '.date("d M y", $date_to);
			// } else {
				$dateof31stday = strtotime(date('Y-m-d') .' +31 day');
				for($datestring=$date_from; $datestring<=$date_to; $datestring+=86400)
				{  
					if($datestring>$dateof31stday)
					{
						continue;
					}
					if(strtotime(date('Y-m-d')) <= $datestring)
					{
						if($row['days']!='')
						{
							$weekdays=explode(",",$row['days']);
							if(in_array(date("l",$datestring),$weekdays))
							{
								$pooja_dates[] = date("d M y", $datestring);
							}
						} else {
						    $pooja_dates[] = date("d M y", $datestring);
						}
					}
				}
			// }
			$c++;
		}

		$tobereturn = [];
		$pooja_dates = array_unique($pooja_dates);
		if(count($pooja_dates)>0)
		{
			usort($pooja_dates, array($this,'compareDates'));
		}
		// echo '<pre>'; print_r($pooja_dates); die();
		$orderPoojaDates =[];
		$otherDates = [];
		foreach ($pooja_dates as $thisdate)
		{
			if(date('d M y', strtotime($thisdate)) === $thisdate)
			{
				$orderPoojaDates[] = $thisdate;
			} else {
				$otherDates[] = $thisdate;
			}
		}
		$orderPoojaDates = array_merge($orderPoojaDates,$otherDates);
		$d = 0; 
		if(count($orderPoojaDates)>0)
		{
			foreach($orderPoojaDates as $this_date)
			{
				foreach ($poojas_res as $row)
				{
					$pooja_datesarr = [];
					$date_from = $row['start_date'];   
					$date_from = strtotime($date_from); 
					$date_to = $row['end_date'];  
					$date_to = strtotime($date_to);  
					for($datestring=$date_from; $datestring<=$date_to; $datestring+=86400)
					{  
						if(strtotime(date('Y-m-d')) <= $datestring)
						{
							if($row['days']!='')
							{
								$weekdays=explode(",",$row['days']);
								if(in_array(date("l",$datestring),$weekdays))
								{
									$pooja_datesarr[] = date("d M y", $datestring);
								}
							} else {
							    $pooja_datesarr[] = date("d M y", $datestring);
							}
						}
					}
					$this_date_splits = explode(' - ', $this_date);
					// echo '<pre>'; print_r($this_date_splits);
					if( (isset($this_date_splits[1]) && (strtotime($this_date_splits[0])>=strtotime($row['start_date'])) && (strtotime($this_date_splits[1])<=strtotime($row['end_date']))) || (in_array($this_date, $pooja_datesarr)) )
					{
						if(count($this_date_splits)==1)
						{
							$poojaIncludeDates = explode(',', $row['include_dates']);
							$poojaExcludeDates = explode(',', $row['exclude_dates']);
							if($row['include_exclude_dates'] == 'IncludeDates' && !in_array(date('d M Y', strtotime($this_date)), $poojaIncludeDates) )
							{
								continue;
							}
							if($row['include_exclude_dates'] == 'ExcludeDates' && in_array(date('d M Y', strtotime($this_date)), $poojaExcludeDates) )
							{
								continue;
							}
						}
						$tobereturn[$d]['pooja_date'] = $this_date;

						$row['include_dates_txt'] = '';
						if(isset($row['include_dates']) && $row['include_dates'] !='' && $row['include_dates'] != NULL)
						{
							$includeDts = explode(',', $row['include_dates']);
							usort($includeDts, array($this,'sortDatesByAscendingorder'));
							foreach($includeDts as $thisIncludeDt)
							{
								if($row['include_dates_txt'] == '')
								{
									$row['include_dates_txt'] .= date('j M Y (D)', strtotime($thisIncludeDt));
								} else {
									$row['include_dates_txt'] .= '<br>'.date('j M Y (D)', strtotime($thisIncludeDt));
								}
							}
						}
						$row['exclude_dates_txt'] = '';
						if(isset($row['exclude_dates']) && $row['exclude_dates'] !='' && $row['exclude_dates'] != NULL)
						{
							$excludeDts = explode(',', $row['exclude_dates']);
							usort($excludeDts, array($this,'sortDatesByAscendingorder'));
							foreach($excludeDts as $thisexcludeDt)
							{
								if($row['exclude_dates_txt'] == '')
								{
									$row['exclude_dates_txt'] .= date('j M Y (D)', strtotime($thisexcludeDt));
								} else {
									$row['exclude_dates_txt'] .= '<br>'.date('j M Y (D)', strtotime($thisexcludeDt));
								}
							}
						}

						$cutoffTimeArr = $this->cutoffTimeCalculation($row['cutoff_type'], $row['cutoff_hour'], $row['cutoff_minutes'], $row['time_from'], $row['time_to']);

						if(isset($cutoffTimeArr['cutoff_time']))
						{
							$row['cutoff_time'] = $cutoffTimeArr['cutoff_time'];
						}
						else
						{
							$row['cutoff_time'] = '';
						}
						
						if(isset($cutoffTimeArr['cutoff_time_str']))
						{
							$row['cutoff_time_str'] = $cutoffTimeArr['cutoff_time_str'];
						}
						else
						{
							$row['cutoff_time_str'] = '';
						}


						$thispooja =  $row;
						$thispooja['pooja_for_the_day']=date('Y-m-d', strtotime($this_date));
						$thispooja['time_from']=date("h:i A",strtotime($row['time_from']));
						$thispooja['time_to']=date("h:i A",strtotime($row['time_to']));
						$thispooja['start_date']=date("d M y",strtotime($row['start_date']));
						$thispooja['end_date']=date("d M y",strtotime($row['end_date']));
						$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));
						$thispooja['price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$row[$priceCol];
						if($row['image']=='')
							$thispooja['image']=aws_s3_base_url."images/pooja_images/sample-pooja.jpg";
						else
							$thispooja['image']=aws_s3_base_url."images/pooja_images/thumb_".$row['image'];

						$thispooja['item_status']=1;
						

						if($row['cutoff_time']!='')
						{
							if(strtotime($this_date." ".$row['cutoff_time'])<=time())
								$thispooja['item_status']=0;
						}
						elseif(strtotime($this_date." ".$row['time_to'])<=time())
						{
							$thispooja['item_status']=0;
						}

						$tobereturn[$d]['poojas'][] = $thispooja;
					}

					
					
				}
				$d++;
			}
		}
		
		$rtn['total']=$c;
		$rtn['by_date'] = $tobereturn;
		return $rtn;
	}


	public function compareDates($date1, $date2)
	{
      if (strtotime($date1) > strtotime($date2))
         return 1;
      else if (strtotime($date1) < strtotime($date2))
         return -1;
      else
         return 0;
   	}

	public function listPublicApi($ashramId,$currency)
	{
		$priceString='';
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($priceString!='') $priceString.=",";
			$priceString.='price_'.strtolower($cData['currency']);
		}
		$query1=$this->db;
		$query1->select("p.id as id,pooja_name,p.description,start_date,end_date,time_from,time_to,cutoff_type,cutoff_hour,cutoff_minutes,image,days, include_exclude_dates, exclude_dates,include_dates,name as category_name,external_link,is_external_link,c.id as cid,".$priceString);

		$query1->where("ashram_id",$ashramId);
		$query1->where("status",1);
		if(isset($_GET['admin']) && $_GET['admin']==1)
		{

		}
		else
			$query1->where("only_for_admin",0);

		if(isset($_GET['s_key']) && $_GET['s_key']!='')
		{
			$query1->where("s_key",$_GET['s_key']);
		}
		else if(isset($admindata) && in_array($admindata->roles, [1,3,4,5,6,7,8,9,10,11,12,13,14]))
		{

		}
		else
		{
			$query1->where("s_key",null);
		}

		$displayCol=strtolower($currency)."_display";
		$query1->where($displayCol,1);


		$query1->from($this->tableName." as p");
		$query1->join("poojas_categories as c","c.id=p.category","left");
		
		$dir='asc';

		$query1->order_by('c.order','asc');
		//$query1->order_by('start_date','asc');
		$query1->order_by('p.order','asc');

		$rtn['data']=$query1->get()->result_array();

		$c=0;

		$categories_poojas=[];
		$categories=[];
		$temp_cats=[];

		foreach ($rtn['data'] as $row)
		{
			$days=array_filter(explode(",",$row['days']));

			$priceCol='price_'.strtolower($currency);
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['start_date']=date("d M Y",strtotime($rtn['data'][$c]['start_date']));
			$rtn['data'][$c]['end_date']=date("d M Y",strtotime($rtn['data'][$c]['end_date']));
			$rtn['data'][$c]['time_from']=date("h:i A",strtotime($rtn['data'][$c]['time_from']));
			$rtn['data'][$c]['time_to']=date("h:i A",strtotime($rtn['data'][$c]['time_to']));
			$rtn['data'][$c]['price']=strtoupper($currency)." ".$rtn['data'][$c][$priceCol];
			if($rtn['data'][$c]['image']=='')
				$rtn['data'][$c]['image']=aws_s3_base_url."images/pooja_images/sample-pooja.jpg";
			else
				$rtn['data'][$c]['image']=aws_s3_base_url."images/pooja_images/".$rtn['data'][$c]['image'];

			if(count($days)==0 || count($days)==7)
			{
				$rtn['data'][$c]['days']='';
			}
			else
			{
				$rtn['data'][$c]['days']='(<b style="color:red;">Only on</b> ';
				$di=0;
				foreach ($days as $weekday)
				{
					if($di) $rtn['data'][$c]['days'].=", ";
					$rtn['data'][$c]['days'].=substr($weekday,0,3);
					$di++;
				}
				$rtn['data'][$c]['days'].=")";
			}

			$rtn['data'][$c]['item_status']=1;
			if(strtotime($row['end_date']." ".$row['time_to'])<=time())
				$rtn['data'][$c]['item_status']=0;

			$categories_poojas[$row['cid']][]=$rtn['data'][$c];
			if(!in_array($row['cid'],$temp_cats))
			{
				$categories[]=array("id"=>$row['cid'],"category"=>$row['category_name']);
				$temp_cats[]=$row['cid'];
			}
			$c++;
		}
		unset($rtn['data']);
		$rtn['total']=$c;
		$rtn['categories']=$categories;
		$rtn['categories_poojas']=$categories_poojas;
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$poojasCategories=$this->poojas_categories_model->getList();
		$categories=array();
		foreach ($poojasCategories as $poojasCategory)
		{
			$categories[$poojasCategory->id]=$poojasCategory;
		}

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Pooja Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		foreach ($GLOBALS['currencies'] as $currencyData)
		{
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,
										"Price (".strtoupper($currencyData['currency'])." ".$currencyData['symbol'].")");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		}

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Category");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Visible From");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Visible To");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Start Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"End Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Included Days");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Included Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Excluded Dates");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Time From");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Time To");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Close Before (Min)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Prasadam");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Public Display");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"External Link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Partial Payments");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if(in_array(global_site_flag, [1]) && ($this->session->userdata("ashramId")==4))
		{
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Navagraha Pooja");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		}

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if($reportrow->shipping == 0){
				$reportrow->shipping = "No";
				
			} else {
				$reportrow->shipping = "Yes";
			}
			if($reportrow->is_external_link == 0){
				$reportrow->is_external_link = "No";
			} else {
				$reportrow->is_external_link = "Yes";
			}
			if($reportrow->is_public_display == 0){
				$reportrow->is_public_display = "No";
			} else {
				$reportrow->is_public_display = "Yes";
			}
			if($reportrow->navagraha_pooja == 1){
				$reportrow->navagraha_pooja = "Yes";
			} else {
				$reportrow->navagraha_pooja = "No";
			}
			if($reportrow->partial_payments_allowed == 0){
				$reportrow->partial_payments_allowed = "No";
			} else {
				$reportrow->partial_payments_allowed = "Yes";
			}
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pooja_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->description)));
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$priceCol="price_".strtolower($currencyData['currency']);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->$priceCol);
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$categories[$reportrow->category]->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->visible_from)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->visible_to)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->start_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->end_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->days);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->include_dates);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->exclude_dates);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->time_from)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->time_to)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cutoff_minutes." Mins");
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->shipping);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->is_public_display);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->is_external_link);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->partial_payments_allowed);
			if(in_array(global_site_flag, [1]) && ($this->session->userdata("ashramId")==4))
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->navagraha_pooja);
			}
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}


	public function checkPoojaItemKeyExists($name,$id)
	{
		$error=0;

		$this->db->where("item_key",$name);
		$this->db->where("id !=",$id);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function checkPoojaSecretKeyExists($name,$id)
	{
		$error=0;

		$this->db->where("s_key",$name);
		$this->db->where("id !=",$id);
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		return $error;
	}

	public function getPoornaPhalaPoojasByAshramId($ashramId)
	{
		$this->db->where("ashram_id",$ashramId);
		$this->db->where("is_poornaphala_seva",1);
		$this->db->order_by("status","desc");
		$this->db->order_by("pooja_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function listPublicSearchPoojas()
	{
		$i=0;
		$query1=$this->db;
		$query1->select("count(p.id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("pooja_name,ashram_id");
		}
		$query1->from($this->tableName." as p");
		$query1->join("ashrams as a","p.ashram_id = a.id");
		$query1->where("a.is_public_display",1);
		$query1->where("p.status",1);
		$query1->where("p.only_for_admin",0);
		$query1->where("p.is_public_display",1);
		$query1->where("p.s_key",null);
		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->group_start();
			$query1->like("p.pooja_name",$_POST['search_text']);
			$query1->or_like("p.description",$_POST['search_text']);
			$query1->group_end();
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$query1->order_by('p.order','asc');
		$query1->group_by('p.id');

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		return $rtn;
	}

	//get poojas ashram_id,category from poojas table
	public function getByAshramCategoryId($ashramId,$categoryId)
	{
		$this->db->where("ashram_id",$ashramId);
		if($categoryId != 'null' && $categoryId != NULL && $categoryId > 0)
			$this->db->where("category",$categoryId);
		$this->db->order_by("status","desc");
		$this->db->order_by("pooja_name","asc");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}
}
?>