<?PHP
class Ashrams_trust_accounts_Model extends CI_Model 
{
	var $tableName="ashrams_trust_accounts";
	var $basicDetailsTableName = "trust_basic_details";
	public function __construct()
	{
		parent::__construct();
	}
	public function trustData($id)
	{
		$this->db->select("a.*, b.trust_80g_year,c.logo as trust_logo");
		$this->db->from($this->tableName." as a");
		$this->db->join("trust_80g_years_note as b","b.id = a.trust_80g_year_id", "left");
		$this->db->join("trust_basic_details as c", "c.trust_basic_id=a.trust_basic_id", "left");
		$this->db->where("a.id",$id);
		$q=$this->db->get();
		return $q->row();
	}
	public function getAllTrustsBasicDetailsByAshramId($ashramId,$currency="")
	{
		$this->db->select("id,ashram_id,ashram_name,trust_name,account_for,currency,trust_status,trust_available");
		$this->db->where("ashram_id",$ashramId);
		if($currency!="")
		{
			$this->db->where("currency",$currency);
		}
		$this->db->order_by("trust_status","desc");
		$this->db->order_by("trust_name","asc");
		$q=$this->db->get($this->tableName);
		return $q->result();
	}
	public function getTrustsByAshramId($ashramId,$accountFor)
	{
		$this->db->select("a.*,b.logo as trust_logo");
		$this->db->from($this->tableName." as a");
		$this->db->join("trust_basic_details as b", "b.trust_basic_id=a.trust_basic_id", "left");
		$this->db->where("a.ashram_id",$ashramId);
		$this->db->where("a.account_for",$accountFor);
		$this->db->where('a.trust_status','1');
		$q=$this->db->get();
		return $q->result();
	}
	public function getTrustByAshramIdCurrency($ashramId,$currency)
	{
		$this->db->where("ashram_id",$ashramId);
		$this->db->where("currency",$currency);
		$this->db->where("account_for",1);
		$this->db->where('trust_status','1');
		$q=$this->db->get($this->tableName);
		return $q->row_array();
	}
	public function updateSettings($id,$colName,$value)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array($colName=>$value));
	}
	public function createTrustsForAshram($ashramId)
	{
		$currencies=$this->currencies_model->getByAshram(0);
		$ashramData=$this->ashrams_model->ashramData($ashramId);
		$ashram_name = "";
		if(isset($ashramData->name))
		{
			$ashram_name = $ashramData->name;
		}
		foreach ($currencies as $currency_row)
		{
			$this->db->insert($this->tableName,
								array
								(
									"ashram_id"=>$ashramId,
									"ashram_name"=>$ashram_name,
									"currency"=>strtolower($currency_row['currency']),
									"account_for"=>1,
									"trust_status"=>'1',
									"trust_available"=>'1'
								)
						);

			$this->db->insert($this->tableName,
								array
								(
									"ashram_id"=>$ashramId,
									"ashram_name"=>$ashram_name,
									"currency"=>strtolower($currency_row['currency']),
									"account_for"=>2,
									"trust_status"=>'1',
									"trust_available"=>'1'
								)
						);
			$this->db->insert($this->tableName,
								array
								(
									"ashram_id"=>$ashramId,
									"ashram_name"=>$ashram_name,
									"currency"=>strtolower($currency_row['currency']),
									"account_for"=>3,
									"trust_status"=>'1',
									"trust_available"=>'1'
								)
						);
			$this->db->insert($this->tableName,
								array
								(
									"ashram_id"=>$ashramId,
									"ashram_name"=>$ashram_name,
									"currency"=>strtolower($currency_row['currency']),
									"account_for"=>4,
									"trust_status"=>'1',
									"trust_available"=>'1'
								)
						);
		}
	}

	public function updateAshramNameToAssociatedTrustsOfAshram($ashramId)
	{
		$ashramData=$this->ashrams_model->ashramData($ashramId);
		if(isset($ashramData->name) && $ashramData->name!='')
		{
			$updateData['ashram_name'] = $ashramData->name;
			$this->db->where('ashram_id', $ashramId);
			$update=$this->db->update($this->tableName, $updateData);
		}

	}

	public function removeCredentials($trustData)
	{
		unset($trustData->ccavenue_merchant_id);
		unset($trustData->ccavenue_working_key);
		unset($trustData->ccavenue_access_code);
		unset($trustData->payu_merchantkey);
		unset($trustData->payu_salt);
		unset($trustData->paypal_email);
		unset($trustData->payflow_partner);
		unset($trustData->payflow_user);
		unset($trustData->payflow_pwd);
		unset($trustData->payflow_vendor);
		unset($trustData->razorpay_key);
		unset($trustData->razorpay_secret);
		unset($trustData->authorizenet_login);
		unset($trustData->authorizenet_key);
		unset($trustData->stripe_public_key);
		unset($trustData->stripe_secret_key);
		unset($trustData->account_type);
		unset($trustData->account_number);
		unset($trustData->account_for);

		return $trustData;
	}


	public function getAllTrustsByPaymentGateway($gateway='')
	{
		$this->db->where("payment_mode",$gateway);
		$q=$this->db->get($this->tableName);
		return $q->result_array();
	}


	/* for add / update Trust*/
	public function saveTrust($id)
	{
		$trust_idd = 0;
		$trustBasicData = $this->trustBasicDataById($_POST["trust_basic_id"]);
		$trust_name = $trustBasicData->trust_name;
		$description = $trustBasicData->description;
		$contact_person = $trustBasicData->contact_person;
		$address = $trustBasicData->address;
		$trust_footer = $trustBasicData->trust_footer;
		if(!$id)
		{
			$insertData = array('ashram_id' => $this->session->userdata("ashramId"),
								'ashram_name' => $this->general_model->filtertext(trim($_POST["name"])),
								'account_for' => $_POST["trustaccfor"],
								'currency' => $this->session->userdata("trustCurrency"),
								'trust_basic_id' => trim($_POST["trust_basic_id"]),
								'trust_name' => $trust_name,
								'description' => $description,
								'contact_person' => $contact_person,
								'address' => $address,
								'ccavenue_merchant_id' => $_POST["ccavenuemerchantid"],
								'ccavenue_working_key' => $_POST["ccavenueworkingkey"],
								'ccavenue_access_code' => $_POST["ccavenueaccesscode"],
								'payu_merchantkey' => $_POST["payumerchantkey"],
								'payu_salt' => $_POST["payusalt"],
								'paypal_email' => $_POST["paypalemail"],
								'payflow_partner' => $_POST["payflowpartner"],
								'payflow_user' => $_POST["payflowuser"],
								'payflow_pwd' => $_POST["payflowpassword"],
								'payflow_vendor' => $_POST["payflowvendor"],
								'razorpay_key' => $_POST["razorpaykey"],
								'razorpay_secret' => $_POST["razorpaysecret"],
								'authorizenet_login' => $_POST["authorizeuser"],
								'authorizenet_key' => $_POST["authorizekey"],
								'stripe_public_key' => $_POST["stripepublickey"],
								'stripe_secret_key' => $_POST["stripesecretkey"],
								'ashram_footer' => $trust_footer,
								'payflow_url' => $_POST["payflowurl"],
								'razorpay_failed_tx_report_emails' => $_POST["razorpayfailedtxreportemails"],
								'razorpay_webhook_secret_key' => $_POST["razorpaywebhooksecretkey"],
								'stripe_webhook_secret_key_inr' => $_POST["stripewebhooksecretkeyinr"],
								'stripe_webhook_secret_key_usd' => $_POST["stripewebhooksecretkeyusd"],
								'payu_url' => $_POST["payuurl"],
								'payu_get_url' => $_POST["payugeturl"],
								'payu_auth_key' => $_POST["payuauthkey"],
							);
			$save = $this->db->insert($this->tableName, $insertData);
			$trustid = $this->db->insert_id();
			if($trustid)
			{
				$this->createTrust80gYearNote($trustid);
				$trust_idd = $trustid;
			}
		} else {
			$updateData = array(
								'ashram_name' => $this->general_model->filtertext(trim($_POST["name"])),
								'trust_basic_id' => trim($_POST["trust_basic_id"]),
								'trust_name' => $trust_name,
								'description' => $description,
								'contact_person' => $contact_person,
								'address' => $address,
								'ccavenue_merchant_id' => $_POST["ccavenuemerchantid"],
								'ccavenue_working_key' => $_POST["ccavenueworkingkey"],
								'ccavenue_access_code' => $_POST["ccavenueaccesscode"],
								'payu_merchantkey' => $_POST["payumerchantkey"],
								'payu_salt' => $_POST["payusalt"],
								'paypal_email' => $_POST["paypalemail"],
								'payflow_partner' => $_POST["payflowpartner"],
								'payflow_user' => $_POST["payflowuser"],
								'payflow_pwd' => $_POST["payflowpassword"],
								'payflow_vendor' => $_POST["payflowvendor"],
								'razorpay_key' => $_POST["razorpaykey"],
								'razorpay_secret' => $_POST["razorpaysecret"],
								'authorizenet_login' => $_POST["authorizeuser"],
								'authorizenet_key' => $_POST["authorizekey"],
								'stripe_public_key' => $_POST["stripepublickey"],
								'stripe_secret_key' => $_POST["stripesecretkey"],
								'ashram_footer' => $trust_footer,
								'payflow_url' => $_POST["payflowurl"],
								'razorpay_failed_tx_report_emails' => $_POST["razorpayfailedtxreportemails"],
								'razorpay_webhook_secret_key' => $_POST["razorpaywebhooksecretkey"],
								'stripe_webhook_secret_key_inr' => $_POST["stripewebhooksecretkeyinr"],
								'stripe_webhook_secret_key_usd' => $_POST["stripewebhooksecretkeyusd"],
								'payu_url' => $_POST["payuurl"],
								'payu_get_url' => $_POST["payugeturl"],
								'payu_auth_key' => $_POST["payuauthkey"],
							);
			$this->db->where('id', $id);
			$update=$this->db->update($this->tableName, $updateData);
			if($update)
			{
				$trust_idd = $id;
			}
		}
		

		if($trust_idd)
		{
			return $trust_idd;
		}
		else
		{
			return false;
		}
	}
	/* for checking number of trusts for seva and currency*/
	public function getTrustsByAshramCurrency($currency=NULL,$seva=FALSE)
	{
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		if(!empty($currency))
			$this->db->where("currency",$currency);
		if($seva)
			$this->db->where("account_for",$seva);
		$q=$this->db->get($this->tableName);
		return $q->result_array();
	}
	/* for enable / disable Trust*/
	public function updateTrustStatus()
	{
		$currency=$_POST['currency'];
		$this->db->where('id',$_POST['id']);
		$this->db->where('trust_status','0');
		$result=$this->db->update($this->tableName,array('trust_available'=>$_POST['status']));
		if($result)
			return $currency;
		else
			return false;
	}
	/* for gettings Active Trust by Ashram and Currency*/
	public function getActiveTrustsByAshramIdCurrency($ashramId,$accountFor,$currency)
	{
		$this->db->where("ashram_id",$ashramId);
		$this->db->where("account_for",$accountFor);
		$this->db->where("currency",$currency);
		$this->db->where("trust_available",'1');
		$q=$this->db->get($this->tableName);
		return $q->result();
	}
	/* for add / update Trust Payment mode for Ashram */
	public function updateTrustPaymentmode()
	{
		if(!$this->session->userdata("trustCurrency") || !$this->session->userdata("ashramId"))
		{
			return false;
			exit;
		}
		$this->db->where("ashram_id",$this->session->userdata("ashramId"));
		$this->db->where("currency",$this->session->userdata("trustCurrency"));
		$this->db->update($this->tableName,array('trust_status'=>'0', 'payment_mode'=>''));

		if($_POST['pooja_gateway']!="")
		{
			$this->db->where("id",$_POST['pooja_trust']);
			$this->db->update($this->tableName,array('trust_status'=>'1','payment_mode'=>$_POST['pooja_gateway']));
		}

		if($_POST['donation_gateway']!="")
		{
			$this->db->where("id",$_POST['donation_trust']);
			$this->db->update($this->tableName,array('trust_status'=>'1','payment_mode'=>$_POST['donation_gateway']));
		}

		if($_POST['store_gateway']!="")
		{
			$this->db->where("id",$_POST['store_trust']);
			$this->db->update($this->tableName,array('trust_status'=>'1','payment_mode'=>$_POST['store_gateway']));
		}

		if($_POST['subscription_gateway']!="")
		{
			$this->db->where("id",$_POST['subscription_trust']);
			$this->db->update($this->tableName,array('trust_status'=>'1','payment_mode'=>$_POST['subscription_gateway']));
		}

		return true;
	}
	/* for exporting all Trusts by Ashram */
	public function exportTrusts()
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where('ashram_id',$this->session->userdata("ashramId"));
		$this->db->where('currency',$_POST['currency']);
		$sql=$this->db->get_compiled_select();
		$preData="\nCurrency: ";
		$preData.=$_POST['currency'];
		$requestResp=$this->excel_exports_model->makeRequest('default',"model","ashrams/ashrams_trust_accounts_model",$sql,$this->currentUser,"default",$_POST,"All Trusts",$preData);
		return $requestResp;
	}
	
	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->trustBasicDetailsExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
		}
		$j++;
		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ashram Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Trust Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Account For");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Contact Person");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if($reportrow->account_for==1)
				$reportrow->account_for='Poojas';
			if($reportrow->account_for==2)
				$reportrow->account_for='Donations';
			if($reportrow->account_for==3)
				$reportrow->account_for='Stores';
			if($reportrow->account_for==4)
				$reportrow->account_for='Subscriptions';

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ashram_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->trust_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->account_for);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->description)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_person);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,ucfirst((!$reportrow->payment_mode) ? 'N/A' : $reportrow->payment_mode));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function trustBasicDetailsExcelReportAdmin($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
		}
		$j++;
		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Basic Trust ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Basic Trust Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Trust Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Trust Contact Person");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Trust Currency");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Trust Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Trust Receipt Footer");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Year End Statement Text");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->trust_basic_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->trust_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->address)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_person);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->description)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->trust_footer)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,html_entity_decode(strip_tags($reportrow->year_end_statement_text)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function getTrust80gByTrustIdAndYear($trust_basic_id, $trust_80g_year)
	{
		$this->db->where("trust_basic_id",$trust_basic_id);
		$this->db->where('trust_80g_year',$trust_80g_year);
		$q=$this->db->get('trust_80g_years_note');
		return $q->row();
	}

	public function createTrust80gYearNote($trust_id)
	{
		if($trust_id>0)
		{
			$user_id= 0;
			if($this->session->userdata('loggedIn'))
			{
				if($this->session->userdata('id'))
					$user_id=$this->session->userdata('admin_data')->id;
				else
					$user_id=$this->session->userdata('user_data')->id;
			}
			$yearData = [];
            $y=date("Y");
            $y = ($y+1);
            for($i=2016;$i<=$y;$i++)
            {
                if(date("Y") == $i && date('m')>=4)
                {
                    $inrstartdate = $i."-".financial_year_start_month_date;
                    $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                    $inrenddate = ($i+1)."-".financial_year_end_month_date;
                    $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                    $yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;
                }
                else
                {
                    $inrstartdate = ($i-1)."-".financial_year_start_month_date;
                    $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                    $inrenddate = ($i)."-".financial_year_end_month_date;
                    $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                    $yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;
                }
            }
            $trustData = $this->trustData($trust_id);
            if(!empty($trustData))
            {
            	foreach($yearData as $key => $thisYear)
            	{
            		$this->db->where("trust_basic_id",$trustData->trust_basic_id);
					$this->db->where("trust_80g_year",$key);
					$q=$this->db->get('trust_80g_years_note');
					$checkYear80gExists = $q->result();
					if(empty($checkYear80gExists))
					{
	            		$trust80gYearData = [
	            								"trust_basic_id"=>$trustData->trust_basic_id,
	            								"trust_80g_year"=>$key,
	            								"trust_80g_note"=>$trustData->tax_80g_501c3,
	            								"created_by"=>$user_id,
	            								"created_on"=>date('Y-m-d H:i:s')
	            							];
	            		$this->db->insert('trust_80g_years_note', $trust80gYearData);
	            	}
            	}
            }
		}
	}

	public function updateTrust80gNote($trust_basic_id,$trust_80g_year,$trust_80g_note)
	{
		$user_id= 0;
		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
				$user_id=$this->session->userdata('admin_data')->id;
			else
				$user_id=$this->session->userdata('user_data')->id;
		}

		$checkYearNote = $this->getTrust80gByTrustIdAndYear($trust_basic_id, $trust_80g_year);
		if(empty($checkYearNote))
		{
			$trustBasicData = $this->trustBasicDataById($trust_basic_id);
            if(!empty($trustBasicData))
            {
				$trust80gYearData = [
	    								"trust_basic_id"=>$trustBasicData->trust_basic_id,
	    								"trust_80g_year"=>$trust_80g_year,
	    								"trust_80g_note"=>$trust_80g_note,
	    								"created_by"=>$user_id,
	    								"created_on"=>date('Y-m-d H:i:s')
	    							];
	    		$this->db->insert('trust_80g_years_note', $trust80gYearData);
	    		$lastInsertedId = $this->db->insert_id();
	    		$this->updateAshramTrustAccount80g($trust_basic_id,$lastInsertedId,$trust_80g_note);
	    	}
		}
		else
		{
			$this->db->where("trust_basic_id",$trust_basic_id);
			$this->db->where("trust_80g_year",$trust_80g_year);
			$this->db->update('trust_80g_years_note',array('trust_80g_note'=>$trust_80g_note, "modified_by"=>$user_id, "modified_on"=>date('Y-m-d H:i:s')));
			if(isset($checkYearNote->id) && $checkYearNote->id>0)
			{
    			$this->updateAshramTrustAccount80g($trust_basic_id,$checkYearNote->id,$trust_80g_note);
    		}
		}

		
	}


	public function trust80gYearsDataByTrustId($trust_id)
	{
		$this->db->where("trust_id",$trust_id);
		$this->db->order_by("trust_80g_year","desc");
		$q=$this->db->get("trust_80g_years_note");
		return $q->result();
	}

	public function trust80gYearsDataById($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->get("trust_80g_years_note");
		return $q->row();
	}

	public function updateAshramTrustAccount80g($trust_basic_id,$trust_80g_year_id,$trust_80g_note)
	{
		$trust80gDetails = $this->trust80gYearsDataById($trust_80g_year_id);
		$current80gYear = "";

		if(date('m')>=4)
        {
            $inrstartdate = date('Y')."-".financial_year_start_month_date;
            $inrenddate = (date('Y')+1)."-".financial_year_end_month_date;
            $current80gYear = $inrstartdate."_to_".$inrenddate;
        }
        else
        {
            $inrstartdate = (date('Y')-1)."-".financial_year_start_month_date;
            $inrenddate = (date('Y'))."-".financial_year_end_month_date;
            $current80gYear = $inrstartdate."_to_".$inrenddate;
        }

		if(isset($trust80gDetails->trust_80g_year) && ($trust80gDetails->trust_80g_year==$current80gYear))
		{
			$this->db->where("trust_basic_id",$trust_basic_id);
			$this->db->update($this->tableName,array('tax_80g_501c3'=>$trust_80g_note, 'trust_80g_year_id'=>$trust_80g_year_id));
		}
	}

	public function listTrustBasicDetailsAdmin($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(a.trust_basic_id) as c, GROUP_CONCAT(DISTINCT b.ashram_name SEPARATOR ',') as trust_ashrams");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("a.*, GROUP_CONCAT(DISTINCT b.ashram_name SEPARATOR ',') as trust_ashrams");
		}
		$query1->from($this->basicDetailsTableName." as a");
		$query1->join("ashrams_trust_accounts as b","b.trust_basic_id = a.trust_basic_id", "left");
		$query1->group_by('a.trust_basic_id');
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like("a.".$_POST['search_col'],trim($_POST['search_text']));
			$preData.=" containing ";
			$preData.='"'.$_POST['search_text'].'"';
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by("a.".$_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by("a.".$_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('a.trust_name',$_POST['dir']);
				else
					$query1->order_by('a.trust_name',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ashrams/ashrams_trust_accounts_model",$sql,$this->currentUser,"default",$_POST,"All Basic Trust Details",$preData,2);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get();

			$rtn['recordsTotal'] = $temp_result->num_rows();
			$rtn['recordsFiltered'] = $temp_result->num_rows();
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by("a.".$col_name,$dir);
			else
				$query1->order_by('a.trust_name',$dir);
		}
		else
		{
			$query1->order_by('a.trust_name',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;

			$rtn['data'][$c]['currency'] = strtoupper($rtn['data'][$c]['currency']);

			if(isset($rtn['data'][$c]['trust_ashrams']) && $rtn['data'][$c]['trust_ashrams']!='')
			{
				$trust_ashrams_arr = explode(',', $rtn['data'][$c]['trust_ashrams']);
				if(count($trust_ashrams_arr)>0)
				{
					$trustAshramNames = "";
					foreach($trust_ashrams_arr as $thisTrustAshram)
					{
						$trustAshramNames .= $thisTrustAshram."<br>";
					}
					$rtn['data'][$c]['trust_ashrams'] = $trustAshramNames;
				}
			}

			if(!$rtn['data'][$c]['logo'])
				$rtn['data'][$c]['trust_logo'] = aws_s3_base_url."images/site_assets/global_site_images/no-image.png";
			else
				$rtn['data'][$c]['trust_logo'] = aws_s3_base_url."images/trusts/trust_images/thumb_".$rtn['data'][$c]['logo'];
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function trustBasicDataById($id)
	{
		$this->db->where("trust_basic_id",$id);
		$q=$this->db->get($this->basicDetailsTableName);
		$result=$q->row();
		return $result;
	}


	public function saveTrustBasicDetails($id)
	{
		$user_id= 0;
		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
				$user_id=$this->session->userdata('admin_data')->id;
			else
				$user_id=$this->session->userdata('user_data')->id;
		}
		$trust_idd = 0;
		if(!$id)
		{
			$insertData = array('trust_name' => $this->general_model->filtertext(trim($_POST["trust_name"])),
								'contact_person' => $this->general_model->filtertext(trim($_POST["contact_person"])),
								'address' => $this->general_model->filtertext(trim($_POST["address"])),
								'currency' => trim($_POST["trust_currency"]),
								'description' => $this->general_model->filtertext(trim($_POST["description"])),
								'year_end_statement_text' => $this->general_model->filtertext(trim($_POST["year_end_statement_text"])),
								'trust_footer' => trim($_POST["trust_footer"]),
								"created_by"=>$user_id,
								"created_on"=>date('Y-m-d H:i:s')
							);
			$save = $this->db->insert($this->basicDetailsTableName, $insertData);
			$trust_idd = $this->db->insert_id();
		} else {
			$updateData = array(
								'trust_name' => $this->general_model->filtertext(trim($_POST["trust_name"])),
								'contact_person' => $this->general_model->filtertext(trim($_POST["contact_person"])),
								'address' => $this->general_model->filtertext(trim($_POST["address"])),
								'description' => $this->general_model->filtertext(trim($_POST["description"])),
								'year_end_statement_text' => $this->general_model->filtertext(trim($_POST["year_end_statement_text"])),
								'trust_footer' => trim($_POST["trust_footer"]),
								"modified_by"=>$user_id,
								"modified_on"=>date('Y-m-d H:i:s')
							);
			$this->db->where('trust_basic_id', $id);
			$update=$this->db->update($this->basicDetailsTableName, $updateData);
			if($update)
			{
				$trust_idd = $id;
				$this->updateTrustBasicDetailsToAshramsTrustAccounts($trust_idd);
			}
		}

		if($id)
		{
			$trustBasicDetails = $this->trustBasicDataById($id);
			if($trustBasicDetails->logo!='' && !isset($_POST['imgupl']))
			{
				$this->db->where("trust_basic_id",$id);
				$this->db->update($this->basicDetailsTableName,array('logo'=>''));
				$path=aws_s3_base_url."/images/trusts/trust_images/".$trustBasicDetails->logo;
				if(file_exists($path))
					unlink($path);
				$thumbPath=aws_s3_base_url."/images/trusts/trust_images/thumb_".$trustBasicDetails->logo;
				if(file_exists($thumbPath))
					unlink($thumbPath);
			}
		}

		if(isset($_FILES['trust_logo']))
		if($_FILES['trust_logo']['name']!='')
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$name=$_FILES['trust_logo']['name'];
			$ext=pathinfo ($_FILES['trust_logo']['name'],PATHINFO_EXTENSION);			
			
			$newName="trust_".$trust_idd."_".substr(md5(mt_rand()), 0, 16).".".$ext;
			$tempPath=$_FILES['trust_logo']['tmp_name'];
			$tempName=basename($_FILES['trust_logo']['tmp_name']);
			$thumbName="thumb_".$newName;
			$thumbPath=str_replace($tempName, $thumbName, $tempPath);
			$this->general_model->create_thumb_150($tempPath,$thumbPath);
			
			$image = new SimpleImage();
			$image->load($tempPath);
			$img_width=$image->getWidth();
	    	$img_height=$image->getHeight();
	    	$ratio=$img_width/$img_height;
	      
			if($ratio>=1)
			{
				if($img_width>800)
					$image->resizeToWidth(800);
			}
			else
			{
				if($img_height>800)
					$image->resizeToHeight(800);
			}
			$image->save($tempPath);
			
			$amazonUri="images/trusts/trust_images/";
			$amazonUriThumb="images/trusts/trust_images/thumb_".$newName;
			$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newName,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($thumbPath,aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());

			$this->db->where("trust_basic_id",$trust_idd);
			$this->db->update($this->basicDetailsTableName,array('logo'=>$newName));
			
		}
		
		if($trust_idd)
		{
			return $trust_idd;
		}
		else
		{
			return false;
		}
	}

	public function getAllBasciTrusts($currency="")
	{
		$this->db->select("*");
		if($currency!="")
		{
			$this->db->where("currency",$currency);
		}
		$this->db->order_by("trust_name","asc");
		$q=$this->db->get($this->basicDetailsTableName);
		return $q->result();
	}

	public function checkTrustBasicName($name,$id,$currency)
	{
		$error=0;
		$this->db->where("trust_name",$name);
		$this->db->where("trust_basic_id !=",$id);
		$this->db->where("currency !=",strtolower($currency));
		$q=$this->db->get($this->basicDetailsTableName);
		if($q->num_rows())
		{
			$error=1;
		}
		return $error;
	}

	public function checkTrustBasicIdExists($id)
	{
		$error=0;
		$this->db->where("trust_basic_id",$id);
		$q=$this->db->get($this->basicDetailsTableName);
		if($q->num_rows())
		{
			$error=1;
		}
		return $error;
	}

	public function updateTrustBasicDetailsToAshramsTrustAccounts($trust_basic_id)
	{
		$trustBasicDetails = $this->trustBasicDataById($trust_basic_id);
		if(!empty($trustBasicDetails))
		{
			$updateData = [
							"trust_name" => $trustBasicDetails->trust_name,
							"description" => $trustBasicDetails->description,
							"contact_person" => $trustBasicDetails->contact_person,
							"address" => $trustBasicDetails->address,
							"ashram_footer" => $trustBasicDetails->trust_footer,
						];
			$this->db->where("trust_basic_id",$trust_basic_id);
			$this->db->update($this->tableName,$updateData);
		}
	}
}
?>