<?PHP
class Announcements_Model extends CI_Model 
{
	var $tableName="announcements";
	var $siteServivcesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->siteServivcesDb = $this->load->database("site_services",true,false);
	}
	public function announcementData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->get($this->tableName);
		$result=$q->row();
		return $result;
	}

	public function getYearMonths($ashramId)
	{
		$this->siteServivcesDb->select("year,month");
		$this->siteServivcesDb->where("ashram_id",$ashramId);
		$this->siteServivcesDb->where("published_on <=",date("Y:m:d"));
		$this->siteServivcesDb->group_by("year, month");
		$this->siteServivcesDb->order_by("year","desc");
		$this->siteServivcesDb->order_by("month","asc");
		$q=$this->siteServivcesDb->get($this->tableName);
		$result['years']=array();
		$result['months']=array();
		foreach ($q->result() as $row)
		{
			if(!in_array($row->year,$result['years']))
			{
				$result['years'][]=$row->year;
			}
			$result['months'][$row->year][]=$row->month;
		}
		return $result;
	}

	public function listPublic($ashramId)
	{
		$years=$this->getYearMonths($ashramId);
		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			//$query1->select("title,content,published_on,month,year");
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$this->siteServivcesDb->where("ashram_id",$ashramId);
		$this->siteServivcesDb->where("status",1);

		$this->siteServivcesDb->where("published_on <=",date("Y:m:d"));
		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->like('title',trim($_POST['search_text']));
		}


		if(isset($_POST['year']) && is_numeric($_POST['year']))
		{
			$query1->where("year",$_POST['year']);
		}
		else
		{
			if(count($years['years']))
				$query1->where("year",$years[0]->year);
			else
				$query1->where("year",0);
		}

		if(isset($_POST['month']) && is_numeric($_POST['month']))
		{
			$query1->where("month",$_POST['month']);
		}

		$per_page=10;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];
			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}

		$query1->order_by('published_on','desc');

		$start=0;
		$length=10;
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}
		/*if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}*/
		/*if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}*/
		
		//$query1->limit($length,$start);
		$query1->limit($per_page,$n);
		$rtn['data']=$query1->get()->result_array();

		$colors=array("red","blue","orange","green","purple");
		$c=0;
		$ii=0;
		//$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			if($ii==5)
				$ii=0;
			$rtn['data'][$c]=$row;
			//$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['color']=$colors[$ii];
			$rtn['data'][$c]['published_on']=date("d M Y",strtotime($rtn['data'][$c]['published_on']));
			//$sno++;
			$c++;
			$ii++;
		}
		return $rtn;
	}

	public function listAdmin($ashramId,$excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->where("ashram_id",$ashramId);
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			/* if($_POST['wild']=='contains')
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
			else if($_POST['wild']=='starts')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
			else if($_POST['wild']=='ends')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before'); */
		}

		$preData.="\nAnnouncement Status:";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1)))
		{
			if($_POST['status']==0)
			{
				$query1->where("status",0);
				$preData.="Inactive";
			}
			else
			{
				$query1->where("status",1);
				$preData.="Active";
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('published_on',$_POST['dir']);
				else
					$query1->order_by('published_on',"desc");
			}
			/*$requestResp=$this->excelexport_model->makeRequest($this->service,"model","deals/deals_model",$query1,$this->currentUser,"deals",$_POST,"All Calendar pages",$preData);*/
			//return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('published_on',$dir);
		}
		else
		{
			$query1->order_by('published_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['published_on']=date("d M Y",strtotime($rtn['data'][$c]['published_on']));
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['created_on']));
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function delete($id,$announcementData)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->delete($this->tableName);
		return 1;
	}

	public function changeStatus($id,$status)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array("status"=>$status));
	}

	public function save($id,$announcementData)
	{
		if(!$id)
		{
			$q=$this->siteServivcesDb->insert($this->tableName,
                                array(
                                	'title' => $this->general_model->filtertext(trim($_POST["title"])),
									'content' => $this->general_model->filtertext(trim($_POST["content"])),
									'ashram_id' => $this->session->userdata("ashramId"),
									'created_on'=>date("Y:m:d H:i:s"),
									'published_on'=>date("Y:m:d",strtotime($_POST['published_on'])),
									'year'=>date("Y",strtotime($_POST["published_on"])),
									'month'=>strtolower(date("m",strtotime($_POST["published_on"]))),
									'status'=>1
								)
								);
			$idd=$this->siteServivcesDb->insert_id();
		}
		else
		{
			$this->siteServivcesDb->where('id', $id);
			$q=$this->siteServivcesDb->update($this->tableName,
                                array(
                                	'title' => $this->general_model->filtertext(trim($_POST["title"])),
									'content' => $this->general_model->filtertext(trim($_POST["content"])),
									'published_on'=>date("Y:m:d",strtotime($_POST['published_on'])),
									'year'=>date("Y",strtotime($_POST["published_on"])),
									'month'=>strtolower(date("m",strtotime($_POST["published_on"]))),
									'status'=>1
								)
								);
			$idd=$id;
		}

		if($q)
			return $idd;
		else
			return 0;
	}
}
?>