<?PHP
class Appji_Model extends CI_Model 
{
	public function checkAppjiAshramExists($ashram_id = 0)
	{
		$exists = 0;
		if($ashram_id>0)
		{
			$this->db->where("id",$ashram_id);
			$q=$this->db->get('ashrams');
			if($q->num_rows())
			{
				$exists=1;
			}
		}
		return $exists;
	}

	public function checkAppjiDonationExists($ashram_id = 0, $donation_id = 0)
	{
		$exists = 0;
		if($ashram_id>0 && $donation_id>0)
		{
			$this->db->where("id",$donation_id);
			$this->db->where("ashram_id",$ashram_id);
			$q=$this->db->get('donations');
			if($q->num_rows())
			{
				$exists=1;
			}
		}
		return $exists;
	}

	public function createdonationLink($postData,$linkToken)
	{
		$linkurl = base_url().'donations/appji_donation/'.$linkToken;
		$insertData = [
					'donationCurrency' => strtolower($postData['donationCurrency']),
					'donationAmount' => $postData['donationAmount'],
					'ashramId' => appji_ashram_id,
					'donationId' => appji_donation_id,
					'appjiEmail' => $postData['appjiEmail'],
					'appjiUserFullName' => $postData['appjiUserFullName'],
					'linkToken' => $linkToken,
					'isSubscription' => "No",
					'linkExpiryTime' => $postData['expiryTime'],
					'donationLinkCreatedOn' => date('Y-m-d H:i:s')
					];
		$this->db->insert("appji_donations_links",$insertData);
		return $linkurl;
	}

	public function donationLinkDetailsByLinkToken($linkToken)
	{
		$this->db->where_in("linkToken",$linkToken);
		$q=$this->db->get('appji_donations_links');
		$result=$q->row_array();
		return $result;
	}

	public function checkAppjiSubscriptionExists($ashram_id = 0, $subscription_id = 0)
	{
		$exists = 0;
		if($ashram_id>0 && $subscription_id>0)
		{
			$this->db->where("id",$subscription_id);
			$this->db->where("ashram_id",$ashram_id);
			$q=$this->db->get('subscriptions');
			if($q->num_rows())
			{
				$exists=1;
			}
		}
		return $exists;
	}

	public function createsubscriptionLink($postData,$linkToken)
	{
		$linkurl = base_url().'subscriptions/appji_subscription/'.$linkToken;
		$insertData = [
					'subscriptionCurrency' => strtolower($postData['subscriptionCurrency']),
					'subscriptionAmount' => $postData['subscriptionAmount'],
					'ashramId' => appji_ashram_id,
					'subscriptionId' => appji_subscription_id,
					'appjiEmail' => $postData['appjiEmail'],
					'appjiUserFullName' => $postData['appjiUserFullName'],
					'linkToken' => $linkToken,
					'subscriptionPeriod' => $postData['subscriptionPeriod'],
					'linkExpiryTime' => $postData['expiryTime'],
					'subscriptionLinkCreatedOn' => date('Y-m-d H:i:s')
					];
		$this->db->insert("appji_subscriptions_links",$insertData);
		return $linkurl;
	}

	public function subscriptionLinkDetailsByLinkToken($linkToken)
	{
		$this->db->where_in("linkToken",$linkToken);
		$q=$this->db->get('appji_subscriptions_links');
		$result=$q->row_array();
		return $result;
	}
}
?>