<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Userutil_model extends CI_Model
{
	var $auth_check="";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("users_model");
		$this->auth_check=$this->load->database("sso_auth",true);
	}

	public function saveadminuser($id=0)
	{
		if($_POST['admin_user_check'] == "2")
    	{
    		$_POST['satsang_id'] = 0;
    	}
    	else if($_POST['admin_user_check'] == "3")
    	{
    		$_POST['ashram_id'] = 0;
    	}
    	else
    	{
    		$_POST['ashram_id'] = 0;
    		$_POST['satsang_id'] = 0;
    	}
    	$is_currency_specific = 0;
    	$currencies = '';
    	if(isset($_POST['currency_specific']) && $_POST['currency_specific'] ==1)
    	{
    		$is_currency_specific = 1;
    		if(isset($_POST['currencies']) && count($_POST['currencies'])>0)
    		{
    			$currencies = implode(',', $_POST['currencies']);
    		}
    	}
		if($id==0)
        {
        	$this->auth_check->insert('users',
	                        array(
	                        	'username' => trim($_POST['username']),
								'pass_hash' => $this->users_model->generatePasswordHash($_POST['password']),
								'firstname' => ucwords(strtolower(trim($_POST['firstname']))),
								'middlename' => ucwords(strtolower(trim($_POST['middlename']))),
								'lastname' => ucwords(strtolower(trim($_POST['lastname']))),
								'email' => strtolower(trim($_POST['email'])),
								"phoneno"=>trim($_POST['phone']),
								'registered_on' => date("Y:m:d H:i:s"),
								'role'=>0,
								'admin'=>1,
								"registered_site"=>registered_from,
								'registered_from_ip'=>$_SERVER['REMOTE_ADDR'],
								'status'=>1,
								'roles'=>$_POST['roles'],
								'ashram_id'=>$_POST['ashram_id'],
								'satsang_id'=>$_POST['satsang_id'],
								'created_by'=>$this->currentUser->id,
								'email_verified'=>1,
								'is_currency_specific'=>$is_currency_specific,
								'currencies'=>$currencies,
								'status'=>1
								)
							);
            $idd=$this->auth_check->insert_id();
            $datta_id = date("Y").$idd;
            $this->auth_check->where("id", $idd);
			$this->auth_check->update('users', array('datta_unique_id' => $datta_id) );
            $this->db->insert('users',
	                        array(
	                        	'username' => trim($_POST['username']),
	                        	"sso_user_id"=>$idd,
								'pass_hash' => $this->users_model->generatePasswordHash($_POST['password']),
								'firstname' => ucwords(strtolower(trim($_POST['firstname']))),
								'middlename' => ucwords(strtolower(trim($_POST['middlename']))),
								'lastname' => ucwords(strtolower(trim($_POST['lastname']))),
								'email' => strtolower(trim($_POST['email'])),
								"phoneno"=>trim($_POST['phone']),
								'registered_on' => date("Y:m:d H:i:s"),
								'role'=>0,
								'admin'=>1,
								"registered_site"=>registered_from,
								'registered_from_ip'=>$_SERVER['REMOTE_ADDR'],
								'status'=>1,
								'roles'=>$_POST['roles'],
								'ashram_id'=>$_POST['ashram_id'],
								'satsang_id'=>$_POST['satsang_id'],
								'created_by'=>$this->currentUser->id,
								'email_verified'=>1,
								'is_currency_specific'=>$is_currency_specific,
								'currencies'=>$currencies,
								'status'=>1
								)
							);
            $idd=$this->db->insert_id();
        }
        else
        {
        	$data = $this->users_model->userData($id);
            $this->auth_check->where("id",$data->sso_user_id);
            $query = $this->auth_check->update('users',
                                array(
                                'username' => trim($_POST['username']),
			                    'firstname' => ucwords(strtolower(trim($_POST['firstname']))),
								'lastname' => ucwords(strtolower(trim($_POST['lastname']))),
								'email' => strtolower(trim($_POST['email'])),
								"phoneno"=>trim($_POST['phone']),
								'roles'=>$_POST['roles'],
								'ashram_id'=>$_POST['ashram_id'],
								'satsang_id'=>$_POST['satsang_id'],
								'is_currency_specific'=>$is_currency_specific,
								'currencies'=>$currencies,
                                ));
            $this->db->where("id",$id);
            $query = $this->db->update('users',
                                array(
                                'username' => trim($_POST['username']),
			                    'firstname' => ucwords(strtolower(trim($_POST['firstname']))),
								'lastname' => ucwords(strtolower(trim($_POST['lastname']))),
								'email' => strtolower(trim($_POST['email'])),
								"phoneno"=>trim($_POST['phone']),
								'roles'=>$_POST['roles'],
								'ashram_id'=>$_POST['ashram_id'],
								'satsang_id'=>$_POST['satsang_id'],
								'is_currency_specific'=>$is_currency_specific,
								'currencies'=>$currencies,
                                ));
            $idd=$id;

            $this->load->library("dattaid_api");
        	$response = $this->dattaid_api->call($data->sso_user_id);
        }
		return $idd;
	}

	public function registeruser($infoArray,$byAdmin=0)
	{
		try
		{
			$country_name='';
			if($infoArray['country']!='')
			{
				$countryData=$this->locations_model->getCountryByCode($infoArray['country']);
				$country_name=$countryData->country_name;
			}
			$emailId=$infoArray['email'];

			$zipcode = "";
			if(!empty($infoArray['zip']))
				$zipcode = $infoArray['zip'];

			$emailParts=explode("@",$infoArray['email']);
			$emailVerified=0;
			$status=0;
			if("@".$emailParts[1]==no_email_domain)
			{
				$emailVerified=1;
				$status=1;
			}
			$block_sms = 0;
			if(!empty($_POST['prefill-user-id']) && $_POST['prefill-user-id'] == "on" && !empty($_POST['prefill-phone']) && $_POST['prefill-phone'] == "on")
        	{
        		$block_sms = 1;
        	}
			$this->auth_check->insert('users',
	                        array(
	                        	'username' => trim($infoArray['username']),
								'pass_hash' => $this->users_model->generatePasswordHash($infoArray['password']),
								'firstname' => ucwords(strtolower(trim($infoArray['firstname']))),
								'middlename' => ucwords(strtolower(trim($infoArray['middlename']))),
								'lastname' => ucwords(strtolower(trim($infoArray['lastname']))),
								'email' => strtolower(trim($infoArray['email'])),
								"zipcode"=>trim($zipcode),
								"phoneno"=>trim($infoArray['phone']),
								"pan_number"=>trim(@$_POST['pan_number']),
								"country_id"=>trim($infoArray['country']),
								'country'=>$country_name,
								'registered_on' => date("Y:m:d H:i:s"),
								'role'=>0,
								'block_sms'=>$block_sms,
								'conf_key'=>random_string('alnum',20),
								'admin'=>0,
								"registered_site"=>registered_from,
								'registered_from_ip'=>$_SERVER['REMOTE_ADDR'],
								'status'=>0,
								'roles'=>2,
								'created_by'=>$byAdmin,
								'email_verified'=>$emailVerified,
								'status'=>$status,
								"user_type"=>!empty($infoArray['user_type'])?$infoArray['user_type']:"direct"
								)
							);
			$uid=$this->auth_check->insert_id();

			if(!empty($infoArray['user_type']) && $infoArray['user_type'] == "import")
			{
				$this->load->model("subscriptions/donors_model");
				$this->donors_model->createDefault($uid);
			}
			if("@".$emailParts[1]==no_email_domain)
			{
				$this->load->model("subscriptions/donors_model");
				$this->donors_model->createDefault($uid);
			}
			$datta_id = date("Y").$uid;
			$subscribe_name=trim($infoArray['firstname'])." ".trim($infoArray['lastname']);
			$subscribe_email=trim($infoArray['email']);
			$this->subscriptions_email_model->subscribe(array("subscribe_name1"=>$subscribe_name,"subscribe_email"=>$subscribe_email,"country_code1"=>trim($infoArray['country'])),0);
			$this->sendRegisteredEmail($uid);

			//If a user added from bulk import update user status to 1 and email_verify flag to 1
			if(!empty($uid))
			{
				$u_type = !empty($infoArray['user_type'])?$infoArray['user_type']:"direct";
				if($u_type == "import")
				{
					$this->auth_check->where("id", $uid);
					$q=$this->auth_check->update('users',
							array('status' => 1,'email_verified'=>1)
							);
				}

				$this->auth_check->where("id", $uid);
				$q=$this->auth_check->update('users', array('datta_unique_id' => $datta_id,"site_flag_".global_site_flag=>1) );
			}
			$ouid = $this->InsertOwnUser($uid);
			return $ouid;
		}
		catch(Exception $e)
		{
			return 0;
		}
	}

	public function InsertOwnUser($id)
	{
		$data = $this->userDatabyId($id);
		$this->db->insert('users',
	                        array(
	                        	'username' => $data->username,
	                        	'sso_user_id'=>$data->id,
								'pass_hash' => $data->pass_hash,
								'firstname' => $data->firstname,
								'middlename' => $data->middlename,
								'lastname' => $data->lastname,
								'email' =>$data->email,
								"zipcode"=>$data->zipcode,
								"phoneno"=>$data->phoneno,
								"pan_number"=>$data->pan_number,
								"country_id"=>$data->country_id,
								'country'=>$data->country,
								'registered_on' => $data->registered_on,
								'role'=>0,
								'conf_key'=>$data->conf_key,
								'admin'=>$data->admin,
								"registered_site"=>$data->registered_site,
								'registered_from_ip'=>$data->registered_from_ip,
								'roles'=>$data->roles,
								'block_sms'=>$data->block_sms,
								'created_by'=>$data->created_by,
								'email_verified'=>$data->email_verified,
								'status'=>$data->status,
								"user_type"=>$data->user_type,
								)
							);
		$uid=$this->db->insert_id();
		$this->db->where("id", $uid);
		$q=$this->db->update('users', array("site_flag_".global_site_flag=>1) );
		return $uid;
	}

	public function getUserData($id)
	{
		$this->db->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,gender,dob,address,address1,address2,country_id,state_id,city_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,pan_number,block_sms");
		$q= $this->db->get_where('users', array('id' => $id,"deleted"=>0));
		if($q->num_rows())
			return $q->row();
		else
			return array();
	}

	public function userDatabyId($id)
	{
		$this->auth_check->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,gender,dob,address,address1,address2,country_id,state_id,city_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,pass_hash,registered_on,conf_key,registered_site,registered_from_ip,created_by,user_type,pan_number,block_sms");
		$q= $this->auth_check->get_where('users', array('id' => $id,"deleted"=>0));
		if($q->num_rows())
			return $q->row();
		else
			return array();
	}

	public function localuserDatabyId($id)
	{
		$this->db->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,gender,dob,address,address1,address2,country_id,state_id,city_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,pass_hash,registered_on,conf_key,registered_site,registered_from_ip,created_by,user_type,pan_number,block_sms");
		$q= $this->db->get_where('users', array('id' => $id,"deleted"=>0));
		if($q->num_rows())
			return $q->row();
		else
			return array();
	}

	public function getUserDataByUsername($username)
	{
		$this->db->where("username",$username);
		$this->db->where("deleted",0);
		$q= $this->db->get('users');
		if($q->num_rows())
			return $q->row();
		else
			return array();
	}
	public function verifyEmail($email,$uid)
	{
		$this->load->model("emails_sns_notifications_model");
    	$bounceCheck = $this->emails_sns_notifications_model->checkExistBounceMail($email);
		if(is_numeric($uid) && $email!='')
		{
			$this->auth_check->where("id !=",$uid);
			$this->auth_check->where('email',$email);
			$vr=$this->auth_check->get("users");
			if($vr->num_rows())
			{
				return 1;
			}
			if($bounceCheck["status"] == 1)
	        {
	        	return 2;
	        }
			else return 0;
		}
		else
			return 0;
	}
	public function verifyUsername($username,$uid)
	{
		if(is_numeric($uid) && $username!='')
		{
			$this->auth_check->where("id !=",$uid);
			$this->auth_check->where('username',$username);
			$vr=$this->auth_check->get("users");
			if($vr->num_rows())
				return 1;
			else return 0;
		}
		else
			return 0;
	}

    public function updateSecurityQuestions($uid,$vars)
    {
    	$userData=$this->getUserData($uid);
    	if(!empty($userData))
    	{
    		if($userData->security_complete)
    		{
    			$this->db->where("user_id",$uid);
				$this->db->delete("user_security_questions");
			}
			
			$this->db->insert('user_security_questions',
	                            array('question_id' => $vars["q1"],
									'answer' => trim($vars["ans1"]),
									'user_id' => $uid,
									'created_on' => date("Y:m:d H:i:s")
								)
								);
			
			$this->db->insert('user_security_questions',
	                            array('question_id' => $vars["q2"],
									'answer' => trim($vars["ans2"]),
									'user_id' => $uid,
									'created_on' => date("Y:m:d H:i:s")
								)
								);
		
			$this->db->where("id",$uid);			
			$this->db->update("users",array('security_complete'=>1));
			
			if($userData->security_complete==0)
			{
				return 1;
			}
			else
				return 2;
    	}
    	else
    		return 0;
    }
    /*public function updatePasswordUser($uid,$currentPassword,$newPassword)
    {
    	$this->db->where("id",$uid);
    	$this->db->where("pass",md5($currentPassword));
    	$q=$this->db->get("users");
    	if($q->num_rows())
    	{
    		$this->db->where("id",$uid);
    		$this->db->update("users",
    					array('pass'=>md5(trim($newPassword))
    						   ));
    		return 1;
    	}
    	else
    		return 2;
    }*/
    /*public function updatePinUser($uid,$newPin)
    {
    	$this->db->where("id",$uid);
		$this->db->update("users",
					array('user_pin'=>md5($newPin),
						   'pin_set'=>1
						   ));
    		
    	return 1;
    }*/
    public function getWallet($uid,$currency)
    {
    	if($currency!='')
    	{
    		$fields = $this->db->list_fields('user_debit_account');
    		if(in_array($currency,$fields))
    		{
    			$this->db->select($currency.",user_id");
    		}
    		else
    		{
    			return 0;
    		}
    	}
    	$this->db->where("user_id",$uid);
    	$q=$this->db->get("user_debit_account");
    	return $q->row();
    }
    public function creditWalletPayU($uid,$vars,$admin)
    {
    	$this->db->where("tx",$vars['txnid']);
		$this->db->update('transaction',
                            array(
								//'tx' => $_POST['txnid'],
								'status' => trim($vars['status']),
								'amount' => trim($vars['amount']),
								'payu_mihpayid' =>trim($vars['mihpayid']),
								'payment_mode' =>'payu',
								'payu_mode' =>trim($vars['mode']),
								'date' =>date("Y:m:d H:i:s"),
								'payu_unmapped_status' =>trim($vars['unmappedstatus']),
								'discount' =>trim($vars['discount']),
								'created_on' =>trim($vars['addedon']),
								'firstname' =>trim($vars['firstname']),
								'lastname' =>trim($vars['lastname']),
								'address1' =>trim($vars['address1']),
								'address2' =>trim($vars['address2']),
								'city' =>trim($vars['city']),
								'state' =>trim($vars['state']),
								'country' =>trim($vars['country']),
								'zipcode' =>trim($vars['zipcode']),
								'email' =>trim($vars['email']),
								'phone' =>trim($vars['phone']),
								'hash' => trim($vars['hash']),
								'pg_type' =>trim($vars['PG_TYPE']),
								'bank_ref_num' =>trim($vars['bank_ref_num']),
								'bankcode' =>trim($vars['bankcode']),
								//'cardnum' =>trim($vars['cardnum']),
								//'cardhash' =>$vars['cardhash'],
								'field1' =>trim($vars['field1']),
								'field2' =>trim($vars['field2']),
								'field3' =>trim($vars['field3']),
								'field4' =>trim($vars['field4']),
								'field5' =>trim($vars['field5']),
								'field6' =>trim($vars['field6']),
								'field7' =>trim($vars['field7']),
								'field8' =>trim($vars['field8']),
								'udf1' =>trim($vars['udf1']),
								'udf2' =>trim($vars['udf2']),
								'udf3' =>trim($vars['udf3']),
								'udf4' =>trim($vars['udf4']),
								'udf5' =>trim($vars['udf5']),
								'udf6' =>trim($vars['udf6']),
								'udf7' =>trim($vars['udf7']),
								'udf8' =>trim($vars['udf8']),
								'udf9' =>trim($vars['udf9']),
								'udf10' =>trim($vars['udf10']),
								'userid' =>$uid,
								't_status'=>1
							)
							);
		if($vars['status']=="success")
		{
			$this->makeWalletTransaction($uid,$vars['txnid'],$vars['amount'],'credit','inr',"Self Funds","payu");
			return 1;
		}
		else
			return 2;
    }
    public function creditWalletPayPal($uid,$vars,$admin)
    {
		$q=$this->db->insert('transaction',
                            	array('tx' => $vars->txn_id,
								'status' => trim($vars->payment_status),
								'amount' => trim($vars->amount),
								'paypal_currency' =>$vars->mc_currency,
								'payment_mode' =>'Paypal',
								'date' => date("Y:m:d H:i:s",strtotime($vars->payment_date)),
								'userid' => $uid
							)
							);
		
		if($vars->payment_status=="Completed")
		{
			$this->makeWalletTransaction($uid,$vars->txn_id,$vars->amount,'credit',$vars->mc_currency,"Self Funds","paypal");
			return 1;
		}
		else return 2;
    }
    public function makeWalletTransaction($uid,$txid,$amount,$type,$currency,$note,$paymentMode)
    {
    	$this->db->where("user_id",$uid);
    	$this->db->where("currency",strtolower($currency));
    	$this->db->order_by("date",'desc');
    	$this->db->order_by("order",'desc');
    	$this->db->limit(1);
    	$list=$this->db->get("user_account_transactions");
    	$lastOrder=0;
		if($list->num_rows())
		{
			$last=$list->row();
			$lastOrder=$last->order++;
			$prev_closing=$last->closing_balance;
			$prev_opening=$last->opening_balance;
		}
		else
		{
			$prev_closing=0;
			$prev_opening=0;
		}

		if($type=='credit')
			$net=$prev_closing+$amount;
		else
			$net=$prev_closing-$amount;



		if($this->session->userdata("id"))
		{
			$created_by=$this->session->userdata("id");
		}
		else
		{
			$created_by=$uid;
		}
		$chq='0';

		$inp= array('user_id' =>$uid,
								'txnid'=>$txid,
									'amount' => $amount,
									'date' => date("Y:m:d H:i:s"),
									'type' => $type,//Credit or Debit
									'ip_address' => $_SERVER['REMOTE_ADDR'],
									'created_by' => $created_by,
									'note' => $note,
									'opening_balance'=>$prev_closing,
									'closing_balance'=>$net,
									'currency'=>$currency,
									'payment_mode'=>$paymentMode,
									'cheque_number'=>$chq,
									'order'=>$lastOrder
								);

		$q=$this->db->insert('user_account_transactions',$inp);
		$this->db->where("user_id", $uid);
		$q=$this->db->update('user_debit_account',array(strtolower($currency) => $net));

		$this->load->library("email_extension");
		if($type=='credit')
		{
			$subject="Funds added to your ".site_name_string1." Wallet";
			$emailView="payments/admin/_email_credit";
		}
		else
		{
			$subject="Funds deducted to your ".site_name_string1." Wallet";
			$emailView="payments/admin/_email_debit";
		}
		$data['txdate']=date("d M Y");
		$data['txid']=$txid;
		$data['amount']=strtoupper($currency)." ".$amount;
		ob_start();
		$this->load->view($emailView,$data);
		$content=ob_get_clean();
		$this->email_extension->sendMail("payments",$uid,$subject,$content);
		return 1;
    }
	
	public function chargeWallet($userID,$amount,$currency,$uniqueID,$note,$serviceSlug='')
	{
		$this->db->where("user_id",$userID);
    	$this->db->where("currency",strtolower($currency));
    	$this->db->order_by("date",'desc');
    	$this->db->limit(1);
		$list=$this->db->get("user_account_transactions");
		$lastOrder=0;
		if($list->num_rows())
		{
			$last=$list->row();
			$lastOrder=$last->order++;
			$prev_closing=$last->closing_balance;
			$prev_opening=$last->opening_balance;
		}
		else
		{
			$prev_closing=0;
			$prev_opening=0;
		}
		
		$net=$prev_closing-$amount;
		
		$chq='0';
		
		$txnid=substr(hash('sha256', mt_rand().microtime()), 0, 20);

		$inp= array('user_id' =>$userID,
						  'txnid'=> $txnid,
						  'amount' => $amount,
						  'date' => date("Y:m:d H:i:s"),
						  'type' => 'debit',
						  'ip_address' => $_SERVER['REMOTE_ADDR'],
						  'created_by' => $userID,
						  'note' => $note,
						  'opening_balance'=>$prev_closing,
						  'closing_balance'=>$net,
						  'currency'=>$currency,
						  'payment_mode'=>'wallet',
						  'unique_id'=>$uniqueID,
						  'service'=>$serviceSlug,
						  'order'=>$lastOrder
						 );

		$q=$this->db->insert('user_account_transactions',$inp);

		$uuid=$this->db->insert_id();

		$this->db->where("user_id", $userID);
		$q=$this->db->update('user_debit_account',
							array($currency => $net)
							);


		$this->load->library("email_extension");
		$subject="Funds deducted to your ".site_name_string1." Wallet";
		$emailView="payments/admin/_email_debit";
	
		$data['txdate']=date("d M Y");
		$data['txid']=$txnid;
		$data['amount']=strtoupper($currency)." ".$amount;
		ob_start();
		$this->load->view($emailView,$data);
		$content=ob_get_clean();
		$this->email_extension->sendMail("payments",$userID,$subject,$content);

		return $txnid;
	}
	public function sendRegisteredEmail($uid=0)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$this->auth_check->where("id",$uid);
			$quser=$this->auth_check->get("users");
			$user=$quser->row();

			if(empty($user))
			{
				$data['msg']="User does not exist";
				return $data;
			}
			$token=urlencode(base64_encode(openssl_encrypt($user->username, open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv)));
			
			$rdata['udata']=$user;
			$rdata['token']=$token;
			if($user->user_type == "import")
			{
				$content=$this->load->view("users/admin/_email_imported_user",$rdata,true);
			}
			else
			{
				$content=$this->load->view("users/admin/_email_registered",$rdata,true);
			}
            
          	$to=$user->email;
          	$subject='Welcome to '. short_ashram_name.' - '.$user->username;
          	$this->load->library("email_extension");
          	
          	$this->email_extension->sendMailGuest("users",$user->firstname." ".$user->lastname,$user->email,$subject,$content,'',1);

            $this->logaction->log("users","Registration email has been sent to ".$user->email);
            $data['flag']=1;
            $data['msg']="Registration Email sent successfully";
			return $data;
			
		}
		else
		{
			$data['msg']="Invalid request";
			return $data;
		}
	}
	public function sendEmailVerificationLink($uid=0)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$user=$this->localuserDatabyId($uid);

			if(empty($user))
			{
				$data['msg']="User does not exist";
				return $data;
			}

			$token=urlencode(base64_encode(openssl_encrypt($user->username, open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv)));

			$rdata['udata']=$user;
			$rdata['token']=$token;
			$content=$this->load->view("users/admin/_email_verification_link",$rdata,true);
            
          	$to=$user->email;
          	$subject= site_name_string1.' - Verify Email - '.$user->username;
          	$this->load->library("email_extension");
          	
          	$this->email_extension->sendMailGuest("users",$user->firstname." ".$user->lastname,$user->email,$subject,$content,'',1);

            $this->logaction->log("users","Email verification link has been sent to ".$user->email);
            $data['flag']=1;
            $data['msg']="Email verification link sent successfully";
			return $data;
			
		}
		else
		{
			$data['msg']="Invalid request";
			return $data;
		}
	}

	public function sendUpdatedEmailVerificationLink($uid=0,$email)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$user=$this->localuserDatabyId($uid);
			if(empty($user))
			{
				$data['msg']="User does not exist";
				return $data;
			}
			$token=urlencode(base64_encode(openssl_encrypt($user->username, open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv)));
			$rdata['udata']=$user;
			$rdata['token']=$token;
			$content=$this->load->view("users/admin/_email_verification_link",$rdata,true);
          	$to=$email;
          	$subject= site_name_string1.' - Verify Email - '.$user->username;
          	$this->load->library("email_extension");
          	
          	$this->email_extension->sendMailGuest("users",$user->firstname." ".$user->lastname,$email,$subject,$content,'',1);
            $this->logaction->log("users","Email verification link has been sent to ".$email);
            $data['flag']=1;
            $data['msg']="Email verification link sent successfully";
			return $data;
			
		}
		else
		{
			$data['msg']="Invalid request";
			return $data;
		}
	}

}
?>