<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Temp_payments_Model extends CI_Model 
{
    function __construct() 
	{
	    parent::__construct();
    }

    public function createTransactionTemp($txnid,$userId,$referenceId='',$status=null,$error=null,$order_id=0)
    {
        // Get user remote ip address or for system created temp transaction set default ip address
    	if(isset($_SERVER['REMOTE_ADDR']))
    		$remote_addr=$_SERVER['REMOTE_ADDR'];
    	else
    		$remote_addr="127.0.0.1";

        // Insert data to transaction_temp table
    	$q=$this->db->insert('transaction_temp',
					              array('started_on' => date("Y:m:d H:i:s"),
					                'tx' =>  $txnid,
					                'userid' =>$userId,
					                'reference_id'=>$referenceId,
					                'status'=>$status,
					                'error'=>$error,
					                'order_id'=>$order_id,
					                'created_on'=>date("Y:m:d H:i:s"),
					                'ip_address'=>$remote_addr,
					                'date'=>date("Y:m:d H:i:s")
					              )
              				);
    }

    public function reconsilationLog($orderId,$payment_id)
    {
        $this->db->insert("reconciliation_orders",array("order_id"=>$orderId,"transaction_id"=>$payment_id,"created_on"=>date("Y-m-d H:i:s")));
    }

    public function getTransactionTemp($tx='')
    {
		$this->db->where("tx",$tx);
		$transaction=$this->db->get("transaction_temp");
		return $transaction->row();
    }

    public function clearTempOrders()
    {
    	$this->db->select("id")->from("orders_temp");
    	$q = $this->db->where('date < NOW() + INTERVAL -2 DAY')->get();
    	if($q->num_rows() > 0)
    	{
    		$db = $q->result_array();
    		foreach ($db as $key => $value) 
    		{
    			$cc[] = $value["id"];
    		}
    		$this->db->where_in("order_id",$cc)->delete("order_items_temp");
    		$this->db->where('date < NOW() + INTERVAL -2 DAY')->delete("orders_temp");
    	}
    	$this->db->where('date < NOW() + INTERVAL -2 DAY')->delete("transaction_temp");
    }

    public function createFailedOrder($orderData)
    {
    	$this->db->insert("orders_failed",$orderData);
    }

    public function getOrderDataTemp($order_id='')
    {
		$this->db->where("id",$order_id);
		$orderData=$this->db->get("orders_temp");
		return $orderData->result_array()[0];
    }

    public function getOrderDataTempRazorpay($reference='')
    {
		$this->db->where("razorpay_temp_reference ",$reference);
		$orderData=$this->db->get("orders_temp");
		if(count($orderData->result_array()) > 0)
			return $orderData->result_array()[0];
		else
			return false;
    }

    public function updateTempReference($orderId,$reference)
    {
    	if(!empty($reference) && !empty($orderId))
    	{
    		$this->db->where("id",$orderId);
    		$this->db->update("orders_temp",array("razorpay_temp_reference"=>$reference));
    	}
    }

    public function updateStripeTempReference($orderId,$reference)
    {
        if(!empty($reference) && !empty($orderId))
        {
            $this->db->where("id",$orderId);
            $this->db->update("orders_temp",array("stripe_temp_reference"=>$reference));
        }
    }

    public function updateTempPaymentInfo($orderId,$tempInfo,$reference)
    {
    	if(!empty($tempInfo) && !empty($orderId))
    	{
    		$this->db->where("id",$orderId);
    		$this->db->update("orders_temp",array("temp_payment_info"=>$tempInfo,"application_reference"=>$reference));
    	}
    }

    public function updateApplicationreference($orderId,$tempInfo)
    {
    	if(!empty($tempInfo) && !empty($orderId))
    	{
    		$this->db->where("id",$orderId);
    		$this->db->update("orders_temp",array("temp_payment_info"=>$tempInfo));
    	}
    }

    public function getTempInfo($reference,$flag=0)
    {
    	$this->db->where("reference_id",$reference);
    	$q=$this->db->get("temp_payment_info");

    	if($flag==1)
    	{
    		$this->db->where("reference_id",$reference);
    		$this->db->update("temp_payment_info",array("status"=>1));
    	}
    	return $q->row();
    }

    public function tempInfoUpdateTxTemp($reference,$tx,$amount=0)
    {
        // Update temp payment info table with transaction id
    	$this->db->where("reference_id",$reference);
    	$this->db->update("temp_payment_info",array("transaction_id"=>$tx));

        // Get temp payment info details by reference number
    	$tempInfo=$this->getTempInfo($reference);
        // Store cart data from temp payment info table to customData variable
    	$customData=unserialize($tempInfo->data);
        // Store form data from temp payment info table to formData variable
    	$formData=$customData['formData'];

    	$order_data['trustData']=$customData['trustData'];

    	$country_isd_code='';
    	$countryData=$this->locations_model->getCountryByCode($formData['country']);
    	if(!empty($countryData))
    	{
    		$country_isd_code=$countryData->isd_code;
    	}

        // Set donation declaration type Gift/Donation and if gift select gift template
        $order_declaration_type = 'Donation';
        $order_selected_template = '';
        if(isset($formData['declaration_type']) && $formData['declaration_type']=='Gift')
        {
            $order_declaration_type = trim($formData['declaration_type']);
        }
        if(isset($formData['selected_template']) && $formData['selected_template']!='' && $order_declaration_type=='Gift')
        {
            $order_selected_template = trim($formData['selected_template']);
        }
        // Build array to update transaction temp table 
    	$updateArray=array(
			                'firstname'=>$formData['firstname'],
			                'lastname'=>$formData['lastname'],
			                'email'=>$formData['email'],
			                'phone'=>$formData['phone'],
			                'city'=>$formData['city'],
			                'state'=>$formData['state'],
			                'country'=>$formData['country'],
			                'ashram_id'=>$customData['ashramData']->id,
                            'trust_id'=>$customData['trustData']->id,
			                //'amount'=>$tempInfo->amount,
			                'currency'=>$tempInfo->currency,
			                'payment_mode'=>$customData['paymentMode'],
			                'order_data'=>serialize($order_data),
			                'country_isd_code'=>$country_isd_code,
                            'declaration_type'=>$order_declaration_type,
                            'declaration_template'=>$order_selected_template,
		            	);
    	if($amount)
    		$updateArray['amount']=$amount;

    	$this->db->where("tx",$tx);
    	$this->db->update('transaction_temp',$updateArray);
    }

    public function deleteTempOrder($order_id)
    {
    	$this->db->where("id",$order_id);
    	$this->db->delete("orders_temp");
    }

    public function deleteTempTx($order_id)
    {
    	$this->db->where("order_id",$order_id);
    	$this->db->delete("transaction_temp");
    }

    public function deleteTempTransaction($tx)
    {
    	$this->db->where("tx",$tx);
    	$this->db->delete("transaction_temp");
    }

    public function deleteTempOrderItems($order_id)
    {
    	$this->db->where("order_id",$order_id);
    	$this->db->delete("order_items_temp");
    }

    public function processPurchaseTemp($reference,$transaction,$tempInfo,$ipn)
	{
		$tx=$transaction->tx;
		$this->logaction->log($this->service,"Receive payments (Temp Order) - Direct payment reference | Process Purchase | Ref:".$reference." | Txnid: ".$tx);
		$sUrl='';
		$flashvars='';
		$sUrl='';
		if(in_array(strtolower($ipn->status),array("completed",'success','release payment','Release Payment','approved','captured','cash_pending','paid','initiated')))
		{
			$customData=unserialize($tempInfo->data);

			$modelName=$customData['model_name'];
			$CI =& get_instance();
			$CI->load->model($customData['model']);
            // Create temp order
			$data=$CI->$modelName->createOrderTemp($reference,$transaction,$tempInfo,$ipn);
            // Get temp order id
			$orderId=$data['order_id'];
            // Set return back url
			if($tempInfo->user_id!=0)
			{
				if($customData['created_by']==1)//Admin
					$sUrl=base_url.'orders/view/'.$data['order_id'];
				else//User
					$sUrl=base_url.'myorders/view/'.$data['order_id'];
			}
			else //Guest
			{
				if($customData['cart_type']==1)
					$sUrl=base_url.'poojas/receipt/'.$tx;
				else if($customData['cart_type']==2)
					$sUrl=base_url.'donations/receipt/'.$tx;
				else if($customData['cart_type']==3)
					$sUrl=base_url.'store/receipt/'.$tx;
				else if($customData['cart_type']==4)
					$sUrl=base_url.'subcriptions/receipt/'.$tx;

			}
			$flashvars='order_placed:1';
			$t_status=1;
            // Update status to temp_payment_info table
			$this->db->where("reference_id",$reference);
    		$this->db->update("temp_payment_info",array("status"=>1));
		}
		else
		{
			$sUrl=$tempInfo->fail_url;
			$orderId=0;
			$t_status=0;
		}

		//If not cash transactions
		if($tx!='')
		{
			$customData=unserialize($tempInfo->data);
			$tData=array(
							"redirect_url"=>$sUrl,
							'flashvars'=>$flashvars,
							't_status'=>$t_status,
							'order_id'=>$orderId,
							'status'=>$ipn->status,
							//'amount'=>$ipn->amount,
							'payment_mode'=>$customData['paymentMode'],
							'currency'=>$tempInfo->currency,
							'created_on'=>date("Y:m:d H:i:s")
						);
            if($orderId>0)
            {
                $orderDetails = $this->getOrderDataTemp($orderId);
                if(isset($orderDetails['partial_payments_allowed']) && $orderDetails['partial_payments_allowed']!='')
                {
                    $tData['tx_partial_payments_allowed'] = $orderDetails['partial_payments_allowed'];
                }
                if(isset($orderDetails['order_number']) && $orderDetails['order_number']!='')
                {
                    $tData['tx_order_number'] = $orderDetails['order_number'];
                }
                if(isset($orderDetails['order_type']) && $orderDetails['order_type']!='')
                {
                    $tData['tx_order_type'] = $orderDetails['order_type'];
                }
                if(isset($orderDetails['date']) && $orderDetails['date']!='')
                {
                    $tData['tx_order_date'] = date('Y-m-d', strtotime($orderDetails['date']));
                }
                if(isset($orderDetails['username']) && $orderDetails['username']!='')
                {
                    $tData['tx_username'] = $orderDetails['username'];
                }
                $this->load->model("user/users_model");
                $userDetails = $this->users_model->userData($orderDetails['user_id']);
                if(isset($orderDetails['order_pan_number']) && $orderDetails['order_pan_number']!='')
                {
                    $tData['tx_pan_number'] = $orderDetails['order_pan_number'];
                }
                else if(isset($orderDetails['user_id']) && $orderDetails['user_id']>0)
                {
                    if(isset($userDetails->pan_number) && $userDetails->pan_number!='')
                    {
                        $tData['tx_pan_number'] = $userDetails->pan_number;
                    }
                }
                if(isset($orderDetails['order_aadhaar_number']) && $orderDetails['order_aadhaar_number']!='')
                {
                    $tData['tx_aadhaar_number'] = $orderDetails['order_aadhaar_number'];
                }
                else if(isset($orderDetails['user_id']) && $orderDetails['user_id']>0)
                {
                    if(isset($userDetails->aadhaar_number) && $userDetails->aadhaar_number!='')
                    {
                        $tData['tx_aadhaar_number'] = $userDetails->aadhaar_number;
                    }
                }
                if(isset($orderDetails['order_tin_number']) && $orderDetails['order_tin_number']!='')
                {
                    $tData['tx_tin_number'] = $orderDetails['order_tin_number'];
                }
                else if(isset($orderDetails['user_id']) && $orderDetails['user_id']>0)
                {
                    if(isset($userDetails->tin_number) && $userDetails->tin_number!='')
                    {
                        $tData['tx_tin_number'] = $userDetails->tin_number;
                    }
                }
                if(isset($orderDetails['order_passport_number']) && $orderDetails['order_passport_number']!='')
                {
                    $tData['tx_passport_number'] = $orderDetails['order_passport_number'];
                }
                else if(isset($orderDetails['user_id']) && $orderDetails['user_id']>0)
                {
                    if(isset($userDetails->passport_number) && $userDetails->passport_number!='')
                    {
                        $tData['tx_passport_number'] = $userDetails->passport_number;
                    }
                }
                if(isset($orderDetails['order_voter_epic_number']) && $orderDetails['order_voter_epic_number']!='')
                {
                    $tData['tx_voter_epic_number'] = $orderDetails['order_voter_epic_number'];
                }
                else if(isset($orderDetails['user_id']) && $orderDetails['user_id']>0)
                {
                    if(isset($userDetails->voter_epic_number) && $userDetails->voter_epic_number!='')
                    {
                        $tData['tx_voter_epic_number'] = $userDetails->voter_epic_number;
                    }
                }
                if(isset($orderDetails['order_driving_license_number']) && $orderDetails['order_driving_license_number']!='')
                {
                    $tData['tx_driving_license_number'] = $orderDetails['order_driving_license_number'];
                }
                else if(isset($orderDetails['user_id']) && $orderDetails['user_id']>0)
                {
                    if(isset($userDetails->driving_license_number) && $userDetails->driving_license_number!='')
                    {
                        $tData['tx_driving_license_number'] = $userDetails->driving_license_number;
                    }
                }
                if(isset($orderDetails['order_ration_card_number']) && $orderDetails['order_ration_card_number']!='')
                {
                    $tData['tx_ration_card_number'] = $orderDetails['order_ration_card_number'];
                }
                else if(isset($orderDetails['user_id']) && $orderDetails['user_id']>0)
                {
                    if(isset($userDetails->ration_card_number) && $userDetails->ration_card_number!='')
                    {
                        $tData['tx_ration_card_number'] = $userDetails->ration_card_number;
                    }
                }
                if(isset($orderDetails['total_price']) && $orderDetails['total_price']>0)
                {
                    $tData['tx_order_total_price'] = $orderDetails['total_price'];
                }
                if(isset($orderDetails['app']) && $orderDetails['app']>0)
                {
                    $tData['tx_app'] = $orderDetails['app'];
                }
                if(isset($orderDetails['created_by']) && $orderDetails['created_by']>0)
                {
                    $tData['tx_created_by'] = $orderDetails['created_by'];
                }
                if(isset($orderDetails['address1']) && $orderDetails['address1']!='')
                {
                    $tData['address1'] = $orderDetails['address1'];
                }
                if(isset($orderDetails['address2']) && $orderDetails['address2']!='')
                {
                    $tData['address2'] = $orderDetails['address2'];
                }
                if(isset($orderDetails['address3']) && $orderDetails['address3']!='')
                {
                    $tData['address3'] = $orderDetails['address3'];
                }
                if(isset($orderDetails['zipcode']) && $orderDetails['zipcode!']=!'')
                {
                    $tData['zipcode'] = $orderDetails['zipcode'];
                }
            }
			
			if($customData['paymentMode']=='paypal')
			{
				$tData['tx']=$tx;
				$this->db->where("reference_id",$reference);
			}
			else
			{
				$this->db->where("tx",$tx);
			}
			
			$this->db->update("transaction_temp",$tData);
		}
		return $orderId;
	}
}