<?PHP
class Subscriptions_sms_Model extends CI_Model 
{
	var $tableName="subscriptions_sms";
	var $siteServicesDb = "";
    function __construct()
    {
        parent::__construct();
        $this->siteServicesDb = $this->load->database("site_services",true,false);
        $this->load->model('subscriptions/subscription_groups_model');
    }

    public function subscriptionData($id)
    {
    	$this->siteServicesDb->where("id",$id);
    	$q=$this->siteServicesDb->get($this->tableName);
    	return $q->row();
    }
    public function unsubscribenewsletter($vars)
    {
    	$this->siteServicesDb->select("country_code,unsubscribe,id");
    	$this->siteServicesDb->where("phone",$vars['subscribe_phone']);
    	$this->siteServicesDb->where("country_code",$vars['country_code']);
		$q=$this->siteServicesDb->get($this->tableName);
		if(!$q->num_rows())
		{
			return 0;
		}
		if($q->num_rows())
		{
			$r = $q->row();
			$vars['country_code'] = $vars['country_code'];
			if($r->unsubscribe == "1")
				return 2;
		}
		
		$check = $this->siteServicesDb->where("id",$r->id)->where("country_code",trim($vars['country_code']))->update($this->tableName,array( 'unsubscribe'=>"1","country_code"=>$vars['country_code'],"name"=>$vars['subscribe_name2']));
		if($check)
		{
			$this->load->library("sms");
			$message="Jaya Guru Datta\n".
			"You have been unsubscribed from ".site_name_string1." notifications system.";

			$countryData=$this->locations_model->getCountryByCode($vars['country_code']);
			$this->sms->sendSMSGuest(
									'subscribe',
									$countryData->isd_code,
									$countryData->isd_code.$vars['subscribe_phone'],
									$message
								);
		}
		return 1;
    }
    public function subscribe($vars,$is_sms=0)
	{
		$this->siteServicesDb->select('id,unsubscribe');
		$this->siteServicesDb->where("phone",$vars['subscribe_phone']);
		$this->siteServicesDb->where("country_code",$vars['country_code']);
		$q=$this->siteServicesDb->get($this->tableName);
		if($q->num_rows())
		{
			$r = $q->row();
			if(!empty($r) && $r->unsubscribe == "1")
			{
				$status = $this->updateUnsubscribestatus($r->id,$vars);
				return $status;
			}
			return 0;
		}
		$app=0;
		if(isset($GLOBALS['app']) && $GLOBALS['app']==1)
		{
			$app=1;
		}
		$group_ids='';
		if(isset($vars['group_ids']) && $vars['group_ids']!=0)
		{
			$group_ids=$vars['group_ids'];
		}
		$country=$this->locations_model->getCountryByCode($vars['country_code']);
		$this->siteServicesDb->insert($this->tableName,
                                array(
                                	'name' => $vars['subscribe_name2'],
                                	'country_code'=>$vars['country_code'],
                                	'city'=>$vars['subscribe_city2'],
                                	'isd_code'=>$country->isd_code,
									'phone' => $vars['subscribe_phone'],
									'group_id'=>$group_ids,
									'phone_verified'=>1,
									'date' =>date("Y:m:d H:i:s"),
									'app'=>$app
								)
								);
		
		$sid=$this->siteServicesDb->insert_id();

		if($is_sms==1)
		{
			$this->load->library("sms");
			$message="Jaya Guru Datta\n".
					"You have been subscribed to receive notifications from ".site_name_string1.".\n".
					base_url."";

			$countryData=$this->locations_model->getCountryByCode($vars['country_code']);
			$this->sms->sendSMSGuest(
									'subscribe',
									$countryData->isd_code,
									$countryData->isd_code.$vars['subscribe_phone'],
									$message
								);
		}
		return 1;
	}

	public function updateUnsubscribestatus($id,$vars)
	{
		if($id)
		{
			$country=$this->locations_model->getCountryByCode($vars['country_code']);
			$data = array('unsubscribe'=>"0","name"=>$vars['subscribe_name2'],'country_code'=>$vars['country_code'],'city'=>$vars['subscribe_city2'],'isd_code'=>$country->isd_code);
			$this->siteServicesDb->where("id",$id);
	    	$this->siteServicesDb->update($this->tableName,$data);
	    	if($this->siteServicesDb->affected_rows() > 0)
	    	{
	    		$this->load->library("sms");
				$message="Jaya Guru Datta\n".
					"You have been subscribed to receive notifications from ".site_name_string1.".\n".
					base_url."";

				$countryData=$this->locations_model->getCountryByCode($vars['country_code']);
				$this->sms->sendSMSGuest(
										'subscribe',
										$countryData->isd_code,
										$countryData->isd_code.$vars['subscribe_phone'],
										$message
									);
				return 1;
	    	}
	    	return 0;
		}
		else
		{
			return 0;
		}
	}
	public function getList($excel=0)
	{

		$gNames = "";
	   	if(isset($_POST['group_name']) && $_POST['group_name'] !="" && $excel==1)
	   	{
	   		$gNames = $this->subscription_groups_model->getGroupNames(implode(",", $_POST['group_name']));
	   	}

		$i=0;
		$query1=$this->siteServicesDb;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		
		$preData="Search Keywords: ";	
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if($_POST['search_col'] == "phone")
				$preData.= " Mobile Number";
			if($_POST['search_col'] == "name")
				$preData.= " Name";
			if($_POST['search_col'] == "city")
				$preData.= " City";
			
			$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
			$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nAll Sources: ";
		if(isset($_POST['app']) && is_numeric($_POST['app']) && in_array($_POST['app'],array(0,1)))
		{
			$query1->where("app",$_POST['app']);
			if($_POST['app']==1)
				$preData.="App";
			else
				$preData.="Website";
		}

		$preData.="\nAll Subscribe Status: ";
		if(isset($_POST['subscribe_status']) && is_numeric($_POST['subscribe_status']) && in_array($_POST['subscribe_status'],array("0","1")))
		{
			$query1->where("unsubscribe",$_POST['subscribe_status']);
			if($_POST['subscribe_status']=="1")
				$preData.="UnSubscribed";
			else
				$preData.="Subscribed";
		}
		
		$preData.="\nMobile Verified: ";
		if(isset($_POST['phone_verified']) && is_numeric($_POST['phone_verified']) && in_array($_POST['phone_verified'],array(0,1)))
		{
			$query1->where('phone_verified',$_POST['phone_verified']);
			if($_POST['phone_verified']==1)
				$preData.="Yes";
			else
				$preData.="No";
		}

		$preData.="\nGroups: ";
		if(isset($_POST['group_name']) && $_POST['group_name']!='' && count($_POST['group_name'])>0)
		{
			$wq = "(";
			$k=0;
		    foreach($_POST['group_name'] as $value)
		    {
		    	if($k++)
		    		$wq.= " OR FIND_IN_SET('$value', group_id) != 0";
		    	else
		    		$wq.= "FIND_IN_SET('$value', group_id) != 0";
		    }
		    $wq.=")";
		   $query1->where($wq);
		   $preData.='"'.$gNames.'"';
		}

		$preData.="\nCountry: ";
		if(isset($_POST['country_code']) && $_POST['country_code']!='')
		{
			$query1->where('country_code',$_POST['country_code']);
			$preData.= $_POST['country_code'];
		}
		
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","Subscriptions_sms_model",$sql,$this->currentUser,"site_services",$_POST,"All SMS Subscriptions",$preData);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('date',$dir);
		}
		else
		{
			$query1->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($rtn['data'][$c]['group_id'])
				$rtn['data'][$c]['group_names'] = $this->subscription_groups_model->getGroupNames($rtn['data'][$c]['group_id']);
			else
				$rtn['data'][$c]['group_names'] = "";
			if($rtn['data'][$c]['city'])
				$rtn['data'][$c]['city'] = $rtn['data'][$c]['city'];
			else
				$rtn['data'][$c]['city'] = "";
			if($rtn['data'][$c]['country_code'])
				$rtn['data'][$c]['country_code'] = $rtn['data'][$c]['country_code'];
			else
				$rtn['data'][$c]['country_code'] = "";
			$rtn['data'][$c]['date']=date("d M Y h:i A",strtotime($rtn['data'][$c]['date']));
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	public function delete($id)
	{
		$this->siteServicesDb->where("id",$id);
    	$this->siteServicesDb->delete($this->tableName);
	}

	public function searchAll($string)
	{
		$this->siteServicesDb->select("*");
		$this->siteServicesDb->from($this->tableName);
		$this->siteServicesDb->group_start();
		$this->siteServicesDb->like("name",$string,'match');
		$this->siteServicesDb->or_like("phone",$string,'match');
		$this->siteServicesDb->group_end();
		//$this->siteServicesDb->where("phone_verified",1);
		$this->siteServicesDb->limit(10);
		return $this->siteServicesDb->get()->result_array();
	}

	public function searchbyGroupAll($string)
	{
		$this->siteServicesDb->select("*");
		$this->siteServicesDb->from($this->tableName." as s");
		$this->siteServicesDb->like("group_name",$string,'match');
		$this->siteServicesDb->join("subscription_groups as sg","FIND_IN_SET(sg.id, s.group_id)");
		$this->siteServicesDb->where("phone_verified",1);
		$this->siteServicesDb->where("unsubscribe","0");
		$this->siteServicesDb->group_by('group_name');
		$this->siteServicesDb->limit(10);
		return $this->siteServicesDb->get()->result_array();
	}

	public function searchCountries($string)
	{
		$location=$this->load->database("location",true,false);

		$this->siteServicesDb->select("l.country_code as country_code,country_name,l.isd_code as isd_code");
		$this->siteServicesDb->from($this->tableName." as s");
		$this->siteServicesDb->join($location->database.".countries_list as l","l.country_code=s.country_code");
		$this->siteServicesDb->group_by("s.country_code");
		$this->siteServicesDb->like("l.country_name",$string,'match');
		$this->siteServicesDb->where("s.country_code !=",'');
		$this->siteServicesDb->where("l.country_code !=",'');
		$this->siteServicesDb->limit(10);
		return $this->siteServicesDb->get()->result_array();
	}
	public function getByIds($ids)
	{
		$this->siteServicesDb->select("*");
		$this->siteServicesDb->from($this->tableName);
		$this->siteServicesDb->where_in("id",$ids);
		return $this->siteServicesDb->get()->result();
	}

	public function update($data='',$where='',$flag=0)
	{
		if($data && $where)
		{
			if($flag == 1)
			{
				$data = implode(",", $data);
				$data = array('group_id' => $data);
			}
			$this->siteServicesDb->where("id",$where);
    		$this->siteServicesDb->update($this->tableName,$data);
    		return true;
		}
	}

	public function appendGroup($newGrouparr,$exGrouparr)
	{
		$merge = array_merge($newGrouparr,$exGrouparr);
		$final_value = array_unique($merge, SORT_REGULAR);
		return implode(",", $final_value);
	}

	public function checkGroups($id='',$groupsstring)
	{
		$q = $this->siteServicesDb->select('group_id')->from($this->tableName)->where('id',$id)->get();
		if($q->num_rows() > 0)
		{
			$existedGroup = $q->result()[0]->group_id;
			if($existedGroup != "")
				return $this->appendGroup(explode(",",$groupsstring),explode(",",$existedGroup));
			else
				return $groupsstring;
		}
	}

	public function phoneCheck($phone,$id) 
    {
    	$this->siteServicesDb->where("phone",$phone);
    	$this->siteServicesDb->where("id != ",$id);
        $query=$this->siteServicesDb->get($this->tableName);
        if($query->num_rows())
		{
			return 1;
        }
        return 0;
    }

    public function excelReport($excelData,$objPHPExcel)
	{

		$q=$this->siteServicesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Mobile Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Group(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$reportrow->group_name = "";
			if($reportrow->group_id)
				$reportrow->group_name = $this->subscription_groups_model->getGroupNames($reportrow->group_id);
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country_code);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->group_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function updateUnsubscribeSmsStatus($id, $status)
	{
		if($id>0 && ($status==0 || $status==1) )
        {
        	$this->siteServicesDb->where('id',$id);
			$this->siteServicesDb->update($this->tableName, array('unsubscribe'=>$status));
            return true;
        }
        else
        {
            return false;
        }
		
	}

}
?>