<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Payment_Model extends CI_Model 
{
	var $archivesDb = "";
    function __construct() 
	{
	    parent::__construct();
		$this->archivesDb = $this->load->database("data_archives",true,false);
    }
    public function getTransaction($tx='')
    {
		$this->db->where("tx",$tx);
		$transaction=$this->db->get("transaction");
		return $transaction->row();
    }

    public function setTempInfo($userID,$userData,$amount,$redirectURL,$failURL,$data,$currency,$successUrl='')
    {
    	// Generate reference number
    	$ref=random_string('alnum',12);
    	// If reference number is already exists in temp_payment_info table then create new reference number
    	while(1)
    	{
    		$this->db->where("reference_id",$ref);
    		$qref=$this->db->get("temp_payment_info");
    		if($qref->num_rows()==0)
    		{
    			break;
    		}
    		$ref=random_string('alnum',12);
    	}
    	// Insert payment info in to temp_payment_info before table sending to payment gateway
    	$dataArray=array(
    		'user_id'=>$userID,
    		"amount"=>$amount,
    		"redirect_url"=>$redirectURL,
    		'success_url'=>$successUrl,
    		'fail_url'=>$failURL,
    		"data"=>serialize($data),
    		'currency'=>$currency,
    		'reference_id'=>$ref,
    		'created_on'=>date("Y:m:d H:i:s"),
    		'user_data'=>serialize($userData)
    		);
    	$this->db->insert("temp_payment_info",$dataArray);
    	$this->logaction->log($this->service,"Temp Payment Info",serialize($this->db->last_query()));
    	return $ref;
    }

    public function getTempInfo($reference,$flag=0)
    {
    	$this->db->where("reference_id",$reference);
    	$q=$this->db->get("temp_payment_info");

    	if($flag==1)
    	{
    		$this->db->where("reference_id",$reference);
    		$this->db->update("temp_payment_info",array("status"=>1));
    	}
    	return $q->row();
    }

    public function getTempInfoByTx($tx,$flag=0)
    {
    	$this->db->where("transaction_id",$tx);
    	$q=$this->db->get("temp_payment_info");

    	if($flag==1)
    	{
    		$this->db->where("transaction_id",$tx);
    		$this->db->update("temp_payment_info",array("status"=>1));
    	}
    	return $q->row();
    }

    public function tempInfoUpdateTx($reference,$tx,$amount=0,$tData = array())
    {
    	$this->db->where("reference_id",$reference);
    	$this->db->update("temp_payment_info",array("transaction_id"=>$tx));

    	$tempInfo=$this->getTempInfo($reference);
    	$customData=unserialize($tempInfo->data);
    	$formData=$customData['formData'];

    	$order_data['trustData']=$customData['trustData'];


    	$order_declaration_type = 'Donation';
		$order_selected_template = '';
		if(isset($customData['formData']['declaration_type']) && $customData['formData']['declaration_type']=='Gift')
		{
			$order_declaration_type = trim($customData['formData']['declaration_type']);
		}
		if(isset($customData['formData']['selected_template']) && $customData['formData']['selected_template']!='' && $order_declaration_type=='Gift')
		{
			$order_selected_template = trim($customData['formData']['selected_template']);
		}


    	$country_isd_code='';
    	$countryData=$this->locations_model->getCountryByCode($formData['country']);
    	if(!empty($countryData))
    	{
    		$country_isd_code=$countryData->isd_code;
    	}

    	$updateArray=array(
			                'firstname'=>$formData['firstname'],
			                'lastname'=>$formData['lastname'],
			                'email'=>$formData['email'],
			                'phone'=>$formData['phone'],
			                'city'=>$formData['city'],
			                'state'=>$formData['state'],
			                'country'=>$formData['country'],
			                'ashram_id'=>$customData['ashramData']->id,
			                'trust_id'=>$customData['trustData']->id,
			                //'amount'=>$tempInfo->amount,
			                'currency'=>$tempInfo->currency,
			                'payment_mode'=>$customData['paymentMode'],
			                //'order_data'=>serialize($order_data),
			                'country_isd_code'=>$country_isd_code,
			                'declaration_type'=>$order_declaration_type,
							'declaration_template'=>$order_selected_template
		            	);
    	if($amount)
    		$updateArray['amount']=$amount;
    	if(is_array($tData)) {
			$tData = array_merge($tData,$updateArray);
			return $tData;
		}

    /* 	$this->db->where("tx",$tx);
    	$this->db->update('transaction',$updateArray); */
    }

    public function createTransaction($txnid,$userId,$referenceId='',$status=null,$error=null,$order_id=0)
    {
    	if(isset($_SERVER['REMOTE_ADDR']))
    		$remote_addr=$_SERVER['REMOTE_ADDR'];
    	else
    		$remote_addr="127.0.0.1";

		$tData = array('started_on' => date("Y:m:d H:i:s"),
		                'tx' =>  $txnid,
		                'userid' =>$userId,
		                'reference_id'=>$referenceId,
		                'status'=>$status,
		                'error'=>$error,
		                'order_id'=>$order_id,
		                'created_on'=>date("Y:m:d H:i:s"),
		                'ip_address'=>$remote_addr,
		                // 'date'=>date("Y:m:d H:i:s")
		              );

		if($order_id>0)
        {
        	$orderDetails=$this->orders_model->orderData($order_id);
        	if(isset($orderDetails['order']->partial_payments_allowed) && $orderDetails['order']->partial_payments_allowed!='')
            {
                $tData['tx_partial_payments_allowed'] = $orderDetails['order']->partial_payments_allowed;
            }
            if(isset($orderDetails['order']->order_number) && $orderDetails['order']->order_number!='')
            {
                $tData['tx_order_number'] = $orderDetails['order']->order_number;
            }
            if(isset($orderDetails['order']->order_type) && $orderDetails['order']->order_type!='')
            {
                $tData['tx_order_type'] = $orderDetails['order']->order_type;
            }
            if(isset($orderDetails['order']->date) && $orderDetails['order']->date!='')
            {
                $tData['tx_order_date'] = date('Y-m-d', strtotime($orderDetails['order']->date));
            }
            if(isset($orderDetails['order']->username) && $orderDetails['order']->username!='')
            {
                $tData['tx_username'] = $orderDetails['order']->username;
            }
            if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
	            $this->load->model("user/users_model");
	            $userDetails = $this->users_model->userData($orderDetails['order']->user_id);
	        }
            if(isset($orderDetails['order']->order_pan_number) && $orderDetails['order']->order_pan_number!='')
            {
                $tData['tx_pan_number'] = $orderDetails['order']->order_pan_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->pan_number) && $userDetails->pan_number!='')
                {
                    $tData['tx_pan_number'] = $userDetails->pan_number;
                }
            }
            if(isset($orderDetails['order']->order_aadhaar_number) && $orderDetails['order']->order_aadhaar_number!='')
            {
                $tData['tx_aadhaar_number'] = $orderDetails['order']->order_aadhaar_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->aadhaar_number) && $userDetails->aadhaar_number!='')
                {
                    $tData['tx_aadhaar_number'] = $userDetails->aadhaar_number;
                }
            }
            if(isset($orderDetails['order']->order_tin_number) && $orderDetails['order']->order_tin_number!='')
            {
                $tData['tx_tin_number'] = $orderDetails['order']->order_tin_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->tin_number) && $userDetails->tin_number!='')
                {
                    $tData['tx_tin_number'] = $userDetails->tin_number;
                }
            }
            if(isset($orderDetails['order']->order_passport_number) && $orderDetails['order']->order_passport_number!='')
            {
                $tData['tx_passport_number'] = $orderDetails['order']->order_passport_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->passport_number) && $userDetails->passport_number!='')
                {
                    $tData['tx_passport_number'] = $userDetails->passport_number;
                }
            }
            if(isset($orderDetails['order']->order_voter_epic_number) && $orderDetails['order']->order_voter_epic_number!='')
            {
                $tData['tx_voter_epic_number'] = $orderDetails['order']->order_voter_epic_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->voter_epic_number) && $userDetails->voter_epic_number!='')
                {
                    $tData['tx_voter_epic_number'] = $userDetails->voter_epic_number;
                }
            }
            if(isset($orderDetails['order']->order_driving_license_number) && $orderDetails['order']->order_driving_license_number!='')
            {
                $tData['tx_driving_license_number'] = $orderDetails['order']->order_driving_license_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->driving_license_number) && $userDetails->driving_license_number!='')
                {
                    $tData['tx_driving_license_number'] = $userDetails->driving_license_number;
                }
            }
            if(isset($orderDetails['order']->order_ration_card_number) && $orderDetails['order']->order_ration_card_number!='')
            {
                $tData['tx_ration_card_number'] = $orderDetails['order']->order_ration_card_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->ration_card_number) && $userDetails->ration_card_number!='')
                {
                    $tData['tx_ration_card_number'] = $userDetails->ration_card_number;
                }
            }
            if(isset($orderDetails['order']->total_price) && $orderDetails['order']->total_price>0)
            {
                $tData['tx_order_total_price'] = $orderDetails['order']->total_price;
            }
            if(isset($orderDetails['order']->app) && $orderDetails['order']->app>0)
            {
                $tData['tx_app'] = $orderDetails['order']->app;
            }
            if(isset($orderDetails['order']->created_by) && $orderDetails['order']->created_by>0)
            {
                $tData['tx_created_by'] = $orderDetails['order']->created_by;
            }
            if(isset($orderDetails['order']->address1) && $orderDetails['order']->address1!='')
            {
                $tData['address1'] = $orderDetails['order']->address1;
            }
            if(isset($orderDetails['order']->address2) && $orderDetails['order']->address2!='')
            {
                $tData['address2'] = $orderDetails['order']->address2;
            }
            if(isset($orderDetails['order']->address3) && $orderDetails['order']->address3!='')
            {
                $tData['address3'] = $orderDetails['order']->address3;
            }
            if(isset($orderDetails['order']->zipcode) && $orderDetails['order']->zipcode!='')
            {
                $tData['zipcode'] = $orderDetails['order']->zipcode;
            }
        }
        $checkTx = $this->checkPrevTx($txnid);
    	if(!empty($checkTx) && $checkTx == "True")
    	{
    		return true;
    	}
		return $tData;
    	//$q=$this->db->insert('transaction',$tData);
    	//$this->logaction->log($this->service,get_class($this),$this->db->last_query());
    }

    public function checkPrevTx($tx)
    {
    	$this->db->select("id");
		$this->db->from("transaction");
		$this->db->where("tx",$tx);
		$q=$this->db->get();
		if($q->num_rows() > 0)
		{
			return "True";
		}
		return "False";
    }

    public function updateTXIP($application_reference,$tempOrderID='',$original_orderId="")
    {
    	if($tempOrderID)
    	{
    		$this->db->select("ip_address");
    		$this->db->from("orders_temp");
    		$this->db->where("id",$tempOrderID);
			$q=$this->db->get();
			if($q->num_rows() > 0)
			{
				$ip_address = $q->row()->ip_address;
				$this->db->where("reference_id",$application_reference);
				$this->db->update("transaction",
									array(
											"ip_address"=>$ip_address,
										)
								);

				$this->db->where("id",$original_orderId);
				$this->db->update("orders",
									array(
											"ip_address"=>$ip_address,
										)
								);
			}
    	}
    }

    public function updateAuthNetTransaction($tx,$response)
	{
		unset($response->first_name);
		unset($response->last_name);
		unset($response->phone);
		unset($response->company);
		unset($response->address);
		unset($response->city);
		unset($response->state);
		unset($response->zip_code);
		unset($response->country);
		unset($response->fax);
		unset($response->email_address);
		$this->db->where("tx",$tx);
		$this->db->update("transaction",
							array(
									"t_status"=>1,
									'authorizenet_mode' =>$response->card_type." - ".$response->method,
									'authorizenet_authcode'=>$response->authorization_code,
									//'data'=>serialize($response),
									'modified_on'=>date("Y:m:d H:i:s")
								)
						);
		$this->logaction->log($this->service,"Authorize.net transaction data updated _ Tx: ".$tx);
		$this->logaction->log($this->service,"",$this->db->last_query());
	}

	public function updatePayFlowTransaction($tx,$response)
	{
		unset($response['LASTNAME']);
		unset($response['EXPDATE']);
		$this->db->where("tx",$tx);
		$this->db->update("transaction",
							array(
									"t_status"=>1,
									//'data'=>serialize($response),
									'modified_on'=>date("Y:m:d H:i:s")
								)
						);

		$this->logaction->log($this->service,"Paypal transaction data updated _ Tx: ".$tx);
		$this->logaction->log($this->service,"",$this->db->last_query());
	}
	public function updateTx($tx,$updateData)
	{
		$this->db->where("tx",$tx);
		$this->db->update("transaction",$updateData);
	}

	public function updateStripeTransaction($tx,$response)
	{
		$this->db->where("tx",$tx);
		$this->db->update("transaction",
							array(
									"t_status"=>1,
									//'data'=>serialize($response),
									'modified_on'=>date("Y:m:d H:i:s")
								)
							);
		$this->logaction->log($this->service,"Stripe transaction data updated _ Tx: ".$tx);
		$this->logaction->log($this->service,"",$this->db->last_query());
	}

    public function updateCCAvenueTransaction($tx,$vars)
	{
		$this->db->where("tx",$tx);
		$this->db->update("transaction",
							array(
									"t_status"=>1,
									'bank_ref_num' =>trim($vars['bank_ref_no']),
									'address1' =>trim($vars['billing_address']),
									'city' =>trim($vars['billing_city']),
									'state' =>trim($vars['billing_state']),
									'country' =>trim($vars['billing_country']),
									'zipcode' =>trim($vars['billing_zip']),
									'modified_on'=>date("Y:m:d H:i:s")
								)
						);
		$this->logaction->log($this->service,"CCAvenue transaction data updated _ Tx: ".$tx);
		$this->logaction->log($this->service,"",$this->db->last_query());
	}
    public function updatePayuTransaction($vars)
	{
		$bankRef='';
		if(isset($vars['bank_ref_num']))
			$bankRef=$vars['bank_ref_num'];

		$this->db->where("tx",$vars['txnid']);
		$this->db->update("transaction",
							array(
									'payu_mihpayid'=>$vars['mihpayid'],
									'payu_unmapped_status' =>trim($vars['unmappedstatus']),
									//'discount' =>trim($vars['discount']),
									'created_on' =>trim($vars['addedon']),
									//'firstname' =>trim($vars['firstname']),
									//'lastname' =>trim($vars['lastname']),
									//'address1' =>trim($vars['address1']),
									//'address2' =>trim($vars['address2']),
									//'city' =>trim($vars['city']),
									//'state' =>trim($vars['state']),
									//'country' =>trim($vars['country']),
									//'zipcode' =>trim($vars['zipcode']),
									//'pg_type' =>trim($ipn['PG_TYPE']),
									'bank_ref_num' =>$bankRef,
									'bankcode' =>trim($vars['bankcode']),
									//'cardnum' =>trim($vars['cardnum']),
									'field1' =>trim($vars['field1']),
									'field2' =>trim($vars['field2']),
									'field3' =>trim($vars['field3']),
									'field4' =>trim($vars['field4']),
									'field5' =>trim($vars['field5']),
									'field6' =>trim($vars['field6']),
									'field7' =>trim($vars['field7']),
									'field8' =>trim($vars['field8']),
									'udf6' =>trim($vars['udf6']),
									'udf7' =>trim($vars['udf7']),
									'udf8' =>trim($vars['udf8']),
									'udf9' =>trim($vars['udf9']),
									'udf10' =>trim($vars['udf10']),
									't_status'=>1
								)
						);
		$this->logaction->log($this->service,"PayU transaction data updated _ Tx: ".$vars['txnid']);
		$this->logaction->log($this->service,"",$this->db->last_query());
	}
	
	public function getPaypalIpn($tx)
	{
		$archivesDb = $this->load->database("data_archives",true,false);
		$archivesDb->where("txn_id",$tx);
		$q=$archivesDb->get("paypal_ipn");
		return $q->row();
	}
	public function getPayUIpn($merchantTransactionId,$notificationId='')
	{
		$archivesDb = $this->load->database("data_archives",true,false);
		$archivesDb->where("merchantTransactionId",$merchantTransactionId);
		if($notificationId!='')
			$archivesDb->where("notificationId",$notificationId);
		$q=$archivesDb->get("payu_ipn");
		return $q->row();
	}

	public function getCCAvenueIpn($tx,$trackingId)
	{
		$this->db->where("order_id",$tx);
		if($trackingId!='')
			$this->db->where("tracking_id",$trackingId);
		$q=$this->db->get("ccavenue_ipn");
		return $q->row();
	}
	public function putCCAvenueIpn($data)
	{
		$this->db->insert("ccavenue_ipn",$data);
	}

	public function processPurchase($reference,$transaction,$tempInfo,$ipn)
	{
		$tx=$transaction->tx;
		$this->logaction->log($this->service,"Receive payments - Direct payment reference | Process Purchase | Ref:".$reference." | Txnid: ".$tx);
		$sUrl='';
		$flashvars='';
		$sUrl='';
		if(in_array(strtolower($ipn->status),array("completed",'success','release payment','Release Payment','approved','captured','cash_pending','paid')))
		{
			$customData=unserialize($tempInfo->data);

			$modelName=$customData['model_name'];
			$CI =& get_instance();
			$CI->load->model($customData['model']);

			$data=$CI->$modelName->createOrder($reference,$transaction,$tempInfo,$ipn);
			$orderId=$data['order_id'];
			if($tempInfo->user_id!=0)
			{
				if($customData['created_by']==1)//Admin
					$sUrl=base_url.'orders/view/'.$data['order_id'];
				else//User
					$sUrl=base_url.'myorders/view/'.$data['order_id'];
			}
			else //Guest
			{
				if($customData['cart_type']==1)
					$sUrl=base_url.'poojas/receipt/'.$tx;
				else if($customData['cart_type']==2)
					$sUrl=base_url.'donations/receipt/'.$tx;
				else if($customData['cart_type']==3)
					$sUrl=base_url.'store/receipt/'.$tx;
				else if($customData['cart_type']==4)
					$sUrl=base_url.'subscriptions/receipt/'.$tx;

			}
			$flashvars='order_placed:1';
			$t_status=1;
			

			//$this->db->where("transaction_id",$tx);
			$this->db->where("reference_id",$reference);
    		$this->db->update("temp_payment_info",array("status"=>1));

    		/*if($customData['paymentMode']=='cash')
    		{
    			$data['orderId']=$orderId;
    			$data['redirect_to']=$sUrl;
    			return $data;
    		}*/
		}
		else
		{
			$sUrl=$tempInfo->fail_url;
			$orderId=0;
			$t_status=0;
		}

		//If not cash transactions
		if($tx!='')
		{
			$customData=unserialize($tempInfo->data);
			$tData=array(
							"redirect_url"=>$sUrl,
							'flashvars'=>$flashvars,
							't_status'=>$t_status,
							'order_id'=>$orderId,
							'status'=>$ipn->status,
							//'amount'=>$ipn->amount,
							'payment_mode'=>$customData['paymentMode'],
							'currency'=>$tempInfo->currency,
							'created_on'=>date("Y:m:d H:i:s")
						);

			if($orderId>0)
	        {
	        	$orderDetails=$this->orders_model->orderData($orderId);
	        	if(isset($orderDetails['order']->partial_payments_allowed) && $orderDetails['order']->partial_payments_allowed!='')
	            {
	                $tData['tx_partial_payments_allowed'] = $orderDetails['order']->partial_payments_allowed;
	            }
	            if(isset($orderDetails['order']->order_number) && $orderDetails['order']->order_number!='')
	            {
	                $tData['tx_order_number'] = $orderDetails['order']->order_number;
	            }
	            if(isset($orderDetails['order']->order_type) && $orderDetails['order']->order_type!='')
	            {
	                $tData['tx_order_type'] = $orderDetails['order']->order_type;
	            }
	            if(isset($orderDetails['order']->date) && $orderDetails['order']->date!='')
	            {
	                $tData['tx_order_date'] = date('Y-m-d', strtotime($orderDetails['order']->date));
	            }
	            if(isset($orderDetails['order']->username) && $orderDetails['order']->username!='')
	            {
	                $tData['tx_username'] = $orderDetails['order']->username;
	            }
	            $this->load->model("user/users_model");
                $userDetails = $this->users_model->userData($orderDetails['order']->user_id);
	            if(isset($orderDetails['order']->order_pan_number) && $orderDetails['order']->order_pan_number!='')
	            {
	                $tData['tx_pan_number'] = $orderDetails['order']->order_pan_number;
	            }
	            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
                {
                    if(isset($userDetails->pan_number) && $userDetails->pan_number!='')
                    {
                        $tData['tx_pan_number'] = $userDetails->pan_number;
                    }
                }
	            if(isset($orderDetails['order']->order_aadhaar_number) && $orderDetails['order']->order_aadhaar_number!='')
	            {
	                $tData['tx_aadhaar_number'] = $orderDetails['order']->order_aadhaar_number;
	            }
	            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
                {
                    if(isset($userDetails->aadhaar_number) && $userDetails->aadhaar_number!='')
                    {
                        $tData['tx_aadhaar_number'] = $userDetails->aadhaar_number;
                    }
                }
                if(isset($orderDetails['order']->order_tin_number) && $orderDetails['order']->order_tin_number!='')
	            {
	                $tData['tx_tin_number'] = $orderDetails['order']->order_tin_number;
	            }
	            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
	            {
	                if(isset($userDetails->tin_number) && $userDetails->tin_number!='')
	                {
	                    $tData['tx_tin_number'] = $userDetails->tin_number;
	                }
	            }
	            if(isset($orderDetails['order']->order_passport_number) && $orderDetails['order']->order_passport_number!='')
	            {
	                $tData['tx_passport_number'] = $orderDetails['order']->order_passport_number;
	            }
	            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
	            {
	                if(isset($userDetails->passport_number) && $userDetails->passport_number!='')
	                {
	                    $tData['tx_passport_number'] = $userDetails->passport_number;
	                }
	            }
	            if(isset($orderDetails['order']->order_voter_epic_number) && $orderDetails['order']->order_voter_epic_number!='')
	            {
	                $tData['tx_voter_epic_number'] = $orderDetails['order']->order_voter_epic_number;
	            }
	            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
	            {
	                if(isset($userDetails->voter_epic_number) && $userDetails->voter_epic_number!='')
	                {
	                    $tData['tx_voter_epic_number'] = $userDetails->voter_epic_number;
	                }
	            }
	            if(isset($orderDetails['order']->order_driving_license_number) && $orderDetails['order']->order_driving_license_number!='')
	            {
	                $tData['tx_driving_license_number'] = $orderDetails['order']->order_driving_license_number;
	            }
	            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
	            {
	                if(isset($userDetails->driving_license_number) && $userDetails->driving_license_number!='')
	                {
	                    $tData['tx_driving_license_number'] = $userDetails->driving_license_number;
	                }
	            }
	            if(isset($orderDetails['order']->order_ration_card_number) && $orderDetails['order']->order_ration_card_number!='')
	            {
	                $tData['tx_ration_card_number'] = $orderDetails['order']->order_ration_card_number;
	            }
	            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
	            {
	                if(isset($userDetails->ration_card_number) && $userDetails->ration_card_number!='')
	                {
	                    $tData['tx_ration_card_number'] = $userDetails->ration_card_number;
	                }
	            }
	            if(isset($orderDetails['order']->total_price) && $orderDetails['order']->total_price>0)
	            {
	                $tData['tx_order_total_price'] = $orderDetails['order']->total_price;
	            }
	            if(isset($orderDetails['order']->app) && $orderDetails['order']->app>0)
	            {
	                $tData['tx_app'] = $orderDetails['order']->app;
	            }
	            if(isset($orderDetails['order']->created_by) && $orderDetails['order']->created_by>0)
	            {
	                $tData['tx_created_by'] = $orderDetails['order']->created_by;
	            }
	            if(isset($orderDetails['order']->address1) && $orderDetails['order']->address1!='')
	            {
	                $tData['address1'] = $orderDetails['order']->address1;
	            }
	            if(isset($orderDetails['order']->address2) && $orderDetails['order']->address2!='')
	            {
	                $tData['address2'] = $orderDetails['order']->address2;
	            }
	            if(isset($orderDetails['order']->address3) && $orderDetails['order']->address3!='')
	            {
	                $tData['address3'] = $orderDetails['order']->address3;
	            }
	            if(isset($orderDetails['order']->zipcode) && $orderDetails['order']->zipcode!='')
	            {
	                $tData['zipcode'] = $orderDetails['order']->zipcode;
	            }
	        }
			
			if($customData['paymentMode']=='paypal')
			{
				$tData['tx']=$tx;
				$this->db->where("reference_id",$reference);
			}
			else
			{
				$this->db->where("tx",$tx);
			}
			
			$this->db->update("transaction",$tData);
		}
		//update order Id in archives db transaction table
		$this->updateOrderId($tx,$orderId);
		// Need to write logic here
		// if($customData['paymentMode']!='cash')
			$this->updateOrderTotalPaid($orderId,$ipn->amount,$tx);

		$this->populateTransactionReport($tx);
		$this->updateTransactionReconciliationReport($tx);
		return $orderId;
	}

	public function populateTransactionReport($tx)
	{
		$itemNameUpdateTables = [];
		$reports_db=$this->load->database("reports",true,false);
		$this->db->select("*");
        $this->db->from("transaction");
        $this->db->where_in("status",array("completed",'success','release payment','approved','captured','paid','Release Payment','Success'));
        $this->db->where("currency!=","");
        $this->db->where("tx",$tx);
        $this->db->where("amount>",0);
		$q=$this->db->get();
		$transactionResults = $q->result();
        foreach ($transactionResults as $tx_record)
        {
            if($tx_record->order_id)
            {
            	if(strtolower($tx_record->currency)=='inr')
            	{
            		$tableName = "tx_report_inr_";
            		$monthOfCreated = date("m",strtotime($tx_record->created_on));
            		$yearOfCreated = date("Y",strtotime($tx_record->created_on));
            		if($monthOfCreated>=4)
            		{
            			$tableName .= $yearOfCreated."-".financial_year_start_month_date;
                        $tableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
            		}
            		else
            		{
            			$tableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
                        $tableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
            		}
            		
            	}
            	else
            	{
            		$tableName = "tx_report_usd_".date("Y",strtotime($tx_record->created_on));
            	}

            	$tableName = str_replace("-","_",$tableName);
            	$this->orders_model->createNewTransactionReportTable($tableName);

            	if($tableName!='')
            	{
            		$itemNameUpdateTables[]=$tableName;
            	}

                $reports_db->where("tx",$tx_record->tx);
                $record_exist=$reports_db->get($tableName)->num_rows();
                
                if($tx_record->tx=='' || abs($tx_record->amount)==0 || $record_exist)
                {
                    continue;
                }
                if($tx_record->created_on=='')
                {
                    $tx_record->created_on=$tx_record->started_on;
                }
                $orderData=$this->orders_model->orderData($tx_record->order_id);
                if(empty($orderData['order']))
                {
                    echo $tx_record->order_id."\n";
                    continue;
                }
                $items=array();
                $itemNames='';
                foreach ($orderData['order_items'] as $itemData)
                {
                    if($itemData->subscription==1)
                        continue;
                    $items[$itemData->id]=$itemData;
                    if($itemNames!='') $itemNames.=" ,";
                    $itemNames.=$itemData->item_name;
                }

                $countryName='';
		    	$countryData=$this->locations_model->getCountryByCode($orderData['order']->country);
		    	if(!empty($countryData))
		    	{
		    		$countryName=$countryData->country_name;
		    	}

                if($tx_record->subscription==1)
                {
					
					foreach ($orderData['order_items'] as $itemData)
	                {
	                	if($itemData->id == $tx_record->order_item_id)
	                	{
	                		if($itemNames!='') $itemNames.=" ,";
	                    	$itemNames.=$itemData->item_name;
	                    	break;
	                	}
	                }
                    $insertData=array(
                                    "order_id"=> $orderData['order']->id,
                                    "order_item_id"=>$tx_record->order_item_id,
                                    "ashram_id"=>$tx_record->ashram_id,
                                    "trust_id"=>$tx_record->trust_id,
                                    "order_number"=>$orderData['order']->order_number,
                                    "order_date"=> $orderData['order']->date,
                                    "tx"=> $tx_record->tx,
                                    "item"=>$itemNames,
                                    "transaction_date"=>$tx_record->created_on,
                                    "amount"=> abs($tx_record->amount),
                                    "currency"=>$tx_record->currency,
                                    "order_type"=>$orderData['order']->order_type,
                                    "payment_mode"=>$tx_record->payment_mode,
                                    "user_id"=>$orderData['order']->user_id,
                                    "username" => $orderData['order']->username,
									"name" => $orderData['order']->firstname." ".$orderData['order']->middlename." ".$orderData['order']->lastname,
									"email" => $orderData['order']->email,
									"address_line_1" => $orderData['order']->address1,
									"address_line_2" => $orderData['order']->address2,
									"address_line_3" => $orderData['order']->address3,
									"city" => $orderData['order']->city,
									"state" => $orderData['order']->state,
									"country" => $countryName,
									"country_code" => $orderData['order']->country,
									"zip" => $orderData['order']->zipcode,
									"created_by" => $orderData['order']->created_by,
                                    "created_on"=>date("Y:m:d H:i:s")
                                );
                    $reports_db->insert($tableName,$insertData);
                }
                else
                {
                    $insertData=array(
                                    "order_id"=> $orderData['order']->id,
                                    "order_item_id"=>$tx_record->order_item_id,
                                    "ashram_id"=>$tx_record->ashram_id,
                                    "trust_id"=>$tx_record->trust_id,
                                    "order_number"=>$orderData['order']->order_number,
                                    "order_date"=> $orderData['order']->date,
                                    "tx"=> $tx_record->tx,
                                    "item"=>$itemNames,
                                    "transaction_date"=>$tx_record->created_on,
                                    "amount"=> abs($tx_record->amount),
                                    "currency"=>$tx_record->currency,
                                    "order_type"=>$orderData['order']->order_type,
                                    "payment_mode"=>$tx_record->payment_mode,
                                    "user_id"=>$orderData['order']->user_id,
                                    "username" => $orderData['order']->username,
									"name" => $orderData['order']->firstname." ".$orderData['order']->middlename." ".$orderData['order']->lastname,
									"email" => $orderData['order']->email,
									"address_line_1" => $orderData['order']->address1,
									"address_line_2" => $orderData['order']->address2,
									"address_line_3" => $orderData['order']->address3,
									"city" => $orderData['order']->city,
									"state" => $orderData['order']->state,
									"country" => $countryName,
									"country_code" => $orderData['order']->country,
									"zip" => $orderData['order']->zipcode,
									"created_by" => $orderData['order']->created_by,
                                    "created_on"=>date("Y:m:d H:i:s")
                                );
                    $reports_db->insert($tableName,$insertData);
                }
            }
        }

        $itemNameUpdateTables = array_unique($itemNameUpdateTables);
        foreach($itemNameUpdateTables as $thisTableName)
        {
	        $report = $reports_db->select("id,item,tx,order_id,order_item_id")->from($thisTableName)->where("item","")->get();
	        if($report->num_rows() > 0)
	        {
	        	$report_records = $report->result();
	        	foreach ($report_records as $key => $value) 
	        	{

	        		$report_orderData=$this->orders_model->orderData($value->order_id);
	                if(empty($report_orderData['order']))
	                {
	                    echo $value->order_id."\n";
	                    continue;
	                }
	                foreach ($report_orderData['order_items'] as $itemData1)
	                {
	                    if($itemData1->subscription==1 && $value->item == "")
	                    {
	                        $itemName = "Setup fee for subscription: ".$itemData1->item_name;

		                    $updateData = array("item"=>$itemName);

		                    $reports_db->where("id",$value->id);
							$reports_db->update($tableName,$updateData);
	                    }
	                }
	        	}
	        }
	    }
	}

	public function updateTransactionReconciliationReport($tx=0)
    {   
        $reportsDb=$this->load->database("reports",true,false);
        $this->db->select("*");
        $this->db->from("transaction");
        $this->db->where_in("status",array("completed",'success','release payment','approved','captured','paid','Release Payment','Success'));
        $this->db->where("currency!=","");
        $this->db->where_in("payment_mode",array("razorpay"));
        $this->db->where("tx",$tx);
        $this->db->where("amount>",0);
		$q=$this->db->get();
		$transactionResults = $q->result();
		foreach ($transactionResults as $tx_record)
        {
	        $checkTableName = "";
	        $transdate  = "";
	        if($tx_record->created_on!='')
	        {
	            $transdate  = date('Y-m-d', strtotime($tx_record->created_on));
	        }
	        if(strtolower($tx_record->currency)=='inr' && $transdate!='')
	        {
	            $checkTableName="tx_reconciliation_report_".strtolower($tx_record->currency)."_";
	            $monthOfCreated = date("m",strtotime($transdate));
	            $yearOfCreated = date("Y",strtotime($transdate));
	            if($monthOfCreated>=4)
	            {
	                $checkTableName .= $yearOfCreated."-".financial_year_start_month_date;
	                $checkTableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
	            }
	            else
	            {
	                $checkTableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
	                $checkTableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
	            }
	        }
	        else if(strtolower($tx_record->currency)=='usd' && $transdate!='')
	        {
	            $checkTableName="tx_reconciliation_report_".strtolower($tx_record->currency)."_".date('Y');
	        }

	        $checkTableName = str_replace("-","_",$checkTableName);

	        if($checkTableName !="" && $reportsDb->table_exists($checkTableName) )
	        {

	        }
	        else if($checkTableName !="")
	        {
	            $reportsDb->query("CREATE TABLE IF NOT EXISTS `".$checkTableName."` (
	                `id` int(11) NOT NULL AUTO_INCREMENT,
	                `ashram_id` int(11) DEFAULT '0',
	                `trust_id` int(11) DEFAULT '0',
	                `seva_date` date DEFAULT NULL,
	                `seva_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `seva_number` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `tx_date` datetime DEFAULT NULL,
	                `tx_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `tx_amount` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `gateway_tx_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `gateway_tx_amount` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `gateway_tx_date` datetime DEFAULT NULL,
	                `seva_total` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `currency` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `payment_gateway` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `payment_mode` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `transaction_status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `gateway_status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `user_id` int(10) NOT NULL DEFAULT 0,
	                `username` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `user_full_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
	                `user_phone` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
					`country_isd_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
					`is_no_transactions` ENUM('1','0') NOT NULL DEFAULT '0',
	                PRIMARY KEY(`id`)
	                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
	        }
	        if($checkTableName !="")
	        {
	        	$userFullName = "";
	        	if(isset($tx_record->firstname))
	        	{
	        		$userFullName .= $tx_record->firstname;
	        	}
	        	if(isset($tx_record->lastname))
	        	{
	        		$userFullName .= " ".$tx_record->lastname;
	        	}

	            $insertdata = [
	                            'ashram_id' => isset($tx_record->ashram_id) ? $tx_record->ashram_id: "",
	                            'trust_id' => isset($tx_record->trust_id) ? $tx_record->trust_id: "",
	                            'seva_date' => isset($tx_record->tx_order_date) ? $tx_record->tx_order_date: "",
	                            'seva_id' => isset($tx_record->order_id) ? $tx_record->order_id: "",
	                            'seva_number' => isset($tx_record->tx_order_number) ? $tx_record->tx_order_number: "",
	                            'tx_date' => isset($tx_record->created_on) ? $tx_record->created_on: "",
	                            'tx_id' => isset($tx_record->tx) ? $tx_record->tx: "",
	                            'tx_amount' => isset($tx_record->amount) ? $tx_record->amount: "",
	                            'seva_total' => isset($tx_record->tx_order_total_price) ? $tx_record->tx_order_total_price: "",
	                            'transaction_status' => isset($tx_record->status) ? $tx_record->status: "",
	                            'user_id' => isset($tx_record->userid) ? $tx_record->userid: "",
	                            'username' => isset($tx_record->tx_username) ? $tx_record->tx_username: "",
	                            'user_full_name' => $userFullName,
	                            'user_email' => isset($tx_record->email) ? $tx_record->email: "",
	                            'user_phone' => isset($tx_record->phone) ? $tx_record->phone: "",
	                            'country_isd_code' => isset($tx_record->country_isd_code) ? $tx_record->country_isd_code: "",
	                            'payment_gateway' => isset($tx_record->payment_mode) ? $tx_record->payment_mode: "",
	                            'payment_mode' => isset($tx_record->payment_mode) ? $tx_record->payment_mode: "",
	                            'currency' => isset($tx_record->currency) ? strtolower($tx_record->currency): "",
	                        ];

                $results = $reportsDb->select('*')->from($checkTableName)->where('gateway_tx_id', $tx_record->tx)->get()->row_array();
	            if(isset($results['id']) && isset($results['id'])>0)
	            {
	                $reportsDb->where('id', $results['id']);
	                $reportsDb->update($checkTableName,$insertdata);
	            }
	            else
	            {
	            	$reportsDb->insert($checkTableName,$insertdata);
	            }
	        }
	    }
    }

	public function updateOrderTotalPaid_old($order_id,$amount = 0,$trx_id = "")
	{
		$trans_ids = "";
		$paid_count = 0;
		$q = $this->db->select("total_paid,transaction_ids,total_price,order_type")->from("orders")->where("id",$order_id)->get()->row();
		if($q)
		{
			if($amount > 0)
			{
				$amount = $q->total_paid + $amount;
			}
			if($trx_id != "")
			{
				if(empty($q->transaction_ids))
					$trans_ids = $trx_id;
				else
					$trans_ids = $q->transaction_ids.",".$trx_id;

				$check_trans_ids = explode(",", $trans_ids);
				$paid_count = 0;
				if(!empty($check_trans_ids))
				{
					$paid_count = count($check_trans_ids);
				}
			}
			$updateData = array("total_paid"=>$amount,"transaction_ids"=>$trans_ids,"paid"=>$amount);
			if($q->order_type != 4)
			{
				if($q->total_price == $amount)
				{
					$updateData["payment_status"] = 1;
				}
			}
			if(($trx_id != "") && ($amount > 0))
			{
				$this->updateOrderItemRows($order_id,$amount,$trx_id);
			}
			$this->db->where("id",$order_id);
			$this->db->update("orders",$updateData);
		}
	}

	public function updateOrderTotalPaid($order_id,$amount = 0,$trx_id = "")
	{
		$trans_ids = "";
		$paid_count = 0;

		$q1 = $this->db->query("SELECT `o`.`id` as `order_id`, 
										SUM(IF(`ts`.`status` IN('completed', 'approved', 'success', 'paid', 'captured', 'Success', 'release payment', 'Release Payment'), ts.amount, 0)) as total_paid_amount,
										SUM(IF(`ts`.`status` IN('refund', 'Refund', 'Refunded', 'refunded'), ts.amount, 0)) as refund_amount,
										SUM(IF(`ts`.`status` IN('failed', 'failure'), ts.amount, 0)) as failed_amount,
										SUM(IF(`ts`.`status` IN('user cancelled'), ts.amount, 0)) as cancelled_amount,
										SUM(IF(`ts`.`status` IN('inprocess'), ts.amount, 0)) as inprocess_amount,
										SUM(IF(`ts`.`status` IN('bounced'), ts.amount, 0)) as bounced_amount,
										GROUP_CONCAT(IF(`ts`.`status` IN('completed', 'approved', 'success', 'paid', 'captured', 'Success', 'release payment', 'Release Payment') AND `ts`.`amount` >0, ts.tx, NULL) SEPARATOR ',') as paid_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('refund', 'Refund', 'Refunded', 'refunded'), ts.tx, NULL) SEPARATOR ',') as refund_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('failed', 'failure'), ts.tx, NULL) SEPARATOR ',') as failed_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('user cancelled'), ts.tx, NULL) SEPARATOR ',') as cancelled_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('inprocess'), ts.tx, NULL) SEPARATOR ',') as inprocess_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('bounced'), ts.tx, NULL) SEPARATOR ',') as bounced_transaction_ids,
										`o`.`currency`, 
										`o`.`order_type`, 
										`o`.`total_price`, 
										`o`.`payment_mode` 
								FROM `orders` as `o` 
								LEFT JOIN `transaction` as `ts` ON `ts`.`order_id`=`o`.`id` 
								WHERE `o`.`id` = '".$order_id."' 
								GROUP BY `o`.`id`");

		$paidOrder = $q1->row_array();
        if(!empty($paidOrder))
        {
    		$check_trans_ids = explode(",", $paidOrder['paid_transaction_ids']);
			$paid_count = 0;
			if(!empty($check_trans_ids))
			{
				$paid_count = count($check_trans_ids);
			}
			$no_paid_transactions = 'No';
    		if($paidOrder['paid_transaction_ids']=='')
    		{
    			$no_paid_transactions = 'Yes';
    		}
			$updateData = array(
								"total_paid"=>$paidOrder['total_paid_amount'],
								"paid_tx_ids"=>$paidOrder['paid_transaction_ids'],
								"refunded_tx_ids"=>$paidOrder['refund_transaction_ids'],
								"failed_tx_ids"=>$paidOrder['failed_transaction_ids'],
								"cancelled_tx_ids"=>$paidOrder['cancelled_transaction_ids'],
								"inprocess_tx_ids"=>$paidOrder['inprocess_transaction_ids'],
								"bounced_tx_ids"=>$paidOrder['bounced_transaction_ids'],
								"paid"=>$paidOrder['total_paid_amount'],
								"no_paid_transactions"=>$no_paid_transactions
							);
			if($paidOrder['order_type'] != 4)
			{
				if($paidOrder['total_price'] == $paidOrder['total_paid_amount'])
				{
					$updateData["payment_status"] = 1;
				}
			}
			if(($trx_id != "") && ($amount > 0))
			{
				$this->updateOrderItemRows($order_id,$amount,$trx_id);
			}

    		$this->db->where("id",$paidOrder['order_id']);
        	$this->db->update("orders",$updateData);


        	$this->logaction->log("system","Updated orders table id=".$paidOrder['order_id']." with total_paid=".$paidOrder['total_paid_amount'].", paid_tx_ids=".$paidOrder['paid_transaction_ids'].", refunded_tx_ids=".$paidOrder['refund_transaction_ids'].", failed_tx_ids=".$paidOrder['failed_transaction_ids'].", cancelled_tx_ids=".$paidOrder['cancelled_transaction_ids'].", inprocess_tx_ids=".$paidOrder['inprocess_transaction_ids'].", bounced_tx_ids=".$paidOrder['bounced_transaction_ids']." and no_paid_transactions=".$no_paid_transactions);
        }
	}

	public function updateOrderItemRows_old($order_id,$amount = 0,$trx_id = "")
	{
		$dbresult = $this->db->select("order_item_id,id")->from("transaction")->where("tx",$trx_id)->where("order_item_id!=",0)->get();
		if($dbresult->num_rows () > 0)
		{
			$fetch_result = $dbresult->row();
			$dbresult_oi = $this->db->select("id,paid_amount,paid_count,transaction_ids")->from("order_items")->where("id",$fetch_result->order_item_id)->get();
			
			$dbresult_oi_fetch = $dbresult_oi->row();
			$sub_tx = 1;
			if(empty($dbresult_oi_fetch->transaction_ids))
				$sub_trans_ids = $trx_id." (".date("d M Y").")";
			else
				$sub_trans_ids = $dbresult_oi_fetch->transaction_ids.", ".$trx_id;

			if($amount > 0)
			{
				$amount = $dbresult_oi_fetch->paid_amount + $amount;
			}

			$check_trans_ids = explode(",", $sub_trans_ids);
			$paid_count = 0;
			if(!empty($check_trans_ids))
			{
				$paid_count = count($check_trans_ids);
			}
			$this->db->where("id",$fetch_result->order_item_id);
			$this->db->update("order_items",array("paid_amount"=>$amount,"transaction_ids"=>$sub_trans_ids,"paid_count"=>$paid_count));
		}
	}

	public function updateOrderItemRows($order_id,$amount = 0,$trx_id = "")
    {
        $dbresult = $this->db->select("order_item_id,id")->from("transaction")->where("tx",$trx_id)->where("order_item_id!=",0)->get();
        if($dbresult->num_rows () > 0)
        {
            $fetch_result = $dbresult->row();
            $this->db->select("sum(amount) as total_paid_amount, count(id) as paid_counts, GROUP_CONCAT(tx) as transaction_ids, created_on as transaction_created_on");
            $this->db->from("transaction");
            $this->db->where_in('status',array('completed','approved','success','paid','captured','Success','refunded','refund','Refunded','Refund'));
            $this->db->where('amount >',0);
            $this->db->where('order_id >',0);
            $this->db->where('order_item_id >',0);
            $paidTransactions = $this->db->where("order_item_id",$fetch_result->order_item_id)->get()->row();


            $this->db->where("id",$fetch_result->order_item_id);
            $this->db->update("order_items",array("paid_amount"=>$paidTransactions->total_paid_amount,"transaction_ids"=>$paidTransactions->transaction_ids,"paid_count"=>$paidTransactions->paid_counts));

            $this->updateOrderItemRefundData($fetch_result->order_item_id);
        }
    }

    public function updateOrderItemRefundData($order_item_id=0)
    {
        if($order_item_id>0)
        {
        	$this->db->select("sum(amount) as total_paid_amount, count(id) as paid_counts, GROUP_CONCAT(tx) as transaction_ids, created_on as transaction_created_on");
            $this->db->from("transaction");
            $this->db->where_in('status',array('refunded','refund','Refunded','Refund'));
            $this->db->where('amount >',0);
            $this->db->where('order_id >',0);
            $this->db->where('order_item_id >',0);
            $refundTransactions = $this->db->where("order_item_id",$order_item_id)->get()->row();


            $this->db->where("id",$order_item_id);
            $this->db->update("order_items",array("subscription_refunded_amount"=>$refundTransactions->total_paid_amount,"refunded_counts"=>$refundTransactions->paid_counts,"refunded_transaction_ids"=>$refundTransactions->transaction_ids));
        }

    }

	public function transactionFailed($referenceId)
	{
		$this->db->where("reference_id",$referenceId);
		$qCart=$this->db->get("cart_data");
		if(!empty($qCart))
		{
			$this->db->where("reference_id",$referenceId);
			$this->db->update("cart_data",array("reference_id"=>''));
		}
	}

	public function clearTempPaymentsInfo()
	{
		$this->db->where("DATE(created_on) <=",date("Y:m:d",strtotime("-30 days")));
    	$this->db->delete("temp_payment_info");
	}

	//insert payment reaposne into archivesDb transaction table
	public function savingPaymentResponse($tx,$response,$user_id,$mode,$order_id=0){
		$tx_data = $this->getTransaction($tx);
		$transactionData = array("tx"=>$tx,
							"tx_id"=>($tx_data->id) ? $tx_data->id : 0,
							"order_id"=>$order_id,
							"user_id"=>$user_id,
							"payment_mode"=>$mode,
							"payment_response"=>serialize($response),
							"payment_date"=>date('Y-m-d H:i:s'),
						);
		$this->archivesDb->insert("transaction",$transactionData);
	}

	public function updateOrderId($tx,$order_id){
		$transactionData = array("order_id"=>$order_id);
		$this->archivesDb->where("tx",$tx);
		$this->archivesDb->update("transaction",$transactionData);
	}
	//saving complete transaction info 
	public function saveTransaction($transactionData){
		$this->db->insert("transaction",$transactionData);
	}
}
?>