<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Offline_Model extends CI_Model 
{

    function __construct() 
	{
	    parent::__construct();
    }

    public function processPayment($reference)
    {
    	$this->load->model("orders/orders_model");
    	$apiReturn['flag']=0;
    	$saveCard=0;
		$tempInfo=$this->payment_model->getTempInfo($reference);
		if(!empty($tempInfo))
		{
			$amount=$tempInfo->amount;
			$uid=$tempInfo->user_id;
			$currency=$tempInfo->currency;
			$customData=unserialize($tempInfo->data);

			$data['reference']=$reference;

    		$customData=unserialize($tempInfo->data);
    		$orderId=0;
    		if(isset($customData['order_id']))
    			$orderId=$customData['order_id'];

    		//Create transaction
    		$txnid=substr(hash('sha256', mt_rand() . microtime()), 0, 20);

    		$tData = $this->payment_model->createTransaction($txnid,$tempInfo->user_id,$reference,'paid',null,$orderId);
    		if(isset($customData['cartData']))
    		{
    			$tData = $this->payment_model->tempInfoUpdateTx($reference,$txnid,0,$tData);
    			//$this->transaction_model->setNote($txnid,"Authorization transaction");
    		}
    		else
    		{
    			$tData = $this->payment_model->tempInfoUpdateTx($reference,$txnid,$amount,$tData);
    			$this->transaction_model->setNote($txnid,date("d M Y H:i:s")." (Pending)"."\nPartial payment");
    		}

			//saving transaction table 
			$this->payment_model->saveTransaction($tData);
			//saving payment response into archives database
			$this->payment_model->savingPaymentResponse($txnid,"",$tempInfo->user_id,"offline",$orderId);
			$transaction=new stdClass();
			$transaction->tx=$txnid;
			$tempIpn=new stdClass();
			$tempIpn->status='paid';
			$tempIpn->amount=$amount;


			if(isset($customData['cartData']))
			{
				$orderId=$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
			}
			else
			{
				$this->orders_model->sendTransactionReceiptEmail($orderId,$txnid);
				//$this->orders_model->sendTransactionReceiptEmailBcc($orderId,$txnid);
			}

			$transactionRecord=$this->payment_model->getTransaction($txnid);
			$apiReturn['redirect_url']=$transactionRecord->redirect_url;
			$apiReturn['order_id']=$orderId=$transactionRecord->order_id;
			$apiReturn['tx']=$txnid;

    		$apiReturn['flag']=1;

    		if(!isset($customData['cartData']))
    		{
    			$this->orders_model->calculateDue($orderId);
    		}

			if(isset($customData['cartData']))
			{
				$transactionAmounts=array();
				$amount=0;
				$has_subscription=0;
				$dup_has_subscription=0;
				$orderData=$this->orders_model->orderData($orderId);
				
				foreach ($orderData['order_items'] as $itemData)
				{
					if(($orderData['order']->order_type==4 || $orderData['order']->order_type==2) && $itemData->subscription==1)
					{
						$dup_has_subscription=1;
						$transactionAmounts[]=array(
													"amount"=>$itemData->price*$itemData->quantity,
													"onetime_charge"=>$itemData->onetime_charge,
													"subscription"=>1,
													"itemData"=>$itemData,
													"startDate"=>$itemData->schedule_dates,
													"user_id"=>$orderData['order']->user_id
												);
						$has_subscription=1;
					}
					else
					{
						$amount+=$itemData->quantity*($itemData->price+$itemData->shipping_price);
					}
				}
				$transactionAmounts[]=array(
										"amount"=>$amount,
										"subscription"=>0
									);

				foreach ($transactionAmounts as $transactionDetail)
				{
					if(isset($transactionDetail['subscription']) && $transactionDetail['subscription']==1)
					{
			    		if($transactionDetail['onetime_charge'])
			    		{
			    			$txnid=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
				    		//$this->payment_model->createTransaction($txnid,$tempInfo->user_id,$reference,'cash_pending',null,$orderId);
				    		$tData = $this->payment_model->createTransaction($txnid,$tempInfo->user_id,$reference,'pending',null,$orderId);
				    		$tData = $this->payment_model->tempInfoUpdateTx($reference,$txnid,$transactionDetail['onetime_charge'],$tData);

							//saving transaction table 
							$this->payment_model->saveTransaction($tData);
							//saving payment response into archives database
							$this->payment_model->savingPaymentResponse($txnid,"",$tempInfo->user_id,"offline",$orderId);

				    		//$this->transaction_model->setNote($txnid,"Setup fee for subscription: ".$transactionDetail['itemData']->item_name);

				    		$this->transaction_model->updateDetails($txnid,array("order_item_id"=>$transactionDetail['itemData']->id));

				    		//$this->orders_model->sendTransactionReceiptEmail($orderId,$txnid);
				    	}

			    		//$this->orders_model->updateSubscription($transactionDetail['itemData']->order_item_id,$result_array,$transactionDetail['itemData']);

						$tempIpn=new stdClass();
						$tempIpn->status='cash_pending';
						$tempIpn->amount=$amount;
					}
					else
					{
						if($dup_has_subscription==1)
						{
							$txnid=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
				    		$tData = $this->payment_model->createTransaction($txnid,$tempInfo->user_id,$reference,'pending',null,$orderId);
				    		$tData = $this->payment_model->tempInfoUpdateTx($reference,$txnid,$transactionDetail['amount'],$tData);
							//saving transaction table 
							$this->payment_model->saveTransaction($tData);
							//saving payment response into archives database
							$this->payment_model->savingPaymentResponse($txnid,"",$tempInfo->user_id,"offline",$orderId);

						}
						if($has_subscription==1)
						{
			    			$txnid=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
				    		//$this->payment_model->createTransaction($txnid,$tempInfo->user_id,$reference,'cash_pending',null,$orderId);
				    		//$this->payment_model->tempInfoUpdateTx($reference,$txnid,$transactionDetail['amount']);
				    		//$this->payment_model->updatePayFlowTransaction($result_array['PNREF'],$result_array);

							/*$transaction=new stdClass();
							$transaction->tx=$txnid;
							$tempIpn=new stdClass();
							$tempIpn->status='cash_pending';
							$tempIpn->amount=$amount;*/
						}
					}
				}
			}
			return $apiReturn;
		}
		else
		{
			$this->logaction->log($this->service,"Direct payment method - Invalid Ref:".$reference."  - redirected back");
			return $apiReturn;
		}
    }

    public function cancelSubscription($profileId,$ashramId,$cartType,$currency)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data
		
    	$api_request_params = array (
		    			// API Data
		    			'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
		    			'TRXTYPE' => 'R',
		    			'ACTION'=>'C',
		    			'ORIGPROFILEID'=>$profileId,
		    	);
    	$nvp = $this->toNVP($api_request_params);
    	$result = $this->runCurl($trustData->payflow_url, $nvp);
    	$result_array = array();
		parse_str($result, $result_array);
		$this->payflow_logs_model->log($result_array,"Subscription cancellation");
		return $result_array;
    }

    public function activateSubscription($profileId,$ashramId,$cartType,$currency,$nextPaymentDate)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data

    	$api_request_params = array (
		    			// API Data
		    			'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
		    			'TRXTYPE' => 'R',
		    			'ACTION'=>'R',
		    			'START'=>date("mdY",strtotime($nextPaymentDate)),
		    			'ORIGPROFILEID'=>$profileId,
		    	);
    	$nvp = $this->toNVP($api_request_params);
    	$result = $this->runCurl($trustData->payflow_url, $nvp);
    	$result_array = array();
		parse_str($result, $result_array);
		$this->payflow_logs_model->log($result_array,"Subscription activation");
		return $result_array;
    }

    public function subscriptionPayments($profileId,$ashramId,$cartType,$currency)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data
    	$api_request_params = array
    			(
                        'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
                        'ORIGPROFILEID'=>$profileId,
                        'PAYMENTHISTORY'=>'Y',
                        'TRXTYPE' => 'R',
                        'ACTION'=>'I',
                        "VERBOSITY"=>"HIGH"
                );
        $nvp = $this->toNVP($api_request_params);
        $result = $this->runCurl($trustData->payflow_url, $nvp);
        $result_array = array();
        parse_str($result, $result_array);

        $this->payflow_logs_model->log($result_array,"Subscription read");
        return $result_array;
    }

    public function expireSubscription($profileId,$ashramId,$cartType,$currency)
    {
    	//Get trust data
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$cartType);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[$currency];
		//Get trust data
    	$api_request_params = array
    			(
                        'USER' => $trustData->payflow_user,
                        'VENDOR' => $trustData->payflow_vendor,
                        'PARTNER' => $trustData->payflow_partner,
                        'PWD' => $trustData->payflow_pwd,
                        'ORIGPROFILEID'=>$profileId,
                        'PAYMENTHISTORY'=>'Y',
                        'TRXTYPE' => 'R',
                        'ACTION'=>'I',
                        "VERBOSITY"=>"HIGH"
                );
        $nvp = $this->toNVP($api_request_params);
        $result = $this->runCurl($trustData->payflow_url, $nvp);
        $result_array = array();
        parse_str($result, $result_array);

        $this->payflow_logs_model->log($result_array,"Subscription expiration");

        return $result_array;
    }
}
?>