<?PHP
class Oauth_sessions_Model extends CI_Model 
{
	private $tableName="oauth_sessions";
	public function __construct()
	{
		parent::__construct();
	}
	public function get($access_token)
	{
		$this->db->where("access_token",$access_token);
		return $this->db->get($this->tableName)->row();
	}
	public function update($access_token,$session_data)
	{
		$data=$this->get($access_token);
		if(empty($data))
		{
			$this->db->insert($this->tableName,array(
														"access_token"=>$access_token,
														"session_data"=>serialize($session_data),
														"session_id"=>session_id()
													)
										);
		}
		else
		{
			$this->db->where("access_token",$access_token);
			$this->db->update($this->tableName,array("session_data"=>serialize($session_data)));
		}
	}

	public function update_session_id($access_token,$session_id)
	{
		$this->db->where("access_token",$access_token);
		$this->db->update($this->tableName,array("session_id"=>$session_id));
	}

	public function session_check()
	{
		$aData=$this->get($this->server->access_token);
        if(empty($aData))
        {
            $this->load->model("oauth2/oauth_access_tokens_model");
            $this->load->model("user/users_model");
            $accessTokenInfo=$this->oauth_access_tokens_model->get_access_token_info($this->server->access_token);
            $userData=$this->users_model->userDataByEmailorUsername($accessTokenInfo->user_id);

            $this->session->set_userdata("loggedIn",1);
            if($userData->admin==0)
            {
	            $this->session->set_userdata("user_id",$userData->id);
	            $this->session->set_userdata("user_data",$userData);
	        }
	        else
	        {
	        	$this->session->set_userdata("id",$userData->id);
	            $this->session->set_userdata("admin_data",$userData);
	        }

            $this->update($this->server->access_token,$this->session->all_userdata());
        }
        else
        {
        	session_id($aData->session_id);
            $this->session->set_userdata(unserialize($aData->session_data));
            
        }

        $session_id=session_id();

        $this->db->where("id",$session_id);
        $this->db->order_by("timestamp","desc");
        $this->db->limit(1);
        $session_latest=$this->db->get("ci_sessions")->row();
        //echo $session_latest->timestamp;
        //exit;
        if(!empty($session_latest))
        {
	        //$this->db->where("id",$session_id);
	        //$this->db->where("timestamp !=",$session_latest->timestamp);
	        //$q=$this->db->delete("ci_sessions");
	        //echo $this->db->last_query();
	    }
	}
}
?>