<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notifications_Model extends CI_Model 
{
	var $tableName="notifications";
	var $siteServivcesDb = "";
	var $serviceData=array(
							"messages"=>array("icon_label"=>"label-info","icon_class"=>"fa fa-envelope"),
							"techsupport"=>array("icon_label"=>"label-warning","icon_class"=>"icomoon-new-message"),
							"files"=>array("icon_label"=>"label-info","icon_class"=>"icomoon-file"),
							"default"=>array("icon_label"=>"label-danger","icon_class"=>"icomoon-bulb")
						);
	function __construct()
	{
        parent::__construct();
        $this->siteServivcesDb = $this->load->database("site_services",true,false);
    }
	
	public function getNotifications($userId)
	{
		$this->siteServivcesDb->where("status",0);
		$this->siteServivcesDb->where("user_id",$userId);
		$this->siteServivcesDb->order_by("date","asc");
		$query = $this->siteServivcesDb->get($this->tableName);

		$this->siteServivcesDb->where("status",0);
		$this->siteServivcesDb->where("user_id",$userId);
		$this->siteServivcesDb->update($this->tableName,array("count_status"=>1));
		return $query->result();
	}
	function notificationData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->get($this->tableName);
		return $query->row();
	}
	
	public function addNotification($userId,$message,$link,$service='')
	{
		if($service=='' || !isset($this->serviceData[$service]))
		{
			$theme=$this->serviceData['default'];
		}
		else
		{
			$theme=$this->serviceData[$service];
		}
		$q=$this->siteServivcesDb->insert($this->tableName,
                            array(
								'date' => date("Y:m:d H:i:s"),
								'message' =>$this->general_model->filtertext(trim($message)),
								'link'=>$link,
								'user_id'=>$userId,
								'icon_class'=>$theme['icon_class'],
								'icon_label'=>$theme['icon_label']
							)
							);
			
	}
	public function remove($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$q=$this->siteServivcesDb->update($this->tableName,
                            array(
								'status' => 1
							)
							);
			
	}
}
?>