<?PHP
class Login_validate extends CI_Model 
{
	var $logtrack='';
	var $tableName="users";
	var $auth_check="";
    function __construct()
    {
        parent::__construct();
		
		$this->logtrack=$this->load->database("site_services",true);
		$this->auth_check=$this->load->database("sso_auth",true);
    }

    public function userData($id)
	{
		$q1 = $this->db->select("id")->from("users")->where("sso_user_id",$id)->get();
		return $q1->row();
	}

	function validate($post,$appLoginUserId=0)
	{		
		$this->auth_check->select("*");
		$this->auth_check->from($this->tableName);
		$this->auth_check->where("suspended",0);
		$this->auth_check->where("deleted",0);

		if($appLoginUserId)
		{
			$this->auth_check->where("id",$appLoginUserId);
		}
		else
		{
			$this->auth_check->group_start();

			$this->auth_check->where("username",$post['username']);
			$this->auth_check->or_where("email",$post['username']);

			$this->auth_check->group_end();
		}
		
		$query = $this->auth_check->get();

		if ($this->agent->is_browser())
		{
			$agent = $this->agent->browser().' '.$this->agent->version();
		}
		elseif ($this->agent->is_robot())
		{
			$agent = $this->agent->robot();
		}
		elseif ($this->agent->is_mobile())
		{
			$agent = $this->agent->mobile();
		}
		else
		{
			$agent = 'Unidentified User Agent';
		}
		
		if($query->num_rows())
		{
			$r=$query->row();
			if($r->admin==0 && $GLOBALS['site_settings']['user_login']==0)
			{
				if(!in_array($r->email, special_login_users))
					return 0;
			}
			if($r->admin==1 && $GLOBALS['site_settings']['admin_login']==0)
			{
				return 0;
			}
			if($r->deleted==1)
			{
				$this->session->set_flashdata("login_error",'Invalid user credentials. Please login with another account.');
				return 0;
			}
			if($r->email_verified==0)
			{
				$this->session->set_flashdata("invalid_login_email_notverified",1);
				return 5;
			}
			if($r->status==2)
			{
				$this->session->set_flashdata("login_error",'Invalid user credentials. Please login with another account.');
				return 0;
			}
			if($r->status == 0 || $r->status == 2)
			{
				return 0;
			}
			if($r->pass_hash!='')
			{
				if(isset($post['pwd']) && !$this->users_model->verifyPasswordHash($post['pwd'],$r->pass_hash) && $appLoginUserId==0)
				{
					return 0;
				}
			}
			else
			{
				if(!$appLoginUserId)
				{
					if($this->users_model->verifyPasswordHash($post['pwd'],$r->pass_hash)!=$r->pass_hash)
					{
						return 0;
					}
					else if($r->admin==0)
					{
						$this->session->set_userdata("force_change_password",1);
					}
				}
				else
				{
					if($r->admin==0)
					{
						$this->session->set_userdata("force_change_password",1);
					}
				}
			}

			if(!$this->userData($r->id))
			{
				$this->insertuser($r);
			}
			if(1==1)
			{
				$this->load->model("sso_auth/partner_users_update_log_model");
				$listData = $this->partner_users_update_log_model->getList();
				if($listData)
				{
					$this->partner_users_update_log_model->updateAllUsers();
				}
			}
			$r = $this->users_model->ProfileuserData($r->id);
			$this->session->set_userdata("loggedIn",1);
            if($r->admin==1)
            {
                $this->session->set_userdata("id",$r->id);
                $this->session->set_userdata("admin_data",$r);
                if($r->ashram_id!=0)
                {
                	$this->session->set_userdata("ashramId",$r->ashram_id);
                }
                if($r->satsang_id!=0)
                {
                	$this->session->set_userdata("satsangId",$r->satsang_id);
                }
            }
            else
            {
                $this->session->set_userdata("user_id",$r->id);
                $this->session->set_userdata("user_data",$r);
            }

			$this->logaction->log($this->service,"Login attempt with Username/Email ID - ".$r->username.": Logged In");
			
            if($this->session->userdata('user_id'))
            {
            	$cartTypes=array(1,2,3,4);
            	foreach ($cartTypes as $cartType)
            	{
	            	//Case 1
	            	//If user already have an existing cart
	                $this->db->where("user_id",$this->session->userdata("user_id"));
	                $this->db->where("cart_type",$cartType);
	                $this->db->where("reference_id is null",null,false);
	                $q1=$this->db->get("cart_data");
	                if($q1->num_rows()==1)
	                {
	                	$cartRow=$q1->row();
	                	$cartContents=unserialize($cartRow->cart_data);
	                	foreach ($cartContents as $key => $cartItem)
	                	{
	                		if($cartType==1)
	                		{
			                	$this->session->set_userdata("poojasCartAshramIdSelection",$cartItem['options']['ashram_id']);
			                	$this->session->set_userdata("poojasCartAshramId",$cartItem['options']['ashram_id']);
			                }
			                if($cartType==2)
	                		{
			                	$this->session->set_userdata("donationCartAshramIdSelection",$cartItem['options']['ashram_id']);
			                	$this->session->set_userdata("donationCartAshramId",$cartItem['options']['ashram_id']);
			                }
			                if($cartType==3)
	                		{
			                	$this->session->set_userdata("storeCartAshramIdSelection",$cartItem['options']['ashram_id']);
			                	$this->session->set_userdata("storeCartAshramId",$cartItem['options']['ashram_id']);
			                }
			                if($cartType==4)
	                		{
			                	$this->session->set_userdata("subscriptionCartAshramIdSelection",$cartItem['options']['ashram_id']);
			                	$this->session->set_userdata("subscriptionCartAshramId",$cartItem['options']['ashram_id']);
			                }
		                	break;
		                }
	                	//Update session ID for user's existing cart
	                	$row1=$q1->row();
	                	$this->db->where("id",$row1->id);
	                	$this->db->where("cart_type",$cartType);
	                	$this->db->update("cart_data",array("session_id"=>session_id()));

	                	//Delete any other records with same session ID
	                	$this->db->where("session_id",session_id());
	                	$this->db->where("id !=",$row1->id);
	                	$this->db->where("cart_type",$cartType);
	                	$this->db->delete("cart_data");
	                }

	                //Case 2
	                //If user dont have any existing cart
	                if($q1->num_rows()==0)
	                {
	                	$this->db->where("session_id",session_id());
		                $this->db->where("user_id",0);
		                $this->db->where("cart_type",$cartType);
		                $this->db->update("cart_data",array("user_id"=>$this->session->userdata("user_id")));
	                }
	            }
            }
                        
			
			$this->db->where("id",$r->id);
			$this->db->update($this->tableName,
									array(
											"last_logged_in"=>date("Y:m:d H:i:s"),
											'last_session_id'=>session_id(),
											"site_flag_".global_site_flag=>1
										)
							);
			$this->auth_check->where("id",$r->sso_user_id);
			$this->auth_check->update($this->tableName,
									array(
											"last_logged_in"=>date("Y:m:d H:i:s"),
											'last_session_id'=>session_id(),
											"site_flag_".global_site_flag=>1
										)
							);
			
			$this->loggedInTrack($r,0);
			
			return 1;
		}
		else
		{
			$pusername='';
			$pemail='';
			$ploginkey='';
			$ploginkey=isset($post['username'])?$post['username']:'';
			$pusername=isset($post['username'])?$post['username']:'';
			
			$this->db->select("*");
			$this->db->from($this->tableName);
			$this->db->where("suspended",0);
			$this->db->where("deleted",0);
			$this->db->where("status",1);
			$this->db->where("pass_hash",$this->users_model->verifyPasswordHash($post['pwd'],$post['pwd']));
			$q2=$this->db->get();
			if($q2->num_rows()==0)
			{
				$this->logaction->log($this->service,"Login attempt - ".$ploginkey.": Password Invalid");
				$this->db->insert("login_record",array(
							'date'=>date("Y:m:d H:i:s"),
							'ip_address'=>$_SERVER['REMOTE_ADDR'],
							'browser'=>$agent,
							'username'=>$pusername,
							'email'=>$pemail,
							'action'=>"Password Invalid",
							'key'=>'wrong_login'
							));
			}
			else
			{
				$this->logaction->log($this->service,"Login attempt - ".$ploginkey.": User ID/Email ID Invalid");
				$this->db->insert("login_record",array(
								'date'=>date("Y:m:d H:i:s"),
								'ip_address'=>$_SERVER['REMOTE_ADDR'],
								'browser'=>$agent,
								'username'=>$pusername,
								'email'=>$pemail,
								'action'=>"User ID/Email ID Invalid",
								'key'=>'wrong_login'
								));
			}
			return 0;
		}
	}

	public function insertuser($infoArray)
	{
		$this->db->insert('users',
	                        array(
	                        	'username' => $infoArray->username,
	                        	'sso_user_id'=>$infoArray->id,
								'pass_hash' => $infoArray->pass_hash,
								'firstname' => $infoArray->firstname,
								'middlename' => $infoArray->middlename,
								'lastname' => $infoArray->lastname,
								'email' =>$infoArray->email,
								"zipcode"=>$infoArray->zipcode,
								"phoneno"=>$infoArray->phoneno,
								"country_id"=>$infoArray->country,
								'country'=>$infoArray->country,
								'registered_on' => $infoArray->registered_on,
								'role'=>0,
								'conf_key'=>$infoArray->conf_key,
								'admin'=>$infoArray->admin,
								"registered_site"=>$infoArray->registered_site,
								'registered_from_ip'=>$infoArray->registered_from_ip,
								'roles'=>$infoArray->roles,
								'created_by'=>$infoArray->created_by,
								'email_verified'=>1,
								'status'=>$infoArray->status,
								"user_type"=>$infoArray->user_type,
								"site_flag_".global_site_flag=>1,
								"profession"=>($infoArray->profession) ? $infoArray->profession : "",
								"birthstar"=>($infoArray->birthstar) ? $infoArray->birthstar : "",
								"raasi"=>($infoArray->raasi) ? $infoArray->raasi : "",
								"gothram"=>($infoArray->gothram) ? $infoArray->gothram : "",
								"gender"=>($infoArray->gender) ? $infoArray->gender : "",
								"dob"=>($infoArray->dob) ? $infoArray->dob : "",
								"address"=>($infoArray->address) ? $infoArray->address : "",
								"address1"=>($infoArray->address1) ? $infoArray->address1 : "",
								"address2"=>($infoArray->address2) ? $infoArray->address2 : "",
								"block_sms"=>($infoArray->block_sms) ? $infoArray->block_sms : 0,
								"state"=>($infoArray->state) ? $infoArray->state : "",
								"city"=>($infoArray->city) ? $infoArray->city : "",
								"pan_number"=>($infoArray->pan_number) ? $infoArray->pan_number : "",
								"profile_complete"=>($infoArray->profile_complete) ? $infoArray->profile_complete : 0,
								"receive_newsletters"=>($infoArray->receive_newsletters) ? $infoArray->receive_newsletters : 1,
								)
							);
			$uid=$this->db->insert_id();
	}

	function loggedInTrack($userData,$app=0,$service='')
	{
		if ($this->agent->is_browser())
		{
			$agent = $this->agent->browser().' '.$this->agent->version();
		}
		elseif ($this->agent->is_robot())
		{
			$agent = $this->agent->robot();
		}
		elseif ($this->agent->is_mobile())
		{
			$agent = $this->agent->mobile();
		}
		else
		{
			$agent = 'Unidentified User Agent';
		}
		if($app==1)
		{
			$agent.="(App/Api)";
		}
		$message="Logged In";
		if($service!='')
		{
			$message.=" with ".$service;
		}
		$this->logtrack->insert('login_track',
                            	array
								(
									'time_stamp'=>date("Y:m:d H:i:s"),
									'session_id'=>session_id(),
									'user_id'=>$userData->id,
									'username'=>$userData->username,
									'email'=>$userData->email,
									'admin'=>$userData->admin,
									'role'=>$userData->role,
									'ip_address'=>$_SERVER['REMOTE_ADDR'],
									'browser'=>$agent,
									'os_type'=>$this->agent->platform(),
									'message'=>$message,
									'app'=>$app
								));
	}

	function validate_external($response,$service='',$app=0)
	{
		login:

		if($service=='yahoo')
			$email=$response->profile->emails[0]->handle;
		else
			$email=$response->email;

		$this->auth_check->select("*");
		$this->auth_check->from($this->tableName);
		$this->auth_check->where("email",$email);
		
		$query = $this->auth_check->get();

		if ($this->agent->is_browser())
		{
			$agent = $this->agent->browser().' '.$this->agent->version();
		}
		elseif ($this->agent->is_robot())
		{
			$agent = $this->agent->robot();
		}
		elseif ($this->agent->is_mobile())
		{
			$agent = $this->agent->mobile();
		}
		else
		{
			$agent = 'Unidentified User Agent';
		}
		
		if($query->num_rows())
		{
			$r=$query->row();
			if($r->admin==0 && $GLOBALS['site_settings']['user_login']==0)
			{
				if(!in_array($r->email, special_login_users))
					return 0;
			}
			if($r->admin==1 && $GLOBALS['site_settings']['admin_login']==0)
			{
				return 0;
			}
			if($r->deleted==1)
			{
				$this->session->set_flashdata("login_error",'JGD, invalid user credentials. Please login with another account.');
				return 0;
			}
			if($r->status==2)
			{
				$this->session->set_flashdata("login_error",'Invalid user credentials. Please login with another account.');
				return 0;
			}
			if($r->suspended==1)
			{
				$this->session->set_flashdata("login_error",'JGD, invalid user credentials. Please login with another account.');
				return 0;
			}
			
			//LoggedIn
			if($app=="app")
			{
	        	$post_fields = 'client_id='.mobile_app_client_id.
                '&client_secret='.mobile_app_client_secret.
                '&grant_type=password'.
                '&username='.$r->username.
                '&password=nopassword'.
                '&app=1'.
                '&scope=user'.
                '&key='.dp_api_admin_bypass_key.
                '&service='.$service;
                
	            $headers = [
	                'Content-Type:application/x-www-form-urlencoded'
	            ];
	            $token_url=base_url.'restapi/authenticate';
	            $ch = curl_init();
	            curl_setopt($ch, CURLOPT_URL, $token_url);
	            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
	            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	            curl_setopt($ch, CURLOPT_POST, 1);
	            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
	            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	            $token_response = curl_exec($ch);
	            curl_close($ch);
	        	return $token_response;
	        }
	        if(!$this->userData($r->id))
			{
				$this->insertuser($r);
			}
			$r = $this->users_model->ProfileuserData($r->id);
			$this->session->set_userdata("loggedIn",1);
			$this->session->set_userdata("login_method",$service);
            if($r->admin==1)
            {
                $this->session->set_userdata("id",$r->id);
                $this->session->set_userdata("admin_data",$r);
                if($r->ashram_id!=0)
                {
                	$this->session->set_userdata("ashramId",$r->ashram_id);
                }
                if($r->satsang_id!=0)
                {
                	$this->session->set_userdata("satsangId",$r->satsang_id);
                }
            }
            else
            {
                $this->session->set_userdata("user_id",$r->id);
                $this->session->set_userdata("user_data",$r);
            }

			$this->logaction->log($this->service,"Login attempt with Username/Email ID - ".$email.": Logged In");
			
            if($this->session->userdata('user_id'))
            {
            	$cartTypes=array(1,2,3,4);
            	foreach ($cartTypes as $cartType)
            	{
	            	//Case 1
	            	//If user already have an existing cart
	                $this->db->where("user_id",$this->session->userdata("user_id"));
	                $this->db->where("cart_type",$cartType);
	                $this->db->where("reference_id is null",null,false);
	                $q1=$this->db->get("cart_data");
	                /*echo $this->db->last_query();
	                echo $q1->num_rows();
	                exit;*/
	                if($q1->num_rows()==1)
	                {
	                	$cartRow=$q1->row();
	                	$cartContents=unserialize($cartRow->cart_data);
	                	foreach ($cartContents as $key => $cartItem)
	                	{
	                		if($cartType==1)
	                		{
			                	$this->session->set_userdata("poojasCartAshramIdSelection",$cartItem['options']['ashram_id']);
			                	$this->session->set_userdata("poojasCartAshramId",$cartItem['options']['ashram_id']);
			                }
			                if($cartType==2)
	                		{
			                	$this->session->set_userdata("donationCartAshramIdSelection",$cartItem['options']['ashram_id']);
			                	$this->session->set_userdata("donationCartAshramId",$cartItem['options']['ashram_id']);
			                }
			                if($cartType==3)
	                		{
			                	$this->session->set_userdata("storeCartAshramIdSelection",$cartItem['options']['ashram_id']);
			                	$this->session->set_userdata("storeCartAshramId",$cartItem['options']['ashram_id']);
			                }
			                if($cartType==4)
	                		{
	                			$this->session->set_userdata("subscriptionCartAshramIdSelection",$cartItem['options']['ashram_id']);
			                	$this->session->set_userdata("subscriptionCartAshramId",$cartItem['options']['ashram_id']);
			                }
		                	break;
		                }

	                	//Update session ID for user's existing cart
	                	$row1=$q1->row();
	                	$this->db->where("id",$row1->id);
	                	$this->db->where("cart_type",$cartType);
	                	$this->db->update("cart_data",array("session_id"=>session_id()));

	                	//Delete any other records with same session ID
	                	$this->db->where("session_id",session_id());
	                	$this->db->where("id !=",$row1->id);
	                	$this->db->where("cart_type",$cartType);
	                	$this->db->delete("cart_data");
	                }

	                //Case 2
	                //If user dont have any existing cart
	                if($q1->num_rows()==0)
	                {
	                	$this->db->where("session_id",session_id());
		                $this->db->where("user_id",0);
		                $this->db->where("cart_type",$cartType);
		                $this->db->update("cart_data",array("user_id"=>$this->session->userdata("user_id")));
	                }
	            }
            }

				$this->db->where("id",$r->id);
				$this->db->update($this->tableName,
									array(
											"last_logged_in"=>date("Y:m:d H:i:s"),
											'last_session_id'=>session_id(),
											"email_verified"=>1,
											"status"=>1,
											"site_flag_".global_site_flag=>1
										)
							);
				$this->auth_check->where("id",$r->sso_user_id);
				$this->auth_check->update($this->tableName,
									array(
											"email_verified"=>1,
											"status"=>1,
											"site_flag_".global_site_flag=>1
										)
							);

				if($app!="app")
				$this->loggedInTrack($r,0,$service);
			
			return 1;
		}
		else
		{
			$domain=$service;
			try
			{
				$emailParts=array_filter(explode("@",$email));
				$username=$emailParts[0];

				while(1)
				{
					$usernameExist=$this->userutil->verifyUsername($username,0);
					if($usernameExist==1)
					{
						$username.=random_string('numeric', 2);
						continue;
					}
					else
					{
						break;
					}
				}

				$this->load->helper('string');
				$tempPassword=random_string('alpha', 8);
				$password=$this->users_model->generatePasswordHash($tempPassword);

				if($service=='google')
				{
					$firstname=$response->given_name;
					$lastname=$response->family_name;
				}
				else if($service=='facebook')
				{
					$nameParts=array_filter(explode(" ",$response->name,2));
					$firstname=$nameParts[0];
					$lastname=$nameParts[1];
				}
				else if($service=='microsoft')
				{
					$nameParts=array_filter(explode(" ",$response->name,2));
					$firstname=$nameParts[0];
					$lastname=$nameParts[1];
				}
				else if($service=='yahoo')
				{
					$firstname=$response->profile->givenName;
					$lastname=$response->profile->familyName;
				}

				$countryData=$this->locations_model->getCountryByCode("IN");
				$this->auth_check->insert('users',
		                        array(
		                        	'username' => $username,
									'pass_hash' => $password,
									'firstname' => ucwords(strtolower($firstname)),
									'middlename' => '',
									'lastname' => ucwords(strtolower($lastname)),
									'email' => strtolower($email),
									"country_id"=>"IN",
									'country'=>$countryData->country_name,
									'registered_on' => date("Y:m:d H:i:s"),
									'role'=>0,
									'conf_key'=>random_string('alnum',20),
									'admin'=>0,
									'registered_from_ip'=>$_SERVER['REMOTE_ADDR'],
									'status'=>1,
									'roles'=>2,
									"email_verified"=>1,
									'created_by'=>0,
									"registered_site"=>$service
									)
								);
				$sso_user_id=$this->auth_check->insert_id();
				$datta_id = date("Y").$sso_user_id;
				$this->auth_check->where("id",$sso_user_id);
				$this->auth_check->update($this->tableName,
										array(
												"datta_unique_id"=>$datta_id,
											)
								);
				$this->db->insert('users',
		                        array(
		                        	'username' => $username,
									'pass_hash' => $password,
									"sso_user_id"=>$sso_user_id,
									'firstname' => ucwords(strtolower($firstname)),
									'middlename' => '',
									'lastname' => ucwords(strtolower($lastname)),
									'email' => strtolower($email),
									"country_id"=>"IN",
									'country'=>$countryData->country_name,
									'registered_on' => date("Y:m:d H:i:s"),
									'role'=>0,
									'conf_key'=>random_string('alnum',20),
									'admin'=>0,
									'registered_from_ip'=>$_SERVER['REMOTE_ADDR'],
									'status'=>1,
									'roles'=>2,
									"email_verified"=>1,
									'created_by'=>0,
									"registered_site"=>$service
									)
								);
				$uid=$this->db->insert_id();
				$subscribe_name=$firstname." ".$lastname;
				$subscribe_email=$email;
				$this->subscriptions_email_model->subscribe(array("subscribe_name1"=>$subscribe_name,"subscribe_email"=>$subscribe_email,"country_code1"=>"IN"),0);
				$this->db->where("id",$uid);
				$quser=$this->db->get("users");
				$newUser=$quser->row();

				$email_data['udata']=$newUser;
				$email_data['tempPassword']=$tempPassword;
				$content=$this->load->view("users/admin/_email_temp_password",$email_data,true);
	            
	          	$to=$newUser->email;
	          	$subject='Welcome to ' .short_ashram_name.' - '.$newUser->username;
	          	$this->load->library("email_extension");
	          	
	          	$this->email_extension->sendMailGuest("users",$newUser->firstname." ".$newUser->lastname,$newUser->email,$subject,$content,'',1);

	            $this->logaction->log("users","Registration email along with temp password has been sent to ".$newUser->email);

	            $this->load->model("subscriptions/donors_model");
	            $this->donors_model->createDefault($sso_user_id);

				goto login;
			}
			catch(Exception $e)
			{
				return 0;
			}
		}
	}
}
?>