<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Locations_model extends CI_Model
{
	var $location='';
	public function __construct()
	{
		parent::__construct();
		$this->location=$this->load->database("location",true,false);
	}
	public function getCountryByCode($countryCode)
	{
		$this->location->where(array("country_code"=>$countryCode));
		$r=$this->location->get("countries_list");
		return $r->row();
	}
	public function getCountryByIsd($isdCode)
	{
		$this->location->where(array("isd_code"=>$isdCode));
		$r=$this->location->get("countries_list");
		return $r->row();
	}
	public function getCountriesByCode($countryCode)
	{
		$this->location->where_in("country_code",$countryCode);
		$r=$this->location->get("countries_list");
		return $r->result();
	}
	public function getStatesByCountryCode($countryCode)
	{
		$this->location->where(array("country_id"=>$countryCode));
		$this->location->order_by('state_name','asc');
		$r=$this->location->get("states_list");
		return $r->result();
	}
	public function getStateByCode($stateCode,$countryCode)
	{
		$this->location->where(array("country_id"=>$countryCode,'state_id'=>$stateCode));
		$r=$this->location->get("states_list");
		return $r->row();
	}
	public function getCitiesByCountryState($countryCode,$stateCode)
	{
		$this->location->where(array("country_code"=>$countryCode,"state_code"=>$stateCode));
		$this->location->order_by('city_name','asc');
		$r=$this->location->get("cities_list");
		return $r->result();
	}
	public function getCityByName($city,$stateCode,$countryCode)
	{
		$this->location->where(array("country_code"=>$countryCode,'state_code'=>$stateCode,'city_name'=>$city));
		$r=$this->location->get("cities_list");
		return $r->row();
	}
	public function getCountryState($countryCode,$stateCode)
	{
		$this->location->select('*');
		$this->location->from('countries_list');
		$this->location->join('states_list', 'states_list.country_id = countries_list.country_code');
		$this->location->where(array("countries_list.country_code"=>$countryCode,'states_list.state_id'=>$stateCode));
		$query = $this->location->get();
		return $query->row();
	}
	public function getCountries($formatted=false)
	{
		$this->location->select("country_code,country_name,isd_code,priority");
		$this->location->order_by('priority','desc');
		$this->location->order_by('country_name','asc');
        $query = $this->location->get("countries_list");
        if($formatted==false)
        return $query->result();
    	else
    	{
    		$cntry=array();
    		foreach ($query->result() as $cn)
    		{
    			$cntry[$cn->country_code]=$cn;
    		}
    		return $cntry;
    	}
    }
    public function getCityById($cityId)
    {
    	$this->location->where("id",$cityId);
		$r=$this->location->get("cities_list");
		return $r->row();
    }
    
}
?>