<?PHP
class General_Model extends CI_Model 
{
	public function __construct()
	{
		parent::__construct();
	}
	function filtertext($str)
    {
		$abusiveWords = explode(",",$GLOBALS['site_settings']['abusive_words']);

    	$filteredString = word_censor($str, $abusiveWords, '***');
		return $filteredString;
    }
    public function help_link()
    {
    	$c=$this->uri->segment(1);
		$m=$this->uri->segment(2);
		?>
        <a href="/kb/<?PHP echo $c.'/'.$m; ?>" title="Help" target="_blank" class="kb-link tooltips hidden-print"
         data-container="body" data-placement="bottom" data-original-title="Help">
            <i class="icomoon-help" style="font-size: 24px;"></i>
        </a>
        <?PHP
    }
    public function create_thumb50($path,$dest)
	{
		$this->load->helper('image');
		$image = new SimpleImage();
		$image->load($path);
		$w=$image->getWidth();
		$h=$image->getHeight();

		if($w>$h)
		{
			$w1=$w*(50/$h);
			$image->crop50($w1,50);
		}
		else if($w<$h)
		{
			$h1=$h*(50/$w);
			$image->crop50(50,$h1);
		}
		else
		{
			$image->crop50(50,50);
		}
		$image->save($dest);
	}
	public function create_thumb_300($path,$dest)
	{
		$this->load->helper('image');
		$image = new SimpleImage();
		$image->load($path);
		$w=$image->getWidth();
		$h=$image->getHeight();

		if($w>$h)
		{
			$w1=$w*(300/$h);
			$image->crop300($w1,300);
		}
		else if($w<$h)
		{
			$h1=$h*(300/$w);
			$image->crop300(300,$h1);
		}
		else
		{
			$image->crop300(300,300);
		}
		$image->save($dest);
	}
	public function create_thumb_150($path,$dest)
	{
		$this->load->helper('image');
		$image = new SimpleImage();
		$image->load($path);
		$w=$image->getWidth();
		$h=$image->getHeight();

		if($w>$h)
		{
			$w1=$w*(150/$h);
			$image->crop($w1,150);
		}
		else if($w<$h)
		{
			$h1=$h*(150/$w);
			$image->crop(150,$h1);
		}
		else
		{
			$image->crop(150,150);
		}
		$image->save($dest);
	}
	function is_url_exist($url)
	{
	    $ch = curl_init($url);    
	    curl_setopt($ch, CURLOPT_NOBODY, true);
	    curl_exec($ch);
	    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

	    if($code == 200)
	    {
			$status = true;
	    }
	    else
	    {
	    	$status = false;
	    }
	    curl_close($ch);
	  	return $status;
	}
	public function getLanguages() 
	{
		$siteServivcesDb = $this->load->database("site_services",true,false);
        $siteServivcesDb->select( 'lang_id,lang_name' );
        $siteServivcesDb->from( 'languages' );
        $query = $siteServivcesDb->get();
        
        return $query->result();
    }

    public function valid_date($str)
	{
		// setup
		$CI =&get_instance();
		$params = explode(',',"d M Y, ");

		$date_parts = explode(" ", $params[0]);

		// get the index (0, 1 or 2) for each part
		$di = $this->valid_date_part_index($date_parts, 'd');
		$mi = $this->valid_date_part_index($date_parts, 'M');
		$yi = $this->valid_date_part_index($date_parts, 'Y');

		// regex setup
		$dre =   "(0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)";
		//$mre = "(0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12)";
		$mre = "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)";
		$yre = "([0-9]{4})";
		$red = ' '; // escape delimiter for regex
		$rex = "/^[0]{$red}[1]{$red}[2]/";

		// do replacements at correct positions
		$rex = str_replace("[{$di}]", $dre, $rex);
		$rex = str_replace("[{$mi}]", $mre, $rex);
		$rex = str_replace("[{$yi}]", $yre, $rex);

		if (preg_match($rex, $str, $matches))
		{
			return true;
		}
		else
			return false;
	}

	public function valid_date2($str)
	{
		// setup
		$CI =&get_instance();
		$params = explode(',',"d-M-Y, ");

		$date_parts = explode("-", $params[0]);

		// get the index (0, 1 or 2) for each part
		$di = $this->valid_date_part_index($date_parts, 'd');
		$mi = $this->valid_date_part_index($date_parts, 'M');
		$yi = $this->valid_date_part_index($date_parts, 'Y');

		// regex setup
		$dre =   "(0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)";
		//$mre = "(0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12)";
		$mre = "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)";
		$yre = "([0-9]{4})";
		$red = '-'; // escape delimiter for regex
		$rex = "/^[0]{$red}[1]{$red}[2]/";

		// do replacements at correct positions
		$rex = str_replace("[{$di}]", $dre, $rex);
		$rex = str_replace("[{$mi}]", $mre, $rex);
		$rex = str_replace("[{$yi}]", $yre, $rex);

		if (preg_match($rex, $str, $matches))
		{
			return true;
		}
		else
			return false;
	}

	public function valid_date3($str)
	{
		// setup
		$CI =&get_instance();
		$params = explode(',',"Y-m-d");

		$date_parts = explode("-", $params[0]);
		// get the index (0, 1 or 2) for each part
		$di = $this->valid_date_part_index($date_parts, 'd');
		$mi = $this->valid_date_part_index($date_parts, 'm');
		$yi = $this->valid_date_part_index($date_parts, 'Y');

		// regex setup
		$dre =   "(0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)";
		$mre = "(0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12)";
		// $mre = "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)";
		$yre = "([0-9]{4})";
		$red = '-'; // escape delimiter for regex
		$rex = "/^[0]{$red}[1]{$red}[2]/";

		// do replacements at correct positions
		$rex = str_replace("[{$di}]", $dre, $rex);
		$rex = str_replace("[{$mi}]", $mre, $rex);
		$rex = str_replace("[{$yi}]", $yre, $rex);

		// echo '<pr>'; print_r($str); die();
		if (preg_match($rex, $str, $matches))
		{
			return true;
		}
		else
			return false;
	}

	

	private function valid_date_part_index($parts, $search)
	{
		for ($i = 0; $i <= count($parts); $i++)
		{
			if ($parts[$i] == $search)
			{
				return $i;
			}
		}
	}

	public function valid_time($str)
	{
		$params = explode(' ',$str);
		if(count($params)!=2)
		{
			return false;
		}
		$timeParts=array_filter(explode(":",$params[0]));
		if(count($timeParts)!=2)
		{
			return false;
		}

		$hh=abs($timeParts[0]);
		$mm=abs($timeParts[1]);

		if($hh<1 || $hh>12)
		{
			return false;
		}

		if($mm<0 || $mm>59)
		{
			return false;
		}

		$meridian=$params[1];
		if($meridian!='AM' && $meridian!="PM")
		{
			return false;
		}

		return true;
	}

	public function ajaxPaginationCreateLinks($totalNum,$perPage)
	{
		$config['use_page_numbers'] = true;
		$config['page_query_string'] = true;
		$config['base_url'] ="javascript:;";
		$config['total_rows'] = $totalNum;
		$config['uri_segment'] = 3;
		$config['num_links'] = 2;
		$config['per_page'] = $perPage; 
		
		$config['prev_link'] = 'Prev';
		$config['prev_tag_open'] = ' <li class="prev" onClick="paginateMe(this)">';
		$config['prev_tag_close'] = '</li>';
		$config['next_link'] = 'Next';
		$config['next_tag_open'] = '<li class="next" onClick="paginateMe(this)">';
		$config['next_tag_close'] = '</li>';
		
		$config['cur_tag_open'] = '<li class="active"><a href="javascript:;">';
		$config['cur_tag_close'] = '</a></li>';
		
		$config['num_tag_open'] = '<li onClick="paginateMe(this)">';
		$config['num_tag_close'] = '</li>';
		
		$config['last_link'] = 'Last';
		$config['last_tag_open'] = '<li class="next" onClick="paginateMe(this)">';
		$config['last_tag_close'] = '</li>';
		
		$config['first_link'] = 'First';
		$config['first_tag_open'] = '<li class="prev" onClick="paginateMe(this)">';
		$config['first_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		return $this->pagination->create_links();
	}

	public function paginationCreateLinks($totalNum,$perPage,$url)
	{
		$config['use_page_numbers'] = true;
		$config['page_query_string'] = true;
		$config['base_url'] =$url;
		$config['total_rows'] = $totalNum;
		$config['uri_segment'] = 3;
		$config['num_links'] = 2;
		$config['per_page'] = $perPage; 
		
		$config['prev_link'] = 'Prev';
		$config['prev_tag_open'] = ' <li class="prev">';
		$config['prev_tag_close'] = '</li>';
		$config['next_link'] = 'Next';
		$config['next_tag_open'] = '<li class="next">';
		$config['next_tag_close'] = '</li>';
		
		$config['cur_tag_open'] = '<li class="active"><a href="javascript:;">';
		$config['cur_tag_close'] = '</a></li>';
		
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		
		$config['last_link'] = 'Last';
		$config['last_tag_open'] = '<li class="next">';
		$config['last_tag_close'] = '</li>';
		
		$config['first_link'] = 'First';
		$config['first_tag_open'] = '<li class="prev">';
		$config['first_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		return $this->pagination->create_links();
	}

	function fileSizeConvert($bytes)
	{
		if($bytes==0)
			return '0 KB';
	    $bytes = floatval($bytes);
	        $arBytes = array(
	            0 => array(
	                "UNIT" => "TB",
	                "VALUE" => pow(1024, 4)
	            ),
	            1 => array(
	                "UNIT" => "GB",
	                "VALUE" => pow(1024, 3)
	            ),
	            2 => array(
	                "UNIT" => "MB",
	                "VALUE" => pow(1024, 2)
	            ),
	            3 => array(
	                "UNIT" => "KB",
	                "VALUE" => 1024
	            ),
	            4 => array(
	                "UNIT" => "B",
	                "VALUE" => 1
	            ),
	        );

	    foreach($arBytes as $arItem)
	    {
	        if($bytes >= $arItem["VALUE"])
	        {
	            $result = $bytes / $arItem["VALUE"];
	            $result = strval(round($result, 2))." ".$arItem["UNIT"];
	            break;
	        }
	    }
	    return $result;
	}

	public function amountToWords($number) 
	{
		if (($number < 0) || ($number > 999999999)) {
			throw new Exception("Number is out of range");
		}
 
		$Gn = floor($number / 1000000);
		/* Millions (giga) */
		$number -= $Gn * 1000000;
		$kn = floor($number / 1000);
		/* Thousands (kilo) */
		$number -= $kn * 1000;
		$Hn = floor($number / 100);
		/* Hundreds (hecto) */
		$number -= $Hn * 100;
		$Dn = floor($number / 10);
		/* Tens (deca) */
		$n = $number % 10;
		/* Ones */
 
		$res = "";
 
		if ($Gn) {
			$res .= $this->amountToWords($Gn) .  "Million";
		}
 
		if ($kn) {
			$res .= (empty($res) ? "" : " ") .$this->amountToWords($kn) . " Thousand";
		}
 
		if ($Hn) {
			$res .= (empty($res) ? "" : " ") .$this->amountToWords($Hn) . " Hundred";
		}
 
		$ones = array("", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eightteen", "Nineteen");
		$tens = array("", "", "Twenty", "Thirty", "Fourty", "Fifty", "Sixty", "Seventy", "Eigthy", "Ninety");
 
		if ($Dn || $n) {
			if (!empty($res)) {
				$res .= " and ";
			}
 
			if ($Dn < 2) {
				$res .= $ones[$Dn * 10 + $n];
			} else {
				$res .= $tens[$Dn];
 
				if ($n) {
					$res .= " " . $ones[$n];
				}
			}
		}
 
		if (empty($res)) {
			$res = "zero";
		}
 
		return $res;
	}

	function base64ToImage($imageData)
	{
	    list($type, $imageData) = explode(';', $imageData);
	    list(,$extension) = explode('/',$type);
	    list(,$imageData)      = explode(',', $imageData);
	    $fileName = uniqid().'.'.$extension;
	    $imageData = base64_decode($imageData);
	    $temp_path="/tmp/".$fileName;
	    file_put_contents($temp_path, $imageData);
	    return $temp_path;
	}
}
?>