<?PHP
class Emails_Model extends CI_Model
{
	var $tableName='mail_track_';
	var $emailDb='';
    function __construct()
    {
        parent::__construct();
        $this->emailDb=$this->load->database("emails",true,false);
    }

    public function listemails($serviceSlug,$excel=0)
	{
		if(!$this->emailDb->table_exists($this->tableName.$serviceSlug))
		{
			$toBeReturn = [
							"recordsTotal" => "0",
							"recordsFiltered" => "0",
							"data" => [],
							"page_records" => 0
						];
			return $toBeReturn;
		}
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$i=0;
		if($excel==0)
			$this->emailDb->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$this->emailDb->select("*");
		}
		$this->emailDb->from($this->tableName.$serviceSlug);
		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nSearch Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
			isset($_POST['search_col']) && in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']) &&
			isset($_POST['wild']) && in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			if($_POST['wild']=='starts')
			{
				$this->emailDb->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$this->emailDb->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$this->emailDb->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			}
			$preData.='"'.$_POST['search_text'].'"';
		}

		if(preg_match("/inr/i",$serviceSlug))
		{
			$preData.="\nPayments: ";
			$preData.=" INR ";
		}
		else if(preg_match("/usd/i",$serviceSlug))
		{
			$preData.="\nPayments: ";
			$preData.=" USD ";
		}
		
		$preData.="\nStatus: ";
		if(isset($_POST['status']) && $_POST['status'] != "" && in_array($_POST['status'],array(0,1,2,"bounced")))
		{
			if($_POST['status'] == "bounced")
			{
				$this->emailDb->where("bounced",1);
				$preData.="Bounced";
			}
			else
			{
				$this->emailDb->where("status",$_POST['status']);
				if($_POST['status']==0)
				{
					$preData.="Pending";
				}
				if($_POST['status']==1)
				{
					$preData.="Sent";
				}
				if($_POST['status']==2)
				{
					$preData.="Failed";
				}
			}
		}

		$preData.="\nViewed: ";
		if(isset($_POST['viewed']) && is_numeric($_POST['viewed']) && in_array($_POST['viewed'],array(0,1)))
		{
			$this->emailDb->where("viewed",$_POST['viewed']);
			if($_POST['viewed']==0)
				$preData.="No";
			else
				$preData.="Yes";
		}
		$preData.="\nFrom Date: ";
		if(isset($_POST['date_col']) && in_array($_POST['date_col'],array('date','sent_on')) &&
			isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$this->emailDb->where("date(".$_POST['date_col'].") >=",date("Y:m:d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date']." (".$GLOBALS['current_acl']['excel_columns'][$_POST['date_col']].")";
		}
		$preData.="\nTo Date: ";
		if(isset($_POST['date_col']) && in_array($_POST['date_col'],array('date','sent_on')) &&
			isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$this->emailDb->where("date(".$_POST['date_col'].") <=",date("Y:m:d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date']." (".$GLOBALS['current_acl']['excel_columns'][$_POST['date_col']].")";
		}
		
		$preData.="\nResent: ";
		if(isset($_POST['resent']) && is_numeric($_POST['resent']) && in_array($_POST['resent'],array(0,1)))
		{
			$this->emailDb->where("resent",$_POST['resent']);
			if($_POST['resent']==0)
				$preData.="No";
			else
				$preData.="Yes";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$this->emailDb->order_by($_POST['order_by'],$_POST['dir']);
				else
					$this->emailDb->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$this->emailDb->order_by('date',$_POST['dir']);
				else
					$this->emailDb->order_by('date',"desc");
			}
			$sql=$this->emailDb->get_compiled_select();

			$slug_title_part='';
			if(preg_match("/payments_/i",$serviceSlug))
			{
				$slug_title_part="Orders";
			}
			else if(preg_match("/payments/i",$serviceSlug))
			{
				$slug_title_part="Payments";
			}
			else
			{
				$slug_title_part=$this->breadcrumb[$serviceSlug]['titlepart'];
			}
			$requestResp=$this->excel_exports_model->makeRequest($serviceSlug,"model","emails_model",$sql,$this->currentUser,"emails",$_POST,$slug_title_part." - All Emails",$preData);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $this->emailDb->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}
		
		$dir='desc';
		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];
		
		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$this->emailDb->order_by($col_name,$dir);
			else
				$this->emailDb->order_by('date',$dir);
		}
		else
		{
			$this->emailDb->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			$start=abs($_POST['start']);
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']))
		{
			$length=abs($_POST['length']);
		}


		$this->emailDb->limit($length,$start);

		$rtn['data']=$this->emailDb->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y h:i A",strtotime($row['date']));
			$rtn['data'][$c]['DT_RowId']=10;
			if($rtn['data'][$c]['sent_on'])
				$rtn['data'][$c]['sent_on']=date("d M Y h:i A",strtotime($row['sent_on']));
			else
				$rtn['data'][$c]['sent_on']="N/A";
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function eventUpdate($response)
	{
		if(!empty($response['key']))
		{
			$tableName=$response['key'];
			$event=$response['event'];
			if(!empty($response['alt_key']))
			{
				$queueID=$response['alt_key'];

				if(preg_match("/mail_track_/i",$tableName))
				{
					$dbObj=$this->emailDb;
				}
				else
				{
					$dbObj=$this->db;
				}
				$dbObj->where("id",$queueID);
				$email_record=$dbObj->get($tableName)->row();

				if(!empty($email_record))
				{
					$updateData=array();
					if($event=='delivered' || $event=='delivery')
					{
						$updateData['delivered']=1;
					}
					if($event=='clicked')
					{
						$updateData['clicked']=($email_record->clicked+1);
					}
					if($event=='opened' || $event=='clicked')
					{
						$updateData['viewed']=1;
						$updateData['delivered']=1;
						$updateData['reads']=($email_record->reads+1);
					}
					foreach ($updateData as $updateKey => $updateValue)
					{
						$dbObj->set($updateKey,$updateValue);
					}
					$dbObj->where("id",$queueID);
					$dbObj->update($tableName,$updateData);
				}
			}
		}
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->emailDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Message ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subject");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Created");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Sent");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Resent?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->message_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->mail_subject);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->mail_to);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			if($reportrow->sent_on!='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->sent_on)));
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			
			$status="Pending";
			if($reportrow->bounced==1 && $reportrow->status==1)
			{
				$status = "Bounced";
			}
			else if($reportrow->status==1 && $reportrow->status==0)
			{
				$status = "Not Sent";
			}
			else
			{
				if($reportrow->status==1)
					$status="Sent";
				if($reportrow->status==2)
					$status="Failed";
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);

			$resent="No";
			if($reportrow->resent==1)
				$resent="Yes";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resent);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>