<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Credit_cards_model extends CI_Model 
{
	protected $tableName="credit_cards";
    function __construct() 
	{
	    parent::__construct();
    }
    public function saveCard($userId,$cardNumber,$cardExpiry,$cardName,$cardType,$payflowPnref)
    {
        $card_expiry_month = substr($cardExpiry, 0, 2);;
        $card_expiry_year = substr($cardExpiry, 2, 4);

        if(!empty($card_expiry_year))
        {
            if($card_expiry_year == "00")
                $card_expiry_year = "30".$card_expiry_year;
            else
                $card_expiry_year = "20".$card_expiry_year;
        }
    	$this->db->insert($this->tableName,
    						array(
    								"user_id"=>$userId,
    								'payflow_pnref'=>$payflowPnref,
    								"card_number"=>$cardNumber,
    								"card_name"=>$cardName,
    								"card_type"=>$cardType,
                                    "card_expiry_month"=>$card_expiry_month,
                                    "card_expiry_year"=>$card_expiry_year,
    								"card_expiry"=>$cardExpiry,
    								"created_on"=>date("Y:m:d H:i:s")
    							)
    					);
    }
    public function getCards($userId)
    {
    	$this->db->where("user_id",$userId);
    	$q=$this->db->get($this->tableName);
    	return $q->result();
    }
    public function cardExist($cardNumber,$userId)
    {
		$this->db->where("card_number",$cardNumber);
		$this->db->where("user_id",$userId);
    	$q=$this->db->get($this->tableName);
    	return $q->num_rows();
    }
    public function getCard($id)
    {
    	$this->db->where("id",$id);
    	$q=$this->db->get($this->tableName);
    	return $q->row();
    }
    public function delete($id)
    {
        $this->db->where("id",$id);
    	$q=$this->db->delete($this->tableName);
    }

    public function notify_expiry_cards()
    {
        $this->load->model("user/users_model");
        $months = array("01","02","03","04","05","06","07","08","09","10","11","12");
        $current_month = date("m");
        if($current_month == "12")
        {
            $check_month = "12";
            $check_year = date("Y");
        }
        else
        {
            $check_month = $current_month;
            $check_year = date("Y");
        }
        $maxDays=date('t');
        $currentDayOfMonth=date('j');
        $this->db->select('id,card_expiry_month,card_expiry_year,user_id,card_number,30_days_alert,15_days_alert,7_days_alert');
        $this->db->from($this->tableName);
        $this->db->where("card_expiry_month",$check_month);
        $this->db->where('card_expiry_year',$check_year);
        $this->db->where('is_expired',"0");
        $result = $this->db->get()->result_array();
        if ($result) 
        {
            foreach ($result as $key => $value) 
            {
                if(($currentDayOfMonth >= 1 && $currentDayOfMonth <= 15) && ($value["30_days_alert"] == 1))
                {
                    continue;
                }
                if(($currentDayOfMonth >= 15 && $currentDayOfMonth <= 21) && ($value["15_days_alert"]  == 1))
                {
                    continue;
                }
                if(($currentDayOfMonth >= 21) && ($value["7_days_alert"]  == 1))
                {
                    continue;
                }
                if($value["30_days_alert"] != 1 || $value["15_days_alert"]  != 1 || $value["7_days_alert"]  != 1)
                {
                    $userData = $this->users_model->userData($value["user_id"]);
                    $data['userData']=$userData;
                    $data['card_number']=$value["card_number"];
                    $body=$this->load->view("orders/public/_email_saved_card_expire",$data,true);
                    $subject='Card Expiry Notification';
                    $this->email_extension->sendOrdersMail(
                                                    "card_notifications",
                                                    $userData->id,
                                                    $userData->firstname." ".$userData->lastname,
                                                    $userData->email,
                                                    $subject,
                                                    $body,
                                                    '',
                                                    1);
                }
                if(($currentDayOfMonth >= 1 && $currentDayOfMonth <= 15))
                {
                    $this->db->where("id",$value["id"]);
                    $this->db->update("credit_cards",array(
                                    "30_days_alert"=>1
                                ));
                }
                if(($currentDayOfMonth >= 15 && $currentDayOfMonth <= 21))
                {
                    $this->db->where("id",$value["id"]);
                    $this->db->update("credit_cards",array(
                                    "15_days_alert"=>1
                                ));
                }
                if(($currentDayOfMonth >= 21))
                {
                    $this->db->where("id",$value["id"]);
                    $this->db->update("credit_cards",array(
                                    "7_days_alert"=>1
                                ));
                }
            }
            $this->updatecardExpire();
        }
        else 
        {
            return false;
        }
    }

    public function updatecardExpire()
    {
        $months = array("01","02","03","04","05","06","07","08","09","10","11","12");
        $current_month = date("m");
        if($current_month == "12")
        {
            $check_month = "01";
            $check_year = date("Y")+1;
        }
        else
        {
            $check_month = $current_month-1;
            $check_year = date("Y");
        }
        $this->db->select('id,card_expiry_month,card_expiry_year,user_id');
        $this->db->from($this->tableName);
        $this->db->where("card_expiry_month",$check_month);
        $this->db->where('card_expiry_year',$check_year);
        $this->db->where('is_expired',"0");
        $result = $this->db->get()->result_array();

        if ($result) 
        {
            foreach ($result as $key => $value) 
            {
                $this->db->where("id",$value["id"]);
                $this->db->update("credit_cards",array(
                                    "is_expired"=>1
                                ));
            }
        }
    }
}
?>