<?PHP
class Cart_Model extends CI_Model 
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model("user/users_model");
		$this->load->model('ashrams/seva_item_blocked_dates');
	}

	public function validateCart($cartObject)
	{
		foreach($cartObject->contents() as $rowId=>$cartItem)
		{
			$defaultCurrency=strtolower($this->session->userdata("defaultCurrency"));
			$displayCol=$defaultCurrency."_display";
			if($cartItem['options']['type']=='pooja')
			{
				$valid=1;
				$poojaData=$this->poojas_model->poojaData($cartItem['id']);
				$checksum=md5(serialize($poojaData));
				if($checksum!=$cartItem['options']['checksum'])
				{
					$valid=0;
				}
				if($poojaData->$displayCol==0)
				{
					$valid=0;
				}
				if(!isset($cartItem['options']['max_family_members']))
				{
					$valid=0;
				}
				if(isset($cartItem['options']['max_family_members']) && $poojaData->max_family_members!=$cartItem['options']['max_family_members'])
				{
					$valid=0;
				}
				if($valid==1)
				{
					$final=array();
					$dates_set=$this->getPoojaValidDates($poojaData);
					$selected=array_filter(explode(",",$cartItem['options']['result_date']));
					foreach($selected as $sDate)
					{
						if(!in_array($sDate,$dates_set))
						{
							$valid=0;
							break;
						}
					}
				}
				$cartItem['options']['status']=$valid;
				$updateArray= array(
		               		'rowid' => $rowId,
           			    	'options'   => $cartItem['options']
			            );
				$cartObject->update($updateArray);
			}
			if($cartItem['options']['type']=='donation')
			{
				$valid=1;
				$donationData=$this->donations_model->donationData($cartItem['id']);
				$checksum=md5(serialize($donationData));
				if($checksum!=$cartItem['options']['checksum'])
				{
					$valid=0;
				}
				if($donationData->$displayCol==0)
				{
					$valid=0;
				}
				if(!isset($cartItem['options']['max_family_members']))
				{
					$valid=0;
				}
				if(isset($cartItem['options']['max_family_members']) && $donationData->max_family_members!=$cartItem['options']['max_family_members'])
				{
					$valid=0;
				}
				if(isset($cartItem['options']['appji_link_token']) && $cartItem['options']['appji_link_token']!="")
                {
                	$this->load->model('appji/appji_model');
        			$donationLinkDetails=$this->appji_model->donationLinkDetailsByLinkToken($cartItem['options']['appji_link_token']);
        			if( (isset($donationLinkDetails['linkExpiryDate']) && $donationLinkDetails['linkExpiryDate']<date('Y-m-d')) || (isset($donationLinkDetails['isLinkExpired']) && $donationLinkDetails['isLinkExpired']==1) )
			        {
			            $valid=0;
			        }
                }
				if($valid==1)
				{
					$final=array();
					$selected=array_filter(explode(",",$cartItem['options']['result_date'] ?? ""));
					//validating card items for single user per day
					/* if($donationData->allow_one_user_per_day_per_seva == 1){	
						$this->load->model('orders/orders_model');
						$selectConvert = [];
						foreach($selected as $select){
							$selectConvert[] = date('Y-m-d',strtotime($select ?? ''));
						}
						//checking seva date already payed
						$donationOrderDates = $this->orders_model->checkSelectedDatesInOrder($cartItem['id'],$selectConvert);
						if(!empty($donationOrderDates)){
							$valid=0;
						}

					
						//selected date should not less than current date
						foreach($selected as $selectedDate) {
							$tempTime = strtotime($selectedDate ?? '');
							$today_date = strtotime(date("d M Y"));
							if($tempTime < $today_date) {
								$valid=0;
								break;
							}
						}

						//checking select date blocked by other users 
						$blockedDates = $this->seva_item_blocked_dates->getBlockedDatesByUserAndItem($cartItem['id'],$selected,2);
						if(!empty($blockedDates)){
							foreach($blockedDates as $blockedDate) {
								if($rowId != $blockedDate->row_id){
									$valid=0;
									break;
								}
							}
						}



					}else { */
						$startDate=date("d M Y 00:00:00");
						$endDate=date("d M Y 23:59:00",strtotime("+5 Months"));

						$startTime=strtotime($startDate ?? "");
						$endTime=strtotime($endDate ?? "");

						
						foreach($selected as $selectedDate)
						{
							$tempTime=strtotime($selectedDate ?? "");
							if($startTime>$tempTime || $tempTime>$endTime)
							{
								$valid=0;
								break;
							}
						}
					//}
				}
				$cartItem['options']['status']=$valid;
				$updateArray= array(
		               		'rowid' => $rowId,
           			    	'options'   => $cartItem['options']
			            );
				$cartObject->update($updateArray);
			}
			if($cartItem['options']['type']=='subscription')
			{
				$valid=1;
				$subscriptionData=$this->subscriptions_model->subscriptionData($cartItem['id']);
				if(isset($cartItem['options']['appji_link_token']) && $cartItem['options']['appji_link_token']!="")
                {
                	$this->load->model('appji/appji_model');
        			$subscriptionLinkDetails=$this->appji_model->subscriptionLinkDetailsByLinkToken($cartItem['options']['appji_link_token']);
        			if( (isset($subscriptionLinkDetails['linkExpiryDate']) && $subscriptionLinkDetails['linkExpiryDate']<date('Y-m-d')) || (isset($subscriptionLinkDetails['isLinkExpired']) && $subscriptionLinkDetails['isLinkExpired']==1) )
			        {
			            $valid=0;
			        }
					if(!empty($subscriptionData))
					{
						$subscriptionData->period = $cartItem['options']['period'];
					}
                }
				$checksum=md5(serialize($subscriptionData));
				if($checksum!=$cartItem['options']['checksum'])
				{
					$valid=0;
				}
				if($subscriptionData->$displayCol==0)
				{
					$valid=0;
				}
				
				if($valid==1)
				{
					$final=array();
					$startDate=date("d M Y 00:00:00");
					// $endDate=date("d M Y 23:59:00",strtotime("+5 Months"));

					$startTime=strtotime($startDate);
					// $endTime=strtotime($endDate);

					$selected=array_filter(explode(",",$cartItem['options']['result_date']));
					foreach($selected as $selectedDate)
					{
						$tempTime=strtotime($selectedDate);
						// if($startTime>$tempTime || $tempTime>$endTime)
						if($startTime>$tempTime)
						{
							$valid=0;
							break;
						}
					}
				}
				$cartItem['options']['status']=$valid;
				$updateArray= array(
		               		'rowid' => $rowId,
           			    	'options'   => $cartItem['options']
			            );
				$cartObject->update($updateArray);
			}
			if($cartItem['options']['type']=='store')
			{
				$valid=1;
				$storeData=$this->store_model->itemData($cartItem['id']);
				$checksum=md5(serialize($storeData));
				if($checksum!=$cartItem['options']['checksum'])
				{
					$valid=0;
				}
				$cartItem['options']['status']=$valid;
				$updateArray= array(
		               		'rowid' => $rowId,
           			    	'options'   => $cartItem['options']
			            );
				$cartObject->update($updateArray);
			}
		}
	}

	public function addItem($itemInfo,$qty,$cartObject,$row_key='')
	{
		// Unset user signature
		$this->session->unset_userdata('user_initials');
		
		$exist=0;
		$ok=0;
       	$finalqty=0;
		
		if($exist==0)
		{
			// Check Cart type is pooja
			if($itemInfo['type']=='pooja')
			{
				//Calculate cut off time
				$cutoffType=$itemInfo['item']->cutoff_type;
				$cutoffHour=$itemInfo['item']->cutoff_hour;
				$cutoffMinutes=$itemInfo['item']->cutoff_minutes;
				if($cutoffHour>0)
				{
					$tempMinutes = $cutoffHour*60;
					$cutoffMinutes = $cutoffMinutes+$tempMinutes;
				}

				if($cutoffType=='CloseAfterStartTime')
				{
					$closeBeforeTime=date("H:i:s",strtotime($itemInfo['item']->time_from." +".$cutoffMinutes." Minutes"));
				} else if($cutoffType=='CloseAfterEndTime')
				{
					$closeBeforeTime=date("H:i:s",strtotime($itemInfo['item']->time_to." +".$cutoffMinutes." Minutes"));
				} else if($cutoffType=='CloseBeforeStartTime')
				{
					$closeBeforeTime=date("H:i:s",strtotime($itemInfo['item']->time_from." -".$cutoffMinutes." Minutes"));
				} else if($cutoffType=='CloseBeforeEndTime')
				{
					$closeBeforeTime=date("H:i:s",strtotime($itemInfo['item']->time_to." -".$cutoffMinutes." Minutes"));
				} else {
					$closeBeforeTime=date("H:i:s",strtotime($itemInfo['item']->time_from." +".$cutoffMinutes." Minutes"));
				}
				// Get pooja valid dates
				$validDates=$this->getPoojaValidDates($itemInfo['item']);
				// If Dates are not valid Send error flag
				if(empty($validDates))
				{
					return array("flag"=>10);
				}
				// Add item image to cart item
				$image=aws_s3_base_url."images/sample_datta_logo.jpg";
				if($itemInfo['item']->image!='')
					$image=aws_s3_base_url."images/pooja_images/thumb_".$itemInfo['item']->image;

				// Set First Date as Valid as default
				$firstDate=$validDates[0];
				$selectedDatesArr = [];
				if(isset($itemInfo['pooja_on_date']) && ($itemInfo['pooja_on_date']!=''))
				{
					$selectedDatesArr = explode(',', $itemInfo['pooja_on_date']);
					if(count($selectedDatesArr)>1)
					{

					} else {
						$firstDate = $itemInfo['pooja_on_date'];
					}
				}
				
				$tempDate=date("d M Y",strtotime($firstDate));
				// Check First date is in between pooja start and end dates and close before time
				if(strtotime($firstDate)>=strtotime($itemInfo['item']->start_date) && strtotime($firstDate)<=strtotime($itemInfo['item']->end_date))
				{
					if(date("d M Y")==$tempDate)
					{
						$temp11=date("d M Y",strtotime($firstDate))." ".$closeBeforeTime;
						if(strtotime($temp11)<time())
						{
							return array("flag"=>10);
						}
					}
				}
				else
				{
					return array("flag"=>10);
				}

				if(isset($itemInfo['item']->max_family_members) && $itemInfo['item']->max_family_members != 'All family members')
	            {
	                $pooja_on_family_type = 3;
	            }
	            else
	            {
	                $pooja_on_family_type = 2;
	            }
				// Set Item data for cart with id, qty, price, name, options(all cart data and serialized cart item)
				$data = array(
					   'id'      => $itemInfo['item']->id,
					   'qty'     => 1,
					   'price'   => '10',
					   'name'    => $itemInfo['item']->pooja_name,			   
					   'options' => array(
					   				'checksum'=>md5(serialize($itemInfo['item'])),
									'type' => $itemInfo['type'],
									'note'=>$itemInfo['note'],
									'category'=> $itemInfo['item']->category,
									'ashram_id' => $itemInfo['item']->ashram_id,
									'description' => $itemInfo['item']->description,
									'partial_payments_allowed' => $itemInfo['item']->partial_payments_allowed,
									'is_public_display'=>$itemInfo['item']->is_public_display,
									//'shipping'=>$itemInfo['item']->shipping,
									'start_date' => $itemInfo['item']->start_date,
									'end_date' => $itemInfo['item']->end_date,
									'time_from' => $itemInfo['item']->time_from,
									'time_to' => $itemInfo['item']->time_to,
									// 'close_before' => $itemInfo['item']->close_before,
									'cutoff_type' => $itemInfo['item']->cutoff_type,
									'cutoff_hour' => $itemInfo['item']->cutoff_hour,
									'cutoff_minutes' => $itemInfo['item']->cutoff_minutes,
									'first_date'=>$firstDate,
									'user_date'=>$firstDate,
									'image_path'=>$image,
									'status'=>1,
									'have_personal_note'=>$itemInfo['item']->have_personal_note,
									'pitru_paksha_pooja'=>$itemInfo['item']->pitru_paksha_pooja,
									'is_poornaphala_seva'=>$itemInfo['item']->is_poornaphala_seva,
									'poornaphala_tie_by'=>$itemInfo['poornaphala_tie_by'],
									'attend_pooja_in_person'=>$itemInfo['attend_pooja_in_person'],
									'is_attend_in_person'=>$itemInfo['is_attend_in_person'],
									'in_person_note'=>$itemInfo['in_person_note'],
									'max_family_members'=>$itemInfo['item']->max_family_members,
									'personal_note'=>$itemInfo['personal_note'],
									'pitru_paksha_deceased_person_name'=>$itemInfo['pitru_paksha_deceased_person_name'],
									'pooja_on_family_type'=>$pooja_on_family_type,
									'result_date'=>date("d M Y",strtotime($firstDate))
									)
					 );

				foreach($GLOBALS['currencies'] as $currencyData)
				{
					$col="price_".strtolower($currencyData['currency']);
					/*$col2="shipping_domestic_".strtolower($currencyData['currency']);
					$col3="shipping_international_".strtolower($currencyData['currency']);*/
					$data['options'][$col]=$itemInfo['item']->$col;
					/*$data['options'][$col2]=$itemInfo['item']->$col2;
					$data['options'][$col3]=$itemInfo['item']->$col3;*/
				}
			}
			else if($itemInfo['type']=='donation')
			{
				$closeBefore=0;
				$closeBeforeTime="23:59:00";
				$firstDate=date("d M Y");
				$tomorrow=date("d M Y 00:00:00",strtotime("+1 day"));
				// Get donation valid dates
				$validDates=$this->getDonationValidDates($itemInfo['item']);
				if(empty($validDates))
				{
					return array("flag"=>10);
				}
				// Set tomorrow date as default date of donating date
				$firstDate=$validDates[0];
				// if($itemInfo['allow_one_user_per_day_per_seva'] == 1){
				// 	$firstDate = $this->donationscart->nextAvailDate($itemInfo['item']->id);
				// }
				//Add item image to cart item
				$image=aws_s3_base_url."images/sample_datta_logo.jpg";
				if($itemInfo['item']->image!='')
					$image=aws_s3_base_url."images/donation_images/thumb_".$itemInfo['item']->image;
				
				if($this->session->userdata("donationCartAshramIdSelection")==appji_ashram_id)
            	{
            		$donation_on_family_type = 13;
            	}
				else if(isset($itemInfo['item']->max_family_members) && $itemInfo['item']->max_family_members != 'All family members')
	            {
	                $donation_on_family_type = 7;
	            }
	            else
	            {
	                $donation_on_family_type = 6;
	            }
				// Set Item data for cart with id, qty, price, name, options(all cart data and serialized cart item)
				$data = array(
					   'id'      => $itemInfo['item']->id,
					   'qty'     => 1,
					   'price'   => '10',
					   'name'    => $itemInfo['item']->donation_name,			   
					   'options' => array(
					   				'checksum'=>md5(serialize($itemInfo['item'])),
									'type' => $itemInfo['type'],
									'note'=>$itemInfo['note'],
									'category'=> $itemInfo['item']->category,
									'ashram_id' => $itemInfo['item']->ashram_id,
									'is_price_fixed'=>$itemInfo['item']->is_price_fixed,
									'description' => $itemInfo['item']->description,
									'partial_payments_allowed' => $itemInfo['item']->partial_payments_allowed,
									'is_public_display'=>$itemInfo['item']->is_public_display,
									'assign_pet' => $itemInfo['item']->assign_pet,
									'subscription' => $itemInfo['item']->subscription,
									'expiration_method' => $itemInfo['item']->expiration_method,
									'num_of_payments' => 0,//$itemInfo['item']->num_of_payments,
									'expiry_date' => $itemInfo['item']->expiry_date,
									'period' => $itemInfo['item']->period,
									'frequency' => $itemInfo['item']->frequency,
									'first_date'=>$firstDate,
									'user_date'=>$firstDate,
									'donor_id'=>0,
									'image_path'=>$image,
									'have_personal_note'=>$itemInfo['item']->have_personal_note,
									'allow_one_user_per_day_per_seva'=>(isset($itemInfo['allow_one_user_per_day_per_seva'])) ? $itemInfo['allow_one_user_per_day_per_seva'] : '',
									'personal_note'=>$itemInfo['personal_note'],
									'max_family_members'=>$itemInfo['item']->max_family_members,
									'donation_on_family_type'=>$donation_on_family_type,
									'status'=>1,
									'result_date'=>date("d M Y",strtotime($firstDate))
								)
					);
				foreach($GLOBALS['currencies'] as $currencyData)
				{
					$col="price_".strtolower($currencyData['currency']);
					$col2="price_suggested_".strtolower($currencyData['currency']);
					$col3="onetime_charge_".strtolower($currencyData['currency']);
					$col4="min_price_".strtolower($currencyData['currency']);
					$data['options'][$col]=$itemInfo['item']->$col;
					$data['options'][$col2]=$itemInfo['item']->$col;
					$data['options'][$col3]=$itemInfo['item']->$col3;
					$data['options'][$col4]=$itemInfo['item']->$col4;
				}

				//If Donation is appji donation add below columns data into options column
				if(isset($itemInfo['is_appji_donation']) && $itemInfo['is_appji_donation']==1)
				{
					$priceCol='price_'.strtolower($itemInfo['appji_currency']);
					$data['options'][$priceCol]=$itemInfo['appji_donation_amount'];
					$data['options']['appji_link_token']=$itemInfo['appji_link_token'];
					$data['options']['appji_email']=$itemInfo['appji_email'];
					$data['options']['appji_member_name']=$itemInfo['appji_user_full_name'];
					$data['options']['appji_member_email']=$itemInfo['appji_email'];
					$data['options']['appji_currency']=$itemInfo['appji_currency'];
					$data['options']['is_appji_donation']=$itemInfo['is_appji_donation'];
				}
				else
				{
					$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));
					$data['options'][$priceCol]=$itemInfo['amount'];
				}
			}
			else if($itemInfo['type']=='subscription')
			{
				// Set today as first date for subscription (if payment mode for ashram subscription is stripe and not appji subscription fast date should be +3 days of today)
				$closeBefore=0;
				$closeBeforeTime="23:59:00";
				$firstDate=date("d M Y");
				$tomorrow=date("d M Y 00:00:00",strtotime("+1 day"));
				if(isset($itemInfo['item']->subscription) && $itemInfo['item']->subscription==1)
				{
					if(strtotime($tomorrow)>strtotime($firstDate))
					{
						$firstDate=$tomorrow;
					}
					if(isset($itemInfo['is_appji_subscription']) && $itemInfo['is_appji_subscription']==1)
					{
						$firstDate=date("d M Y");
					}
				}
				$display_first_date = 0;
				if($itemInfo['item']->ashram_id)
				{
					$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($itemInfo['item']->ashram_id,4);
			    	$trustsArray=array();
			    	foreach ($trusts as $trustData)
			    	{
			    		$trustsArray[$trustData->currency]=$trustData;
			    	}
			    	$trustData=$trustsArray[strtolower($this->session->userdata("defaultCurrency"))];
			    	if($trustData->payment_mode == "stripe")
			    	{
			    		$display_first_date = 1;
						if(isset($itemInfo['is_appji_subscription']) && $itemInfo['is_appji_subscription']==1)
						{
			    			$firstDate=date("d M Y");
						}
						else
						{
							$firstDate=date("d M Y 00:00:00",strtotime("+3 day"));
						}
			    	}
				}
				
				// Set expiry date for subscription
				$subscription_expiry_date='';
				if($itemInfo['item']->subscription==1)
				{
					if($itemInfo['item']->expiration_method==1)
					{
						$future="+".($itemInfo['item']->frequency*$itemInfo['item']->num_of_payments)." ".$itemInfo['item']->period;
						$subscription_expiry_date=date("d M Y",strtotime($future,strtotime($firstDate))+(60*60*24));
					}
					if($itemInfo['item']->expiration_method==2)
					{
						$subscription_expiry_date=date("d M Y",strtotime($itemInfo['item']->expiry_date));
					}
				}
				$image=aws_s3_base_url."images/sample_datta_logo.jpg";
				if($itemInfo['item']->image!='')
					$image=aws_s3_base_url."images/subscription_images/thumb_".$itemInfo['item']->image;

				// Set period for appji subscription(days,months,years)
				if(!empty($itemInfo['is_appji_subscription']) && $itemInfo['is_appji_subscription']==1 && !empty($itemInfo['period']))
				{
					$itemInfo['item']->period = $itemInfo['period'];
				}

				if($this->session->userdata("subscriptionCartAshramIdSelection")==appji_ashram_id)
            	{
            		$subscription_on_family_type = 14;
            	}
				else 
				{
					$subscription_on_family_type = 10;
				}
				// Set Item data for cart with id, qty, price, name, options(all cart data and serialized cart item)
				$data = array(
					   'id'      => $itemInfo['item']->id,
					   'qty'     => 1,
					   'price'   => '10',
					   'name'    => $itemInfo['item']->subscription_name,			   
					   'options' => array(
					   				'checksum'=>md5(serialize($itemInfo['item'])),
									'type' => $itemInfo['type'],
									'note'=>$itemInfo['note'],
									'category'=> $itemInfo['item']->category,
									'ashram_id' => $itemInfo['item']->ashram_id,
									'is_price_fixed'=>$itemInfo['item']->is_price_fixed,
									'description' => $itemInfo['item']->description,
									'partial_payments_allowed' => $itemInfo['item']->partial_payments_allowed,
									'is_public_display'=>$itemInfo['item']->is_public_display,
									'assign_pet' => $itemInfo['item']->assign_pet,
									'subscription' => $itemInfo['item']->subscription,
									'expiration_method' => $itemInfo['item']->expiration_method,
									'num_of_payments' => 0,//$itemInfo['item']->num_of_payments,
									'expiry_date' => $itemInfo['item']->expiry_date,
									'period' => $itemInfo['item']->period,
									'subscription_payment_type' => $itemInfo['item']->subscription_payment_type,
									'frequency' => $itemInfo['item']->frequency,
									'first_date'=>$firstDate,
									'user_date'=>$firstDate,
									'donor_id'=>0,
									'image_path'=>$image,
									'subscription_expiry_date'=>$subscription_expiry_date,
									'have_personal_note'=>$itemInfo['item']->have_personal_note,
									'personal_note'=>$itemInfo['personal_note'],
									'subscription_on_family_type'=>$subscription_on_family_type,
									'status'=>1,
									'result_date'=>date("d M Y",strtotime($firstDate))
								)
					 );

				// Set donor id to option
				if($itemInfo['item']->subscription==1)
				{
					$tempUserId=0;
					if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
						$tempUserId=$this->session->userdata('temp_checkout_user')->sso_user_id;
					else
						$tempUserId=$this->currentUser->sso_user_id;

					$firstDonor=$this->donors_model->firstDonor($tempUserId);
					if(!empty($firstDonor))
					{
						$data['options']['donor_id']=$firstDonor->id;
					}
				}
			
				foreach($GLOBALS['currencies'] as $currencyData)
				{
					$col="price_".strtolower($currencyData['currency']);
					$col2="price_suggested_".strtolower($currencyData['currency']);
					$col3="onetime_charge_".strtolower($currencyData['currency']);
					$col4="min_price_".strtolower($currencyData['currency']);
					$data['options'][$col]=$itemInfo['item']->$col;
					$data['options'][$col2]=$itemInfo['item']->$col;
					$data['options'][$col3]=$itemInfo['item']->$col3;
					$data['options'][$col4]=$itemInfo['item']->$col4;
				}

				if(isset($itemInfo['is_appji_subscription']) && $itemInfo['is_appji_subscription']==1)
				{
					$priceCol='price_'.strtolower($itemInfo['appji_currency']);
					$data['options'][$priceCol]=$itemInfo['appji_subscription_amount'];
					$data['options']['appji_link_token']=$itemInfo['appji_link_token'];
					$data['options']['appji_email']=$itemInfo['appji_email'];
					$data['options']['appji_member_name']=$itemInfo['appji_user_full_name'];
					$data['options']['appji_member_email']=$itemInfo['appji_email'];
					$data['options']['appji_currency']=$itemInfo['appji_currency'];
					$data['options']['is_appji_subscription']=$itemInfo['is_appji_subscription'];
				}
				else
				{
					$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));
					$data['options'][$priceCol]=$itemInfo['amount'];
				}
				if(!empty($display_first_date) && $display_first_date > 0 && $data['options']["onetime_charge_".strtolower($this->session->userdata("defaultCurrency"))] == 0)
				{
					$data['options']['result_date']=date("d M Y");
				}
			}
			else if($itemInfo['type']=='store')
			{
				$tempUserId=0;
				if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
				{
					$tempUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
					$localUserId = $this->session->userdata('temp_checkout_user')->id;
				}
				else
				{
					$tempUserId=$this->currentUser->sso_user_id;
					$localUserId = $this->currentUser->id;;
				}

				// Get cart user details for address details
				$this->db->select('firstname,middlename,lastname,email,address,address1,address2,city,state,country_id,country');
				$this->db->where("id",$localUserId);
				$q1=$this->db->get("users");
				$addItemmUser = $q1->row();
				$addItemmUserName = '';
				$addItemmUserEmail = '';
				$addItemmUserAddress1 = '';
				$addItemmUserAddress2 = '';
				$addItemmUserAddress3 = '';
				$addItemmUserCity = '';
				$addItemmUserState = '';
				$addItemmUserCountry = '';
				$addItemmUserCountryName = '';
				$addItemmUserCountry_id = '';
				if(isset($addItemmUser->email)){
					$addItemmUserEmail = $addItemmUser->email;
				}
				if(isset($addItemmUser->firstname)){
					$addItemmUserName .= $addItemmUser->firstname;
				}
				if(isset($addItemmUser->middlename)){
					$addItemmUserName .= ' '.$addItemmUser->middlename;
				}
				if(isset($addItemmUser->lastname)){
					$addItemmUserName .= ' '.$addItemmUser->lastname;
				}
				if(isset($addItemmUser->address)){
					$addItemmUserAddress1 .= $addItemmUser->address;
				}
				if(isset($addItemmUser->address1)){
					$addItemmUserAddress2 .= $addItemmUser->address1;
				}
				if(isset($addItemmUser->address2)){
					$addItemmUserAddress3 .= $addItemmUser->address2;
				}
				if(isset($addItemmUser->city)){
					$addItemmUserCity .= $addItemmUser->city;
				}
				if(isset($addItemmUser->state)){
					$addItemmUserState .= $addItemmUser->state;
				}
				if(isset($addItemmUser->country_id)){
					$addItemmUserCountry_id .= $addItemmUser->country_id;
				}
				if(isset($addItemmUser->country)){
					$addItemmUserCountry .= $addItemmUser->country;
				}
				if(isset($addItemmUser->country_id) && $addItemmUser->country_id!=''){
					$allcountries=$this->locations_model->getCountries(true);
					$addItemmUserCountryName .= $allcountries[$addItemmUser->country_id]->country_name;
				}

				$image=aws_s3_base_url."images/sample_datta_logo.jpg";
				if(!empty($itemInfo['item']['photos']))
					$image=aws_s3_base_url."images/store_images/".$itemInfo['item']['item']->id."/thumb_".$itemInfo['item']['photos'][0]->filename;

				// Set Item data for cart with id, qty, price, name, options(all cart data and serialized cart item)
				$data = array(
					   	'id'      => $itemInfo['item']['item']->id,
					   	'qty'     => 1,
					   	'price'   => 1,
					   	'name'    => $itemInfo['item']['item']->item_name,
					    'options' => array(
					    			'checksum'=>md5(serialize($itemInfo['item'])),
					    			'item_data'=>serialize($itemInfo['item']),
					    			'type' => $itemInfo['type'],
									'note'=>'',
									'gift_friend_email'=> $addItemmUserEmail,
									'gift_friend_name'=> $addItemmUserName,
									'status'=>1,
									'category'=> $itemInfo['item']['item']->category,
									'ashram_id' => $itemInfo['item']['item']->ashram_id,
									'description' => $itemInfo['item']['item']->description,
									'partial_payments_allowed' => $itemInfo['item']['item']->partial_payments_allowed,
									'is_public_display'=>$itemInfo['item']['item']->is_public_display,
									'shipping'=>$itemInfo['item']['item']->shipping,
									'image_path'=>$image,
									'have_personal_note'=>$itemInfo['item']['item']->have_personal_note,
									'personal_note'=>$itemInfo['personal_note'],
									'shipping_address'=>array(
																'address1' => $addItemmUserAddress1,
																'address2' => $addItemmUserAddress2,
																'address3' => $addItemmUserAddress3,
																'city' => $addItemmUserCity,
																'state' => $addItemmUserState,
																'country' => $addItemmUserCountry_id,
																'country_name' => $addItemmUserCountryName
																)
									)
					 );	
				
				foreach($GLOBALS['currencies'] as $currencyData)
				{
					$col="price_".strtolower($currencyData['currency']);
					$col2="shipping_domestic_".strtolower($currencyData['currency']);
					$col3="shipping_international_".strtolower($currencyData['currency']);
					$data['options'][$col]=$itemInfo['item']['item']->$col;
					$data['options'][$col2]=$itemInfo['item']['item']->$col2;
					$data['options'][$col3]=$itemInfo['item']['item']->$col3;
				}
			}

			$custom_email_text = "";
			$custom_sms_text = "";
			if($itemInfo['type']=='store')
			{
				if(isset($itemInfo['item']['item']->having_custom_email) && $itemInfo['item']['item']->having_custom_email==1 && isset($itemInfo['item']['item']->custom_email_text) && trim($itemInfo['item']['item']->custom_email_text)!="")
				{
					$custom_email_text = $itemInfo['item']['item']->custom_email_text;
				}
				
				if(isset($itemInfo['item']['item']->having_custom_sms) && $itemInfo['item']['item']->having_custom_sms==1 && isset($itemInfo['item']['item']->custom_sms_text) && trim($itemInfo['item']['item']->custom_sms_text)!="")
				{
					$custom_sms_text = $itemInfo['item']['item']->custom_sms_text;
				}
			}
			else
			{
				if(isset($itemInfo['item']->having_custom_email) && $itemInfo['item']->having_custom_email==1 && isset($itemInfo['item']->custom_email_text) && trim($itemInfo['item']->custom_email_text)!="")
				{
					$custom_email_text = $itemInfo['item']->custom_email_text;
				}
				
				if(isset($itemInfo['item']->having_custom_sms) && $itemInfo['item']->having_custom_sms==1 && isset($itemInfo['item']->custom_sms_text) && trim($itemInfo['item']->custom_sms_text)!="")
				{
					$custom_sms_text = $itemInfo['item']->custom_sms_text;
				}
			}
			$data['options']['custom_email_text'] = $custom_email_text;
			$data['options']['custom_sms_text'] = $custom_sms_text;
			$rowId=$cartObject->insert($data,$row_key);

			if($itemInfo['type']=='pooja' && (isset($selectedDatesArr) && (count($selectedDatesArr)>1)) )
			{
				$poojaData=$this->poojas_model->poojaData($itemInfo['item']->id);
				if(!empty($poojaData) && $poojaData->status==1)
				{
					$dates_set=$this->cart_model->getPoojaValidDates($poojaData);
					$final=array();
					if(!empty($selectedDatesArr))
					foreach($selectedDatesArr as $pdate)
					{
						if(in_array(date('d M Y', strtotime($pdate)),$dates_set))
						$final[]=$pdate;
					}
					
					foreach($final as $key=>$tms)
					{
						$final[$key]=strtotime($tms);
					}
					
					asort($final);
					
					$store_array=array();
					
					$cnt=0;
					$first='';
					
					
					foreach($final as $key=>$tms)
					{
						if($cnt==0)
						$first=date("d M Y",$tms);
						
						$final[$key]=date("d M Y (l)",$tms);
						$store_array[]=date("d M Y",$tms);
						$cnt++;
					}
					
					$opt=$this->poojascart->product_options($rowId);

					$opt['result_date']=implode(",",$store_array);
					$opt['schedule_options']=$_POST;
					$opt['user_date']=$first;

					$upd= array(
							 'rowid' => $rowId,
							 'options'   => $opt,
							 'qty'=>$cnt);

					$this->poojascart->update($upd);
					$this->cart_model->validateCart($this->poojascart);
				}
			}
		}
        if(!$exist)
            return array("flag"=>-2,"rowid"=>$rowId); // item added newly
        else
            return array("flag"=>$finalqty,"rowid"=>$rowId); // return prev qty in cart
	}

	public function getTotalPrice($cartObject, $appjiLinkToken='', $appjiLinkTokenFor='')
	{
		$totalPrice=0;
		if($appjiLinkToken!='' && $appjiLinkTokenFor=='donation')
		{
			$this->load->model('appji/appji_model');
        	$donationLinkDetails=$this->appji_model->donationLinkDetailsByLinkToken($appjiLinkToken);
			$defaultCurrency = $donationLinkDetails['donationCurrency'];
		}
		else if($appjiLinkToken!='' && $appjiLinkTokenFor=='subscription')
		{
			$this->load->model('appji/appji_model');
        	$subscriptionLinkDetails=$this->appji_model->subscriptionLinkDetailsByLinkToken($appjiLinkToken);
			$defaultCurrency = $subscriptionLinkDetails['subscriptionCurrency'];
		}
		else
		{
			$defaultCurrency = $this->session->userdata("defaultCurrency");
		}
		if(empty($defaultCurrency))
			$defaultCurrency = isset($_SESSION["defaultCurrency"]) ? $_SESSION["defaultCurrency"] : default_currency;
		foreach($cartObject->contents() as $rowKey=>$cartItem)
		{
			$priceCol="price_".strtolower($defaultCurrency);
			if($cartItem['options']['status']==1)
			{
				$totalPrice+=($cartItem['qty']*$cartItem['options'][$priceCol]);
				if(isset($cartItem['options']['shipping']))
				{
					if($cartItem['options']['shipping']==1)
					{
						$shipDomestic="shipping_domestic_".strtolower($defaultCurrency);
						$shipInternational="shipping_international_".strtolower($defaultCurrency);
						if($cartItem['options']['type']=='store')
						{
							if(!empty($cartItem['options']['shipping_address']))
							{
								if($cartItem['options']['shipping_address']['country']=='IN')
								{
									$itemShipping=$cartItem['options'][$shipDomestic]*$cartItem['qty'];
								}
								else
								{
									$itemShipping=$cartItem['options'][$shipInternational]*$cartItem['qty'];
								}
							}
							else
		                	{
		                		if($info['country']=='IN')
								{
									$itemShipping=$cartItem['options'][$shipDomestic]*$cartItem['qty'];
								}
								else
								{
									$itemShipping=$cartItem['options'][$shipInternational]*$cartItem['qty'];
								}
		                	}
						}
						else
						{
							if($defaultCurrency=='inr')
							{
								$itemShipping=$cartItem['options'][$shipDomestic]*$cartItem['qty'];
							}
							else
							{
								$itemShipping=$cartItem['options'][$shipInternational]*$cartItem['qty'];
							}
						}
						$totalPrice+=$itemShipping;
					}
            	}
            	if(isset($cartItem['options']['subscription']) && $cartItem['options']['subscription']==1)
            	{
            		$oneTimePriceCol="onetime_charge_".strtolower($defaultCurrency);
            		$totalPrice+=$cartItem['options'][$oneTimePriceCol];
            	}
			}
		}
		return $totalPrice;
	}
	public function updateReferenceId($referenceId,$type)
	{
		$tempuser = $this->session->userdata('temp_checkout_user');
		if($this->session->userdata("loggedIn") && $this->session->userdata("user_id"))
		{
			$this->db->where("user_id",$this->session->userdata("user_id"));
		}
		else if(isset($tempuser->id) && $tempuser->id>0)
		{
			$this->db->where("user_id",$tempuser->id);
		}
		else
		{
			$this->db->where("user_id",0);
			$this->db->where("session_id",session_id());
		}
		// $this->db->where("session_id",session_id());
		$this->db->where("cart_type",$type);
		$this->db->update("cart_data",array("reference_id"=>$referenceId,'started_on'=>date("Y:m:d H:i:s")));
	}

	public function getPoojaValidDates($poojaData)
	{
		$include_exclude_dates = @$poojaData->include_exclude_dates;
		$weekdays=explode(",",$poojaData->days);
		$exclude_dates=explode(",",$poojaData->exclude_dates);
		$include_dates=explode(",",$poojaData->include_dates);
		$startDateTime=strtotime($poojaData->start_date);
		$endDateTime=strtotime($poojaData->end_date);
		
		$result=array();
		
		if($startDateTime>=time())
			$temp=$startDateTime;
		else
			$temp=strtotime("00:00:00");
		
		while($temp<=$endDateTime)
		{
			// $dateTime=strtotime(date("d M Y",$temp)." ".$poojaData->time_to." -".$poojaData->close_before." Minutes");
			$cutoffType=$poojaData->cutoff_type;
			$cutoffHour=$poojaData->cutoff_hour;
			$cutoffMinutes=$poojaData->cutoff_minutes;
			if($cutoffHour>0)
			{
				$tempMinutes = $cutoffHour*60;
				$cutoffMinutes = $cutoffMinutes+$tempMinutes;
			}

			if($cutoffType=='CloseAfterStartTime')
			{
				$dateTime=strtotime(date("d M Y",$temp)." ".$poojaData->time_from." +".$cutoffMinutes." Minutes");
			} else if($cutoffType=='CloseAfterEndTime')
			{
				$dateTime=strtotime(date("d M Y",$temp)." ".$poojaData->time_to." +".$cutoffMinutes." Minutes");
			} else if($cutoffType=='CloseBeforeStartTime')
			{
				$dateTime=strtotime(date("d M Y",$temp)." ".$poojaData->time_from." -".$cutoffMinutes." Minutes");
			} else if($cutoffType=='CloseBeforeEndTime')
			{
				$dateTime=strtotime(date("d M Y",$temp)." ".$poojaData->time_to." -".$cutoffMinutes." Minutes");
			} else {
				$dateTime=strtotime(date("d M Y",$temp)." ".$poojaData->time_to." -".$cutoffMinutes." Minutes");
			}

			

			if($poojaData->days!='')
			{
				if($include_exclude_dates == 'IncludeDates')
				{
					if(in_array(date("l",$temp),$weekdays) && in_array(date("d M Y",$temp),$include_dates) && time()<$dateTime)
					{
						$result[]=date("d M Y",$temp);
					}
				} else if (in_array(date("l",$temp),$weekdays) && !in_array(date("d M Y",$temp),$exclude_dates) && time()<$dateTime)
				{
					$result[]=date("d M Y",$temp);
				}
			}
			else
			{
				if($include_exclude_dates == 'IncludeDates')
				{
					if(in_array(date("d M Y",$temp),$include_dates) && time()<$dateTime)
					{
						$result[]=date("d M Y",$temp);
					}
				} else if(!in_array(date("d M Y",$temp),$exclude_dates) && time()<$dateTime)
				{
					$result[]=date("d M Y",$temp);
				}
			}
			
			$temp=strtotime("+1 Day",$temp);
		}
		
		return $result;
	}

	public function regenerateSession($cartType)
	{
		$userId=0;
		$sessionCartType = "";
		if($this->session->userdata("loggedIn") && $this->session->userdata("user_id"))
		{
			$userId=$this->session->userdata("user_id");
		}
		else if($this->session->userdata("loggedIn") && $this->currentUser->admin==1 && (isset($this->session->userdata('temp_checkout_user')->id)))
		{
			$userId=$this->session->userdata('temp_checkout_user')->id;
		}
		
		//$oldCart=$this->poojascart->getFromDb();
		$this->session->sess_regenerate(false);
		if(!empty($this->session->userdata("pooja_cart_contents")))
		//if(!empty($this->poojascart->contents()))
		{
			$sessionCartType = "poojasCartAshramId";
			$current_ashram_id = 0;
			if($this->session->userdata('poojasCartAshramId')>0)
			{
				$current_ashram_id = $this->session->userdata('poojasCartAshramId');
			}
			$this->deleteDeclinedCartRow($current_ashram_id,$userId,1);
			$this->db->insert("cart_data",
								array
								(
									"session_id"=>session_id(),
									"cart_data"=>serialize($this->session->userdata("pooja_cart_contents")),
									'updated_on'=>date("Y:m:d H:i:s"),
									'cart_type'=>1,
									'user_id'=>$userId,
									'ashram_id'=>$current_ashram_id
								)
							);
		}
		//if(!empty($this->donationscart->contents()))
		if(!empty($this->session->userdata("donation_cart_contents")))
		{
			$sessionCartType = "donationCartAshramId";
			$current_ashram_id = 0;
			if($this->session->userdata('donationCartAshramId')>0)
			{
				$current_ashram_id = $this->session->userdata('donationCartAshramId');
			}
			$this->deleteDeclinedCartRow($current_ashram_id,$userId,2);
			$this->db->insert("cart_data",
								array
								(
									"session_id"=>session_id(),
									"cart_data"=>serialize($this->session->userdata("donation_cart_contents")),
									'updated_on'=>date("Y:m:d H:i:s"),
									'cart_type'=>2,
									'user_id'=>$userId,
									'ashram_id'=>$current_ashram_id
								)
							);
		}

		//if(!empty($this->donationscart->contents()))
		if(!empty($this->session->userdata("store_cart_contents")))
		{
			$sessionCartType = "storeCartAshramId";
			$current_ashram_id = 0;
			if($this->session->userdata('storeCartAshramId')>0)
			{
				$current_ashram_id = $this->session->userdata('storeCartAshramId');
			}
			$this->deleteDeclinedCartRow($current_ashram_id,$userId,3);
			$this->db->insert("cart_data",
								array
								(
									"session_id"=>session_id(),
									"cart_data"=>serialize($this->session->userdata("store_cart_contents")),
									'updated_on'=>date("Y:m:d H:i:s"),
									'cart_type'=>3,
									'user_id'=>$userId,
									'ashram_id'=>$current_ashram_id
								)
							);
		}

		//if(!empty($this->donationscart->contents()))
		if(!empty($this->session->userdata("subscription_cart_contents")))
		{
			$sessionCartType = "subscriptionCartAshramId";
			$current_ashram_id = 0;
			if($this->session->userdata('subscriptionCartAshramId')>0)
			{
				$current_ashram_id = $this->session->userdata('subscriptionCartAshramId');
			}
			$this->deleteDeclinedCartRow($current_ashram_id,$userId,4);
			$this->db->insert("cart_data",
								array
								(
									"session_id"=>session_id(),
									"cart_data"=>serialize($this->session->userdata("subscription_cart_contents")),
									'updated_on'=>date("Y:m:d H:i:s"),
									'cart_type'=>4,
									'user_id'=>$userId,
									'ashram_id'=>$current_ashram_id,
									'subscription' => 1
								)
							);
		}

		if($this->session->userdata("loggedIn"))
		{
			if($this->session->userdata("id"))
				$userId=$this->session->userdata("id");
			else
				$userId=$this->session->userdata("user_id");
			$this->users_model->updateLastSessionId($userId,session_id());

			if($sessionCartType!='' && $current_ashram_id>0)
			{
				$this->session->set_userdata($sessionCartType,$current_ashram_id);
			}
		}
	}

	public function emptyAllCarts()
	{
		//Empty the cart
		$cart=$this->poojascart->contents();
		if(!empty($cart))
		{
			foreach ($cart as $key => $item)
			{
				$upd= array(
			               'rowid' => $key,
               				'qty'   => 0
				            );
				$this->poojascart->update($upd);
			}
		}
		//Empty the cart
		$cart=$this->donationscart->contents();
		if(!empty($cart))
		{
			foreach ($cart as $key => $item)
			{
				$upd= array(
			               'rowid' => $key,
               				'qty'   => 0
				            );
				$this->donationscart->update($upd);
			}
		}

		$cart=$this->subscriptionscart->contents();
		if(!empty($cart))
		{
			foreach ($cart as $key => $item)
			{
				$upd= array(
			               'rowid' => $key,
               				'qty'   => 0
				            );
				$this->subscriptionscart->update($upd);
			}
		}

		$cart=$this->storecart->contents();
		if(!empty($cart))
		{
			foreach ($cart as $key => $item)
			{
				$upd= array(
			               'rowid' => $key,
               				'qty'   => 0
				            );
				$this->storecart->update($upd);
			}
		}
					
	}

	public function deleteDeclinedCartRow($ashramid=0,$userid=0,$carttype=0)
	{
		if($ashramid>0 && $userid>0 && $carttype>0)
		{
			$this->db->where('ashram_id',$ashramid);
			$this->db->where('user_id',$userid);
			$this->db->where('cart_type',$carttype);
			$this->db->delete('cart_data');
		}
	}

	public function getDonationValidDates($donationData)
	{
		$include_exclude_dates = @$donationData->include_exclude_dates;
		$weekdays=explode(",",$donationData->days);
		$exclude_dates=explode(",",$donationData->exclude_dates);
		$include_dates=explode(",",$donationData->include_dates);
		$startDate=date("d M Y 00:00:00");
		$endDate=date("d M Y 23:59:00",strtotime("+5 Months"));
		$startDateTime=strtotime($startDate);
		$endDateTime=strtotime($endDate);
		
		$result=array();
		
		if($startDateTime>=time())
			$temp=$startDateTime;
		else
			$temp=strtotime("00:00:00");
		
		while($temp<=$endDateTime)
		{
			if($donationData->days!='')
			{
				if($include_exclude_dates == 'IncludeDates')
				{
					if(in_array(date("l",$temp),$weekdays) && in_array(date("d M Y",$temp),$include_dates))
					{
						$result[]=date("d M Y",$temp);
					}
				} else if (in_array(date("l",$temp),$weekdays) && !in_array(date("d M Y",$temp),$exclude_dates))
				{
					$result[]=date("d M Y",$temp);
				}
			}
			else
			{
				if($include_exclude_dates == 'IncludeDates')
				{
					if(in_array(date("d M Y",$temp),$include_dates))
					{
						$result[]=date("d M Y",$temp);
					}
				} else if(!in_array(date("d M Y",$temp),$exclude_dates))
				{
					$result[]=date("d M Y",$temp);
				}
			}
			
			$temp=strtotime("+1 Day",$temp);
		}
		return $result;
	}
}
?>