<?PHP
class Cart_log_model extends CI_Model 
{
	var $tableName="cart_log";
	var $archivesDb = "";
	var $cart_log_data_table = "";
	var $cart_data_table = "";
	var $temp_payment_data_table = "";
	public function __construct()
	{
		parent::__construct();
		$current_year_table = date("Y");
		$year_table = date("Y",strtotime("-1 year"));
		$this->cart_log_data_table="cart_log_archives_".$year_table;
		$this->cart_data_table="cart_data_archives_".$year_table;
		$this->temp_payment_data_table="temp_payment_info_archives_".$current_year_table;
		$this->archivesDb = $this->load->database("data_archives",true,false);
	}
	public function log($message,$ashram_id=0,$type=1)
	{
		$user_id=0;
		$username='';
		$admin=0;
		if($ashram_id == 0 || empty($ashram_id))
		{
			return true;
		}
		if($this->session->userdata("loggedIn"))
		{
			if($this->session->userdata('user_id'))
			{
				$user_id=$this->session->userdata("user_id");
				$username=$this->session->userdata("user_data")->username;
			}
			else if($this->session->userdata('id'))
			{
				$user_id=$this->session->userdata("id");
				$username=$this->session->userdata("admin_data")->username;
				$admin=1;
				if($this->session->userdata('temp_checkout_user'))
				{
					$user_id=$this->session->userdata('temp_checkout_user')->id;
					$username=$this->session->userdata('temp_checkout_user')->username;
					$admin=0;
				}
			}
		}
		$session_id=session_id();
		$ip_address=$_SERVER['REMOTE_ADDR'];
		$browser=$this->agent->browser()." ".$this->agent->version();
		$platform=$this->agent->platform();
		$this->db->insert($this->tableName,array(
													"user_id"=>$user_id,
													"username"=>$username,
													"admin"=>$admin,
													"session_id"=>$session_id,
													"ip_address"=>$ip_address,
													"browser"=>$browser,
													"platform"=>$platform,
													"message"=>$message,
													"type"=>$type,
													"ashram_id"=>$ashram_id
											));
	}
	public function delete($session_id,$ip_address)
	{
		$this->db->where("session_id",$session_id);
		$this->db->where("ip_address",$ip_address);
		$q=$this->db->delete($this->tableName);
		return $this->db->affected_rows();
	}

	public function saveYeardatacartlog_cron()
	{
		$q = $this->db->select("user_id,username,admin,session_id,ip_address,browser,platform,message,type,ashram_id,date")->from($this->tableName)->where('date < NOW() + INTERVAL -90 DAY')->get();
		if($q->num_rows() > 0)
		{
			$result = $q->result_array();
			foreach ($result as $key => $value) 
			{
				$date_month = date("m",strtotime($value["date"]));
				$date_year = date("Y",strtotime($value["date"]));
				if(in_array($date_month, array("01","02","03")))
				{
					$arch_table = "cart_log_archives_from_01_to_03_".$date_year;
				}
				if(in_array($date_month, array("04","05","06")))
				{
					$arch_table = "cart_log_archives_from_04_to_06_".$date_year;
				}
				if(in_array($date_month, array("07","08","09")))
				{
					$arch_table = "cart_log_archives_from_07_to_09_".$date_year;
				}
				if(in_array($date_month, array("10","11","12")))
				{
					$arch_table = "cart_log_archives_from_10_to_12_".$date_year;
				}
				if ($this->archivesDb->table_exists($arch_table) )
				{

				}
				else
				{
				  	// table does not exist
				  	$new_table = "CREATE TABLE IF NOT EXISTS `".$arch_table."` (
					  			`id` int(11) NOT NULL AUTO_INCREMENT,
						  		`ashram_id` int(11) NOT NULL DEFAULT 0,
							  	`type` int(11) NOT NULL DEFAULT 1,
							  	`user_id` int(11) NOT NULL DEFAULT 0,
							  	`username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  	`admin` int(11) NOT NULL DEFAULT 0,
							  	`session_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
							  	`ip_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
							  	`message` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  	`date` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
							  	`browser` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  	`platform` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  		PRIMARY KEY (`id`)
								) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
					$this->archivesDb->query($new_table);
				}
				$this->archivesDb->insert($arch_table,$value);
			}
			$this->db->where('date < NOW() + INTERVAL -90 DAY')->delete($this->tableName);
		}
	}

	public function saveYeardatacartdata_cron()
	{
		$q = $this->db->select("cart_type,reference_id,cart_data,session_id,ashram_id,user_id,updated_on,started_on,cart_from_seva_details")->from("cart_data")->where('updated_on < NOW() + INTERVAL -365 DAY')->get();
		if($q->num_rows() > 0)
		{
			if ($this->archivesDb->table_exists($this->cart_data_table) )
			{
				// ashram_id does not exist
				if ($this->archivesDb->field_exists('ashram_id', $this->cart_data_table))
		        {
		            
		        }
		        else
		        {
		            $sqlUpdatecol ="ALTER TABLE `".$this->cart_data_table."` ADD `ashram_id` int(11) NOT NULL DEFAULT 0 AFTER `session_id`;";
		            $this->archivesDb->query($sqlUpdatecol);
		        }
		        if (!$this->archivesDb->field_exists('cart_from_seva_details', $this->cart_data_table))
		        {
		            $sqlUpdatecol ="ALTER TABLE `cart_data` ADD `cart_from_seva_details` SMALLINT(2) NOT NULL DEFAULT '0' AFTER `started_on`;";
		            $this->archivesDb->query($sqlUpdatecol);
		        }
			}
			else
			{
			  	// table does not exist
			  	$new_table = "CREATE TABLE IF NOT EXISTS `".$this->cart_data_table."` (
				  			  `id` int(11) NOT NULL AUTO_INCREMENT,
					  		  `cart_type` int(11) NOT NULL DEFAULT 1,
							  `reference_id` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `cart_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `session_id` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `ashram_id` int(11) NOT NULL DEFAULT 0,
							  `user_id` int(11) NOT NULL DEFAULT 0,
							  `updated_on` datetime NOT NULL,
							  `started_on` datetime DEFAULT NULL,
							  `cart_from_seva_details` SMALLINT(2) NOT NULL DEFAULT '0',
					  		PRIMARY KEY (`id`)
							) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
				$this->archivesDb->query($new_table);
			}
			$yearData = $q->result_array();
			$this->archivesDb->insert_batch($this->cart_data_table,$yearData);
			$this->db->where('updated_on < NOW() + INTERVAL -365 DAY')->delete("cart_data");
		}
	}

	public function temppaymentinfo_cron()
	{
		$q = $this->db->select("reference_id,transaction_id,redirect_url,success_url,fail_url,currency,amount,data,status,created_on,user_id,user_data")->from("temp_payment_info")->where('created_on < NOW() + INTERVAL -7 DAY')->get();
		if($q->num_rows() > 0)
		{
			if ($this->archivesDb->table_exists($this->temp_payment_data_table) )
			{

			}
			else
			{
			  	// table does not exist
			  	$new_table = "CREATE TABLE IF NOT EXISTS `".$this->temp_payment_data_table."` (
				  			  `id` int(11) NOT NULL AUTO_INCREMENT,
					  		  `reference_id` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `transaction_id` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `redirect_url` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `success_url` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `fail_url` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  `currency` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
							  `amount` int(11) DEFAULT NULL,
							  `data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
							  `status` int(11) DEFAULT 0,
							  `created_on` datetime DEFAULT NULL,
							  `user_id` int(11) NOT NULL DEFAULT 0,
							  `user_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
					  		PRIMARY KEY (`id`)
							) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
				$this->archivesDb->query($new_table);
			}
			$yearData = $q->result_array();
			$this->archivesDb->insert_batch($this->temp_payment_data_table,$yearData);
			$this->db->where('created_on < NOW() + INTERVAL -7 DAY')->delete("temp_payment_info");
		}
	}

	public function saveYeardatacartlog()
	{
		$years = array("2015","2016","2017","2018","2019");
		foreach ($years as $key => $value) 
		{
			$q = $this->db->select("user_id,username,admin,session_id,ip_address,browser,platform,message,type,ashram_id,date")->from("cart_log")->where('date like "%'.$value.'%"')->get();
			if($q->num_rows() > 0)
			{
				$n_cart_log_table="cart_log_archives_".$value;
				if ($this->archivesDb->table_exists($n_cart_log_table) )
				{

				}
				else
				{
				  	// table does not exist
				  	$new_table = "CREATE TABLE IF NOT EXISTS `".$n_cart_log_table."` (
					  			`id` int(11) NOT NULL AUTO_INCREMENT,
						  		`ashram_id` int(11) NOT NULL DEFAULT 0,
							  	`type` int(11) NOT NULL DEFAULT 1,
							  	`user_id` int(11) NOT NULL DEFAULT 0,
							  	`username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  	`admin` int(11) NOT NULL DEFAULT 0,
							  	`session_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
							  	`ip_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
							  	`message` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  	`date` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
							  	`browser` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							  	`platform` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  		PRIMARY KEY (`id`)
								) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
					$this->archivesDb->query($new_table);
				}
				$yearData = $q->result_array();
				$this->archivesDb->insert_batch($n_cart_log_table,$yearData);
				$this->db->where('date like "%'.$value.'%"')->delete("cart_log");
			}
		}
	}

	public function saveYeardatacartdata()
	{
		$years = array("2015","2016","2017","2018","2019");
		foreach ($years as $key => $value) 
		{
			$q = $this->db->select("cart_type,reference_id,cart_data,session_id,ashram_id,user_id,updated_on,started_on")->from("cart_data")->where('updated_on like "%'.$value.'%"')->get();
			if($q->num_rows() > 0)
			{
				$n_cart_data_table="cart_data_archives_".$value;
				if ($this->archivesDb->table_exists($n_cart_data_table) )
				{
					// ashram_id does not exist
					if ($this->archivesDb->field_exists('ashram_id', $n_cart_data_table))
			        {
			            
			        }
			        else
			        {
			            $sqlUpdatecol ="ALTER TABLE `".$n_cart_data_table."` ADD `ashram_id` int(11) NOT NULL DEFAULT 0 AFTER `session_id`;";
			            $this->archivesDb->query($sqlUpdatecol);
			        }
				}
				else
				{
				  	// table does not exist
				  	$new_table = "CREATE TABLE IF NOT EXISTS `".$n_cart_data_table."` (
					  			  `id` int(11) NOT NULL AUTO_INCREMENT,
						  		  `cart_type` int(11) NOT NULL DEFAULT 1,
								  `reference_id` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								  `cart_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
								  `session_id` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
								  `ashram_id` int(11) NOT NULL DEFAULT 0,
								  `user_id` int(11) NOT NULL DEFAULT 0,
								  `updated_on` datetime NOT NULL,
								  `started_on` datetime DEFAULT NULL,
						  		PRIMARY KEY (`id`)
								) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
					$this->archivesDb->query($new_table);
				}
				$yearData = $q->result_array();
				$this->archivesDb->insert_batch($n_cart_data_table,$yearData);
				$this->db->where('updated_on like "%'.$value.'%"')->delete("cart_data");
			}
		}
	}
}
?>