<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require 'vendor/autoload.php';
use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;
class Authorizenet_Model extends CI_Model
{
    function __construct() 
	{
	    parent::__construct();
    }

    public function processOneTimePayment($reference)
    {
    	$apiReturn['flag']=0;
		$tempInfo=$this->payment_model->getTempInfo($reference);
		if(!empty($tempInfo))
		{
			$amount=$tempInfo->amount;
			$uid=$tempInfo->user_id;
			$currency=$tempInfo->currency;
			$customData=unserialize($tempInfo->data);

			//Get trust data
			$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
	    	$trustsArray=array();
	    	foreach ($trusts as $trustData)
	    	{
	    		$trustsArray[$trustData->currency]=$trustData;
	    	}
	    	$trustData=$trustsArray[$tempInfo->currency];
			//Get trust data
			
			$data['reference']=$reference;
			$this->logaction->log($this->service,"Making API request - Ref:".$reference.", to authorize.net");

			// Set API Request Parameters
			$cardTransaction = new AuthorizeNetAIM($trustData->authorizenet_login,$trustData->authorizenet_key);
			$cardTransaction->amount = $amount;
			$cardTransaction->card_num = $customData['formData']['card_number'];
			$cardTransaction->exp_date = $customData['formData']['card_expiry'];
			$cardTransaction->card_code = $customData['formData']['card_cvv'];

			$customer = (object)array();
			$customer->first_name = $customData['formData']['firstname'];
			$customer->last_name = $customData['formData']['lastname'];
			$customer->address = $customData['formData']['address1'];
			$customer->city = $customData['formData']['city'];
			$customer->state = $customData['formData']['state'];
			$customer->zip = $customData['formData']['zipcode'];
			$customer->country = $customData['formData']['country'];
			$customer->phone = $customData['formData']['phone'];
			$customer->email = $customData['formData']['email'];
			$customer->customer_ip = $_SERVER['REMOTE_ADDR'];
			$cardTransaction->setFields($customer);

			//Charge credit card
			$response = $cardTransaction->authorizeAndCapture();
			
    		$customData=unserialize($tempInfo->data);
    		$orderId=0;
    		if(isset($customData['order_id']))
    			$orderId=$customData['order_id'];

	    	if($response->approved==1 && $response->response_code==1)//Success
	    	{
	    		$this->payment_model->createTransaction($response->transaction_id,$tempInfo->user_id,$reference,'approved',null,$orderId);
	    		$this->payment_model->tempInfoUpdateTx($reference,$response->transaction_id,$amount);
	    		$this->payment_model->updateAuthNetTransaction($response->transaction_id,$response);

				$transaction=new stdClass();
				$transaction->tx=$response->transaction_id;
				$tempIpn=new stdClass();
				$tempIpn->status='approved';
				$tempIpn->amount=$amount;


				if(isset($customData['cartData']))
				{
					$orderId=$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
					$this->orders_model->sendTransactionReceiptEmail($orderId,$transaction->tx);
				}
				else
				{
					$this->orders_model->sendTransactionReceiptEmail($orderId,$response->transaction_id);
				}

				$transactionRecord=$this->payment_model->getTransaction($response->transaction_id);
				$apiReturn['redirect_url']=$transactionRecord->redirect_url;
				$apiReturn['order_id']=$transactionRecord->order_id;
				$apiReturn['tx']=$response->transaction_id;

				////****Save Card*****////
				/*if(empty($creditCardData) && $uid>0)
				{
					$lastFourDigits=substr( $customData['formData']['card_number'],-4);
					$this->load->model("credit_cards_model");
					if(!$this->credit_cards_model->cardExist($lastFourDigits,$uid))
					{
						$this->credit_cards_model->saveCard(
															$uid,
															$lastFourDigits,
															str_replace("/","",$customData['formData']['card_expiry']),
															$customData['formData']['card_name'],
															$result_array['CARDTYPE'],
															$result_array['PNREF']
														);
					}
				}*/
				////****Save Card*****////

	    		$apiReturn['flag']=1;
	    		return $apiReturn; //Success
	    	}
	    	else
	    	{
	    		$txnid=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
	    		$this->payment_model->createTransaction($txnid,$tempInfo->user_id,$reference,'failure',"Error Code:".$result_array['RESULT']." - Msg: ".$result_array['RESPMSG'],$orderId);
	    		$this->payment_model->tempInfoUpdateTx($reference,$txnid);

	    		$this->logaction->log($this->service,"authorize.net error response - Error Code:".$result_array['RESULT']." - Msg: ".$result_array['RESPMSG']);
	    		$apiReturn['error_msg']=$result_array['RESPMSG'];
	    		return $apiReturn;
	    	}
		}
		else
		{
			$this->logaction->log($this->service,"Direct payment method - Invalid Ref:".$reference."  - redirected back");
			return $apiReturn;
		}
    }
}
?>