<?PHP
class Acl_Model extends CI_Model 
{
	var $tableName="acl";
	public function getList()
	{
		$i=0;
		$query1=$this->db;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
	
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && 
			trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			/* if($_POST['wild']=='contains')
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
			else if($_POST['wild']=='starts')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
			else if($_POST['wild']=='ends')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
			else if($_POST['wild']=='equals')
				$query1->where($_POST['search_col'],trim($_POST['search_text'])); */
		}
		
		$roleKeys=array_keys($this->roles);

		if(isset($_POST['admin_role']) && is_numeric($_POST['admin_role']) && in_array($_POST['admin_role'],$roleKeys))
		{
			$query1->where("FIND_IN_SET('".$_POST['admin_role']."',roles) !=","0");
		}
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(1,0)))
		{
			$query1->where("active",$_POST['status']);
		}
		if(isset($_POST['ajax']) && is_numeric($_POST['ajax']) && in_array($_POST['ajax'],array(1,0)))
		{
			$query1->where("is_ajax",$_POST['ajax']);
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$length=10;
		if(isset($_POST['length']))
			$length=abs($_POST['length']);

		$start=0;
		if(isset($_POST['start']))
			$start=abs($_POST['start']);
		
		
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) && isset($_POST['order'][0]['dir']))
		{
			$col_num=$_POST['order'][0]['column'];
			$col_name=$_POST['columns'][$col_num]['name'];
			$dir=$_POST['order'][0]['dir'];
			if(!in_array($dir,$GLOBALS['current_acl']['dir']))
			{
				$dir="asc";
			}
			if(!in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
			{
				$col_name="controller";
				$dir="asc";
			}
			$query1->order_by($col_name,$dir);
		}
		else
		{
			$query1->order_by("controller","asc");
			$query1->order_by("method","asc");
		}

		$query1->limit($length,$start);
		$result=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();
		$rtn['data']=array();
		$c=0;
		$sno=$start+1;
		foreach ($result as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($row['title']==null)
				$rtn['data'][$c]['title']='';
			if($row['description']==null)
				$rtn['data'][$c]['description']='';

			$rtn['data'][$c]['ajax']="No";
			$rtn['data'][$c]['status']="Inactive";
			$rtn['data'][$c]['admin_login']="No";
			$rtn['data'][$c]['user_login']="No";
			if($row['is_ajax']==1)
				$rtn['data'][$c]['ajax']="Yes";
			if($row['active']==1)
				$rtn['data'][$c]['status']="Active";
			if($row['need_admin_login']==1)
				$rtn['data'][$c]['admin_login']="Yes";
			if($row['need_user_login']==1)
				$rtn['data'][$c]['user_login']="Yes";

			if($row['search_columns']==null)
				$rtn['data'][$c]['search_columns']='';

			if($row['sort_columns']==null)
				$rtn['data'][$c]['sort_columns']='';

			if($row['excel_columns']==null)
				$rtn['data'][$c]['excel_columns']='';

			$sno++;
			$c++;
		}


		return $rtn;
	}
	public function update($vars)
	{
		$value='';
		if(isset($vars['value']))
			$value=$vars['value'];
		if(isset($vars['pk']) && isset($vars['name']))
		{
			$this->db->where("id",$vars['pk']);
			$acl_data=$this->db->get($this->tableName)->row();
			$column_name=$vars['name'];
			$value=$vars['value'];


			$this->db->where("controller",$acl_data->controller);
			$this->db->where("method",$acl_data->method);
			if($vars['name']=='roles')
			{
				if($value!='')
					$roles=implode(",",$value);
				else
					$roles='';
				$this->db->update($this->tableName,array(trim($_POST['name'])=>$roles));
			}
			else
				$this->db->update($this->tableName,array(trim($_POST['name'])=>trim($_POST['value'])));

			$up_query=preg_replace("/\n/"," ",$this->db->last_query()).";";

			$down_query='UPDATE `'.$this->tableName.'` set `'.$vars['name'].'` = \''.$acl_data->$column_name.'\' where `controller` =\''.$acl_data->controller.'\' and `method` = "'.$acl_data->method.'" ;';

			$this->log_sql($down_query,$up_query);

			return 1;
		}
		else return 0;
	}

	function reload()
	{
		// Load the library
		$this->load->library('controllerlist',array("folder"=>"controllers"));
   		$list=$this->controllerlist->getControllers();

		$exist=0;
		$new=0;
		$ids=array();
		
		foreach($list as $controller=>$methods)
		{
			foreach($methods as $method)
			{
				$this->db->select("*");
				$this->db->from($this->tableName);
				$this->db->where("controller",$controller);
				$this->db->where("method",$method);
				$q=$this->db->get();

				if(!$q->num_rows())
				{
					$q=$this->db->insert($this->tableName,
                                array(
                                	'controller' => $controller,
									'method' => $method
									)
								);
					
					$ids[]=$this->db->insert_id();

					//Log db changes
					$up_query=$this->db->last_query().";";
					$down_query="\n DELETE FROM `".$this->tableName."` where `controller` ='".$controller."' and `method` = '".$method."' ;";
					$this->log_sql($down_query,$up_query);
					//Log db changes

					$new++;
				}
				else 
				{
					$result=$q->row();
					$ids[]=$result->id;
					$exist++;
				}
			}
		}

		$down_query='';
		$up_query='';
		$deleted=0;
		$this->db->where_not_in("id",$ids);
		$this->db->where("controller !=",'restapi');
		$deleteable_acls=$this->db->get($this->tableName)->result_array();
		$deleteable_ids=array();
		foreach ($deleteable_acls as $acl_record)
		{
			$col_names='';
			$col_values='';
			foreach ($acl_record as $colname => $colvalue)
			{
				if($col_names!='')
				{
					$col_names.=",";
					$col_values.=",";
				}
				$col_names.="`".$colname."`";
				$col_values.="'".$colvalue."'";
			}
			$deleteable_ids[]=$acl_record['id'];
			$up_query.="\n DELETE FROM ".$this->tableName." where `controller` = '".$acl_record['controller']."' and `method` = '".$acl_record['method']."';";
			$down_query.="\n INSERT into `".$this->tableName."` (".$col_names.") values (".$col_values.");";
			$deleted++;
		}
		$this->log_sql($down_query,$up_query);

		$remove_duplicate_rows = "DELETE n1 FROM acl n1, acl n2 WHERE n1.id > n2.id AND n1.controller = n2.controller AND n1.method = n2.method";

		$this->db->query($remove_duplicate_rows);
		
		echo $new."_".$deleted;
	}

	public function get_acl()
	{
		$controller=$this->uri->segment(1);
		$method=$this->uri->segment(2);
		
		if($method=='')
		$method="index";
		
		$acl=$this->db->query("select * from acl where 
		controller='".$this->general_model->db_escape(trim($controller))."' and 
		method='".$this->general_model->db_escape(trim($method))."'");
		
		if($acl->num_rows())
		{
		$details=$acl->row();
		
		$roles=explode(",",$details->roles);
		}
		else
		$roles=array();
		if(in_array($this->session->userdata("role"),$roles))
		return true;
		else
		return false;
	}
	
	
	// Sathish Ravepati
	// Modified on 20-02-2014
	// @ tell us roles for controller and method
	public function getAcl()
	{
		$controller=$this->uri->segment(2);
		$method=$this->uri->segment(3);
		
		if($controller!='' && $method!=''){
			if($method=='')
				$method="index";
			
			$acl=$this->db->query("select * from acl where 
			controller='".$this->general_model->db_escape(trim($controller))."' and 
			method='".$this->general_model->db_escape(trim($method))."'");
			$details=$acl->row();
			
			if($this->session->userdata("role")!=''){
				$roles=explode(",",$details->roles);
				if(in_array($this->session->userdata("role"),$roles))
					return true;
				else
					return false;
			}else{
				return true;
			}
		}else{
			return true;
		}
	}
	public function app_acl()
	{
		$controller=$this->uri->segment(1);
        $method=$this->uri->segment(2);

        if($controller=='restapi')
        {
            if($this->uri->segment(3)!='')
            {
                $method.="/".$this->uri->segment(3);
            }
        }

        if($controller=='') $controller='home';
        if($method=='') $method='index';
        //$this->db->where("active",1);
        $this->db->where("controller",ucwords($controller));
        $this->db->where("method",$method);

        $q=$this->db->get("acl");
        if($q->num_rows())
        {
            $acl=$q->row();
            $GLOBALS['current_acl']['data']=$acl;
            $GLOBALS['current_acl']['search_columns']=explode(",",$acl->search_columns);
            $GLOBALS['current_acl']['sort_columns']=explode(",",$acl->sort_columns);
            $tempCols=array();

            if($acl->excel_columns!='')
            {
                $temp1=explode(",",$acl->excel_columns);
                foreach ($temp1 as $colMaps)
                {
                    $temp2=explode(":",$colMaps);
                    $tempCols[$temp2[0]]=$temp2[1];
                }
            }
            $GLOBALS['current_acl']['excel_columns']=$tempCols;
            $GLOBALS['current_acl']['wild']=array("contains","starts","ends");
            $GLOBALS['current_acl']['dir']=array("asc","desc");
            $GLOBALS['current_acl']['per_page_options_user']=array(10,20);
            $GLOBALS['current_acl']['per_page_options_admin']=array(10,20,50,100);
        }
	}

	/**
	 * Checks whether a group is assigned for an ACL record
	 *
	 * @param      string   $group_id  The group identifier
	 *
	 * @return     boolean  True if assigned otherwise false
	 */
	public function check_group_assigned($group_id)
	{
		$this->db->where('FIND_IN_SET(\''.$group_id."',groups".") !=",0);
		if($this->db->get($this->tableName)->num_rows())
			return true;
		else
			return false;
	}
	/**
	 * Checks whether a role is assigned for an ACL record
	 *
	 * @param      string   $role_id  The role identifier
	 *
	 * @return     boolean  True if assigned otherwise false
	 */
	public function check_role_assigned($role_id)
	{
		$this->db->where('FIND_IN_SET(\''.$role_id."',roles".") !=",0);
		if($this->db->get($this->tableName)->num_rows())
			return true;
		else
			return false;
	}

	private function log_sql($down_query,$up_query)
	{
		$this->load->helper("file");
		$file_data='';
		if($up_query!='')
		$file_data="\n".date("d:m:Y h:i:s")." - UP - ".$this->currentUser->username." - ".$up_query;
		if($down_query!='')
		$file_data.="\n".date("d:m:Y h:i:s")." - DOWN - ".$this->currentUser->username." - ".$down_query;
		$fp=write_file(APPPATH.'logs/acl_db_log.txt',$file_data,'a');
	}
}
?>