<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_20210329000002 extends CI_Migration {

    public function up()
    {
        if (!$this->db->field_exists('item_key', "poojas"))
        {
            $alter_sql = "ALTER TABLE `poojas` ADD `item_key` VARCHAR(120) NULL DEFAULT NULL COMMENT 'To access only this pooja in list' AFTER `s_key`;"; 
            $this->db->query($alter_sql);
        }

        if (!$this->db->field_exists('is_secret', "poojas"))
        {
            $alter_sql = "ALTER TABLE `poojas` ADD `is_secret` int(11) NOT NULL DEFAULT '0' AFTER `s_key`;"; 
            $this->db->query($alter_sql);
        }

        $alter_sql = "ALTER TABLE `poojas` CHANGE `s_flag` `only_for_admin` INT(11) NOT NULL DEFAULT '0';"; 
        $this->db->query($alter_sql);

        if (!$this->db->field_exists('display_only_popup', "poojas"))
        {
            $alter_sql = "ALTER TABLE `poojas` ADD `display_only_popup` int(11) NOT NULL DEFAULT '0';"; 
            $this->db->query($alter_sql);
        }
        if (!$this->db->field_exists('popup_content', "poojas"))
        {
            $alter_sql = "ALTER TABLE `poojas` ADD `popup_content` longtext DEFAULT NULL AFTER `display_only_popup`;"; 
            $this->db->query($alter_sql);
        }

        if (!$this->db->field_exists('item_key', "donations"))
        {
            $alter_sql = "ALTER TABLE `donations` ADD `item_key` VARCHAR(120) NULL DEFAULT NULL COMMENT 'To access only this donation in list' AFTER `s_key`;"; 
            $this->db->query($alter_sql);
        }

        if (!$this->db->field_exists('is_secret', "donations"))
        {
            $alter_sql = "ALTER TABLE `donations` ADD `is_secret` int(11) NOT NULL DEFAULT '0' AFTER `s_key`;"; 
            $this->db->query($alter_sql);
        }

        $alter_sql = "ALTER TABLE `donations` CHANGE `s_flag` `only_for_admin` INT(11) NOT NULL DEFAULT '0';"; 
        $this->db->query($alter_sql);

        if (!$this->db->field_exists('display_only_popup', "donations"))
        {
            $alter_sql = "ALTER TABLE `donations` ADD `display_only_popup` int(11) NOT NULL DEFAULT '0';"; 
            $this->db->query($alter_sql);
        }
        if (!$this->db->field_exists('popup_content', "donations"))
        {
            $alter_sql = "ALTER TABLE `donations` ADD `popup_content` longtext DEFAULT NULL AFTER `display_only_popup`;"; 
            $this->db->query($alter_sql);
        }

        if (!$this->db->field_exists('item_key', "subscriptions"))
        {
            $alter_sql = "ALTER TABLE `subscriptions` ADD `item_key` VARCHAR(120) NULL DEFAULT NULL COMMENT 'To access only this subscription in list' AFTER `s_key`;"; 
            $this->db->query($alter_sql);
        }

        if (!$this->db->field_exists('is_secret', "subscriptions"))
        {
            $alter_sql = "ALTER TABLE `subscriptions` ADD `is_secret` int(11) NOT NULL DEFAULT '0' AFTER `s_key`;"; 
            $this->db->query($alter_sql);
        }

        $alter_sql = "ALTER TABLE `subscriptions` CHANGE `s_flag` `only_for_admin` INT(11) NOT NULL DEFAULT '0';"; 
        $this->db->query($alter_sql);

        if (!$this->db->field_exists('display_only_popup', "subscriptions"))
        {
            $alter_sql = "ALTER TABLE `subscriptions` ADD `display_only_popup` int(11) NOT NULL DEFAULT '0';"; 
            $this->db->query($alter_sql);
        }
        if (!$this->db->field_exists('popup_content', "subscriptions"))
        {
            $alter_sql = "ALTER TABLE `subscriptions` ADD `popup_content` longtext DEFAULT NULL AFTER `display_only_popup`;"; 
            $this->db->query($alter_sql);
        }

        if (!$this->db->field_exists('only_for_admin', "store"))
        {
            $alter_sql = "ALTER TABLE `store` ADD `only_for_admin` INT(11) NOT NULL DEFAULT '0' AFTER `image`;"; 
            $this->db->query($alter_sql);
        }

        if (!$this->db->field_exists('s_key', "store"))
        {
            $alter_sql = "ALTER TABLE `store` ADD `s_key` VARCHAR(120) NULL DEFAULT NULL AFTER `only_for_admin`;"; 
            $this->db->query($alter_sql);
        }

        if (!$this->db->field_exists('item_key', "store"))
        {
            $alter_sql = "ALTER TABLE `store` ADD `item_key` VARCHAR(120) NULL DEFAULT NULL COMMENT 'To access only this store item in list' AFTER `s_key`;"; 
            $this->db->query($alter_sql);
        }

        if (!$this->db->field_exists('display_only_popup', "store"))
        {
            $alter_sql = "ALTER TABLE `store` ADD `display_only_popup` int(11) NOT NULL DEFAULT '0';"; 
            $this->db->query($alter_sql);
        }
        if (!$this->db->field_exists('popup_content', "store"))
        {
            $alter_sql = "ALTER TABLE `store` ADD `popup_content` longtext DEFAULT NULL AFTER `display_only_popup`;"; 
            $this->db->query($alter_sql);
        }


    }

    public function down()
    {
        $sql="";
        $sqls=array_filter(explode(";",$sql));
        foreach ($sqls as $q)
        {
          if(trim($q)!='')
          $this->db->query($q);
        }
    }
}
?>