<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_20210219000001 extends CI_Migration
{
    public function up()
    {
        $insert_sql = "CREATE TABLE IF NOT EXISTS `bounced_emails` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `bounced_email` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
              `bounce_count` int(4) NOT NULL DEFAULT 0,
              `sso_user_id` int(11) NOT NULL DEFAULT 0,
              `user_name` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
              `last_bounced_on` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
        $this->db->query($insert_sql);

        $emailsDb=$this->load->database("emails",true,false);

        $tables = $emailsDb->list_tables();

        foreach ($tables as $table)
        {
            if (!$emailsDb->field_exists('bounced', $table))
            {
                $alter_sql = "ALTER TABLE `".$table."` ADD `bounced` int(4) NOT NULL DEFAULT 0 AFTER `viewed`;";
                $emailsDb->query($alter_sql);
            }
        }

        if (!$this->db->field_exists('email_bounce_count', "users"))
        {
            $alter_sql = "ALTER TABLE `users` ADD `email_bounce_count` int(4) NOT NULL DEFAULT 0;";
            $this->db->query($alter_sql);
        }

        $ssoDb=$this->load->database("sso_auth",true,false);
        if (!$ssoDb->field_exists('email_bounce_count', "users"))
        {
            $alter_sql = "ALTER TABLE `users` ADD `email_bounce_count` int(4) NOT NULL DEFAULT 0;";
            $ssoDb->query($alter_sql);
        }

        $acl_sql1 ="INSERT INTO `acl` (`id`, `title`, `description`, `controller`, `method`, `roles`, `is_ajax`, `active`, `excel_columns`, `need_admin_login`, `need_user_login`, `search_columns`, `sort_columns`) VALUES (NULL, NULL, NULL, 'Usersadmin', 'bounced_emails', '1', '0', '1', NULL, '0', '0', NULL, NULL);"; 
        $this->db->query($acl_sql1);

        $acl_sql2 ="INSERT INTO `acl` (`id`, `title`, `description`, `controller`, `method`, `roles`, `is_ajax`, `active`, `excel_columns`, `need_admin_login`, `need_user_login`, `search_columns`, `sort_columns`) VALUES (NULL, NULL, NULL, 'Usersadmin', 'listbouncedemails', '1', '1', '1', 'bounced_email:Bounced Email,user_name:User ID', '0', '0', 'bounced_email,user_name', 'bounced_email,user_name,last_update_on');";
         $this->db->query($acl_sql2);
    }

    public function down()
    {
    }
}
?>