<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_20190801000007 extends CI_Migration {

    /**
     * To Insert SMS Queue of Order Details and Transaction Details for user
     * Only for ashram {{Ashram_id: 5}}
     * And It is just to save template data in to respectivee queue's. Will not send any SMS
     * @author Baji Shaik [bajidotwork@gmail.com] - 30 Jul 2019
     * ---Ticket: 467 (bajidotwwork_DPDEV-467)
     */
    public function up()
    {
        ini_set('max_execution_time', 0);
        
        $this->load->model('locations_model');
        
        $q = $this->db->select('id,transaction_id')->from('orders')->where('ashram_id',5)->where('currency','inr')->where('transaction_id!=','')->where('transaction_id!=',null)->get();

        $service_slug = 'payments_5_inr';

        if($q->num_rows() > 0)
        {
            $r = $q->result_array();
            if(!empty($r))
            {
                foreach ($r as $key => $value) 
                {
                    $orderData=$this->orderData($value['id']);

                    $data['orderData']=$orderData;
                    $data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
                    
                    $service_slug = 'payments_5_inr';

                    /*----------  Transaction Reciept SMS  ----------*/

                    if($orderData)
                    {
                        if(!empty($value['transaction_id']))
                        {
                            $transaction = $this->getTransactionByTx($value['transaction_id']);

                            if(!empty($transaction->status))
                                if(in_array($transaction->status,array('success','Success','approved','completed','captured','paid','release payment','Release Payment')))
                                {
                                    if($transaction->payment_mode=='paypal')
                                        $transaction->date=$transaction->created_on;

                                    if($transaction->payment_mode == "cashiers_check")
                                    {
                                        $transaction->payment_mode = "Cashiers Check";
                                    }
                                    if($transaction->payment_mode == "paypal" && $transaction->status="approved")
                                    {
                                        $transaction->status = "paid";
                                    }
                                    if($transaction->payment_mode == "razorpay" && $transaction->status="captured")
                                    {
                                        $transaction->status = "paid";
                                    }
                                    if($transaction->payment_mode == "payu" && $transaction->status="Release Payment")
                                    {
                                        $transaction->status = "paid";
                                    }

                                    $message=
                                        display_site_name."\n".
                                        "Payment update:\n".
                                        "Order ID: ".$orderData['order']->order_number."\n".
                                        "Tx Date: ".date("d M Y",strtotime($transaction->date))."\n".
                                        "Amount: ".strtoupper($orderData['order']->currency)." ".$transaction->amount."\n".
                                        "Payment mode: ".$transaction->payment_mode."\n".
                                        "Transaction status: ".ucwords($transaction->status)
                                        ;
                                    $smsdata=array(
                                        'user_id' => $orderData['order']->user_id,
                                        'username'=>$orderData['order']->username,
                                        'message_id' => "",
                                        'message' => $message,
                                        'to' => $data['countryData']->isd_code.$orderData['order']->phone,
                                        'sent_on'=>$orderData['order']->date,
                                        'date'=>date("Y:m:d H:i:s"),
                                        'status'=>1,
                                        'fail_reason'=>"",
                                        'resent'=>0,
                                        'resent_id'=>0
                                        );
                                    $this->smsDb=$this->load->database("sms",true,false);
                                    $this->smsDb->insert('sms_track_'.$service_slug,$smsdata);
                                }
                        }
                    }

                    /*----------  Transaction Reciept SMS  ----------*/
                }
            }
        }
    }

    public function getTransactionByTx($tx)
    {
        $this->db->where("tx",$tx);
        $transaction=$this->db->get("transaction");
        $txrow=$transaction->row();

        if(empty($txrow))
            return array();

        if($txrow->sub_transaction==1)
        {
            $this->db->select("
                                *
                                ,t2.amount as amount
                                ,t2.id as id
                            ");
            $this->db->from("transaction as t");
            $this->db->join("transaction as t2","t.tx=t2.sub_tx");
            $this->db->where("t.tx",$txrow->sub_tx);
            $this->db->where("t2.tx",$tx);

            $transaction=$this->db->get();
            $txrow=$transaction->row();
        }
        return $txrow;
    }

    public function orderData($id)
    {
        $this->db->where("id",$id);
        $q=$this->db->get("orders");
        $result['order']=$q->row();
        $result['order_items']=array();
        $result['order_items_files']=array();
        if($q->num_rows())
        {
            $this->db->select("*,oi.id as id,oi.id as order_item_id,p.id as pet_id");
            $this->db->where("order_id",$id);
            $this->db->from("order_items as oi");
            $this->db->join("pets as p","p.id=oi.pet_id","left");
            $items=$this->db->get();
            $result['order_items']=$items->result();

            $this->db->where("order_id",$id);
            $items=$this->db->get("order_log");
            $result['order_log']=$items->result();

            $this->db->where("order_id",$id);
            $items=$this->db->get("order_items_files");
            if($items->num_rows())
            {
                $result['order_items_files']=$items->result();
                foreach ($result['order_items_files'] as $fileData)
                {
                    $this->db->where("file_id",$fileData->id);
                    $tempD=$this->db->get("order_items_downloads")->result();
                    $result['order_items_downloads'][$fileData->id]=$tempD;
                }
            }

            $this->db->where("order_id",$id);
            $payflow_card=$this->db->get("subscription_profiles_payflow")->row();
            $result['payflow_card']=$payflow_card;
        }
        return $result;
    }

    public function down()
    {
        $sql='';
        $sqls=explode(";",$sql);
        foreach ($sqls as $q)
        {
            if($q!='')
            $this->db->query($q);
        }
    }
}
?>