<?php

defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Subscription Groups Migrations
 * Ref: Subscription Groups
 *      Subscriptions SMS
 *      Subscriptions Email
 *@author Baji shaik <bajidotwork@gmail.com>
 */
class Migration_20190628000006   extends CI_Migration {

    public function up()
    {
        $sql="
            ALTER TABLE `subscriptions_sms` ADD `group_id` VARCHAR(110) NULL DEFAULT NULL AFTER `phone`;
            ALTER TABLE `subscriptions_email` ADD `group_id` VARCHAR(110) NULL DEFAULT NULL AFTER `email`;

            CREATE TABLE IF NOT EXISTS `subscription_groups` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `group_name` varchar(120) NOT NULL,
              `group_slug` varchar(250) DEFAULT NULL,
              `status` enum('1','0') NOT NULL DEFAULT '1',
              `created_on` datetime NOT NULL,
              `modified_on` datetime DEFAULT NULL,
              `created_by` int(11) NOT NULL,
              `modified_by` int(11) DEFAULT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
        ";
        $sqls=array_filter(explode(";",$sql));
        foreach ($sqls as $q)
        {
            if(trim($q)!='')
            $this->db->query($q);
        }
    }

    public function down()
    {
        $sql="
            ALTER TABLE `subscriptions_sms` DROP `group_id`;
            ALTER TABLE `subscriptions_email` DROP `group_id`;
            DROP table `subscription_groups`;
        ";
        $sqls=array_filter(explode(";",$sql));
        foreach ($sqls as $q)
        {
            if(trim($q)!='')
            $this->db->query($q);
        }
    }
}
?>