<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_20190409000004 extends CI_Migration
{
    public function up()
    {
        $sql = "ALTER TABLE `transaction` ADD `is_foreign_payment` INT(11) NULL DEFAULT 0;";
        $this->db->query($sql);
        
        $sql = "ALTER TABLE `transaction` ADD `foreign_currency` VARCHAR(20) NULL;";
        $this->db->query($sql);

        $sql = "ALTER TABLE `transaction` ADD `foreign_amount` INT(11) NULL DEFAULT 0;";
        $this->db->query($sql);

        $sql = "ALTER TABLE `transaction` ADD `realized_amount` INT(11) NULL DEFAULT 0;";
        $this->db->query($sql);

        $sql = "CREATE TABLE `foreign_currencies` (
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `currency` varchar(20) NOT NULL,
                    `description` varchar(200) DEFAULT NULL,
                    `created_on` datetime NOT NULL,
                    `modified_on` datetime NOT NULL,
                    PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        $this->db->query($sql);

        $sql = "INSERT INTO `foreign_currencies` (`id`, `currency`, `description`, `created_on`, `modified_on`) VALUES
                (1, 'aud', 'Australian dollar', '2019-04-24 00:00:00', '2019-04-24 00:00:00'),
                (2, 'usd', 'US dollar', '2019-04-24 00:00:00', '2019-04-24 00:00:00'),
                (3, 'eur', 'Euro', '2019-04-24 00:00:00', '2019-04-24 00:00:00'),
                (4, 'pound', 'Britain pound', '2019-04-24 00:00:00', '2019-04-24 00:00:00'),
                (5, 'inr', 'Indian rupee', '2019-04-24 00:00:00', '2019-04-24 00:00:00');";
        $this->db->query($sql);


    }

    public function down()
    {
        $sql='ALTER TABLE `transaction` DROP `foreign_currency`, DROP `foreign_amount`, DROP `realized_amount`;
        DROP table `foreign_currencies`;';
        $sqls=array_filter(explode(";",$sql));
        foreach ($sqls as $q)
        {
            if(trim($q)!='')
            $this->db->query($q);
        }
    }
}
?>