<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_20190407000001   extends CI_Migration {

    public function up()
    {
        $this->load->model("locations_model");
        $countries=$this->locations_model->getCountries(true);

        $this->db->where("order_id >",0);
        $this->db->group_start();
            $this->db->where("firstname",null);
            $this->db->or_where("firstname",'');
        $this->db->group_end();
        $transactions=$this->db->get("transaction")->result();

        foreach ($transactions as $transaction)
        {
            $this->db->where("id",$transaction->order_id);
            $orderData=$this->db->get("orders")->row();

            $this->db->where("id",$transaction->id);
            $this->db->update("transaction",
                                    array(
                                        "firstname"=>$orderData->firstname,
                                        "lastname"=>$orderData->lastname,
                                        "city"=>$orderData->city,
                                        "state"=>$orderData->state,
                                        "country"=>$orderData->country,
                                        "zipcode"=>$orderData->zipcode,
                                        "email"=>$orderData->email,
                                        "phone"=>$orderData->phone,
                                        "country_isd_code"=>$countries[$orderData->country]->isd_code
                                    )
                                );
        }
       // exit;
        /*$sql = "ALTER TABLE `razorpay_subscriptions` CHANGE `plan_id` `plan_id` VARCHAR(60) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL;";
        $this->db->query($sql);*/
    }

    public function down()
    {
        $sql='';
        $sqls=array_filter(explode(";",$sql));
        foreach ($sqls as $q)
        {
            if(trim($q)!='')
            $this->db->query($q);
        }
    }
}
?>