<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
class Userutil 
{
	var $CI='';
	public function __construct()
    {
        $this->CI =& get_instance();
        $this->CI->load->model("userutil_model");
    }
    /**
     * Registers the User
     * @param  array $info Array of information [firstname,middlename,lastname,email,username,password,country]
     * @return array
     */
    public function register($info)
    {
        $data['flag']=0;
        $data['userid']=0;
        $userid=$this->CI->userutil_model->registerUser($info);
        if($userid)
        {
            $this->CI->logaction->log("users","User registered | Username: ".trim($info['username'])." | ID: ".$userid." |
            Email ID: ".trim($info['email']));
            $data['flag']=1; // Active User
            $data['userid']=$userid;
        }
        return $data;
    }

    public function getUserData($id=0)
    {
    	$data['flag']=0;
    	$data['userid']=0;
    	if($id)
    	{
    		if(is_numeric($id))
    		{
    			$q=$this->CI->userutil_model->getUserData($id);
    			if(!empty($q))
	    		{
	    			$r=$q;
	    			/*unset($r->pass);// Remove password
	    			unset($r->pin);// Remove PIN
	    			unset($r->pin_copy);*/
	    			$data['admin']=$r->admin;
	    			$data['role']=$r->role;
	    			$data['userid']=$r->id;
	    			$data['userdata']['email']=$r->email;
	    			$data['userdata']['username']=$r->username;
	    			$data['userdata']['firstname']=$r->firstname;
	    			$data['userdata']['lastname']=$r->lastname;
	    			$data['userdata']['phoneno']=$r->phoneno;
		    		$data['flag']=1; // Active User
	    		}
    		}
    		else
    			$data['flag']=0; // Invalid UserID
    	}
    	else
    	{
    		$data['flag']=0; // Invalid UserID
    	}
    	return $data;
    }

    public function getUserMetaData($id=0)
    {
        $data['flag']=0;
        $data['userid']=0;
        if($id)
        {
            if(is_numeric($id))
            {
                $q=$this->CI->userutil_model->getUserData($id);
                if(!empty($q))
                {
                    $r=$q;
                    /*unset($r->pass);// Remove password
                    unset($r->pin);// Remove PIN
                    unset($r->pin_copy);*/
                    $data['userid']=$r->id;
                    $data['userdata']=$r;
                    $data['flag']=1; // Active User
                }
            }
            else
                $data['flag']=0; // Invalid UserID
        }
        else
        {
            $data['flag']=0; // Invalid UserID
        }
        return $data;
    }
    public function verifyEmail($email,$uid)
    {
         return $q=$this->CI->userutil_model->verifyEmail($email,$uid);
    }
    public function verifyUsername($username,$uid)
    {
         return $q=$this->CI->userutil_model->verifyUsername($username,$uid);
    }
    
    public function updateSecurityQuestions($uid,$vars)
    {
        if(is_numeric($uid) && $uid)
            return $this->CI->userutil_model->updateSecurityQuestions($uid,$vars);
        else
            return 0;
    }
    public function updatePasswordUser($uid,$currentPassword,$newPassword)
    {
        if(is_numeric($uid) && $uid)
            return $this->CI->userutil_model->updatePasswordUser($uid,$currentPassword,$newPassword);
        else
            return 0;
    }
    public function updatePinUser($uid,$newPin)
    {
        if(is_numeric($uid) && $uid)
            return $this->CI->userutil_model->updatePinUser($uid,$newPin);
        else
            return 0;
    }
    public function getWallet($uid,$currency='')
    {
        if(is_numeric($uid) && $uid)
        {
            $wallet=$this->CI->userutil_model->getWallet($uid,$currency);
            if($currency!='')
            {
                if(gettype($wallet)=='int')
                    return "Invalid currency";
            }
            return $wallet;
        }
        else
            return array();
    }
    public function creditWalletPayU($vars,$uid,$admin=0)
    {
        $data['flag']=0;
        if(isset($vars['mihpayid']))
        {
            $data['flag']=$this->CI->userutil_model->creditWalletPayU($uid,$vars,$admin);
            if($data['flag']==2)
            {
                $data['error']="Transaction failure";
            }
        }
        else
        {
            $data['error']="Invalid Payment Data";
        }
        return $data;
    }
    public function creditWalletPayPal($vars,$uid,$admin=0)
    {
        $data['flag']=0;
        if(isset($vars->txn_id))
        {

            $data['flag']=$this->CI->userutil_model->creditWalletPayPal($uid,$vars,$admin);
            if($data['flag']==2)
            {
                $data['error']="Transaction failure";
            }
        }
        else
        {
            $data['error']="Invalid Payment Data";
        }
        return $data;
    }
    public function creditWallet($uid,$txnid,$amount,$currency,$note,$uniqueID,$serviceSlug)
    {
        $data['flag']=0;
        if(isset($txnid))
        {

            $data['flag']=$this->CI->userutil_model->makeWalletTransaction($uid,$txnid,$amount,'credit',$currency,$note,"wallet");
            if($data['flag']==2)
            {
                $data['error']="Transaction failure";
            }
        }
        else
        {
            $data['error']="Invalid Payment Data";
        }
        return $data;
    }

    public function chargeWallet($userID,$amount,$currency,$uniqueID,$note,$serviceSlug)
    {
        $data['flag']=0;

        $wallet=$this->getWallet($userID);
        if($wallet->$currency>=$amount)
        {
            $tx=$this->CI->userutil_model->chargeWallet($userID,$amount,$currency,$uniqueID,$note,$serviceSlug);
            $data['tx']=$tx;
            $data['flag']=1;
        }
        else
        {
            $data['flag']=2;
            $data['error']="Insufficient Funds";
        }
        return $data;
    }
    public function sendEmailVerificationLink($uid=0)
    {
        $result=$this->CI->userutil_model->sendEmailVerificationLink($uid);
        return $result;
    }
    public function sendResetPasswordLink($uid=0)
    {
        $result=$this->CI->userutil_model->sendResetPasswordLink($uid);
        return $result;
    }
    public function activateUser($username='')
    {
        if($username!='')
        {
            $result=$this->CI->userutil_model->activateUser($username);
            return $result;
        }
        else
            return 0;
    }
    public function isAdmin()
    {
        if($this->CI->session->userdata("id"))
        {
            return 1;
        }
        else
            return 0;
    }

    public function sendUpdatedEmailVerificationLink($uid=0,$email)
    {
        $result=$this->CI->userutil_model->sendUpdatedEmailVerificationLink($uid,$email);
        return $result;
    }
    
}
?>