<?php
/**
* @package     Server
* @author      xiaocao
* @link        http://homeway.me/
* @copyright   Copyright(c) 2015
* @version     15.6.24
**/
date_default_timezone_set('Asia/Kolkata');

class Server{
	public $access_token;
	public $access_token_data;
	function __construct($config=array()){
		//print_r(getallheaders() );
		if($_SERVER['REQUEST_METHOD']=='OPTIONS')
		{
			http_response_code(200);
			exit;
		}
		//This Exit is included hold mobile app for a while will remove below exit once App has been restared
		return true;
		exit();
		//This Exit is included hold mobile app for a while will remove below exit once App has been restared
		include(APPPATH.'config/database.php');
		require_once(APPPATH.'third_party/OAuth2/Autoloader.php');	//oauth library
		$config = $db['default'];

		OAuth2\Autoloader::register();
		$this->storage = new OAuth2\Storage\Pdo(array('dsn' => $config["dsn"], 'username' => $config["username"], 'password' => $config["password"]));
		$this->server = new OAuth2\Server($this->storage, array('allow_implicit' => true,'issuer'=>'localhost'),array(),array(),new OAuth2\TokenType\Bearer());
		$this->request = OAuth2\Request::createFromGlobals();
		$this->response = new OAuth2\Response();

		$this->access_token_data=$this->server->getAccessTokenData($this->request);
	}

	/**
	* client_credentials, for more see: http://tools.ietf.org/html/rfc6749#section-4.3
	* @link http://homeway.me/2015/06/29/build-oauth2-under-codeigniter/#Client_Credentials
	*/
	public function client_credentials(){
		$this->server->addGrantType(new OAuth2\GrantType\ClientCredentials($this->storage, array(
    		"allow_credentials_in_request_body" => true
		)));
		$this->server->handleTokenRequest($this->request)->send();
	}

	/**
	* password_credentials, for more see: http://tools.ietf.org/html/rfc6749#section-4.3
	* @link http://homeway.me/2015/06/29/build-oauth2-under-codeigniter/#Resource_Owner_Password_Credentials
	*/
	public function password_credentials()
	{
		$users = array($_POST['username'] => array("password" => $_POST['password']));
		//$storage = new OAuth2\Storage\Pdo($config);
		//$storage = new OAuth2\Storage\Memory(array('user_credentials' => $users));
		$this->server->addGrantType(new OAuth2\GrantType\UserCredentials($this->storage));
		$this->server->handleTokenRequest($this->request,$this->response);
		return $this->response->getResponseBody();
	}

	/**
	* refresh_token, for more see: http://tools.ietf.org/html/rfc6749#page-74
	*/
	public function refresh_token(){
		$this->server->addGrantType(new OAuth2\GrantType\RefreshToken($this->storage, array(
			"always_issue_new_refresh_token" => true,
			"unset_refresh_token_after_use" => true,
			"refresh_token_lifetime" => 2419200,
		)));
		$this->server->handleTokenRequest($this->request)->send();
	}

	/**
	* limit scpoe here
	* @param $scope = "node file userinfo"
	*/
	public function require_scope($scope="",$condition="and")
	{
		$scopes=array_filter(explode(" ",$this->access_token_data['scope']));
		$required_scopes=array_filter(explode(" ",$scope));
		/*if (!$this->server->verifyResourceRequest(OAuth2\Request::createFromGlobals())) {
    		$this->server->getResponse()->send();
    		die;
		}*/
		$this->access_token=$this->access_token_data['access_token'];
		
		
		//$scope_status=$this->server->verifyResourceRequest($this->request, $this->response, $scope);

		if($condition=='and')
		{
			$permitted=1;
			foreach ($required_scopes as $required_scope)
			{
				if(!in_array($required_scope,$scopes))
				{
					$permitted=0;
					break;
				}
			}
		}
		if($condition=='or')
		{
			$permitted=0;
			foreach ($required_scopes as $required_scope)
			{
				if(in_array($required_scope,$scopes))
				{
					$permitted=1;
					break;
				}
			}
		}

		if($permitted==0)
		{
			header("Content-Type:application/json");
            echo json_encode(array('error' => 'invalid_scope', 'error_description' => 'Invalid scope for access token'));
            die;
		}
	}

	public function check_client_id(){
		if (!$this->server->validateAuthorizeRequest($this->request, $this->response)) {
    		$this->response->send();
    		die;
		}
	}

	public function authorize($is_authorized){
		$this->server->addGrantType(new OAuth2\GrantType\AuthorizationCode($this->storage));
		$this->server->handleAuthorizeRequest($this->request, $this->response, $is_authorized);
		if ($is_authorized) {
	  		$code = substr($this->response->getHttpHeader('Location'), strpos($this->response->getHttpHeader('Location'), 'code=')+5, 40);
	  		return $code;
	  	}
		//$this->response->send();
	}

	public function authorization_code(){
		$this->server->addGrantType(new OAuth2\GrantType\AuthorizationCode($this->storage));
		$this->server->handleTokenRequest($this->request)->send();
	}
}