<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Mobile_one_signal
{
	public function __construct()
	{
		$this->CI =& get_instance();
	}

	public function sendToAllUsers($notification_id){
		$status_flag = 1;
		//get notitication data from table
		$this->CI->load->model("mobile/mobileNotifications_model");
		$notificationData = $this->CI->mobileNotifications_model->getNotificationById($notification_id);
		//checking notitication data status
		if(empty($notificationData))
			return $status_flag = 2;
		//getting user devices to send notification which are active & logged in
		$this->CI->load->model("mobile/mobileDevices_model");
		$userDevices = $this->CI->mobileDevices_model->getActiveDevices();
		$player_ids = array_map (function($value){
			return $value['device_id'];
		} , $userDevices);
		if(empty($userDevices))
			return $status_flag = 3;
		$ashram_id = 0;
		$ashram_name = '';
		if(in_array($notificationData->type,array(5,6))){
			if($notificationData->type == 5){
				$this->CI->load->model('ashrams/poojas_model');
				$ashram = $this->CI->poojas_model->poojaData($notificationData->type_id);
				if(!empty($ashram)){
					$ashram_id = $ashram->ashram_id;
					$ashram_name = $ashram->ashram_name;
				}
			}
			if($notificationData->type == 6){
				$this->CI->load->model('ashrams/donations_model');
				$ashram = $this->CI->donations_model->donationData($notificationData->type_id);
				if(!empty($ashram)){
					$ashram_id = $ashram->ashram_id;
					$ashram_name = $ashram->ashram_name;
				}
			}
		}
		//Send notification using cURL via one signal
		$response  = $this->sendNotification($notificationData->title,$notificationData->description,$player_ids,$notificationData,$ashram_id,$ashram_name);
		if(empty($response))
			return $status_flag = 4;
		//Updaing onesignal notitication id & is_sent status 
		$response = json_decode($response);
		if(!isset($response->id)){
			return $status_flag = 4;
		}
		$this->CI->mobileNotifications_model->updateSentStatus($notification_id,$response->id);
		return $status_flag;
	}

	public function sendNotification($title,$description,$userDevices,$notificationData,$ashram_id='',$ashram_name='')
	{
		//Embading title & description description of notitications
		$content = array("en" => $description);
		$heading = array("en" => $title);
		
		//Preparing notitication data
		$fields = array(
			'app_id' => mobile_one_signal_app_id,
			"headings" => $heading,
			'include_player_ids' => $userDevices,
			'data' => array("redirect"=>$notificationData->type,"type_id"=>$notificationData->type_id,"ashram_id"=>$ashram_id,"ashram_name"=>$ashram_name),
			'contents' => $content
		);
	
		$fields = json_encode($fields);
		//cURL operation for onesignal notitication
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, one_signal_api_end_point."notifications");
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
												   'Authorization: Basic '.mobile_one_signal_api_key));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

		$response = curl_exec($ch);
		curl_close($ch);
		return $response;
	}
}
?>