<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class MY_Form_validation extends CI_Form_validation 
{
	protected $CI;
	function __construct() 
	{
		parent::__construct();
		$this->CI =& get_instance();
	}
	public function valid_email_custom($str)
	{
		$this->CI->form_validation->set_message('valid_email_custom', 'Invalid Email ID');
		if(preg_match_all('/^(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){255,})(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){65,}@)(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E]+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F]|(?:\x5C[\x00-\x7F]))*\x22))(?:\.(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E]+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F]|(?:\x5C[\x00-\x7F]))*\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-[a-z0-9]+)*\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-[a-z0-9]+)*)|(?:\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\]))$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function max_length($str, $val)
	{
		if ( ! is_numeric($val))
		{
			return FALSE;
		}
		$str=preg_replace("/\n/",'',$str);
		return ($val >= mb_strlen($str));
	}
	public function valid_emails_custom($str)
	{
		$this->CI->form_validation->set_message('valid_emails_custom', 'Invalid Email ID(s)');
		if (strpos($str, ',') === FALSE)
		{
			return $this->valid_email_custom(trim($str));
		}

		foreach (explode(',', $str) as $email)
		{
			if (trim($email) !== '' && $this->valid_email_custom(trim($email)) === FALSE)
			{
				return FALSE;
			}
		}

		return TRUE;
	}
	public function no_uppercase($str)
	{
		$this->CI->form_validation->set_message('no_uppercase', 'Uppercase letters are not allowed');
		if(preg_match('/[A-Z]/', $str))
		{
		    return FALSE;
		}
		else
		{
		  	return TRUE;
		}
	}
	public function lettersonly($str)
	{
		$this->CI->form_validation->set_message('lettersonly', 'Allowed characters are [a-z],[A-Z] and spaces');
		if(preg_match('/^[a-zA-Z ]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate($str)
	{
		$this->CI->form_validation->set_message('name_validate', "Allowed characters are [a-z],[A-Z],[0-9],[.,-_\"()';] and spaces");
		if(preg_match('/^[a-zA-Z0-9 \.\-\_\,\"\'\(\)\;]+$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate2($str)
	{
		$this->CI->form_validation->set_message('name_validate2', "Allowed characters are [a-z],[A-Z],[0-9],[.,-\"] and spaces");
		if(preg_match('/^[a-zA-Z0-9 \.\-\,\"]+$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate3($str)
	{
		$this->CI->form_validation->set_message('name_validate3', "Allowed characters are [a-z],[A-Z],[0-9],[_-\"] and spaces");
		if(preg_match('/^[a-zA-Z0-9 \-\_\"]+$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate4($str)
	{
		$this->CI->form_validation->set_message('name_validate4', "Allowed characters are [a-z],[A-Z],[0-9],[_-] and spaces");
		if(preg_match('/^[a-zA-Z0-9 \-\_]+$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate5($str)
	{
		$this->CI->form_validation->set_message('name_validate5', "Allowed characters are [a-z],[A-Z],[0-9],[\"] and spaces");
		if(preg_match('/^[a-zA-Z0-9 \"]+$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate6($str)
	{
		$this->CI->form_validation->set_message('name_validate6', "Allowed characters are [a-z],[A-Z],[0-9],[.-_?] and spaces");
		if(preg_match('/^[a-zA-Z0-9 \.\-\_\?]+$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate7($str)
	{
		$this->CI->form_validation->set_message('name_validate7', 'Allowed characters are [a-z],[A-Z],[0-9],[-] and spaces');
		if(preg_match('/^[a-zA-Z0-9 \-]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate8($str)
	{
		$this->CI->form_validation->set_message('name_validate8', 'Allowed characters are [a-z],[A-Z],[0-9],[.,-_\"()] and spaces');
		if(preg_match('/^[a-zA-Z0-9 \.\-\_\,\"\(\)]+$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate9($str)
	{
		$this->CI->form_validation->set_message('name_validate9', 'Allowed characters are [a-z],[A-Z],[,] and spaces');
		if(preg_match('/^[a-zA-Z \,]+$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate10($str)
	{
		$this->CI->form_validation->set_message('name_validate10', 'Allowed characters are [a-z],[A-Z],[0-9] and spaces');
		if(preg_match('/^[a-zA-Z0-9 ]+$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate11($str)
	{
		$this->CI->form_validation->set_message('name_validate11', 'Allowed characters are [a-z],[A-Z],[0-9],[.-_,$&:+*@!()] and spaces');
		if(preg_match('/^[a-zA-Z0-9 \-\_\$\!\@\$\+\(\)\*\&\:\.\,]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate12($str)
	{
		$this->CI->form_validation->set_message('name_validate12', 'Allowed characters are [a-z],[A-Z],[0-9],[.-_] and spaces');
		if(preg_match('/^[a-zA-Z0-9 \-\_\.]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function name_validate13($str)
	{
		$this->CI->form_validation->set_message('name_validate13', 'Allowed characters are [a-z],[A-Z],[0-9],[.-_@/] and spaces');
		if(preg_match('/^[a-zA-Z0-9 \-\_\.\@\/]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function name_validate14($str)
	{
		$this->CI->form_validation->set_message('name_validate14', 'Allowed characters are [a-z],[A-Z],[0-9],[#&.-_@/] and spaces');
		if(preg_match('/^[a-zA-Z0-9 \-\#\&\_\.\@\/]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function alphabetsnumbers($str)
	{
		$this->CI->form_validation->set_message('alphabetsnumbers', 'Alphabets and numbers are only allowed');
		if(preg_match('/^[a-zA-Z0-9]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function alphabetsnumbers2($str)
	{
		$this->CI->form_validation->set_message('alphabetsnumbers2', 'Lower case alphabets and numbers are only allowed');
		if(preg_match('/^[a-z0-9]*$/', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function alphabetsnumberssps($str)
	{
		$this->CI->form_validation->set_message('alphabetsnumberssps', 'Alphabets, numbers and spaces are only allowed');
		if(preg_match('/^[a-zA-Z0-9 ]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function noSpaces($str)
	{
		$this->CI->form_validation->set_message('noSpaces', 'Only spaces not valid');
		if(trim($str)!='')
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function slug($str)
	{
		$this->CI->form_validation->set_message('slug', 'Allowed characters are [a-z],[A-Z],[0-9] and [-]');
		if(preg_match('/^[a-zA-Z0-9\-]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function ContainsAtLeastOneDigit($str)
	{
		$this->CI->form_validation->set_message('ContainsAtLeastOneDigit', 'Please enter at least one number');
		if(preg_match('/[0-9]/', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function ContainsAtLeastOneCapitalLetter($str)
	{
		$this->CI->form_validation->set_message('ContainsAtLeastOneCapitalLetter', 'Please enter at least one capital letter');
		if(preg_match('/[A-Z]/', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function AtLeastOneSpl($str)
	{
		$this->CI->form_validation->set_message('AtLeastOneSpl', 'Please enter at least one special character other than [#] and space');
		if(preg_match('/[^\w\s\#]/', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	
	public function countryCheck($countryCode)
	{
		$this->CI->form_validation->set_message('countryCheck', 'Country does not exist');
		$this->CI->load->model("locations_model");
		$country=$this->CI->locations_model->getCountryByCode($countryCode);
		if(empty($country))
		{
			return false;
		}
		else
		{
			return true;
		}
	}
	public function stateCheck($stateId,$countryCode)
	{
		$this->CI->form_validation->set_message('stateCheck', 'State does not exist');
		$this->CI->load->model("locations_model");
		$state=$this->CI->locations_model->getStateByCode($stateId,$countryCode);
		if(empty($state))
		{
			return false;
		}
		else
		{
			return true;
		}
	}
	
	public function checkSecurityQuestion($str,$groupnum)
	{
		$this->CI->form_validation->set_message('checkSecurityQuestion', 'Invalid Security Question');
		$this->CI->load->model("user/users_model");
        $security_questions=$this->CI->users_model->getSecurityQuestionsGroups();
        $group="group".$groupnum;
        
        $qIds=array();
        foreach ($security_questions[$group] as $ques)
        {
        	$qIds[]=$ques->id;
        }
		if(!in_array($str,$qIds))
		{
			return false;
		}
		else
			return true;
	}
	public function usernameCheck($username)
	{
		$this->CI->form_validation->set_message('usernameCheck', 'User ID already exists');
		$this->CI->load->model('user/users_reserved_model');
		$this->CI->load->library("userutil");


		$restricted=$this->CI->users_reserved_model->check_restricted_reserved($username);
		if($restricted)
		{
			return false;
		}

		$un=$this->CI->userutil->verifyUsername(trim($username),0);
		if($un)
		{
			return false;
		}
		else
		{
			return true;
		}
	}
	public function emailCheck($email,$userId)
	{
		$this->CI->form_validation->set_message('emailCheck', 'Email ID already exists');
		$this->CI->load->library("userutil");
		$flag=$this->CI->userutil->verifyEmail($email,$userId);
		if($flag==1 || $flag==2)
		{
			return false;
		}
		else
		{
			return true;
		}
	}

	public function emailBounceCheck($email)
	{
		$this->CI->form_validation->set_message('emailBounceCheck', 'Email ID already exists');
		$this->CI->load->model("emails_sns_notifications_model");
		$flag=$this->CI->emails_sns_notifications_model->verifyBounceEmail($email);
		if($flag==1)
		{
			return false;
		}
		else
		{
			return true;
		}
	}

	public function genderCheck($gender)
	{
		$this->CI->form_validation->set_message('genderCheck', 'Invalid Gender value');
		if(in_array($gender,array("Male","Female","Other")))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	public function professionCheck($gender)
	{
		$this->CI->form_validation->set_message('professionCheck', 'Invalid Profession value');
		if(in_array($gender,array("Priest/Veda Pandit","Doctor","Lawyer","Social Activist","Bussiness Man","Government Employee","Engineer","Self-employed","Other")))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	public function raasiCheck($gender)
	{
		$this->CI->form_validation->set_message('raasiCheck', 'Invalid Raasi value');
		if(in_array($gender,array("Mesha","Vrishuba","Mithuna","Karkataka","Simha","Kanya","Tula","Vruschika","Dhanur","Makara","Kumbha","Meena")))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	public function starCheck($gender)
	{
		$this->CI->form_validation->set_message('starCheck', 'Invalid Birth Star value');
		if(in_array($gender,array("Ashwini","Bharani","Krittika","Rohini","Mrigasira","Arudra","Punarvasu","Pushyami","Aslesha","Magha",
			"P.Phalguni","U.Phalguni","Hasta","Chitra","Swati","Visakha","Anuradha","Jyestha","Moola","P.Ashadha","U.Ashadha",
			"Shravana","Dhanishta","Satabhistha","P.Bhadra","U.Bhadra","Revati")))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	public function dobCheck($dob)
	{
		$this->CI->form_validation->set_message('dobCheck', 'Invalid DOB value');
		$validDate=strtotime("-15 Years");
		$dobtime=strtotime($dob);
		if($dobtime<=$validDate)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	public function categoryCheck($category,$id)
	{
		$this->CI->form_validation->set_message('categoryCheck', 'Category already exists');
		$this->CI->load->model('categories/categories_model','categories_model');
		$categoryID=$id;
		
		$e=$this->CI->categories_model->categoryCheck($category,$categoryID);
		if($e==1)//does not exist
		{
			return true;
		}
		else if($e==2)
		{
			$this->CI->form_validation->set_message('categoryCheck', 'Invalid Category name');
			return false;
		}
		else//exists
		{
			return false;
		}
	}
	//To check subscription group unique name validation
	public function groupCheck($group,$id)
	{
		$this->CI->form_validation->set_message('groupCheck', 'group already exists');
		$this->CI->load->model('subscriptions/subscription_groups_model','subscription_groups_model');
		$groupID=$id;
		
		$e=$this->CI->subscription_groups_model->groupexistCheck($group,$groupID);
		if($e==1)//does not exist
		{
			return true;
		}
		else if($e==2)
		{
			$this->CI->form_validation->set_message('groupCheck', 'Invalid Group name');
			return false;
		}
		else//exists
		{
			return false;
		}
	}
	//To check general newsletter group unique name validation
	public function generalNewsletterGroupCheck($group,$idAndListid)
	{
		$this->CI->form_validation->set_message('generalNewsletterGroupCheck', 'group already exists');
		$this->CI->load->model('general_newsletters/general_newsletter_groups_model','general_newsletter_groups_model');

		$idAndListid = preg_split('/,/', $idAndListid);
	    $groupID = $idAndListid[0];
	    $listID = $idAndListid[1];
		
		$e=$this->CI->general_newsletter_groups_model->groupexistCheck($group,$groupID,$listID);
		if($e==1)//does not exist
		{
			return true;
		}
		else if($e==2)
		{
			$this->CI->form_validation->set_message('generalNewsletterGroupCheck', 'Invalid Group name');
			return false;
		}
		else//exists
		{
			return false;
		}
	}
	public function categoryParentCheck($parent,$id)
	{
		$this->CI->form_validation->set_message('categoryParentCheck', 'Invalid parent category');
		$this->CI->load->model('categories/categories_model','categories_model');
		$categoryID=$id;
		$e=$this->CI->categories_model->parentCategoryCheck($parent,$categoryID);
		if($e)//valid
		{
			return true;
		}
		else//not valid
		{
			return false;
		}
	}
	
	public function tagsMaxLength($str,$length)
	{
		$maxlength=$length;
		$tags=explode(",",$str);
		$flag=0;
		foreach ($tags as $tag) 
		{
			if(strlen($tag)>$length)
				$flag=1;
		}
		if($flag==0)
		{
			return true;
		}
		else
		{
			$this->CI->form_validation->set_message('tagsMaxLength', 'Please enter tags less than 30 characters each');
			return false;
		}
	}
	
	public function checkYear($str)
	{
		$this->CI->form_validation->set_message('checkYear', "Year cannot be future year");
		if(abs($str)<=date("Y"))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	
	public function calendarDateRangeCheck($date)
	{
		$start=strtotime($this->CI->input->post('start_date'));
		$end=strtotime($this->CI->input->post('end_date'));
		$this->CI->form_validation->set_message('calendarDateRangeCheck', "Invalid Dates");
		if($start<=$end)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	
	function valid_url_format($str)
	{
        $pattern = "/^(http|https|ftp):\/\/[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}(:[0-9]{1,5})?(\/.*)?$/i";
        if (!preg_match($pattern, $str))
        {
            $this->set_message('valid_url_format', 'Invalid URL format');
            return FALSE;
        }
        return TRUE;
    }
    
	
	public function checkCurrency($str)
	{
		$this->CI->form_validation->set_message('checkCurrency', "Invalid Currency");
		$c=$this->CI->general_model->getCurrencies();
		if(in_array($str,array_keys($c)))
			return TRUE;
		else
		{
		  return FALSE;
		}
	}
	
	public function checkTitleSlug($str)
	{
		$slug=url_title($this->CI->general_model->filtertext($str));
		$this->CI->form_validation->set_message('checkTitleSlug', "Invalid Title");
		if(strlen($slug)>=6)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function checkAbsoluteNumber($str)
	{
		$len1=strlen($str);
		$len2=strlen(abs($str));
		$this->CI->form_validation->set_message('checkAbsoluteNumber', "Invalid Numeric value");
		if($len1==$len2)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function eventNameCheck($title,$id)
	{
		$this->CI->form_validation->set_message('eventNameCheck', "Invalid Event Title");
		$this->CI->load->model("content/events_model");
		$slug=url_title($this->CI->general_model->filtertext($title));
		if(strlen($slug)<6)
		{
			return false;
		}
		else
		{
			if(is_numeric($id))
			{
				$flag=$this->CI->events_model->checkEventName($this->CI->general_model->filtertext(trim($title)),$id);
				if($flag==1)
					return false;
				else
					return true;
			}
			else
				return false;
		}
	}

	public function validate_event_parent($parent_id,$event_id)
	{
		if($parent_id==$event_id)
		{
			$this->CI->form_validation->set_message('validate_event_parent', "Parent Event cannot be same as current Event");
			return false;
		}
		$this->CI->form_validation->set_message('validate_event_parent', "Invalid Parent Event");
		$this->CI->load->model("content/events_model");
		$this->CI->load->model('content/events_category_model');
        $this->CI->load->model('content/events_images_model');
        $this->CI->load->model('content/event_attachments_model');
        $this->CI->load->model('category/categories_model');
		$eventData=$this->CI->events_model->eventData($parent_id);
		if(empty($eventData['event']))
		{
			return false;
		}
		return true;
	}

	public function checkVideoAlbumTitle($str,$id)
	{
		$slug=url_title($this->CI->general_model->filtertext($str));
		$this->CI->form_validation->set_message('checkVideoAlbumTitle', "Album Name already exists");
		$this->CI->load->model("content/videos_albums_model");
		if(strlen($slug)>=6)
		{
		    return TRUE;
		}
		else
		{
			if(is_numeric($id))
			{
				$flag=$this->CI->videos_albums_model->checkName($this->CI->general_model->filtertext(trim($title)),$id);
				if($flag==1)
					return false;
				else
					return true;
			}
			else
				return FALSE;
		}
	}

	public function pageNameCheck($title,$id)
	{
		$this->CI->form_validation->set_message('pageNameCheck', "Invalid Page Title");
		$this->CI->load->model("content/pages_model");
		$slug=url_title($this->CI->general_model->filtertext($title));
		if(strlen($slug)<6)
		{
			return false;
		}
		else
		{
			if(is_numeric($id))
			{
				$flag=$this->CI->pages_model->checkPageName($this->CI->general_model->filtertext(trim($title)),$id);
				if($flag==1)
					return false;
				else
					return true;
			}
			else
				return false;
		}
	}

	public function postTypeNameCheck($name,$id)
	{
		$this->CI->form_validation->set_message('postTypeNameCheck', "Invalid Post Type Name");
		$this->CI->load->model("content/dailypost_types_model");
		$slug=url_title($this->CI->general_model->filtertext($name));
		if(strlen($slug)<6)
		{
			return false;
		}
		else
		{
			if(is_numeric($id))
			{
				$flag=$this->CI->dailypost_types_model->checkName($this->CI->general_model->filtertext(trim($name)),$id);
				if($flag==1)
					return false;
				else
					return true;
			}
			else
				return false;
		}
	}

	public function checkPostType($id)
	{
		$this->CI->form_validation->set_message('checkPostType', "Invalid Post Type");
		$this->CI->load->model("content/dailypost_types_model");
		$typeData=$this->CI->dailypost_types_model->typeData($id);
		if(empty($typeData))
			return false;
		else
			return true;
	}

	public function checkReleaseType($type)
	{
		$this->CI->form_validation->set_message('checkReleaseType', "Invalid Type");
		$types=array("MP3 Music Track","PDF Document","Image","Book","MP3 Album","MP3 CD","Audio CD","Video CD","Video DVD","Store Item");
		if(in_array($type,$types))
			return true;
		else
			return false;
	}

	public function checkCountry($countryCode)
	{
		$this->CI->form_validation->set_message('checkCountry', "Invalid Country");
		$this->CI->load->model("locations_model");
		$countryData=$this->CI->locations_model->getCountryByCode($countryCode);
		if(empty($countryData))
			return false;
		else
			return true;
	}

	public function checkTimezone($timezoneString)
	{
		$this->CI->form_validation->set_message('checkTimezone', "Invalid Timezone");
		$zones_array = array();
		$timestamp = time();
		$error=1;
		foreach(timezone_identifiers_list() as $key => $zone)
		{
			if($timezoneString==$zone)
			{
				$error=0;
				break;
			}
		}
		
		return $error;
	}

	public function articleNameCheck($str)
	{
		$slug=url_title($this->CI->general_model->filtertext($str));
		$this->CI->form_validation->set_message('articleNameCheck', "Invalid Article Title");
		if(strlen($slug)>=6)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function speechNameCheck($str)
	{
		$slug=url_title($this->CI->general_model->filtertext($str));
		$this->CI->form_validation->set_message('speechNameCheck', "Invalid Article Title");
		if(strlen($slug)>=6)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function validate_speech_parent($parent_id,$event_id)
	{
		if($parent_id==$event_id)
		{
			$this->CI->form_validation->set_message('validate_speech_parent', "Parent Speech cannot be same as current Speech");
			return false;
		}
		$this->CI->form_validation->set_message('validate_speech_parent', "Invalid Parent Speech");
		$this->CI->load->model('content/speeches_model');
        $this->CI->load->model('content/speeches_images_model');
        $this->CI->load->model('content/speeches_category_model');
        $this->CI->load->model('category/categories_model');
		$speechData=$this->CI->speeches_model->speechData($parent_id);
		if(empty($speechData))
		{
			return false;
		}
		return true;
	}


	public function checkCategories($str)
	{
		$this->CI->form_validation->set_message('checkCategories', "Invalid Category");
		if(isset($this->CI->categories_model->categoriesList['categories'][$str]))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	/*public function checkAshramId($ashram_id)
	{
		$this->CI->form_validation->set_message('checkCategories', "Invalid Category");
		$ashramData = $this->CI->ashrams_model->ashramData($ashram_id);
		if(isset($ashramData))
		{
			return true;
		}
		else
		{
			return false;
		}
	}*/

	public function eventDateRangeCheck($endDate,$startDate)
	{
		$this->CI->form_validation->set_message('eventDateRangeCheck', "Invalid Event Dates");
		$sD=strtotime($startDate);
		$eD=strtotime($endDate);
		if($sD>$eD)
		{
			return false;
		}
		else
			return true;
	}

	public function checkFaqCategory($str)
	{
		$this->CI->form_validation->set_message('checkFaqCategory', "Invalid Category");
		$this->CI->load->model("content/faq_category_model");
		$catData=$this->CI->faq_category_model->catData($str);
		if(!empty($catData))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkFaqCategoryExist($str,$id)
	{
		$this->CI->form_validation->set_message('checkFaqCategoryExist', "Category already exists");
		$this->CI->load->model("content/faq_category_model");
		$exist=$this->CI->faq_category_model->faqcat_exist($id,$str);
		if(!$exist)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkBhajanKey($str)
	{
		$this->CI->form_validation->set_message('checkBhajanKey', "Invalid Key");
		$this->CI->load->model("content/bhajans_model");
		$flag=$this->CI->bhajans_model->checkKey($str);
		return $flag;
	}

	public function checkKb($str)
	{
		$this->CI->form_validation->set_message('checkKb', "Invalid KB");
		$this->CI->load->model("content/knowledgebase_model");
		$kbData=$this->CI->knowledgebase_model->kbData($str);
		if(!empty($kbData))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function usernameCheckAdmin($str)
	{
		$this->CI->form_validation->set_message('usernameCheckAdmin', "User ID already exists");
		$this->CI->load->model("user/users_model");
		$exist=$this->CI->users_model->usernameCheck($str);
		if(!$exist)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function emailCheckAdmin($str,$id)
	{
		$this->CI->form_validation->set_message('emailCheckAdmin', "Email ID already exists");
		$this->CI->load->model("user/users_model");
		$exist=$this->CI->users_model->emailCheck($str,$id);
		if(!$exist)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function checkUserRoles($str)
	{
		$this->CI->form_validation->set_message('checkUserRoles', "Invalid Role value");
		$this->CI->load->model("user/users_model");
		$roles=$this->CI->users_model->getRoles();
		$tempArray=[];
		foreach ($roles as $value)
		{
			$tempArray[]=$value->id;
		}
		$flag=1;
		foreach ($_POST['roles'] as $v)
		{
			if(!in_array($v,$tempArray))
			{
			    $flag=0;
			    break;
			}
		}
		if($flag==1)
			return TRUE;
		else
		{
		  return FALSE;
		}
	}
	public function checkUserRole($str)
	{
		$this->CI->form_validation->set_message('checkUserRole', "Invalid Role");
		$this->CI->load->model("user/users_model");
		$roles=$this->CI->users_model->getRoles();
		$tempArray=[];
		foreach ($roles as $value)
		{
			$tempArray[]=$value->id;
		}
		$flag=1;
		
		if(!in_array($str,$tempArray))
		{
		    $flag=0;
		}
		if($flag==1)
			return TRUE;
		else
		{
		  return FALSE;
		}
	}
	public function checkReservedUserId($str)
	{
		$this->CI->form_validation->set_message('checkReservedUserId', "User ID invalid");
		$userids=array_filter(explode(",",$str));
		$cnt=0;
		$ok=1;
		foreach ($userids as $userid)
		{
			if(strlen($userid)<6 || strlen($userid)>60)
			{
				$ok=0;
				break;
			}
			$cnt++;
		}
		if(!$ok || $cnt>500)
			return FALSE;
		else
		{
		  return TRUE;
		}
	}
	public function checkRestrictedUserId($str)
	{
		$this->CI->form_validation->set_message('checkReservedUserId', "User ID invalid");
		$userids=array_filter(explode(",",$str));
		$cnt=0;
		$ok=1;
		foreach ($userids as $userid)
		{
			if(strlen($userid)<3 || strlen($userid)>60)
			{
				$ok=0;
				break;
			}
			$cnt++;
		}
		if(!$ok || $cnt>500)
			return FALSE;
		else
		{
		  return TRUE;
		}
	}
	public function checkFeedbackPurpose($str)
	{
		$this->CI->form_validation->set_message('checkFeedbackPurpose', "Invalid purpose value");
		
		if(!in_array($str,array(1,2,3,4,5,6,7)))
			return FALSE;
		else
		{
		  return TRUE;
		}
	}
	public function validTimezone($str)
	{
		$this->CI->form_validation->set_message('validTimezone', "Invalid Timezone");
		$regions = array(
					'Africa' => DateTimeZone::AFRICA,
					'America' => DateTimeZone::AMERICA,
					'Antarctica' => DateTimeZone::ANTARCTICA,
					'Aisa' => DateTimeZone::ASIA,
					'Atlantic' => DateTimeZone::ATLANTIC,
					'Europe' => DateTimeZone::EUROPE,
					'Indian' => DateTimeZone::INDIAN,
					'Pacific' => DateTimeZone::PACIFIC
					);

		$timestamp = time();
		foreach(timezone_identifiers_list() as $key => $zone)
		{
			date_default_timezone_set($zone);
			$zones_array1['zone'][$key] = $zone;
			$zones_array1['diff_from_GMT'][$key] = 'UTC/GMT ' . date('P', $timestamp);
		}
		asort($zones_array1['diff_from_GMT']);

		if(!in_array($str,$zones_array1['zone']))
			return FALSE;
		else
		{
		  return TRUE;
		}
	}
	public function reminderDate($str)
	{
		$this->CI->form_validation->set_message('reminderDate', "Invalid Date");
		$valid=strtotime("-1 Day",time());
		$valid=date("d M Y 00:00:00",$valid);
		if(strtotime($valid)>strtotime($str))
			return FALSE;
		else
		{
		  return TRUE;
		}
	}
	public function remindBeforeValue($str)
	{
		$this->CI->form_validation->set_message('remindBeforeValue', "Invalid value");
		
		if(0<=abs($str) && abs($str)<=59)
			return TRUE;
		else
		{
		  return FALSE;
		}
	}

	public function checkCurrencyValues($value,$currency)
	{
		$this->CI->form_validation->set_message('checkCurrencyValues', "Invalid value");
		$currencyData=array();
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($currency==strtolower($cData['currency']))
				$currencyData=$cData;
		}
		
		if(!empty($currencyData))
		{
			if($value>=$currencyData['min'] && $value<=$currencyData['max'])
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else
			return false;
	}

	public function checkCurrencyValuesByAshram($value,$currencystring='')
	{
		$currencyashram = explode(' || ', $currencystring);
		$currency = '';
		$ashramid = '';
		if(isset($currencyashram[0]))
		{
			$currency = $currencyashram[0];
		}
		if(isset($currencyashram[1]))
		{
			$ashramid = $currencyashram[1];
		}
		if($ashramid == '')
		{
			return false;
		}
		else
		{
			$this->CI->load->model('currencies_model');
			$ashramCurrencies=$this->CI->currencies_model->getByAshram($ashramid);
			$this->CI->form_validation->set_message('checkCurrencyValuesByAshram', "Invalid value");
			$currencyData=array();
			foreach ($ashramCurrencies as $thiscurrency)
			{
				if($currency==strtolower($thiscurrency['currency']))
					$currencyData=$thiscurrency;
			}
			
			if(!empty($currencyData))
			{
				if($value>=$currencyData['min'] && $value<=$currencyData['max'])
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			else
			{
				return false;
			}
		}
	}

	public function checkOneTimeChargeValues($value,$currency)
	{
		$this->CI->form_validation->set_message('checkOneTimeChargeValues', "Invalid value");
		$currencyData=array();
		foreach ($GLOBALS['currencies'] as $cData)
		{
			if($currency==strtolower($cData['currency']))
				$currencyData=$cData;
		}
		
		if(!empty($currencyData))
		{
			if($value<=$currencyData['max'])
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else
			return false;
	}

	public function valid_date($str)
	{
		$this->CI->form_validation->set_message('valid_date', "Invalid Date format");
		$valid=($this->CI->general_model->valid_date($str) || $this->CI->general_model->valid_date2($str));
		return $valid;
	}

	public function valid_ymd_date($str)
	{
		$this->CI->form_validation->set_message('valid_ymd_date', "Invalid Date format");
		$valid=$this->CI->general_model->valid_date3($str);
		return $valid;
	}

	public function valid_time($str)
	{
		$this->CI->form_validation->set_message('valid_time', "Invalid Time format");
		$valid=$this->CI->general_model->valid_time($str);
		return $valid;
	}

	public function checkPoojaVisibleDates($str)
	{
		$this->CI->form_validation->set_message('checkPoojaVisibleDates', "Visible To date cannot be before Visible From date");
		if(strtotime($_POST['visible_from'])>strtotime($_POST['visible_to']))
		{
			return false;
		}
		else
			return true;
	}
	public function checkPoojaDates($str)
	{
		$this->CI->form_validation->set_message('checkPoojaDates', "End date cannot be before Start date");
		if(strtotime($_POST['start_date'])>strtotime($_POST['end_date']))
		{
			return false;
		}
		else
			return true;
	}
	public function checkPoojaStartDate($str)
	{
		$this->CI->form_validation->set_message('checkPoojaStartDate', "Start date cannot be before Visible From date");
		if(strtotime($_POST['visible_from'])>strtotime($_POST['start_date']))
		{
			return false;
		}
		else
			return true;
	}
	public function checkPoojaEndDate($str)
	{
		$this->CI->form_validation->set_message('checkPoojaEndDate', "Visible To date cannot be before End date");
		if(strtotime($_POST['end_date'])>strtotime($_POST['visible_to']))
		{
			return false;
		}
		else
			return true;
	}
	public function checkPoojaIncludedDays($str)
	{
		$this->CI->form_validation->set_message('checkPoojaIncludedDays', "Invalid Day");
		$daysArray=array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday");
		if($str=='')
			return true;
		if(!in_array($str,$daysArray))
		{
			return false;
		}
		else
			return true;
	}
	
	public function checkStandardReplyCategory($str)
	{
		$this->CI->form_validation->set_message('checkStandardReplyCategory', "Invalid Category");
		$this->CI->load->model("techsupport/techsupport_standard_replies_category_model");
		$catData=$this->CI->techsupport_standard_replies_category_model->catData($str);
		if(!empty($catData))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function checkStandardReplyCategoryExist($str,$id)
	{
		$this->CI->form_validation->set_message('checkStandardReplyCategoryExist', "Category already exists");
		$this->CI->load->model("techsupport/techsupport_standard_replies_category_model");
		$exist=$this->CI->techsupport_standard_replies_category_model->standardreplycat_exist($id,$str);
		if(!$exist)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function checkTechsupportPurpose($str)
	{
		$this->CI->form_validation->set_message('checkTechsupportPurpose', "Invalid purpose value");
		
		if(!in_array($str,array(1,2,3,4,5,6,7)))
			return FALSE;
		else
		{
		  return TRUE;
		}
	}

	public function checkPoojaTimes($str)
	{
		$this->CI->form_validation->set_message('checkPoojaTimes', "Time From cannot be before Time To");
		if(strtotime($_POST['time_from'])>strtotime($_POST['time_to']))
		{
			return false;
		}
		else
			return true;
	}
	public function checkPoojaExcludedDates($str)
	{
		$this->CI->form_validation->set_message('checkPoojaExcludedDates', "Invalid Excluded Dates");
		$validDates=$this->validPoojaDateSet();
		$exDates=array_filter(explode(",",$str));
		$error=0;
		foreach ($exDates as $exDate)
		{
			$valid=$this->CI->general_model->valid_date($exDate);
			if($valid==false)
			{
				return false;
			}
			if(!in_array($exDate,$validDates))
			{
				return false;
			}
		}
		return true;
	}
	public function checkPoojaIncludedDates($str)
	{
		$this->CI->form_validation->set_message('checkPoojaIncludedDates', "Invalid Included Dates");
		$validDates=$this->validPoojaDateSet();
		$inDates=array_filter(explode(",",$str));
		$error=0;
		foreach ($inDates as $inDate)
		{
			$valid=$this->CI->general_model->valid_date($inDate);
			if($valid==false)
			{
				return false;
			}
			if(!in_array($inDate,$validDates))
			{
				return false;
			}
		}
		return true;
	}
	public function checkExternalLinkFlag($str)
	{
		$this->CI->form_validation->set_message('checkExternalLinkFlag', "Invalid value for external link selection");
		if(!in_array($str,array(0,1)))
		{
			return false;
		}
		else
			return true;
	}
	public function checkPriceFixedFlag($str)
	{
		$this->CI->form_validation->set_message('checkPriceFixedFlag', "Invalid value for price fixed selection");
		if(!in_array($str,array(0,1)))
		{
			return false;
		}
		else
			return true;
	}
	private function validPoojaDateSet()
	{
		if(isset($_POST['days']))
			$weekdays=$_POST['days'];
		else
			$weekdays=array();
		$start=strtotime($_POST['start_date']);
		$end=strtotime($_POST['end_date']);
		$temp=$start;
		$result=array();

		while($temp<=$end)
		{
			if(!empty($weekdays))
			{
				if(in_array(date("l",$temp),$weekdays))
				$result[]=date("d M Y",$temp);
			}
			else
			{
				$result[]=date("d M Y",$temp);
			}
			
			$temp=strtotime("+1 Day",$temp);
		}
		return $result;
	}
	public function checkPoojaCloseBefore($str)
	{
		$this->CI->form_validation->set_message('checkPoojaCloseBefore', "Invalid value");
		if($str>=0 && $str<=59)
		{
			return true;
		}
		else
			return false;
	}

	public function checkPoojaCutoffType($str)
	{
		$this->CI->form_validation->set_message('checkPoojaCutoffType', "Invalid Cutoff Type");
		if(in_array($str, ['CloseAfterStartTime','CloseAfterEndTime','CloseBeforeStartTime','CloseBeforeEndTime']))
		{
			return true;
		}
		else
			return false;
	}

	public function checkPoojaCutoffHour($str)
	{
		$this->CI->form_validation->set_message('checkPoojaCutoffHour', "Invalid Cutoff Hour");
		if($str>=0 && $str<=23)
		{
			return true;
		}
		else
			return false;
	}

	public function checkPoojaCutoffMinutes($str)
	{
		$this->CI->form_validation->set_message('checkPoojaCutoffMinutes', "Invalid Cutoff Minutes");
		if($str>=0 && $str<=59)
		{
			return true;
		}
		else
			return false;
	}

	public function checkPoojaName($name,$id)
	{
		$this->CI->form_validation->set_message('checkPoojaName', "Pooja Name already exists");
		$this->CI->load->model("ashrams/poojas_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->poojas_model->checkPoojaName($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkPoojaCategory($catid)
	{
		$this->CI->form_validation->set_message('checkPoojaCategory', "Invalid category");
		$this->CI->load->model("ashrams/poojas_categories_model");
		$categoryData=$this->CI->poojas_categories_model->categoryData($catid);
		if(!empty($categoryData))
		{
			return true;
		}
		else
			return false;
	}
	public function checkDonationCategory($catid)
	{
		$this->CI->form_validation->set_message('checkDonationCategory', "Invalid category");
		$this->CI->load->model("ashrams/donations_categories_model");
		$categoryData=$this->CI->donations_categories_model->categoryData($catid);
		if(!empty($categoryData))
		{
			return true;
		}
		else
			return false;
	}
	public function checkDonationGroup($groupid)
	{
		$this->CI->form_validation->set_message('checkDonationGroup', "Invalid group");
		$this->CI->load->model("ashrams/donations_groups_model");
		$groupData=$this->CI->donations_groups_model->groupData($groupid);
		if(!empty($groupData))
		{
			return true;
		}
		else
			return false;
	}
	public function checkSubscriptionCategory($catid)
	{
		$this->CI->form_validation->set_message('checkSubscriptionCategory', "Invalid category");
		$this->CI->load->model("ashrams/subscriptions_categories_model");
		$categoryData=$this->CI->subscriptions_categories_model->categoryData($catid);
		if(!empty($categoryData))
		{
			return true;
		}
		else
			return false;
	}
	public function checkStoreCategory($catid)
	{
		$this->CI->form_validation->set_message('checkStoreCategory', "Invalid category");
		$this->CI->load->model("ashrams/store_categories_model");
		$categoryData=$this->CI->store_categories_model->categoryData($catid);
		if(!empty($categoryData))
		{
			return true;
		}
		else
			return false;
	}

	public function checkDonationName($name,$id)
	{
		$this->CI->form_validation->set_message('checkDonationName', "Donation Name already exists");
		$this->CI->load->model("ashrams/donations_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->donations_model->checkDonationName($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkDonations($ids,$id)
	{
		$this->CI->form_validation->set_message('checkDonations', "Invalid value");
		$this->CI->load->model("ashrams/donations_model");
		$ids=array_filter(explode(",",$ids));
		foreach ($ids as $did)
		{
			$donationData=$this->CI->donations_model->donationData($did);
			if(empty($donationData) || $did==$id)
			{
				return false;
			}
		}
		return true;
	}

	public function checkSubscriptionName($name,$id)
	{
		$this->CI->form_validation->set_message('checkSubscriptionName', "Subscription Name already exists");
		$this->CI->load->model("ashrams/subscriptions_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->subscriptions_model->checkSubscriptionName($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkSubscriptions($ids,$id)
	{
		$this->CI->form_validation->set_message('checkSubscriptions', "Invalid value");
		$this->CI->load->model("ashrams/subscriptions_model");
		$ids=array_filter(explode(",",$ids));
		foreach ($ids as $did)
		{
			$subscriptionData=$this->CI->subscriptions_model->subscriptionData($did);
			if(empty($subscriptionData) || $did==$id)
			{
				return false;
			}
		}
		return true;
	}

	public function checkItemName($name,$id)
	{
		$this->CI->form_validation->set_message('checkItemName', "Item Name already exists");
		$this->CI->load->model("ashrams/store_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->store_model->checkItemName($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}
	public function checkItemType($type)
	{
		$this->CI->form_validation->set_message('checkItemType', "Invalid Type");
		if(in_array($type,array(1,2,3,4,5,6,7,8,9,10)))
		{
			return true;
		}
		else
			return false;
	}

	public function checkItemShipping($val)
	{
		$this->CI->form_validation->set_message('checkItemShipping', "Invalid value");
		if(in_array($val, array(0,1)))
		{
			return true;
		}
		else
			return false;
	}

	public function checkPublicDisplay($val)
	{
		$this->CI->form_validation->set_message('checkPublicDisplay', "Invalid value");
		if(in_array($val, array(0,1)))
		{
			return true;
		}
		else
			return false;
	}

	public function checkShowAliasNameAsAshramNameInOrders($val)
	{
		$this->CI->form_validation->set_message('checkShowAliasNameAsAshramNameInOrders', "Invalid value");
		if(in_array($val, array(0,1)))
		{
			return true;
		}
		else
			return false;
	}

	public function checkPersonalNote($val)
	{
		$this->CI->form_validation->set_message('checkPersonalNote', "Invalid value");
		if(in_array($val, array(0,1)))
		{
			return true;
		}
		else
			return false;
	}

	public function checkPitruPakshaPooja($val)
	{
		$this->CI->form_validation->set_message('checkPitruPakshaPooja', "Invalid value");
		if(in_array($val, array(0,1)))
		{
			return true;
		}
		else
			return false;
	}

	public function checkPoornaphalaSeva($val)
	{
		$this->CI->form_validation->set_message('checkPoornaphalaSeva', "Invalid value");
		if(in_array($val, array(0,1)))
		{
			return true;
		}
		else
			return false;
	}

	public function checkMaxFamilyMembers($val)
	{
		$this->CI->form_validation->set_message('checkMaxFamilyMembers', "Invalid value");
		if(in_array($val, array('All family members','1','2','3','4','5','6','7','8','9','10')))
		{
			return true;
		}
		else
			return false;
	}

	public function checkMantraDates($str)
	{
		$this->CI->form_validation->set_message('checkMantraDates', "End date cannot be before Start date");
		if($this->CI->input->post("start_date")!='' && $this->CI->input->post("end_date")!='' )
		{
			if(strtotime($_POST['start_date'])>strtotime($_POST['end_date']))
			{
				return false;
			}
		}
		return true;
	}

	public function check_poojas_category($category,$id)
	{
		$this->CI->form_validation->set_message('check_poojas_category', "Category already exists");
		$this->CI->load->model("ashrams/poojas_categories_model");
		if(is_numeric($id))
		{
			$error=$this->CI->poojas_categories_model->checkName(trim($category),$id);
			if($error==0)
				return true;
		}
		return false;
	}

	public function check_downloads_category($category,$id)
	{
		$this->CI->form_validation->set_message('check_downloads_category', "Category already exists");
		$this->CI->load->model("content/downloads_categories_model");
		if(is_numeric($id))
		{
			$error=$this->CI->downloads_categories_model->checkName(trim($category),$id);
			if($error==0)
				return true;
		}
		return false;
	}

	public function check_donations_category($category,$id)
	{
		$this->CI->form_validation->set_message('check_donations_category', "Category already exists");
		$this->CI->load->model("ashrams/donations_categories_model");
		if(is_numeric($id))
		{
			$error=$this->CI->donations_categories_model->checkName(trim($category),$id);
			if($error==0)
				return true;
		}
		return false;
	}

	public function check_donations_group($group,$id)
	{
		$this->CI->form_validation->set_message('check_donations_group', "Group already exists");
		$this->CI->load->model("ashrams/donations_groups_model");
		if(is_numeric($id))
		{
			$error=$this->CI->donations_groups_model->checkName(trim($group),$id);
			if($error==0)
				return true;
		}
		return false;
	}

	public function check_subscriptions_category($category,$id)
	{
		$this->CI->form_validation->set_message('check_subscriptions_category', "Category already exists");
		$this->CI->load->model("ashrams/subscriptions_categories_model");
		if(is_numeric($id))
		{
			$error=$this->CI->subscriptions_categories_model->checkName(trim($category),$id);
			if($error==0)
				return true;
		}
		return false;
	}

	public function check_store_category($category,$id)
	{
		$this->CI->form_validation->set_message('check_store_category', "Category already exists");
		$this->CI->load->model("ashrams/store_categories_model");
		if(is_numeric($id))
		{
			$error=$this->CI->store_categories_model->checkName(trim($category),$id);
			if($error==0)
				return true;
		}
		return false;
	}

	public function check_store_type($type,$id)
	{
		$this->CI->form_validation->set_message('check_store_type', "Type already exists");
		$this->CI->load->model("ashrams/store_types_model");
		if(is_numeric($id))
		{
			$error=$this->CI->store_types_model->checkName(trim($type),$id);
			if($error==0)
				return true;
		}
		return false;
	}

	public function validateAdminRoles()
	{
		$this->CI->form_validation->set_message('roles', "Role Is Not Valid");
		$this->CI->load->model("user_model");
		if(is_numeric($_POST['roles']))
		{
			$checksuccess=$this->CI->user_model->getRole($_POST['roles']);
			if($checksuccess)
				return true;
		}
		return false;
	}

	public function validateAshrams($category,$id)
	{
		$this->CI->form_validation->set_message('ashram_id', "Ashram Is Invalid");
		$this->CI->load->model("ashrams/ashrams_model");
		if(is_numeric($_POST['ashram_id']))
		{
			$checksuccess=$this->CI->ashrams_model->ashramData($_POST['ashram_id']);
			if(!empty($checksuccess))
				return true;
		}
		return false;
	}

	public function validateSatsangs($category,$id)
	{
		$this->CI->form_validation->set_message('satsang_id', "Satsang Is Invalid");
		$this->CI->load->model("satsangs/satsangs_model");
		if(is_numeric($_POST['satsang_id']))
		{
			$checksuccess=$this->CI->satsangs_model->satsangData($_POST['satsang_id']);
			if(!empty($checksuccess))
				return true;
		}
		return false;
	}

	public function checkAdminUserType($status)
	{
		$this->CI->form_validation->set_message('admin_user_check', "Invalid Value");
		if(in_array($status,array(1,2,3)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function valid_gender($str)
	{
		$this->CI->form_validation->set_message('valid_gender', "Invalid Gender");
		if(!in_array($str,array("Male","Female","Other")))
		{
			return false;
		}
		else
			return true;
	}
	public function validDob($str)
	{
		$this->CI->form_validation->set_message('validDob', "Must be 15 years old");
		$validDate=strtotime("-15 Years");
		if(strtotime($str)>$validDate)
		{
			return false;
		}
		else
			return true;
	}
	public function checkLanguage($str)
	{
		$this->CI->form_validation->set_message('checkLanguage', 'Invalid language');
		$languages=$this->CI->general_model->getLanguages();
		$langArray=array();
		foreach ($languages as $lang)
		{
			$langArray[]=$lang->lang_id;
		}
		if(in_array($str,$langArray))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function checkAgeLimit($str)
	{
		$this->CI->form_validation->set_message('checkAgeLimit', "Invalid age");
		if($str>60 || $str<18)
		{
			return false;
		}
		else
			return true;
	}
	public function newsletterAgeFilter($str)
	{
		$this->CI->form_validation->set_message('newsletterAgeFilter', "Invalid ages");
		if($_POST['age_from']!='' && $_POST['age_to']=='')
		{
			return false;
		}
		if($_POST['age_from']=='' && $_POST['age_to']!='')
		{
			return false;
		}
		if($_POST['age_from']>$_POST['age_to'])
		{
			return false;
		}
		return true;
	}
	public function newsletterType($str)
	{
		$this->CI->form_validation->set_message('newsletterType', "Invalid type");
		if(!in_array($str,array(1,2,3)))
			return false;
		return true;
	}
	public function checkAshramName($name,$id)
	{
		$this->CI->form_validation->set_message('checkAshramName', "Ashram Name already exists");
		$this->CI->load->model("ashrams/ashrams_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->ashrams_model->checkName($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}
	public function checkSatsangName($name,$id)
	{
		$this->CI->form_validation->set_message('checkSatsangName', "Ashram Name already exists");
		$this->CI->load->model("satsangs/satsangs_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->satsangs_model->checkName($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkAshramcenterName($name,$id)
	{
		$this->CI->form_validation->set_message('checkAshramcenterName', "Ashram Center Name already exists");
		$this->CI->load->model("content/ashramcenters_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->ashramcenters_model->checkName($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkVideoType($videoId)
	{
		$this->CI->form_validation->set_message('checkVideoType', "Invalid Video Type");
		
		if(is_numeric($videoId) && in_array($videoId,array(1,2)))
		{
			return true;
		}
		else
			return false;
	}
	public function contactPurpose($str)
	{
		$this->CI->form_validation->set_message('contactPurpose', "Invalid Purpose");
		
		if(in_array($str,array('Personal Request','Complaint','Other','Abuse')))
		{
			return true;
		}
		else
			return false;
	}

	public function checkoutCountry($str, $currency)
	{
		$this->CI->form_validation->set_message('checkoutCountry', "Invalid Country");
		if($currency=='inr')
		{
			if($str!='IN')
			{
				return false;
			}
		}
		if($currency!='inr')
		{
			if($str=='IN')
			{
				return false;
			}
			else
			{
				$this->CI->load->model("locations_model");
				$country=$this->CI->locations_model->getCountryByCode($str);
				if(empty($country))
				{
					return false;
				}
				else
				{
					return true;
				}
			}
		}
		return true;
	}

	public function cardExpiry($str)
	{
		$this->CI->form_validation->set_message('cardExpiry', "Invalid expiry date");
		
		if(preg_match('/^\d{1,2}\/\d{2}$/',$str))
		{
			return true;
		}
		else
			return false;
	}
	public function liveupdate_type_check($str)
	{
		$this->CI->form_validation->set_message('liveupdate_type_check', "Invalid type");
		
		if(in_array($str,array(1,2,3,4)))
		{
			return true;
		}
		else
			return false;
	}

	public function pledgePurpose($id,$public=0)
	{
		$this->CI->form_validation->set_message('pledgePurpose', "Invalid Purpose");
		$this->CI->load->model("pledge/pledge_categories_model");
		$catData=$this->CI->pledge_categories_model->catData($id);

		if(!empty($catData))
		{
			if($public==1)
			{
				if($catData->status==1)
					return true;
				else return false;
			}
			else
				return true;
		}
		else
			return false;
	}

	public function currencyCheck($currency)
	{
		$this->CI->form_validation->set_message('currencyCheck', "Invalid Currency");
		$this->CI->load->model("currencies_model");
		$currencies=$this->CI->currencies_model->getByAshram(0);
		if(isset($currencies[$currency]))
		{
			return true;
		}
		else
			return false;
	}
	public function pledgeCheckPaymentMode($str)
	{
		$this->CI->form_validation->set_message('pledgeCheckPaymentMode', "Invalid value");
		
		if(in_array($str,array(1,2,3)))
		{
			return true;
		}
		else
			return false;
	}

	public function checkPledgeCategoryExist($str,$id)
	{
		$this->CI->form_validation->set_message('checkPledgeCategoryExist', "Category already exists");
		$this->CI->load->model("pledge/pledge_categories_model");
		$exist=$this->CI->pledge_categories_model->cat_exist($id,$str);
		if(!$exist)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function pledgeExist($id)
	{
		$this->CI->form_validation->set_message('pledgeExist', "Invalid request");
		$this->CI->load->model("pledge/pledge_model");
		$pledgeData=$this->CI->pledge_model->pledgeData($id);
		if(!empty($pledgeData))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkRegistrationCategoryExist($str,$id)
	{
		$this->CI->form_validation->set_message('checkRegistrationCategoryExist', "Category already exists");
		$this->CI->load->model("registrations/register_categories_model");
		$exist=$this->CI->register_categories_model->cat_exist($id,$str);
		if(!$exist)
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function registrationExist($id)
	{
		$this->CI->form_validation->set_message('registrationExist', "Invalid request");
		$this->CI->load->model("registrations/register_model");
		$registerData=$this->CI->register_model->registerData($id);
		if(!empty($registerData))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function registrationPurpose($id,$public=0)
	{
		$this->CI->form_validation->set_message('registrationPurpose', "Invalid Purpose");
		$this->CI->load->model("registrations/register_categories_model");
		$catData=$this->CI->register_categories_model->catData($id);
		if(!empty($catData))
		{
			if($public==1)
			{
				if($catData->status==1)
					return true;
				else return false;	
			}
			else
				return true;
		}
		else
			return false;
	}

	public function checkAdminPaymentMode($mode)
	{
		$this->CI->form_validation->set_message('checkAdminPaymentMode', "Invalid payment mode");
		if(in_array($mode,array("default","cash")))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkPaymentStatus($status)
	{
		$this->CI->form_validation->set_message('checkPaymentStatus', "Invalid payment status");
		if(in_array($status,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function checkCashModes($mode)
	{
		$this->CI->form_validation->set_message('checkCashModes', "Invalid payment mode");
		if(in_array($mode,array("cash","cheque","dd","mo","cc","dc","online","cashiers_check","neft")))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function checkTransactionStatus($status,$mode='')
	{
		$this->CI->form_validation->set_message('checkTransactionStatus', "Invalid status");
		if($mode=='')
		{
			if(in_array($status,array('paid','bounced','inprocess','refund')))
			{
			    return TRUE;
			}
		}
		else
		{
			if($mode=='cheque')
			{
				if(in_array($status,array('paid','bounced','inprocess','refund')))
				{
				    return TRUE;
				}
			}
			else
			{
				if($status=='paid' || $status=='refund')
				{
					return true;
				}
			}
		}

		return FALSE;
	}

	public function checkTransactionExist($id,$order_id)
	{
		$this->CI->form_validation->set_message('checkTransactionExist', "Invalid transaction");
		$this->CI->load->model("orders/transaction_model");
		$txData=$this->CI->transaction_model->getTransactionByID($id);
		if(!empty($txData))
		{
			if($this->CI->input->post("tx_status")!='')
			{
				if($this->CI->input->post("tx_status")==$txData->status)
					return false;
			}
			if($order_id!=$txData->order_id)
			{
				return false;
			}
			else
				return true;
		}
		else
			return false;
	}
	public function checkPartialPaymentOption($value)
	{
		$this->CI->form_validation->set_message('checkPartialPaymentOption', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkSubscriptionPeriods($value)
	{
		$this->CI->form_validation->set_message('checkSubscriptionPeriods', "Invalid value");
		if(current_env=='dev')
			$periodArray=array('days','weeks','months','years');
		else
			$periodArray=array('weeks','months','years');
		if(in_array($value,$periodArray))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkSubscriptionsubscriptionPaymentType($value)
	{
		$this->CI->form_validation->set_message('checkSubscriptionsubscriptionPaymentType', "Invalid value");
		$periodArray=array('Both','Pay till Cancelled','Select total payments');
		if(in_array($value,$periodArray))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkSubscriptionFrequency($value,$period)
	{
		$this->CI->form_validation->set_message('checkSubscriptionFrequency', "Invalid value");
		if(empty($period))
			return false;

		if(current_env=='dev')
		{
			if($period=='days')
			{
				if($value>=1 && $value<=30)
				{
				    return TRUE;
				}
				else
				{
				  return FALSE;
				}
			}
		}
		if($period=='weeks')
		{
			if($value>=1 && $value<=52)
			{
			    return TRUE;
			}
			else
			{
			  return FALSE;
			}
		}
		else if($period=='months')
		{
			if($value>=1 && $value<=12)
			{
			    return TRUE;
			}
			else
			{
			  return FALSE;
			}
		}
		else if($period=='years')
		{
			if($value>=1 && $value<=5)
			{
			    return TRUE;
			}
			else
			{
			  return FALSE;
			}
		}
		else
		{
			return false;
		}
	}
	public function checkSubscriptionNumPayments($num)
	{
		
		$this->CI->form_validation->set_message('checkSubscriptionNumPayments', "Invalid value");
		if(current_env=='dev')
		{
			if($this->CI->input->post("period")=='days')
			{
				$frequency_val 		= $this->CI->input->post("frequency");
		    	$no_payments_value 	= 365 / $frequency_val;
		    	$no_payments_value 	= intval($no_payments_value);

				if($num>=1 && $no_payments_value >=$num)
				{
					return true;
				}
			}
		}
		if($this->CI->input->post("period")=='weeks')
		{
			$frequency_val 		= $this->CI->input->post("frequency");
	    	$no_payments_value 	= 260 / $frequency_val;
	    	$no_payments_value 	= intval($no_payments_value);

			if($num>=1 && $no_payments_value >=$num)
			{
				return true;
			}
		}
		if($this->CI->input->post("period")=='months')
		{
			$frequency_val 		= $this->CI->input->post("frequency");
	    	$no_payments_value 	= 60 / $frequency_val;
	    	$no_payments_value 	= intval($no_payments_value);

			if($num>=1 && $no_payments_value >=$num)
			{
				return true;
			}
		}
		if($this->CI->input->post("period")=='years')
		{
			$frequency_val 		= $this->CI->input->post("frequency");
	    	$no_payments_value 	= 5 / $frequency_val;
	    	$no_payments_value 	= intval($no_payments_value);

			if($num>=1 && $no_payments_value >=$num)
			{
				return true;
			}
		}
		return false;
	}
	public function checkSubscriptionExpirationType($num)
	{
		$this->CI->form_validation->set_message('checkSubscriptionExpirationType', "Invalid value");
		if($num== '' || $num==1 || $num==2)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	public function dayCheck($num)
	{
		$this->CI->form_validation->set_message('dayCheck', "Invalid value");
		if($num>=1 && $num<=31)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	public function monthCheck($num)
	{
		$this->CI->form_validation->set_message('monthCheck', "Invalid value");
		if($num>=1 && $num<=12)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	public function valid_foreign_currency($foreign_currency,$order_currency)
	{
		$this->CI->form_validation->set_message('valid_foreign_currency', "Invalid currency");
		if(strtolower($foreign_currency)==strtolower($order_currency))
		{
			return false;
		}
		$this->CI->load->model("foreign_currencies_model");
		$currencyData=$this->CI->foreign_currencies_model->getByCurrency(strtolower($foreign_currency));
		if(!empty($currencyData))
		{
			return true;
		}
		else
			return false;
	}
	public function check_boolean($value)
	{
		$this->CI->form_validation->set_message('check_boolean', "Invalid value");
		if($value==0 || $value==1)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	public function checkClearCartBeforeDate($str)
	{
		$this->CI->form_validation->set_message('checkClearCartBeforeDate', "Please select valid date");
		if(strtotime($_POST['date_before'])>strtotime(date('Y-m-d')))
		{
			return false;
		}
		else
			return true;
	}

	public function checkDonationIncludedDays($str)
	{
		$this->CI->form_validation->set_message('checkDonationIncludedDays', "Invalid Day");
		$daysArray=array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday");
		if($str=='')
			return true;
		if(!in_array($str,$daysArray))
		{
			return false;
		}
		else
			return true;
	}

	public function checkDonationExcludedDates($str)
	{
		$this->CI->form_validation->set_message('checkDonationExcludedDates', "Invalid Excluded Dates");
		$exDates=array_filter(explode(",",$str));
		$error=0;
		foreach ($exDates as $exDate)
		{
			$valid=$this->CI->general_model->valid_date($exDate);
			if($valid==false)
			{
				return false;
			}
		}
		return true;
	}

	public function checkDonationIncludedDates($str)
	{
		$this->CI->form_validation->set_message('checkDonationIncludedDates', "Invalid Included Dates");
		$inDates=array_filter(explode(",",$str));
		$error=0;
		foreach ($inDates as $inDate)
		{
			$valid=$this->CI->general_model->valid_date($inDate);
			if($valid==false)
			{
				return false;
			}
		}
		return true;
	}

	//To check General Newslater list unique name validation
	public function generalNewslaterListCheck($list,$id)
	{
		$this->CI->form_validation->set_message('generalNewslaterListCheck', 'List already exists');
		$this->CI->load->model('general_newsletters/general_newsletter_lists_model','general_newsletter_lists_model');
		$listID=$id;
		
		$e=$this->CI->general_newsletter_lists_model->listexistCheck($list,$listID);
		if($e==1)//does not exist
		{
			return true;
		}
		else if($e==2)
		{
			$this->CI->form_validation->set_message('generalNewslaterListCheck', 'Invalid List name');
			return false;
		}
		else//exists
		{
			return false;
		}
	}

	//To check General Newslater group unique name validation
	public function generalNewslaterGroupCheck($group,$id)
	{
		$this->CI->form_validation->set_message('generalNewslaterGroupCheck', 'Group already exists');
		$this->CI->load->model('general_newsletters/general_newsletter_groups_model','general_newsletter_groups_model');
		$groupID=$id;
		
		$e=$this->CI->general_newsletter_groups_model->groupexistCheck($group,$groupID);
		if($e==1)//does not exist
		{
			return true;
		}
		else if($e==2)
		{
			$this->CI->form_validation->set_message('generalNewslaterGroupCheck', 'Invalid Group name');
			return false;
		}
		else//exists
		{
			return false;
		}
	}

	//To check PAN (INR) Required for Ashram
	public function checkPanRequiredForInr($val)
	{
		$this->CI->form_validation->set_message('checkPanRequiredForInr', "Invalid value");
		if(in_array($val, array(0,1)))
		{
			return true;
		}
		else
			return false;
	}

	//To check Letter Template Type for Ashram
	public function checkDeclarationType($str)
	{
		$this->CI->form_validation->set_message('checkLetterTemplateType', "Invalid Template Type");
		$templeteTypeArray=array("Donation","Gift");
		if(in_array($str,$templeteTypeArray))
		{
			return true;
		}
		else
			return false;
	}

	//To check Declaration Template is exists or not
	public function checkDeclarationTemplates($str)
	{
		$this->CI->form_validation->set_message('checkDeclarationTemplates', "Invalid Declaration Templates");
		$str = str_replace(".php","",$str);
		foreach (explode(',', $str) as $template)
		{
			if (trim($template) !== '')
			{
				$templatepath=$_SERVER['DOCUMENT_ROOT'].'/application/views/ashrams/admin/gift_donation_templates/'.trim($template).'.php';
				if(!file_exists($templatepath))
				{
					return false;
				}
			}
		}

		return true;
	}

	public function checkAlphaNumericUnderscoreDashOnly($str)
	{
		$this->CI->form_validation->set_message('checkAlphaNumericUnderscoreDashOnly', 'Alphabets, numbers, underscores and dashes are only allowed');
		if(preg_match('/^[a-zA-Z0-9_-]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkPoojaIsOnlyForAdmin($value)
	{
		$this->CI->form_validation->set_message('checkPoojaIsOnlyForAdmin', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	

	public function checkIsSecretPooja($value)
	{
		$this->CI->form_validation->set_message('checkIsSecretPooja', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkPoojaDisplayOnlyPopup($value)
	{
		$this->CI->form_validation->set_message('checkPoojaDisplayOnlyPopup', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkPoojaItemKeyExists($name,$id)
	{
		$this->CI->form_validation->set_message('checkPoojaItemKeyExists', "Item Key already exists");
		$this->CI->load->model("ashrams/poojas_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->poojas_model->checkPoojaItemKeyExists($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkPoojaSecretKeyExists($name,$id)
	{
		$this->CI->form_validation->set_message('checkPoojaSecretKeyExists', "Secret Key already exists");
		$this->CI->load->model("ashrams/poojas_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->poojas_model->checkPoojaSecretKeyExists($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkDonationIsOnlyForAdmin($value)
	{
		$this->CI->form_validation->set_message('checkDonationIsOnlyForAdmin', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	

	public function checkIsSecretDonation($value)
	{
		$this->CI->form_validation->set_message('checkIsSecretDonation', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkDonationDisplayOnlyPopup($value)
	{
		$this->CI->form_validation->set_message('checkDonationDisplayOnlyPopup', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkDonationItemKeyExists($name,$id)
	{
		$this->CI->form_validation->set_message('checkDonationItemKeyExists', "Item Key already exists");
		$this->CI->load->model("ashrams/donations_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->donations_model->checkDonationItemKeyExists($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkDonationSecretKeyExists($name,$id)
	{
		$this->CI->form_validation->set_message('checkDonationSecretKeyExists', "Secret Key already exists");
		$this->CI->load->model("ashrams/donations_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->donations_model->checkDonationSecretKeyExists($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkSubscriptionIsOnlyForAdmin($value)
	{
		$this->CI->form_validation->set_message('checkSubscriptionIsOnlyForAdmin', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	

	public function checkIsSecretSubscription($value)
	{
		$this->CI->form_validation->set_message('checkIsSecretSubscription', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkSubscriptionDisplayOnlyPopup($value)
	{
		$this->CI->form_validation->set_message('checkSubscriptionDisplayOnlyPopup', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkSubscriptionItemKeyExists($name,$id)
	{
		$this->CI->form_validation->set_message('checkSubscriptionItemKeyExists', "Item Key already exists");
		$this->CI->load->model("ashrams/subscriptions_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->subscriptions_model->checkSubscriptionItemKeyExists($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkSubscriptionSecretKeyExists($name,$id)
	{
		$this->CI->form_validation->set_message('checkSubscriptionSecretKeyExists', "Secret Key already exists");
		$this->CI->load->model("ashrams/subscriptions_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->subscriptions_model->checkSubscriptionSecretKeyExists($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkStoreIsOnlyForAdmin($value)
	{
		$this->CI->form_validation->set_message('checkStoreIsOnlyForAdmin', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	

	public function checkIsSecretStore($value)
	{
		$this->CI->form_validation->set_message('checkIsSecretStore', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkStoreDisplayOnlyPopup($value)
	{
		$this->CI->form_validation->set_message('checkStoreDisplayOnlyPopup', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkStoreItemKeyExists($name,$id)
	{
		$this->CI->form_validation->set_message('checkStoreItemKeyExists', "Item Key already exists");
		$this->CI->load->model("ashrams/store_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->store_model->checkStoreItemKeyExists($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkStoreSecretKeyExists($name,$id)
	{
		$this->CI->form_validation->set_message('checkStoreSecretKeyExists', "Secret Key already exists");
		$this->CI->load->model("ashrams/store_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->store_model->checkStoreSecretKeyExists($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkSendPoojasReportMail($str)
	{
		$this->CI->form_validation->set_message('checkSendPoojasReportMail', "Invalid Send Poojas Report Mail");
		$templeteTypeArray=array(0,1);
		if(in_array($str,$templeteTypeArray))
		{
			return true;
		}
		else
			return false;
	}

	public function checkSendDonationsReportMail($str)
	{
		$this->CI->form_validation->set_message('checkSendDonationsReportMail', "Invalid Send Donations Report Mail");
		$templeteTypeArray=array(0,1);
		if(in_array($str,$templeteTypeArray))
		{
			return true;
		}
		else
			return false;
	}

	public function checkSendStoreReportMail($str)
	{
		$this->CI->form_validation->set_message('checkSendStoreReportMail', "Invalid Send Store Report Mail");
		$templeteTypeArray=array(0,1);
		if(in_array($str,$templeteTypeArray))
		{
			return true;
		}
		else
			return false;
	}

	public function checkSendSubscriptionsReportMail($str)
	{
		$this->CI->form_validation->set_message('checkSendSubscriptionsReportMail', "Invalid Send Subscriptions Report Mail");
		$templeteTypeArray=array(0,1);
		if(in_array($str,$templeteTypeArray))
		{
			return true;
		}
		else
			return false;
	}

	public function checkPoojasReportEmails($str)
	{
		$this->CI->form_validation->set_message('checkPoojasReportEmails', 'Invalid Poojas Report Email ID(s)');
		if (strpos($str, ',') === FALSE)
		{
			return $this->valid_email_custom(trim($str));
		}

		foreach (explode(',', $str) as $email)
		{
			if (trim($email) !== '' && $this->valid_email_custom(trim($email)) === FALSE)
			{
				return FALSE;
			}
		}

		return TRUE;
	}

	public function checkDonationsReportEmails($str)
	{
		$this->CI->form_validation->set_message('checkDonationsReportEmails', 'Invalid Donations Report Email ID(s)');
		if (strpos($str, ',') === FALSE)
		{
			return $this->valid_email_custom(trim($str));
		}

		foreach (explode(',', $str) as $email)
		{
			if (trim($email) !== '' && $this->valid_email_custom(trim($email)) === FALSE)
			{
				return FALSE;
			}
		}

		return TRUE;
	}

	public function checkStoreReportEmails($str)
	{
		$this->CI->form_validation->set_message('checkStoreReportEmails', 'Invalid Store Report Email ID(s)');
		if (strpos($str, ',') === FALSE)
		{
			return $this->valid_email_custom(trim($str));
		}

		foreach (explode(',', $str) as $email)
		{
			if (trim($email) !== '' && $this->valid_email_custom(trim($email)) === FALSE)
			{
				return FALSE;
			}
		}

		return TRUE;
	}

	public function checkSubscriptionsReportEmails($str)
	{
		$this->CI->form_validation->set_message('checkSubscriptionsReportEmails', 'Invalid Subscriptions Report Email ID(s)');
		if (strpos($str, ',') === FALSE)
		{
			return $this->valid_email_custom(trim($str));
		}

		foreach (explode(',', $str) as $email)
		{
			if (trim($email) !== '' && $this->valid_email_custom(trim($email)) === FALSE)
			{
				return FALSE;
			}
		}

		return TRUE;
	}

	public function checkAppjiCurrency($str)
	{
		$this->CI->form_validation->set_message('checkAppjiCurrency', "Invalid Currency");
		$c=['USD','INR'];
		if(in_array($str,$c))
			return TRUE;
		else
		{
		  return FALSE;
		}
	}

	public function checkAppjiIsSubscription($str)
	{
		$this->CI->form_validation->set_message('checkAppjiIsSubscription', "Invalid isSubscription");
		$c=['No'];
		if(in_array($str,$c))
			return TRUE;
		else
		{
		  return FALSE;
		}
	}

	public function checkAppjiSubscriptionPeriod($str)
	{
		$this->CI->form_validation->set_message('checkAppjiSubscriptionPeriod', "Invalid Subscription Period");
		$c=['days', 'weeks', 'months', 'years'];
		if(in_array($str,$c))
			return TRUE;
		else
		{
		  return FALSE;
		}
	}

	public function checkIsTimestamp($timestamp)
	{
		$this->CI->form_validation->set_message('checkIsTimestamp', "Invalid Time Stamp");
		if( is_numeric($timestamp) && (strtotime(date('d-m-Y H:i:s',$timestamp)) === (int)$timestamp) )
		{
			return TRUE;
		}
		else 
		{
			return FALSE;
		}
	}

	public function checkAppjiDonationExpiryTimestamp($timestamp)
	{
		$this->CI->form_validation->set_message('checkAppjiDonationExpiryTimestamp', "Invalid Link Expiry Date");
		if( is_numeric($timestamp) && (strtotime(date('d-m-Y H:i:s',$timestamp)) === (int)$timestamp) )
		{
			return TRUE;
		}
		else 
		{
			return FALSE;
		}
	}

	public function checkAppjiSubscriptionExpiryTimestamp($timestamp)
	{
		$this->CI->form_validation->set_message('checkAppjiSubscriptionExpiryTimestamp', "Invalid Link Expiry Date");
		if( is_numeric($timestamp) && (strtotime(date('d-m-Y H:i:s',$timestamp)) === (int)$timestamp) )
		{
			return TRUE;
		}
		else 
		{
			return FALSE;
		}
	}

	/*for checking any phone field value is 'undefined' -- HARSHA*/
	public function undefinedCheckforPhone($value)
	{
		$this->CI->form_validation->set_message('undefinedCheckforPhone', 'Please enter valid Phone number');
		if($value=='undefined')
		{
			return false;
		}
		else
		{
			return true;
		}
	}

	public function checkAppjiLinkType($str)
	{
		$this->CI->form_validation->set_message('checkAppjiLinkType', "Invalid Link Type");
		$c=['donation', 'subscription'];
		if(in_array($str,$c))
			return TRUE;
		else
		{
		  return FALSE;
		}
	}

	public function checkSpecialCharactersName($str)
	{
		$this->CI->form_validation->set_message('checkSpecialCharactersName', 'Allowed characters are [a-z],[A-Z],[0-9],[À-ž] and spaces');
		if(preg_match('/^[a-zA-Z0-9À-ž ]*$/i', $str))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkDonationGroupKeyExists($name,$id)
	{
		$this->CI->form_validation->set_message('checkDonationGroupKeyExists', "Group Key already exists");
		$this->CI->load->model("ashrams/donations_groups_model");
		if(is_numeric($id))
		{
			$flag=$this->CI->donations_groups_model->checkDonationGroupKeyExists($this->CI->general_model->filtertext(trim($name)),$id);
			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkLimitDonationDaysPerItem($val)
	{
		$this->CI->form_validation->set_message('checkLimitDonationDaysPerItem', "Invalid value");
		if(in_array($val, array('All available days','1','2','3','4','5','6','7','8','9','10')))
		{
			return true;
		}
		else
			return false;
	}

	public function checkTrustName($name,$trust_id_and_currency_str)
	{
		$this->CI->form_validation->set_message('checkTrustName', "Trust Name already exists");
		$trust_id_and_currency = explode(' || ', $trust_id_and_currency_str);
		$currency = '';
		$trust_id = '';
		if(isset($trust_id_and_currency[0]))
		{
			$trust_id = $trust_id_and_currency[0];
		}
		if(isset($trust_id_and_currency[1]))
		{
			$currency = $trust_id_and_currency[1];
		}
		if($trust_id == '')
		{
			return false;
		}
		if($currency == '')
		{
			return false;
		}

		$this->CI->load->model("ashrams/ashrams_trust_accounts_model");
		if(is_numeric($trust_id))
		{
			$flag=$this->CI->ashrams_trust_accounts_model->checkTrustBasicName($this->CI->general_model->filtertext(trim($name)),$trust_id,$currency);

			if($flag==1)
				return false;
			else
				return true;
		}
		else
			return false;
	}

	public function checkBasicTrust($id)
	{
		$this->CI->form_validation->set_message('checkBasicTrust', "Trust Basic ID not exists");
		if(is_numeric($id))
		{
			$this->CI->load->model("ashrams/ashrams_trust_accounts_model");
			$flag=$this->CI->ashrams_trust_accounts_model->checkTrustBasicIdExists($id);
			if($flag==1)
				return true;
			else
				return false;
		}
		else
			return false;
	}

	public function checkAshramCenterCategories($category)
	{
		$this->CI->form_validation->set_message('checkAshramCenterCategories', "Invalid Categories");
		$categoriessArray=array("Shodasha Datta Kshetras", "Navanatha Kshetras", "Centers in India", "Centers outside India");
		if($category=='')
			return false;
		if(!in_array($category,$categoriessArray))
			return false;
		return true;
	}

	public function checkGoogleMapLink($str)
	{
		$this->CI->form_validation->set_message('checkGoogleMapLink', "Invalid Google Map Link");
		$pattern = "/^(http|https|ftp):\/\/[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}(:[0-9]{1,5})?(\/.*)?$/i";
        if (!preg_match($pattern, $str))
        {
            return false;
        }
        return true;
	}

	public function checkPoojaHavingCustomEmail($value)
	{
		$this->CI->form_validation->set_message('checkPoojaHavingCustomEmail', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkPoojaHavingCustomSms($value)
	{
		$this->CI->form_validation->set_message('checkPoojaHavingCustomSms', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkDonationHavingCustomEmail($value)
	{
		$this->CI->form_validation->set_message('checkDonationHavingCustomEmail', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkDonationHavingCustomSms($value)
	{
		$this->CI->form_validation->set_message('checkDonationHavingCustomSms', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkSubscriptionHavingCustomEmail($value)
	{
		$this->CI->form_validation->set_message('checkSubscriptionHavingCustomEmail', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkSubscriptionHavingCustomSms($value)
	{
		$this->CI->form_validation->set_message('checkSubscriptionHavingCustomSms', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkStoreItemHavingCustomEmail($value)
	{
		$this->CI->form_validation->set_message('checkStoreItemHavingCustomEmail', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	public function checkStoreItemHavingCustomSms($value)
	{
		$this->CI->form_validation->set_message('checkStoreItemHavingCustomSms', "Invalid value");
		if(in_array($value,array(0,1)))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}

	//Pooja family type check
	public function checkPoojaOnFamilyType($val)
	{
		$this->CI->form_validation->set_message('checkPoojaOnFamilyType', "Invalid value");
		if(in_array($val, array(0,1,2,3,8)))
		{
			return true;
		}
		else
			return false;
	}

	public function checkPoojaOnFamilyMembers($val)
	{
		$this->CI->form_validation->set_message('checkPoojaOnFamilyMembers', "Invalid value");
		if(in_array($val, array("Pooja on All Family Members","Pooja on selected Family Members","Pooja on Sri Swamiji's name","Pooja on Sri Datta Vijayananda Teertha Swamiji's name","Pooja on Friends / Others")))
		{
			return true;
		}
		else
			return false;
	}

	//Donation family type check
	public function checkDonationOnFamilyType($val)
	{
		$this->CI->form_validation->set_message('checkDonationOnFamilyType', "Invalid family type");
		if(in_array($val, array(4,5,6,7,9,13)))
			return true;
		return false;
	}

	public function checkDonationOnFamilyMembers($val)
	{
		$this->CI->form_validation->set_message('checkDonationOnFamilyMembers', "Invalid value");
		if(in_array($val, array("Donation on All Family Members","Donation on selected Family Members","Donation on Sri Swamiji's name","Donation on Sri Datta Vijayananda Teertha Swamiji's name","Donation on Friends / Others", "Donation on Appji Member")))
		{
			return true;
		}
		else
			return false;
	}

	//Subscription family type check
	public function checkSubscriptionOnFamilyType($val)
	{
		$this->CI->form_validation->set_message('checkSubscriptionOnFamilyType', "Invalid family type");
		if(in_array($val, array(10,11,12,14)))
			return true;
		return false;
	}

	public function checkSubscriptionOnFamilyMembers($val)
	{
		$this->CI->form_validation->set_message('checkSubscriptionOnFamilyMembers', "Invalid value");
		if(in_array($val, array("Subscription on selected Family Members","Subscription on Sri Swamiji's name","Subscription on Sri Datta Vijayananda Teertha Swamiji's name", "Subscription on Appji Member")))
		{
			return true;
		}
		else
			return false;
	}

	public function checkSingleUser($val){
		$this->CI->form_validation->set_message('checkSingleUser', "Select Only one family member per seva");
		$allow_user_per_day_seva = $this->CI->input->post('allow_one_user_per_day_per_seva');
		if($allow_user_per_day_seva == 1){
			if($val != 1){
				return false;
			}
		}
		return true;
	}

}
?>