<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Class: Dattaid_api
 * Developer: Baji Shaik
 * Start Date: 17th Feb 2018
 */
class Dattaid_api
{
    protected $CI;
    protected $token;
    public function __construct() 
    {
        $this->CI =& get_instance();
        $this->CI->load->model("sso_auth/datta_id_partner_sites_model");
    }

    public function call($userId) 
    {
        $partner_sites = $this->CI->datta_id_partner_sites_model->getList();

        if(!empty($partner_sites))
        {
            foreach ($partner_sites as $key => $value) 
            {
                $serviceUrl = $value["partner_site_url"] . "/datta_id_api/update_user_profile";
                log_message('error', "**********Start of API Call************");
                log_message('error', $serviceUrl." Time: ".date("Y-m-d H:i:s"));
                
                $headers = [
                    'Authtoken:' . $value['auth_token'],
                ];

                $postdata = [
                    'userId' => $userId,
                    'securetoken' => $value['auth_token']
                ];

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => $serviceUrl,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_TIMEOUT => 120,
                    CURLOPT_REFERER, $value["partner_site_url"],
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => $postdata,
                    CURLOPT_HTTPHEADER => $headers,
                    CURLOPT_FAILONERROR => true
                ));
                if (curl_errno($curl)) 
                {
                    $error_msg = curl_error($curl);
                    log_message('error', print_r($error_msg, TRUE));
                }
                $response = curl_exec($curl);
                log_message('error', print_r($response, TRUE));
                log_message('error', "**********End of API Call");
            }
            return true;
        }
    }
}