<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 *   Class      : Checktoken
 *   For        : Web service to check app Authentication
 *   Comments   : Authentication for App
**/
class Checktoken {

    private $CI;

    public function __construct()
    {
        $this->CI =& get_instance();
        $this->CI->load->library("JWT");
        $this->CI->load->model("Application_clients_model","app_clients");
    }

    /**
     * [authenticate description]
     * @return [type] [description]
     */
    public function authenticate()
    {
        $token = $this->CI->input->get_request_header('AuthToken', TRUE);
        $clientId = $this->CI->input->get_request_header('ClientId', TRUE);
        if(!$token && !$clientId)
        {
            $this->CI->failResponse("UnAuthorized Client!", 401);
            exit;
        }

        $valid = $this->CI->app_clients->checkClient($clientId);
        if($valid['message']=='Fail')
        {
            $this->CI->failResponse("UnAuthorized Client!", 401);
            exit;
        }

        try { 
            $data = $this->CI->jwt->decode($this->CI->input->get_request_header('AuthToken', TRUE), $valid['secret_key']);
            if(empty($data) || $data->client_id!=$clientId)
            {
                $this->CI->failResponse("UnAuthorized Client!", 401);
                exit;
            } 
        } catch (\Exception $e) {
            $this->CI->failResponse("UnAuthorized Client!", 401);
            exit; 
        }
        

    }

    public function generate_token($data, $secretId)
    {
        $data = $this->CI->jwt->encode($data, $secretId);
        $this->CI->successResponse($data);
    }
}
