<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Quicklinks extends REST_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
    }

    /**
    * @api {post} /quicklinks Get Quick Links
    * @apiName List
    * @apiGroup Quick Links
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              {
                "id": "1",
                "title": "Sri Sri Swamiji Page",
                "description": "Sri Sri Swamiji Page",
                "link": "https://dev.dattapeetham.org/sriswamiji"
              }
        }
    *
    * @apiSuccess {Integer} id Unique Identifier
    * @apiSuccess {String} title Title
    * @apiSuccess {String} description Description
    * @apiSuccess {String} link Link
    */
    public function index_post()
    {
        $this->load->model("quick_links_model");
        $list=$this->quick_links_model->listAll();
        foreach ($list as $key => $row)
        {
            if($list[$key]->include_base_url)
                $list[$key]->link=base_url.$list[$key]->link;
            unset($list[$key]->include_base_url);
        }
        $this->response($list, REST_Controller::HTTP_OK);
    }
}
?>