<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}
//use Restserver\Libraries\REST_Controller;
class Poojas extends REST_Controller {
    var $service='cart';
    var $currentUser='';
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        //echo session_id();
        $this->load->model('currencies_model');
        //$this->load->model('oauth_sessions_model');
        $this->load->model('ashrams/poojas_model');
        $this->load->model('ashrams/ashrams_trust_accounts_model');
        //$this->oauth_sessions_model->session_check();

        //echo "<br>".session_id();
        
        /*if($this->session->userdata('id'))
            $this->currentUser=$this->session->userdata("admin_data");
        else
            $this->currentUser=$this->session->userdata("user_data");

        if(!$this->session->userdata("poojasCartAshramId"))
        {
            $this->session->set_userdata("poojasCartAshramId",default_ashram_id);
        }
        if(!$this->session->userdata("poojasCartAshramIdSelection"))
        {
            $this->session->set_userdata("poojasCartAshramIdSelection",default_ashram_id);
        }
        $this->currencies=$this->currencies_model->getByAshram($this->session->userdata("poojasCartAshramIdSelection"));
        if(!$this->session->userdata("defaultCurrency"))
        {
            if(empty($this->currencies))
                $this->session->set_userdata("defaultCurrency",default_currency);
            else
            {
                $currency_keys=array_keys($this->currencies);
                $currency=$this->currencies[$currency_keys[0]];
                $this->session->set_userdata("defaultCurrency",$currency['currency']);
            }
        }
        else
        {
            $currency_valid=0;
            foreach($this->currencies as $temp_currency)
            {
                if($this->session->userdata("defaultCurrency")==$temp_currency['currency'])
                {
                    $currency_valid=1;
                    break;
                }
            }
            if($currency_valid==0)
            {
                $currency_keys=array_keys($this->currencies);
                $currency=$this->currencies[$currency_keys[0]];
                $this->session->set_userdata("defaultCurrency",$currency['currency']);
            }
        }*/
        /*$this->load->library('poojascart');
        $this->load->model('cart_model');
        $this->cart_model->validateCart($this->poojascart);*/

        //$this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
    }

    /**
    * @api {post} /poojas Get Poojas
    * @apiPermission User
    * @apiName List
    * @apiGroup Poojas
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   [
            {
                "id": "430",
                "pooja_name": "Digambara Dattatreya Puja",
                "description": "Digambara Dattatreya Puja",
                "start_date": "25 Jun 2016",
                "end_date": "31 Aug 2017",
                "time_from": "10:30 AM",
                "time_to": "01:00 PM",
                "close_before": "0",
                "image": "https://dev.dattapeetham.org/images/pooja_images/430.jpg",
                "days": "",
                "price_inr": "1008",
                "price_usd": "25",
                "price": "INR 1008",
                "item_status": 1
            }
        ]
    *
    * @apiSuccess {Integer} id  Unique identifier of Pooja
    * @apiSuccess {String} pooja_name Pooja Name
    * @apiSuccess {String} description Description
    * @apiSuccess {String} start_date Start Date in format dd MMM YYYY
    * @apiSuccess {String} end_date End Date in format dd MMM YYYY
    * @apiSuccess {String} time_from From time in format hh:mm A
    * @apiSuccess {String} time_to To time in format hh:mm A
    * @apiSuccess {Integer} close_before Number of minutes to close pooja before the end time
    * @apiSuccess {String} image Pooja Image
    * @apiSuccess {String} Days in a week
    * @apiSuccess {Integer} price_inr Price in INR
    * @apiSuccess {Integer} price_usd Price in USD
    * @apiSuccess {String} price Price with default Currency
    * @apiSuccess {Integer} status Poojas status
    **/

    public function index_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        //if($GLOBALS['site_settings']['poojas']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
        if($GLOBALS['site_settings']['poojas']==0)
        {
            goto end;
        }
        $ashram_id=default_ashram_id;
        if($this->input->post("ashram_id")!='')
        {
            $ashramData=$this->ashrams_model->ashramData($this->input->post("ashram_id"));
            if(!empty($ashramData))
                $ashram_id=$this->input->post("ashram_id");
        }
        $currency=default_currency;
        if($this->input->post("currency")!='')
        {
            $currencies=$this->currencies_model->getByAshram($ashram_id);
            if(isset($currencies[$this->input->post("currency")]))
            {
                $currency=$this->input->post("currency");
            }
        }

        $response['currency']=strtoupper($currency);
        $response['ashram_id']=$ashram_id;
        $poojas=$this->poojas_model->listPublicApi($ashram_id,$currency);

        $poojas_sorted=array();
        foreach ($poojas['categories'] as $key=> $category)
        {
            $poojas_sorted[$key]['category']=$category['category'];
            $poojas_sorted[$key]['poojas']=$poojas['categories_poojas'][$category['id']];
        }

        $response['categories']=$poojas_sorted;
        $response['status']=true;
        //$this->cart_log_model->log("App: Poojas page opened",$ashram_id,1);

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /poojas/add_to_cart/:pooja_id Add pooja to cart
    * @apiDescription
    * Rules:<br>
    * 1. Can add same ashram poojas.<br>
    * 2. Maximum amounts are defined in currencies. Cart total cannot be greater than the specified amount.<br>
    * 3. Admin cannot add items to cart
    * @apiPermission User
    * @apiName Add to cart
    * @apiGroup Poojas
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    **/

    /*public function add_to_cart_post($id=0)
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $response['message']="Sevas are disabled currently";
            goto end;
        }
        if($GLOBALS['site_settings']['poojas']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
        {
            $response['message']="Poojas are disabled";
            goto end;
        }
        if($this->session->userdata("loggedIn"))
        {
            if($this->currentUser->admin==0)
            {
                if($this->currentUser->email_verified==0)
                {
                    $response['message']="Email ID is not verified for User";
                    goto end;
                }
            }
            else
            {
                $response['message']="You are admin! Cannot add items to cart.";
                goto end;
            }
        }
        if($GLOBALS['poojaCartLocked']==1)
        {
            $response['message']="Sorry, cannot add item, a transaction is already in progress";
            goto end;
        }
        if(is_numeric($id) && $id)
        {
            $cart=$this->poojascart->contents();
            $amount=$this->cart_model->getTotalPrice($this->poojascart);
            $poojaData=$this->poojas_model->poojaData($id);
            if(empty($poojaData))
            {
                $response['message']="Invalid pooja ID";
                goto end;
            }

            $data['item']=$poojaData;
            $data['type']='pooja';
            $data['note']='';
            if($this->session->userdata("loggedIn"))
            {
                if($this->currentUser->admin==0)
                {
                    $data['note']=$this->currentUser->family_details;
                }
                else
                {
                    if($this->session->userdata('temp_checkout_user'))
                    {
                        $data['note']=$this->session->userdata('temp_checkout_user')->family_details;
                    }
                }
            }
            
            if(!$this->session->userdata('poojasCartAshramId') || $poojaData->ashram_id==$this->session->userdata('poojasCartAshramId') || count($cart)==0)
            {
                $col="price_".strtolower($this->session->userdata("defaultCurrency"));
                $netAmount=$amount+$poojaData->$col;
                if(strtolower($this->session->userdata("defaultCurrency"))=='inr' && $netAmount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
                {
                    $response['message']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                    goto end;
                }
                if(strtolower($this->session->userdata("defaultCurrency"))=='usd' && $netAmount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
                {
                    $response['message']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                    goto end;
                }

                $r=$this->cart_model->addItem($data,1,$this->poojascart);
                $flag=$r['flag'];
                if($flag==-2)
                {
                    $this->logaction->log($this->service,"Pooja added to cart _ Pooja ID:".$id." _ ".$poojaData->pooja_name." _ Row ID: ".$r['rowid']);
                    
                    $this->cart_log_model->log("App: Item added - Name:".$poojaData->pooja_name.", Price:".strtoupper($this->session->userdata("defaultCurrency"))." ".$poojaData->$col,$this->session->userdata("poojasCartAshramId"),1);

                    $response['status']=true;
                    $this->session->set_userdata('poojasCartAshramId',$poojaData->ashram_id);
                }
                else
                {
                    $response['message']="Invalid request";
                }
            }
            else
            {
                $this->load->model('ashrams/ashrams_model');
                $ashramData=$this->ashrams_model->ashramData($this->session->userdata('poojasCartAshramId'));
                $response['message']="You can add poojas from ".$ashramData->name." only. If you want to add items from other ashram, delete the items and then add again.";
            }
        }

        $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /**
    * @api {post} /poojas/update_family_details/:row_id Update family details
    * @apiPermission User
    * @apiName Update family details
    * @apiGroup Poojas
    * @apiParam [String] family_details Family Details<br>
                                        Minlength:6<br>
                                        Maxlength:500
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    **/

    /*public function update_family_details_post($key='')
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($GLOBALS['poojaCartLocked']==1)
        {
            $response['message']="Sorry, cannot add item, a transaction is already in progress";
            goto end;
        }
        if($key=='')
        {
            $response['message']="Invalid Row ID";
            goto end;
        }
        $item=$this->poojascart->get_item($key);
        $options=$this->poojascart->product_options($key);
        if(empty($options))
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        if(!isset($_POST['value']))
        {
            $response['message']="Family Details field is required";
            goto end;
        }

        $this->form_validation->set_rules('value', 'Family Details', 'trim|min_length[6]|max_length[500]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }
        
        $options['note']=$_POST['value'];
        $updateArray= array(
                   'rowid' => $key,
                       'options'   => $options
                    );

        foreach ($options as $key => $val)
        {
            $temp[$key] = $val;
        }
        $this->cart_log_model->log("App: Family details updated - Name:".$item['name'],$this->session->userdata("poojasCartAshramId"),1);
        $this->poojascart->update($updateArray);
        $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
        $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /**
    * @api {post} /poojas/dates_validate/:row_id Validate and save dates
    * @apiPermission User
    * @apiName Validate Dates
    * @apiGroup Poojas
    * @apiParam {String} selected_dates User selected dates comma separated in format dd MMM YYYY 
    * @apiParam {Boolean} [save] If this is passed, dates are saved to cart else only returns valid dates  
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true",
            "dates": [
                "09 Apr 2017 (Sunday)",
                "10 Apr 2017 (Monday)"
              ]
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Array} dates Array of resulting dates
    **/

    /*public function dates_validate_post($key='')
    {
        $row_id=$key;
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($GLOBALS['poojaCartLocked']==1)
        {
            $response['message']="Sorry, cannot add item, a transaction is already in progress";
            goto end;
        }

        if($row_id=='')
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        $item_data=$this->poojascart->get_item($row_id);
        if(empty($item_data))
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        if(!isset($_POST['selected_dates']))
        {
            $response['message']="Selected dates field required";
            goto end;
        }

        if($_POST['selected_dates']=='')
        {
            $response['message']="Selected dates field is empty";
            goto end;
        }

        $poojaData=$this->poojas_model->poojaData($item_data['id']);
        if(!empty($poojaData) && $poojaData->status==1)
        {
            $dates_set=$this->cart_model->getPoojaValidDates($poojaData);
            $final=array();
            if($_POST['selected_dates']!='')
                $selected=explode(",",$_POST['selected_dates']);
            else
                $selected=array();
            
            if(!empty($selected))
            foreach($selected as $pdate)
            {
                if(in_array($pdate,$dates_set))
                $final[]=$pdate;
            }
            
            foreach($final as $key=>$tms)
            {
                $final[$key]=strtotime($tms);
            }
            
            asort($final);
            
            $store_array=array();
            
            $cnt=0;
            $first='';
            
            
            foreach($final as $key=>$tms)
            {
                if($cnt==0)
                $first=date("d M Y",$tms);
                
                $final[$key]=date("d M Y (D)",$tms);
                $store_array[]=date("d M Y",$tms);
                $cnt++;
            }
            
            if(isset($_POST['save']) && $_POST['save']==1)
            {
                $options=$item_data['options'];
                $options['result_date']=implode(",",$store_array);
                $options['user_date']=$first;
                $upd= array(
                         'rowid' => $row_id,
                         'options'   => $options,
                         'qty'=>$cnt
                         );

                //$this->logaction->log_action("Pooja dates updated _ Row ID: ".$_POST['cartid'],"Order");
                $this->poojascart->update($upd);
                $this->cart_log_model->log("App: Dates changed - Name:".$poojaData->pooja_name,$this->session->userdata("poojasCartAshramId"),1);
                $this->cart_model->validateCart($this->poojascart);
                $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
            }
            $response['status']=true;
            $response['dates']=$final;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/


    /**
    * @api {post} /poojas/remove_from_cart/:row_id Remove pooja from cart
    * @apiPermission User
    * @apiName Remove from cart
    * @apiGroup Poojas
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true",
            "cart_count": 1
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Integer} cart_count Number of items remaining in cart. Set only if status is true
    **/

    /*public function remove_from_cart_post($key='')
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['poojaCartLocked']==1)
        {
            $response['message']="Cannot remove item, a transaction is already in progress";
            goto end;
        }
        if(isset($key) && $key!='')
        {
            $item=$this->poojascart->get_item($key);
            if(!empty($item))
            {
                $upd= array(
                           'rowid' => $key,
                            'qty'   => 0
                            );
                $this->poojascart->update($upd);
                $this->logaction->log($this->service,"Pooja removed from cart _ Pooja ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
                $cc=$this->poojascart->contents();
                $this->cart_log_model->log("App: Item removed - Name:".$item['name'],$this->session->userdata("poojasCartAshramId"),1);
                if(count($cc)==0)
                {
                    $this->session->unset_userdata('poojasCartAshramId');
                }
                $response['status']=true;
                $response['cart_count']=count($cc);
                $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
            }
            else
            {
                //$result['flag']=2;
                $response['message']="Invalid request";
            }
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /**
    * @api {post} /poojas/get_cart Poojas cart
    * @apiPermission User
    * @apiName Cart
    * @apiGroup Poojas
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "7cbb43d3185e4e822ba1ecbc35612b22":
            {
                "id": "430",
                "qty": 1,
                "price": 10,
                "name": "Digambara Dattatreya Puja",
                "options": {
                    "checksum": "060c341cb3c23793ffca39a249494fe2",
                    "type": "pooja",
                    "note": "First name\r\nGothram\r\nNakshatram",
                    "ashram_id": "4",
                    "description": "Digambara Dattatreya Puja",
                    "start_date": "2016-06-25",
                    "end_date": "2017-08-31",
                    "time_from": "10:30:00",
                    "time_to": "13:00:00",
                    "close_before": "0",
                    "first_date": "31 Mar 2017",
                    "user_date": "31 Mar 2017",
                    "status": 1,
                    "result_date": "31 Mar 2017",
                    "price_inr": "1008",
                    "price_usd": "25"
                },
                "rowid": "7cbb43d3185e4e822ba1ecbc35612b22",
                "subtotal": 10
            }
        }
    *
    * @apiSuccess {Object} row_id Cart item object, row id will be the key
    * @apiSuccess {Integer} row_id.id Unique identifier of Pooja
    * @apiSuccess {Integer} row_id.qty Quantity
    * @apiSuccess {Integer} row_id.price Price (IGNORE)
    * @apiSuccess {String} row_id.name Pooja name
    * @apiSuccess {Object} row_id.options Pooja item options object
    * @apiSuccess {String} row_id.options.checksum Checksum value for current cart item
    * @apiSuccess {String} row_id.options.type=pooja Item type
    * @apiSuccess {String} row_id.options.note Family details
    * @apiSuccess {String} row_id.options.ashram_id Unique identifier of Ashram to which pooja belong
    * @apiSuccess {String} row_id.options.description Description of pooja
    * @apiSuccess {String} row_id.options.start_date Start date in format yyyy-mm-dd
    * @apiSuccess {String} row_id.options.end_date End date in format yyyy-mm-dd
    * @apiSuccess {String} row_id.options.time_from From time in format HH:mm:ss
    * @apiSuccess {String} row_id.options.time_to To time in format HH:mm:ss
    * @apiSuccess {String} row_id.options.close_before Number of minutes from end time before the pooja booking will be closed
    * @apiSuccess {String} row_id.options.first_date First occurance date of current pooja in format dd MMM YYYY
    * @apiSuccess {String} row_id.options.user_date First occurance date of current pooja in format dd MMM YYYY based on user selection
    * @apiSuccess {String} row_id.options.status Status of pooja in cart (To checkout, all items must have status=1)
    * @apiSuccess {String} row_id.options.result_date List of result dates separated with comma
    * @apiSuccess {String} row_id.options.price_inr Price in INR
    * @apiSuccess {String} row_id.options.price_usd Price in USD
    * @apiSuccess {String} row_id.rowid Row id of item in cart
    * @apiSuccess {String} row_id.subtotal Subtotal of items (IGNORE)
    **/
    /*public function get_cart_post()
    {
        $list['currency']=strtoupper($this->session->userdata("defaultCurrency"));
        $this->load->model("credit_cards_model");
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("poojasCartAshramId"),1);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        if($this->session->userdata("defaultCurrency")=='inr' && !empty($trustsArray))
        {
            $list['trust_data']=$trustsArray['inr'];
        }
        if($this->session->userdata("defaultCurrency")=='usd' && !empty($trustsArray))
        {
            $list['trust_data']=$trustsArray['usd'];
        }
        $credit_cards=$this->credit_cards_model->getCards($this->currentUser->id);
        foreach ($credit_cards as $key => $credit_card)
        {
            unset($credit_cards[$key]->user_id);
            unset($credit_cards[$key]->payflow_pnref);
            unset($credit_cards[$key]->created_on);
            unset($credit_cards[$key]->modified_on);
            $credit_cards[$key]->card_expiry_month=substr($credit_cards[$key]->card_expiry,0,2);
            $credit_cards[$key]->card_expiry_year=substr($credit_cards[$key]->card_expiry,-2);
        }
        $list['credit_cards']=$credit_cards;
        $list['ip_address']=$_SERVER["REMOTE_ADDR"];
        $list['session']=session_id();
        $list['cart']=$this->poojascart->contents();
        $this->response($list, REST_Controller::HTTP_OK);
        //$this->set_response($this->poojascart->contents(), REST_Controller::HTTP_OK);
    }*/

    /*public function get_cart_item_post($key='')
    {
        if($key=='')
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        $options=$this->poojascart->product_options($key);
        if(empty($options))
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        $item=$this->poojascart->get_item($key);
        $pooja=$this->poojas_model->poojaData($item['id']);
        $pooja->time_from=date("h:i A",strtotime($pooja->time_from));
        $pooja->time_to=date("h:i A",strtotime($pooja->time_to));

        $response['status']=true;
        $response['item']=$item;
        $response['pooja']=$pooja;
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /*public function checkout_notify_post($tab_index=0)
    {
        if($tab_index!=null && in_array($tab_index,array(0,1,2)))
        {
            $data='';
            if($tab_index==2)
            {
                $countryData=$this->locations_model->getCountryByCode($this->input->post("country"));
                $data="<br>Data:<br>".$this->input->post("firstname")." ".$this->input->post("lastname")."<br>".
                    $this->input->post("city").", ".$this->input->post("state").", ".$this->input->post("country")."<br>".
                    "+".$countryData->isd_code." ".$this->input->post("phone")."<br>".
                    $this->input->post("email");
            }
            if($tab_index==0)
                $this->cart_log_model->log("App: Checkout page opened",$this->session->userdata("poojasCartAshramId"),1);
            else
                $this->cart_log_model->log("App: Checkout - navigated to tab ".($tab_index+1).$data,$this->session->userdata("poojasCartAshramId"),1);
        }
    }*/

    /**
    * @api {post} /poojas/pay Make Payment
    * @apiPermission User
    * @apiName Pay
    * @apiGroup Poojas
    * @apiParam {String=a-z,A-Z,spaces} firstname First Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam {String=a-z,A-Z,spaces} lastname Last Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam email Email ID<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:100
    * @apiParam phone Phone Number<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:10<br>
     *                            Digits only
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} address1 Address line 1<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} address2 Address line 2<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} address3 Address line 3<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} state State Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:100
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} city City<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:100
    * @apiParam {String='[a-z]','[A-Z]','[0-9]'} zipcode ZIP/PIN Code<br>
                                    Minlength\:3<br>
    *                               Maxlength\:15
    * @apiParam {String} country Country Code
    * @apiParam {String} donation_initials Donation Initials<br>
                                    Minlength\:3<br>
    *                               Maxlength\:25
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status":true,
            "payment_status": 1,
            "order_id":100
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Integer} payment_status 1 if success otherwise 0 (Set only for USD/Paypal)
    * @apiSuccess {Integer} order_id Seva ID (Set only for USD/Paypal)
    * @apiSuccess {Integer} payment_status 1 if success otherwise 0 (Set only for USD/Paypal)
    * @apiSuccess {String} redirect_to URL to redirect to (Set only for INR/PayU)
    * @apiSuccess {Integer} time_exceed 1 Sets only when transaction is already in process and initiated more than 5 minutes ago 
    *
    */
    /*public function pay_post()
    {
        //Check site settings
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $response['message']='Sevas are disabled.';
            goto end;
        }

        if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
        {
            if($this->currentUser->email_verified==0)
            {
                $response['message']='Email ID not verified.';
                goto end;
            }   
        }

        //Get cart DB record
        if($GLOBALS['poojaCartLocked']==1)
        {
            $startedOn=strtotime($GLOBALS['poojaCartStartedOn']." +5 Minutes");
            if(time()>=$startedOn)
            {
                $response['time_exceed']=1;
            }
            //$response['flag']=5;
            $response['message']='Transaction already in progress.';
            goto end;
        }

        //Validate form data
        if(!isset($_POST["firstname"]) || !isset($_POST["lastname"]) ||
                !isset($_POST["preferred_name"]) ||
                !isset($_POST["email"]) || !isset($_POST["phone"]) ||
                !isset($_POST["address1"]) || !isset($_POST["address2"]) || !isset($_POST["address3"]) ||
                !isset($_POST["city"]) || !isset($_POST["state"]) || !isset($_POST["country"]) ||
                !isset($_POST["donation_initials"]))
        {
            $response['message']='Some parameters are missing.';
            goto end;
        }

        if($this->session->userdata("defaultCurrency")=='usd')
        {
            if(!isset($_POST["credit_card_id"]))
            {
                $response['message']='Some parameters are missing.';
                goto end;
            }
        }

        $this->form_validation->set_rules('firstname', 'First Name','trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('lastname', 'Last Name','trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('preferred_name', 'Preferred Name','trim|required|min_length[2]|max_length[50]');
        $this->form_validation->set_rules('email', 'Email ID','trim|required|valid_email_custom|min_length[6]|max_length[100]');
        $this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
        //$this->form_validation->set_rules('phone2', 'Phone Number 2','trim|min_length[10]|max_length[100]');
        $this->form_validation->set_rules('address1', 'Address Line 1','trim|required|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
        $this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
        $this->form_validation->set_rules('country', 'Country','trim|required|checkoutCountry['.$this->session->userdata("defaultCurrency").']');
        $this->form_validation->set_rules('zipcode', 'ZIP Code','trim|required|alphabetsnumbers|min_length[3]|max_length[15]');
        $this->form_validation->set_rules('donation_initials', 'Initials','trim|required|min_length[3]|max_length[25]');

        if($this->session->userdata("defaultCurrency")=='usd')
        {
            if($_POST["credit_card_id"]=='')
            {
                $this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
                $this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
                $this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
                $this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
            }
            else
            {
                $this->form_validation->set_rules('credit_card_id', 'Save Card ID','trim|required|numeric|max_length[20]');
            }
        }

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        //Validate Cart items
        $this->cart_model->validateCart($this->poojascart);

        //Check cart items count
        $cartContents=$this->poojascart->contents();
        if(empty($cartContents)) //If cart is empty
        {
            $response['message']='Cart is empty';
            goto end;
        }

        $totalItems=count($cartContents);
        $validItems=0;
        foreach ($cartContents as $cartItem)
        {
            if($cartItem['options']['status']==1)
            {
                $validItems++;
            }
        }

        //Check all items in cart are valid
        if($validItems!=$totalItems)
        {
            $response['message']='Some cart items are not valid.';
            goto end;
        }

        //Capture User ID
        $userId=0;

        if($this->session->userdata("loggedIn"))
        {
            if($this->currentUser->admin==1)
            {
                if($this->session->userdata('temp_checkout_user'))
                {
                    $tData=$this->session->userdata('temp_checkout_user');
                    $userId=$tData->id;
                }
            }
            else
            {
                $userId=$this->currentUser->id;
            }
        }

        //Get trust accounts for Ashram and Currency defined
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("poojasCartAshramId"),1);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }

        $amount=$this->cart_model->getTotalPrice($this->poojascart);

        //Decide trust based on Currency
        if($this->session->userdata("defaultCurrency")=='inr')
        {
            $customData['trustData']=$trustsArray['inr'];
            if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
            {
                $response['error_msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                goto end;
            }
        }
        if($this->session->userdata("defaultCurrency")=='usd')
        {
            $customData['trustData']=$trustsArray['usd'];
            if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
            {
                //$response['flag']=10;
                $response['error_msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                goto end;
            }
        }

        $this->load->model('ashrams/ashrams_model');


        //Define custom data before initializing transaction
        $created_by_user_id=0;
        $created_by=0;
        $userData=array();
        if($this->session->userdata('id'))
        {
            if($this->session->userdata('temp_checkout_user'))
            {
                $userData=$this->session->userdata('temp_checkout_user');
                $userId=$userData->id;
            }
            $created_by=1;
        }
        else if($this->session->userdata('user_id'))
        {
            $userId=$this->session->userdata('user_id');
            $userData=$this->currentUser;
            $created_by=2;
        }

        if($this->session->userdata("defaultCurrency")=='usd')
        {
            $creditCardData=array();
            if($_POST["credit_card_id"]!='')
            {
                $this->load->model("credit_cards_model");
                $creditCardData=$this->credit_cards_model->getCard($_POST['credit_card_id']);
                if(empty($creditCardData))
                {
                    goto end;
                }
                if($creditCardData->user_id!=$userId)
                {
                    goto end;
                }
            }
        }

        $this->cart_log_model->log("App: Payment initiated",$this->session->userdata("poojasCartAshramId"),1);

        $paymentMode=$customData['trustData']->payment_mode;
        if($this->session->userdata('loggedIn'))
            $created_by_user_id=$this->currentUser->id;

        $customData['cartData']=$cartContents;
        $customData['formData']=$_POST;
        $customData['formData']['app']=1;
        $customData['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("poojasCartAshramId"));
        $customData['cart_type']=1;
        $customData['paymentMode']=$paymentMode;
        $customData['created_by']=$created_by;
        $customData['created_by_user_id']=$created_by_user_id;
        $customData['model']="orders/orders_model";
        $customData['model_name']="orders_model";
        $customData['ip_address']=$_SERVER['REMOTE_ADDR'];
        
        $customData['amount_in_words']=$this->general_model->amountToWords($amount);
        //Load payment model
        $this->load->model("payment_model");
        $reference=$this->payment_model->setTempInfo(
            $userId,
            $userData,
            $amount,
            base_url."poojas/",
            base_url."poojas/checkout/",
            $customData,
            $this->session->userdata("defaultCurrency")
            );
        //$response['flag']=1;
        $response['status']=true;
        $response['reference']=$reference;
        $this->cart_model->updateReferenceId($reference,1);

        $response['payment_mode']=$paymentMode;
        if($this->session->userdata("defaultCurrency")=='usd')
        {
            $response['currency']="USD";
            if($paymentMode=='paypal')
            {
                $this->load->model("paypal_model");
                $paypalResponse=$this->paypal_model->processOneTimePayment($reference,$creditCardData);
                if($paypalResponse['flag']==1)
                {
                    $response['order_id']=$paypalResponse['order_id'];
                    $response['payment_status']=1;
                    $this->cart_log_model->log("App: Payment success:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
                }
                else
                {
                    $response['payment_status']=0;
                    $response['message']=$paypalResponse['error_msg'];
                    $this->cart_model->updateReferenceId('',1);
                    $this->cart_log_model->log("App: Payment failure:".$paymentMode.", Reason:".$paypalResponse['error_msg'],$this->session->userdata("poojasCartAshramId"),1);
                }
            }
            if($paymentMode=='razorpay')
            {
                $response['amount']=$amount*100;
                $response['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $response['prefill_email']=$this->input->post("email");
                $response['prefill_contact']=$this->input->post("phone");
            }
        }
        else
        {
            $response['currency']="INR";
            if($paymentMode=='payu')
            {
                $response['redirect_to']=base_url.'payment/direct/'.$reference."?app=1&type=1";
                $this->cart_log_model->log("App: Redirected to payment gateway:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
            }
            if($paymentMode=='razorpay')
            {
                $response['amount']=$amount*100;
                $response['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $response['prefill_email']=$this->input->post("email");
                $response['prefill_contact']=$this->input->post("phone");
                $response['key']=$customData['trustData']->razorpay_key;
            }
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /**
    * @api {post} /poojas/cancel_previous Cancel previous transaction
    * @apiPermission User
    * @apiName Cancel transaction
    * @apiGroup Poojas
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status":true
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    *
    */
   
    /*public function cancel_previous_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($GLOBALS['poojaCartLocked']==1)
        {
            $startedOn=strtotime($GLOBALS['poojaCartStartedOn']." +5 Minutes");
            if(time()>=$startedOn)
            {
                $this->cart_model->regenerateSession(1);
                $this->oauth_sessions_model->update_session_id($this->server->access_token,session_id());
                $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
                $response['status']=true;
            }
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/
}
?>
